/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.univocity.parsers.csv.CsvParser;
import java.io.Serializable;
import java.util.Locale;
import java.util.Properties;
import org.apache.spark.Partition;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.FailureSafeParser;
import org.apache.spark.sql.execution.datasources.csv.CSVDataSource$;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions$;
import org.apache.spark.sql.execution.datasources.csv.CSVUtils$;
import org.apache.spark.sql.execution.datasources.csv.TextInputCSVDataSource$;
import org.apache.spark.sql.execution.datasources.csv.UnivocityParser;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCPartition;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation$;
import org.apache.spark.sql.execution.datasources.json.TextInputJsonDataSource$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.sources.v2.DataSourceV2;
import org.apache.spark.sql.sources.v2.ReadSupport;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@InterfaceStability.Stable
@ScalaSignature(bytes="\u0006\u0001\tee\u0001\u0002\u00180\u0001aB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\u0007\u0015\u0002!\taL&\t\u000b9\u0003A\u0011A(\t\u000bu\u0003A\u0011\u00010\t\u000bu\u0003A\u0011\u00014\t\u000b%\u0004A\u0011\u00016\t\u000b%\u0004A\u0011A8\t\u000b%\u0004A\u0011A;\t\u000b%\u0004A\u0011A>\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006!9\u00111\u0001\u0001\u0005\u0002\u0005U\u0001bBA\u0014\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003O\u0001A\u0011AA\u001d\u0011\u001d\t9\u0003\u0001C\u0001\u0003\u007fAq!!\u0017\u0001\t\u0013\tY\u0006C\u0004\u0002`\u0001!\t!!\u0019\t\u000f\u0005}\u0003\u0001\"\u0001\u0002v!9\u0011q\f\u0001\u0005\u0002\u0005U\u0005bBAT\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0003O\u0003A\u0011AAW\u0011\u001d\t9\u000b\u0001C\u0001\u0003gCq!a*\u0001\t\u0003\t9\u000eC\u0004\u0002(\u0002!\t!!;\t\u000f\u0005U\b\u0001\"\u0001\u0002x\"9\u0011Q\u001f\u0001\u0005\u0002\u0005m\bbBA{\u0001\u0011\u0005!\u0011\u0001\u0005\b\u0005\u000f\u0001A\u0011\u0001B\u0005\u0011\u001d\u00119\u0001\u0001C\u0001\u0005\u001bAqAa\u0005\u0001\t\u0003\u0011)\u0002C\u0004\u0003\u0014\u0001!\tA!\u0007\t\u000f\u0005%\u0004\u0001\"\u0001\u0003 !9!Q\u0005\u0001\u0005\u0002\t\u001d\u0002b\u0002B\u0013\u0001\u0011\u0005!1\u0006\u0005\b\u0005c\u0001A\u0011\u0001B\u001a\u0011\u001d\u0011\t\u0004\u0001C\u0001\u0005oAqA!\u0010\u0001\t\u0013\u0011y\u0004C\u0004\u0003L\u0001!IA!\u0014\t\u0011E\u0003\u0001\u0019!C\u0005\u0005+B\u0011Ba\u0016\u0001\u0001\u0004%IA!\u0017\t\u000f\t}\u0003\u0001)Q\u0005%\"I!\u0011\r\u0001A\u0002\u0013%!1\r\u0005\n\u0005W\u0002\u0001\u0019!C\u0005\u0005[B\u0001B!\u001d\u0001A\u0003&!Q\r\u0005\n\u0005g\u0002!\u0019!C\u0005\u0005kB\u0001Ba!\u0001A\u0003%!q\u000f\u0002\u0010\t\u0006$\u0018M\u0012:b[\u0016\u0014V-\u00193fe*\u0011\u0001'M\u0001\u0004gFd'B\u0001\u001a4\u0003\u0015\u0019\b/\u0019:l\u0015\t!T'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!O \u0011\u0005ijT\"A\u001e\u000b\u0003q\nQa]2bY\u0006L!AP\u001e\u0003\r\u0005s\u0017PU3g!\t\u00015)D\u0001B\u0015\t\u0011\u0015'\u0001\u0005j]R,'O\\1m\u0013\t!\u0015IA\u0004M_\u001e<\u0017N\\4\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005\u001dCU\"A\u0018\n\u0005%{#\u0001D*qCJ\\7+Z:tS>t\u0017A\u0002\u001fj]&$h\b\u0006\u0002M\u001bB\u0011q\t\u0001\u0005\u0006\u000b\n\u0001\rAR\u0001\u0007M>\u0014X.\u0019;\u0015\u00051\u0003\u0006\"B)\u0004\u0001\u0004\u0011\u0016AB:pkJ\u001cW\r\u0005\u0002T5:\u0011A\u000b\u0017\t\u0003+nj\u0011A\u0016\u0006\u0003/^\na\u0001\u0010:p_Rt\u0014BA-<\u0003\u0019\u0001&/\u001a3fM&\u00111\f\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005e[\u0014AB:dQ\u0016l\u0017\r\u0006\u0002M?\")Q\f\u0002a\u0001AB\u0011\u0011\rZ\u0007\u0002E*\u00111mL\u0001\u0006if\u0004Xm]\u0005\u0003K\n\u0014!b\u0015;sk\u000e$H+\u001f9f)\tau\rC\u0003i\u000b\u0001\u0007!+\u0001\u0007tG\",W.Y*ue&tw-\u0001\u0004paRLwN\u001c\u000b\u0004\u0019.l\u0007\"\u00027\u0007\u0001\u0004\u0011\u0016aA6fs\")aN\u0002a\u0001%\u0006)a/\u00197vKR\u0019A\n]9\t\u000b1<\u0001\u0019\u0001*\t\u000b9<\u0001\u0019\u0001:\u0011\u0005i\u001a\u0018B\u0001;<\u0005\u001d\u0011un\u001c7fC:$2\u0001\u0014<x\u0011\u0015a\u0007\u00021\u0001S\u0011\u0015q\u0007\u00021\u0001y!\tQ\u00140\u0003\u0002{w\t!Aj\u001c8h)\raE0 \u0005\u0006Y&\u0001\rA\u0015\u0005\u0006]&\u0001\rA \t\u0003u}L1!!\u0001<\u0005\u0019!u.\u001e2mK\u00069q\u000e\u001d;j_:\u001cHc\u0001'\u0002\b!9\u00111\u0001\u0006A\u0002\u0005%\u0001CBA\u0006\u0003#\u0011&+\u0004\u0002\u0002\u000e)\u0019\u0011qB\u001e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0014\u00055!aA'baR\u0019A*a\u0006\t\u000f\u0005\r1\u00021\u0001\u0002\u001aA1\u00111DA\u0013%Jk!!!\b\u000b\t\u0005}\u0011\u0011E\u0001\u0005kRLGN\u0003\u0002\u0002$\u0005!!.\u0019<b\u0013\u0011\t\u0019\"!\b\u0002\t1|\u0017\r\u001a\u000b\u0003\u0003W\u0001B!!\f\u000249\u0019q)a\f\n\u0007\u0005Er&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005U\u0012q\u0007\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T1!!\r0)\u0011\tY#a\u000f\t\r\u0005uR\u00021\u0001S\u0003\u0011\u0001\u0018\r\u001e5\u0015\t\u0005-\u0012\u0011\t\u0005\b\u0003\u0007r\u0001\u0019AA#\u0003\u0015\u0001\u0018\r\u001e5t!\u0011Q\u0014q\t*\n\u0007\u0005%3H\u0001\u0006=e\u0016\u0004X-\u0019;fIzB3ADA'!\u0011\ty%!\u0016\u000e\u0005\u0005E#bAA*w\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0013\u0011\u000b\u0002\bm\u0006\u0014\u0018M]4t\u00031aw.\u00193WcM{WO]2f)\u0011\tY#!\u0018\t\u000f\u0005\rs\u00021\u0001\u0002F\u0005!!\u000e\u001a2d)!\tY#a\u0019\u0002h\u0005-\u0004BBA3!\u0001\u0007!+A\u0002ve2Da!!\u001b\u0011\u0001\u0004\u0011\u0016!\u0002;bE2,\u0007bBA7!\u0001\u0007\u0011qN\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\b\u0003BA\u000e\u0003cJA!a\u001d\u0002\u001e\tQ\u0001K]8qKJ$\u0018.Z:\u0015!\u0005-\u0012qOA=\u0003w\ny(a!\u0002\b\u0006E\u0005BBA3#\u0001\u0007!\u000b\u0003\u0004\u0002jE\u0001\rA\u0015\u0005\u0007\u0003{\n\u0002\u0019\u0001*\u0002\u0015\r|G.^7o\u001d\u0006lW\r\u0003\u0004\u0002\u0002F\u0001\r\u0001_\u0001\u000bY><XM\u001d\"pk:$\u0007BBAC#\u0001\u0007\u00010\u0001\u0006vaB,'OQ8v]\u0012Dq!!#\u0012\u0001\u0004\tY)A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\t\u0004u\u00055\u0015bAAHw\t\u0019\u0011J\u001c;\t\u000f\u0005M\u0015\u00031\u0001\u0002p\u0005!2m\u001c8oK\u000e$\u0018n\u001c8Qe>\u0004XM\u001d;jKN$\"\"a\u000b\u0002\u0018\u0006e\u00151TAS\u0011\u0019\t)G\u0005a\u0001%\"1\u0011\u0011\u000e\nA\u0002ICq!!(\u0013\u0001\u0004\ty*\u0001\u0006qe\u0016$\u0017nY1uKN\u0004BAOAQ%&\u0019\u00111U\u001e\u0003\u000b\u0005\u0013(/Y=\t\u000f\u0005M%\u00031\u0001\u0002p\u0005!!n]8o)\u0011\tY#a+\t\r\u0005u2\u00031\u0001S)\u0011\tY#a,\t\u000f\u0005\rC\u00031\u0001\u0002F!\u001aA#!\u0014\u0015\t\u0005-\u0012Q\u0017\u0005\b\u0003o+\u0002\u0019AA]\u0003\u001dQ7o\u001c8S\t\u0012\u0003R!a/\u0002DJk!!!0\u000b\t\u0005\r\u0012q\u0018\u0006\u0004\u0003\u0003\f\u0014aA1qS&!\u0011QYA_\u0005\u001dQ\u0015M^1S\t\u0012Cs!FAe\u0003\u001f\f\u0019\u000eE\u0002;\u0003\u0017L1!!4<\u0005)!W\r\u001d:fG\u0006$X\rZ\u0011\u0003\u0003#\f!%V:fA)\u001cxN\u001c\u0015ECR\f7/\u001a;\\'R\u0014\u0018N\\4^S\u0001Jgn\u001d;fC\u0012t\u0013EAAk\u0003\u0015\u0011dF\r\u00181)\u0011\tY#!7\t\u000f\u0005]f\u00031\u0001\u0002\\B)\u0011Q\\Ar%6\u0011\u0011q\u001c\u0006\u0004\u0003C\f\u0014a\u0001:eI&!\u0011Q]Ap\u0005\r\u0011F\t\u0012\u0015\b-\u0005%\u0017qZAj)\u0011\tY#a;\t\u000f\u00055x\u00031\u0001\u0002p\u0006Y!n]8o\t\u0006$\u0018m]3u!\u00119\u0015\u0011\u001f*\n\u0007\u0005MxFA\u0004ECR\f7/\u001a;\u0002\u0007\r\u001ch\u000f\u0006\u0003\u0002,\u0005e\bBBA\u001f1\u0001\u0007!\u000b\u0006\u0003\u0002,\u0005u\bbBA\u00003\u0001\u0007\u0011q^\u0001\u000bGN4H)\u0019;bg\u0016$H\u0003BA\u0016\u0005\u0007Aq!a\u0011\u001b\u0001\u0004\t)\u0005K\u0002\u001b\u0003\u001b\nq\u0001]1scV,G\u000f\u0006\u0003\u0002,\t-\u0001BBA\u001f7\u0001\u0007!\u000b\u0006\u0003\u0002,\t=\u0001bBA\"9\u0001\u0007\u0011Q\t\u0015\u00049\u00055\u0013aA8sGR!\u00111\u0006B\f\u0011\u0019\ti$\ba\u0001%R!\u00111\u0006B\u000e\u0011\u001d\t\u0019E\ba\u0001\u0003\u000bB3AHA')\u0011\tYC!\t\t\r\t\rr\u00041\u0001S\u0003%!\u0018M\u00197f\u001d\u0006lW-\u0001\u0003uKb$H\u0003BA\u0016\u0005SAa!!\u0010!\u0001\u0004\u0011F\u0003BA\u0016\u0005[Aq!a\u0011\"\u0001\u0004\t)\u0005K\u0002\"\u0003\u001b\n\u0001\u0002^3yi\u001aKG.\u001a\u000b\u0005\u0003_\u0014)\u0004\u0003\u0004\u0002>\t\u0002\rA\u0015\u000b\u0005\u0003_\u0014I\u0004C\u0004\u0002D\r\u0002\r!!\u0012)\u0007\r\ni%A\fbgN,'\u000f\u001e(p'B,7-\u001b4jK\u0012\u001c6\r[3nCR!!\u0011\tB$!\rQ$1I\u0005\u0004\u0005\u000bZ$\u0001B+oSRDaA!\u0013%\u0001\u0004\u0011\u0016!C8qKJ\fG/[8o\u0003}1XM]5gs\u000e{G.^7o\u001d\u0006lWm\u00144D_J\u0014X\u000f\u001d;SK\u000e|'\u000f\u001a\u000b\u0007\u0005\u0003\u0012yE!\u0015\t\u000bu+\u0003\u0019\u00011\t\r\tMS\u00051\u0001S\u0003e\u0019w\u000e\\;n]:\u000bW.Z(g\u0007>\u0014(/\u001e9u%\u0016\u001cwN\u001d3\u0016\u0003I\u000b!b]8ve\u000e,w\fJ3r)\u0011\u0011\tEa\u0017\t\u0011\tus%!AA\u0002I\u000b1\u0001\u001f\u00132\u0003\u001d\u0019x.\u001e:dK\u0002\n1#^:feN\u0003XmY5gS\u0016$7k\u00195f[\u0006,\"A!\u001a\u0011\ti\u00129\u0007Y\u0005\u0004\u0005SZ$AB(qi&|g.A\fvg\u0016\u00148\u000b]3dS\u001aLW\rZ*dQ\u0016l\u0017m\u0018\u0013fcR!!\u0011\tB8\u0011%\u0011iFKA\u0001\u0002\u0004\u0011)'\u0001\u000bvg\u0016\u00148\u000b]3dS\u001aLW\rZ*dQ\u0016l\u0017\rI\u0001\rKb$(/Y(qi&|gn]\u000b\u0003\u0005o\u0002bA!\u001f\u0003\u0000I\u0013VB\u0001B>\u0015\u0011\u0011i(!\u0004\u0002\u000f5,H/\u00192mK&!!\u0011\u0011B>\u0005\u001dA\u0015m\u001d5NCB\fQ\"\u001a=ue\u0006|\u0005\u000f^5p]N\u0004\u0003f\u0001\u0001\u0003\bB!!\u0011\u0012BJ\u001d\u0011\u0011YIa$\u000e\u0005\t5%bAA*c%!!\u0011\u0013BG\u0003IIe\u000e^3sM\u0006\u001cWm\u0015;bE&d\u0017\u000e^=\n\t\tU%q\u0013\u0002\u0007'R\f'\r\\3\u000b\t\tE%Q\u0012")
public class DataFrameReader
implements Logging {
    private final SparkSession sparkSession;
    private String source;
    private Option<StructType> userSpecifiedSchema;
    private final HashMap<String, String> extraOptions;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Dataset<Row> load(String ... paths) {
        return this.load((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> json(String ... paths) {
        return this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> csv(String ... paths) {
        return this.csv((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> parquet(String ... paths) {
        return this.parquet((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> orc(String ... paths) {
        return this.orc((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> text(String ... paths) {
        return this.text((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<String> textFile(String ... paths) {
        return this.textFile((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public DataFrameReader format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataFrameReader schema(StructType schema) {
        this.userSpecifiedSchema_$eq((Option<StructType>)Option$.MODULE$.apply((Object)schema));
        return this;
    }

    public DataFrameReader schema(String schemaString) {
        this.userSpecifiedSchema_$eq((Option<StructType>)Option$.MODULE$.apply((Object)StructType$.MODULE$.fromDDL(schemaString)));
        return this;
    }

    public DataFrameReader option(String key, String value) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value));
        return this;
    }

    public DataFrameReader option(String key, boolean value) {
        return this.option(key, ((Object)BoxesRunTime.boxToBoolean((boolean)value)).toString());
    }

    public DataFrameReader option(String key, long value) {
        return this.option(key, ((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public DataFrameReader option(String key, double value) {
        return this.option(key, ((Object)BoxesRunTime.boxToDouble((double)value)).toString());
    }

    public DataFrameReader options(Map<String, String> options) {
        this.extraOptions().$plus$plus$eq(options);
        return this;
    }

    public DataFrameReader options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public Dataset<Row> load() {
        return this.load((Seq<String>)((Seq)Seq$.MODULE$.empty()));
    }

    public Dataset<Row> load(String path) {
        return this.option("path", path).load((Seq<String>)((Seq)Seq$.MODULE$.empty()));
    }

    public Dataset<Row> load(Seq<String> paths) {
        Dataset<Row> dataset;
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new AnalysisException("Hive data source can only be used with tables, you can not read files of Hive data source directly.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        Class<?> cls = DataSource$.MODULE$.lookupDataSource(this.source(), this.sparkSession.sessionState().conf());
        if (DataSourceV2.class.isAssignableFrom(cls)) {
            DataSourceV2 ds = (DataSourceV2)cls.newInstance();
            if (ds instanceof ReadSupport) {
                scala.collection.immutable.Map<String, String> sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs(ds, this.sparkSession.sessionState().conf());
                ObjectMapper objectMapper = new ObjectMapper();
                Tuple2 pathsOption = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paths"), (Object)objectMapper.writeValueAsString(paths.toArray(ClassTag$.MODULE$.apply(String.class))));
                DataSourceV2 x$1 = ds;
                scala.collection.immutable.Map x$2 = sessionOptions.$plus$plus((GenTraversableOnce)this.extraOptions().toMap(Predef$.MODULE$.$conforms())).$plus(pathsOption);
                Option<StructType> x$3 = this.userSpecifiedSchema();
                Option<TableIdentifier> x$4 = DataSourceV2Relation$.MODULE$.create$default$3();
                dataset = Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)DataSourceV2Relation$.MODULE$.create(x$1, (scala.collection.immutable.Map<String, String>)x$2, x$4, x$3));
            } else {
                dataset = this.loadV1Source(paths);
            }
        } else {
            dataset = this.loadV1Source(paths);
        }
        return dataset;
    }

    private Dataset<Row> loadV1Source(Seq<String> paths) {
        SparkSession x$1 = this.sparkSession;
        Seq<String> x$2 = paths;
        Option<StructType> x$3 = this.userSpecifiedSchema();
        String x$4 = this.source();
        scala.collection.immutable.Map x$5 = this.extraOptions().toMap(Predef$.MODULE$.$conforms());
        Seq<String> x$6 = DataSource$.MODULE$.apply$default$5();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        DataSource qual$1 = new DataSource(x$1, x$4, x$2, x$3, x$6, x$7, (scala.collection.immutable.Map<String, String>)x$5, x$8);
        boolean x$9 = qual$1.resolveRelation$default$1();
        return this.sparkSession.baseRelationToDataFrame(qual$1.resolveRelation(x$9));
    }

    public Dataset<Row> jdbc(String url, String table, Properties properties) {
        this.assertNoSpecifiedSchema("jdbc");
        this.extraOptions().$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(properties).asScala());
        this.extraOptions().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_URL()), (Object)url), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_TABLE_NAME()), (Object)table), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        return this.format("jdbc").load();
    }

    public Dataset<Row> jdbc(String url, String table, String columnName, long lowerBound, long upperBound, int numPartitions, Properties connectionProperties) {
        this.extraOptions().$plus$plus$eq((TraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_PARTITION_COLUMN()), (Object)columnName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_LOWER_BOUND()), (Object)((Object)BoxesRunTime.boxToLong((long)lowerBound)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_UPPER_BOUND()), (Object)((Object)BoxesRunTime.boxToLong((long)upperBound)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_NUM_PARTITIONS()), (Object)((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString())})));
        return this.jdbc(url, table, connectionProperties);
    }

    public Dataset<Row> jdbc(String url, String table, String[] predicates, Properties connectionProperties) {
        this.assertNoSpecifiedSchema("jdbc");
        scala.collection.immutable.Map params = this.extraOptions().toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(connectionProperties).asScala()).toMap(Predef$.MODULE$.$conforms()));
        JDBCOptions options = new JDBCOptions(url, table, (scala.collection.immutable.Map<String, String>)params);
        Partition[] parts = (Partition[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predicates)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String part = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            JDBCPartition jDBCPartition = new JDBCPartition(part, i);
            return jDBCPartition;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Partition.class)));
        JDBCRelation relation = JDBCRelation$.MODULE$.apply(parts, options, this.sparkSession);
        return this.sparkSession.baseRelationToDataFrame(relation);
    }

    public Dataset<Row> json(String path) {
        return this.json((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> json(Seq<String> paths) {
        return this.format("json").load(paths);
    }

    public Dataset<Row> json(JavaRDD<String> jsonRDD) {
        return this.json((RDD<String>)jsonRDD.rdd());
    }

    public Dataset<Row> json(RDD<String> jsonRDD) {
        return this.json(this.sparkSession.createDataset(jsonRDD, Encoders$.MODULE$.STRING()));
    }

    public Dataset<Row> json(Dataset<String> jsonDataset) {
        JSONOptions parsedOptions = new JSONOptions(this.extraOptions().toMap(Predef$.MODULE$.$conforms()), this.sparkSession.sessionState().conf().sessionLocalTimeZone(), this.sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        StructType schema = (StructType)this.userSpecifiedSchema().getOrElse((Function0 & Serializable & scala.Serializable)() -> TextInputJsonDataSource$.MODULE$.inferFromDataset(jsonDataset, parsedOptions));
        this.verifyColumnNameOfCorruptRecord(schema, parsedOptions.columnNameOfCorruptRecord());
        StructType actualSchema = StructType$.MODULE$.apply((Seq)schema.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DataFrameReader.$anonfun$json$2(parsedOptions, x$1))));
        Function2 & Serializable & scala.Serializable createParser = (Function2 & Serializable & scala.Serializable)(jsonFactory, record) -> CreateJacksonParser$.MODULE$.string(jsonFactory, record);
        RDD parsed = jsonDataset.rdd().mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            JacksonParser rawParser = new JacksonParser((DataType)actualSchema, parsedOptions);
            FailureSafeParser parser = new FailureSafeParser((Function1 & Serializable & scala.Serializable)input -> rawParser.parse(input, createParser, (Function1 & Serializable & scala.Serializable)x$1 -> UTF8String.fromString((String)x$1)), parsedOptions.parseMode(), schema, parsedOptions.columnNameOfCorruptRecord());
            return iter.flatMap((Function1 & Serializable & scala.Serializable)input -> parser.parse(input));
        }, jsonDataset.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        return this.sparkSession.internalCreateDataFrame((RDD<InternalRow>)parsed, schema, jsonDataset.isStreaming());
    }

    public Dataset<Row> csv(String path) {
        return this.csv((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> csv(Dataset<String> csvDataset) {
        RDD rDD;
        CSVOptions parsedOptions = new CSVOptions((scala.collection.immutable.Map<String, String>)this.extraOptions().toMap(Predef$.MODULE$.$conforms()), this.sparkSession.sessionState().conf().csvColumnPruning(), this.sparkSession.sessionState().conf().sessionLocalTimeZone(), CSVOptions$.MODULE$.$lessinit$greater$default$4());
        Dataset<String> filteredLines = CSVUtils$.MODULE$.filterCommentAndEmpty(csvDataset, parsedOptions);
        Option maybeFirstLine = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredLines.take(1))).headOption();
        StructType schema = (StructType)this.userSpecifiedSchema().getOrElse((Function0 & Serializable & scala.Serializable)() -> TextInputCSVDataSource$.MODULE$.inferFromDataset($this.sparkSession, csvDataset, (Option<String>)maybeFirstLine, parsedOptions));
        this.verifyColumnNameOfCorruptRecord(schema, parsedOptions.columnNameOfCorruptRecord());
        StructType actualSchema = StructType$.MODULE$.apply((Seq)schema.filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DataFrameReader.$anonfun$csv$2(parsedOptions, x$2))));
        if (parsedOptions.headerFlag() && maybeFirstLine.isDefined()) {
            String firstLine = (String)maybeFirstLine.get();
            CsvParser parser = new CsvParser(parsedOptions.asParserSettings());
            String[] columnNames = parser.parseLine(firstLine);
            CSVDataSource$.MODULE$.checkHeaderColumnNames(actualSchema, columnNames, csvDataset.getClass().getCanonicalName(), parsedOptions.enforceSchema(), this.sparkSession.sessionState().conf().caseSensitiveAnalysis());
            rDD = filteredLines.rdd().mapPartitions((Function1 & Serializable & scala.Serializable)x$3 -> CSVUtils$.MODULE$.filterHeaderLine((Iterator<String>)x$3, firstLine, parsedOptions), filteredLines.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(String.class));
        } else {
            rDD = filteredLines.rdd();
        }
        RDD linesWithoutHeader = rDD;
        RDD parsed = linesWithoutHeader.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            UnivocityParser rawParser = new UnivocityParser(actualSchema, parsedOptions);
            FailureSafeParser parser = new FailureSafeParser((Function1 & Serializable & scala.Serializable)input -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalRow[]{rawParser.parse((String)input)})), parsedOptions.parseMode(), schema, parsedOptions.columnNameOfCorruptRecord());
            return iter.flatMap((Function1 & Serializable & scala.Serializable)input -> parser.parse(input));
        }, linesWithoutHeader.mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        return this.sparkSession.internalCreateDataFrame((RDD<InternalRow>)parsed, schema, csvDataset.isStreaming());
    }

    public Dataset<Row> csv(Seq<String> paths) {
        return this.format("csv").load(paths);
    }

    public Dataset<Row> parquet(String path) {
        return this.parquet((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> parquet(Seq<String> paths) {
        return this.format("parquet").load(paths);
    }

    public Dataset<Row> orc(String path) {
        return this.orc((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> orc(Seq<String> paths) {
        return this.format("orc").load(paths);
    }

    public Dataset<Row> table(String tableName) {
        this.assertNoSpecifiedSchema("table");
        return this.sparkSession.table(tableName);
    }

    public Dataset<Row> text(String path) {
        return this.text((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> text(Seq<String> paths) {
        return this.format("text").load(paths);
    }

    public Dataset<String> textFile(String path) {
        return this.textFile((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<String> textFile(Seq<String> paths) {
        this.assertNoSpecifiedSchema("textFile");
        return this.text(paths).select("value", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).as(this.sparkSession.implicits().newStringEncoder());
    }

    private void assertNoSpecifiedSchema(String operation) {
        if (this.userSpecifiedSchema().nonEmpty()) {
            throw new AnalysisException(new StringBuilder(43).append("User specified schema not supported with `").append(operation).append("`").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    private void verifyColumnNameOfCorruptRecord(StructType schema, String columnNameOfCorruptRecord) {
        schema.getFieldIndex(columnNameOfCorruptRecord).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)corruptFieldIndex -> {
            StructField f = schema.apply(corruptFieldIndex);
            DataType dataType = f.dataType();
            StringType$ stringType$ = StringType$.MODULE$;
            if ((dataType != null ? !dataType.equals(stringType$) : stringType$ != null) || !f.nullable()) {
                throw new AnalysisException("The field for corrupt records must be string type and nullable", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        });
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private Option<StructType> userSpecifiedSchema() {
        return this.userSpecifiedSchema;
    }

    private void userSpecifiedSchema_$eq(Option<StructType> x$1) {
        this.userSpecifiedSchema = x$1;
    }

    private HashMap<String, String> extraOptions() {
        return this.extraOptions;
    }

    public static final /* synthetic */ boolean $anonfun$json$2(JSONOptions parsedOptions$1, StructField x$1) {
        String string = x$1.name();
        String string2 = parsedOptions$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$csv$2(CSVOptions parsedOptions$2, StructField x$2) {
        String string = x$2.name();
        String string2 = parsedOptions$2.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public DataFrameReader(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        Logging.$init$((Logging)this);
        this.source = sparkSession.sessionState().conf().defaultDataSourceName();
        this.userSpecifiedSchema = None$.MODULE$;
        this.extraOptions = new HashMap();
    }
}

