/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sources.v2;

import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.sources.v2.CSVDataWriter;
import org.apache.spark.sql.sources.v2.writer.DataWriter;
import org.apache.spark.sql.sources.v2.writer.DataWriterFactory;
import org.apache.spark.util.SerializableConfiguration;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001a3AAB\u0004\u0001)!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006\u0003\u00058\u0001\t\u0005\t\u0015!\u0003+\u0011!A\u0004A!A!\u0002\u0013I\u0004\"B \u0001\t\u0003\u0001\u0005\"\u0002$\u0001\t\u0003:%\u0001F\"T-\u0012\u000bG/Y,sSR,'OR1di>\u0014\u0018P\u0003\u0002\t\u0013\u0005\u0011aO\r\u0006\u0003\u0015-\tqa]8ve\u000e,7O\u0003\u0002\r\u001b\u0005\u00191/\u001d7\u000b\u00059y\u0011!B:qCJ\\'B\u0001\t\u0012\u0003\u0019\t\u0007/Y2iK*\t!#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001+u\u0001\"AF\u000e\u000e\u0003]Q!\u0001G\r\u0002\t1\fgn\u001a\u0006\u00025\u0005!!.\u0019<b\u0013\tarC\u0001\u0004PE*,7\r\u001e\t\u0004=\u0005\u001aS\"A\u0010\u000b\u0005\u0001:\u0011AB<sSR,'/\u0003\u0002#?\t\tB)\u0019;b/JLG/\u001a:GC\u000e$xN]=\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019Z\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005!*#aC%oi\u0016\u0014h.\u00197S_^\fA\u0001]1uQB\u00111\u0006\u000e\b\u0003YI\u0002\"!\f\u0019\u000e\u00039R!aL\n\u0002\rq\u0012xn\u001c;?\u0015\u0005\t\u0014!B:dC2\f\u0017BA\u001a1\u0003\u0019\u0001&/\u001a3fM&\u0011QG\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005M\u0002\u0014!\u00026pE&#\u0017\u0001B2p]\u001a\u0004\"AO\u001f\u000e\u0003mR!\u0001P\u0007\u0002\tU$\u0018\u000e\\\u0005\u0003}m\u0012\u0011dU3sS\u0006d\u0017N_1cY\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u00061A(\u001b8jiz\"B!Q\"E\u000bB\u0011!\tA\u0007\u0002\u000f!)\u0011\u0006\u0002a\u0001U!)q\u0007\u0002a\u0001U!)\u0001\b\u0002a\u0001s\u0005\u00012M]3bi\u0016$\u0015\r^1Xe&$XM\u001d\u000b\u0005\u0011.\u000bf\u000bE\u0002\u001f\u0013\u000eJ!AS\u0010\u0003\u0015\u0011\u000bG/Y,sSR,'\u000fC\u0003M\u000b\u0001\u0007Q*A\u0006qCJ$\u0018\u000e^5p]&#\u0007C\u0001(P\u001b\u0005\u0001\u0014B\u0001)1\u0005\rIe\u000e\u001e\u0005\u0006%\u0016\u0001\raU\u0001\u0007i\u0006\u001c8.\u00133\u0011\u00059#\u0016BA+1\u0005\u0011auN\\4\t\u000b]+\u0001\u0019A*\u0002\u000f\u0015\u0004xn\u00195JI\u0002")
public class CSVDataWriterFactory
implements DataWriterFactory<InternalRow> {
    private final String path;
    private final String jobId;
    private final SerializableConfiguration conf;

    public DataWriter<InternalRow> createDataWriter(int partitionId, long taskId, long epochId) {
        Path jobPath = new Path(new Path(this.path, "_temporary"), this.jobId);
        Path filePath = new Path(jobPath, new StringBuilder(2).append(this.jobId).append("-").append(partitionId).append("-").append(taskId).toString());
        FileSystem fs = filePath.getFileSystem(this.conf.value());
        return new CSVDataWriter(fs, filePath);
    }

    public CSVDataWriterFactory(String path, String jobId, SerializableConfiguration conf) {
        this.path = path;
        this.jobId = jobId;
        this.conf = conf;
    }
}

