/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sources.v2;

import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.sources.v2.writer.DataWriter;
import org.apache.spark.sql.sources.v2.writer.WriterCommitMessage;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U3A!\u0003\u0006\u0001/!AA\u0006\u0001B\u0001B\u0003%Q\u0006\u0003\u00055\u0001\t\u0005\t\u0015!\u00036\u0011\u0015A\u0004\u0001\"\u0001:\u0011\u001dq\u0004A1A\u0005\n}Baa\u0011\u0001!\u0002\u0013\u0001\u0005\"\u0002#\u0001\t\u0003*\u0005\"\u0002(\u0001\t\u0003z\u0005\"B*\u0001\t\u0003\"&!D\"T-\u0012\u000bG/Y,sSR,'O\u0003\u0002\f\u0019\u0005\u0011aO\r\u0006\u0003\u001b9\tqa]8ve\u000e,7O\u0003\u0002\u0010!\u0005\u00191/\u001d7\u000b\u0005E\u0011\u0012!B:qCJ\\'BA\n\u0015\u0003\u0019\t\u0007/Y2iK*\tQ#A\u0002pe\u001e\u001c\u0001aE\u0002\u00011\u0001\u0002\"!\u0007\u0010\u000e\u0003iQ!a\u0007\u000f\u0002\t1\fgn\u001a\u0006\u0002;\u0005!!.\u0019<b\u0013\ty\"D\u0001\u0004PE*,7\r\u001e\t\u0004C\u00112S\"\u0001\u0012\u000b\u0005\rR\u0011AB<sSR,'/\u0003\u0002&E\tQA)\u0019;b/JLG/\u001a:\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005%r\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005-B#aC%oi\u0016\u0014h.\u00197S_^\f!AZ:\u0011\u00059\u0012T\"A\u0018\u000b\u00051\u0002$BA\u0019\u0013\u0003\u0019A\u0017\rZ8pa&\u00111g\f\u0002\u000b\r&dWmU=ti\u0016l\u0017\u0001\u00024jY\u0016\u0004\"A\f\u001c\n\u0005]z#\u0001\u0002)bi\"\fa\u0001P5oSRtDc\u0001\u001e={A\u00111\bA\u0007\u0002\u0015!)Af\u0001a\u0001[!)Ag\u0001a\u0001k\u0005\u0019q.\u001e;\u0016\u0003\u0001\u0003\"AL!\n\u0005\t{#A\u0005$T\t\u0006$\u0018mT;uaV$8\u000b\u001e:fC6\fAa\\;uA\u0005)qO]5uKR\u0011a\t\u0014\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0002\u0013\u0006)1oY1mC&\u00111\n\u0013\u0002\u0005+:LG\u000fC\u0003N\r\u0001\u0007a%\u0001\u0004sK\u000e|'\u000fZ\u0001\u0007G>lW.\u001b;\u0015\u0003A\u0003\"!I)\n\u0005I\u0013#aE,sSR,'oQ8n[&$X*Z:tC\u001e,\u0017!B1c_J$H#\u0001$")
public class CSVDataWriter
implements DataWriter<InternalRow> {
    private final FileSystem fs;
    private final Path file;
    private final FSDataOutputStream out;

    private FSDataOutputStream out() {
        return this.out;
    }

    public void write(InternalRow record) {
        this.out().writeBytes(new StringBuilder(2).append(record.getLong(0)).append(",").append(record.getLong(1)).append("\n").toString());
    }

    public WriterCommitMessage commit() {
        this.out().close();
        return null;
    }

    public void abort() {
        try {
            this.out().close();
        }
        finally {
            this.fs.delete(this.file, false);
        }
    }

    public CSVDataWriter(FileSystem fs, Path file) {
        this.fs = fs;
        this.file = file;
        this.out = fs.create(file);
    }
}

