/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.vectorized;

import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.sql.RandomDataGenerator$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.arrow.ArrowUtils$;
import org.apache.spark.sql.execution.vectorized.ColumnVectorUtils;
import org.apache.spark.sql.execution.vectorized.OffHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.vectorized.ArrowColumnVector;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.sql.vectorized.ColumnarRow;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.NotImplementedError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ResizableArray;
import scala.math.BigDecimal$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\u0006\r\u0001eAQA\b\u0001\u0005\u0002}AQA\t\u0001\u0005\n\rBQa\u0010\u0001\u0005\n\u0001CqA\u0017\u0001C\u0002\u0013%1\f\u0003\u0004`\u0001\u0001\u0006I\u0001\u0018\u0005\bA\u0002\u0011\r\u0011\"\u0003\\\u0011\u0019\t\u0007\u0001)A\u00059\")!\r\u0001C\u0005G\")a\u000e\u0001C\u0005_\"9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\"AE\"pYVlg.\u0019:CCR\u001c\u0007nU;ji\u0016T!!\u0004\b\u0002\u0015Y,7\r^8sSj,GM\u0003\u0002\u0010!\u0005IQ\r_3dkRLwN\u001c\u0006\u0003#I\t1a]9m\u0015\t\u0019B#A\u0003ta\u0006\u00148N\u0003\u0002\u0016-\u00051\u0011\r]1dQ\u0016T\u0011aF\u0001\u0004_J<7\u0001A\n\u0003\u0001i\u0001\"a\u0007\u000f\u000e\u0003II!!\b\n\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0005\u0005\u0002\"\u00015\tA\"\u0001\u0005bY2|7-\u0019;f)\u0011!seL\u001c\u0011\u0005\u0005*\u0013B\u0001\u0014\r\u0005Q9&/\u001b;bE2,7i\u001c7v[:4Vm\u0019;pe\")\u0001F\u0001a\u0001S\u0005A1-\u00199bG&$\u0018\u0010\u0005\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3FA\u0002J]RDQ\u0001\r\u0002A\u0002E\n!\u0001\u001a;\u0011\u0005I*T\"A\u001a\u000b\u0005Q\u0002\u0012!\u0002;za\u0016\u001c\u0018B\u0001\u001c4\u0005!!\u0015\r^1UsB,\u0007\"\u0002\u001d\u0003\u0001\u0004I\u0014aB7f[6{G-\u001a\t\u0003uuj\u0011a\u000f\u0006\u0003yI\ta!\\3n_JL\u0018B\u0001 <\u0005)iU-\\8ss6{G-Z\u0001\u000bi\u0016\u001cHOV3di>\u0014H\u0003B!K/f#\"AQ#\u0011\u0005)\u001a\u0015B\u0001#,\u0005\u0011)f.\u001b;\t\u000b\u0019\u001b\u0001\u0019A$\u0002\u000b\tdwnY6\u0011\t)BEEQ\u0005\u0003\u0013.\u0012\u0011BR;oGRLwN\\\u0019\t\u000b-\u001b\u0001\u0019\u0001'\u0002\t9\fW.\u001a\t\u0003\u001bRs!A\u0014*\u0011\u0005=[S\"\u0001)\u000b\u0005EC\u0012A\u0002\u001fs_>$h(\u0003\u0002TW\u00051\u0001K]3eK\u001aL!!\u0016,\u0003\rM#(/\u001b8h\u0015\t\u00196\u0006C\u0003Y\u0007\u0001\u0007\u0011&\u0001\u0003tSj,\u0007\"\u0002\u0019\u0004\u0001\u0004\t\u0014AC:ueV\u001cG\u000fV=qKV\tA\f\u0005\u00023;&\u0011al\r\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017aC:ueV\u001cG\u000fV=qK\u0002\n\u0011b];c'\u000eDW-\\1\u0002\u0015M,(mU2iK6\f\u0007%\u0001\u0007e_V\u0014G.Z#rk\u0006d7\u000fF\u0002eO2\u0004\"AK3\n\u0005\u0019\\#a\u0002\"p_2,\u0017M\u001c\u0005\u0006Q\"\u0001\r![\u0001\u0003IF\u0002\"A\u000b6\n\u0005-\\#A\u0002#pk\ndW\rC\u0003n\u0011\u0001\u0007\u0011.\u0001\u0002ee\u0005i1m\\7qCJ,7\u000b\u001e:vGR$rA\u00119\u007f\u0003\u001b\tI\u0002C\u0003r\u0013\u0001\u0007!/\u0001\u0004gS\u0016dGm\u001d\t\u0004gb\\hB\u0001;w\u001d\tyU/C\u0001-\u0013\t98&A\u0004qC\u000e\\\u0017mZ3\n\u0005eT(aA*fc*\u0011qo\u000b\t\u0003eqL!!`\u001a\u0003\u0017M#(/^2u\r&,G\u000e\u001a\u0005\u0007\u007f&\u0001\r!!\u0001\u0002\u0005I\f\u0004\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001d\u0001#\u0001\u0005dCR\fG._:u\u0013\u0011\tY!!\u0002\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\b\u0003\u001fI\u0001\u0019AA\t\u0003\t\u0011(\u0007\u0005\u0003\u0002\u0014\u0005UQ\"\u0001\t\n\u0007\u0005]\u0001CA\u0002S_^Dq!a\u0007\n\u0001\u0004\ti\"\u0001\u0003tK\u0016$\u0007c\u0001\u0016\u0002 %\u0019\u0011\u0011E\u0016\u0003\t1{gnZ\u0001\u000fi\u0016\u001cHOU1oI>l'k\\<t)\u0015\u0011\u0015qEA\u0016\u0011\u0019\tIC\u0003a\u0001I\u0006Qa\r\\1u'\u000eDW-\\1\t\r\u00055\"\u00021\u0001*\u0003%qW/\u001c$jK2$7\u000f")
public class ColumnarBatchSuite
extends SparkFunSuite {
    private final StructType structType;
    private final StructType subSchema;

    private WritableColumnVector allocate(int capacity, DataType dt, MemoryMode memMode) {
        MemoryMode memoryMode = memMode;
        MemoryMode memoryMode2 = MemoryMode.OFF_HEAP;
        return !(memoryMode != null ? !memoryMode.equals(memoryMode2) : memoryMode2 != null) ? new OffHeapColumnVector(capacity, dt) : new OnHeapColumnVector(capacity, dt);
    }

    private void testVector(String name, int size, DataType dt, Function1<WritableColumnVector, BoxedUnit> block) {
        this.test(name, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MemoryMode[]{MemoryMode.ON_HEAP, MemoryMode.OFF_HEAP}))).foreach((Function1 & Serializable & scala.Serializable)mode -> {
            ColumnarBatchSuite.$anonfun$testVector$2(this, size, dt, block, mode);
            return BoxedUnit.UNIT;
        }), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
    }

    private StructType structType() {
        return this.structType;
    }

    private StructType subSchema() {
        return this.subSchema;
    }

    private boolean doubleEquals(double d1, double d2) {
        return Predef$.MODULE$.double2Double(d1).isNaN() && Predef$.MODULE$.double2Double(d2).isNaN() ? true : d1 == d2;
    }

    private void compareStruct(Seq<StructField> fields, InternalRow r1, Row r2, long seed) {
        ((IterableLike)fields.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            StructField field = (StructField)tuple2._1();
            int ordinal = tuple2._2$mcI$sp();
            if (field == null) throw new MatchError((Object)tuple2);
            StructField structField = field;
            int n = ordinal;
            boolean $org_scalatest_assert_macro_left = r1.isNullAt(n);
            boolean $org_scalatest_assert_macro_right = r2.isNullAt(n);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1069));
            if (!r1.isNullAt(n)) {
                Assertion assertion;
                DataType dataType = structField.dataType();
                if (BooleanType$.MODULE$.equals(dataType)) {
                    boolean $org_scalatest_assert_macro_left2 = r1.getBoolean(n);
                    boolean $org_scalatest_assert_macro_right2 = r2.getBoolean(n);
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                    assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1072));
                } else if (ByteType$.MODULE$.equals(dataType)) {
                    byte $org_scalatest_assert_macro_left3 = r1.getByte(n);
                    byte $org_scalatest_assert_macro_right3 = r2.getByte(n);
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                    assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1074));
                } else if (ShortType$.MODULE$.equals(dataType)) {
                    short $org_scalatest_assert_macro_left4 = r1.getShort(n);
                    short $org_scalatest_assert_macro_right4 = r2.getShort(n);
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
                    assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1075));
                } else if (IntegerType$.MODULE$.equals(dataType)) {
                    int $org_scalatest_assert_macro_left5 = r1.getInt(n);
                    int $org_scalatest_assert_macro_right5 = r2.getInt(n);
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
                    assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1076));
                } else if (LongType$.MODULE$.equals(dataType)) {
                    long $org_scalatest_assert_macro_left6 = r1.getLong(n);
                    long $org_scalatest_assert_macro_right6 = r2.getLong(n);
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
                    assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1077));
                } else if (FloatType$.MODULE$.equals(dataType)) {
                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(this.doubleEquals(r1.getFloat(n), r2.getFloat(n)), "ColumnarBatchSuite.this.doubleEquals(r1.getFloat(ordinal).toDouble, r2.getFloat(ordinal).toDouble)", Prettifier$.MODULE$.default());
                    assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1078));
                } else if (DoubleType$.MODULE$.equals(dataType)) {
                    Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(this.doubleEquals(r1.getDouble(n), r2.getDouble(n)), "ColumnarBatchSuite.this.doubleEquals(r1.getDouble(ordinal), r2.getDouble(ordinal))", Prettifier$.MODULE$.default());
                    assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1080));
                } else if (dataType instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)dataType;
                    scala.math.BigDecimal d1 = r1.getDecimal(n, decimalType.precision(), decimalType.scale()).toBigDecimal();
                    BigDecimal d2 = r2.getDecimal(n);
                    int $org_scalatest_assert_macro_left7 = d1.compare(BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(d2));
                    int $org_scalatest_assert_macro_right7 = 0;
                    Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
                    assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1085));
                } else if (StringType$.MODULE$.equals(dataType)) {
                    String $org_scalatest_assert_macro_left8 = r1.getString(n);
                    String $org_scalatest_assert_macro_right8 = r2.getString(n);
                    String string = $org_scalatest_assert_macro_left8;
                    String string2 = $org_scalatest_assert_macro_right8;
                    Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right8, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                    assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1087));
                } else if (CalendarIntervalType$.MODULE$.equals(dataType)) {
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(r1.getInterval(n));
                    CalendarInterval $org_scalatest_assert_macro_right9 = (CalendarInterval)r2.get(n);
                    Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1089));
                } else if (dataType instanceof ArrayType) {
                    BoxedUnit boxedUnit2;
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType childType = arrayType.elementType();
                    Object[] a1 = r1.getArray(n).array();
                    Object[] a2 = r2.getList(n).toArray();
                    Object[] $org_scalatest_assert_macro_left10 = a1;
                    int $org_scalatest_assert_macro_right10 = a2.length;
                    Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left10, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left10.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Prettifier$.MODULE$.default());
                    this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1093));
                    DataType dataType2 = childType;
                    if (DoubleType$.MODULE$.equals(dataType2)) {
                        for (int i = 0; i < a1.length; ++i) {
                            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(this.doubleEquals(BoxesRunTime.unboxToDouble((Object)a1[i]), BoxesRunTime.unboxToDouble((Object)a2[i])), "ColumnarBatchSuite.this.doubleEquals(a1.apply(i).asInstanceOf[Double], a2.apply(i).asInstanceOf[Double])", Prettifier$.MODULE$.default());
                            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1098));
                        }
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else if (FloatType$.MODULE$.equals(dataType2)) {
                        for (int i = 0; i < a1.length; ++i) {
                            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.simpleMacroBool(this.doubleEquals(BoxesRunTime.unboxToFloat((Object)a1[i]), BoxesRunTime.unboxToFloat((Object)a2[i])), "ColumnarBatchSuite.this.doubleEquals(a1.apply(i).asInstanceOf[Float].toDouble, a2.apply(i).asInstanceOf[Float].toDouble)", Prettifier$.MODULE$.default());
                            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1105));
                        }
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else if (dataType2 instanceof DecimalType) {
                        for (int i = 0; i < a1.length; ++i) {
                            BoxedUnit boxedUnit3;
                            boolean $org_scalatest_assert_macro_left11 = a1[i] == null;
                            boolean $org_scalatest_assert_macro_right11 = a2[i] == null;
                            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left11), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11 == $org_scalatest_assert_macro_right11, Prettifier$.MODULE$.default());
                            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1112));
                            if (a1[i] != null) {
                                scala.math.BigDecimal d1 = ((Decimal)a1[i]).toBigDecimal();
                                BigDecimal d2 = (BigDecimal)a2[i];
                                int $org_scalatest_assert_macro_left12 = d1.compare(BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(d2));
                                int $org_scalatest_assert_macro_right12 = 0;
                                Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left12), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12 == $org_scalatest_assert_macro_right12, Prettifier$.MODULE$.default());
                                boxedUnit3 = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1116));
                                continue;
                            }
                            boxedUnit3 = BoxedUnit.UNIT;
                        }
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.convertToEqualizer(a1);
                        Object[] $org_scalatest_assert_macro_right13 = a2;
                        Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)$org_scalatest_assert_macro_right13, $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)$org_scalatest_assert_macro_right13, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        boxedUnit2 = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1120));
                    }
                    assertion = boxedUnit2;
                } else {
                    if (!(dataType instanceof StructType)) throw new NotImplementedError(new StringBuilder(16).append("Not implemented ").append(structField.dataType()).toString());
                    StructType structType = (StructType)dataType;
                    StructField[] childFields = structType.fields();
                    this.compareStruct((Seq<StructField>)Predef$.MODULE$.wrapRefArray((Object[])childFields), r1.getStruct(n, fields.length()), r2.getStruct(n), seed);
                    assertion = BoxedUnit.UNIT;
                }
                boxedUnit = assertion;
                return boxedUnit;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
    }

    public void testRandomRows(boolean flatSchema, int numFields) {
        DataType[] types = (DataType[])((Object[])new DataType[]{BooleanType$.MODULE$, ByteType$.MODULE$, FloatType$.MODULE$, DoubleType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, ShortType$.MODULE$, DecimalType$.MODULE$.ShortDecimal(), DecimalType$.MODULE$.IntDecimal(), DecimalType$.MODULE$.ByteDecimal(), DecimalType$.MODULE$.FloatDecimal(), DecimalType$.MODULE$.LongDecimal(), new DecimalType(5, 2), new DecimalType(12, 2), new DecimalType(30, 10), CalendarIntervalType$.MODULE$});
        long seed = System.nanoTime();
        int NUM_ROWS = 200;
        int NUM_ITERS = 1000;
        Random random = new Random(seed);
        for (int i = 0; i < NUM_ITERS; ++i) {
            StructType schema = flatSchema ? RandomDataGenerator$.MODULE$.randomSchema(random, numFields, (Seq)Predef$.MODULE$.wrapRefArray((Object[])types)) : RandomDataGenerator$.MODULE$.randomNestedSchema(random, numFields, (Seq)Predef$.MODULE$.wrapRefArray((Object[])types));
            ArrayBuffer rows = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            for (int j = 0; j < NUM_ROWS; ++j) {
                Row row = RandomDataGenerator$.MODULE$.randomRow(random, schema);
                rows.$plus$eq((Object)row);
            }
            MemoryMode memoryMode = MemoryMode.ON_HEAP;
            MemoryMode memoryMode2 = MemoryMode.OFF_HEAP;
            Nil$.MODULE$.$colon$colon((Object)memoryMode2).$colon$colon((Object)memoryMode).foreach((Function1 & Serializable & scala.Serializable)memMode -> {
                ColumnarBatchSuite.$anonfun$testRandomRows$1(this, schema, rows, NUM_ROWS, seed, memMode);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ void $anonfun$testVector$2(ColumnarBatchSuite $this, int size$1, DataType dt$1, Function1 block$1, MemoryMode mode) {
        try (WritableColumnVector vector = $this.allocate(size$1, dt$1, mode);){
            block$1.apply((Object)vector);
        }
    }

    public static final /* synthetic */ void $anonfun$new$1(ColumnarBatchSuite $this, WritableColumnVector column) {
        ArrayBuffer reference = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        int idx = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(column.hasNull(), "column.hasNull()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        int $org_scalatest_assert_macro_left = column.numNulls();
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        column.appendNotNull();
        reference.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(column.hasNull(), "column.hasNull()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        int $org_scalatest_assert_macro_left2 = column.numNulls();
        int $org_scalatest_assert_macro_right2 = 0;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        column.appendNotNulls(3);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).foreach((Function1 & Serializable & scala.Serializable)x$1 -> reference.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)false)));
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(column.hasNull(), "column.hasNull()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        int $org_scalatest_assert_macro_left3 = column.numNulls();
        int $org_scalatest_assert_macro_right3 = 0;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        column.appendNull();
        reference.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(column.hasNull(), "column.hasNull()", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        int $org_scalatest_assert_macro_left4 = column.numNulls();
        int $org_scalatest_assert_macro_right4 = 1;
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        column.appendNulls(3);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).foreach((Function1 & Serializable & scala.Serializable)x$2 -> reference.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(column.hasNull(), "column.hasNull()", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        int $org_scalatest_assert_macro_left5 = column.numNulls();
        int $org_scalatest_assert_macro_right5 = 4;
        Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        idx = column.elementsAppended;
        column.putNotNull(idx);
        reference.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)false));
        ++idx;
        Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(column.hasNull(), "column.hasNull()", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        int $org_scalatest_assert_macro_left6 = column.numNulls();
        int $org_scalatest_assert_macro_right6 = 4;
        Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        column.putNull(idx);
        reference.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)true));
        ++idx;
        Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(column.hasNull(), "column.hasNull()", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        int $org_scalatest_assert_macro_left7 = column.numNulls();
        int $org_scalatest_assert_macro_right7 = 5;
        Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        column.putNulls(idx, 3);
        reference.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)true));
        reference.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)true));
        reference.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)true));
        idx += 3;
        Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(column.hasNull(), "column.hasNull()", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        int $org_scalatest_assert_macro_left8 = column.numNulls();
        int $org_scalatest_assert_macro_right8 = 8;
        Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8 == $org_scalatest_assert_macro_right8, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        column.putNotNulls(idx, 4);
        reference.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)false));
        reference.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)false));
        reference.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)false));
        reference.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)false));
        idx += 4;
        Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.simpleMacroBool(column.hasNull(), "column.hasNull()", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        int $org_scalatest_assert_macro_left9 = column.numNulls();
        int $org_scalatest_assert_macro_right9 = 8;
        Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left9), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9 == $org_scalatest_assert_macro_right9, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        ((ResizableArray)reference.zipWithIndex(ArrayBuffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)v -> {
            boolean $org_scalatest_assert_macro_left = v._1$mcZ$sp();
            boolean $org_scalatest_assert_macro_right = column.isNullAt(v._2$mcI$sp());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        });
    }

    public static final /* synthetic */ byte $anonfun$new$6(int x$8) {
        return (byte)x$8;
    }

    public static final /* synthetic */ byte $anonfun$new$8(int x$15) {
        return (byte)x$15;
    }

    public static final /* synthetic */ void $anonfun$new$5(ColumnarBatchSuite $this, WritableColumnVector column) {
        ArrayBuffer reference = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        int n = 10;
        int n2 = 20;
        int n3 = 30;
        int n4 = 40;
        int n5 = 50;
        byte[] values = (byte[])((TraversableOnce)Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToInteger((int)n5)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)n4)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)n3)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)n2)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)n)).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToByte((byte)ColumnarBatchSuite.$anonfun$new$6(BoxesRunTime.unboxToInt((Object)x$8))), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Byte());
        column.appendBytes(2, values, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)10)));
        reference.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)20)));
        column.appendBytes(3, values, 2);
        reference.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)30)));
        reference.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)40)));
        reference.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)50)));
        column.appendBytes(6, (byte)60);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 6).foreach((Function1 & Serializable & scala.Serializable)x$9 -> reference.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)60))));
        column.appendByte((byte)70);
        reference.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)70)));
        int idx = column.elementsAppended;
        int n6 = 1;
        int n7 = 2;
        int n8 = 3;
        int n9 = 4;
        int n10 = 5;
        values = (byte[])((TraversableOnce)Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToInteger((int)n10)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)n9)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)n8)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)n7)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)n6)).map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToByte((byte)ColumnarBatchSuite.$anonfun$new$8(BoxesRunTime.unboxToInt((Object)x$15))), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Byte());
        column.putBytes(idx, 2, values, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToByte((byte)1));
        reference.$plus$eq((Object)BoxesRunTime.boxToByte((byte)2));
        column.putBytes(idx += 2, 3, values, 2);
        reference.$plus$eq((Object)BoxesRunTime.boxToByte((byte)3));
        reference.$plus$eq((Object)BoxesRunTime.boxToByte((byte)4));
        reference.$plus$eq((Object)BoxesRunTime.boxToByte((byte)5));
        column.putByte(idx += 3, (byte)9);
        reference.$plus$eq((Object)BoxesRunTime.boxToByte((byte)9));
        column.putBytes(++idx, 3, (byte)4);
        reference.$plus$eq((Object)BoxesRunTime.boxToByte((byte)4));
        reference.$plus$eq((Object)BoxesRunTime.boxToByte((byte)4));
        reference.$plus$eq((Object)BoxesRunTime.boxToByte((byte)4));
        idx += 3;
        ((ResizableArray)reference.zipWithIndex(ArrayBuffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)v -> {
            byte $org_scalatest_assert_macro_left = BoxesRunTime.unboxToByte((Object)v._1());
            byte $org_scalatest_assert_macro_right = column.getByte(v._2$mcI$sp());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(11).append("VectorType=").append(column.getClass().getSimpleName()).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
        });
    }

    public static final /* synthetic */ short $anonfun$new$11(int x$21) {
        return (short)x$21;
    }

    public static final /* synthetic */ short $anonfun$new$13(int x$28) {
        return (short)x$28;
    }

    public static final /* synthetic */ void $anonfun$new$10(ColumnarBatchSuite $this, WritableColumnVector column) {
        long seed = System.currentTimeMillis();
        Random random = new Random(seed);
        ArrayBuffer reference = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        int n = 10;
        int n2 = 20;
        int n3 = 30;
        int n4 = 40;
        int n5 = 50;
        short[] values = (short[])((TraversableOnce)Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToInteger((int)n5)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)n4)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)n3)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)n2)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)n)).map((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToShort((short)ColumnarBatchSuite.$anonfun$new$11(BoxesRunTime.unboxToInt((Object)x$21))), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Short());
        column.appendShorts(2, values, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)((short)10)));
        reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)((short)20)));
        column.appendShorts(3, values, 2);
        reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)((short)30)));
        reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)((short)40)));
        reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)((short)50)));
        column.appendShorts(6, (short)60);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 6).foreach((Function1 & Serializable & scala.Serializable)x$22 -> reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)((short)60))));
        column.appendShort((short)70);
        reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)((short)70)));
        int idx = column.elementsAppended;
        int n6 = 1;
        int n7 = 2;
        int n8 = 3;
        int n9 = 4;
        int n10 = 5;
        values = (short[])((TraversableOnce)Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToInteger((int)n10)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)n9)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)n8)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)n7)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)n6)).map((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToShort((short)ColumnarBatchSuite.$anonfun$new$13(BoxesRunTime.unboxToInt((Object)x$28))), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Short());
        column.putShorts(idx, 2, values, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)1));
        reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)2));
        column.putShorts(idx += 2, 3, values, 2);
        reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)3));
        reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)4));
        reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)5));
        column.putShort(idx += 3, (short)9);
        reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)9));
        column.putShorts(++idx, 3, (short)4);
        reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)4));
        reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)4));
        reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)4));
        idx += 3;
        while (idx < column.capacity) {
            boolean single = random.nextBoolean();
            if (single) {
                short v2 = (short)random.nextInt();
                column.putShort(idx, v2);
                reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)v2));
                ++idx;
                continue;
            }
            int n11 = package$.MODULE$.min(random.nextInt(column.capacity / 20), column.capacity - idx);
            short v3 = (short)(n11 + 1);
            column.putShorts(idx, n11, v3);
            for (int i = 0; i < n11; ++i) {
                reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)v3));
            }
            idx += n11;
        }
        ((ResizableArray)reference.zipWithIndex(ArrayBuffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)v -> {
            short $org_scalatest_assert_macro_left = BoxesRunTime.unboxToShort((Object)v._1());
            short $org_scalatest_assert_macro_right = column.getShort(v._2$mcI$sp());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(19).append("Seed = ").append(seed).append(" VectorType=").append(column.getClass().getSimpleName()).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
        });
    }

    public static final /* synthetic */ void $anonfun$new$15(ColumnarBatchSuite $this, WritableColumnVector column) {
        long seed = System.currentTimeMillis();
        Random random = new Random(seed);
        ArrayBuffer reference = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        int n = 10;
        int n2 = 20;
        int n3 = 30;
        int n4 = 40;
        int n5 = 50;
        int[] values = (int[])Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToInteger((int)n5)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)n4)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)n3)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)n2)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)n)).toArray(ClassTag$.MODULE$.Int());
        column.appendInts(2, values, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)10));
        reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)20));
        column.appendInts(3, values, 2);
        reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)30));
        reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)40));
        reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)50));
        column.appendInts(6, 60);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 6).foreach((Function1 & Serializable & scala.Serializable)x$34 -> reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)60)));
        column.appendInt(70);
        reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)70));
        int idx = column.elementsAppended;
        int n6 = 1;
        int n7 = 2;
        int n8 = 3;
        int n9 = 4;
        int n10 = 5;
        values = (int[])Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToInteger((int)n10)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)n9)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)n8)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)n7)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)n6)).toArray(ClassTag$.MODULE$.Int());
        column.putInts(idx, 2, values, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)1));
        reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)2));
        column.putInts(idx += 2, 3, values, 2);
        reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)3));
        reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)4));
        reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)5));
        idx += 3;
        byte[] littleEndian = new byte[8];
        littleEndian[0] = 7;
        littleEndian[1] = 1;
        littleEndian[4] = 6;
        littleEndian[6] = 1;
        column.putIntsLittleEndian(idx, 1, littleEndian, 4);
        column.putIntsLittleEndian(idx + 1, 1, littleEndian, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)65542));
        reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)263));
        column.putIntsLittleEndian(idx += 2, 2, littleEndian, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)263));
        reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)65542));
        idx += 2;
        while (idx < column.capacity) {
            boolean single = random.nextBoolean();
            if (single) {
                int v2 = random.nextInt();
                column.putInt(idx, v2);
                reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)v2));
                ++idx;
                continue;
            }
            int n11 = package$.MODULE$.min(random.nextInt(column.capacity / 20), column.capacity - idx);
            column.putInts(idx, n11, n11 + 1);
            for (int i = 0; i < n11; ++i) {
                reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(n11 + 1)));
            }
            idx += n11;
        }
        ((ResizableArray)reference.zipWithIndex(ArrayBuffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)v -> {
            int $org_scalatest_assert_macro_left = v._1$mcI$sp();
            int $org_scalatest_assert_macro_right = column.getInt(v._2$mcI$sp());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(19).append("Seed = ").append(seed).append(" VectorType=").append(column.getClass().getSimpleName()).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
        });
    }

    public static final /* synthetic */ void $anonfun$new$18(ColumnarBatchSuite $this, WritableColumnVector column) {
        long seed = System.currentTimeMillis();
        Random random = new Random(seed);
        ArrayBuffer reference = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        long l = 10L;
        long l2 = 20L;
        long l3 = 30L;
        long l4 = 40L;
        long l5 = 50L;
        long[] values = (long[])Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToLong((long)l5)).$colon$colon((Object)BoxesRunTime.boxToLong((long)l4)).$colon$colon((Object)BoxesRunTime.boxToLong((long)l3)).$colon$colon((Object)BoxesRunTime.boxToLong((long)l2)).$colon$colon((Object)BoxesRunTime.boxToLong((long)l)).toArray(ClassTag$.MODULE$.Long());
        column.appendLongs(2, values, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)10L));
        reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)20L));
        column.appendLongs(3, values, 2);
        reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)30L));
        reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)40L));
        reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)50L));
        column.appendLongs(6, 60L);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 6).foreach((Function1 & Serializable & scala.Serializable)x$45 -> reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)60L)));
        column.appendLong(70L);
        reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)70L));
        int idx = column.elementsAppended;
        long l6 = 1L;
        long l7 = 2L;
        long l8 = 3L;
        long l9 = 4L;
        long l10 = 5L;
        values = (long[])Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToLong((long)l10)).$colon$colon((Object)BoxesRunTime.boxToLong((long)l9)).$colon$colon((Object)BoxesRunTime.boxToLong((long)l8)).$colon$colon((Object)BoxesRunTime.boxToLong((long)l7)).$colon$colon((Object)BoxesRunTime.boxToLong((long)l6)).toArray(ClassTag$.MODULE$.Long());
        column.putLongs(idx, 2, values, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)1L));
        reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)2L));
        column.putLongs(idx += 2, 3, values, 2);
        reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)3L));
        reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)4L));
        reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)5L));
        idx += 3;
        byte[] littleEndian = new byte[16];
        littleEndian[0] = 7;
        littleEndian[1] = 1;
        littleEndian[8] = 6;
        littleEndian[10] = 1;
        column.putLongsLittleEndian(idx, 1, littleEndian, 8);
        column.putLongsLittleEndian(idx + 1, 1, littleEndian, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)65542L));
        reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)263L));
        column.putLongsLittleEndian(idx += 2, 2, littleEndian, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)263L));
        reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)65542L));
        idx += 2;
        while (idx < column.capacity) {
            boolean single = random.nextBoolean();
            if (single) {
                long v2 = random.nextLong();
                column.putLong(idx, v2);
                reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)v2));
                ++idx;
                continue;
            }
            int n = package$.MODULE$.min(random.nextInt(column.capacity / 20), column.capacity - idx);
            column.putLongs(idx, n, (long)(n + 1));
            for (int i = 0; i < n; ++i) {
                reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)(n + 1)));
            }
            idx += n;
        }
        ((ResizableArray)reference.zipWithIndex(ArrayBuffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)v -> {
            long $org_scalatest_assert_macro_left = v._1$mcJ$sp();
            long $org_scalatest_assert_macro_right = column.getLong(v._2$mcI$sp());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(24).append("idx=").append(v._2$mcI$sp()).append(" Seed = ").append(seed).append(" VectorType=").append(column.getClass().getSimpleName()).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
        });
    }

    public static final /* synthetic */ void $anonfun$new$21(ColumnarBatchSuite $this, WritableColumnVector column) {
        long seed = System.currentTimeMillis();
        Random random = new Random(seed);
        ArrayBuffer reference = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        float f = 0.1f;
        float f2 = 0.2f;
        float f3 = 0.3f;
        float f4 = 0.4f;
        float f5 = 0.5f;
        float[] values = (float[])Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToFloat((float)f5)).$colon$colon((Object)BoxesRunTime.boxToFloat((float)f4)).$colon$colon((Object)BoxesRunTime.boxToFloat((float)f3)).$colon$colon((Object)BoxesRunTime.boxToFloat((float)f2)).$colon$colon((Object)BoxesRunTime.boxToFloat((float)f)).toArray(ClassTag$.MODULE$.Float());
        column.appendFloats(2, values, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)0.1f));
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)0.2f));
        column.appendFloats(3, values, 2);
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)0.3f));
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)0.4f));
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)0.5f));
        column.appendFloats(6, 0.6f);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 6).foreach((Function1 & Serializable & scala.Serializable)x$56 -> reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)0.6f)));
        column.appendFloat(0.7f);
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)0.7f));
        int idx = column.elementsAppended;
        float f6 = 1.0f;
        float f7 = 2.0f;
        float f8 = 3.0f;
        float f9 = 4.0f;
        float f10 = 5.0f;
        values = (float[])Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToFloat((float)f10)).$colon$colon((Object)BoxesRunTime.boxToFloat((float)f9)).$colon$colon((Object)BoxesRunTime.boxToFloat((float)f8)).$colon$colon((Object)BoxesRunTime.boxToFloat((float)f7)).$colon$colon((Object)BoxesRunTime.boxToFloat((float)f6)).toArray(ClassTag$.MODULE$.Float());
        column.putFloats(idx, 2, values, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)1.0f));
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)2.0f));
        column.putFloats(idx += 2, 3, values, 2);
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)3.0f));
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)4.0f));
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)5.0f));
        idx += 3;
        byte[] buffer = new byte[8];
        Platform.putFloat((Object)buffer, (long)Platform.BYTE_ARRAY_OFFSET, (float)2.234f);
        Platform.putFloat((Object)buffer, (long)(Platform.BYTE_ARRAY_OFFSET + 4), (float)1.123f);
        if (ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN)) {
            ByteBuffer bb = ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN);
            Platform.putFloat((Object)buffer, (long)Platform.BYTE_ARRAY_OFFSET, (float)bb.getFloat(0));
            Platform.putFloat((Object)buffer, (long)(Platform.BYTE_ARRAY_OFFSET + 4), (float)bb.getFloat(4));
        }
        column.putFloats(idx, 1, buffer, 4);
        column.putFloats(idx + 1, 1, buffer, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)1.123f));
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)2.234f));
        column.putFloats(idx += 2, 2, buffer, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)2.234f));
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)1.123f));
        idx += 2;
        while (idx < column.capacity) {
            boolean single = random.nextBoolean();
            if (single) {
                float v2 = random.nextFloat();
                column.putFloat(idx, v2);
                reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)v2));
                ++idx;
                continue;
            }
            int n = package$.MODULE$.min(random.nextInt(column.capacity / 20), column.capacity - idx);
            float v3 = random.nextFloat();
            column.putFloats(idx, n, v3);
            for (int i = 0; i < n; ++i) {
                reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)v3));
            }
            idx += n;
        }
        ((ResizableArray)reference.zipWithIndex(ArrayBuffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)v -> {
            float $org_scalatest_assert_macro_left = BoxesRunTime.unboxToFloat((Object)v._1());
            float $org_scalatest_assert_macro_right = column.getFloat(v._2$mcI$sp());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(19).append("Seed = ").append(seed).append(" VectorType=").append(column.getClass().getSimpleName()).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 486));
        });
    }

    public static final /* synthetic */ void $anonfun$new$24(ColumnarBatchSuite $this, WritableColumnVector column) {
        long seed = System.currentTimeMillis();
        Random random = new Random(seed);
        ArrayBuffer reference = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        double d = 0.1;
        double d2 = 0.2;
        double d3 = 0.3;
        double d4 = 0.4;
        double d5 = 0.5;
        double[] values = (double[])Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToDouble((double)d5)).$colon$colon((Object)BoxesRunTime.boxToDouble((double)d4)).$colon$colon((Object)BoxesRunTime.boxToDouble((double)d3)).$colon$colon((Object)BoxesRunTime.boxToDouble((double)d2)).$colon$colon((Object)BoxesRunTime.boxToDouble((double)d)).toArray(ClassTag$.MODULE$.Double());
        column.appendDoubles(2, values, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)0.1));
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)0.2));
        column.appendDoubles(3, values, 2);
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)0.3));
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)0.4));
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)0.5));
        column.appendDoubles(6, 0.6);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 6).foreach((Function1 & Serializable & scala.Serializable)x$67 -> reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)0.6)));
        column.appendDouble(0.7);
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)0.7));
        int idx = column.elementsAppended;
        double d6 = 1.0;
        double d7 = 2.0;
        double d8 = 3.0;
        double d9 = 4.0;
        double d10 = 5.0;
        values = (double[])Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToDouble((double)d10)).$colon$colon((Object)BoxesRunTime.boxToDouble((double)d9)).$colon$colon((Object)BoxesRunTime.boxToDouble((double)d8)).$colon$colon((Object)BoxesRunTime.boxToDouble((double)d7)).$colon$colon((Object)BoxesRunTime.boxToDouble((double)d6)).toArray(ClassTag$.MODULE$.Double());
        column.putDoubles(idx, 2, values, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)1.0));
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)2.0));
        column.putDoubles(idx += 2, 3, values, 2);
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)3.0));
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)4.0));
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)5.0));
        idx += 3;
        byte[] buffer = new byte[16];
        Platform.putDouble((Object)buffer, (long)Platform.BYTE_ARRAY_OFFSET, (double)2.234);
        Platform.putDouble((Object)buffer, (long)(Platform.BYTE_ARRAY_OFFSET + 8), (double)1.123);
        if (ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN)) {
            ByteBuffer bb = ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN);
            Platform.putDouble((Object)buffer, (long)Platform.BYTE_ARRAY_OFFSET, (double)bb.getDouble(0));
            Platform.putDouble((Object)buffer, (long)(Platform.BYTE_ARRAY_OFFSET + 8), (double)bb.getDouble(8));
        }
        column.putDoubles(idx, 1, buffer, 8);
        column.putDoubles(idx + 1, 1, buffer, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)1.123));
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)2.234));
        column.putDoubles(idx += 2, 2, buffer, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)2.234));
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)1.123));
        idx += 2;
        while (idx < column.capacity) {
            boolean single = random.nextBoolean();
            if (single) {
                double v2 = random.nextDouble();
                column.putDouble(idx, v2);
                reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)v2));
                ++idx;
                continue;
            }
            int n = package$.MODULE$.min(random.nextInt(column.capacity / 20), column.capacity - idx);
            double v3 = random.nextDouble();
            column.putDoubles(idx, n, v3);
            for (int i = 0; i < n; ++i) {
                reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)v3));
            }
            idx += n;
        }
        ((ResizableArray)reference.zipWithIndex(ArrayBuffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)v -> {
            double $org_scalatest_assert_macro_left = v._1$mcD$sp();
            double $org_scalatest_assert_macro_right = column.getDouble(v._2$mcI$sp());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(19).append("Seed = ").append(seed).append(" VectorType=").append(column.getClass().getSimpleName()).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 570));
        });
    }

    public static final /* synthetic */ void $anonfun$new$27(ColumnarBatchSuite $this, WritableColumnVector column) {
        ArrayBuffer reference = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        int $org_scalatest_assert_macro_left = column.arrayData().elementsAppended;
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 579));
        String str = "string";
        column.appendByteArray(str.getBytes(StandardCharsets.UTF_8), 0, str.getBytes(StandardCharsets.UTF_8).length);
        reference.$plus$eq((Object)str);
        int $org_scalatest_assert_macro_left2 = column.arrayData().elementsAppended;
        int $org_scalatest_assert_macro_right2 = 6;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 585));
        int idx = column.elementsAppended;
        String string = "Hello";
        String string2 = "abc";
        String[] values = (String[])Nil$.MODULE$.$colon$colon((Object)string2).$colon$colon((Object)string).toArray(ClassTag$.MODULE$.apply(String.class));
        column.putByteArray(idx, values[0].getBytes(StandardCharsets.UTF_8), 0, values[0].getBytes(StandardCharsets.UTF_8).length);
        reference.$plus$eq((Object)values[0]);
        ++idx;
        int $org_scalatest_assert_macro_left3 = column.arrayData().elementsAppended;
        int $org_scalatest_assert_macro_right3 = 11;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 594));
        column.putByteArray(idx, values[1].getBytes(StandardCharsets.UTF_8), 0, values[1].getBytes(StandardCharsets.UTF_8).length);
        reference.$plus$eq((Object)values[1]);
        ++idx;
        int $org_scalatest_assert_macro_left4 = column.arrayData().elementsAppended;
        int $org_scalatest_assert_macro_right4 = 14;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 600));
        int offset = column.putByteArray(idx, values[0].getBytes(StandardCharsets.UTF_8), 2, values[0].getBytes(StandardCharsets.UTF_8).length - 2);
        reference.$plus$eq((Object)"llo");
        ++idx;
        int $org_scalatest_assert_macro_left5 = column.arrayData().elementsAppended;
        int $org_scalatest_assert_macro_right5 = 17;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 607));
        column.putArray(idx, offset, 2);
        reference.$plus$eq((Object)"ll");
        ++idx;
        int $org_scalatest_assert_macro_left6 = column.arrayData().elementsAppended;
        int $org_scalatest_assert_macro_right6 = 17;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 613));
        String s = "abcdefghijklmnopqrstuvwxyz";
        column.putByteArray(idx, new StringBuilder(0).append(s).append(s).toString().getBytes(StandardCharsets.UTF_8));
        reference.$plus$eq((Object)new StringBuilder(0).append(s).append(s).toString());
        ++idx;
        int $org_scalatest_assert_macro_left7 = column.arrayData().elementsAppended;
        int $org_scalatest_assert_macro_right7 = 17 + new StringBuilder(0).append(s).append(s).toString().length();
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 620));
        column.putNull(idx);
        UTF8String $org_scalatest_assert_macro_left8 = column.getUTF8String(idx);
        Object $org_scalatest_assert_macro_right8 = null;
        UTF8String uTF8String = $org_scalatest_assert_macro_left8;
        Object var34_33 = null;
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", null, !(uTF8String != null ? !uTF8String.equals(var34_33) : var34_33 != null), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 623));
        ++idx;
        ((ResizableArray)reference.zipWithIndex(ArrayBuffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)v -> {
            String errMsg = new StringBuilder(11).append("VectorType=").append(column.getClass().getSimpleName()).toString();
            String $org_scalatest_assert_macro_left = (String)v._1();
            int $org_scalatest_assert_macro_right = column.getArrayLength(v._2$mcI$sp());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)errMsg, Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 628));
            String $org_scalatest_assert_macro_left2 = (String)v._1();
            String $org_scalatest_assert_macro_right2 = column.getUTF8String(v._2$mcI$sp()).toString();
            String string = $org_scalatest_assert_macro_left2;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)errMsg, Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 629));
        });
        column.reset();
        int $org_scalatest_assert_macro_left9 = column.arrayData().elementsAppended;
        int $org_scalatest_assert_macro_right9 = 0;
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left9), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9 == $org_scalatest_assert_macro_right9, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 633));
    }

    public static final /* synthetic */ void $anonfun$new$29(ColumnarBatchSuite $this, WritableColumnVector column) {
        ArrayBuffer reference = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        WritableColumnVector months = column.getChild(0);
        WritableColumnVector microseconds = column.getChild(1);
        DataType $org_scalatest_assert_macro_left = months.dataType();
        IntegerType$ $org_scalatest_assert_macro_right = IntegerType$.MODULE$;
        DataType dataType = $org_scalatest_assert_macro_left;
        IntegerType$ integerType$ = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(integerType$) : integerType$ != null), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 642));
        DataType $org_scalatest_assert_macro_left2 = microseconds.dataType();
        LongType$ $org_scalatest_assert_macro_right2 = LongType$.MODULE$;
        DataType dataType2 = $org_scalatest_assert_macro_left2;
        LongType$ longType$ = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType2 != null ? !dataType2.equals(longType$) : longType$ != null), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 643));
        months.putInt(0, 1);
        microseconds.putLong(0, 100L);
        reference.$plus$eq((Object)new CalendarInterval(1, 100L));
        months.putInt(1, 0);
        microseconds.putLong(1, 2000L);
        reference.$plus$eq((Object)new CalendarInterval(0, 2000L));
        column.putNull(2);
        CalendarInterval $org_scalatest_assert_macro_left3 = column.getInterval(2);
        Object $org_scalatest_assert_macro_right3 = null;
        CalendarInterval calendarInterval = $org_scalatest_assert_macro_left3;
        Object var16_15 = null;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", null, !(calendarInterval != null ? !calendarInterval.equals(var16_15) : var16_15 != null), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 654));
        reference.$plus$eq(null);
        months.putInt(3, 20);
        microseconds.putLong(3, 0L);
        reference.$plus$eq((Object)new CalendarInterval(20, 0L));
        ((ResizableArray)reference.zipWithIndex(ArrayBuffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                CalendarInterval v = (CalendarInterval)tuple2._1();
                int i = tuple2._2$mcI$sp();
                String errMsg = new StringBuilder(11).append("VectorType=").append(column.getClass().getSimpleName()).toString();
                CalendarInterval $org_scalatest_assert_macro_left = v;
                CalendarInterval $org_scalatest_assert_macro_right = column.getInterval(i);
                CalendarInterval calendarInterval = $org_scalatest_assert_macro_left;
                CalendarInterval calendarInterval2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(calendarInterval != null ? !calendarInterval.equals(calendarInterval2) : calendarInterval2 != null), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)errMsg, Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 663));
                if (v == null) {
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(column.isNullAt(i), "column.isNullAt(i)", Prettifier$.MODULE$.default());
                    boxedUnit = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)errMsg, Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 664));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return boxedUnit2;
        });
        column.close();
    }

    public static final /* synthetic */ void $anonfun$new$31(ColumnarBatchSuite $this, WritableColumnVector column) {
        WritableColumnVector data = column.arrayData();
        for (int i = 0; i < 6; ++i) {
            data.putInt(i, i);
        }
        column.putArray(0, 0, 1);
        column.putArray(1, 1, 2);
        column.putNull(2);
        column.putArray(3, 3, 0);
        column.putArray(4, 3, 3);
        int $org_scalatest_assert_macro_left = column.getArray(0).numElements();
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 688));
        int $org_scalatest_assert_macro_left2 = column.getArray(1).numElements();
        int $org_scalatest_assert_macro_right2 = 2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 689));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(column.isNullAt(2), "column.isNullAt(2)", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 690));
        ColumnarArray $org_scalatest_assert_macro_left3 = column.getArray(2);
        Object $org_scalatest_assert_macro_right3 = null;
        ColumnarArray columnarArray = $org_scalatest_assert_macro_left3;
        Object var14_13 = null;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", null, !(columnarArray != null ? !columnarArray.equals(var14_13) : var14_13 != null), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 691));
        int $org_scalatest_assert_macro_left4 = column.getArray(3).numElements();
        int $org_scalatest_assert_macro_right4 = 0;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 692));
        int $org_scalatest_assert_macro_left5 = column.getArray(4).numElements();
        int $org_scalatest_assert_macro_right5 = 3;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 693));
        int[] a1 = ColumnVectorUtils.toJavaIntArray((ColumnarArray)column.getArray(0));
        int[] a2 = ColumnVectorUtils.toJavaIntArray((ColumnarArray)column.getArray(1));
        int[] a3 = ColumnVectorUtils.toJavaIntArray((ColumnarArray)column.getArray(3));
        int[] a4 = ColumnVectorUtils.toJavaIntArray((ColumnarArray)column.getArray(4));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(a1);
        int[] $org_scalatest_assert_macro_right6 = new int[]{0};
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 699));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = $this.convertToEqualizer(a2);
        int[] $org_scalatest_assert_macro_right7 = new int[]{1, 2};
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 700));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = $this.convertToEqualizer(a3);
        int[] $org_scalatest_assert_macro_right8 = (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int());
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 701));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = $this.convertToEqualizer(a4);
        int[] $org_scalatest_assert_macro_right9 = new int[]{3, 4, 5};
        Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 702));
        int $org_scalatest_assert_macro_left10 = column.getArray(0).getInt(0);
        int $org_scalatest_assert_macro_right10 = 0;
        Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left10), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10 == $org_scalatest_assert_macro_right10, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 705));
        int $org_scalatest_assert_macro_left11 = column.getArray(1).getInt(0);
        int $org_scalatest_assert_macro_right11 = 1;
        Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left11), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11 == $org_scalatest_assert_macro_right11, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 707));
        int $org_scalatest_assert_macro_left12 = column.getArray(1).getInt(1);
        int $org_scalatest_assert_macro_right12 = 2;
        Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left12), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12 == $org_scalatest_assert_macro_right12, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 708));
        int $org_scalatest_assert_macro_left13 = column.getArray(4).getInt(0);
        int $org_scalatest_assert_macro_right13 = 3;
        Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left13), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right13), $org_scalatest_assert_macro_left13 == $org_scalatest_assert_macro_right13, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 710));
        int $org_scalatest_assert_macro_left14 = column.getArray(4).getInt(1);
        int $org_scalatest_assert_macro_right14 = 4;
        Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left14), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right14), $org_scalatest_assert_macro_left14 == $org_scalatest_assert_macro_right14, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 711));
        int $org_scalatest_assert_macro_left15 = column.getArray(4).getInt(2);
        int $org_scalatest_assert_macro_right15 = 5;
        Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left15), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right15), $org_scalatest_assert_macro_left15 == $org_scalatest_assert_macro_right15, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 712));
        column.reset();
        int[] array = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
        int $org_scalatest_assert_macro_left16 = data.capacity;
        int $org_scalatest_assert_macro_right16 = 10;
        Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left16), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right16), $org_scalatest_assert_macro_left16 == $org_scalatest_assert_macro_right16, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 717));
        data.reserve(array.length);
        int $org_scalatest_assert_macro_left17 = data.capacity;
        int $org_scalatest_assert_macro_right17 = array.length * 2;
        Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left17), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right17), $org_scalatest_assert_macro_left17 == $org_scalatest_assert_macro_right17, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 719));
        data.putInts(0, array.length, array, 0);
        column.putArray(0, 0, array.length);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left18 = $this.convertToEqualizer(ColumnVectorUtils.toJavaIntArray((ColumnarArray)column.getArray(0)));
        int[] $org_scalatest_assert_macro_right18 = array;
        Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left18, "===", (Object)$org_scalatest_assert_macro_right18, $org_scalatest_assert_macro_left18.$eq$eq$eq((Object)$org_scalatest_assert_macro_right18, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 722));
    }

    public static final /* synthetic */ void $anonfun$new$34(WritableColumnVector columnBool$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        boolean v = tuple2._1$mcZ$sp();
        int i = tuple2._2$mcI$sp();
        columnBool$1.arrayData().putBoolean(i, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$35(WritableColumnVector columnByte$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        byte v = BoxesRunTime.unboxToByte((Object)tuple2._1());
        int i = tuple2._2$mcI$sp();
        columnByte$1.arrayData().putByte(i, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$36(WritableColumnVector columnShort$1, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        short v = BoxesRunTime.unboxToShort((Object)tuple2._1());
        int i = tuple2._2$mcI$sp();
        columnShort$1.arrayData().putShort(i, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$37(WritableColumnVector columnInt$1, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int v = tuple2._1$mcI$sp();
        int i = tuple2._2$mcI$sp();
        columnInt$1.arrayData().putInt(i, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$38(WritableColumnVector columnLong$1, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long v = tuple2._1$mcJ$sp();
        int i = tuple2._2$mcI$sp();
        columnLong$1.arrayData().putLong(i, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$39(WritableColumnVector columnFloat$1, Tuple2 x0$7) {
        Tuple2 tuple2 = x0$7;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        float v = BoxesRunTime.unboxToFloat((Object)tuple2._1());
        int i = tuple2._2$mcI$sp();
        columnFloat$1.arrayData().putFloat(i, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$40(WritableColumnVector columnDouble$1, Tuple2 x0$8) {
        Tuple2 tuple2 = x0$8;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double v = tuple2._1$mcD$sp();
        int i = tuple2._2$mcI$sp();
        columnDouble$1.arrayData().putDouble(i, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$33(ColumnarBatchSuite $this, MemoryMode memMode) {
        int len = 4;
        WritableColumnVector columnBool = $this.allocate(len, (DataType)new ArrayType((DataType)BooleanType$.MODULE$, false), memMode);
        boolean[] boolArray = new boolean[]{false, true, false, true};
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofBoolean(Predef$.MODULE$.booleanArrayOps(boolArray)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ColumnarBatchSuite.$anonfun$new$34(columnBool, x0$2);
            return BoxedUnit.UNIT;
        });
        columnBool.putArray(0, 0, len);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(columnBool.getArray(0).toBooleanArray());
        boolean[] $org_scalatest_assert_macro_right = boolArray;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 733));
        columnBool.close();
        WritableColumnVector columnByte = $this.allocate(len, (DataType)new ArrayType((DataType)ByteType$.MODULE$, false), memMode);
        byte[] byteArray = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 1, 2, 3}), ClassTag$.MODULE$.Byte());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(byteArray)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            ColumnarBatchSuite.$anonfun$new$35(columnByte, x0$3);
            return BoxedUnit.UNIT;
        });
        columnByte.putArray(0, 0, len);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(columnByte.getArray(0).toByteArray());
        byte[] $org_scalatest_assert_macro_right2 = byteArray;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 740));
        columnByte.close();
        WritableColumnVector columnShort = $this.allocate(len, (DataType)new ArrayType((DataType)ShortType$.MODULE$, false), memMode);
        short[] shortArray = (short[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapShortArray(new short[]{0, 1, 2, 3}), ClassTag$.MODULE$.Short());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofShort(Predef$.MODULE$.shortArrayOps(shortArray)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
            ColumnarBatchSuite.$anonfun$new$36(columnShort, x0$4);
            return BoxedUnit.UNIT;
        });
        columnShort.putArray(0, 0, len);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(columnShort.getArray(0).toShortArray());
        short[] $org_scalatest_assert_macro_right3 = shortArray;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 747));
        columnShort.close();
        WritableColumnVector columnInt = $this.allocate(len, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), memMode);
        int[] intArray = new int[]{0, 1, 2, 3};
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(intArray)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
            ColumnarBatchSuite.$anonfun$new$37(columnInt, x0$5);
            return BoxedUnit.UNIT;
        });
        columnInt.putArray(0, 0, len);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(columnInt.getArray(0).toIntArray());
        int[] $org_scalatest_assert_macro_right4 = intArray;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 754));
        columnInt.close();
        WritableColumnVector columnLong = $this.allocate(len, (DataType)new ArrayType((DataType)LongType$.MODULE$, false), memMode);
        long[] longArray = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 1L, 2L, 3L}), ClassTag$.MODULE$.Long());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(longArray)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$6 -> {
            ColumnarBatchSuite.$anonfun$new$38(columnLong, x0$6);
            return BoxedUnit.UNIT;
        });
        columnLong.putArray(0, 0, len);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(columnLong.getArray(0).toLongArray());
        long[] $org_scalatest_assert_macro_right5 = longArray;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 761));
        columnLong.close();
        WritableColumnVector columnFloat = $this.allocate(len, (DataType)new ArrayType((DataType)FloatType$.MODULE$, false), memMode);
        float[] floatArray = new float[]{0.0f, 1.1f, 2.2f, 3.3f};
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(floatArray)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$7 -> {
            ColumnarBatchSuite.$anonfun$new$39(columnFloat, x0$7);
            return BoxedUnit.UNIT;
        });
        columnFloat.putArray(0, 0, len);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(columnFloat.getArray(0).toFloatArray());
        float[] $org_scalatest_assert_macro_right6 = floatArray;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 768));
        columnFloat.close();
        WritableColumnVector columnDouble = $this.allocate(len, (DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), memMode);
        double[] doubleArray = new double[]{0.0, 1.1, 2.2, 3.3};
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleArray)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$8 -> {
            ColumnarBatchSuite.$anonfun$new$40(columnDouble, x0$8);
            return BoxedUnit.UNIT;
        });
        columnDouble.putArray(0, 0, len);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = $this.convertToEqualizer(columnDouble.getArray(0).toDoubleArray());
        double[] $org_scalatest_assert_macro_right7 = doubleArray;
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 775));
        columnDouble.close();
    }

    public static final /* synthetic */ void $anonfun$new$42(ColumnarBatchSuite $this, MemoryMode memMode) {
        WritableColumnVector column = $this.allocate(10, (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)IntegerType$.MODULE$, false), memMode);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)colIndex -> {
            WritableColumnVector data = column.getChild(colIndex);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> data.putInt(i, i * (colIndex + 1)));
        });
        column.putArray(0, 0, 1);
        column.putArray(1, 1, 2);
        column.putNull(2);
        ColumnarMap $org_scalatest_assert_macro_left = column.getMap(2);
        Object $org_scalatest_assert_macro_right = null;
        ColumnarMap columnarMap = $org_scalatest_assert_macro_left;
        Object var6_5 = null;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", null, !(columnarMap != null ? !columnarMap.equals(var6_5) : var6_5 != null), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 794));
        column.putArray(3, 3, 0);
        column.putArray(4, 3, 3);
        int $org_scalatest_assert_macro_left2 = column.getMap(0).numElements();
        int $org_scalatest_assert_macro_right2 = 1;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 798));
        int $org_scalatest_assert_macro_left3 = column.getMap(1).numElements();
        int $org_scalatest_assert_macro_right3 = 2;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 799));
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(column.isNullAt(2), "column.isNullAt(2)", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 800));
        int $org_scalatest_assert_macro_left4 = column.getMap(3).numElements();
        int $org_scalatest_assert_macro_right4 = 0;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 801));
        int $org_scalatest_assert_macro_left5 = column.getMap(4).numElements();
        int $org_scalatest_assert_macro_right5 = 3;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 802));
        Map a1 = ColumnVectorUtils.toJavaIntMap((ColumnarMap)column.getMap(0));
        Map a2 = ColumnVectorUtils.toJavaIntMap((ColumnarMap)column.getMap(1));
        Map a4 = ColumnVectorUtils.toJavaIntMap((ColumnarMap)column.getMap(3));
        Map a5 = ColumnVectorUtils.toJavaIntMap((ColumnarMap)column.getMap(4));
        scala.collection.mutable.Map $org_scalatest_assert_macro_left6 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(a1).asScala();
        scala.collection.immutable.Map $org_scalatest_assert_macro_right6 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)0))}));
        scala.collection.mutable.Map map = $org_scalatest_assert_macro_left6;
        scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right6;
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 809));
        scala.collection.mutable.Map $org_scalatest_assert_macro_left7 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(a2).asScala();
        scala.collection.immutable.Map $org_scalatest_assert_macro_right7 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToInteger((int)4))}));
        scala.collection.mutable.Map map3 = $org_scalatest_assert_macro_left7;
        scala.collection.immutable.Map map4 = $org_scalatest_assert_macro_right7;
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right7, !(map3 != null ? !map3.equals(map4) : map4 != null), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 810));
        scala.collection.mutable.Map $org_scalatest_assert_macro_left8 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(a4).asScala();
        scala.collection.immutable.Map $org_scalatest_assert_macro_right8 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Map map5 = $org_scalatest_assert_macro_left8;
        scala.collection.immutable.Map map6 = $org_scalatest_assert_macro_right8;
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right8, !(map5 != null ? !map5.equals(map6) : map6 != null), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 811));
        scala.collection.mutable.Map $org_scalatest_assert_macro_left9 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(a5).asScala();
        scala.collection.immutable.Map $org_scalatest_assert_macro_right9 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToInteger((int)6)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)BoxesRunTime.boxToInteger((int)8)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)BoxesRunTime.boxToInteger((int)10))}));
        scala.collection.mutable.Map map7 = $org_scalatest_assert_macro_left9;
        scala.collection.immutable.Map map8 = $org_scalatest_assert_macro_right9;
        Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right9, !(map7 != null ? !map7.equals(map8) : map8 != null), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 812));
        column.close();
    }

    public static final /* synthetic */ void $anonfun$new$45(ColumnarBatchSuite $this, WritableColumnVector column) {
        WritableColumnVector c1 = column.getChild(0);
        WritableColumnVector c2 = column.getChild(1);
        DataType $org_scalatest_assert_macro_left = c1.dataType();
        IntegerType$ $org_scalatest_assert_macro_right = IntegerType$.MODULE$;
        DataType dataType = $org_scalatest_assert_macro_left;
        IntegerType$ integerType$ = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(integerType$) : integerType$ != null), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 824));
        DataType $org_scalatest_assert_macro_left2 = c2.dataType();
        DoubleType$ $org_scalatest_assert_macro_right2 = DoubleType$.MODULE$;
        DataType dataType2 = $org_scalatest_assert_macro_left2;
        DoubleType$ doubleType$ = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType2 != null ? !dataType2.equals(doubleType$) : doubleType$ != null), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 825));
        c1.putInt(0, 123);
        c2.putDouble(0, 3.45);
        column.putNull(1);
        ColumnarRow $org_scalatest_assert_macro_left3 = column.getStruct(1);
        Object $org_scalatest_assert_macro_right3 = null;
        ColumnarRow columnarRow = $org_scalatest_assert_macro_left3;
        Object var15_14 = null;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", null, !(columnarRow != null ? !columnarRow.equals(var15_14) : var15_14 != null), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 831));
        c1.putInt(2, 456);
        c2.putDouble(2, 5.67);
        ColumnarRow s = column.getStruct(0);
        int $org_scalatest_assert_macro_left4 = s.getInt(0);
        int $org_scalatest_assert_macro_right4 = 123;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 837));
        double $org_scalatest_assert_macro_left5 = s.getDouble(1);
        double $org_scalatest_assert_macro_right5 = 3.45;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 838));
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(column.isNullAt(1), "column.isNullAt(1)", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 840));
        ColumnarRow $org_scalatest_assert_macro_left6 = column.getStruct(1);
        Object $org_scalatest_assert_macro_right6 = null;
        ColumnarRow columnarRow2 = $org_scalatest_assert_macro_left6;
        Object var29_26 = null;
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", null, !(columnarRow2 != null ? !columnarRow2.equals(var29_26) : var29_26 != null), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 841));
        ColumnarRow s2 = column.getStruct(2);
        int $org_scalatest_assert_macro_left7 = s2.getInt(0);
        int $org_scalatest_assert_macro_right7 = 456;
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 844));
        double $org_scalatest_assert_macro_left8 = s2.getDouble(1);
        double $org_scalatest_assert_macro_right8 = 5.67;
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left8), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8 == $org_scalatest_assert_macro_right8, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
    }

    public static final /* synthetic */ void $anonfun$new$46(ColumnarBatchSuite $this, WritableColumnVector column) {
        WritableColumnVector childColumn = column.arrayData();
        WritableColumnVector data = column.arrayData().arrayData();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x0$9 -> {
            int n = x0$9;
            switch (n) {
                case 3: {
                    data.putNull(3);
                    break;
                }
                default: {
                    data.putInt(n, n);
                    break;
                }
            }
        });
        childColumn.putArray(0, 0, 1);
        childColumn.putArray(1, 1, 2);
        childColumn.putArray(2, 2, 0);
        childColumn.putArray(3, 3, 3);
        column.putArray(0, 0, 1);
        column.putArray(1, 1, 2);
        column.putArray(2, 2, 2);
        column.putNull(3);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(column.getArray(0).getArray(0).toIntArray());
        int[] $org_scalatest_assert_macro_right = new int[]{0};
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 867));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(column.getArray(1).getArray(0).toIntArray());
        int[] $org_scalatest_assert_macro_right2 = new int[]{1, 2};
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 868));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(column.getArray(1).getArray(1).toIntArray());
        Object[] $org_scalatest_assert_macro_right3 = (Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Nothing());
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 869));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(column.getArray(2).getArray(0).toIntArray());
        Object[] $org_scalatest_assert_macro_right4 = (Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Nothing());
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 870));
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(column.getArray(2).getArray(1).isNullAt(0), "column.getArray(2).getArray(1).isNullAt(0)", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 871));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)column.getArray(2).getArray(1).getInt(1)));
        int $org_scalatest_assert_macro_right5 = 4;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 872));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)column.getArray(2).getArray(1).getInt(2)));
        int $org_scalatest_assert_macro_right6 = 5;
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 873));
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(column.isNullAt(3), "column.isNullAt(3)", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 874));
    }

    public static final /* synthetic */ void $anonfun$new$48(ColumnarBatchSuite $this, WritableColumnVector column) {
        WritableColumnVector data = column.arrayData();
        WritableColumnVector c0 = data.getChild(0);
        WritableColumnVector c1 = data.getChild(1);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            c0.putInt(i, i);
            c1.putLong(i, (long)(i * 10));
        });
        column.putArray(0, 0, 2);
        column.putArray(1, 1, 3);
        column.putArray(2, 4, 2);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(column.getArray(0).getStruct(0, 2).toSeq($this.structType()));
        Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 0}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 897));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(column.getArray(0).getStruct(1, 2).toSeq($this.structType()));
        Seq $org_scalatest_assert_macro_right2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 10}));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 898));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(column.getArray(1).getStruct(0, 2).toSeq($this.structType()));
        Seq $org_scalatest_assert_macro_right3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 10}));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 899));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(column.getArray(1).getStruct(1, 2).toSeq($this.structType()));
        Seq $org_scalatest_assert_macro_right4 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 20}));
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 900));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(column.getArray(1).getStruct(2, 2).toSeq($this.structType()));
        Seq $org_scalatest_assert_macro_right5 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 30}));
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 901));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(column.getArray(2).getStruct(0, 2).toSeq($this.structType()));
        Seq $org_scalatest_assert_macro_right6 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 40}));
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 902));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = $this.convertToEqualizer(column.getArray(2).getStruct(1, 2).toSeq($this.structType()));
        Seq $org_scalatest_assert_macro_right7 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 50}));
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 903));
    }

    public static final /* synthetic */ void $anonfun$new$50(ColumnarBatchSuite $this, WritableColumnVector column) {
        WritableColumnVector c0 = column.getChild(0);
        WritableColumnVector c1 = column.getChild(1);
        c0.putInt(0, 0);
        c0.putInt(1, 1);
        c0.putInt(2, 2);
        WritableColumnVector c1Child = c1.arrayData();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> c1Child.putInt(i, i));
        c1.putArray(0, 0, 2);
        c1.putArray(1, 2, 1);
        c1.putArray(2, 3, 3);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)column.getStruct(0).getInt(0)));
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 926));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(column.getStruct(0).getArray(1).toIntArray());
        int[] $org_scalatest_assert_macro_right2 = new int[]{0, 1};
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 927));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)column.getStruct(1).getInt(0)));
        int $org_scalatest_assert_macro_right3 = 1;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 928));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(column.getStruct(1).getArray(1).toIntArray());
        int[] $org_scalatest_assert_macro_right4 = new int[]{2};
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 929));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)column.getStruct(2).getInt(0)));
        int $org_scalatest_assert_macro_right5 = 2;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 930));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(column.getStruct(2).getArray(1).toIntArray());
        int[] $org_scalatest_assert_macro_right6 = new int[]{3, 4, 5};
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 931));
    }

    public static final /* synthetic */ void $anonfun$new$52(ColumnarBatchSuite $this, WritableColumnVector column) {
        WritableColumnVector c0 = column.getChild(0);
        WritableColumnVector c1 = column.getChild(1);
        c0.putInt(0, 0);
        c0.putInt(1, 1);
        c0.putInt(2, 2);
        WritableColumnVector c1c0 = c1.getChild(0);
        WritableColumnVector c1c1 = c1.getChild(1);
        c1c0.putInt(0, 7);
        c1c0.putInt(1, 8);
        c1c0.putInt(2, 9);
        c1c1.putInt(0, 70);
        c1c1.putInt(1, 80);
        c1c1.putInt(2, 90);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)column.getStruct(0).getInt(0)));
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 956));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(column.getStruct(0).getStruct(1, 2).toSeq($this.subSchema()));
        Seq $org_scalatest_assert_macro_right2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 70}));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 957));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)column.getStruct(1).getInt(0)));
        int $org_scalatest_assert_macro_right3 = 1;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 958));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(column.getStruct(1).getStruct(1, 2).toSeq($this.subSchema()));
        Seq $org_scalatest_assert_macro_right4 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{8, 80}));
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 959));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)column.getStruct(2).getInt(0)));
        int $org_scalatest_assert_macro_right5 = 2;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 960));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(column.getStruct(2).getStruct(1, 2).toSeq($this.subSchema()));
        Seq $org_scalatest_assert_macro_right6 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{9, 90}));
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 961));
    }

    private final void rowEquals$1(InternalRow x, Row y) {
        block6: {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            boolean $org_scalatest_assert_macro_left = x.isNullAt(0);
            boolean $org_scalatest_assert_macro_right = y.isNullAt(0);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1034));
            if (!x.isNullAt(0)) {
                int $org_scalatest_assert_macro_left2 = x.getInt(0);
                int $org_scalatest_assert_macro_right2 = y.getInt(0);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                boxedUnit3 = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1035));
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            boolean $org_scalatest_assert_macro_left3 = x.isNullAt(1);
            boolean $org_scalatest_assert_macro_right3 = y.isNullAt(1);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1037));
            if (!x.isNullAt(1)) {
                double $org_scalatest_assert_macro_left4 = x.getDouble(1);
                double $org_scalatest_assert_macro_right4 = y.getDouble(1);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
                boxedUnit2 = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1038));
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            boolean $org_scalatest_assert_macro_left5 = x.isNullAt(2);
            boolean $org_scalatest_assert_macro_right5 = y.isNullAt(2);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1040));
            if (!x.isNullAt(2)) {
                int $org_scalatest_assert_macro_left6 = x.getInt(2);
                int $org_scalatest_assert_macro_right6 = y.getInt(2);
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
                boxedUnit = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1041));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            boolean $org_scalatest_assert_macro_left7 = x.isNullAt(3);
            boolean $org_scalatest_assert_macro_right7 = y.isNullAt(3);
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1043));
            if (x.isNullAt(3)) break block6;
            String $org_scalatest_assert_macro_left8 = x.getString(3);
            String $org_scalatest_assert_macro_right8 = y.getString(3);
            String string = $org_scalatest_assert_macro_left8;
            String string2 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right8, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1044));
        }
    }

    public static final /* synthetic */ void $anonfun$new$54(ColumnarBatchSuite $this, MemoryMode memMode) {
        StructType schema = new StructType().add("intCol", (DataType)IntegerType$.MODULE$).add("doubleCol", (DataType)DoubleType$.MODULE$).add("intCol2", (DataType)IntegerType$.MODULE$).add("string", (DataType)BinaryType$.MODULE$);
        int capacity = 4096;
        WritableColumnVector[] columns = (WritableColumnVector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)field -> $this.allocate(capacity, field.dataType(), memMode), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(WritableColumnVector.class)));
        ColumnarBatch batch = new ColumnarBatch((ColumnVector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columns)).toArray(ClassTag$.MODULE$.apply(ColumnVector.class)));
        int $org_scalatest_assert_macro_left = batch.numCols();
        int $org_scalatest_assert_macro_right = 4;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 977));
        int $org_scalatest_assert_macro_left2 = batch.numRows();
        int $org_scalatest_assert_macro_right2 = 0;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 978));
        boolean $org_scalatest_assert_macro_left3 = batch.rowIterator().hasNext();
        boolean $org_scalatest_assert_macro_right3 = false;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 979));
        columns[0].putInt(0, 1);
        columns[1].putDouble(0, 1.1);
        columns[2].putNull(0);
        columns[3].putByteArray(0, "Hello".getBytes(StandardCharsets.UTF_8));
        batch.setNumRows(1);
        int $org_scalatest_assert_macro_left4 = batch.numCols();
        int $org_scalatest_assert_macro_right4 = 4;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 989));
        int $org_scalatest_assert_macro_left5 = batch.numRows();
        int $org_scalatest_assert_macro_right5 = 1;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 990));
        boolean $org_scalatest_assert_macro_left6 = batch.rowIterator().hasNext();
        boolean $org_scalatest_assert_macro_right6 = true;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 991));
        boolean $org_scalatest_assert_macro_left7 = batch.rowIterator().hasNext();
        boolean $org_scalatest_assert_macro_right7 = true;
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 992));
        int $org_scalatest_assert_macro_left8 = columns[0].getInt(0);
        int $org_scalatest_assert_macro_right8 = 1;
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8 == $org_scalatest_assert_macro_right8, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 994));
        boolean $org_scalatest_assert_macro_left9 = columns[0].isNullAt(0);
        boolean $org_scalatest_assert_macro_right9 = false;
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left9), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9 == $org_scalatest_assert_macro_right9, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 995));
        double $org_scalatest_assert_macro_left10 = columns[1].getDouble(0);
        double $org_scalatest_assert_macro_right10 = 1.1;
        Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left10), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10 == $org_scalatest_assert_macro_right10, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 996));
        boolean $org_scalatest_assert_macro_left11 = columns[1].isNullAt(0);
        boolean $org_scalatest_assert_macro_right11 = false;
        Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left11), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11 == $org_scalatest_assert_macro_right11, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 997));
        boolean $org_scalatest_assert_macro_left12 = columns[2].isNullAt(0);
        boolean $org_scalatest_assert_macro_right12 = true;
        Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left12), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12 == $org_scalatest_assert_macro_right12, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 998));
        String $org_scalatest_assert_macro_left13 = columns[3].getUTF8String(0).toString();
        String $org_scalatest_assert_macro_right13 = "Hello";
        String string = $org_scalatest_assert_macro_left13;
        String string2 = $org_scalatest_assert_macro_right13;
        Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", (Object)$org_scalatest_assert_macro_right13, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 999));
        java.util.Iterator it = batch.rowIterator();
        Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.simpleMacroBool(it.hasNext(), "it.hasNext()", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1003));
        InternalRow row = (InternalRow)it.next();
        int $org_scalatest_assert_macro_left14 = row.getInt(0);
        int $org_scalatest_assert_macro_right14 = 1;
        Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left14), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right14), $org_scalatest_assert_macro_left14 == $org_scalatest_assert_macro_right14, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1005));
        boolean $org_scalatest_assert_macro_left15 = row.isNullAt(0);
        boolean $org_scalatest_assert_macro_right15 = false;
        Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left15), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right15), $org_scalatest_assert_macro_left15 == $org_scalatest_assert_macro_right15, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1006));
        double $org_scalatest_assert_macro_left16 = row.getDouble(1);
        double $org_scalatest_assert_macro_right16 = 1.1;
        Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left16), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right16), $org_scalatest_assert_macro_left16 == $org_scalatest_assert_macro_right16, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1007));
        boolean $org_scalatest_assert_macro_left17 = row.isNullAt(1);
        boolean $org_scalatest_assert_macro_right17 = false;
        Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left17), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right17), $org_scalatest_assert_macro_left17 == $org_scalatest_assert_macro_right17, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1008));
        boolean $org_scalatest_assert_macro_left18 = row.isNullAt(2);
        boolean $org_scalatest_assert_macro_right18 = true;
        Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left18), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right18), $org_scalatest_assert_macro_left18 == $org_scalatest_assert_macro_right18, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1009));
        String $org_scalatest_assert_macro_left19 = columns[3].getUTF8String(0).toString();
        String $org_scalatest_assert_macro_right19 = "Hello";
        String string3 = $org_scalatest_assert_macro_left19;
        String string4 = $org_scalatest_assert_macro_right19;
        Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left19, "==", (Object)$org_scalatest_assert_macro_right19, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1010));
        boolean $org_scalatest_assert_macro_left20 = it.hasNext();
        boolean $org_scalatest_assert_macro_right20 = false;
        Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left20), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right20), $org_scalatest_assert_macro_left20 == $org_scalatest_assert_macro_right20, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1011));
        boolean $org_scalatest_assert_macro_left21 = it.hasNext();
        boolean $org_scalatest_assert_macro_right21 = false;
        Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left21), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right21), $org_scalatest_assert_macro_left21 == $org_scalatest_assert_macro_right21, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1012));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columns)).foreach((Function1 & Serializable & scala.Serializable)x$81 -> {
            x$81.reset();
            return BoxedUnit.UNIT;
        });
        columns[0].putNull(0);
        columns[1].putDouble(0, 2.2);
        columns[2].putInt(0, 2);
        columns[3].putByteArray(0, "abc".getBytes(StandardCharsets.UTF_8));
        columns[0].putInt(1, 3);
        columns[1].putNull(1);
        columns[2].putInt(1, 3);
        columns[3].putByteArray(1, "".getBytes(StandardCharsets.UTF_8));
        columns[0].putInt(2, 4);
        columns[1].putDouble(2, 4.4);
        columns[2].putInt(2, 4);
        columns[3].putByteArray(2, "world".getBytes(StandardCharsets.UTF_8));
        batch.setNumRows(3);
        int $org_scalatest_assert_macro_left22 = batch.numRows();
        int $org_scalatest_assert_macro_right22 = 3;
        Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left22), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right22), $org_scalatest_assert_macro_left22 == $org_scalatest_assert_macro_right22, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1048));
        java.util.Iterator it2 = batch.rowIterator();
        $this.rowEquals$1((InternalRow)it2.next(), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)2.2), BoxesRunTime.boxToInteger((int)2), "abc"})));
        $this.rowEquals$1((InternalRow)it2.next(), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, BoxesRunTime.boxToInteger((int)3), ""})));
        $this.rowEquals$1((InternalRow)it2.next(), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToDouble((double)4.4), BoxesRunTime.boxToInteger((int)4), "world"})));
        Bool $org_scalatest_assert_macro_expr24 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(it.hasNext(), "it.hasNext()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr24, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1053));
        batch.close();
    }

    public static final /* synthetic */ void $anonfun$new$58(ColumnarBatchSuite $this, MemoryMode memMode) {
        Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)2L), "a", BoxesRunTime.boxToDouble((double)1.2), BoxesRunTime.boxToByte((byte)((byte)98))}));
        Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToLong((long)5L), "cd", BoxesRunTime.boxToDouble((double)2.3), BoxesRunTime.boxToByte((byte)((byte)97))}));
        List rows = Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row);
        StructType schema = new StructType().add("i1", (DataType)IntegerType$.MODULE$).add("l2", (DataType)LongType$.MODULE$).add("string", (DataType)StringType$.MODULE$).add("d", (DataType)DoubleType$.MODULE$).add("b", (DataType)ByteType$.MODULE$);
        ColumnarBatch batch = ColumnVectorUtils.toBatch((StructType)schema, (MemoryMode)memMode, (java.util.Iterator)((java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(rows.iterator()).asJava()));
        int $org_scalatest_assert_macro_left = batch.numRows();
        int $org_scalatest_assert_macro_right = 2;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1143));
        int $org_scalatest_assert_macro_left2 = batch.numCols();
        int $org_scalatest_assert_macro_right2 = 5;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1144));
        java.util.Iterator it = batch.rowIterator();
        Iterator referenceIt = rows.iterator();
        while (it.hasNext()) {
            $this.compareStruct((Seq<StructField>)schema, (InternalRow)it.next(), (Row)referenceIt.next(), 0L);
        }
        batch.close();
    }

    public static final /* synthetic */ void $anonfun$testRandomRows$1(ColumnarBatchSuite $this, StructType schema$1, ArrayBuffer rows$1, int NUM_ROWS$1, long seed$7, MemoryMode memMode) {
        ColumnarBatch batch = ColumnVectorUtils.toBatch((StructType)schema$1, (MemoryMode)memMode, (java.util.Iterator)((java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(rows$1.iterator()).asJava()));
        int $org_scalatest_assert_macro_left = batch.numRows();
        int $org_scalatest_assert_macro_right = NUM_ROWS$1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1186));
        java.util.Iterator it = batch.rowIterator();
        Iterator referenceIt = rows$1.iterator();
        int k = 0;
        while (it.hasNext()) {
            $this.compareStruct((Seq<StructField>)schema$1, (InternalRow)it.next(), (Row)referenceIt.next(), seed$7);
            ++k;
        }
        batch.close();
    }

    public static final /* synthetic */ void $anonfun$new$67(ColumnarBatchSuite $this, WritableColumnVector column) {
        ArrayBuffer reference = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        int idx = 0;
        column.putDecimal(idx, new Decimal().set(10), 10);
        reference.$plus$eq((Object)new Decimal().set(10));
        column.putDecimal(++idx, new Decimal().set(20), 10);
        reference.$plus$eq((Object)new Decimal().set(20));
        column.putNull(++idx);
        Decimal $org_scalatest_assert_macro_left = column.getDecimal(idx, 10, 0);
        Object $org_scalatest_assert_macro_right = null;
        Decimal decimal = $org_scalatest_assert_macro_left;
        Object var7_6 = null;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", null, !(decimal != null ? !decimal.equals(var7_6) : var7_6 != null), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1288));
        reference.$plus$eq(null);
        column.putDecimal(++idx, new Decimal().set(30), 10);
        reference.$plus$eq((Object)new Decimal().set(30));
        ((ResizableArray)reference.zipWithIndex(ArrayBuffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$11 -> {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$11;
            if (tuple2 != null) {
                Decimal v = (Decimal)tuple2._1();
                int i = tuple2._2$mcI$sp();
                String errMsg = new StringBuilder(11).append("VectorType=").append(column.getClass().getSimpleName()).toString();
                Decimal $org_scalatest_assert_macro_left = v;
                Decimal $org_scalatest_assert_macro_right = column.getDecimal(i, 10, 0);
                Decimal decimal = $org_scalatest_assert_macro_left;
                Decimal decimal2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(decimal != null ? !decimal.equals(decimal2) : decimal2 != null), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)errMsg, Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1297));
                if (v == null) {
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(column.isNullAt(i), "column.isNullAt(i)", Prettifier$.MODULE$.default());
                    boxedUnit = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)errMsg, Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1298));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return boxedUnit2;
        });
        column.close();
    }

    public static final /* synthetic */ void $anonfun$new$69(ColumnarBatchSuite $this, WritableColumnVector column) {
        ArrayBuffer reference = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        int idx = 0;
        column.putByteArray(idx, "Hello".getBytes(StandardCharsets.UTF_8));
        reference.$plus$eq((Object)"Hello");
        column.putByteArray(++idx, "World".getBytes(StandardCharsets.UTF_8));
        reference.$plus$eq((Object)"World");
        column.putNull(++idx);
        reference.$plus$eq(null);
        column.putByteArray(++idx, "abc".getBytes(StandardCharsets.UTF_8));
        reference.$plus$eq((Object)"abc");
        ((ResizableArray)reference.zipWithIndex(ArrayBuffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$12 -> {
            Assertion assertion;
            Tuple2 tuple2 = x0$12;
            if (tuple2 != null) {
                String v = (String)tuple2._1();
                int i = tuple2._2$mcI$sp();
                String errMsg = new StringBuilder(11).append("VectorType=").append(column.getClass().getSimpleName()).toString();
                if (v != null) {
                    String $org_scalatest_assert_macro_left = v;
                    String $org_scalatest_assert_macro_right = new String(column.getBinary(i));
                    String string = $org_scalatest_assert_macro_left;
                    String string2 = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                    assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)errMsg, Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1327));
                } else {
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(column.isNullAt(i), "column.isNullAt(i)", Prettifier$.MODULE$.default());
                    $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)errMsg, Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1329));
                    byte[] $org_scalatest_assert_macro_left = column.getBinary(i);
                    Object $org_scalatest_assert_macro_right = null;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", null, $org_scalatest_assert_macro_left == null, Prettifier$.MODULE$.default());
                    assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)errMsg, Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1330));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Assertion assertion2 = assertion;
            return assertion2;
        });
        column.close();
    }

    public static final /* synthetic */ void $anonfun$new$71(ColumnarBatchSuite $this, WritableColumnVector column) {
        RuntimeException ex = (RuntimeException)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> column.reserve(-1), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1339));
        String $org_scalatest_assert_macro_left = ex.getMessage();
        String $org_scalatest_assert_macro_right = "Cannot reserve additional contiguous bytes in the vectorized reader (integer overflow)";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1340));
    }

    public ColumnarBatchSuite() {
        this.testVector("Null APIs", 1024, (DataType)IntegerType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable & scala.Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$1(this, column);
            return BoxedUnit.UNIT;
        });
        this.testVector("Byte APIs", 1024, (DataType)ByteType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable & scala.Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$5(this, column);
            return BoxedUnit.UNIT;
        });
        this.testVector("Short APIs", 1024, (DataType)ShortType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable & scala.Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$10(this, column);
            return BoxedUnit.UNIT;
        });
        this.testVector("Int APIs", 1024, (DataType)IntegerType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable & scala.Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$15(this, column);
            return BoxedUnit.UNIT;
        });
        this.testVector("Long APIs", 1024, (DataType)LongType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable & scala.Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$18(this, column);
            return BoxedUnit.UNIT;
        });
        this.testVector("Float APIs", 1024, (DataType)FloatType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable & scala.Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$21(this, column);
            return BoxedUnit.UNIT;
        });
        this.testVector("Double APIs", 1024, (DataType)DoubleType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable & scala.Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$24(this, column);
            return BoxedUnit.UNIT;
        });
        this.testVector("String APIs", 7, (DataType)StringType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable & scala.Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$27(this, column);
            return BoxedUnit.UNIT;
        });
        this.testVector("CalendarInterval APIs", 4, (DataType)CalendarIntervalType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable & scala.Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$29(this, column);
            return BoxedUnit.UNIT;
        });
        this.testVector("Int Array", 10, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable & scala.Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$31(this, column);
            return BoxedUnit.UNIT;
        });
        this.test("toArray for primitive types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MemoryMode memoryMode = MemoryMode.ON_HEAP;
            MemoryMode memoryMode2 = MemoryMode.OFF_HEAP;
            Nil$.MODULE$.$colon$colon((Object)memoryMode2).$colon$colon((Object)memoryMode).foreach((Function1 & Serializable & scala.Serializable)memMode -> {
                ColumnarBatchSuite.$anonfun$new$33(this, memMode);
                return BoxedUnit.UNIT;
            });
        }, new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 725));
        this.test("Int Map", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MemoryMode memoryMode = MemoryMode.ON_HEAP;
            MemoryMode memoryMode2 = MemoryMode.OFF_HEAP;
            Nil$.MODULE$.$colon$colon((Object)memoryMode2).$colon$colon((Object)memoryMode).foreach((Function1 & Serializable & scala.Serializable)memMode -> {
                ColumnarBatchSuite.$anonfun$new$42(this, memMode);
                return BoxedUnit.UNIT;
            });
        }, new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 780));
        this.testVector("Struct Column", 10, (DataType)new StructType().add("int", (DataType)IntegerType$.MODULE$).add("double", (DataType)DoubleType$.MODULE$), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable & scala.Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$45(this, column);
            return BoxedUnit.UNIT;
        });
        this.testVector("Nest Array in Array", 10, (DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable & scala.Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$46(this, column);
            return BoxedUnit.UNIT;
        });
        this.structType = new StructType().add("i", (DataType)IntegerType$.MODULE$).add("l", (DataType)LongType$.MODULE$);
        this.testVector("Nest Struct in Array", 10, (DataType)new ArrayType((DataType)this.structType(), true), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable & scala.Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$48(this, column);
            return BoxedUnit.UNIT;
        });
        this.testVector("Nest Array in Struct", 10, (DataType)new StructType().add("int", (DataType)IntegerType$.MODULE$).add("array", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true)), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable & scala.Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$50(this, column);
            return BoxedUnit.UNIT;
        });
        this.subSchema = new StructType().add("int", (DataType)IntegerType$.MODULE$).add("int", (DataType)IntegerType$.MODULE$);
        this.testVector("Nest Struct in Struct", 10, (DataType)new StructType().add("int", (DataType)IntegerType$.MODULE$).add("struct", (DataType)this.subSchema()), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable & scala.Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$52(this, column);
            return BoxedUnit.UNIT;
        });
        this.test("ColumnarBatch basic", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MemoryMode memoryMode = MemoryMode.ON_HEAP;
            MemoryMode memoryMode2 = MemoryMode.OFF_HEAP;
            Nil$.MODULE$.$colon$colon((Object)memoryMode2).$colon$colon((Object)memoryMode).foreach((Function1 & Serializable & scala.Serializable)memMode -> {
                ColumnarBatchSuite.$anonfun$new$54(this, memMode);
                return BoxedUnit.UNIT;
            });
        }, new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 964));
        this.test("Convert rows", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MemoryMode memoryMode = MemoryMode.ON_HEAP;
            MemoryMode memoryMode2 = MemoryMode.OFF_HEAP;
            Nil$.MODULE$.$colon$colon((Object)memoryMode2).$colon$colon((Object)memoryMode).foreach((Function1 & Serializable & scala.Serializable)memMode -> {
                ColumnarBatchSuite.$anonfun$new$58(this, memMode);
                return BoxedUnit.UNIT;
            });
        }, new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1132));
        this.test("Random flat schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testRandomRows(true, 15), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1201));
        this.test("Random nested schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testRandomRows(false, 30), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1205));
        this.test("exceeding maximum capacity should throw an error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MemoryMode memoryMode = MemoryMode.ON_HEAP;
            MemoryMode memoryMode2 = MemoryMode.OFF_HEAP;
            Nil$.MODULE$.$colon$colon((Object)memoryMode2).$colon$colon((Object)memoryMode).foreach((Function1 & Serializable & scala.Serializable)memMode -> {
                WritableColumnVector column = this.allocate(1, (DataType)ByteType$.MODULE$, (MemoryMode)memMode);
                column.MAX_CAPACITY = 15;
                column.appendBytes(5, (byte)0);
                int $org_scalatest_assert_macro_left = column.capacity;
                int $org_scalatest_assert_macro_right = 10;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1215));
                column.appendBytes(10, (byte)0);
                int $org_scalatest_assert_macro_left2 = column.capacity;
                int $org_scalatest_assert_macro_right2 = 15;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1218));
                RuntimeException ex = (RuntimeException)this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> column.appendBytes(10, (byte)0), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1219));
                String $org_scalatest_assert_macro_left3 = ex.getMessage();
                String $org_scalatest_assert_macro_right3 = new StringBuilder(67).append("Cannot reserve additional contiguous bytes in the ").append("vectorized reader").toString();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1223));
            });
        }, new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1209));
        this.test("create columnar batch from Arrow column vectors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BufferAllocator allocator = ArrowUtils$.MODULE$.rootAllocator().newChildAllocator("int", 0L, Long.MAX_VALUE);
            IntVector vector1 = (IntVector)ArrowUtils$.MODULE$.toArrowField("int1", (DataType)IntegerType$.MODULE$, true, null).createVector(allocator);
            vector1.allocateNew();
            IntVector vector2 = (IntVector)ArrowUtils$.MODULE$.toArrowField("int2", (DataType)IntegerType$.MODULE$, true, null).createVector(allocator);
            vector2.allocateNew();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                vector1.setSafe(i, i);
                vector2.setSafe(i + 1, i);
            });
            vector1.setNull(10);
            vector1.setValueCount(11);
            vector2.setNull(0);
            vector2.setValueCount(11);
            Seq columnVectors = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrowColumnVector[]{new ArrowColumnVector((ValueVector)vector1), new ArrowColumnVector((ValueVector)vector2)}));
            StructType schema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("int1", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("int2", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
            ColumnarBatch batch = new ColumnarBatch((ColumnVector[])columnVectors.toArray(ClassTag$.MODULE$.apply(ColumnVector.class)));
            batch.setNumRows(11);
            int $org_scalatest_assert_macro_left = batch.numCols();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1252));
            int $org_scalatest_assert_macro_left2 = batch.numRows();
            int $org_scalatest_assert_macro_right2 = 11;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1253));
            Iterator rowIter = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(batch.rowIterator()).asScala();
            rowIter.zipWithIndex().foreach((Function1 & Serializable & scala.Serializable)x0$10 -> {
                Assertion assertion;
                Tuple2 tuple2 = x0$10;
                if (tuple2 != null) {
                    Assertion assertion2;
                    InternalRow row = (InternalRow)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    if (i == 10) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(row.isNullAt(0), "row.isNullAt(0)", Prettifier$.MODULE$.default());
                        assertion2 = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1258));
                    } else {
                        int $org_scalatest_assert_macro_left = row.getInt(0);
                        int $org_scalatest_assert_macro_right = i;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                        assertion2 = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1260));
                    }
                    if (i == 0) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(row.isNullAt(1), "row.isNullAt(1)", Prettifier$.MODULE$.default());
                        assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1263));
                    } else {
                        int $org_scalatest_assert_macro_left = row.getInt(1);
                        int $org_scalatest_assert_macro_right = i - 1;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                        assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1265));
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Assertion assertion3 = assertion;
                return assertion3;
            });
            batch.close();
            allocator.close();
        }, new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1228));
        this.testVector("Decimal API", 4, (DataType)DecimalType$.MODULE$.IntDecimal(), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable & scala.Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$67(this, column);
            return BoxedUnit.UNIT;
        });
        this.testVector("Binary APIs", 4, (DataType)BinaryType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable & scala.Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$69(this, column);
            return BoxedUnit.UNIT;
        });
        this.testVector("WritableColumnVector.reserve(): requested capacity is negative", 1024, (DataType)ByteType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable & scala.Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$71(this, column);
            return BoxedUnit.UNIT;
        });
    }
}

