/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.benchmark.BenchmarkBase;
import org.apache.spark.util.Benchmark;
import org.apache.spark.util.Benchmark$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001)2Aa\u0001\u0003\u0001#!)!\u0004\u0001C\u00017!)Q\u0004\u0001C\u0001=\t9\u0002K]5nSRLg/Z!se\u0006L()\u001a8dQ6\f'o\u001b\u0006\u0003\u000b\u0019\t\u0011BY3oG\"l\u0017M]6\u000b\u0005\u001dA\u0011!C3yK\u000e,H/[8o\u0015\tI!\"A\u0002tc2T!a\u0003\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\r\u0001!C\u0006\t\u0003'Qi\u0011AC\u0005\u0003+)\u0011Qb\u00159be.4UO\\*vSR,\u0007CA\f\u0019\u001b\u0005!\u0011BA\r\u0005\u00055\u0011UM\\2i[\u0006\u00148NQ1tK\u00061A(\u001b8jiz\"\u0012\u0001\b\t\u0003/\u0001\t\u0011c\u001e:ji\u0016$\u0015\r^1tKR\f%O]1z)\tyR\u0005\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0003V]&$\b\"\u0002\u0014\u0003\u0001\u00049\u0013!B5uKJ\u001c\bC\u0001\u0011)\u0013\tI\u0013EA\u0002J]R\u0004")
public class PrimitiveArrayBenchmark
extends SparkFunSuite
implements BenchmarkBase {
    private SparkSession sparkSession;
    private volatile boolean bitmap$0;

    @Override
    public void runBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        BenchmarkBase.runBenchmark$(this, name, cardinality, f);
    }

    private SparkSession sparkSession$lzycompute() {
        PrimitiveArrayBenchmark primitiveArrayBenchmark = this;
        synchronized (primitiveArrayBenchmark) {
            if (!this.bitmap$0) {
                this.sparkSession = BenchmarkBase.sparkSession$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkSession;
    }

    @Override
    public SparkSession sparkSession() {
        return !this.bitmap$0 ? this.sparkSession$lzycompute() : this.sparkSession;
    }

    public void writeDatasetArray(int iters) {
        int count = 0x200000;
        SparkContext sc = this.sparkSession().sparkContext();
        int[] primitiveIntArray = (int[])Array$.MODULE$.fill(count, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 65535, ClassTag$.MODULE$.Int());
        Dataset dsInt = this.sparkSession().implicits().rddToDatasetHolder(sc.parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new int[][]{primitiveIntArray})), 1, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))), this.sparkSession().implicits().newIntArrayEncoder()).toDS();
        dsInt.count();
        JFunction1.mcVI.sp & Serializable & scala.Serializable intArray = (JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int len = 0;
            for (int n = 0; n < iters; ++n) {
                len += ((InternalRow[])dsInt.map((Function1 & Serializable & scala.Serializable)e -> e, this.sparkSession().implicits().newIntArrayEncoder()).queryExecution().toRdd().collect()).length;
            }
        };
        double[] primitiveDoubleArray = (double[])Array$.MODULE$.fill(count, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 65535.0, ClassTag$.MODULE$.Double());
        Dataset dsDouble = this.sparkSession().implicits().rddToDatasetHolder(sc.parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new double[][]{primitiveDoubleArray})), 1, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))), this.sparkSession().implicits().newDoubleArrayEncoder()).toDS();
        dsDouble.count();
        JFunction1.mcVI.sp & Serializable & scala.Serializable doubleArray = (JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int len = 0;
            for (int n = 0; n < iters; ++n) {
                len += ((InternalRow[])dsDouble.map((Function1 & Serializable & scala.Serializable)e -> e, this.sparkSession().implicits().newDoubleArrayEncoder()).queryExecution().toRdd().collect()).length;
            }
        };
        Benchmark benchmark = new Benchmark("Write an array in Dataset", (long)(count * iters), Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        benchmark.addCase("Int   ", benchmark.addCase$default$2(), (Function1)intArray);
        benchmark.addCase("Double", benchmark.addCase$default$2(), (Function1)doubleArray);
        benchmark.run();
    }

    public PrimitiveArrayBenchmark() {
        BenchmarkBase.$init$(this);
        this.ignore("Write an array in Dataset", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.writeDatasetArray(4), new Position("PrimitiveArrayBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
    }
}

