/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import org.apache.spark.MapOutputStatistics;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.exchange.ExchangeCoordinator;
import org.apache.spark.sql.execution.exchange.ExchangeCoordinator$;
import org.apache.spark.sql.execution.exchange.ReusedExchangeExec;
import org.apache.spark.sql.execution.exchange.ShuffleExchangeExec;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001B\b\u0011\u0001mAQA\n\u0001\u0005\u0002\u001dB\u0011B\u000b\u0001A\u0002\u0003\u0007I\u0011B\u0016\t\u0013Y\u0002\u0001\u0019!a\u0001\n\u00139\u0004\"C\u001f\u0001\u0001\u0004\u0005\t\u0015)\u0003-\u0011%q\u0004\u00011AA\u0002\u0013%1\u0006C\u0005@\u0001\u0001\u0007\t\u0019!C\u0005\u0001\"I!\t\u0001a\u0001\u0002\u0003\u0006K\u0001\f\u0005\u0006\u0007\u0002!\t\u0006\u0012\u0005\u0006\u000b\u0002!\t\u0006\u0012\u0005\u0006\r\u0002!Ia\u0012\u0005\b?\u0002\u0011\r\u0011\"\u0001a\u0011\u0019\t\u0007\u0001)A\u00059\")!\r\u0001C\u0001G\"9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M!\u0001G#yG\"\fgnZ3D_>\u0014H-\u001b8bi>\u00148+^5uK*\u0011\u0011CE\u0001\nKb,7-\u001e;j_:T!a\u0005\u000b\u0002\u0007M\fHN\u0003\u0002\u0016-\u0005)1\u000f]1sW*\u0011q\u0003G\u0001\u0007CB\f7\r[3\u000b\u0003e\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u000f!!\tib$D\u0001\u0015\u0013\tyBCA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003C\u0011j\u0011A\t\u0006\u0003Ga\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005\u0015\u0012#!\u0005\"fM>\u0014X-\u00118e\u0003\u001a$XM]!mY\u00061A(\u001b8jiz\"\u0012\u0001\u000b\t\u0003S\u0001i\u0011\u0001E\u0001\u001b_JLw-\u001b8bY\u0006\u001bG/\u001b<f'B\f'o[*fgNLwN\\\u000b\u0002YA\u0019Q\u0006\r\u001a\u000e\u00039R\u0011aL\u0001\u0006g\u000e\fG.Y\u0005\u0003c9\u0012aa\u00149uS>t\u0007CA\u001a5\u001b\u0005\u0011\u0012BA\u001b\u0013\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003yy'/[4j]\u0006d\u0017i\u0019;jm\u0016\u001c\u0006/\u0019:l'\u0016\u001c8/[8o?\u0012*\u0017\u000f\u0006\u00029wA\u0011Q&O\u0005\u0003u9\u0012A!\u00168ji\"9AhAA\u0001\u0002\u0004a\u0013a\u0001=%c\u0005YrN]5hS:\fG.Q2uSZ,7\u000b]1sWN+7o]5p]\u0002\n\u0001e\u001c:jO&t\u0017\r\\%ogR\fg\u000e^5bi\u0016$7\u000b]1sWN+7o]5p]\u0006!sN]5hS:\fG.\u00138ti\u0006tG/[1uK\u0012\u001c\u0006/\u0019:l'\u0016\u001c8/[8o?\u0012*\u0017\u000f\u0006\u00029\u0003\"9AHBA\u0001\u0002\u0004a\u0013!I8sS\u001eLg.\u00197J]N$\u0018M\u001c;jCR,Gm\u00159be.\u001cVm]:j_:\u0004\u0013!\u00032fM>\u0014X-\u00117m)\u0005A\u0014\u0001C1gi\u0016\u0014\u0018\t\u001c7\u0002\u001f\rDWmY6FgRLW.\u0019;j_:$B\u0001\u000f%Q3\")\u0011J\u0003a\u0001\u0015\u0006Y1m\\8sI&t\u0017\r^8s!\tYe*D\u0001M\u0015\ti\u0005#\u0001\u0005fq\u000eD\u0017M\\4f\u0013\tyEJA\nFq\u000eD\u0017M\\4f\u0007>|'\u000fZ5oCR|'\u000fC\u0003R\u0015\u0001\u0007!+A\fcsR,7OQ=QCJ$\u0018\u000e^5p]&#\u0017I\u001d:bsB\u0019QfU+\n\u0005Qs#!B!se\u0006L\bcA\u0017T-B\u0011QfV\u0005\u00031:\u0012A\u0001T8oO\")!L\u0003a\u00017\u0006iR\r\u001f9fGR,G\rU1si&$\u0018n\u001c8Ti\u0006\u0014H/\u00138eS\u000e,7\u000fE\u0002.'r\u0003\"!L/\n\u0005ys#aA%oi\u0006\u0011b.^7J]B,H\u000fU1si&$\u0018n\u001c8t+\u0005a\u0016a\u00058v[&s\u0007/\u001e;QCJ$\u0018\u000e^5p]N\u0004\u0013aC2iK\u000e\\\u0017I\\:xKJ$2\u0001\u000f3|\u0011\u0019)W\u0002\"a\u0001M\u00061\u0011m\u0019;vC2\u00042!L4j\u0013\tAgF\u0001\u0005=Eft\u0017-\\3?!\tQ\u0007P\u0004\u0002lm:\u0011A.\u001e\b\u0003[Rt!A\\:\u000f\u0005=\u0014X\"\u00019\u000b\u0005ET\u0012A\u0002\u001fs_>$h(C\u0001\u001a\u0013\t9\u0002$\u0003\u0002\u0016-%\u00111\u0003F\u0005\u0003oJ\tq\u0001]1dW\u0006<W-\u0003\u0002zu\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003oJAQ\u0001`\u0007A\u0002u\fa\"\u001a=qK\u000e$X\rZ!og^,'\u000fE\u0003\u007f\u0003\u000b\tYAD\u0002\u0000\u0003\u0007q1a\\A\u0001\u0013\u0005y\u0013BA</\u0013\u0011\t9!!\u0003\u0003\u0007M+\u0017O\u0003\u0002x]A\u00191'!\u0004\n\u0007\u0005=!CA\u0002S_^\f\u0001c^5uQN\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0015\u000fa\n)\"a\b\u0002$!9\u0011q\u0003\bA\u0002\u0005e\u0011!\u00014\u0011\u000b5\nYB\r\u001d\n\u0007\u0005uaFA\u0005Gk:\u001cG/[8oc!1\u0011\u0011\u0005\bA\u0002q\u000ba\u0004^1sO\u0016$h*^7Q_N$8\u000b[;gM2,\u0007+\u0019:uSRLwN\\:\t\u000f\u0005\u0015b\u00021\u0001\u0002(\u0005YR.\u001b8Ok6\u0004vn\u001d;TQV4g\r\\3QCJ$\u0018\u000e^5p]N\u00042!\f\u0019]\u0001")
public class ExchangeCoordinatorSuite
extends SparkFunSuite {
    private Option<SparkSession> originalActiveSparkSession;
    private Option<SparkSession> originalInstantiatedSparkSession;
    private final int numInputPartitions;

    private Option<SparkSession> originalActiveSparkSession() {
        return this.originalActiveSparkSession;
    }

    private void originalActiveSparkSession_$eq(Option<SparkSession> x$1) {
        this.originalActiveSparkSession = x$1;
    }

    private Option<SparkSession> originalInstantiatedSparkSession() {
        return this.originalInstantiatedSparkSession;
    }

    private void originalInstantiatedSparkSession_$eq(Option<SparkSession> x$1) {
        this.originalInstantiatedSparkSession = x$1;
    }

    public void beforeAll() {
        this.originalActiveSparkSession_$eq((Option<SparkSession>)SparkSession$.MODULE$.getActiveSession());
        this.originalInstantiatedSparkSession_$eq((Option<SparkSession>)SparkSession$.MODULE$.getDefaultSession());
        SparkSession$.MODULE$.clearActiveSession();
        SparkSession$.MODULE$.clearDefaultSession();
    }

    public void afterAll() {
        this.originalActiveSparkSession().foreach((Function1 & Serializable & scala.Serializable)ctx -> {
            SparkSession$.MODULE$.setActiveSession(ctx);
            return BoxedUnit.UNIT;
        });
        this.originalInstantiatedSparkSession().foreach((Function1 & Serializable & scala.Serializable)ctx -> {
            SparkSession$.MODULE$.setDefaultSession(ctx);
            return BoxedUnit.UNIT;
        });
    }

    private void checkEstimation(ExchangeCoordinator coordinator, long[][] bytesByPartitionIdArray, int[] expectedPartitionStartIndices) {
        MapOutputStatistics[] mapOutputStatistics = (MapOutputStatistics[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bytesByPartitionIdArray)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long[] bytesByPartitionId = (long[])tuple2._1();
            int index = tuple2._2$mcI$sp();
            MapOutputStatistics mapOutputStatistics = new MapOutputStatistics(index, bytesByPartitionId);
            return mapOutputStatistics;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(MapOutputStatistics.class)));
        int[] estimatedPartitionStartIndices = coordinator.estimatePartitionStartIndices(mapOutputStatistics);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(estimatedPartitionStartIndices);
        int[] $org_scalatest_assert_macro_right = expectedPartitionStartIndices;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
    }

    public int numInputPartitions() {
        return this.numInputPartitions;
    }

    public void checkAnswer(Function0<Dataset<Row>> actual, Seq<Row> expectedAnswer) {
        Option<String> option = QueryTest$.MODULE$.checkAnswer((Dataset<Row>)((Dataset)actual.apply()), expectedAnswer, QueryTest$.MODULE$.checkAnswer$default$3());
        if (option instanceof Some) {
            Some some = (Some)option;
            String errorMessage = (String)some.value();
            throw this.fail(errorMessage, new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
        }
        if (!None$.MODULE$.equals(option)) {
            throw new MatchError(option);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void withSparkSession(Function1<SparkSession, BoxedUnit> f, int targetNumPostShufflePartitions, Option<Object> minNumPostShufflePartitions) {
        SparkConf sparkConf;
        SparkConf sparkConf2 = new SparkConf(false).setMaster("local[*]").setAppName("test").set("spark.ui.enabled", "false").set("spark.driver.allowMultipleContexts", "true").set(SQLConf$.MODULE$.SHUFFLE_PARTITIONS().key(), "5").set(SQLConf$.MODULE$.ADAPTIVE_EXECUTION_ENABLED().key(), "true").set(SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key(), "-1").set(SQLConf$.MODULE$.SHUFFLE_TARGET_POSTSHUFFLE_INPUT_SIZE().key(), ((Object)BoxesRunTime.boxToInteger((int)targetNumPostShufflePartitions)).toString());
        Option<Object> option = minNumPostShufflePartitions;
        if (option instanceof Some) {
            Some some = (Some)option;
            int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
            sparkConf = sparkConf2.set(SQLConf$.MODULE$.SHUFFLE_MIN_NUM_POSTSHUFFLE_PARTITIONS().key(), ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString());
        } else if (None$.MODULE$.equals(option)) {
            sparkConf = sparkConf2.set(SQLConf$.MODULE$.SHUFFLE_MIN_NUM_POSTSHUFFLE_PARTITIONS().key(), "-1");
        } else {
            throw new MatchError(option);
        }
        SparkSession spark = SparkSession$.MODULE$.builder().config(sparkConf2).getOrCreate();
        try {
            f.apply((Object)spark);
        }
        finally {
            spark.stop();
        }
    }

    public static final /* synthetic */ void $anonfun$new$7(ExchangeCoordinatorSuite $this, Option minNumPostShufflePartitions$1, SparkSession spark) {
        Dataset df = spark.range(0L, 1000L, 1L, $this.numInputPartitions()).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id % 20 as key", "id as value"}));
        Dataset agg = df.groupBy("key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count();
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> agg, (Seq<Row>)Predef$.MODULE$.wrapRefArray((Object[])spark.range(0L, 20L).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "50 as cnt"})).collect()));
        Seq exchanges = agg.queryExecution().executedPlan().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                ShuffleExchangeExec shuffleExchangeExec;
                A1 A1 = x1;
                Object object = A1 instanceof ShuffleExchangeExec ? (shuffleExchangeExec = (ShuffleExchangeExec)A1) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan2 = x1;
                boolean bl = sparkPlan2 instanceof ShuffleExchangeExec;
                return bl;
            }
        });
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)exchanges.length()));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
        Option option = minNumPostShufflePartitions$1;
        if (option instanceof Some) {
            exchanges.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                BoxedUnit boxedUnit;
                ShuffleExchangeExec shuffleExchangeExec = x0$1;
                if (shuffleExchangeExec != null) {
                    ShuffleExchangeExec shuffleExchangeExec2 = shuffleExchangeExec;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(shuffleExchangeExec2.coordinator().isDefined(), "e.coordinator.isDefined", Prettifier$.MODULE$.default());
                    $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)shuffleExchangeExec2.outputPartitioning().numPartitions()));
                    int $org_scalatest_assert_macro_right = 5;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    boxedUnit = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            exchanges.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                BoxedUnit boxedUnit;
                ShuffleExchangeExec shuffleExchangeExec = x0$2;
                if (shuffleExchangeExec != null) {
                    ShuffleExchangeExec shuffleExchangeExec2 = shuffleExchangeExec;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(shuffleExchangeExec2.coordinator().isDefined(), "e.coordinator.isDefined", Prettifier$.MODULE$.default());
                    $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)shuffleExchangeExec2.outputPartitioning().numPartitions()));
                    int $org_scalatest_assert_macro_right = 3;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    boxedUnit = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ void $anonfun$new$12(ExchangeCoordinatorSuite $this, Option minNumPostShufflePartitions$1, SparkSession spark) {
        Dataset df1 = spark.range(0L, 1000L, 1L, $this.numInputPartitions()).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key1", "id as value1"}));
        Dataset df2 = spark.range(0L, 1000L, 1L, $this.numInputPartitions()).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key2", "id as value2"}));
        Dataset join = df1.join(df2, functions$.MODULE$.col("key1").$eq$eq$eq((Object)functions$.MODULE$.col("key2"))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("key1"), functions$.MODULE$.col("value2")}));
        Dataset expectedAnswer = spark.range(0L, 1000L).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key", "id as value"})).union(spark.range(0L, 1000L).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key", "id as value"})));
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> join, (Seq<Row>)Predef$.MODULE$.wrapRefArray((Object[])expectedAnswer.collect()));
        Seq exchanges = join.queryExecution().executedPlan().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                ShuffleExchangeExec shuffleExchangeExec;
                A1 A1 = x2;
                Object object = A1 instanceof ShuffleExchangeExec ? (shuffleExchangeExec = (ShuffleExchangeExec)A1) : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x2) {
                SparkPlan sparkPlan2 = x2;
                boolean bl = sparkPlan2 instanceof ShuffleExchangeExec;
                return bl;
            }
        });
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)exchanges.length()));
        int $org_scalatest_assert_macro_right = 2;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356));
        Option option = minNumPostShufflePartitions$1;
        if (option instanceof Some) {
            exchanges.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                BoxedUnit boxedUnit;
                ShuffleExchangeExec shuffleExchangeExec = x0$3;
                if (shuffleExchangeExec != null) {
                    ShuffleExchangeExec shuffleExchangeExec2 = shuffleExchangeExec;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(shuffleExchangeExec2.coordinator().isDefined(), "e.coordinator.isDefined", Prettifier$.MODULE$.default());
                    $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)shuffleExchangeExec2.outputPartitioning().numPartitions()));
                    int $org_scalatest_assert_macro_right = 5;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    boxedUnit = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            exchanges.foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                BoxedUnit boxedUnit;
                ShuffleExchangeExec shuffleExchangeExec = x0$4;
                if (shuffleExchangeExec != null) {
                    ShuffleExchangeExec shuffleExchangeExec2 = shuffleExchangeExec;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(shuffleExchangeExec2.coordinator().isDefined(), "e.coordinator.isDefined", Prettifier$.MODULE$.default());
                    $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 369));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)shuffleExchangeExec2.outputPartitioning().numPartitions()));
                    int $org_scalatest_assert_macro_right = 2;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    boxedUnit = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ boolean $anonfun$new$20(ShuffleExchangeExec x$1) {
        return x$1.coordinator().isDefined();
    }

    public static final /* synthetic */ int $anonfun$new$21(ShuffleExchangeExec x$2) {
        return x$2.outputPartitioning().numPartitions();
    }

    public static final /* synthetic */ void $anonfun$new$17(ExchangeCoordinatorSuite $this, Option minNumPostShufflePartitions$1, SparkSession spark) {
        Dataset df1 = spark.range(0L, 1000L, 1L, $this.numInputPartitions()).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key1", "id as value1"})).groupBy("key1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count().toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key1", "cnt1"}));
        Dataset df2 = spark.range(0L, 1000L, 1L, $this.numInputPartitions()).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key2", "id as value2"})).groupBy("key2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count().toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key2", "cnt2"}));
        Dataset join = df1.join(df2, functions$.MODULE$.col("key1").$eq$eq$eq((Object)functions$.MODULE$.col("key2"))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("key1"), functions$.MODULE$.col("cnt2")}));
        Dataset expectedAnswer = spark.range(0L, 500L).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "2 as cnt"}));
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> join, (Seq<Row>)Predef$.MODULE$.wrapRefArray((Object[])expectedAnswer.collect()));
        Seq exchanges = join.queryExecution().executedPlan().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                ShuffleExchangeExec shuffleExchangeExec;
                A1 A1 = x3;
                Object object = A1 instanceof ShuffleExchangeExec ? (shuffleExchangeExec = (ShuffleExchangeExec)A1) : function1.apply(x3);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x3) {
                SparkPlan sparkPlan2 = x3;
                boolean bl = sparkPlan2 instanceof ShuffleExchangeExec;
                return bl;
            }
        });
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)exchanges.length()));
        int $org_scalatest_assert_macro_right = 4;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 412));
        Option option = minNumPostShufflePartitions$1;
        if (option instanceof Some) {
            exchanges.foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
                BoxedUnit boxedUnit;
                ShuffleExchangeExec shuffleExchangeExec = x0$5;
                if (shuffleExchangeExec != null) {
                    ShuffleExchangeExec shuffleExchangeExec2 = shuffleExchangeExec;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(shuffleExchangeExec2.coordinator().isDefined(), "e.coordinator.isDefined", Prettifier$.MODULE$.default());
                    $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 417));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)shuffleExchangeExec2.outputPartitioning().numPartitions()));
                    int $org_scalatest_assert_macro_right = 5;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    boxedUnit = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 418));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(exchanges.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ExchangeCoordinatorSuite.$anonfun$new$20(x$1))), "exchanges.forall(((x$1: org.apache.spark.sql.execution.exchange.ShuffleExchangeExec) => x$1.coordinator.isDefined))", Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 423));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(((TraversableOnce)exchanges.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)ExchangeCoordinatorSuite.$anonfun$new$21(x$2)), Seq$.MODULE$.canBuildFrom())).toSet());
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ boolean $anonfun$new$26(ShuffleExchangeExec x$3) {
        return x$3.coordinator().isDefined();
    }

    public static final /* synthetic */ int $anonfun$new$27(ShuffleExchangeExec x$4) {
        return x$4.outputPartitioning().numPartitions();
    }

    public static final /* synthetic */ void $anonfun$new$23(ExchangeCoordinatorSuite $this, Option minNumPostShufflePartitions$1, SparkSession spark) {
        Dataset df1 = spark.range(0L, 1000L, 1L, $this.numInputPartitions()).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key1", "id as value1"})).groupBy("key1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count().toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key1", "cnt1"}));
        Dataset df2 = spark.range(0L, 1000L, 1L, $this.numInputPartitions()).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key2", "id as value2"}));
        Dataset join = df1.join(df2, functions$.MODULE$.col("key1").$eq$eq$eq((Object)functions$.MODULE$.col("key2"))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("key1"), functions$.MODULE$.col("cnt1"), functions$.MODULE$.col("value2")}));
        Dataset expectedAnswer = spark.range(0L, 1000L).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key", "2 as cnt", "id as value"}));
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> join, (Seq<Row>)Predef$.MODULE$.wrapRefArray((Object[])expectedAnswer.collect()));
        Seq exchanges = join.queryExecution().executedPlan().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                ShuffleExchangeExec shuffleExchangeExec;
                A1 A1 = x4;
                Object object = A1 instanceof ShuffleExchangeExec ? (shuffleExchangeExec = (ShuffleExchangeExec)A1) : function1.apply(x4);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x4) {
                SparkPlan sparkPlan2 = x4;
                boolean bl = sparkPlan2 instanceof ShuffleExchangeExec;
                return bl;
            }
        });
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)exchanges.length()));
        int $org_scalatest_assert_macro_right = 3;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 464));
        Option option = minNumPostShufflePartitions$1;
        if (option instanceof Some) {
            exchanges.foreach((Function1 & Serializable & scala.Serializable)x0$6 -> {
                BoxedUnit boxedUnit;
                ShuffleExchangeExec shuffleExchangeExec = x0$6;
                if (shuffleExchangeExec != null) {
                    ShuffleExchangeExec shuffleExchangeExec2 = shuffleExchangeExec;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(shuffleExchangeExec2.coordinator().isDefined(), "e.coordinator.isDefined", Prettifier$.MODULE$.default());
                    $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 469));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)shuffleExchangeExec2.outputPartitioning().numPartitions()));
                    int $org_scalatest_assert_macro_right = 5;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    boxedUnit = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 470));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(exchanges.forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ExchangeCoordinatorSuite.$anonfun$new$26(x$3))), "exchanges.forall(((x$3: org.apache.spark.sql.execution.exchange.ShuffleExchangeExec) => x$3.coordinator.isDefined))", Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 475));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(((TraversableOnce)exchanges.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)ExchangeCoordinatorSuite.$anonfun$new$27(x$4)), Seq$.MODULE$.canBuildFrom())).toSet());
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 3}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 476));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ void $anonfun$new$5(ExchangeCoordinatorSuite $this, Option minNumPostShufflePartitions) {
        String string;
        Option option = minNumPostShufflePartitions;
        if (option instanceof Some) {
            Some some = (Some)option;
            int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
            string = new StringBuilder(31).append("(minNumPostShufflePartitions: ").append(numPartitions).append(")").toString();
        } else if (None$.MODULE$.equals(option)) {
            string = "";
        } else {
            throw new MatchError((Object)option);
        }
        String testNameNote = string;
        $this.test(new StringBuilder(54).append("determining the number of reducers: aggregate operator").append(testNameNote).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Function1 & Serializable & scala.Serializable test = (Function1 & Serializable & scala.Serializable)spark -> {
                ExchangeCoordinatorSuite.$anonfun$new$7($this, minNumPostShufflePartitions, spark);
                return BoxedUnit.UNIT;
            };
            $this.withSparkSession((Function1<SparkSession, BoxedUnit>)test, 2000, (Option<Object>)minNumPostShufflePartitions);
        }, new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
        $this.test(new StringBuilder(49).append("determining the number of reducers: join operator").append(testNameNote).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Function1 & Serializable & scala.Serializable test = (Function1 & Serializable & scala.Serializable)spark -> {
                ExchangeCoordinatorSuite.$anonfun$new$12($this, minNumPostShufflePartitions, spark);
                return BoxedUnit.UNIT;
            };
            $this.withSparkSession((Function1<SparkSession, BoxedUnit>)test, 16384, (Option<Object>)minNumPostShufflePartitions);
        }, new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
        $this.test(new StringBuilder(51).append("determining the number of reducers: complex query 1").append(testNameNote).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Function1 & Serializable & scala.Serializable test = (Function1 & Serializable & scala.Serializable)spark -> {
                ExchangeCoordinatorSuite.$anonfun$new$17($this, minNumPostShufflePartitions, spark);
                return BoxedUnit.UNIT;
            };
            $this.withSparkSession((Function1<SparkSession, BoxedUnit>)test, 6644, (Option<Object>)minNumPostShufflePartitions);
        }, new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379));
        $this.test(new StringBuilder(51).append("determining the number of reducers: complex query 2").append(testNameNote).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Function1 & Serializable & scala.Serializable test = (Function1 & Serializable & scala.Serializable)spark -> {
                ExchangeCoordinatorSuite.$anonfun$new$23($this, minNumPostShufflePartitions, spark);
                return BoxedUnit.UNIT;
            };
            $this.withSparkSession((Function1<SparkSession, BoxedUnit>)test, 6144, (Option<Object>)minNumPostShufflePartitions);
        }, new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 431));
    }

    public static final /* synthetic */ void $anonfun$new$29(ExchangeCoordinatorSuite $this, SparkSession spark) {
        spark.sql("SET spark.sql.exchange.reuse=true");
        Dataset df = spark.range(1L).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id AS key", "id AS value"}));
        Dataset resultDf = df.join(df, "key").join(df, "key");
        SparkPlan sparkPlan2 = resultDf.queryExecution().executedPlan();
        Seq $org_scalatest_assert_macro_left = sparkPlan2.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                ReusedExchangeExec reusedExchangeExec;
                A1 A1 = x5;
                Object object = A1 instanceof ReusedExchangeExec ? (reusedExchangeExec = (ReusedExchangeExec)A1) : function1.apply(x5);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x5) {
                SparkPlan sparkPlan2 = x5;
                boolean bl = sparkPlan2 instanceof ReusedExchangeExec;
                return bl;
            }
        });
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 490));
        Seq $org_scalatest_assert_macro_left2 = sparkPlan2.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                ShuffleExchangeExec shuffleExchangeExec;
                Option option;
                A1 A1 = x6;
                Object object = A1 instanceof ShuffleExchangeExec && (option = (shuffleExchangeExec = (ShuffleExchangeExec)A1).coordinator()) instanceof Some ? shuffleExchangeExec : function1.apply(x6);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x6) {
                ShuffleExchangeExec shuffleExchangeExec;
                Option option;
                SparkPlan sparkPlan2 = x6;
                boolean bl = sparkPlan2 instanceof ShuffleExchangeExec && (option = (shuffleExchangeExec = (ShuffleExchangeExec)sparkPlan2).coordinator()) instanceof Some;
                return bl;
            }
        });
        int $org_scalatest_assert_macro_right2 = 3;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 491));
        Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)}));
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> resultDf, (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row));
    }

    public ExchangeCoordinatorSuite() {
        this.test("test estimatePartitionStartIndices - 1 Exchange", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ExchangeCoordinator coordinator = new ExchangeCoordinator(100L, ExchangeCoordinator$.MODULE$.$lessinit$greater$default$2());
            long[] bytesByPartitionId = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 0L, 0L, 0L, 0L}), ClassTag$.MODULE$.Long());
            int[] expectedPartitionStartIndices = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}), ClassTag$.MODULE$.Int());
            this.checkEstimation(coordinator, (long[][])((Object[])new long[][]{bytesByPartitionId}), expectedPartitionStartIndices);
            long[] bytesByPartitionId2 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{10L, 0L, 20L, 0L, 0L}), ClassTag$.MODULE$.Long());
            int[] expectedPartitionStartIndices2 = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}), ClassTag$.MODULE$.Int());
            this.checkEstimation(coordinator, (long[][])((Object[])new long[][]{bytesByPartitionId2}), expectedPartitionStartIndices2);
            long[] bytesByPartitionId3 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{10L, 0L, 90L, 20L, 0L}), ClassTag$.MODULE$.Long());
            int[] expectedPartitionStartIndices3 = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3}), ClassTag$.MODULE$.Int());
            this.checkEstimation(coordinator, (long[][])((Object[])new long[][]{bytesByPartitionId3}), expectedPartitionStartIndices3);
            long[] bytesByPartitionId4 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{110L, 10L, 100L, 110L, 0L}), ClassTag$.MODULE$.Long());
            int[] expectedPartitionStartIndices4 = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}), ClassTag$.MODULE$.Int());
            this.checkEstimation(coordinator, (long[][])((Object[])new long[][]{bytesByPartitionId4}), expectedPartitionStartIndices4);
            long[] bytesByPartitionId5 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{100L, 110L, 100L, 110L, 110L}), ClassTag$.MODULE$.Long());
            int[] expectedPartitionStartIndices5 = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}), ClassTag$.MODULE$.Int());
            this.checkEstimation(coordinator, (long[][])((Object[])new long[][]{bytesByPartitionId5}), expectedPartitionStartIndices5);
            long[] bytesByPartitionId6 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{30L, 30L, 0L, 40L, 110L}), ClassTag$.MODULE$.Long());
            int[] expectedPartitionStartIndices6 = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 4}), ClassTag$.MODULE$.Int());
            this.checkEstimation(coordinator, (long[][])((Object[])new long[][]{bytesByPartitionId6}), expectedPartitionStartIndices6);
        }, new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        this.test("test estimatePartitionStartIndices - 2 Exchanges", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ExchangeCoordinator coordinator = new ExchangeCoordinator(100L, ExchangeCoordinator$.MODULE$.$lessinit$greater$default$2());
            long[] bytesByPartitionId1 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 0L, 0L, 0L, 0L}), ClassTag$.MODULE$.Long());
            long[] bytesByPartitionId2 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 0L, 0L, 0L, 0L, 0L}), ClassTag$.MODULE$.Long());
            MapOutputStatistics[] mapOutputStatistics = (MapOutputStatistics[])((Object[])new MapOutputStatistics[]{new MapOutputStatistics(0, bytesByPartitionId1), new MapOutputStatistics(1, bytesByPartitionId2)});
            this.intercept((Function0 & Serializable & scala.Serializable)() -> coordinator.estimatePartitionStartIndices(mapOutputStatistics), ClassTag$.MODULE$.apply(AssertionError.class), new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
            long[] bytesByPartitionId12 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 0L, 0L, 0L, 0L}), ClassTag$.MODULE$.Long());
            long[] bytesByPartitionId22 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 0L, 0L, 0L, 0L}), ClassTag$.MODULE$.Long());
            int[] expectedPartitionStartIndices = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}), ClassTag$.MODULE$.Int());
            this.checkEstimation(coordinator, (long[][])((Object[])new long[][]{bytesByPartitionId12, bytesByPartitionId22}), expectedPartitionStartIndices);
            long[] bytesByPartitionId13 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 10L, 0L, 20L, 0L}), ClassTag$.MODULE$.Long());
            long[] bytesByPartitionId23 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{30L, 0L, 20L, 0L, 20L}), ClassTag$.MODULE$.Long());
            int[] expectedPartitionStartIndices2 = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}), ClassTag$.MODULE$.Int());
            this.checkEstimation(coordinator, (long[][])((Object[])new long[][]{bytesByPartitionId13, bytesByPartitionId23}), expectedPartitionStartIndices2);
            long[] bytesByPartitionId14 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 10L, 0L, 20L, 0L}), ClassTag$.MODULE$.Long());
            long[] bytesByPartitionId24 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{30L, 0L, 70L, 0L, 30L}), ClassTag$.MODULE$.Long());
            int[] expectedPartitionStartIndices3 = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 4}), ClassTag$.MODULE$.Int());
            this.checkEstimation(coordinator, (long[][])((Object[])new long[][]{bytesByPartitionId14, bytesByPartitionId24}), expectedPartitionStartIndices3);
            long[] bytesByPartitionId15 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 99L, 0L, 20L, 0L}), ClassTag$.MODULE$.Long());
            long[] bytesByPartitionId25 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{30L, 0L, 70L, 0L, 30L}), ClassTag$.MODULE$.Long());
            int[] expectedPartitionStartIndices4 = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 4}), ClassTag$.MODULE$.Int());
            this.checkEstimation(coordinator, (long[][])((Object[])new long[][]{bytesByPartitionId15, bytesByPartitionId25}), expectedPartitionStartIndices4);
            long[] bytesByPartitionId16 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 100L, 0L, 30L, 0L}), ClassTag$.MODULE$.Long());
            long[] bytesByPartitionId26 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{30L, 0L, 70L, 0L, 30L}), ClassTag$.MODULE$.Long());
            int[] expectedPartitionStartIndices5 = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 4}), ClassTag$.MODULE$.Int());
            this.checkEstimation(coordinator, (long[][])((Object[])new long[][]{bytesByPartitionId16, bytesByPartitionId26}), expectedPartitionStartIndices5);
            long[] bytesByPartitionId17 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 100L, 40L, 30L, 0L}), ClassTag$.MODULE$.Long());
            long[] bytesByPartitionId27 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{30L, 0L, 60L, 0L, 110L}), ClassTag$.MODULE$.Long());
            int[] expectedPartitionStartIndices6 = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}), ClassTag$.MODULE$.Int());
            this.checkEstimation(coordinator, (long[][])((Object[])new long[][]{bytesByPartitionId17, bytesByPartitionId27}), expectedPartitionStartIndices6);
            long[] bytesByPartitionId18 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{100L, 100L, 40L, 30L, 0L}), ClassTag$.MODULE$.Long());
            long[] bytesByPartitionId28 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{30L, 0L, 60L, 70L, 110L}), ClassTag$.MODULE$.Long());
            int[] expectedPartitionStartIndices7 = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}), ClassTag$.MODULE$.Int());
            this.checkEstimation(coordinator, (long[][])((Object[])new long[][]{bytesByPartitionId18, bytesByPartitionId28}), expectedPartitionStartIndices7);
        }, new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.test("test estimatePartitionStartIndices and enforce minimal number of reducers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ExchangeCoordinator coordinator = new ExchangeCoordinator(100L, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
            long[] bytesByPartitionId1 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 0L, 0L, 0L, 0L}), ClassTag$.MODULE$.Long());
            long[] bytesByPartitionId2 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 0L, 0L, 0L, 0L}), ClassTag$.MODULE$.Long());
            int[] expectedPartitionStartIndices = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}), ClassTag$.MODULE$.Int());
            this.checkEstimation(coordinator, (long[][])((Object[])new long[][]{bytesByPartitionId1, bytesByPartitionId2}), expectedPartitionStartIndices);
            long[] bytesByPartitionId12 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{10L, 5L, 5L, 0L, 20L}), ClassTag$.MODULE$.Long());
            long[] bytesByPartitionId22 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{5L, 10L, 0L, 10L, 5L}), ClassTag$.MODULE$.Long());
            int[] expectedPartitionStartIndices2 = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3}), ClassTag$.MODULE$.Int());
            this.checkEstimation(coordinator, (long[][])((Object[])new long[][]{bytesByPartitionId12, bytesByPartitionId22}), expectedPartitionStartIndices2);
            long[] bytesByPartitionId13 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{10L, 50L, 20L, 80L, 20L}), ClassTag$.MODULE$.Long());
            long[] bytesByPartitionId23 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{40L, 10L, 0L, 10L, 30L}), ClassTag$.MODULE$.Long());
            int[] expectedPartitionStartIndices3 = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3, 4}), ClassTag$.MODULE$.Int());
            this.checkEstimation(coordinator, (long[][])((Object[])new long[][]{bytesByPartitionId13, bytesByPartitionId23}), expectedPartitionStartIndices3);
        }, new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
        this.numInputPartitions = 10;
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{new Some((Object)BoxesRunTime.boxToInteger((int)5)), None$.MODULE$}))).foreach((Function1 & Serializable & scala.Serializable)minNumPostShufflePartitions -> {
            ExchangeCoordinatorSuite.$anonfun$new$5(this, minNumPostShufflePartitions);
            return BoxedUnit.UNIT;
        });
        this.test("SPARK-24705 adaptive query execution works correctly when exchange reuse enabled", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Function1 & Serializable & scala.Serializable test = (Function1 & Serializable & scala.Serializable)spark -> {
                ExchangeCoordinatorSuite.$anonfun$new$29(this, spark);
                return BoxedUnit.UNIT;
            };
            this.withSparkSession((Function1<SparkSession, BoxedUnit>)test, 4, (Option<Object>)None$.MODULE$);
        }, new Position("ExchangeCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 484));
    }
}

