/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.TimeZone;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Sort;
import org.apache.spark.sql.catalyst.util.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenSet;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class QueryTest$
implements scala.Serializable {
    public static QueryTest$ MODULE$;

    static {
        new QueryTest$();
    }

    public Option<String> checkAnswer(Dataset<Row> df, Seq<Row> expectedAnswer, boolean checkToRDD) {
        Seq seq;
        boolean isSorted = df.logicalPlan().collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Sort sort;
                A1 A1 = x1;
                Object object = A1 instanceof Sort ? (sort = (Sort)A1) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof Sort;
                return bl;
            }
        }).nonEmpty();
        Object object = checkToRDD ? BoxesRunTime.boxToLong((long)df.rdd().count()) : BoxedUnit.UNIT;
        try {
            seq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.collect())).toSeq();
        }
        catch (Exception e) {
            String errorMessage = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(135).append("\n            |Exception thrown while executing query:\n            |").append(df.queryExecution()).append("\n            |== Exception ==\n            |").append(e).append("\n            |").append(package$.MODULE$.stackTraceToString((Throwable)e)).append("\n          ").toString())).stripMargin();
            return new Some((Object)errorMessage);
        }
        Seq sparkAnswer = seq;
        return this.sameRows(expectedAnswer, (Seq<Row>)sparkAnswer, isSorted).map((Function1 & Serializable & scala.Serializable)results -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(146).append("\n        |Results do not match for query:\n        |Timezone: ").append(TimeZone.getDefault()).append("\n        |Timezone Env: ").append(scala.sys.package$.MODULE$.env().getOrElse((Object)"TZ", (Function0 & Serializable & scala.Serializable)() -> "")).append("\n        |\n        |").append(df.queryExecution()).append("\n        |== Results ==\n        |").append((String)results).append("\n       ").toString())).stripMargin());
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Row> prepareAnswer(Seq<Row> answer, boolean isSorted) {
        void var3_3;
        Seq converted = (Seq)answer.map((Function1 & Serializable & scala.Serializable)row -> MODULE$.prepareRow((Row)row), Seq$.MODULE$.canBuildFrom());
        return !isSorted ? (Seq)converted.sortBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toString(), (Ordering)Ordering.String$.MODULE$) : var3_3;
    }

    public Row prepareRow(Row row) {
        return Row$.MODULE$.fromSeq((Seq)row.toSeq().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            Object object2 = x0$1;
            if (object2 == null) {
                object = null;
            } else if (object2 instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object2;
                object = scala.package$.MODULE$.BigDecimal().apply(bigDecimal);
            } else if (object2 instanceof Seq) {
                Seq seq = (Seq)object2;
                object = seq.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Object object;
                    Object object2 = x0$2;
                    if (object2 instanceof Byte) {
                        Byte by = (Byte)object2;
                        object = BoxesRunTime.boxToByte((byte)by);
                    } else if (object2 instanceof Short) {
                        Short s = (Short)object2;
                        object = BoxesRunTime.boxToShort((short)s);
                    } else if (object2 instanceof Integer) {
                        Integer n = (Integer)object2;
                        object = BoxesRunTime.boxToInteger((int)n);
                    } else if (object2 instanceof Long) {
                        Long l = (Long)object2;
                        object = BoxesRunTime.boxToLong((long)l);
                    } else if (object2 instanceof Float) {
                        Float f = (Float)object2;
                        object = BoxesRunTime.boxToFloat((float)f.floatValue());
                    } else if (object2 instanceof Double) {
                        Double d = (Double)object2;
                        object = BoxesRunTime.boxToDouble((double)d);
                    } else {
                        object = object2;
                    }
                    return object;
                }, Seq$.MODULE$.canBuildFrom());
            } else if (ScalaRunTime$.MODULE$.isArray(object2, 1)) {
                Object object3 = object2;
                object = Predef$.MODULE$.genericArrayOps(object3).toSeq();
            } else if (object2 instanceof Row) {
                Row row = (Row)object2;
                object = MODULE$.prepareRow(row);
            } else {
                object = object2;
            }
            return object;
        }, Seq$.MODULE$.canBuildFrom()));
    }

    private String genError(Seq<Row> expectedAnswer, Seq<Row> sparkAnswer, boolean isSorted) {
        Function1 & Serializable & scala.Serializable getRowType = (Function1 & Serializable & scala.Serializable)row2 -> (String)row2.map((Function1 & Serializable & scala.Serializable)row -> row.schema() == null ? "struct<>" : String.valueOf(row.schema().catalogString())).getOrElse((Function0 & Serializable & scala.Serializable)() -> "struct<>");
        String string = new StringBuilder(23).append("== Correct Answer - ").append(expectedAnswer.size()).append(" ==").toString();
        String string2 = (String)getRowType.apply((Object)expectedAnswer.headOption());
        String string3 = new StringBuilder(21).append("== Spark Answer - ").append(sparkAnswer.size()).append(" ==").toString();
        String string4 = (String)getRowType.apply((Object)sparkAnswer.headOption());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(36).append("\n       |== Results ==\n       |").append(package$.MODULE$.sideBySide((Seq)((SeqLike)((SeqLike)this.prepareAnswer(expectedAnswer, isSorted).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toString(), Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string2, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom()), (Seq)((SeqLike)((SeqLike)this.prepareAnswer(sparkAnswer, isSorted).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.toString(), Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string4, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string3, Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n    ").toString())).stripMargin();
    }

    private boolean genError$default$3() {
        return false;
    }

    public Option<String> includesRows(Seq<Row> expectedRows, Seq<Row> sparkAnswer) {
        if (!this.prepareAnswer(expectedRows, true).toSet().subsetOf((GenSet)this.prepareAnswer(sparkAnswer, true).toSet())) {
            return new Some((Object)this.genError(expectedRows, sparkAnswer, true));
        }
        return None$.MODULE$;
    }

    public Option<String> sameRows(Seq<Row> expectedAnswer, Seq<Row> sparkAnswer, boolean isSorted) {
        Seq<Row> seq = this.prepareAnswer(expectedAnswer, isSorted);
        Seq<Row> seq2 = this.prepareAnswer(sparkAnswer, isSorted);
        if (seq == null ? seq2 != null : !seq.equals(seq2)) {
            return new Some((Object)this.genError(expectedAnswer, sparkAnswer, isSorted));
        }
        return None$.MODULE$;
    }

    public boolean sameRows$default$3() {
        return false;
    }

    public void checkAggregatesWithTol(Row actualAnswer, Row expectedAnswer, double absTol) {
        Predef$.MODULE$.require(actualAnswer.length() == expectedAnswer.length(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("actual answer length ").append(actualAnswer.length()).append(" != ").append(new StringBuilder(23).append("expected answer length ").append(expectedAnswer.length()).toString()).toString());
        ((IterableLike)actualAnswer.toSeq().zip((GenIterable)expectedAnswer.toSeq(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            QueryTest$.$anonfun$checkAggregatesWithTol$4(absTol, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public String checkAnswer(Dataset<Row> df, List<Row> expectedAnswer) {
        String string;
        Option<String> option = this.checkAnswer(df, (Seq<Row>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(expectedAnswer).asScala()), this.checkAnswer$default$3());
        if (option instanceof Some) {
            String errorMessage;
            Some some = (Some)option;
            string = errorMessage = (String)some.value();
        } else if (None$.MODULE$.equals(option)) {
            string = null;
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    public boolean checkAnswer$default$3() {
        return true;
    }

    private Object readResolve() {
        return MODULE$;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$checkAggregatesWithTol$4(double absTol$2, Tuple2 x0$1) {
        Object expected;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object actual = tuple2._1();
            Object expected2 = tuple2._2();
            if (actual instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)actual);
                if (expected2 instanceof Double) {
                    double d2 = BoxesRunTime.unboxToDouble((Object)expected2);
                    Predef$.MODULE$.assert(scala.math.package$.MODULE$.abs(d - d2) < absTol$2, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("actual answer ").append(d).append(" not within ").append(absTol$2).append(" of correct answer ").append(d2).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Object actual = tuple2._1();
        Predef$.MODULE$.assert(BoxesRunTime.equals((Object)actual, (Object)(expected = tuple2._2())), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append(actual).append(" did not equal ").append(expected).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private QueryTest$() {
        MODULE$ = this;
    }
}

