/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.AnalyzeTableCommand$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand$class;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SessionState;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.math.BigInt;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\u0001\u0003\u0001>\u00111#\u00118bYfTX\rV1cY\u0016\u001cu.\\7b]\u0012T!a\u0001\u0003\u0002\u000f\r|W.\\1oI*\u0011QAB\u0001\nKb,7-\u001e;j_:T!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\t\u001b=\u0011\u0002\"!\u0005\r\u000e\u0003IQ!a\u0005\u000b\u0002\u000f1|w-[2bY*\u0011QCF\u0001\u0006a2\fgn\u001d\u0006\u0003/\u0019\t\u0001bY1uC2L8\u000f^\u0005\u00033I\u00111\u0002T8hS\u000e\fG\u000e\u00157b]B\u00111\u0004H\u0007\u0002\u0005%\u0011QD\u0001\u0002\u0010%Vtg.\u00192mK\u000e{W.\\1oIB\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t9\u0001K]8ek\u000e$\bCA\u0010&\u0013\t1\u0003E\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005)\u0001\tU\r\u0011\"\u0001*\u0003)!\u0018M\u00197f\u0013\u0012,g\u000e^\u000b\u0002UA\u00111\u0006L\u0007\u0002-%\u0011QF\u0006\u0002\u0010)\u0006\u0014G.Z%eK:$\u0018NZ5fe\"Aq\u0006\u0001B\tB\u0003%!&A\u0006uC\ndW-\u00133f]R\u0004\u0003\u0002C\u0019\u0001\u0005+\u0007I\u0011\u0001\u001a\u0002\r9|7oY1o+\u0005\u0019\u0004CA\u00105\u0013\t)\u0004EA\u0004C_>dW-\u00198\t\u0011]\u0002!\u0011#Q\u0001\nM\nqA\\8tG\u0006t\u0007\u0005C\u0003:\u0001\u0011\u0005!(\u0001\u0004=S:LGO\u0010\u000b\u0004wqj\u0004CA\u000e\u0001\u0011\u0015A\u0003\b1\u0001+\u0011\u001d\t\u0004\b%AA\u0002MBQa\u0010\u0001\u0005B\u0001\u000b1A];o)\t\t\u0015\u000bE\u0002C\u00156s!a\u0011%\u000f\u0005\u0011;U\"A#\u000b\u0005\u0019s\u0011A\u0002\u001fs_>$h(C\u0001\"\u0013\tI\u0005%A\u0004qC\u000e\\\u0017mZ3\n\u0005-c%aA*fc*\u0011\u0011\n\t\t\u0003\u001d>k\u0011AB\u0005\u0003!\u001a\u00111AU8x\u0011\u0015\u0011f\b1\u0001T\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\tqE+\u0003\u0002V\r\ta1\u000b]1sWN+7o]5p]\"9q\u000bAA\u0001\n\u0003A\u0016\u0001B2paf$2aO-[\u0011\u001dAc\u000b%AA\u0002)Bq!\r,\u0011\u0002\u0003\u00071\u0007C\u0004]\u0001E\u0005I\u0011A/\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\taL\u000b\u0002+?.\n\u0001\r\u0005\u0002bM6\t!M\u0003\u0002dI\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003K\u0002\n!\"\u00198o_R\fG/[8o\u0013\t9'MA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016Dq!\u001b\u0001\u0012\u0002\u0013\u0005!.\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003-T#aM0\t\u000f5\u0004\u0011\u0011!C!]\u0006i\u0001O]8ek\u000e$\bK]3gSb,\u0012a\u001c\t\u0003aVl\u0011!\u001d\u0006\u0003eN\fA\u0001\\1oO*\tA/\u0001\u0003kCZ\f\u0017B\u0001<r\u0005\u0019\u0019FO]5oO\"9\u0001\u0010AA\u0001\n\u0003I\u0018\u0001\u00049s_\u0012,8\r^!sSRLX#\u0001>\u0011\u0005}Y\u0018B\u0001?!\u0005\rIe\u000e\u001e\u0005\b}\u0002\t\t\u0011\"\u0001\u0000\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0001\u0002\bA\u0019q$a\u0001\n\u0007\u0005\u0015\u0001EA\u0002B]fD\u0001\"!\u0003~\u0003\u0003\u0005\rA_\u0001\u0004q\u0012\n\u0004\"CA\u0007\u0001\u0005\u0005I\u0011IA\b\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\t!\u0019\t\u0019\"!\u0007\u0002\u00025\u0011\u0011Q\u0003\u0006\u0004\u0003/\u0001\u0013AC2pY2,7\r^5p]&!\u00111DA\u000b\u0005!IE/\u001a:bi>\u0014\b\"CA\u0010\u0001\u0005\u0005I\u0011AA\u0011\u0003!\u0019\u0017M\\#rk\u0006dGcA\u001a\u0002$!Q\u0011\u0011BA\u000f\u0003\u0003\u0005\r!!\u0001\t\u0013\u0005\u001d\u0002!!A\u0005B\u0005%\u0012AB3rk\u0006d7\u000fF\u00024\u0003WA!\"!\u0003\u0002&\u0005\u0005\t\u0019AA\u0001\u000f%\tyCAA\u0001\u0012\u0003\t\t$A\nB]\u0006d\u0017P_3UC\ndWmQ8n[\u0006tG\rE\u0002\u001c\u0003g1\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011QG\n\u0006\u0003g\t9\u0004\n\t\b\u0003s\tyDK\u001a<\u001b\t\tYDC\u0002\u0002>\u0001\nqA];oi&lW-\u0003\u0003\u0002B\u0005m\"!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oe!9\u0011(a\r\u0005\u0002\u0005\u0015CCAA\u0019\u0011)\tI%a\r\u0002\u0002\u0013\u0015\u00131J\u0001\ti>\u001cFO]5oOR\tq\u000e\u0003\u0006\u0002P\u0005M\u0012\u0011!CA\u0003#\nQ!\u00199qYf$RaOA*\u0003+Ba\u0001KA'\u0001\u0004Q\u0003\u0002C\u0019\u0002NA\u0005\t\u0019A\u001a\t\u0015\u0005e\u00131GA\u0001\n\u0003\u000bY&A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005u\u0013\u0011\u000e\t\u0006?\u0005}\u00131M\u0005\u0004\u0003C\u0002#AB(qi&|g\u000eE\u0003 \u0003KR3'C\u0002\u0002h\u0001\u0012a\u0001V;qY\u0016\u0014\u0004\"CA6\u0003/\n\t\u00111\u0001<\u0003\rAH\u0005\r\u0005\n\u0003_\n\u0019$%A\u0005\u0002)\fq\"\u00199qYf$C-\u001a4bk2$HE\r\u0005\n\u0003g\n\u0019$%A\u0005\u0002)\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0004BCA<\u0003g\t\t\u0011\"\u0003\u0002z\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tY\bE\u0002q\u0003{J1!a r\u0005\u0019y%M[3di\u0002")
public class AnalyzeTableCommand
extends LogicalPlan
implements RunnableCommand,
Serializable {
    private final TableIdentifier tableIdent;
    private final boolean noscan;
    private final Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$2() {
        return AnalyzeTableCommand$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean apply$default$2() {
        return AnalyzeTableCommand$.MODULE$.apply$default$2();
    }

    public static Option<Tuple2<TableIdentifier, Object>> unapply(AnalyzeTableCommand analyzeTableCommand) {
        return AnalyzeTableCommand$.MODULE$.unapply(analyzeTableCommand);
    }

    public static Function1<Tuple2<TableIdentifier, Object>, AnalyzeTableCommand> tupled() {
        return AnalyzeTableCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Object, AnalyzeTableCommand>> curried() {
        return AnalyzeTableCommand$.MODULE$.curried();
    }

    private Map metrics$lzycompute() {
        AnalyzeTableCommand analyzeTableCommand = this;
        synchronized (analyzeTableCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand$class.metrics(this);
                this.bitmap$0 = true;
            }
            return this.metrics;
        }
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return this.bitmap$0 ? this.metrics : this.metrics$lzycompute();
    }

    public Seq<Attribute> output() {
        return Command.class.output((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.class.children((Command)this);
    }

    public TableIdentifier tableIdent() {
        return this.tableIdent;
    }

    public boolean noscan() {
        return this.noscan;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionState sessionState2 = sparkSession.sessionState();
        String db = (String)this.tableIdent().database().getOrElse((Function0)new Serializable(this, sessionState2){
            public static final long serialVersionUID = 0L;
            private final SessionState sessionState$1;

            public final String apply() {
                return this.sessionState$1.catalog().getCurrentDatabase();
            }
            {
                this.sessionState$1 = sessionState$1;
            }
        });
        TableIdentifier tableIdentWithDB = new TableIdentifier(this.tableIdent().table(), (Option)new Some((Object)db));
        CatalogTable tableMeta = sessionState2.catalog().getTableMetadata(tableIdentWithDB);
        CatalogTableType catalogTableType = tableMeta.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            throw new AnalysisException("ANALYZE TABLE is not supported on views.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        BigInt newTotalSize = CommandUtils$.MODULE$.calculateTotalSize(sparkSession, tableMeta);
        None$ newRowCount = this.noscan() ? None$.MODULE$ : new Some((Object)package$.MODULE$.BigInt().apply(sparkSession.table(tableIdentWithDB).count()));
        Option<CatalogStatistics> newStats = CommandUtils$.MODULE$.compareAndGetNewStats((Option<CatalogStatistics>)tableMeta.stats(), newTotalSize, (Option<BigInt>)newRowCount);
        if (newStats.isDefined()) {
            sessionState2.catalog().alterTableStats(tableIdentWithDB, newStats);
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    public AnalyzeTableCommand copy(TableIdentifier tableIdent, boolean noscan) {
        return new AnalyzeTableCommand(tableIdent, noscan);
    }

    public TableIdentifier copy$default$1() {
        return this.tableIdent();
    }

    public boolean copy$default$2() {
        return this.noscan();
    }

    public String productPrefix() {
        return "AnalyzeTableCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.noscan());
                break;
            }
            case 0: {
                object = this.tableIdent();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AnalyzeTableCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AnalyzeTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AnalyzeTableCommand analyzeTableCommand = (AnalyzeTableCommand)x$1;
        TableIdentifier tableIdentifier = this.tableIdent();
        TableIdentifier tableIdentifier2 = analyzeTableCommand.tableIdent();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        if (this.noscan() != analyzeTableCommand.noscan()) return false;
        if (!analyzeTableCommand.canEqual(this)) return false;
        return true;
    }

    public AnalyzeTableCommand(TableIdentifier tableIdent, boolean noscan) {
        this.tableIdent = tableIdent;
        this.noscan = noscan;
        Command.class.$init$((Command)this);
        RunnableCommand$class.$init$(this);
    }
}

