/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.runtime.BoxesRunTime;

public final class MsSqlServerDialect$
extends JdbcDialect {
    public static final MsSqlServerDialect$ MODULE$;

    static {
        new MsSqlServerDialect$();
    }

    @Override
    public boolean canHandle(String url) {
        return url.startsWith("jdbc:sqlserver");
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        Option option;
        if (typeName.contains("datetimeoffset")) {
            option = Option$.MODULE$.apply((Object)StringType$.MODULE$);
        } else if (SQLConf$.MODULE$.get().legacyMsSqlServerNumericMappingEnabled()) {
            option = None$.MODULE$;
        } else {
            int n = sqlType;
            switch (n) {
                default: {
                    option = None$.MODULE$;
                    break;
                }
                case 7: {
                    option = new Some((Object)FloatType$.MODULE$);
                    break;
                }
                case 5: {
                    option = new Some((Object)ShortType$.MODULE$);
                }
            }
        }
        return option;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        Object object = TimestampType$.MODULE$.equals(dataType) ? new Some((Object)new JdbcType("DATETIME", 93)) : (StringType$.MODULE$.equals(dataType) ? new Some((Object)new JdbcType("NVARCHAR(MAX)", -9)) : (BooleanType$.MODULE$.equals(dataType) ? new Some((Object)new JdbcType("BIT", -7)) : (BinaryType$.MODULE$.equals(dataType) ? new Some((Object)new JdbcType("VARBINARY(MAX)", -3)) : (ShortType$.MODULE$.equals(dataType) && !SQLConf$.MODULE$.get().legacyMsSqlServerNumericMappingEnabled() ? new Some((Object)new JdbcType("SMALLINT", 5)) : None$.MODULE$))));
        return object;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MsSqlServerDialect$() {
        MODULE$ = this;
    }
}

