/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.AlterTableRenamePartitionCommand$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand$class;
import org.apache.spark.sql.execution.datasources.PartitioningUtils$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001B\u0001\u0003\u0001>\u0011\u0001%\u00117uKJ$\u0016M\u00197f%\u0016t\u0017-\\3QCJ$\u0018\u000e^5p]\u000e{W.\\1oI*\u00111\u0001B\u0001\bG>lW.\u00198e\u0015\t)a!A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u0005\u000e\u001fIA\u0011\u0011\u0003G\u0007\u0002%)\u00111\u0003F\u0001\bY><\u0017nY1m\u0015\t)b#A\u0003qY\u0006t7O\u0003\u0002\u0018\r\u0005A1-\u0019;bYf\u001cH/\u0003\u0002\u001a%\tYAj\\4jG\u0006d\u0007\u000b\\1o!\tYB$D\u0001\u0003\u0013\ti\"AA\bSk:t\u0017M\u00197f\u0007>lW.\u00198e!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u001d\u0001&o\u001c3vGR\u0004\"aH\u0013\n\u0005\u0019\u0002#\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002\u0003\u0015\u0001\u0005+\u0007I\u0011A\u0015\u0002\u0013Q\f'\r\\3OC6,W#\u0001\u0016\u0011\u0005-bS\"\u0001\f\n\u000552\"a\u0004+bE2,\u0017\nZ3oi&4\u0017.\u001a:\t\u0011=\u0002!\u0011#Q\u0001\n)\n!\u0002^1cY\u0016t\u0015-\\3!\u0011!\t\u0004A!f\u0001\n\u0003\u0011\u0014\u0001D8mIB\u000b'\u000f^5uS>tW#A\u001a\u0011\u0005QBeBA\u001bF\u001d\t14I\u0004\u00028\u0005:\u0011\u0001(\u0011\b\u0003s\u0001s!AO \u000f\u0005mrT\"\u0001\u001f\u000b\u0005ur\u0011A\u0002\u001fs_>$h(C\u0001\u000e\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003/\u0019I!\u0001\u0012\f\u0002\u000f\r\fG/\u00197pO&\u0011aiR\u0001\r\u0007\u0006$\u0018\r\\8h)f\u0004Xm\u001d\u0006\u0003\tZI!!\u0013&\u0003%Q\u000b'\r\\3QCJ$\u0018\u000e^5p]N\u0003Xm\u0019\u0006\u0003\r\u001eC\u0001\u0002\u0014\u0001\u0003\u0012\u0003\u0006IaM\u0001\u000e_2$\u0007+\u0019:uSRLwN\u001c\u0011\t\u00119\u0003!Q3A\u0005\u0002I\nAB\\3x!\u0006\u0014H/\u001b;j_:D\u0001\u0002\u0015\u0001\u0003\u0012\u0003\u0006IaM\u0001\u000e]\u0016<\b+\u0019:uSRLwN\u001c\u0011\t\u000bI\u0003A\u0011A*\u0002\rqJg.\u001b;?)\u0011!VKV,\u0011\u0005m\u0001\u0001\"\u0002\u0015R\u0001\u0004Q\u0003\"B\u0019R\u0001\u0004\u0019\u0004\"\u0002(R\u0001\u0004\u0019\u0004\"B-\u0001\t\u0003R\u0016a\u0001:v]R\u00111\f\u001b\t\u00049\u0006$gBA/`\u001d\tYd,C\u0001\"\u0013\t\u0001\u0007%A\u0004qC\u000e\\\u0017mZ3\n\u0005\t\u001c'aA*fc*\u0011\u0001\r\t\t\u0003K\u001al\u0011AB\u0005\u0003O\u001a\u00111AU8x\u0011\u0015I\u0007\f1\u0001k\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\t)7.\u0003\u0002m\r\ta1\u000b]1sWN+7o]5p]\"9a\u000eAA\u0001\n\u0003y\u0017\u0001B2paf$B\u0001\u00169re\"9\u0001&\u001cI\u0001\u0002\u0004Q\u0003bB\u0019n!\u0003\u0005\ra\r\u0005\b\u001d6\u0004\n\u00111\u00014\u0011\u001d!\b!%A\u0005\u0002U\fabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001wU\tQsoK\u0001y!\tIh0D\u0001{\u0015\tYH0A\u0005v]\u000eDWmY6fI*\u0011Q\u0010I\u0001\u000bC:tw\u000e^1uS>t\u0017BA@{\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003\u0007\u0001\u0011\u0013!C\u0001\u0003\u000b\tabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\b)\u00121g\u001e\u0005\n\u0003\u0017\u0001\u0011\u0013!C\u0001\u0003\u000b\tabY8qs\u0012\"WMZ1vYR$3\u0007C\u0005\u0002\u0010\u0001\t\t\u0011\"\u0011\u0002\u0012\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0005\u0011\t\u0005U\u0011qD\u0007\u0003\u0003/QA!!\u0007\u0002\u001c\u0005!A.\u00198h\u0015\t\ti\"\u0001\u0003kCZ\f\u0017\u0002BA\u0011\u0003/\u0011aa\u0015;sS:<\u0007\"CA\u0013\u0001\u0005\u0005I\u0011AA\u0014\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tI\u0003E\u0002 \u0003WI1!!\f!\u0005\rIe\u000e\u001e\u0005\n\u0003c\u0001\u0011\u0011!C\u0001\u0003g\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u00026\u0005m\u0002cA\u0010\u00028%\u0019\u0011\u0011\b\u0011\u0003\u0007\u0005s\u0017\u0010\u0003\u0006\u0002>\u0005=\u0012\u0011!a\u0001\u0003S\t1\u0001\u001f\u00132\u0011%\t\t\u0005AA\u0001\n\u0003\n\u0019%A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t)\u0005\u0005\u0004\u0002H\u00055\u0013QG\u0007\u0003\u0003\u0013R1!a\u0013!\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001f\nIE\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\t\u0019\u0006AA\u0001\n\u0003\t)&\u0001\u0005dC:,\u0015/^1m)\u0011\t9&!\u0018\u0011\u0007}\tI&C\u0002\u0002\\\u0001\u0012qAQ8pY\u0016\fg\u000e\u0003\u0006\u0002>\u0005E\u0013\u0011!a\u0001\u0003kA\u0011\"!\u0019\u0001\u0003\u0003%\t%a\u0019\u0002\r\u0015\fX/\u00197t)\u0011\t9&!\u001a\t\u0015\u0005u\u0012qLA\u0001\u0002\u0004\t)dB\u0005\u0002j\t\t\t\u0011#\u0001\u0002l\u0005\u0001\u0013\t\u001c;feR\u000b'\r\\3SK:\fW.\u001a)beRLG/[8o\u0007>lW.\u00198e!\rY\u0012Q\u000e\u0004\t\u0003\t\t\t\u0011#\u0001\u0002pM)\u0011QNA9IAA\u00111OA=UM\u001aD+\u0004\u0002\u0002v)\u0019\u0011q\u000f\u0011\u0002\u000fI,h\u000e^5nK&!\u00111PA;\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u0005\b%\u00065D\u0011AA@)\t\tY\u0007\u0003\u0006\u0002\u0004\u00065\u0014\u0011!C#\u0003\u000b\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003'A!\"!#\u0002n\u0005\u0005I\u0011QAF\u0003\u0015\t\u0007\u000f\u001d7z)\u001d!\u0016QRAH\u0003#Ca\u0001KAD\u0001\u0004Q\u0003BB\u0019\u0002\b\u0002\u00071\u0007\u0003\u0004O\u0003\u000f\u0003\ra\r\u0005\u000b\u0003+\u000bi'!A\u0005\u0002\u0006]\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u00033\u000b)\u000bE\u0003 \u00037\u000by*C\u0002\u0002\u001e\u0002\u0012aa\u00149uS>t\u0007CB\u0010\u0002\"*\u001a4'C\u0002\u0002$\u0002\u0012a\u0001V;qY\u0016\u001c\u0004\"CAT\u0003'\u000b\t\u00111\u0001U\u0003\rAH\u0005\r\u0005\u000b\u0003W\u000bi'!A\u0005\n\u00055\u0016a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a,\u0011\t\u0005U\u0011\u0011W\u0005\u0005\u0003g\u000b9B\u0001\u0004PE*,7\r\u001e")
public class AlterTableRenamePartitionCommand
extends LogicalPlan
implements RunnableCommand,
Serializable {
    private final TableIdentifier tableName;
    private final Map<String, String> oldPartition;
    private final Map<String, String> newPartition;
    private final Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<TableIdentifier, Map<String, String>, Map<String, String>>> unapply(AlterTableRenamePartitionCommand alterTableRenamePartitionCommand) {
        return AlterTableRenamePartitionCommand$.MODULE$.unapply(alterTableRenamePartitionCommand);
    }

    public static Function1<Tuple3<TableIdentifier, Map<String, String>, Map<String, String>>, AlterTableRenamePartitionCommand> tupled() {
        return AlterTableRenamePartitionCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Map<String, String>, Function1<Map<String, String>, AlterTableRenamePartitionCommand>>> curried() {
        return AlterTableRenamePartitionCommand$.MODULE$.curried();
    }

    private Map metrics$lzycompute() {
        AlterTableRenamePartitionCommand alterTableRenamePartitionCommand = this;
        synchronized (alterTableRenamePartitionCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand$class.metrics(this);
                this.bitmap$0 = true;
            }
            return this.metrics;
        }
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return this.bitmap$0 ? this.metrics : this.metrics$lzycompute();
    }

    public Seq<Attribute> output() {
        return Command.class.output((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.class.children((Command)this);
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public Map<String, String> oldPartition() {
        return this.oldPartition;
    }

    public Map<String, String> newPartition() {
        return this.newPartition;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog2 = sparkSession.sessionState().catalog();
        CatalogTable table = catalog2.getTableMetadata(this.tableName());
        DDLUtils$.MODULE$.verifyAlterTableType(catalog2, table, false);
        DDLUtils$.MODULE$.verifyPartitionProviderIsHive(sparkSession, table, "ALTER TABLE RENAME PARTITION");
        Map<String, String> normalizedOldPartition = PartitioningUtils$.MODULE$.normalizePartitionSpec(this.oldPartition(), (Seq<String>)table.partitionColumnNames(), table.identifier().quotedString(), (Function2<String, String, Object>)sparkSession.sessionState().conf().resolver());
        Map<String, String> normalizedNewPartition = PartitioningUtils$.MODULE$.normalizePartitionSpec(this.newPartition(), (Seq<String>)table.partitionColumnNames(), table.identifier().quotedString(), (Function2<String, String, Object>)sparkSession.sessionState().conf().resolver());
        catalog2.renamePartitions(this.tableName(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{normalizedOldPartition})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{normalizedNewPartition})));
        return (Seq)Seq$.MODULE$.empty();
    }

    public AlterTableRenamePartitionCommand copy(TableIdentifier tableName, Map<String, String> oldPartition, Map<String, String> newPartition) {
        return new AlterTableRenamePartitionCommand(tableName, oldPartition, newPartition);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public Map<String, String> copy$default$2() {
        return this.oldPartition();
    }

    public Map<String, String> copy$default$3() {
        return this.newPartition();
    }

    public String productPrefix() {
        return "AlterTableRenamePartitionCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        TableIdentifier tableIdentifier;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                tableIdentifier = this.newPartition();
                break;
            }
            case 1: {
                tableIdentifier = this.oldPartition();
                break;
            }
            case 0: {
                tableIdentifier = this.tableName();
            }
        }
        return tableIdentifier;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableRenamePartitionCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableRenamePartitionCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableRenamePartitionCommand alterTableRenamePartitionCommand = (AlterTableRenamePartitionCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = alterTableRenamePartitionCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Map<String, String> map2 = this.oldPartition();
        Map<String, String> map3 = alterTableRenamePartitionCommand.oldPartition();
        if (map2 == null) {
            if (map3 != null) {
                return false;
            }
        } else if (!map2.equals(map3)) return false;
        Map<String, String> map4 = this.newPartition();
        Map<String, String> map5 = alterTableRenamePartitionCommand.newPartition();
        if (map4 == null) {
            if (map5 != null) {
                return false;
            }
        } else if (!map4.equals(map5)) return false;
        if (!alterTableRenamePartitionCommand.canEqual(this)) return false;
        return true;
    }

    public AlterTableRenamePartitionCommand(TableIdentifier tableName, Map<String, String> oldPartition, Map<String, String> newPartition) {
        this.tableName = tableName;
        this.oldPartition = oldPartition;
        this.newPartition = newPartition;
        Command.class.$init$((Command)this);
        RunnableCommand$class.$init$(this);
    }
}

