/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.SparkContext;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SparkPlanInfo$;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionEnd;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionStart;
import org.apache.spark.util.CallSite;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class SQLExecution$ {
    public static final SQLExecution$ MODULE$;
    private final String EXECUTION_ID_KEY;
    private final AtomicLong _nextExecutionId;
    private final ConcurrentHashMap<Object, QueryExecution> executionIdToQueryExecution;
    private final boolean testing;

    static {
        new SQLExecution$();
    }

    public String EXECUTION_ID_KEY() {
        return this.EXECUTION_ID_KEY;
    }

    private AtomicLong _nextExecutionId() {
        return this._nextExecutionId;
    }

    private long nextExecutionId() {
        return this._nextExecutionId().getAndIncrement();
    }

    private ConcurrentHashMap<Object, QueryExecution> executionIdToQueryExecution() {
        return this.executionIdToQueryExecution;
    }

    public QueryExecution getQueryExecution(long executionId) {
        return this.executionIdToQueryExecution().get(BoxesRunTime.boxToLong((long)executionId));
    }

    private boolean testing() {
        return this.testing;
    }

    public void checkSQLExecutionId(SparkSession sparkSession) {
        SparkContext sc = sparkSession.sparkContext();
        if (this.testing() && sc.getLocalProperty(this.EXECUTION_ID_KEY()) == null) {
            throw new IllegalStateException("Execution ID should be set");
        }
    }

    /*
     * WARNING - void declaration
     */
    public <T> T withNewExecutionId(SparkSession sparkSession, QueryExecution queryExecution, Function0<T> body) {
        T t;
        SparkContext sc = sparkSession.sparkContext();
        String oldExecutionId = sc.getLocalProperty(this.EXECUTION_ID_KEY());
        long executionId = this.nextExecutionId();
        sc.setLocalProperty(this.EXECUTION_ID_KEY(), ((Object)BoxesRunTime.boxToLong((long)executionId)).toString());
        this.executionIdToQueryExecution().put(BoxesRunTime.boxToLong((long)executionId), queryExecution);
        try {
            CallSite callSite = sc.getCallSite();
            t = this.withSQLConfPropagated(sparkSession, (Function0<T>)new Serializable(queryExecution, body, sc, executionId, callSite){
                public static final long serialVersionUID = 0L;
                private final QueryExecution queryExecution$1;
                private final Function0 body$1;
                private final SparkContext sc$1;
                private final long executionId$1;
                private final CallSite callSite$1;

                public final T apply() {
                    this.sc$1.listenerBus().post((SparkListenerEvent)new SparkListenerSQLExecutionStart(this.executionId$1, this.callSite$1.shortForm(), this.callSite$1.longForm(), this.queryExecution$1.toString(), SparkPlanInfo$.MODULE$.fromSparkPlan(this.queryExecution$1.executedPlan()), System.currentTimeMillis()));
                    try {
                        return (T)this.body$1.apply();
                    }
                    finally {
                        this.sc$1.listenerBus().post((SparkListenerEvent)new SparkListenerSQLExecutionEnd(this.executionId$1, System.currentTimeMillis()));
                    }
                }
                {
                    this.queryExecution$1 = queryExecution$1;
                    this.body$1 = body$1;
                    this.sc$1 = sc$1;
                    this.executionId$1 = executionId$1;
                    this.callSite$1 = callSite$1;
                }
            });
            this.executionIdToQueryExecution().remove(BoxesRunTime.boxToLong((long)executionId));
        }
        catch (Throwable throwable) {
            void var5_5;
            void var4_4;
            void var6_6;
            this.executionIdToQueryExecution().remove(BoxesRunTime.boxToLong((long)var6_6));
            var4_4.setLocalProperty(this.EXECUTION_ID_KEY(), (String)var5_5);
            throw throwable;
        }
        sc.setLocalProperty(this.EXECUTION_ID_KEY(), oldExecutionId);
        return t;
    }

    public <T> T withExecutionId(SparkSession sparkSession, String executionId, Function0<T> body) {
        SparkContext sc = sparkSession.sparkContext();
        String oldExecutionId = sc.getLocalProperty(this.EXECUTION_ID_KEY());
        return this.withSQLConfPropagated(sparkSession, (Function0<T>)new Serializable(executionId, body, sc, oldExecutionId){
            public static final long serialVersionUID = 0L;
            private final String executionId$2;
            private final Function0 body$2;
            private final SparkContext sc$2;
            private final String oldExecutionId$1;

            public final T apply() {
                try {
                    this.sc$2.setLocalProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY(), this.executionId$2);
                    return (T)this.body$2.apply();
                }
                finally {
                    this.sc$2.setLocalProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY(), this.oldExecutionId$1);
                }
            }
            {
                this.executionId$2 = executionId$2;
                this.body$2 = body$2;
                this.sc$2 = sc$2;
                this.oldExecutionId$1 = oldExecutionId$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public <T> T withSQLConfPropagated(SparkSession sparkSession, Function0<T> body) {
        Object object;
        SparkContext sc = sparkSession.sparkContext();
        Map allConfigs = sparkSession.sessionState().conf().getAllConfs();
        Map originalLocalProps = (Map)allConfigs.collect((PartialFunction)new Serializable(sc){
            public static final long serialVersionUID = 0L;
            private final SparkContext sc$3;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    String key = (String)A1._1();
                    String value = (String)A1._2();
                    if (key.startsWith("spark")) {
                        String originalValue = this.sc$3.getLocalProperty(key);
                        this.sc$3.setLocalProperty(key, value);
                        object = new Tuple2((Object)key, (Object)originalValue);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<String, String> x1) {
                String key;
                Tuple2<String, String> tuple2 = x1;
                boolean bl = tuple2 != null && (key = (String)tuple2._1()).startsWith("spark");
                return bl;
            }
            {
                this.sc$3 = sc$3;
            }
        }, Map$.MODULE$.canBuildFrom());
        try {
            object = body.apply();
        }
        catch (Throwable throwable) {
            void var3_3;
            void var5_5;
            var5_5.withFilter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, String> check$ifrefutable$1) {
                    Tuple2<String, String> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable((SparkContext)var3_3){
                public static final long serialVersionUID = 0L;
                private final SparkContext sc$3;

                public final void apply(Tuple2<String, String> x$1) {
                    Tuple2<String, String> tuple2 = x$1;
                    if (tuple2 != null) {
                        String key = (String)tuple2._1();
                        String value = (String)tuple2._2();
                        this.sc$3.setLocalProperty(key, value);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.sc$3 = sc$3;
                }
            });
            throw throwable;
        }
        originalLocalProps.withFilter((Function1)new /* invalid duplicate definition of identical inner class */).foreach((Function1)new /* invalid duplicate definition of identical inner class */);
        return (T)object;
    }

    public <T> Future<T> withThreadLocalCaptured(SparkSession sparkSession, ExecutionContext exec, Function0<T> body) {
        SparkSession activeSession = sparkSession;
        SparkContext sc = sparkSession.sparkContext();
        Properties localProps = Utils$.MODULE$.cloneProperties(sc.getLocalProperties());
        return Future$.MODULE$.apply((Function0)new Serializable(body, activeSession, sc, localProps){
            public static final long serialVersionUID = 0L;
            private final Function0 body$3;
            private final SparkSession activeSession$1;
            private final SparkContext sc$4;
            private final Properties localProps$1;

            public final T apply() {
                SparkSession$.MODULE$.setActiveSession(this.activeSession$1);
                this.sc$4.setLocalProperties(this.localProps$1);
                return (T)this.body$3.apply();
            }
            {
                this.body$3 = body$3;
                this.activeSession$1 = activeSession$1;
                this.sc$4 = sc$4;
                this.localProps$1 = localProps$1;
            }
        }, exec);
    }

    private SQLExecution$() {
        MODULE$ = this;
        this.EXECUTION_ID_KEY = "spark.sql.execution.id";
        this._nextExecutionId = new AtomicLong(0L);
        this.executionIdToQueryExecution = new ConcurrentHashMap();
        this.testing = package$.MODULE$.props().contains("spark.testing");
    }
}

