/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.FileIndex$class;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.FileStatusCache$;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex$;
import org.apache.spark.sql.execution.datasources.PartitionDirectory;
import org.apache.spark.sql.execution.datasources.PartitionPath;
import org.apache.spark.sql.execution.datasources.PartitionSpec;
import org.apache.spark.sql.execution.datasources.PrunedInMemoryFileIndex;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\u0001\u0003\u0001=\u0011\u0001cQ1uC2|wMR5mK&sG-\u001a=\u000b\u0005\r!\u0011a\u00033bi\u0006\u001cx.\u001e:dKNT!!\u0002\u0004\u0002\u0013\u0015DXmY;uS>t'BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011c\u0001\u0001\u0011-A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"a\u0006\r\u000e\u0003\tI!!\u0007\u0002\u0003\u0013\u0019KG.Z%oI\u0016D\b\u0002C\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005uqR\"\u0001\u0004\n\u0005}1!\u0001D*qCJ\\7+Z:tS>t\u0007\u0002C\u0011\u0001\u0005\u000b\u0007I\u0011\u0001\u0012\u0002\u000bQ\f'\r\\3\u0016\u0003\r\u0002\"\u0001J\u0015\u000e\u0003\u0015R!AJ\u0014\u0002\u000f\r\fG/\u00197pO*\u0011\u0001FB\u0001\tG\u0006$\u0018\r\\=ti&\u0011!&\n\u0002\r\u0007\u0006$\u0018\r\\8h)\u0006\u0014G.\u001a\u0005\tY\u0001\u0011\t\u0011)A\u0005G\u00051A/\u00192mK\u0002B\u0001B\f\u0001\u0003\u0006\u0004%\teL\u0001\fg&TX-\u00138CsR,7/F\u00011!\t\t\u0012'\u0003\u00023%\t!Aj\u001c8h\u0011!!\u0004A!A!\u0002\u0013\u0001\u0014\u0001D:ju\u0016LeNQ=uKN\u0004\u0003\"\u0002\u001c\u0001\t\u00039\u0014A\u0002\u001fj]&$h\b\u0006\u00039siZ\u0004CA\f\u0001\u0011\u0015YR\u00071\u0001\u001d\u0011\u0015\tS\u00071\u0001$\u0011\u0015qS\u00071\u00011\u0011\u001di\u0004A1A\u0005\u0012y\n!\u0002[1e_>\u00048i\u001c8g+\u0005y\u0004C\u0001!F\u001b\u0005\t%B\u0001\"D\u0003\u0011\u0019wN\u001c4\u000b\u0005\u0011S\u0011A\u00025bI>|\u0007/\u0003\u0002G\u0003\ni1i\u001c8gS\u001e,(/\u0019;j_:Da\u0001\u0013\u0001!\u0002\u0013y\u0014a\u00035bI>|\u0007oQ8oM\u0002BqA\u0013\u0001C\u0002\u0013%1*A\bgS2,7\u000b^1ukN\u001c\u0015m\u00195f+\u0005a\u0005CA\fN\u0013\tq%AA\bGS2,7\u000b^1ukN\u001c\u0015m\u00195f\u0011\u0019\u0001\u0006\u0001)A\u0005\u0019\u0006\u0001b-\u001b7f'R\fG/^:DC\u000eDW\r\t\u0005\b%\u0002\u0011\r\u0011\"\u0003T\u00031\u0011\u0017m]3M_\u000e\fG/[8o+\u0005!\u0006cA\tV/&\u0011aK\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005akV\"A-\u000b\u0005i[\u0016a\u00018fi*\tA,\u0001\u0003kCZ\f\u0017B\u00010Z\u0005\r)&+\u0013\u0005\u0007A\u0002\u0001\u000b\u0011\u0002+\u0002\u001b\t\f7/\u001a'pG\u0006$\u0018n\u001c8!\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0003=\u0001\u0018M\u001d;ji&|gnU2iK6\fW#\u00013\u0011\u0005\u0015DW\"\u00014\u000b\u0005\u001d4\u0011!\u0002;za\u0016\u001c\u0018BA5g\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006W\u0002!\t\u0005\\\u0001\ne>|G\u000fU1uQN,\u0012!\u001c\t\u0004]ZLhBA8u\u001d\t\u00018/D\u0001r\u0015\t\u0011h\"\u0001\u0004=e>|GOP\u0005\u0002'%\u0011QOE\u0001\ba\u0006\u001c7.Y4f\u0013\t9\bPA\u0002TKFT!!\u001e\n\u0011\u0005ilX\"A>\u000b\u0005q\u001c\u0015A\u00014t\u0013\tq8P\u0001\u0003QCRD\u0007bBA\u0001\u0001\u0011\u0005\u00131A\u0001\nY&\u001cHOR5mKN$b!!\u0002\u0002\u000e\u0005}\u0001\u0003\u00028w\u0003\u000f\u00012aFA\u0005\u0013\r\tYA\u0001\u0002\u0013!\u0006\u0014H/\u001b;j_:$\u0015N]3di>\u0014\u0018\u0010C\u0004\u0002\u0010}\u0004\r!!\u0005\u0002!A\f'\u000f^5uS>tg)\u001b7uKJ\u001c\b\u0003\u00028w\u0003'\u0001B!!\u0006\u0002\u001c5\u0011\u0011q\u0003\u0006\u0004\u000339\u0013aC3yaJ,7o]5p]NLA!!\b\u0002\u0018\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u000f\u0005\u0005r\u00101\u0001\u0002\u0012\u0005YA-\u0019;b\r&dG/\u001a:t\u0011\u001d\t)\u0003\u0001C!\u0003O\tqA]3ge\u0016\u001c\b\u000e\u0006\u0002\u0002*A\u0019\u0011#a\u000b\n\u0007\u00055\"C\u0001\u0003V]&$\bbBA\u0019\u0001\u0011\u0005\u00111G\u0001\u0011M&dG/\u001a:QCJ$\u0018\u000e^5p]N$B!!\u000e\u0002<A\u0019q#a\u000e\n\u0007\u0005e\"AA\tJ]6+Wn\u001c:z\r&dW-\u00138eKbD\u0001\"!\u0010\u00020\u0001\u0007\u0011\u0011C\u0001\bM&dG/\u001a:t\u0011\u001d\t\t\u0005\u0001C!\u0003\u0007\n!\"\u001b8qkR4\u0015\u000e\\3t+\t\t)\u0005E\u0003\u0012\u0003\u000f\nY%C\u0002\u0002JI\u0011Q!\u0011:sCf\u0004B!!\u0014\u0002T9\u0019\u0011#a\u0014\n\u0007\u0005E##\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003+\n9F\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003#\u0012\u0002bBA.\u0001\u0011\u0005\u0013QL\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005}\u0013Q\r\t\u0004#\u0005\u0005\u0014bAA2%\t9!i\\8mK\u0006t\u0007\u0002CA4\u00033\u0002\r!!\u001b\u0002\u0003=\u00042!EA6\u0013\r\tiG\u0005\u0002\u0004\u0003:L\bbBA9\u0001\u0011\u0005\u00131O\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011Q\u000f\t\u0004#\u0005]\u0014bAA=%\t\u0019\u0011J\u001c;")
public class CatalogFileIndex
implements FileIndex {
    public final SparkSession org$apache$spark$sql$execution$datasources$CatalogFileIndex$$sparkSession;
    private final CatalogTable table;
    private final long sizeInBytes;
    private final Configuration hadoopConf;
    private final FileStatusCache fileStatusCache;
    private final Option<URI> baseLocation;

    @Override
    public Option<Object> metadataOpsTimeNs() {
        return FileIndex$class.metadataOpsTimeNs(this);
    }

    public CatalogTable table() {
        return this.table;
    }

    @Override
    public long sizeInBytes() {
        return this.sizeInBytes;
    }

    public Configuration hadoopConf() {
        return this.hadoopConf;
    }

    private FileStatusCache fileStatusCache() {
        return this.fileStatusCache;
    }

    private Option<URI> baseLocation() {
        return this.baseLocation;
    }

    @Override
    public StructType partitionSchema() {
        return this.table().partitionSchema();
    }

    @Override
    public Seq<Path> rootPaths() {
        return Option$.MODULE$.option2Iterable(this.baseLocation().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Path apply(URI x$1) {
                return new Path(x$1);
            }
        })).toSeq();
    }

    @Override
    public Seq<PartitionDirectory> listFiles(Seq<Expression> partitionFilters2, Seq<Expression> dataFilters) {
        return this.filterPartitions(partitionFilters2).listFiles((Seq<Expression>)Nil$.MODULE$, dataFilters);
    }

    @Override
    public void refresh() {
        this.fileStatusCache().invalidateAll();
    }

    public InMemoryFileIndex filterPartitions(Seq<Expression> filters) {
        InMemoryFileIndex inMemoryFileIndex;
        if (this.table().partitionColumnNames().nonEmpty()) {
            long startTime = System.nanoTime();
            Seq selectedPartitions = this.org$apache$spark$sql$execution$datasources$CatalogFileIndex$$sparkSession.sessionState().catalog().listPartitionsByFilter(this.table().identifier(), filters);
            Seq partitions = (Seq)selectedPartitions.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CatalogFileIndex $outer;

                public final PartitionPath apply(CatalogTablePartition p) {
                    Path path = new Path(p.location());
                    FileSystem fs = path.getFileSystem(this.$outer.hadoopConf());
                    return new PartitionPath(p.toRow(this.$outer.partitionSchema(), this.$outer.org$apache$spark$sql$execution$datasources$CatalogFileIndex$$sparkSession.sessionState().conf().sessionLocalTimeZone()), path.makeQualified(fs.getUri(), fs.getWorkingDirectory()));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Seq$.MODULE$.canBuildFrom());
            PartitionSpec partitionSpec2 = new PartitionSpec(this.partitionSchema(), (Seq<PartitionPath>)partitions);
            long timeNs = System.nanoTime() - startTime;
            inMemoryFileIndex = new PrunedInMemoryFileIndex(this.org$apache$spark$sql$execution$datasources$CatalogFileIndex$$sparkSession, new Path((URI)this.baseLocation().get()), this.fileStatusCache(), partitionSpec2, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)timeNs)));
        } else {
            inMemoryFileIndex = new InMemoryFileIndex(this.org$apache$spark$sql$execution$datasources$CatalogFileIndex$$sparkSession, this.rootPaths(), (Map<String, String>)this.table().storage().properties(), (Option<StructType>)None$.MODULE$, InMemoryFileIndex$.MODULE$.$lessinit$greater$default$5());
        }
        return inMemoryFileIndex;
    }

    @Override
    public String[] inputFiles() {
        return this.filterPartitions((Seq<Expression>)Nil$.MODULE$).inputFiles();
    }

    public boolean equals(Object o) {
        boolean bl;
        Object object = o;
        if (object instanceof CatalogFileIndex) {
            CatalogFileIndex catalogFileIndex = (CatalogFileIndex)object;
            TableIdentifier tableIdentifier = this.table().identifier();
            TableIdentifier tableIdentifier2 = catalogFileIndex.table().identifier();
            bl = !(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.table().identifier().hashCode();
    }

    public CatalogFileIndex(SparkSession sparkSession, CatalogTable table, long sizeInBytes2) {
        this.org$apache$spark$sql$execution$datasources$CatalogFileIndex$$sparkSession = sparkSession;
        this.table = table;
        this.sizeInBytes = sizeInBytes2;
        FileIndex$class.$init$(this);
        this.hadoopConf = sparkSession.sessionState().newHadoopConf();
        this.fileStatusCache = FileStatusCache$.MODULE$.getOrCreate(sparkSession);
        Predef$.MODULE$.assert(table.identifier().database().isDefined(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The table identifier must be qualified in CatalogFileIndex";
            }
        });
        this.baseLocation = table.storage().locationUri();
    }
}

