/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.columnar.ByteBufferHelper$;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.LONG$;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.compression.Encoder$class;
import org.apache.spark.sql.execution.columnar.compression.LongDelta$;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.LongType$;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t\u0015qAB\u0001\u0003\u0011\u0003#\u0001#A\u0005M_:<G)\u001a7uC*\u00111\u0001B\u0001\fG>l\u0007O]3tg&|gN\u0003\u0002\u0006\r\u0005A1m\u001c7v[:\f'O\u0003\u0002\b\u0011\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u0013)\t1a]9m\u0015\tYA\"A\u0003ta\u0006\u00148N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<\u0007CA\t\u0013\u001b\u0005\u0011aAB\n\u0003\u0011\u0003#ACA\u0005M_:<G)\u001a7uCN)!#F\u000e\u001fCA\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\t1\u0011I\\=SK\u001a\u0004\"!\u0005\u000f\n\u0005u\u0011!!E\"p[B\u0014Xm]:j_:\u001c6\r[3nKB\u0011acH\u0005\u0003A]\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u0017E%\u00111e\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0006KI!\taJ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t\u0001\u0003C\u0003*%\u0011\u0005#&\u0001\u0004usB,\u0017\nZ\u000b\u0002WA\u0011a\u0003L\u0005\u0003[]\u00111!\u00138u\u0011\u0015y#\u0003\"\u00111\u0003\u001d!WmY8eKJ,\"!M\u001c\u0015\u0007I\u001aU\nE\u0002\u0012gUJ!\u0001\u000e\u0002\u0003\u000f\u0011+7m\u001c3feB\u0011ag\u000e\u0007\u0001\t\u0015AdF1\u0001:\u0005\u0005!\u0016C\u0001\u001e>!\t12(\u0003\u0002=/\t9aj\u001c;iS:<\u0007C\u0001 B\u001b\u0005y$B\u0001!\t\u0003\u0015!\u0018\u0010]3t\u0013\t\u0011uH\u0001\u0006Bi>l\u0017n\u0019+za\u0016DQ\u0001\u0012\u0018A\u0002\u0015\u000baAY;gM\u0016\u0014\bC\u0001$L\u001b\u00059%B\u0001%J\u0003\rq\u0017n\u001c\u0006\u0002\u0015\u0006!!.\u0019<b\u0013\tauI\u0001\u0006CsR,')\u001e4gKJDQA\u0014\u0018A\u0002=\u000b!bY8mk6tG+\u001f9f!\r\u0001\u0016+N\u0007\u0002\t%\u0011!\u000b\u0002\u0002\u0011\u001d\u0006$\u0018N^3D_2,XN\u001c+za\u0016DQ\u0001\u0016\n\u0005BU\u000bq!\u001a8d_\u0012,'/\u0006\u0002W7R\u0011q\u000b\u0018\t\u0004#aS\u0016BA-\u0003\u0005\u001d)enY8eKJ\u0004\"AN.\u0005\u000ba\u001a&\u0019A\u001d\t\u000b9\u001b\u0006\u0019A/\u0011\u0007A\u000b&\fC\u0003`%\u0011\u0005\u0003-\u0001\u0005tkB\u0004xN\u001d;t)\t\tG\r\u0005\u0002\u0017E&\u00111m\u0006\u0002\b\u0005>|G.Z1o\u0011\u0015qe\f1\u0001fa\t1'\u000eE\u0002QO&L!\u0001\u001b\u0003\u0003\u0015\r{G.^7o)f\u0004X\r\u0005\u00027U\u0012I1\u000eZA\u0001\u0002\u0003\u0015\t\u0001\u001c\u0002\u0004?\u00122\u0014C\u0001\u001en!\t1b.\u0003\u0002p/\t\u0019\u0011I\\=\u0007\te\u0013\u0002!]\n\u0004aV\u0011\bcA\tYg:\u0011a\b^\u0005\u0003k~\n\u0001\u0002T8oORK\b/\u001a\u0005\u0006KA$\ta\u001e\u000b\u0002qB\u0011\u0011\u0010]\u0007\u0002%!91\u0010\u001da\u0001\n#Q\u0013aD0d_6\u0004(/Z:tK\u0012\u001c\u0016N_3\t\u000fu\u0004\b\u0019!C\t}\u0006\u0019rlY8naJ,7o]3e'&TXm\u0018\u0013fcR\u0019q0!\u0002\u0011\u0007Y\t\t!C\u0002\u0002\u0004]\u0011A!\u00168ji\"A\u0011q\u0001?\u0002\u0002\u0003\u00071&A\u0002yIEBq!a\u0003qA\u0003&1&\u0001\t`G>l\u0007O]3tg\u0016$7+\u001b>fA!A\u0011q\u00029A\u0002\u0013E!&A\t`k:\u001cw.\u001c9sKN\u001cX\rZ*ju\u0016D\u0011\"a\u0005q\u0001\u0004%\t\"!\u0006\u0002+}+hnY8naJ,7o]3e'&TXm\u0018\u0013fcR\u0019q0a\u0006\t\u0013\u0005\u001d\u0011\u0011CA\u0001\u0002\u0004Y\u0003bBA\u000ea\u0002\u0006KaK\u0001\u0013?Vt7m\\7qe\u0016\u001c8/\u001a3TSj,\u0007\u0005\u0003\u0004\u0002 A$\tEK\u0001\u000fG>l\u0007O]3tg\u0016$7+\u001b>f\u0011\u0019\t\u0019\u0003\u001dC!U\u0005\u0001RO\\2p[B\u0014Xm]:fINK'0\u001a\u0005\f\u0003O\u0001\b\u0019!a\u0001\n\u0013\tI#A\u0005qe\u00164h+\u00197vKV\u0011\u00111\u0006\t\u0004-\u00055\u0012bAA\u0018/\t!Aj\u001c8h\u0011-\t\u0019\u0004\u001da\u0001\u0002\u0004%I!!\u000e\u0002\u001bA\u0014XM\u001e,bYV,w\fJ3r)\ry\u0018q\u0007\u0005\u000b\u0003\u000f\t\t$!AA\u0002\u0005-\u0002\u0002CA\u001ea\u0002\u0006K!a\u000b\u0002\u0015A\u0014XM\u001e,bYV,\u0007\u0005C\u0004\u0002@A$\t%!\u0011\u00025\u001d\fG\u000f[3s\u0007>l\u0007O]3tg&\u0014\u0017\u000e\\5usN#\u0018\r^:\u0015\u000b}\f\u0019%a\u0015\t\u0011\u0005\u0015\u0013Q\ba\u0001\u0003\u000f\n1A]8x!\u0011\tI%a\u0014\u000e\u0005\u0005-#bAA'\u0011\u0005A1-\u0019;bYf\u001cH/\u0003\u0003\u0002R\u0005-#aC%oi\u0016\u0014h.\u00197S_^Dq!!\u0016\u0002>\u0001\u00071&A\u0004pe\u0012Lg.\u00197\t\u000f\u0005e\u0003\u000f\"\u0011\u0002\\\u0005A1m\\7qe\u0016\u001c8\u000fF\u0003F\u0003;\n\t\u0007C\u0004\u0002`\u0005]\u0003\u0019A#\u0002\t\u0019\u0014x.\u001c\u0005\b\u0003G\n9\u00061\u0001F\u0003\t!xNB\u00035%\u0001\t9gE\u0003\u0002fU\tI\u0007E\u0002\u0012gMD\u0011\u0002RA3\u0005\u0003\u0005\u000b\u0011B#\t\u00159\u000b)G!A!\u0002\u0013\ty\u0007E\u0002Q#NDq!JA3\t\u0003\t\u0019\b\u0006\u0004\u0002v\u0005]\u0014\u0011\u0010\t\u0004s\u0006\u0015\u0004B\u0002#\u0002r\u0001\u0007Q\tC\u0004O\u0003c\u0002\r!a\u001c\t\u0019\u0005u\u0014Q\ra\u0001\u0002\u0004%I!!\u000b\u0002\tA\u0014XM\u001e\u0005\r\u0003\u0003\u000b)\u00071AA\u0002\u0013%\u00111Q\u0001\taJ,go\u0018\u0013fcR\u0019q0!\"\t\u0015\u0005\u001d\u0011qPA\u0001\u0002\u0004\tY\u0003C\u0005\u0002\n\u0006\u0015\u0004\u0015)\u0003\u0002,\u0005)\u0001O]3wA!A\u0011QRA3\t\u0003\ny)A\u0004iCNtU\r\u001f;\u0016\u0003\u0005D\u0001\"a%\u0002f\u0011\u0005\u0013QS\u0001\u0005]\u0016DH\u000fF\u0003\u0000\u0003/\u000bI\n\u0003\u0005\u0002F\u0005E\u0005\u0019AA$\u0011\u001d\t)&!%A\u0002-B\u0001\"!(\u0002f\u0011\u0005\u0013qT\u0001\u000bI\u0016\u001cw.\u001c9sKN\u001cH#B@\u0002\"\u0006E\u0006\u0002CAR\u00037\u0003\r!!*\u0002\u0019\r|G.^7o-\u0016\u001cGo\u001c:\u0011\t\u0005\u001d\u0016QV\u0007\u0003\u0003SS1!a+\u0007\u0003)1Xm\u0019;pe&TX\rZ\u0005\u0005\u0003_\u000bIK\u0001\u000bXe&$\u0018M\u00197f\u0007>dW/\u001c8WK\u000e$xN\u001d\u0005\b\u0003g\u000bY\n1\u0001,\u0003!\u0019\u0017\r]1dSRL\b\"CA\\%\u0005\u0005I\u0011IA]\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0018\t\u0005\u0003{\u000b\u0019-\u0004\u0002\u0002@*\u0019\u0011\u0011Y%\u0002\t1\fgnZ\u0005\u0005\u0003\u000b\fyL\u0001\u0004TiJLgn\u001a\u0005\t\u0003\u0013\u0014\u0012\u0011!C\u0001U\u0005a\u0001O]8ek\u000e$\u0018I]5us\"I\u0011Q\u001a\n\u0002\u0002\u0013\u0005\u0011qZ\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\ri\u0017\u0011\u001b\u0005\n\u0003\u000f\tY-!AA\u0002-B\u0011\"!6\u0013\u0003\u0003%\t%a6\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!7\u0011\u000b\u0005m\u0017\u0011]7\u000e\u0005\u0005u'bAAp/\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\r\u0018Q\u001c\u0002\t\u0013R,'/\u0019;pe\"I\u0011q\u001d\n\u0002\u0002\u0013\u0005\u0011\u0011^\u0001\tG\u0006tW)];bYR\u0019\u0011-a;\t\u0013\u0005\u001d\u0011Q]A\u0001\u0002\u0004i\u0007\"CAx%\u0005\u0005I\u0011IAy\u0003!A\u0017m\u001d5D_\u0012,G#A\u0016\t\u0013\u0005U(#!A\u0005B\u0005]\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005m\u0006\"CA~%\u0005\u0005I\u0011BA\u007f\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005}\b\u0003BA_\u0005\u0003IAAa\u0001\u0002@\n1qJ\u00196fGR\u0004")
public final class LongDelta {
    public static String toString() {
        return LongDelta$.MODULE$.toString();
    }

    public static int hashCode() {
        return LongDelta$.MODULE$.hashCode();
    }

    public static boolean canEqual(Object object) {
        return LongDelta$.MODULE$.canEqual(object);
    }

    public static Iterator<Object> productIterator() {
        return LongDelta$.MODULE$.productIterator();
    }

    public static Object productElement(int n) {
        return LongDelta$.MODULE$.productElement(n);
    }

    public static int productArity() {
        return LongDelta$.MODULE$.productArity();
    }

    public static String productPrefix() {
        return LongDelta$.MODULE$.productPrefix();
    }

    public static boolean supports(ColumnType<?> columnType) {
        return LongDelta$.MODULE$.supports(columnType);
    }

    public static <T extends AtomicType> org.apache.spark.sql.execution.columnar.compression.Encoder<T> encoder(NativeColumnType<T> nativeColumnType) {
        return LongDelta$.MODULE$.encoder(nativeColumnType);
    }

    public static <T extends AtomicType> org.apache.spark.sql.execution.columnar.compression.Decoder<T> decoder(ByteBuffer byteBuffer, NativeColumnType<T> nativeColumnType) {
        return LongDelta$.MODULE$.decoder(byteBuffer, nativeColumnType);
    }

    public static int typeId() {
        return LongDelta$.MODULE$.typeId();
    }

    public static class Encoder
    implements org.apache.spark.sql.execution.columnar.compression.Encoder<LongType$> {
        private int _compressedSize;
        private int _uncompressedSize;
        private long prevValue;

        @Override
        public double compressionRatio() {
            return Encoder$class.compressionRatio(this);
        }

        public int _compressedSize() {
            return this._compressedSize;
        }

        public void _compressedSize_$eq(int x$1) {
            this._compressedSize = x$1;
        }

        public int _uncompressedSize() {
            return this._uncompressedSize;
        }

        public void _uncompressedSize_$eq(int x$1) {
            this._uncompressedSize = x$1;
        }

        @Override
        public int compressedSize() {
            return this._compressedSize();
        }

        @Override
        public int uncompressedSize() {
            return this._uncompressedSize();
        }

        private long prevValue() {
            return this.prevValue;
        }

        private void prevValue_$eq(long x$1) {
            this.prevValue = x$1;
        }

        @Override
        public void gatherCompressibilityStats(InternalRow row, int ordinal) {
            long value = row.getLong(ordinal);
            long delta = value - this.prevValue();
            this._compressedSize_$eq(this._compressedSize() + 1);
            if (this._uncompressedSize() == 0 || delta <= (long)-128 || delta > (long)127) {
                this._compressedSize_$eq(this._compressedSize() + LONG$.MODULE$.defaultSize());
            }
            this._uncompressedSize_$eq(this._uncompressedSize() + LONG$.MODULE$.defaultSize());
            this.prevValue_$eq(value);
        }

        @Override
        public ByteBuffer compress(ByteBuffer from, ByteBuffer to) {
            to.putInt(LongDelta$.MODULE$.typeId());
            if (from.hasRemaining()) {
                long prev = from.getLong();
                to.put((byte)-128);
                to.putLong(prev);
                while (from.hasRemaining()) {
                    ByteBuffer byteBuffer;
                    long current = from.getLong();
                    long delta = current - prev;
                    prev = current;
                    if ((long)-128 < delta && delta <= (long)127) {
                        byteBuffer = to.put((byte)delta);
                        continue;
                    }
                    to.put((byte)-128);
                    byteBuffer = to.putLong(current);
                }
            }
            return (ByteBuffer)to.rewind();
        }

        public Encoder() {
            Encoder$class.$init$(this);
            this._compressedSize = 0;
            this._uncompressedSize = 0;
        }
    }

    public static class Decoder
    implements org.apache.spark.sql.execution.columnar.compression.Decoder<LongType$> {
        private final ByteBuffer buffer;
        private long prev;

        private long prev() {
            return this.prev;
        }

        private void prev_$eq(long x$1) {
            this.prev = x$1;
        }

        @Override
        public boolean hasNext() {
            return this.buffer.hasRemaining();
        }

        @Override
        public void next(InternalRow row, int ordinal) {
            byte delta = this.buffer.get();
            this.prev_$eq(delta > -128 ? this.prev() + (long)delta : ByteBufferHelper$.MODULE$.getLong(this.buffer));
            row.setLong(ordinal, this.prev());
        }

        @Override
        public void decompress(WritableColumnVector columnVector, int capacity) {
            long prevLocal = 0L;
            ByteBuffer nullsBuffer = this.buffer.duplicate().order(ByteOrder.nativeOrder());
            nullsBuffer.rewind();
            int nullCount = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
            int nextNullIndex = nullCount > 0 ? ByteBufferHelper$.MODULE$.getInt(nullsBuffer) : -1;
            int seenNulls = 0;
            for (int pos = 0; pos < capacity; ++pos) {
                if (pos != nextNullIndex) {
                    byte delta = this.buffer.get();
                    prevLocal = delta > -128 ? prevLocal + (long)delta : ByteBufferHelper$.MODULE$.getLong(this.buffer);
                    columnVector.putLong(pos, prevLocal);
                    continue;
                }
                if (++seenNulls < nullCount) {
                    nextNullIndex = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
                }
                columnVector.putNull(pos);
            }
        }

        public Decoder(ByteBuffer buffer, NativeColumnType<LongType$> columnType) {
            this.buffer = buffer;
        }
    }
}

