/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.sources;

import java.util.List;
import java.util.Optional;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.execution.streaming.RateStreamOffset;
import org.apache.spark.sql.execution.streaming.ValueRunTimeMsPair;
import org.apache.spark.sql.execution.streaming.sources.RateStreamBatchTask;
import org.apache.spark.sql.execution.streaming.sources.RateStreamSourceV2$;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.reader.DataReaderFactory;
import org.apache.spark.sql.sources.v2.reader.streaming.MicroBatchReader;
import org.apache.spark.sql.sources.v2.reader.streaming.Offset;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ManualClock;
import org.apache.spark.util.SystemClock;
import org.json4s.DefaultFormats;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.jackson.Serialization$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001B\u0001\u0003\u0001E\u0011!DU1uKN#(/Z1n\u001b&\u001c'o\u001c\"bi\u000eD'+Z1eKJT!a\u0001\u0003\u0002\u000fM|WO]2fg*\u0011QAB\u0001\ngR\u0014X-Y7j]\u001eT!a\u0002\u0005\u0002\u0013\u0015DXmY;uS>t'BA\u0005\u000b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00171\tQa\u001d9be.T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011c\u0001\u0001\u00135A\u00111\u0003G\u0007\u0002))\u0011QCF\u0001\u0005Y\u0006twMC\u0001\u0018\u0003\u0011Q\u0017M^1\n\u0005e!\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001cE5\tAD\u0003\u0002\u0006;)\u0011adH\u0001\u0007e\u0016\fG-\u001a:\u000b\u0005\u0001\n\u0013A\u0001<3\u0015\t\u0019\u0001\"\u0003\u0002$9\t\u0001R*[2s_\n\u000bGo\u00195SK\u0006$WM\u001d\u0005\tK\u0001\u0011\t\u0011)A\u0005M\u00059q\u000e\u001d;j_:\u001c\bCA\u0014)\u001b\u0005y\u0012BA\u0015 \u0005E!\u0015\r^1T_V\u00148-Z(qi&|gn\u001d\u0005\u0006W\u0001!\t\u0001L\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00055z\u0003C\u0001\u0018\u0001\u001b\u0005\u0011\u0001\"B\u0013+\u0001\u00041\u0003bB\u0019\u0001\u0005\u0004%\u0019AM\u0001\u000fI\u00164\u0017-\u001e7u\r>\u0014X.\u0019;t+\u0005\u0019\u0004C\u0001\u001b8\u001b\u0005)$B\u0001\u001c\u000f\u0003\u0019Q7o\u001c85g&\u0011\u0001(\u000e\u0002\u000f\t\u00164\u0017-\u001e7u\r>\u0014X.\u0019;t\u0011\u0019Q\u0004\u0001)A\u0005g\u0005yA-\u001a4bk2$hi\u001c:nCR\u001c\b\u0005C\u0004=\u0001\t\u0007I\u0011A\u001f\u0002\u000b\rdwnY6\u0016\u0003y\u0002\"a\u0010\"\u000e\u0003\u0001S!!\u0011\u0006\u0002\tU$\u0018\u000e\\\u0005\u0003\u0007\u0002\u0013Qa\u00117pG.Da!\u0012\u0001!\u0002\u0013q\u0014AB2m_\u000e\\\u0007\u0005C\u0004H\u0001\t\u0007I\u0011\u0002%\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t+\u0005I\u0005C\u0001&N\u001b\u0005Y%\"\u0001'\u0002\u000bM\u001c\u0017\r\\1\n\u00059[%aA%oi\"1\u0001\u000b\u0001Q\u0001\n%\u000baB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b\u0005C\u0004S\u0001\t\u0007I\u0011B*\u0002\u001bI|wo\u001d)feN+7m\u001c8e+\u0005!\u0006C\u0001&V\u0013\t16J\u0001\u0003M_:<\u0007B\u0002-\u0001A\u0003%A+\u0001\bs_^\u001c\b+\u001a:TK\u000e|g\u000e\u001a\u0011\t\u000fi\u0003!\u0019!C\u0005'\u0006IRn\u001d)feB\u000b'\u000f^5uS>t')\u001a;xK\u0016t'k\\<t\u0011\u0019a\u0006\u0001)A\u0005)\u0006QRn\u001d)feB\u000b'\u000f^5uS>t')\u001a;xK\u0016t'k\\<tA!)a\f\u0001C!?\u0006Q!/Z1e'\u000eDW-\\1\u0015\u0003\u0001\u0004\"!\u00193\u000e\u0003\tT!a\u0019\u0005\u0002\u000bQL\b/Z:\n\u0005\u0015\u0014'AC*ueV\u001cG\u000fV=qK\"9q\r\u0001b\u0001\n\u0003\u0019\u0016AD2sK\u0006$\u0018n\u001c8US6,Wj\u001d\u0005\u0007S\u0002\u0001\u000b\u0011\u0002+\u0002\u001f\r\u0014X-\u0019;j_:$\u0016.\\3Ng\u0002B\u0011b\u001b\u0001A\u0002\u0003\u0007I\u0011\u00027\u0002\u000bM$\u0018M\u001d;\u0016\u00035\u0004\"A\\8\u000e\u0003\u0011I!\u0001\u001d\u0003\u0003!I\u000bG/Z*ue\u0016\fWn\u00144gg\u0016$\b\"\u0003:\u0001\u0001\u0004\u0005\r\u0011\"\u0003t\u0003%\u0019H/\u0019:u?\u0012*\u0017\u000f\u0006\u0002uoB\u0011!*^\u0005\u0003m.\u0013A!\u00168ji\"9\u00010]A\u0001\u0002\u0004i\u0017a\u0001=%c!1!\u0010\u0001Q!\n5\faa\u001d;beR\u0004\u0003\"\u0003?\u0001\u0001\u0004\u0005\r\u0011\"\u0003m\u0003\r)g\u000e\u001a\u0005\n}\u0002\u0001\r\u00111A\u0005\n}\fq!\u001a8e?\u0012*\u0017\u000fF\u0002u\u0003\u0003Aq\u0001_?\u0002\u0002\u0003\u0007Q\u000eC\u0004\u0002\u0006\u0001\u0001\u000b\u0015B7\u0002\t\u0015tG\r\t\u0005\b\u0003\u0013\u0001A\u0011IA\u0006\u00039\u0019X\r^(gMN,GOU1oO\u0016$R\u0001^A\u0007\u0003?Aqa[A\u0004\u0001\u0004\ty\u0001\u0005\u0004\u0002\u0012\u0005U\u0011\u0011D\u0007\u0003\u0003'Q!!\u0011\f\n\t\u0005]\u00111\u0003\u0002\t\u001fB$\u0018n\u001c8bYB\u00191$a\u0007\n\u0007\u0005uAD\u0001\u0004PM\u001a\u001cX\r\u001e\u0005\by\u0006\u001d\u0001\u0019AA\b\u0011\u001d\t\u0019\u0003\u0001C!\u0003K\tabZ3u'R\f'\u000f^(gMN,G\u000f\u0006\u0002\u0002\u001a!9\u0011\u0011\u0006\u0001\u0005B\u0005\u0015\u0012\u0001D4fi\u0016sGm\u00144gg\u0016$\bbBA\u0017\u0001\u0011\u0005\u0013qF\u0001\u0012I\u0016\u001cXM]5bY&TXm\u00144gg\u0016$H\u0003BA\r\u0003cA\u0001\"a\r\u0002,\u0001\u0007\u0011QG\u0001\u0005UN|g\u000e\u0005\u0003\u00028\u0005ubb\u0001&\u0002:%\u0019\u00111H&\u0002\rA\u0013X\rZ3g\u0013\u0011\ty$!\u0011\u0003\rM#(/\u001b8h\u0015\r\tYd\u0013\u0005\b\u0003\u000b\u0002A\u0011IA$\u0003e\u0019'/Z1uK\u0012\u000bG/\u0019*fC\u0012,'OR1di>\u0014\u0018.Z:\u0015\u0005\u0005%\u0003CBA\t\u0003\u0017\ny%\u0003\u0003\u0002N\u0005M!\u0001\u0002'jgR\u0004b!!\u0015\u0002T\u0005]S\"A\u000f\n\u0007\u0005USDA\tECR\f'+Z1eKJ4\u0015m\u0019;pef\u0004B!!\u0017\u0002\\5\t\u0001\"C\u0002\u0002^!\u00111AU8x\u0011\u001d\t\t\u0007\u0001C!\u0003G\naaY8n[&$Hc\u0001;\u0002f!9A0a\u0018A\u0002\u0005e\u0001bBA5\u0001\u0011\u0005\u00131N\u0001\u0005gR|\u0007\u000fF\u0001u\u0001")
public class RateStreamMicroBatchReader
implements MicroBatchReader {
    private final DefaultFormats defaultFormats = DefaultFormats$.MODULE$;
    private final Clock clock;
    private final int org$apache$spark$sql$execution$streaming$sources$RateStreamMicroBatchReader$$numPartitions;
    private final long rowsPerSecond;
    private final long org$apache$spark$sql$execution$streaming$sources$RateStreamMicroBatchReader$$msPerPartitionBetweenRows;
    private final long creationTimeMs;
    private RateStreamOffset start;
    private RateStreamOffset end;

    public DefaultFormats defaultFormats() {
        return this.defaultFormats;
    }

    public Clock clock() {
        return this.clock;
    }

    public int org$apache$spark$sql$execution$streaming$sources$RateStreamMicroBatchReader$$numPartitions() {
        return this.org$apache$spark$sql$execution$streaming$sources$RateStreamMicroBatchReader$$numPartitions;
    }

    private long rowsPerSecond() {
        return this.rowsPerSecond;
    }

    public long org$apache$spark$sql$execution$streaming$sources$RateStreamMicroBatchReader$$msPerPartitionBetweenRows() {
        return this.org$apache$spark$sql$execution$streaming$sources$RateStreamMicroBatchReader$$msPerPartitionBetweenRows;
    }

    @Override
    public StructType readSchema() {
        StructField structField = new StructField("timestamp", (DataType)TimestampType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("value", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        return StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
    }

    public long creationTimeMs() {
        return this.creationTimeMs;
    }

    private RateStreamOffset start() {
        return this.start;
    }

    private void start_$eq(RateStreamOffset x$1) {
        this.start = x$1;
    }

    private RateStreamOffset end() {
        return this.end;
    }

    private void end_$eq(RateStreamOffset x$1) {
        this.end = x$1;
    }

    @Override
    public void setOffsetRange(Optional<Offset> start2, Optional<Offset> end) {
        this.start_$eq((RateStreamOffset)start2.orElse(RateStreamSourceV2$.MODULE$.createInitialOffset(this.org$apache$spark$sql$execution$streaming$sources$RateStreamMicroBatchReader$$numPartitions(), this.creationTimeMs())));
        long currentTime = this.clock().getTimeMillis();
        this.end_$eq((RateStreamOffset)end.orElse(new RateStreamOffset((Map<Object, ValueRunTimeMsPair>)((Map)this.start().partitionToValueAndRunTimeMs().map((Function1)new Serializable(this, currentTime){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RateStreamMicroBatchReader $outer;
            private final long currentTime$1;

            public final Tuple2<Object, ValueRunTimeMsPair> apply(Tuple2<Object, ValueRunTimeMsPair> x0$1) {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    int part = tuple2._1$mcI$sp();
                    ValueRunTimeMsPair valueRunTimeMsPair = (ValueRunTimeMsPair)tuple2._2();
                    if (valueRunTimeMsPair != null) {
                        long currentVal = valueRunTimeMsPair.value();
                        long currentReadTime = valueRunTimeMsPair.runTimeMs();
                        long readInterval = this.currentTime$1 - currentReadTime;
                        long numNewRows = readInterval / this.$outer.org$apache$spark$sql$execution$streaming$sources$RateStreamMicroBatchReader$$msPerPartitionBetweenRows();
                        Tuple2 tuple22 = numNewRows <= 0L ? tuple2 : new Tuple2((Object)BoxesRunTime.boxToInteger((int)part), (Object)new ValueRunTimeMsPair(currentVal + numNewRows * (long)this.$outer.org$apache$spark$sql$execution$streaming$sources$RateStreamMicroBatchReader$$numPartitions(), currentReadTime + numNewRows * this.$outer.org$apache$spark$sql$execution$streaming$sources$RateStreamMicroBatchReader$$msPerPartitionBetweenRows()));
                        return tuple22;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.currentTime$1 = currentTime$1;
            }
        }, Map$.MODULE$.canBuildFrom())))));
    }

    @Override
    public Offset getStartOffset() {
        if (this.start() == null) {
            throw new IllegalStateException("start offset not set");
        }
        return this.start();
    }

    @Override
    public Offset getEndOffset() {
        if (this.end() == null) {
            throw new IllegalStateException("end offset not set");
        }
        return this.end();
    }

    @Override
    public Offset deserializeOffset(String json) {
        return new RateStreamOffset((Map<Object, ValueRunTimeMsPair>)((Map)Serialization$.MODULE$.read(json, (Formats)this.defaultFormats(), ManifestFactory$.MODULE$.classType(Map.class, (Manifest)ManifestFactory$.MODULE$.Int(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(ValueRunTimeMsPair.class)})))));
    }

    @Override
    public List<DataReaderFactory<Row>> createDataReaderFactories() {
        Map<Object, ValueRunTimeMsPair> startMap = this.start().partitionToValueAndRunTimeMs();
        Map<Object, ValueRunTimeMsPair> endMap = this.end().partitionToValueAndRunTimeMs();
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)endMap.keys().toSeq().map((Function1)new Serializable(this, startMap, endMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RateStreamMicroBatchReader $outer;
            private final Map startMap$1;
            private final Map endMap$1;

            public final DataReaderFactory<Row> apply(int part) {
                ValueRunTimeMsPair valueRunTimeMsPair = (ValueRunTimeMsPair)this.endMap$1.apply((Object)BoxesRunTime.boxToInteger((int)part));
                if (valueRunTimeMsPair != null) {
                    long endVal;
                    long l;
                    long endVal2 = l = (endVal = valueRunTimeMsPair.value());
                    ValueRunTimeMsPair valueRunTimeMsPair2 = (ValueRunTimeMsPair)this.startMap$1.apply((Object)BoxesRunTime.boxToInteger((int)part));
                    if (valueRunTimeMsPair2 != null) {
                        Tuple2.mcJJ.sp sp2;
                        long startVal = valueRunTimeMsPair2.value();
                        long startTimeMs = valueRunTimeMsPair2.runTimeMs();
                        Tuple2.mcJJ.sp sp3 = sp2 = new Tuple2.mcJJ.sp(startVal, startTimeMs);
                        long startVal2 = sp3._1$mcJ$sp();
                        long startTimeMs2 = sp3._2$mcJ$sp();
                        ListBuffer packedRows = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                        long outVal = startVal2 + (long)this.$outer.org$apache$spark$sql$execution$streaming$sources$RateStreamMicroBatchReader$$numPartitions();
                        long outTimeMs = startTimeMs2;
                        while (outVal <= endVal2) {
                            packedRows.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(outTimeMs, outVal)}));
                            outVal += (long)this.$outer.org$apache$spark$sql$execution$streaming$sources$RateStreamMicroBatchReader$$numPartitions();
                            outTimeMs += this.$outer.org$apache$spark$sql$execution$streaming$sources$RateStreamMicroBatchReader$$msPerPartitionBetweenRows();
                        }
                        return new RateStreamBatchTask((Seq<Tuple2<Object, Object>>)packedRows);
                    }
                    throw new MatchError((Object)valueRunTimeMsPair2);
                }
                throw new MatchError((Object)valueRunTimeMsPair);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.startMap$1 = startMap$1;
                this.endMap$1 = endMap$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toList()).asJava();
    }

    @Override
    public void commit(Offset end) {
    }

    @Override
    public void stop() {
    }

    public RateStreamMicroBatchReader(DataSourceOptions options) {
        this.clock = new StringOps(Predef$.MODULE$.augmentString(options.get("useManualClock").orElse("false"))).toBoolean() ? new ManualClock() : new SystemClock();
        this.org$apache$spark$sql$execution$streaming$sources$RateStreamMicroBatchReader$$numPartitions = new StringOps(Predef$.MODULE$.augmentString(options.get(RateStreamSourceV2$.MODULE$.NUM_PARTITIONS()).orElse("5"))).toInt();
        this.rowsPerSecond = new StringOps(Predef$.MODULE$.augmentString(options.get(RateStreamSourceV2$.MODULE$.ROWS_PER_SECOND()).orElse("6"))).toLong();
        this.org$apache$spark$sql$execution$streaming$sources$RateStreamMicroBatchReader$$msPerPartitionBetweenRows = (long)(1000 * this.org$apache$spark$sql$execution$streaming$sources$RateStreamMicroBatchReader$$numPartitions()) / this.rowsPerSecond();
        this.creationTimeMs = this.clock().getTimeMillis();
    }
}

