/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.continuous;

import java.util.List;
import java.util.Optional;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.execution.streaming.RateSourceProvider$;
import org.apache.spark.sql.execution.streaming.RateStreamOffset;
import org.apache.spark.sql.execution.streaming.ValueRunTimeMsPair;
import org.apache.spark.sql.execution.streaming.continuous.RateStreamContinuousDataReaderFactory;
import org.apache.spark.sql.execution.streaming.continuous.RateStreamPartitionOffset;
import org.apache.spark.sql.execution.streaming.sources.RateStreamSourceV2$;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.reader.DataReaderFactory;
import org.apache.spark.sql.sources.v2.reader.streaming.ContinuousReader;
import org.apache.spark.sql.sources.v2.reader.streaming.Offset;
import org.apache.spark.sql.sources.v2.reader.streaming.PartitionOffset;
import org.apache.spark.sql.types.StructType;
import org.json4s.DefaultFormats;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.jackson.Serialization$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001B\u0001\u0003\u0001E\u0011!DU1uKN#(/Z1n\u0007>tG/\u001b8v_V\u001c(+Z1eKJT!a\u0001\u0003\u0002\u0015\r|g\u000e^5ok>,8O\u0003\u0002\u0006\r\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f!\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005%Q\u0011aA:rY*\u00111\u0002D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001b9\ta!\u00199bG\",'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0011\"\u0004\u0005\u0002\u001415\tAC\u0003\u0002\u0016-\u0005!A.\u00198h\u0015\u00059\u0012\u0001\u00026bm\u0006L!!\u0007\u000b\u0003\r=\u0013'.Z2u!\tY2%D\u0001\u001d\u0015\t)QD\u0003\u0002\u001f?\u00051!/Z1eKJT!\u0001I\u0011\u0002\u0005Y\u0014$B\u0001\u0012\t\u0003\u001d\u0019x.\u001e:dKNL!\u0001\n\u000f\u0003!\r{g\u000e^5ok>,8OU3bI\u0016\u0014\b\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\u0002\u000f=\u0004H/[8ogB\u0011\u0001&K\u0007\u0002?%\u0011!f\b\u0002\u0012\t\u0006$\u0018mU8ve\u000e,w\n\u001d;j_:\u001c\b\"\u0002\u0017\u0001\t\u0003i\u0013A\u0002\u001fj]&$h\b\u0006\u0002/aA\u0011q\u0006A\u0007\u0002\u0005!)ae\u000ba\u0001O!9!\u0007\u0001b\u0001\n\u0007\u0019\u0014A\u00043fM\u0006,H\u000e\u001e$pe6\fGo]\u000b\u0002iA\u0011Q\u0007O\u0007\u0002m)\u0011qGD\u0001\u0007UN|g\u000eN:\n\u0005e2$A\u0004#fM\u0006,H\u000e\u001e$pe6\fGo\u001d\u0005\u0007w\u0001\u0001\u000b\u0011\u0002\u001b\u0002\u001f\u0011,g-Y;mi\u001a{'/\\1ug\u0002Bq!\u0010\u0001C\u0002\u0013\u0005a(\u0001\u0007de\u0016\fG/[8o)&lW-F\u0001@!\t\u00015)D\u0001B\u0015\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#B\u0005\u0011auN\\4\t\r\u0019\u0003\u0001\u0015!\u0003@\u00035\u0019'/Z1uS>tG+[7fA!9\u0001\n\u0001b\u0001\n\u0003I\u0015!\u00048v[B\u000b'\u000f^5uS>t7/F\u0001K!\t\u00015*\u0003\u0002M\u0003\n\u0019\u0011J\u001c;\t\r9\u0003\u0001\u0015!\u0003K\u00039qW/\u001c)beRLG/[8og\u0002Bq\u0001\u0015\u0001C\u0002\u0013\u0005a(A\u0007s_^\u001c\b+\u001a:TK\u000e|g\u000e\u001a\u0005\u0007%\u0002\u0001\u000b\u0011B \u0002\u001dI|wo\u001d)feN+7m\u001c8eA!9A\u000b\u0001b\u0001\n\u0003)\u0016\u0001\u00059feB\u000b'\u000f^5uS>t'+\u0019;f+\u00051\u0006C\u0001!X\u0013\tA\u0016I\u0001\u0004E_V\u0014G.\u001a\u0005\u00075\u0002\u0001\u000b\u0011\u0002,\u0002#A,'\u000fU1si&$\u0018n\u001c8SCR,\u0007\u0005C\u0003]\u0001\u0011\u0005S,\u0001\u0007nKJ<Wm\u00144gg\u0016$8\u000f\u0006\u0002_CB\u00111dX\u0005\u0003Ar\u0011aa\u00144gg\u0016$\b\"\u00022\\\u0001\u0004\u0019\u0017aB8gMN,Go\u001d\t\u0004\u0001\u00124\u0017BA3B\u0005\u0015\t%O]1z!\tYr-\u0003\u0002i9\ty\u0001+\u0019:uSRLwN\\(gMN,G\u000fC\u0003k\u0001\u0011\u00053.A\teKN,'/[1mSj,wJ\u001a4tKR$\"A\u00187\t\u000b5L\u0007\u0019\u00018\u0002\t)\u001cxN\u001c\t\u0003_Jt!\u0001\u00119\n\u0005E\f\u0015A\u0002)sK\u0012,g-\u0003\u0002ti\n11\u000b\u001e:j]\u001eT!!]!\t\u000bY\u0004A\u0011I<\u0002\u0015I,\u0017\rZ*dQ\u0016l\u0017\rF\u0001y!\tIH0D\u0001{\u0015\tY\b\"A\u0003usB,7/\u0003\u0002~u\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u0015}\u0004\u0001\u0019!a\u0001\n\u0013\t\t!\u0001\u0004pM\u001a\u001cX\r^\u000b\u0002=\"Y\u0011Q\u0001\u0001A\u0002\u0003\u0007I\u0011BA\u0004\u0003)ygMZ:fi~#S-\u001d\u000b\u0005\u0003\u0013\ty\u0001E\u0002A\u0003\u0017I1!!\u0004B\u0005\u0011)f.\u001b;\t\u0013\u0005E\u00111AA\u0001\u0002\u0004q\u0016a\u0001=%c!9\u0011Q\u0003\u0001!B\u0013q\u0016aB8gMN,G\u000f\t\u0005\b\u00033\u0001A\u0011IA\u000e\u00039\u0019X\r^*uCJ$xJ\u001a4tKR$B!!\u0003\u0002\u001e!9q0a\u0006A\u0002\u0005}\u0001#BA\u0011\u0003OqVBAA\u0012\u0015\r\t)CF\u0001\u0005kRLG.\u0003\u0003\u0002*\u0005\r\"\u0001C(qi&|g.\u00197\t\u000f\u00055\u0002\u0001\"\u0011\u00020\u0005qq-\u001a;Ti\u0006\u0014Ho\u00144gg\u0016$H#\u00010\t\u000f\u0005M\u0002\u0001\"\u0011\u00026\u0005I2M]3bi\u0016$\u0015\r^1SK\u0006$WM\u001d$bGR|'/[3t)\t\t9\u0004\u0005\u0004\u0002\"\u0005e\u0012QH\u0005\u0005\u0003w\t\u0019C\u0001\u0003MSN$\bCBA \u0003\u0003\n)%D\u0001\u001e\u0013\r\t\u0019%\b\u0002\u0012\t\u0006$\u0018MU3bI\u0016\u0014h)Y2u_JL\b\u0003BA$\u0003\u0013j\u0011\u0001C\u0005\u0004\u0003\u0017B!a\u0001*po\"9\u0011q\n\u0001\u0005B\u0005E\u0013AB2p[6LG\u000f\u0006\u0003\u0002\n\u0005M\u0003bBA+\u0003\u001b\u0002\rAX\u0001\u0004K:$\u0007bBA-\u0001\u0011\u0005\u00131L\u0001\u0005gR|\u0007\u000f\u0006\u0002\u0002\n\u0001")
public class RateStreamContinuousReader
implements ContinuousReader {
    private final DefaultFormats defaultFormats = DefaultFormats$.MODULE$;
    private final long creationTime = System.currentTimeMillis();
    private final int numPartitions;
    private final long rowsPerSecond;
    private final double perPartitionRate;
    private Offset offset;

    public DefaultFormats defaultFormats() {
        return this.defaultFormats;
    }

    public long creationTime() {
        return this.creationTime;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public long rowsPerSecond() {
        return this.rowsPerSecond;
    }

    public double perPartitionRate() {
        return this.perPartitionRate;
    }

    @Override
    public Offset mergeOffsets(PartitionOffset[] offsets) {
        Predef$.MODULE$.assert(offsets.length == this.numPartitions());
        Tuple2[] tuples = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])offsets).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, ValueRunTimeMsPair> apply(PartitionOffset x0$1) {
                PartitionOffset partitionOffset = x0$1;
                if (partitionOffset instanceof RateStreamPartitionOffset) {
                    RateStreamPartitionOffset rateStreamPartitionOffset = (RateStreamPartitionOffset)partitionOffset;
                    int i = rateStreamPartitionOffset.partition();
                    long currVal = rateStreamPartitionOffset.currentValue();
                    long nextRead = rateStreamPartitionOffset.currentTimeMs();
                    Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)new ValueRunTimeMsPair(currVal, nextRead));
                    return tuple2;
                }
                throw new MatchError((Object)partitionOffset);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        return new RateStreamOffset((Map<Object, ValueRunTimeMsPair>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuples))));
    }

    @Override
    public Offset deserializeOffset(String json) {
        return new RateStreamOffset((Map<Object, ValueRunTimeMsPair>)((Map)Serialization$.MODULE$.read(json, (Formats)this.defaultFormats(), ManifestFactory$.MODULE$.classType(Map.class, (Manifest)ManifestFactory$.MODULE$.Int(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(ValueRunTimeMsPair.class)})))));
    }

    @Override
    public StructType readSchema() {
        return RateSourceProvider$.MODULE$.SCHEMA();
    }

    private Offset offset() {
        return this.offset;
    }

    private void offset_$eq(Offset x$1) {
        this.offset = x$1;
    }

    @Override
    public void setStartOffset(Optional<Offset> offset) {
        this.offset_$eq(offset.orElse(RateStreamSourceV2$.MODULE$.createInitialOffset(this.numPartitions(), this.creationTime())));
    }

    @Override
    public Offset getStartOffset() {
        return this.offset();
    }

    @Override
    public List<DataReaderFactory<Row>> createDataReaderFactories() {
        Offset offset = this.offset();
        if (offset instanceof RateStreamOffset) {
            RateStreamOffset rateStreamOffset = (RateStreamOffset)offset;
            Map<Object, ValueRunTimeMsPair> map2 = rateStreamOffset.partitionToValueAndRunTimeMs();
            Map<Object, ValueRunTimeMsPair> partitionStartMap = map2;
            if (partitionStartMap.keySet().size() != this.numPartitions()) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The previous run contained ", " partitions, but"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitionStartMap.keySet().size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " partitions are currently configured. The numPartitions option"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numPartitions())}))).append((Object)" cannot be changed.").toString());
            }
            return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.Range().apply(0, this.numPartitions()).map((Function1)new Serializable(this, partitionStartMap){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RateStreamContinuousReader $outer;
                private final Map partitionStartMap$1;

                public final DataReaderFactory<Row> apply(int i) {
                    ValueRunTimeMsPair start2 = (ValueRunTimeMsPair)this.partitionStartMap$1.apply((Object)BoxesRunTime.boxToInteger((int)i));
                    return new RateStreamContinuousDataReaderFactory(start2.value(), start2.runTimeMs(), i, this.$outer.numPartitions(), this.$outer.perPartitionRate());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.partitionStartMap$1 = partitionStartMap$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom())).asJava();
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid offset type ", " for ContinuousRateSource"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{offset.getClass()})));
    }

    @Override
    public void commit(Offset end) {
    }

    @Override
    public void stop() {
    }

    public RateStreamContinuousReader(DataSourceOptions options) {
        this.numPartitions = new StringOps(Predef$.MODULE$.augmentString(options.get(RateStreamSourceV2$.MODULE$.NUM_PARTITIONS()).orElse("5"))).toInt();
        this.rowsPerSecond = new StringOps(Predef$.MODULE$.augmentString(options.get(RateStreamSourceV2$.MODULE$.ROWS_PER_SECOND()).orElse("6"))).toLong();
        this.perPartitionRate = (double)this.rowsPerSecond() / (double)this.numPartitions();
    }
}

