/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.jdbc;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Locale;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.executor.InputMetrics;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.expressions.SpecificInternalRow;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.execution.datasources.jdbc.DriverRegistry$;
import org.apache.spark.sql.execution.datasources.jdbc.DriverWrapper;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$$anonfun$16$;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$$anonfun$org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcDialects$;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.NextIterator;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class JdbcUtils$
implements Logging {
    public static final JdbcUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new JdbcUtils$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public Function0<Connection> createConnectionFactory(JDBCOptions options) {
        String driverClass = options.driverClass();
        return new Serializable(options, driverClass){
            public static final long serialVersionUID = 0L;
            private final JDBCOptions options$1;
            public final String driverClass$1;

            public final Connection apply() {
                DriverRegistry$.MODULE$.register(this.driverClass$1);
                Driver driver = (Driver)((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(DriverManager.getDrivers()).asScala()).collectFirst((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.createConnectionFactory.1 $outer;

                    /*
                     * WARNING - void declaration
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends Driver, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        void var6_9;
                        A1 A1 = x1;
                        if (A1 instanceof DriverWrapper) {
                            DriverWrapper driverWrapper = (DriverWrapper)A1;
                            String string = driverWrapper.wrapped().getClass().getCanonicalName();
                            String string2 = this.$outer.driverClass$1;
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                DriverWrapper driverWrapper2 = driverWrapper;
                                return var6_9;
                            }
                        }
                        String string = A1.getClass().getCanonicalName();
                        String string3 = this.$outer.driverClass$1;
                        if (!(string != null ? !string.equals(string3) : string3 != null)) {
                            A1 A12 = A1;
                            return var6_9;
                        }
                        Object object = function1.apply(x1);
                        return var6_9;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean isDefinedAt(Driver x1) {
                        Driver driver = x1;
                        if (driver instanceof DriverWrapper) {
                            DriverWrapper driverWrapper = (DriverWrapper)driver;
                            String string = driverWrapper.wrapped().getClass().getCanonicalName();
                            String string2 = this.$outer.driverClass$1;
                            if (string == null) {
                                if (string2 == null) return true;
                            } else if (string.equals(string2)) {
                                return true;
                            }
                        }
                        String string = driver.getClass().getCanonicalName();
                        String string3 = this.$outer.driverClass$1;
                        if (string != null) {
                            if (!string.equals(string3)) return false;
                            return true;
                        }
                        if (string3 == null) return true;
                        return false;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.createConnectionFactory.1 $outer;

                    public final Nothing$ apply() {
                        throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not find registered driver with class ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.driverClass$1})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return driver.connect(this.options$1.url(), this.options$1.asConnectionProperties());
            }
            {
                this.options$1 = options$1;
                this.driverClass$1 = driverClass$1;
            }
        };
    }

    public boolean tableExists(Connection conn, JDBCOptions options) {
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(options.url());
        return Try$.MODULE$.apply((Function0)new Serializable(conn, options, dialect){
            public static final long serialVersionUID = 0L;
            private final Connection conn$1;
            private final JDBCOptions options$2;
            private final JdbcDialect dialect$1;

            /*
             * WARNING - void declaration
             */
            public final ResultSet apply() {
                ResultSet resultSet;
                PreparedStatement statement = this.conn$1.prepareStatement(this.dialect$1.getTableExistsQuery(this.options$2.table()));
                try {
                    resultSet = statement.executeQuery();
                }
                catch (Throwable throwable) {
                    void var1_1;
                    var1_1.close();
                    throw throwable;
                }
                statement.close();
                return resultSet;
            }
            {
                this.conn$1 = conn$1;
                this.options$2 = options$2;
                this.dialect$1 = dialect$1;
            }
        }).isSuccess();
    }

    /*
     * WARNING - void declaration
     */
    public void dropTable(Connection conn, String table) {
        Statement statement = conn.createStatement();
        try {
            statement.executeUpdate(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP TABLE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table})));
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        statement.close();
    }

    /*
     * WARNING - void declaration
     */
    public void truncateTable(Connection conn, String table) {
        Statement statement = conn.createStatement();
        try {
            statement.executeUpdate(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TRUNCATE TABLE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table})));
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        statement.close();
    }

    public Option<Object> isCascadingTruncateTable(String url) {
        return JdbcDialects$.MODULE$.get(url).isCascadingTruncateTable();
    }

    public String getInsertStatement(String table, StructType rddSchema, Option<StructType> tableSchema, boolean isCaseSensitive, JdbcDialect dialect) {
        String string;
        if (tableSchema.isEmpty()) {
            string = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])rddSchema.fields()).map((Function1)new Serializable(dialect){
                public static final long serialVersionUID = 0L;
                private final JdbcDialect dialect$2;

                public final String apply(StructField x) {
                    return this.dialect$2.quoteIdentifier(x.name());
                }
                {
                    this.dialect$2 = dialect$2;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(",");
        } else {
            Function2 columnNameEquality = isCaseSensitive ? package$.MODULE$.caseSensitiveResolution() : package$.MODULE$.caseInsensitiveResolution();
            String[] tableColumnNames = ((StructType)tableSchema.get()).fieldNames();
            string = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])rddSchema.fields()).map((Function1)new Serializable(tableSchema, dialect, columnNameEquality, tableColumnNames){
                public static final long serialVersionUID = 0L;
                public final Option tableSchema$1;
                private final JdbcDialect dialect$2;
                public final Function2 columnNameEquality$1;
                private final String[] tableColumnNames$1;

                public final String apply(StructField col) {
                    String normalizedName = (String)Predef$.MODULE$.refArrayOps((Object[])this.tableColumnNames$1).find((Function1)new Serializable(this, col){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.4 $outer;
                        private final StructField col$1;

                        public final boolean apply(String f) {
                            return BoxesRunTime.unboxToBoolean((Object)this.$outer.columnNameEquality$1.apply((Object)f, (Object)this.col$1.name()));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.col$1 = col$1;
                        }
                    }).getOrElse((Function0)new Serializable(this, col){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.4 $outer;
                        private final StructField col$1;

                        public final Nothing$ apply() {
                            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Column \"", "\" not found in schema ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.col$1.name(), this.$outer.tableSchema$1})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.col$1 = col$1;
                        }
                    });
                    return this.dialect$2.quoteIdentifier(normalizedName);
                }
                {
                    this.tableSchema$1 = tableSchema$1;
                    this.dialect$2 = dialect$2;
                    this.columnNameEquality$1 = columnNameEquality$1;
                    this.tableColumnNames$1 = tableColumnNames$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(",");
        }
        String columns2 = string;
        String placeholders = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])rddSchema.fields()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$1) {
                return "?";
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(",");
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", " (", ") VALUES (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table, columns2, placeholders}));
    }

    public Option<JdbcType> getCommonJDBCType(DataType dt) {
        Option option;
        DataType dataType = dt;
        if (IntegerType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("INTEGER", 4));
        } else if (LongType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("BIGINT", -5));
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("DOUBLE PRECISION", 8));
        } else if (FloatType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("REAL", 6));
        } else if (ShortType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("INTEGER", 5));
        } else if (ByteType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("BYTE", -6));
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("BIT(1)", -7));
        } else if (StringType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("TEXT", 2005));
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("BLOB", 2004));
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("TIMESTAMP", 93));
        } else if (DateType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("DATE", 91));
        } else if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            option = Option$.MODULE$.apply((Object)new JdbcType(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DECIMAL(", ",", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)decimalType.precision()), BoxesRunTime.boxToInteger((int)decimalType.scale())})), 3));
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    public JdbcType org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$getJdbcType(DataType dt, JdbcDialect dialect) {
        return (JdbcType)dialect.getJDBCType(dt).orElse((Function0)new Serializable(dt){
            public static final long serialVersionUID = 0L;
            private final DataType dt$1;

            public final Option<JdbcType> apply() {
                return JdbcUtils$.MODULE$.getCommonJDBCType(this.dt$1);
            }
            {
                this.dt$1 = dt$1;
            }
        }).getOrElse((Function0)new Serializable(dt){
            public static final long serialVersionUID = 0L;
            private final DataType dt$1;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't get JDBC type for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dt$1.simpleString()})));
            }
            {
                this.dt$1 = dt$1;
            }
        });
    }

    public DataType org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$getCatalystType(int sqlType, int precision, int scale, boolean signed) {
        StringType$ answer;
        int n = sqlType;
        switch (n) {
            default: {
                StringType$ stringType$ = null;
                break;
            }
            case 12: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case -3: {
                StringType$ stringType$ = BinaryType$.MODULE$;
                break;
            }
            case -6: {
                StringType$ stringType$ = IntegerType$.MODULE$;
                break;
            }
            case 93: {
                StringType$ stringType$ = TimestampType$.MODULE$;
                break;
            }
            case 92: {
                StringType$ stringType$ = TimestampType$.MODULE$;
                break;
            }
            case 2002: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case 2009: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case 5: {
                StringType$ stringType$ = IntegerType$.MODULE$;
                break;
            }
            case -8: {
                StringType$ stringType$ = LongType$.MODULE$;
                break;
            }
            case 2006: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case 7: {
                StringType$ stringType$ = DoubleType$.MODULE$;
                break;
            }
            case 1111: {
                StringType$ stringType$ = null;
                break;
            }
            case -9: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case 2: {
                StringType$ stringType$;
                if (precision != 0 || scale != 0) {
                    stringType$ = DecimalType$.MODULE$.bounded(precision, scale);
                    break;
                }
                stringType$ = DecimalType$.MODULE$.SYSTEM_DEFAULT();
                break;
            }
            case 0: {
                StringType$ stringType$ = null;
                break;
            }
            case 2011: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case -15: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case -1: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case -4: {
                StringType$ stringType$ = BinaryType$.MODULE$;
                break;
            }
            case -16: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case 2000: {
                StringType$ stringType$ = null;
                break;
            }
            case 4: {
                StringType$ stringType$;
                if (signed) {
                    stringType$ = IntegerType$.MODULE$;
                    break;
                }
                stringType$ = LongType$.MODULE$;
                break;
            }
            case 6: {
                StringType$ stringType$ = FloatType$.MODULE$;
                break;
            }
            case 8: {
                StringType$ stringType$ = DoubleType$.MODULE$;
                break;
            }
            case 2001: {
                StringType$ stringType$ = null;
                break;
            }
            case 3: {
                StringType$ stringType$;
                if (precision != 0 || scale != 0) {
                    stringType$ = DecimalType$.MODULE$.bounded(precision, scale);
                    break;
                }
                stringType$ = DecimalType$.MODULE$.SYSTEM_DEFAULT();
                break;
            }
            case 91: {
                StringType$ stringType$ = DateType$.MODULE$;
                break;
            }
            case 70: {
                StringType$ stringType$ = null;
                break;
            }
            case 2005: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case 1: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case 16: {
                StringType$ stringType$ = BooleanType$.MODULE$;
                break;
            }
            case 2004: {
                StringType$ stringType$ = BinaryType$.MODULE$;
                break;
            }
            case -7: {
                StringType$ stringType$ = BooleanType$.MODULE$;
                break;
            }
            case -2: {
                StringType$ stringType$ = BinaryType$.MODULE$;
                break;
            }
            case -5: {
                StringType$ stringType$;
                if (signed) {
                    stringType$ = LongType$.MODULE$;
                    break;
                }
                stringType$ = new DecimalType(20, 0);
                break;
            }
            case 2003: {
                StringType$ stringType$ = answer = null;
            }
        }
        if (answer == null) {
            throw new SQLException(new StringBuilder().append((Object)"Unsupported type ").append((Object)BoxesRunTime.boxToInteger((int)sqlType)).toString());
        }
        return answer;
    }

    public Option<StructType> getSchemaOption(Connection conn, JDBCOptions options) {
        None$ none$;
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(options.url());
        try {
            PreparedStatement statement = conn.prepareStatement(dialect.getSchemaQuery(options.table()));
            try {
                try {
                    none$ = new Some((Object)this.getSchema(statement.executeQuery(), dialect));
                }
                catch (SQLException sQLException) {
                    none$ = None$.MODULE$;
                }
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    /*
     * Exception decompiling
     */
    public StructType getSchema(ResultSet resultSet, JdbcDialect dialect) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [0 : 298->311)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Iterator<Row> resultSetToRows(ResultSet resultSet, StructType schema) {
        InputMetrics inputMetrics = (InputMetrics)Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final InputMetrics apply(TaskContext x$2) {
                return x$2.taskMetrics().inputMetrics();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final InputMetrics apply() {
                return new InputMetrics();
            }
        });
        ExpressionEncoder qual$1 = RowEncoder$.MODULE$.apply(schema);
        Seq x$7 = qual$1.resolveAndBind$default$1();
        Analyzer x$8 = qual$1.resolveAndBind$default$2();
        ExpressionEncoder encoder = qual$1.resolveAndBind(x$7, x$8);
        Iterator<InternalRow> internalRows = this.resultSetToSparkInternalRows(resultSet, schema, inputMetrics);
        return internalRows.map((Function1)new Serializable(encoder){
            public static final long serialVersionUID = 0L;
            private final ExpressionEncoder encoder$1;

            public final Row apply(InternalRow row) {
                return (Row)this.encoder$1.fromRow(row);
            }
            {
                this.encoder$1 = encoder$1;
            }
        });
    }

    public Iterator<InternalRow> resultSetToSparkInternalRows(ResultSet resultSet, StructType schema, InputMetrics inputMetrics) {
        return new NextIterator<InternalRow>(resultSet, schema, inputMetrics){
            private final ResultSet rs;
            private final Function3<ResultSet, InternalRow, Object, BoxedUnit>[] getters;
            private final SpecificInternalRow mutableRow;
            private final InputMetrics inputMetrics$1;

            public void close() {
                try {
                    this.rs.close();
                }
                catch (Exception exception) {
                    JdbcUtils$.MODULE$.logWarning((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Exception closing resultset";
                        }
                    }, exception);
                }
            }

            public InternalRow getNext() {
                SpecificInternalRow specificInternalRow;
                if (this.rs.next()) {
                    this.inputMetrics$1.incRecordsRead(1L);
                    for (int i = 0; i < this.getters.length; ++i) {
                        this.getters[i].apply((Object)this.rs, (Object)this.mutableRow, (Object)BoxesRunTime.boxToInteger((int)i));
                        if (!this.rs.wasNull()) continue;
                        this.mutableRow.setNullAt(i);
                    }
                    specificInternalRow = this.mutableRow;
                } else {
                    this.finished_$eq(true);
                    specificInternalRow = null;
                }
                return specificInternalRow;
            }
            {
                this.inputMetrics$1 = inputMetrics$1;
                this.rs = resultSet$1;
                this.getters = JdbcUtils$.MODULE$.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$makeGetters(schema$1);
                this.mutableRow = new SpecificInternalRow((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])schema$1.fields()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DataType apply(StructField x) {
                        return x.dataType();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class)))));
            }
        };
    }

    public Function3<ResultSet, InternalRow, Object, BoxedUnit>[] org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$makeGetters(StructType schema) {
        return (Function3[])Predef$.MODULE$.refArrayOps((Object[])schema.fields()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Function3<ResultSet, InternalRow, Object, BoxedUnit> apply(StructField sf) {
                return JdbcUtils$.MODULE$.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$makeGetter(sf.dataType(), sf.metadata());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function3.class)));
    }

    public Function3<ResultSet, InternalRow, Object, BoxedUnit> org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$makeGetter(DataType dt, Metadata metadata) {
        block26: {
            Object object;
            block14: {
                Object object2;
                DataType dataType;
                block25: {
                    block24: {
                        block23: {
                            block22: {
                                block21: {
                                    boolean bl;
                                    block20: {
                                        DataType dataType2;
                                        block19: {
                                            block18: {
                                                block17: {
                                                    block16: {
                                                        DecimalType decimalType;
                                                        Option option;
                                                        block15: {
                                                            block13: {
                                                                bl = false;
                                                                dataType2 = null;
                                                                dataType = dt;
                                                                if (!BooleanType$.MODULE$.equals(dataType)) break block13;
                                                                object = new Serializable(){
                                                                    public static final long serialVersionUID = 0L;

                                                                    public final void apply(ResultSet rs, InternalRow row, int pos) {
                                                                        row.setBoolean(pos, rs.getBoolean(pos + 1));
                                                                    }
                                                                };
                                                                break block14;
                                                            }
                                                            if (!DateType$.MODULE$.equals(dataType)) break block15;
                                                            object = new Serializable(){
                                                                public static final long serialVersionUID = 0L;

                                                                public final void apply(ResultSet rs, InternalRow row, int pos) {
                                                                    Date dateVal = rs.getDate(pos + 1);
                                                                    if (dateVal == null) {
                                                                        row.update(pos, null);
                                                                    } else {
                                                                        row.setInt(pos, DateTimeUtils$.MODULE$.fromJavaDate(dateVal));
                                                                    }
                                                                }
                                                            };
                                                            break block14;
                                                        }
                                                        if (!(dataType instanceof DecimalType) || (option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) break block16;
                                                        int p = ((Tuple2)option.get())._1$mcI$sp();
                                                        int s = ((Tuple2)option.get())._2$mcI$sp();
                                                        object = new Serializable(p, s){
                                                            public static final long serialVersionUID = 0L;
                                                            public final int p$1;
                                                            public final int s$1;

                                                            public final void apply(ResultSet rs, InternalRow row, int pos) {
                                                                Object decimal = JdbcUtils$.MODULE$.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$nullSafeConvert(rs.getBigDecimal(pos + 1), new Serializable(this){
                                                                    public static final long serialVersionUID = 0L;
                                                                    private final /* synthetic */ anonfun$org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$makeGetter$3 $outer;

                                                                    public final Decimal apply(BigDecimal d) {
                                                                        return Decimal$.MODULE$.apply(d, this.$outer.p$1, this.$outer.s$1);
                                                                    }
                                                                    {
                                                                        if ($outer == null) {
                                                                            throw null;
                                                                        }
                                                                        this.$outer = $outer;
                                                                    }
                                                                });
                                                                row.update(pos, decimal);
                                                            }
                                                            {
                                                                this.p$1 = p$1;
                                                                this.s$1 = s$1;
                                                            }
                                                        };
                                                        break block14;
                                                    }
                                                    if (!DoubleType$.MODULE$.equals(dataType)) break block17;
                                                    object = new Serializable(){
                                                        public static final long serialVersionUID = 0L;

                                                        public final void apply(ResultSet rs, InternalRow row, int pos) {
                                                            row.setDouble(pos, rs.getDouble(pos + 1));
                                                        }
                                                    };
                                                    break block14;
                                                }
                                                if (!FloatType$.MODULE$.equals(dataType)) break block18;
                                                object = new Serializable(){
                                                    public static final long serialVersionUID = 0L;

                                                    public final void apply(ResultSet rs, InternalRow row, int pos) {
                                                        row.setFloat(pos, rs.getFloat(pos + 1));
                                                    }
                                                };
                                                break block14;
                                            }
                                            if (!IntegerType$.MODULE$.equals(dataType)) break block19;
                                            object = new Serializable(){
                                                public static final long serialVersionUID = 0L;

                                                public final void apply(ResultSet rs, InternalRow row, int pos) {
                                                    row.setInt(pos, rs.getInt(pos + 1));
                                                }
                                            };
                                            break block14;
                                        }
                                        if (!LongType$.MODULE$.equals(dataType)) break block20;
                                        bl = true;
                                        dataType2 = dataType;
                                        if (!metadata.contains("binarylong")) break block20;
                                        object = new Serializable(){
                                            public static final long serialVersionUID = 0L;

                                            public final void apply(ResultSet rs, InternalRow row, int pos) {
                                                byte[] bytes = rs.getBytes(pos + 1);
                                                long ans = 0L;
                                                for (int j = 0; j < bytes.length; ++j) {
                                                    ans = 256L * ans + (long)(0xFF & bytes[j]);
                                                }
                                                row.setLong(pos, ans);
                                            }
                                        };
                                        break block14;
                                    }
                                    if (!bl) break block21;
                                    object = new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final void apply(ResultSet rs, InternalRow row, int pos) {
                                            row.setLong(pos, rs.getLong(pos + 1));
                                        }
                                    };
                                    break block14;
                                }
                                if (!ShortType$.MODULE$.equals(dataType)) break block22;
                                object = new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply(ResultSet rs, InternalRow row, int pos) {
                                        row.setShort(pos, rs.getShort(pos + 1));
                                    }
                                };
                                break block14;
                            }
                            if (!StringType$.MODULE$.equals(dataType)) break block23;
                            object = new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final void apply(ResultSet rs, InternalRow row, int pos) {
                                    row.update(pos, (Object)UTF8String.fromString((String)rs.getString(pos + 1)));
                                }
                            };
                            break block14;
                        }
                        if (!TimestampType$.MODULE$.equals(dataType)) break block24;
                        object = new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final void apply(ResultSet rs, InternalRow row, int pos) {
                                Timestamp t = rs.getTimestamp(pos + 1);
                                if (t == null) {
                                    row.update(pos, null);
                                } else {
                                    row.setLong(pos, DateTimeUtils$.MODULE$.fromJavaTimestamp(t));
                                }
                            }
                        };
                        break block14;
                    }
                    if (!BinaryType$.MODULE$.equals(dataType)) break block25;
                    object = new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ResultSet rs, InternalRow row, int pos) {
                            row.update(pos, (Object)rs.getBytes(pos + 1));
                        }
                    };
                    break block14;
                }
                if (!(dataType instanceof ArrayType)) break block26;
                ArrayType arrayType = (ArrayType)dataType;
                DataType et = arrayType.elementType();
                DataType dataType3 = et;
                if (TimestampType$.MODULE$.equals(dataType3)) {
                    object2 = new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Object[] apply(Object array2) {
                            return (Object[])Predef$.MODULE$.refArrayOps((Object[])((Timestamp[])array2)).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Object apply(Timestamp timestamp) {
                                    return JdbcUtils$.MODULE$.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$nullSafeConvert(timestamp, new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final long apply(Timestamp t) {
                                            return DateTimeUtils$.MODULE$.fromJavaTimestamp(t);
                                        }
                                    });
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
                        }
                    };
                } else if (StringType$.MODULE$.equals(dataType3)) {
                    object2 = new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final UTF8String[] apply(Object array2) {
                            return (UTF8String[])Predef$.MODULE$.refArrayOps((Object[])array2).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final UTF8String apply(Object obj) {
                                    return obj == null ? null : UTF8String.fromString((String)obj.toString());
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(UTF8String.class)));
                        }
                    };
                } else if (DateType$.MODULE$.equals(dataType3)) {
                    object2 = new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Object[] apply(Object array2) {
                            return (Object[])Predef$.MODULE$.refArrayOps((Object[])((Date[])array2)).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Object apply(Date date) {
                                    return JdbcUtils$.MODULE$.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$nullSafeConvert(date, new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final int apply(Date date) {
                                            return DateTimeUtils$.MODULE$.fromJavaDate(date);
                                        }
                                    });
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
                        }
                    };
                } else if (dataType3 instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)dataType3;
                    object2 = new Serializable(decimalType){
                        public static final long serialVersionUID = 0L;
                        public final DecimalType x8$1;

                        public final Object[] apply(Object array2) {
                            return (Object[])Predef$.MODULE$.refArrayOps((Object[])((BigDecimal[])array2)).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.16 $outer;

                                public final Object apply(BigDecimal decimal) {
                                    return JdbcUtils$.MODULE$.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$nullSafeConvert(decimal, new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ anonfun$16$$anonfun$apply$6 $outer;

                                        public final Decimal apply(BigDecimal d) {
                                            return Decimal$.MODULE$.apply(d, this.$outer.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$anonfun$$anonfun$$$outer().x8$1.precision(), this.$outer.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$anonfun$$anonfun$$$outer().x8$1.scale());
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                }

                                public /* synthetic */ anonfun.16 org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$anonfun$$anonfun$$$outer() {
                                    return this.$outer;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
                        }
                        {
                            this.x8$1 = x8$1;
                        }
                    };
                } else {
                    if (LongType$.MODULE$.equals(dataType3) && metadata.contains("binarylong")) {
                        throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported array element "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"type ", " based on binary"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dt.simpleString()}))).toString());
                    }
                    if (dataType3 instanceof ArrayType) {
                        throw new IllegalArgumentException("Nested arrays unsupported");
                    }
                    object2 = new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Object[] apply(Object array2) {
                            return (Object[])array2;
                        }
                    };
                }
                Serializable elementConversion = object2;
                object = new Serializable((Function1)elementConversion){
                    public static final long serialVersionUID = 0L;
                    public final Function1 elementConversion$1;

                    public final void apply(ResultSet rs, InternalRow row, int pos) {
                        Object array2 = JdbcUtils$.MODULE$.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$nullSafeConvert(rs.getArray(pos + 1), new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$makeGetter$13 $outer;

                            public final GenericArrayData apply(Array array2) {
                                return new GenericArrayData(this.$outer.elementConversion$1.apply(array2.getArray()));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        row.update(pos, array2);
                    }
                    {
                        this.elementConversion$1 = elementConversion$1;
                    }
                };
            }
            return object;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dt.simpleString()})));
    }

    public <T> Object org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$nullSafeConvert(T input, Function1<T, Object> f) {
        return input == null ? null : f.apply(input);
    }

    public Function3<PreparedStatement, Row, Object, BoxedUnit> org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$makeSetter(Connection conn, JdbcDialect dialect, DataType dataType) {
        Object object;
        DataType dataType2 = dataType;
        if (IntegerType$.MODULE$.equals(dataType2)) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(PreparedStatement stmt, Row row, int pos) {
                    stmt.setInt(pos + 1, row.getInt(pos));
                }
            };
        } else if (LongType$.MODULE$.equals(dataType2)) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(PreparedStatement stmt, Row row, int pos) {
                    stmt.setLong(pos + 1, row.getLong(pos));
                }
            };
        } else if (DoubleType$.MODULE$.equals(dataType2)) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(PreparedStatement stmt, Row row, int pos) {
                    stmt.setDouble(pos + 1, row.getDouble(pos));
                }
            };
        } else if (FloatType$.MODULE$.equals(dataType2)) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(PreparedStatement stmt, Row row, int pos) {
                    stmt.setFloat(pos + 1, row.getFloat(pos));
                }
            };
        } else if (ShortType$.MODULE$.equals(dataType2)) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(PreparedStatement stmt, Row row, int pos) {
                    stmt.setInt(pos + 1, row.getShort(pos));
                }
            };
        } else if (ByteType$.MODULE$.equals(dataType2)) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(PreparedStatement stmt, Row row, int pos) {
                    stmt.setInt(pos + 1, row.getByte(pos));
                }
            };
        } else if (BooleanType$.MODULE$.equals(dataType2)) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(PreparedStatement stmt, Row row, int pos) {
                    stmt.setBoolean(pos + 1, row.getBoolean(pos));
                }
            };
        } else if (StringType$.MODULE$.equals(dataType2)) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(PreparedStatement stmt, Row row, int pos) {
                    stmt.setString(pos + 1, row.getString(pos));
                }
            };
        } else if (BinaryType$.MODULE$.equals(dataType2)) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(PreparedStatement stmt, Row row, int pos) {
                    stmt.setBytes(pos + 1, (byte[])row.getAs(pos));
                }
            };
        } else if (TimestampType$.MODULE$.equals(dataType2)) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(PreparedStatement stmt, Row row, int pos) {
                    stmt.setTimestamp(pos + 1, (Timestamp)row.getAs(pos));
                }
            };
        } else if (DateType$.MODULE$.equals(dataType2)) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(PreparedStatement stmt, Row row, int pos) {
                    stmt.setDate(pos + 1, (Date)row.getAs(pos));
                }
            };
        } else if (dataType2 instanceof DecimalType) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(PreparedStatement stmt, Row row, int pos) {
                    stmt.setBigDecimal(pos + 1, row.getDecimal(pos));
                }
            };
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType et = arrayType.elementType();
            String typeName = this.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$getJdbcType(et, dialect).databaseTypeDefinition().toLowerCase(Locale.ROOT).split("\\(")[0];
            object = new Serializable(conn, typeName){
                public static final long serialVersionUID = 0L;
                private final Connection conn$2;
                private final String typeName$1;

                public final void apply(PreparedStatement stmt, Row row, int pos) {
                    Array array2 = this.conn$2.createArrayOf(this.typeName$1, (Object[])row.getSeq(pos).toArray(ClassTag$.MODULE$.AnyRef()));
                    stmt.setArray(pos + 1, array2);
                }
                {
                    this.conn$2 = conn$2;
                    this.typeName$1 = typeName$1;
                }
            };
        } else {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply(PreparedStatement x$3, Row x$4, int pos) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't translate non-null value for field ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)pos)})));
                }
            };
        }
        return object;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Iterator<Object> savePartition(Function0<Connection> getConnection, String table, Iterator<Row> iterator, StructType rddSchema, String insertStmt, int batchSize, JdbcDialect dialect, int isolationLevel) {
        block35: {
            block34: {
                conn = (Connection)getConnection.apply();
                committed = false;
                finalIsolationLevel = 0;
                if (isolationLevel != 0) {
                    try {
                        metadata = conn.getMetaData();
                        if (metadata.supportsTransactions()) {
                            finalIsolationLevel = defaultIsolation = metadata.getDefaultTransactionIsolation();
                            if (metadata.supportsTransactionIsolationLevel(isolationLevel)) {
                                finalIsolationLevel = isolationLevel;
                            } else {
                                this.logWarning((Function0<String>)new Serializable(isolationLevel, defaultIsolation){
                                    public static final long serialVersionUID = 0L;
                                    private final int isolationLevel$1;
                                    private final int defaultIsolation$1;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requested isolation level ", " is not supported; "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.isolationLevel$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"falling back to default isolation level ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.defaultIsolation$1)}))).toString();
                                    }
                                    {
                                        this.isolationLevel$1 = isolationLevel$1;
                                        this.defaultIsolation$1 = defaultIsolation$1;
                                    }
                                });
                            }
                        } else {
                            this.logWarning((Function0<String>)new Serializable(isolationLevel){
                                public static final long serialVersionUID = 0L;
                                private final int isolationLevel$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requested isolation level ", ", but transactions are unsupported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.isolationLevel$1)}));
                                }
                                {
                                    this.isolationLevel$1 = isolationLevel$1;
                                }
                            });
                        }
                    }
                    catch (Throwable var14_14) {
                        var15_15 = var14_14;
                        var16_16 = NonFatal$.MODULE$.unapply(var15_15);
                        if (var16_16.isEmpty()) {
                            throw var14_14;
                        }
                        e = (Throwable)var16_16.get();
                        this.logWarning((Function0<String>)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Exception while detecting transaction support";
                            }
                        }, e);
                        var18_18 = BoxedUnit.UNIT;
                    }
                }
                supportsTransactions = finalIsolationLevel != 0;
                if (supportsTransactions) {
                    conn.setAutoCommit(false);
                    conn.setTransactionIsolation(finalIsolationLevel);
                }
                stmt = conn.prepareStatement(insertStmt);
                setters = (Function3[])Predef$.MODULE$.refArrayOps((Object[])rddSchema.fields()).map((Function1)new Serializable(dialect, conn){
                    public static final long serialVersionUID = 0L;
                    private final JdbcDialect dialect$3;
                    private final Connection conn$3;

                    public final Function3<PreparedStatement, Row, Object, BoxedUnit> apply(StructField f) {
                        return JdbcUtils$.MODULE$.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$makeSetter(this.conn$3, this.dialect$3, f.dataType());
                    }
                    {
                        this.dialect$3 = dialect$3;
                        this.conn$3 = conn$3;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function3.class)));
                nullTypes = (int[])Predef$.MODULE$.refArrayOps((Object[])rddSchema.fields()).map((Function1)new Serializable(dialect){
                    public static final long serialVersionUID = 0L;
                    private final JdbcDialect dialect$3;

                    public final int apply(StructField f) {
                        return JdbcUtils$.MODULE$.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$getJdbcType(f.dataType(), this.dialect$3).jdbcNullType();
                    }
                    {
                        this.dialect$3 = dialect$3;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                numFields = rddSchema.fields().length;
                rowCount = 0;
                while (iterator.hasNext()) {
                    row = (Row)iterator.next();
                    for (i = 0; i < numFields; ++i) {
                        if (row.isNullAt(i)) {
                            stmt.setNull(i + 1, nullTypes[i]);
                            v0 = BoxedUnit.UNIT;
                            continue;
                        }
                        v0 = setters[i].apply((Object)stmt, (Object)row, (Object)BoxesRunTime.boxToInteger((int)i));
                    }
                    stmt.addBatch();
                    if (++rowCount % batchSize != 0) continue;
                    stmt.executeBatch();
                    rowCount = 0;
                }
                v1 = rowCount > 0 ? (Object)stmt.executeBatch() : BoxedUnit.UNIT;
                stmt.close();
                if (supportsTransactions) {
                    conn.commit();
                }
                committed = true;
                var27_27 = scala.package$.MODULE$.Iterator().empty();
                if (!committed) break block34;
                try {
                    conn.close();
                }
                catch (Exception var33_34) {
                    this.logWarning((Function0<String>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Transaction succeeded, but closing failed";
                        }
                    }, var33_34);
                }
            }
            if (supportsTransactions) {
                conn.rollback();
            }
            conn.close();
            break block35;
            {
                catch (Throwable var28_28) {
                    try {
                        try {
                            var20_20.close();
                            throw var28_28;
                        }
                        catch (SQLException var29_29) {
                            cause = var29_29.getNextException();
                            if (cause == null) ** GOTO lbl-1000
                            v2 = var29_29.getCause();
                            var31_31 = cause;
                            if (!(v2 != null ? v2.equals(var31_31) == false : var31_31 != null)) lbl-1000:
                            // 2 sources

                            {
                                v3 /* !! */  = BoxedUnit.UNIT;
                            } else if (var29_29.getCause() == null) {
                                try {
                                    v3 /* !! */  = var29_29.initCause(cause);
                                }
                                catch (IllegalStateException v4) {
                                    var29_29.addSuppressed(cause);
                                    v3 /* !! */  = BoxedUnit.UNIT;
                                }
                            } else {
                                var29_29.addSuppressed(cause);
                                v3 /* !! */  = BoxedUnit.UNIT;
                            }
                            throw var29_29;
                        }
                    }
                    catch (Throwable var32_32) {
                        if (committed) {
                            try {
                                conn.close();
                            }
                            catch (Exception var33_33) {
                                this.logWarning((Function0<String>)new /* invalid duplicate definition of identical inner class */, var33_33);
                            }
                        } else {
                            if (supportsTransactions) {
                                conn.rollback();
                            }
                            conn.close();
                        }
                        throw var32_32;
                    }
                }
            }
        }
        return var27_27;
    }

    public String schemaString(Dataset<Row> df, String url, Option<String> createTableColumnTypes) {
        StringBuilder sb = new StringBuilder();
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(url);
        Map userSpecifiedColTypesMap = (Map)createTableColumnTypes.map((Function1)new Serializable(df){
            public static final long serialVersionUID = 0L;
            private final Dataset df$1;

            public final Map<String, String> apply(String x$5) {
                return JdbcUtils$.MODULE$.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$parseUserSpecifiedCreateTableColumnTypes(this.df$1, x$5);
            }
            {
                this.df$1 = df$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Map<String, String> apply() {
                return Predef$.MODULE$.Map().empty();
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])df.schema().fields()).foreach((Function1)new Serializable(sb, dialect, userSpecifiedColTypesMap){
            public static final long serialVersionUID = 0L;
            private final StringBuilder sb$1;
            public final JdbcDialect dialect$4;
            private final Map userSpecifiedColTypesMap$1;

            public final StringBuilder apply(StructField field) {
                String name = this.dialect$4.quoteIdentifier(field.name());
                String typ = (String)this.userSpecifiedColTypesMap$1.getOrElse((Object)field.name(), (Function0)new Serializable(this, field){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.schemaString.1 $outer;
                    private final StructField field$1;

                    public final String apply() {
                        return JdbcUtils$.MODULE$.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$getJdbcType(this.field$1.dataType(), this.$outer.dialect$4).databaseTypeDefinition();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.field$1 = field$1;
                    }
                });
                String nullable = field.nullable() ? "" : "NOT NULL";
                return this.sb$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", ", " ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, typ, nullable})));
            }
            {
                this.sb$1 = sb$1;
                this.dialect$4 = dialect$4;
                this.userSpecifiedColTypesMap$1 = userSpecifiedColTypesMap$1;
            }
        });
        return sb.length() < 2 ? "" : sb.substring(2);
    }

    public Option<String> schemaString$default$3() {
        return None$.MODULE$;
    }

    public Map<String, String> org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$parseUserSpecifiedCreateTableColumnTypes(Dataset<Row> df, String createTableColumnTypes) {
        StructType userSchema = CatalystSqlParser$.MODULE$.parseTableSchema(createTableColumnTypes);
        Function2 nameEquality = df.sparkSession().sessionState().conf().resolver();
        Predef$.MODULE$.refArrayOps((Object[])userSchema.fieldNames()).foreach((Function1)new Serializable(userSchema, nameEquality){
            public static final long serialVersionUID = 0L;
            private final StructType userSchema$1;
            public final Function2 nameEquality$1;

            public final void apply(String col) {
                String[] duplicatesCols = (String[])Predef$.MODULE$.refArrayOps((Object[])this.userSchema$1.fieldNames()).filter((Function1)new Serializable(this, col){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$parseUserSpecifiedCreateTableColumnTypes$1 $outer;
                    private final String col$2;

                    public final boolean apply(String x$6) {
                        return BoxesRunTime.unboxToBoolean((Object)this.$outer.nameEquality$1.apply((Object)x$6, (Object)this.col$2));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.col$2 = col$2;
                    }
                });
                if (Predef$.MODULE$.refArrayOps((Object[])duplicatesCols).size() >= 2) {
                    throw new AnalysisException(new StringBuilder().append((Object)"Found duplicate column(s) in createTableColumnTypes option value: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])duplicatesCols).mkString(", ")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
            }
            {
                this.userSchema$1 = userSchema$1;
                this.nameEquality$1 = nameEquality$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])userSchema.fieldNames()).foreach((Function1)new Serializable(df, nameEquality){
            public static final long serialVersionUID = 0L;
            public final Dataset df$2;
            public final Function2 nameEquality$1;

            public final StructField apply(String col) {
                return (StructField)this.df$2.schema().find((Function1)new Serializable(this, col){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$parseUserSpecifiedCreateTableColumnTypes$2 $outer;
                    private final String col$3;

                    public final boolean apply(StructField f) {
                        return BoxesRunTime.unboxToBoolean((Object)this.$outer.nameEquality$1.apply((Object)f.name(), (Object)this.col$3));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.col$3 = col$3;
                    }
                }).getOrElse((Function0)new Serializable(this, col){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$parseUserSpecifiedCreateTableColumnTypes$2 $outer;
                    private final String col$3;

                    public final Nothing$ apply() {
                        throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"createTableColumnTypes option column ", " not found in schema "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.col$3}))).append((Object)this.$outer.df$2.schema().catalogString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.col$3 = col$3;
                    }
                });
            }
            {
                this.df$2 = df$2;
                this.nameEquality$1 = nameEquality$1;
            }
        });
        Map userSchemaMap = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])userSchema.fields()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(StructField f) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name()), (Object)JdbcUtils$.MODULE$.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$typeName$2(f));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        boolean isCaseSensitive = df.sparkSession().sessionState().conf().caseSensitiveAnalysis();
        return isCaseSensitive ? userSchemaMap : CaseInsensitiveMap$.MODULE$.apply(userSchemaMap);
    }

    public void saveTable(Dataset<Row> df, Option<StructType> tableSchema, boolean isCaseSensitive, JDBCOptions options) {
        int n;
        String url = options.url();
        String table = options.table();
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(url);
        StructType rddSchema = df.schema();
        Function0<Connection> getConnection = this.createConnectionFactory(options);
        int batchSize = options.batchSize();
        int isolationLevel = options.isolationLevel();
        String insertStmt = this.getInsertStatement(table, rddSchema, tableSchema, isCaseSensitive, dialect);
        boolean bl = false;
        Some some = null;
        Option<Object> option = options.numPartitions();
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            int n2 = BoxesRunTime.unboxToInt((Object)some.x());
            if (n2 <= 0) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid value `", "` for parameter `", "` in table writing "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n2), JDBCOptions$.MODULE$.JDBC_NUM_PARTITIONS()}))).append((Object)"via JDBC. The minimum value is 1.").toString());
            }
        }
        Dataset<Row> dataset = bl && (n = BoxesRunTime.unboxToInt((Object)some.x())) < df.rdd().getNumPartitions() ? df.coalesce(n) : df;
        Dataset<Row> repartitionedDF = dataset;
        repartitionedDF.foreachPartition((Function1<Iterator<Row>, BoxedUnit>)new Serializable(table, dialect, rddSchema, getConnection, batchSize, isolationLevel, insertStmt){
            public static final long serialVersionUID = 0L;
            private final String table$1;
            private final JdbcDialect dialect$5;
            private final StructType rddSchema$1;
            private final Function0 getConnection$1;
            private final int batchSize$1;
            private final int isolationLevel$2;
            private final String insertStmt$1;

            public final void apply(Iterator<Row> iterator2) {
                JdbcUtils$.MODULE$.savePartition((Function0<Connection>)this.getConnection$1, this.table$1, iterator2, this.rddSchema$1, this.insertStmt$1, this.batchSize$1, this.dialect$5, this.isolationLevel$2);
            }
            {
                this.table$1 = table$1;
                this.dialect$5 = dialect$5;
                this.rddSchema$1 = rddSchema$1;
                this.getConnection$1 = getConnection$1;
                this.batchSize$1 = batchSize$1;
                this.isolationLevel$2 = isolationLevel$2;
                this.insertStmt$1 = insertStmt$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void createTable(Connection conn, Dataset<Row> df, JDBCOptions options) {
        String strSchema = this.schemaString(df, options.url(), options.createTableColumnTypes());
        String table = options.table();
        String createTableOptions = options.createTableOptions();
        String sql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE ", " (", ") ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table, strSchema, createTableOptions}));
        Statement statement = conn.createStatement();
        try {
            statement.executeUpdate(sql);
        }
        catch (Throwable throwable) {
            void var8_8;
            var8_8.close();
            throw throwable;
        }
        statement.close();
    }

    public final String org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$typeName$2(StructField f) {
        return f.metadata().contains(org.apache.spark.sql.types.package$.MODULE$.HIVE_TYPE_STRING()) ? f.metadata().getString(org.apache.spark.sql.types.package$.MODULE$.HIVE_TYPE_STRING()) : f.dataType().catalogString();
    }

    private JdbcUtils$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

