/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.NoSuchPartitionException;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LeafNode;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.command.TruncateTableCommand$;
import org.apache.spark.sql.execution.datasources.PartitioningUtils$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001B\u0001\u0003\u0001>\u0011A\u0003\u0016:v]\u000e\fG/\u001a+bE2,7i\\7nC:$'BA\u0002\u0005\u0003\u001d\u0019w.\\7b]\u0012T!!\u0002\u0004\u0002\u0013\u0015DXmY;uS>t'BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011#\u0002\u0001\u00115y!\u0003CA\t\u0019\u001b\u0005\u0011\"BA\n\u0015\u0003\u001dawnZ5dC2T!!\u0006\f\u0002\u000bAd\u0017M\\:\u000b\u0005]1\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005e\u0011\"\u0001\u0003'fC\u001atu\u000eZ3\u0011\u0005maR\"\u0001\u0002\n\u0005u\u0011!a\u0004*v]:\f'\r\\3D_6l\u0017M\u001c3\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\u000fA\u0013x\u000eZ;diB\u0011q$J\u0005\u0003M\u0001\u0012AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\u0002\u000b\u0001\u0003\u0016\u0004%\t!K\u0001\ni\u0006\u0014G.\u001a(b[\u0016,\u0012A\u000b\t\u0003W1j\u0011AF\u0005\u0003[Y\u0011q\u0002V1cY\u0016LE-\u001a8uS\u001aLWM\u001d\u0005\t_\u0001\u0011\t\u0012)A\u0005U\u0005QA/\u00192mK:\u000bW.\u001a\u0011\t\u0011E\u0002!Q3A\u0005\u0002I\nQ\u0002]1si&$\u0018n\u001c8Ta\u0016\u001cW#A\u001a\u0011\u0007}!d'\u0003\u00026A\t1q\n\u001d;j_:\u0004\"aN&\u000f\u0005aBeBA\u001dG\u001d\tQTI\u0004\u0002<\t:\u0011Ah\u0011\b\u0003{\ts!AP!\u000e\u0003}R!\u0001\u0011\b\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011qCB\u0005\u0003\u000fZ\tqaY1uC2|w-\u0003\u0002J\u0015\u0006a1)\u0019;bY><G+\u001f9fg*\u0011qIF\u0005\u0003\u00196\u0013!\u0003V1cY\u0016\u0004\u0016M\u001d;ji&|gn\u00159fG*\u0011\u0011J\u0013\u0005\t\u001f\u0002\u0011\t\u0012)A\u0005g\u0005q\u0001/\u0019:uSRLwN\\*qK\u000e\u0004\u0003\"B)\u0001\t\u0003\u0011\u0016A\u0002\u001fj]&$h\bF\u0002T)V\u0003\"a\u0007\u0001\t\u000b!\u0002\u0006\u0019\u0001\u0016\t\u000bE\u0002\u0006\u0019A\u001a\t\u000b]\u0003A\u0011\t-\u0002\u0007I,h\u000e\u0006\u0002ZMB\u0019!l\u00182\u000f\u0005mkfB\u0001 ]\u0013\u0005\t\u0013B\u00010!\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001Y1\u0003\u0007M+\u0017O\u0003\u0002_AA\u00111\rZ\u0007\u0002\r%\u0011QM\u0002\u0002\u0004%><\b\"B\u0005W\u0001\u00049\u0007CA2i\u0013\tIgA\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u0004l\u0001\u0005\u0005I\u0011\u00017\u0002\t\r|\u0007/\u001f\u000b\u0004'6t\u0007b\u0002\u0015k!\u0003\u0005\rA\u000b\u0005\bc)\u0004\n\u00111\u00014\u0011\u001d\u0001\b!%A\u0005\u0002E\fabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001sU\tQ3oK\u0001u!\t)(0D\u0001w\u0015\t9\b0A\u0005v]\u000eDWmY6fI*\u0011\u0011\u0010I\u0001\u000bC:tw\u000e^1uS>t\u0017BA>w\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\b{\u0002\t\n\u0011\"\u0001\u007f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\u0012a \u0016\u0003gMD\u0011\"a\u0001\u0001\u0003\u0003%\t%!\u0002\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t9\u0001\u0005\u0003\u0002\n\u0005MQBAA\u0006\u0015\u0011\ti!a\u0004\u0002\t1\fgn\u001a\u0006\u0003\u0003#\tAA[1wC&!\u0011QCA\u0006\u0005\u0019\u0019FO]5oO\"I\u0011\u0011\u0004\u0001\u0002\u0002\u0013\u0005\u00111D\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003;\u00012aHA\u0010\u0013\r\t\t\u0003\t\u0002\u0004\u0013:$\b\"CA\u0013\u0001\u0005\u0005I\u0011AA\u0014\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u000b\u00020A\u0019q$a\u000b\n\u0007\u00055\u0002EA\u0002B]fD!\"!\r\u0002$\u0005\u0005\t\u0019AA\u000f\u0003\rAH%\r\u0005\n\u0003k\u0001\u0011\u0011!C!\u0003o\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003s\u0001b!a\u000f\u0002B\u0005%RBAA\u001f\u0015\r\ty\u0004I\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\"\u0003{\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003\u000f\u0002\u0011\u0011!C\u0001\u0003\u0013\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0017\n\t\u0006E\u0002 \u0003\u001bJ1!a\u0014!\u0005\u001d\u0011un\u001c7fC:D!\"!\r\u0002F\u0005\u0005\t\u0019AA\u0015\u0011%\t)\u0006AA\u0001\n\u0003\n9&\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u0017\nI\u0006\u0003\u0006\u00022\u0005M\u0013\u0011!a\u0001\u0003S9\u0011\"!\u0018\u0003\u0003\u0003E\t!a\u0018\u0002)Q\u0013XO\\2bi\u0016$\u0016M\u00197f\u0007>lW.\u00198e!\rY\u0012\u0011\r\u0004\t\u0003\t\t\t\u0011#\u0001\u0002dM)\u0011\u0011MA3IA9\u0011qMA7UM\u001aVBAA5\u0015\r\tY\u0007I\u0001\beVtG/[7f\u0013\u0011\ty'!\u001b\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007C\u0004R\u0003C\"\t!a\u001d\u0015\u0005\u0005}\u0003BCA<\u0003C\n\t\u0011\"\u0012\u0002z\u0005AAo\\*ue&tw\r\u0006\u0002\u0002\b!Q\u0011QPA1\u0003\u0003%\t)a \u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000bM\u000b\t)a!\t\r!\nY\b1\u0001+\u0011\u0019\t\u00141\u0010a\u0001g!Q\u0011qQA1\u0003\u0003%\t)!#\u0002\u000fUt\u0017\r\u001d9msR!\u00111RAJ!\u0011yB'!$\u0011\u000b}\tyIK\u001a\n\u0007\u0005E\u0005E\u0001\u0004UkBdWM\r\u0005\n\u0003+\u000b))!AA\u0002M\u000b1\u0001\u001f\u00131\u0011)\tI*!\u0019\u0002\u0002\u0013%\u00111T\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\u001eB!\u0011\u0011BAP\u0013\u0011\t\t+a\u0003\u0003\r=\u0013'.Z2u\u0001")
public class TruncateTableCommand
extends LeafNode
implements RunnableCommand,
Serializable {
    private final TableIdentifier tableName;
    private final Option<Map<String, String>> partitionSpec;

    public static Option<Tuple2<TableIdentifier, Option<Map<String, String>>>> unapply(TruncateTableCommand truncateTableCommand) {
        return TruncateTableCommand$.MODULE$.unapply(truncateTableCommand);
    }

    public static Function1<Tuple2<TableIdentifier, Option<Map<String, String>>>, TruncateTableCommand> tupled() {
        return TruncateTableCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Option<Map<String, String>>, TruncateTableCommand>> curried() {
        return TruncateTableCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.class.output((Command)this);
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public Option<Map<String, String>> partitionSpec() {
        return this.partitionSpec;
    }

    @Override
    public Seq<Row> run(SparkSession spark) {
        Seq seq;
        Seq partCols;
        SessionCatalog catalog2 = spark.sessionState().catalog();
        CatalogTable table = catalog2.getTableMetadata(this.tableName());
        String tableIdentWithDB = table.identifier().quotedString();
        CatalogTableType catalogTableType = table.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.EXTERNAL();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation not allowed: TRUNCATE TABLE on external tables: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableIdentWithDB})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        CatalogTableType catalogTableType3 = table.tableType();
        CatalogTableType catalogTableType4 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType3 != null ? !catalogTableType3.equals(catalogTableType4) : catalogTableType4 != null)) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation not allowed: TRUNCATE TABLE on views: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableIdentWithDB})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (table.partitionColumnNames().isEmpty() && this.partitionSpec().isDefined()) {
            throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation not allowed: TRUNCATE TABLE ... PARTITION is not supported "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for tables that are not partitioned: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableIdentWithDB}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (this.partitionSpec().isDefined()) {
            DDLUtils$.MODULE$.verifyPartitionProviderIsHive(spark, table, "TRUNCATE TABLE ... PARTITION");
        }
        if ((partCols = table.partitionColumnNames()).isEmpty()) {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{table.storage().locationUri()}));
        } else {
            Option normalizedSpec = this.partitionSpec().map((Function1)new Serializable(this, spark, table, partCols){
                public static final long serialVersionUID = 0L;
                private final SparkSession spark$1;
                private final CatalogTable table$1;
                private final Seq partCols$1;

                public final Map<String, String> apply(Map<String, String> spec) {
                    return PartitioningUtils$.MODULE$.normalizePartitionSpec(spec, (Seq<String>)this.partCols$1, this.table$1.identifier().quotedString(), (Function2<String, String, Object>)this.spark$1.sessionState().conf().resolver());
                }
                {
                    this.spark$1 = spark$1;
                    this.table$1 = table$1;
                    this.partCols$1 = partCols$1;
                }
            });
            Seq partLocations = (Seq)catalog2.listPartitions(table.identifier(), normalizedSpec).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Option<URI> apply(CatalogTablePartition x$2) {
                    return x$2.storage().locationUri();
                }
            }, Seq$.MODULE$.canBuildFrom());
            this.partitionSpec().withFilter((Function1)new Serializable(this, partCols, partLocations){
                public static final long serialVersionUID = 0L;
                private final Seq partCols$1;
                private final Seq partLocations$1;

                public final boolean apply(Map<String, String> spec) {
                    return this.partLocations$1.isEmpty() && spec.size() == this.partCols$1.length();
                }
                {
                    this.partCols$1 = partCols$1;
                    this.partLocations$1 = partLocations$1;
                }
            }).foreach((Function1)new Serializable(this, table){
                public static final long serialVersionUID = 0L;
                private final CatalogTable table$1;

                public final Nothing$ apply(Map<String, String> spec) {
                    throw new NoSuchPartitionException(this.table$1.database(), this.table$1.identifier().table(), spec);
                }
                {
                    this.table$1 = table$1;
                }
            });
            seq = partLocations;
        }
        Seq locations = seq;
        Configuration hadoopConf = spark.sessionState().newHadoopConf();
        locations.foreach((Function1)new Serializable(this, tableIdentWithDB, hadoopConf){
            public static final long serialVersionUID = 0L;
            private final String tableIdentWithDB$1;
            private final Configuration hadoopConf$1;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object apply(Option<URI> location) {
                Object object;
                if (!location.isDefined()) {
                    object = BoxedUnit.UNIT;
                    return object;
                }
                Path path = new Path((URI)location.get());
                try {
                    FileSystem fs = path.getFileSystem(this.hadoopConf$1);
                    fs.delete(path, true);
                    object = BoxesRunTime.boxToBoolean((boolean)fs.mkdirs(path));
                    return object;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to truncate table ", " when removing data of the path: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableIdentWithDB$1, path}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"because of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.toString()}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
            }
            {
                this.tableIdentWithDB$1 = tableIdentWithDB$1;
                this.hadoopConf$1 = hadoopConf$1;
            }
        });
        spark.sessionState().refreshTable(this.tableName().unquotedString());
        try {
            spark.sharedState().cacheManager().uncacheQuery(spark.table(table.identifier()), spark.sharedState().cacheManager().uncacheQuery$default$2());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception when attempting to uncache table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableIdentWithDB})), e);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    public TruncateTableCommand copy(TableIdentifier tableName, Option<Map<String, String>> partitionSpec2) {
        return new TruncateTableCommand(tableName, partitionSpec2);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public Option<Map<String, String>> copy$default$2() {
        return this.partitionSpec();
    }

    public String productPrefix() {
        return "TruncateTableCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        TableIdentifier tableIdentifier;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                tableIdentifier = this.partitionSpec();
                break;
            }
            case 0: {
                tableIdentifier = this.tableName();
            }
        }
        return tableIdentifier;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TruncateTableCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TruncateTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        TruncateTableCommand truncateTableCommand = (TruncateTableCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = truncateTableCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Option<Map<String, String>> option = this.partitionSpec();
        Option<Map<String, String>> option2 = truncateTableCommand.partitionSpec();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!truncateTableCommand.canEqual(this)) return false;
        return true;
    }

    public TruncateTableCommand(TableIdentifier tableName, Option<Map<String, String>> partitionSpec2) {
        this.tableName = tableName;
        this.partitionSpec = partitionSpec2;
        Command.class.$init$((Command)this);
    }
}

