/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.api.r;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaRDD$;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.r.SerDe$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ClassTag$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class SQLUtils$ {
    public static final SQLUtils$ MODULE$;

    static {
        new SQLUtils$();
    }

    public SQLContext createSQLContext(JavaSparkContext jsc) {
        return new SQLContext(jsc);
    }

    public JavaSparkContext getJavaSparkContext(SQLContext sqlCtx) {
        return new JavaSparkContext(sqlCtx.sparkContext());
    }

    public <T> Seq<T> toSeq(Object arr) {
        return Predef$.MODULE$.genericArrayOps(arr).toSeq();
    }

    public StructType createStructType(Seq<StructField> fields) {
        return StructType$.MODULE$.apply(fields);
    }

    public DataType getSQLDataType(String dataType) {
        block14: {
            ByteType$ byteType$;
            block3: {
                String string;
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block6: {
                                                block5: {
                                                    block4: {
                                                        block2: {
                                                            string = dataType;
                                                            if (!"byte".equals(string)) break block2;
                                                            byteType$ = ByteType$.MODULE$;
                                                            break block3;
                                                        }
                                                        if (!"integer".equals(string)) break block4;
                                                        byteType$ = IntegerType$.MODULE$;
                                                        break block3;
                                                    }
                                                    if (!"double".equals(string)) break block5;
                                                    byteType$ = DoubleType$.MODULE$;
                                                    break block3;
                                                }
                                                if (!"numeric".equals(string)) break block6;
                                                byteType$ = DoubleType$.MODULE$;
                                                break block3;
                                            }
                                            if (!"character".equals(string)) break block7;
                                            byteType$ = StringType$.MODULE$;
                                            break block3;
                                        }
                                        if (!"string".equals(string)) break block8;
                                        byteType$ = StringType$.MODULE$;
                                        break block3;
                                    }
                                    if (!"binary".equals(string)) break block9;
                                    byteType$ = BinaryType$.MODULE$;
                                    break block3;
                                }
                                if (!"raw".equals(string)) break block10;
                                byteType$ = BinaryType$.MODULE$;
                                break block3;
                            }
                            if (!"logical".equals(string)) break block11;
                            byteType$ = BooleanType$.MODULE$;
                            break block3;
                        }
                        if (!"boolean".equals(string)) break block12;
                        byteType$ = BooleanType$.MODULE$;
                        break block3;
                    }
                    if (!"timestamp".equals(string)) break block13;
                    byteType$ = TimestampType$.MODULE$;
                    break block3;
                }
                if (!"date".equals(string)) break block14;
                byteType$ = DateType$.MODULE$;
            }
            return byteType$;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invaid type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType})));
    }

    public StructField createStructField(String name, String dataType, boolean nullable) {
        DataType dtObj = this.getSQLDataType(dataType);
        return new StructField(name, dtObj, nullable, StructField$.MODULE$.apply$default$4());
    }

    public DataFrame createDF(RDD<byte[]> rdd, StructType schema2, SQLContext sqlContext) {
        int num = Predef$.MODULE$.refArrayOps((Object[])schema2.fields()).size();
        RDD rowRDD = rdd.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Row apply(byte[] bytes) {
                return SQLUtils$.MODULE$.org$apache$spark$sql$api$r$SQLUtils$$bytesToRow(bytes);
            }
        }, ClassTag$.MODULE$.apply(Row.class));
        return sqlContext.createDataFrame((RDD<Row>)rowRDD, schema2);
    }

    public JavaRDD<byte[]> dfToRowRDD(DataFrame df) {
        return JavaRDD$.MODULE$.fromRDD(df.map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(Row r) {
                return SQLUtils$.MODULE$.org$apache$spark$sql$api$r$SQLUtils$$rowToRBytes(r);
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public Row org$apache$spark$sql$api$r$SQLUtils$$bytesToRow(byte[] bytes) {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        DataInputStream dis = new DataInputStream(bis);
        int num = SerDe$.MODULE$.readInt(dis);
        return Row$.MODULE$.fromSeq((Seq)((scala.collection.immutable.Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), num).map((Function1)new Serializable(dis){
            public static final long serialVersionUID = 0L;
            private final DataInputStream dis$1;

            public final Object apply(int i) {
                return SerDe$.MODULE$.readObject(this.dis$1);
            }
            {
                this.dis$1 = dis$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toSeq());
    }

    public byte[] org$apache$spark$sql$api$r$SQLUtils$$rowToRBytes(Row row) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        SerDe$.MODULE$.writeInt(dos, row.length());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), row.length()).map((Function1)new Serializable(row, dos){
            public static final long serialVersionUID = 0L;
            private final Row row$1;
            private final DataOutputStream dos$1;

            public final void apply(int idx) {
                this.apply$mcVI$sp(idx);
            }

            public void apply$mcVI$sp(int idx) {
                Object obj = this.row$1.apply(idx);
                SerDe$.MODULE$.writeObject(this.dos$1, obj);
            }
            {
                this.row$1 = row$1;
                this.dos$1 = dos$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return bos.toByteArray();
    }

    public byte[][] dfToCols(DataFrame df) {
        Row[] localDF = df.collect();
        int numCols = df.columns().length;
        Object[][] dfCols = this.convertRowsToColumns(localDF, numCols);
        return (byte[][])Predef$.MODULE$.refArrayOps((Object[])dfCols).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(Object[] col2) {
                return SQLUtils$.MODULE$.colToRBytes(col2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))));
    }

    public Object[][] convertRowsToColumns(Row[] localDF, int numCols) {
        return (Object[][])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numCols).map((Function1)new Serializable(localDF){
            public static final long serialVersionUID = 0L;
            private final Row[] localDF$1;

            public final Object[] apply(int colIdx) {
                return (Object[])Predef$.MODULE$.refArrayOps((Object[])this.localDF$1).map((Function1)new Serializable(this, colIdx){
                    public static final long serialVersionUID = 0L;
                    private final int colIdx$1;

                    public final Object apply(Row row) {
                        return row.apply(this.colIdx$1);
                    }
                    {
                        this.colIdx$1 = colIdx$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
            }
            {
                this.localDF$1 = localDF$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Object.class)));
    }

    public byte[] colToRBytes(Object[] col2) {
        int numRows = col2.length;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        SerDe$.MODULE$.writeInt(dos, numRows);
        Predef$.MODULE$.genericArrayOps((Object)col2).map((Function1)new Serializable(dos){
            public static final long serialVersionUID = 0L;
            private final DataOutputStream dos$2;

            public final void apply(Object item) {
                Object obj = item;
                SerDe$.MODULE$.writeObject(this.dos$2, obj);
            }
            {
                this.dos$2 = dos$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Unit()));
        return bos.toByteArray();
    }

    public SaveMode saveMode(String mode) {
        String string;
        block6: {
            SaveMode saveMode;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            string = mode;
                            if (!"append".equals(string)) break block2;
                            saveMode = SaveMode.Append;
                            break block3;
                        }
                        if (!"overwrite".equals(string)) break block4;
                        saveMode = SaveMode.Overwrite;
                        break block3;
                    }
                    if (!"error".equals(string)) break block5;
                    saveMode = SaveMode.ErrorIfExists;
                    break block3;
                }
                if (!"ignore".equals(string)) break block6;
                saveMode = SaveMode.Ignore;
            }
            return saveMode;
        }
        throw new MatchError((Object)string);
    }

    private SQLUtils$() {
        MODULE$ = this;
    }
}

