/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.metric;

import java.text.NumberFormat;
import java.util.Locale;
import org.apache.spark.SparkContext;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetric$;
import org.apache.spark.sql.execution.ui.SparkListenerDriverAccumUpdates;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public final class SQLMetrics$ {
    public static final SQLMetrics$ MODULE$;
    private final String SUM_METRIC;
    private final String SIZE_METRIC;
    private final String TIMING_METRIC;

    static {
        new SQLMetrics$();
    }

    private String SUM_METRIC() {
        return this.SUM_METRIC;
    }

    private String SIZE_METRIC() {
        return this.SIZE_METRIC;
    }

    private String TIMING_METRIC() {
        return this.TIMING_METRIC;
    }

    /*
     * WARNING - void declaration
     */
    public SQLMetric createMetric(SparkContext sc, String name) {
        void var3_3;
        SQLMetric acc = new SQLMetric(this.SUM_METRIC(), SQLMetric$.MODULE$.$lessinit$greater$default$2());
        acc.register(sc, (Option)new Some((Object)name), false);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public SQLMetric createSizeMetric(SparkContext sc, String name) {
        void var3_3;
        SQLMetric acc = new SQLMetric(this.SIZE_METRIC(), -1L);
        acc.register(sc, (Option)new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " total (min, med, max)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name}))), false);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public SQLMetric createTimingMetric(SparkContext sc, String name) {
        void var3_3;
        SQLMetric acc = new SQLMetric(this.TIMING_METRIC(), -1L);
        acc.register(sc, (Option)new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " total (min, med, max)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name}))), false);
        return var3_3;
    }

    public String stringValue(String metricsType, Seq<Object> values) {
        block9: {
            Seq seq;
            block10: {
                String string;
                block6: {
                    Tuple4 tuple4;
                    Seq seq2;
                    Object object;
                    block8: {
                        block7: {
                            block5: {
                                String string2 = metricsType;
                                String string3 = this.SUM_METRIC();
                                if (string2 != null ? !string2.equals(string3) : string3 != null) break block5;
                                NumberFormat numberFormat = NumberFormat.getIntegerInstance(Locale.US);
                                string = numberFormat.format(BoxesRunTime.unboxToLong((Object)values.sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
                                break block6;
                            }
                            String string4 = metricsType;
                            String string5 = this.SIZE_METRIC();
                            if (string4 != null ? !string4.equals(string5) : string5 != null) break block7;
                            object = new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final String apply(long size) {
                                    return Utils$.MODULE$.bytesToString(size);
                                }
                            };
                            break block8;
                        }
                        String string6 = metricsType;
                        String string7 = this.TIMING_METRIC();
                        if (string6 != null ? !string6.equals(string7) : string7 != null) break block9;
                        object = new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply(long ms) {
                                return Utils$.MODULE$.msDurationToString(ms);
                            }
                        };
                    }
                    Serializable strFormat = object;
                    Seq validValues = (Seq)values.filter((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(long x$1) {
                            return this.apply$mcZJ$sp(x$1);
                        }

                        public boolean apply$mcZJ$sp(long x$1) {
                            return x$1 >= 0L;
                        }
                    });
                    if (validValues.isEmpty()) {
                        seq2 = (Seq)Seq$.MODULE$.fill(4, (Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final long apply() {
                                return this.apply$mcJ$sp();
                            }

                            public long apply$mcJ$sp() {
                                return 0L;
                            }
                        });
                    } else {
                        Seq sorted = (Seq)validValues.sorted((Ordering)Ordering.Long$.MODULE$);
                        seq2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{BoxesRunTime.unboxToLong((Object)sorted.sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), BoxesRunTime.unboxToLong((Object)sorted.apply(0)), BoxesRunTime.unboxToLong((Object)sorted.apply(validValues.length() / 2)), BoxesRunTime.unboxToLong((Object)sorted.apply(validValues.length() - 1))}));
                    }
                    Seq metric = seq2;
                    seq = (Seq)metric.map((Function1)strFormat, Seq$.MODULE$.canBuildFrom());
                    Some some = Seq$.MODULE$.unapplySeq(seq);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(4) != 0) break block10;
                    String sum = (String)((SeqLike)some.get()).apply(0);
                    String min = (String)((SeqLike)some.get()).apply(1);
                    String med = (String)((SeqLike)some.get()).apply(2);
                    String max = (String)((SeqLike)some.get()).apply(3);
                    Tuple4 tuple42 = tuple4 = new Tuple4((Object)sum, (Object)min, (Object)med, (Object)max);
                    String sum2 = (String)tuple42._1();
                    String min2 = (String)tuple42._2();
                    String med2 = (String)tuple42._3();
                    String max2 = (String)tuple42._4();
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n", " (", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sum2, min2, med2, max2}));
                }
                return string;
            }
            throw new MatchError((Object)seq);
        }
        throw new IllegalStateException(new StringBuilder().append((Object)"unexpected metrics type: ").append((Object)metricsType).toString());
    }

    public void postDriverMetricUpdates(SparkContext sc, String executionId, Seq<SQLMetric> metrics) {
        if (executionId != null) {
            sc.listenerBus().post((SparkListenerEvent)new SparkListenerDriverAccumUpdates(new StringOps(Predef$.MODULE$.augmentString(executionId)).toLong(), (Seq<Tuple2<Object, Object>>)((Seq)metrics.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Object> apply(SQLMetric m) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToLong((long)m.id())), (Object)BoxesRunTime.boxToLong((long)m.value()));
                }
            }, Seq$.MODULE$.canBuildFrom()))));
        }
    }

    private SQLMetrics$() {
        MODULE$ = this;
        this.SUM_METRIC = "sum";
        this.SIZE_METRIC = "size";
        this.TIMING_METRIC = "timing";
    }
}

