/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class CSVUtils$ {
    public static final CSVUtils$ MODULE$;

    static {
        new CSVUtils$();
    }

    public Dataset<String> filterCommentAndEmpty(Dataset<String> lines, CSVOptions options) {
        Dataset<String> nonEmptyLines = lines.filter(functions$.MODULE$.length(functions$.MODULE$.trim(lines.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq<Object>)Nil$.MODULE$))).$greater(BoxesRunTime.boxToInteger((int)0)));
        return options.isCommentSet() ? nonEmptyLines.filter(lines.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq<Object>)Nil$.MODULE$).startsWith(((Object)BoxesRunTime.boxToCharacter((char)options.comment())).toString()).unary_$bang()) : nonEmptyLines;
    }

    public Iterator<String> filterCommentAndEmpty(Iterator<String> iter, CSVOptions options) {
        return iter.filter((Function1)new Serializable(options){
            public static final long serialVersionUID = 0L;
            private final CSVOptions options$1;

            public final boolean apply(String line) {
                return new StringOps(Predef$.MODULE$.augmentString(line.trim())).nonEmpty() && !line.startsWith(((Object)BoxesRunTime.boxToCharacter((char)this.options$1.comment())).toString());
            }
            {
                this.options$1 = options$1;
            }
        });
    }

    public Iterator<String> filterHeaderLine(Iterator<String> iter, String firstLine, CSVOptions options) {
        return options.headerFlag() ? iter.filterNot((Function1)new Serializable(firstLine){
            public static final long serialVersionUID = 0L;
            private final String firstLine$1;

            public final boolean apply(String x$1) {
                String string = x$1;
                String string2 = this.firstLine$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.firstLine$1 = firstLine$1;
            }
        }) : iter;
    }

    public Iterator<String> dropHeaderLine(Iterator<String> iter, CSVOptions options) {
        Iterator iterator2;
        if (options.isCommentSet()) {
            String commentPrefix = ((Object)BoxesRunTime.boxToCharacter((char)options.comment())).toString();
            iterator2 = iter.dropWhile((Function1)new Serializable(commentPrefix){
                public static final long serialVersionUID = 0L;
                private final String commentPrefix$1;

                public final boolean apply(String line) {
                    return line.trim().isEmpty() || line.trim().startsWith(this.commentPrefix$1);
                }
                {
                    this.commentPrefix$1 = commentPrefix$1;
                }
            });
        } else {
            iterator2 = iter.dropWhile((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$2) {
                    return x$2.trim().isEmpty();
                }
            });
        }
        Iterator nonEmptyLines = iterator2;
        Object object = nonEmptyLines.hasNext() ? nonEmptyLines.drop(1) : BoxedUnit.UNIT;
        return iter;
    }

    public char toChar(String str2) throws IllegalArgumentException {
        block15: {
            char c;
            block14: {
                block13: {
                    if (str2.charAt(0) != '\\') break block13;
                    char c2 = str2.charAt(1);
                    switch (c2) {
                        case 'u': {
                            String string = str2;
                            String string2 = "\u0000";
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                c = '\u0000';
                                break;
                            }
                        }
                        default: {
                            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported special character for delimiter: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str2})));
                        }
                        case '\'': {
                            c = '\'';
                            break;
                        }
                        case '\"': {
                            c = '\"';
                            break;
                        }
                        case 'f': {
                            c = '\f';
                            break;
                        }
                        case 'b': {
                            c = '\b';
                            break;
                        }
                        case 'r': {
                            c = '\r';
                            break;
                        }
                        case 't': {
                            c = '\t';
                            break;
                        }
                    }
                    break block14;
                }
                if (str2.length() != 1) break block15;
                c = str2.charAt(0);
            }
            return c;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Delimiter cannot be more than one character: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str2})));
    }

    public void verifySchema(StructType schema) {
        schema.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(StructField field) {
                CSVUtils$.MODULE$.org$apache$spark$sql$execution$datasources$csv$CSVUtils$$verifyType$1(field.dataType());
            }
        });
    }

    public final void org$apache$spark$sql$execution$datasources$csv$CSVUtils$$verifyType$1(DataType dataType) {
        while (true) {
            boolean bl;
            DataType dataType2 = dataType;
            ByteType$ byteType$ = ByteType$.MODULE$;
            DataType dataType3 = dataType2;
            if (!(byteType$ != null ? !byteType$.equals(dataType3) : dataType3 != null)) {
                bl = true;
            } else {
                ShortType$ shortType$ = ShortType$.MODULE$;
                DataType dataType4 = dataType2;
                if (!(shortType$ != null ? !shortType$.equals(dataType4) : dataType4 != null)) {
                    bl = true;
                } else {
                    IntegerType$ integerType$ = IntegerType$.MODULE$;
                    DataType dataType5 = dataType2;
                    if (!(integerType$ != null ? !integerType$.equals(dataType5) : dataType5 != null)) {
                        bl = true;
                    } else {
                        LongType$ longType$ = LongType$.MODULE$;
                        DataType dataType6 = dataType2;
                        if (!(longType$ != null ? !longType$.equals(dataType6) : dataType6 != null)) {
                            bl = true;
                        } else {
                            FloatType$ floatType$ = FloatType$.MODULE$;
                            DataType dataType7 = dataType2;
                            if (!(floatType$ != null ? !floatType$.equals(dataType7) : dataType7 != null)) {
                                bl = true;
                            } else {
                                DoubleType$ doubleType$ = DoubleType$.MODULE$;
                                DataType dataType8 = dataType2;
                                if (!(doubleType$ != null ? !doubleType$.equals(dataType8) : dataType8 != null)) {
                                    bl = true;
                                } else {
                                    BooleanType$ booleanType$ = BooleanType$.MODULE$;
                                    DataType dataType9 = dataType2;
                                    if (!(booleanType$ != null ? !booleanType$.equals(dataType9) : dataType9 != null)) {
                                        bl = true;
                                    } else if (dataType2 instanceof DecimalType) {
                                        bl = true;
                                    } else {
                                        TimestampType$ timestampType$ = TimestampType$.MODULE$;
                                        DataType dataType10 = dataType2;
                                        if (!(timestampType$ != null ? !timestampType$.equals(dataType10) : dataType10 != null)) {
                                            bl = true;
                                        } else {
                                            DateType$ dateType$ = DateType$.MODULE$;
                                            DataType dataType11 = dataType2;
                                            if (!(dateType$ != null ? !dateType$.equals(dataType11) : dataType11 != null)) {
                                                bl = true;
                                            } else {
                                                StringType$ stringType$ = StringType$.MODULE$;
                                                DataType dataType12 = dataType2;
                                                bl = !(stringType$ != null ? !stringType$.equals(dataType12) : dataType12 != null);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (bl) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
            if (!(dataType2 instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            dataType = userDefinedType.sqlType();
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CSV data source does not support ", " data type."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType.simpleString()})));
    }

    private CSVUtils$() {
        MODULE$ = this;
    }
}

