/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.Count$;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat$;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LeafNode;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.AnalyzeColumnCommand$;
import org.apache.spark.sql.execution.command.AnalyzeTableCommand$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.internal.SessionState;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001B\u0001\u0003\u0001>\u0011A#\u00118bYfTXmQ8mk6t7i\\7nC:$'BA\u0002\u0005\u0003\u001d\u0019w.\\7b]\u0012T!!\u0002\u0004\u0002\u0013\u0015DXmY;uS>t'BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011#\u0002\u0001\u00115y!\u0003CA\t\u0019\u001b\u0005\u0011\"BA\n\u0015\u0003\u001dawnZ5dC2T!!\u0006\f\u0002\u000bAd\u0017M\\:\u000b\u0005]1\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005e\u0011\"\u0001\u0003'fC\u001atu\u000eZ3\u0011\u0005maR\"\u0001\u0002\n\u0005u\u0011!a\u0004*v]:\f'\r\\3D_6l\u0017M\u001c3\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\u000fA\u0013x\u000eZ;diB\u0011q$J\u0005\u0003M\u0001\u0012AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\u0002\u000b\u0001\u0003\u0016\u0004%\t!K\u0001\u000bi\u0006\u0014G.Z%eK:$X#\u0001\u0016\u0011\u0005-bS\"\u0001\f\n\u000552\"a\u0004+bE2,\u0017\nZ3oi&4\u0017.\u001a:\t\u0011=\u0002!\u0011#Q\u0001\n)\n1\u0002^1cY\u0016LE-\u001a8uA!A\u0011\u0007\u0001BK\u0002\u0013\u0005!'A\u0006d_2,XN\u001c(b[\u0016\u001cX#A\u001a\u0011\u0007QbtH\u0004\u00026u9\u0011a'O\u0007\u0002o)\u0011\u0001HD\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005J!a\u000f\u0011\u0002\u000fA\f7m[1hK&\u0011QH\u0010\u0002\u0004'\u0016\f(BA\u001e!!\t\u00015I\u0004\u0002 \u0003&\u0011!\tI\u0001\u0007!J,G-\u001a4\n\u0005\u0011+%AB*ue&twM\u0003\u0002CA!Aq\t\u0001B\tB\u0003%1'\u0001\u0007d_2,XN\u001c(b[\u0016\u001c\b\u0005C\u0003J\u0001\u0011\u0005!*\u0001\u0004=S:LGO\u0010\u000b\u0004\u00172k\u0005CA\u000e\u0001\u0011\u0015A\u0003\n1\u0001+\u0011\u0015\t\u0004\n1\u00014\u0011\u0015y\u0005\u0001\"\u0011Q\u0003\r\u0011XO\u001c\u000b\u0003#Z\u00032\u0001\u000e\u001fS!\t\u0019F+D\u0001\u0007\u0013\t)fAA\u0002S_^DQa\u0016(A\u0002a\u000bAb\u001d9be.\u001cVm]:j_:\u0004\"aU-\n\u0005i3!\u0001D*qCJ\\7+Z:tS>t\u0007\"\u0002/\u0001\t\u0013i\u0016AE2p[B,H/Z\"pYVlgn\u0015;biN$BA\u00186lYB!qdX1e\u0013\t\u0001\u0007E\u0001\u0004UkBdWM\r\t\u0003?\tL!a\u0019\u0011\u0003\t1{gn\u001a\t\u0005\u0001\u0016|t-\u0003\u0002g\u000b\n\u0019Q*\u00199\u0011\u0005EA\u0017BA5\u0013\u0005)\u0019u\u000e\\;n]N#\u0018\r\u001e\u0005\u0006/n\u0003\r\u0001\u0017\u0005\u0006Qm\u0003\rA\u000b\u0005\u0006cm\u0003\ra\r\u0005\b]\u0002\t\t\u0011\"\u0001p\u0003\u0011\u0019w\u000e]=\u0015\u0007-\u0003\u0018\u000fC\u0004)[B\u0005\t\u0019\u0001\u0016\t\u000fEj\u0007\u0013!a\u0001g!91\u000fAI\u0001\n\u0003!\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0002k*\u0012!F^\u0016\u0002oB\u0011\u00010`\u0007\u0002s*\u0011!p_\u0001\nk:\u001c\u0007.Z2lK\u0012T!\u0001 \u0011\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002\u007fs\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005\u0005\u0001!%A\u0005\u0002\u0005\r\u0011AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003\u000bQ#a\r<\t\u0013\u0005%\u0001!!A\u0005B\u0005-\u0011!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u000eA!\u0011qBA\r\u001b\t\t\tB\u0003\u0003\u0002\u0014\u0005U\u0011\u0001\u00027b]\u001eT!!a\u0006\u0002\t)\fg/Y\u0005\u0004\t\u0006E\u0001\"CA\u000f\u0001\u0005\u0005I\u0011AA\u0010\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\t\u0003E\u0002 \u0003GI1!!\n!\u0005\rIe\u000e\u001e\u0005\n\u0003S\u0001\u0011\u0011!C\u0001\u0003W\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002.\u0005M\u0002cA\u0010\u00020%\u0019\u0011\u0011\u0007\u0011\u0003\u0007\u0005s\u0017\u0010\u0003\u0006\u00026\u0005\u001d\u0012\u0011!a\u0001\u0003C\t1\u0001\u001f\u00132\u0011%\tI\u0004AA\u0001\n\u0003\nY$A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\u0004\u0005\u0004\u0002@\u0005\u0015\u0013QF\u0007\u0003\u0003\u0003R1!a\u0011!\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u000f\n\tE\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\tY\u0005AA\u0001\n\u0003\ti%\u0001\u0005dC:,\u0015/^1m)\u0011\ty%!\u0016\u0011\u0007}\t\t&C\u0002\u0002T\u0001\u0012qAQ8pY\u0016\fg\u000e\u0003\u0006\u00026\u0005%\u0013\u0011!a\u0001\u0003[A\u0011\"!\u0017\u0001\u0003\u0003%\t%a\u0017\u0002\r\u0015\fX/\u00197t)\u0011\ty%!\u0018\t\u0015\u0005U\u0012qKA\u0001\u0002\u0004\ticB\u0005\u0002b\t\t\t\u0011#\u0001\u0002d\u0005!\u0012I\\1msj,7i\u001c7v[:\u001cu.\\7b]\u0012\u00042aGA3\r!\t!!!A\t\u0002\u0005\u001d4#BA3\u0003S\"\u0003cBA6\u0003cR3gS\u0007\u0003\u0003[R1!a\u001c!\u0003\u001d\u0011XO\u001c;j[\u0016LA!a\u001d\u0002n\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\t\u000f%\u000b)\u0007\"\u0001\u0002xQ\u0011\u00111\r\u0005\u000b\u0003w\n)'!A\u0005F\u0005u\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u00055\u0001BCAA\u0003K\n\t\u0011\"!\u0002\u0004\u0006)\u0011\r\u001d9msR)1*!\"\u0002\b\"1\u0001&a A\u0002)Ba!MA@\u0001\u0004\u0019\u0004BCAF\u0003K\n\t\u0011\"!\u0002\u000e\u00069QO\\1qa2LH\u0003BAH\u0003/\u0003RaHAI\u0003+K1!a%!\u0005\u0019y\u0005\u000f^5p]B!qd\u0018\u00164\u0011%\tI*!#\u0002\u0002\u0003\u00071*A\u0002yIAB!\"!(\u0002f\u0005\u0005I\u0011BAP\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005\u0005\u0006\u0003BA\b\u0003GKA!!*\u0002\u0012\t1qJ\u00196fGR\u0004")
public class AnalyzeColumnCommand
extends LeafNode
implements RunnableCommand,
Serializable {
    private final TableIdentifier tableIdent;
    private final Seq<String> columnNames;

    public static Function1<Tuple2<TableIdentifier, Seq<String>>, AnalyzeColumnCommand> tupled() {
        return AnalyzeColumnCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Seq<String>, AnalyzeColumnCommand>> curried() {
        return AnalyzeColumnCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.class.output((Command)this);
    }

    public TableIdentifier tableIdent() {
        return this.tableIdent;
    }

    public Seq<String> columnNames() {
        return this.columnNames;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionState sessionState2 = sparkSession.sessionState();
        String db = (String)this.tableIdent().database().getOrElse((Function0)new Serializable(this, sessionState2){
            public static final long serialVersionUID = 0L;
            private final SessionState sessionState$1;

            public final String apply() {
                return this.sessionState$1.catalog().getCurrentDatabase();
            }
            {
                this.sessionState$1 = sessionState$1;
            }
        });
        TableIdentifier tableIdentWithDB = new TableIdentifier(this.tableIdent().table(), (Option)new Some((Object)db));
        CatalogTable tableMeta = sessionState2.catalog().getTableMetadata(tableIdentWithDB);
        CatalogTableType catalogTableType = tableMeta.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            throw new AnalysisException("ANALYZE TABLE is not supported on views.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        long sizeInBytes2 = AnalyzeTableCommand$.MODULE$.calculateTotalSize(sessionState2, tableMeta);
        Tuple2<Object, Map<String, ColumnStat>> tuple2 = this.computeColumnStats(sparkSession, tableIdentWithDB, this.columnNames());
        if (tuple2 != null) {
            Tuple2 tuple22;
            long rowCount = tuple2._1$mcJ$sp();
            Map newColStats = (Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)rowCount), (Object)newColStats);
            long rowCount2 = tuple23._1$mcJ$sp();
            Map newColStats2 = (Map)tuple23._2();
            CatalogStatistics statistics = new CatalogStatistics(BigInt$.MODULE$.long2bigInt(sizeInBytes2), (Option)new Some((Object)BigInt$.MODULE$.long2bigInt(rowCount2)), ((MapLike)tableMeta.stats().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Map<String, ColumnStat> apply(CatalogStatistics x$2) {
                    return x$2.colStats();
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Map<String, Nothing$> apply() {
                    return Predef$.MODULE$.Map().empty();
                }
            })).$plus$plus((GenTraversableOnce)newColStats2));
            Some x$5 = new Some((Object)statistics);
            TableIdentifier x$6 = tableMeta.copy$default$1();
            CatalogTableType x$7 = tableMeta.copy$default$2();
            CatalogStorageFormat x$8 = tableMeta.copy$default$3();
            StructType x$9 = tableMeta.copy$default$4();
            Option x$10 = tableMeta.copy$default$5();
            Seq x$11 = tableMeta.copy$default$6();
            Option x$12 = tableMeta.copy$default$7();
            String x$13 = tableMeta.copy$default$8();
            long x$14 = tableMeta.copy$default$9();
            long x$15 = tableMeta.copy$default$10();
            Map x$16 = tableMeta.copy$default$11();
            Option x$17 = tableMeta.copy$default$13();
            Option x$18 = tableMeta.copy$default$14();
            Seq x$19 = tableMeta.copy$default$15();
            boolean x$20 = tableMeta.copy$default$16();
            boolean x$21 = tableMeta.copy$default$17();
            sessionState2.catalog().alterTable(tableMeta.copy(x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, (Option)x$5, x$17, x$18, x$19, x$20, x$21));
            sessionState2.catalog().refreshTable(tableIdentWithDB);
            return (Seq)Seq$.MODULE$.empty();
        }
        throw new MatchError(tuple2);
    }

    private Tuple2<Object, Map<String, ColumnStat>> computeColumnStats(SparkSession sparkSession, TableIdentifier tableIdent, Seq<String> columnNames) {
        LogicalPlan relation = sparkSession.table(tableIdent).logicalPlan();
        Function2 resolver = sparkSession.sessionState().conf().resolver();
        Seq attributesToAnalyze = (Seq)columnNames.map((Function1)new Serializable(this, relation, resolver){
            public static final long serialVersionUID = 0L;
            private final LogicalPlan relation$1;
            public final Function2 resolver$1;

            public final Attribute apply(String col) {
                Option exprOption = this.relation$1.output().find((Function1)new Serializable(this, col){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;
                    private final String col$1;

                    public final boolean apply(Attribute attr) {
                        return BoxesRunTime.unboxToBoolean((Object)this.$outer.resolver$1.apply((Object)attr.name(), (Object)this.col$1));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.col$1 = col$1;
                    }
                });
                return (Attribute)exprOption.getOrElse((Function0)new Serializable(this, col){
                    public static final long serialVersionUID = 0L;
                    private final String col$1;

                    public final Nothing$ apply() {
                        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Column ", " does not exist."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.col$1})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                    {
                        this.col$1 = col$1;
                    }
                });
            }
            {
                this.relation$1 = relation$1;
                this.resolver$1 = resolver$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        attributesToAnalyze.foreach((Function1)new Serializable(this, tableIdent){
            public static final long serialVersionUID = 0L;
            private final TableIdentifier tableIdent$1;

            public final void apply(Attribute attr) {
                if (ColumnStat$.MODULE$.supportsType(attr.dataType())) {
                    return;
                }
                throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Column ", " in table ", " is of type ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attr.name(), this.tableIdent$1, attr.dataType()}))).append((Object)"and Spark does not support statistics collection on this column type.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            {
                this.tableIdent$1 = tableIdent$1;
            }
        });
        double ndvMaxErr = sparkSession.sessionState().conf().ndvMaxError();
        AggregateExpression aggregateExpression = Count$.MODULE$.apply((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).toAggregateExpression();
        Seq expressions = (Seq)((SeqLike)attributesToAnalyze.map((Function1)new Serializable(this, ndvMaxErr){
            public static final long serialVersionUID = 0L;
            private final double ndvMaxErr$1;

            public final CreateNamedStruct apply(Attribute x$3) {
                return ColumnStat$.MODULE$.statExprs(x$3, this.ndvMaxErr$1);
            }
            {
                this.ndvMaxErr$1 = ndvMaxErr$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)aggregateExpression, Seq$.MODULE$.canBuildFrom());
        Seq namedExpressions = (Seq)expressions.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Alias apply(Expression e) {
                Expression x$22 = e;
                String x$23 = e.toString();
                ExprId x$24 = Alias$.MODULE$.apply$default$3(x$22, x$23);
                Option x$25 = Alias$.MODULE$.apply$default$4(x$22, x$23);
                Option x$26 = Alias$.MODULE$.apply$default$5(x$22, x$23);
                Boolean x$27 = Alias$.MODULE$.apply$default$6(x$22, x$23);
                return new Alias(x$22, x$23, x$24, x$25, x$26, x$27);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Row statsRow = Dataset$.MODULE$.ofRows(sparkSession, (LogicalPlan)new Aggregate((Seq)Nil$.MODULE$, namedExpressions, relation)).head();
        long rowCount = statsRow.getLong(0);
        Map columnStats = ((TraversableOnce)((TraversableLike)attributesToAnalyze.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, statsRow){
            public static final long serialVersionUID = 0L;
            private final Row statsRow$1;

            public final Tuple2<String, ColumnStat> apply(Tuple2<Attribute, Object> x0$1) {
                Tuple2<Attribute, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Attribute attr = (Attribute)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    Tuple2 tuple22 = new Tuple2((Object)attr.name(), (Object)ColumnStat$.MODULE$.rowToColumnStat(this.statsRow$1.getStruct(i + 1), attr));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.statsRow$1 = statsRow$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)rowCount), (Object)columnStats);
    }

    public AnalyzeColumnCommand copy(TableIdentifier tableIdent, Seq<String> columnNames) {
        return new AnalyzeColumnCommand(tableIdent, columnNames);
    }

    public TableIdentifier copy$default$1() {
        return this.tableIdent();
    }

    public Seq<String> copy$default$2() {
        return this.columnNames();
    }

    public String productPrefix() {
        return "AnalyzeColumnCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        TableIdentifier tableIdentifier;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                tableIdentifier = this.columnNames();
                break;
            }
            case 0: {
                tableIdentifier = this.tableIdent();
            }
        }
        return tableIdentifier;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AnalyzeColumnCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AnalyzeColumnCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AnalyzeColumnCommand analyzeColumnCommand = (AnalyzeColumnCommand)x$1;
        TableIdentifier tableIdentifier = this.tableIdent();
        TableIdentifier tableIdentifier2 = analyzeColumnCommand.tableIdent();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Seq<String> seq = this.columnNames();
        Seq<String> seq2 = analyzeColumnCommand.columnNames();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!analyzeColumnCommand.canEqual(this)) return false;
        return true;
    }

    public AnalyzeColumnCommand(TableIdentifier tableIdent, Seq<String> columnNames) {
        this.tableIdent = tableIdent;
        this.columnNames = columnNames;
        Command.class.$init$((Command)this);
    }
}

