/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LeafNode;
import org.apache.spark.sql.execution.command.AlterTableRecoverPartitionsCommand$;
import org.apache.spark.sql.execution.command.AlterTableRecoverPartitionsCommand$$anonfun$addPartitions$1$;
import org.apache.spark.sql.execution.command.AlterTableRecoverPartitionsCommand$$anonfun$org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.PartitionStatistics;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.ThreadUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.GenMap$;
import scala.collection.GenSeq;
import scala.collection.GenSeq$;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.collection.parallel.ForkJoinTaskSupport;
import scala.collection.parallel.TaskSupport;
import scala.collection.parallel.mutable.ParArray;
import scala.concurrent.forkjoin.ForkJoinPool;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t=e\u0001B\u0001\u0003\u0001>\u0011!%\u00117uKJ$\u0016M\u00197f%\u0016\u001cwN^3s!\u0006\u0014H/\u001b;j_:\u001c8i\\7nC:$'BA\u0002\u0005\u0003\u001d\u0019w.\\7b]\u0012T!!\u0002\u0004\u0002\u0013\u0015DXmY;uS>t'BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011#\u0002\u0001\u00115y!\u0003CA\t\u0019\u001b\u0005\u0011\"BA\n\u0015\u0003\u001dawnZ5dC2T!!\u0006\f\u0002\u000bAd\u0017M\\:\u000b\u0005]1\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005e\u0011\"\u0001\u0003'fC\u001atu\u000eZ3\u0011\u0005maR\"\u0001\u0002\n\u0005u\u0011!a\u0004*v]:\f'\r\\3D_6l\u0017M\u001c3\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\u000fA\u0013x\u000eZ;diB\u0011q$J\u0005\u0003M\u0001\u0012AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\u0002\u000b\u0001\u0003\u0016\u0004%\t!K\u0001\ni\u0006\u0014G.\u001a(b[\u0016,\u0012A\u000b\t\u0003W1j\u0011AF\u0005\u0003[Y\u0011q\u0002V1cY\u0016LE-\u001a8uS\u001aLWM\u001d\u0005\t_\u0001\u0011\t\u0012)A\u0005U\u0005QA/\u00192mK:\u000bW.\u001a\u0011\t\u0011E\u0002!Q3A\u0005\u0002I\n1aY7e+\u0005\u0019\u0004C\u0001\u001b8\u001d\tyR'\u0003\u00027A\u00051\u0001K]3eK\u001aL!\u0001O\u001d\u0003\rM#(/\u001b8h\u0015\t1\u0004\u0005\u0003\u0005<\u0001\tE\t\u0015!\u00034\u0003\u0011\u0019W\u000e\u001a\u0011\t\u000bu\u0002A\u0011\u0001 \u0002\rqJg.\u001b;?)\ry\u0004)\u0011\t\u00037\u0001AQ\u0001\u000b\u001fA\u0002)Bq!\r\u001f\u0011\u0002\u0003\u00071\u0007C\u0004D\u0001\t\u0007I\u0011\u0001#\u0002\u00139+Vj\u0018$J\u0019\u0016\u001bV#A#\u0011\u0005\u0019[U\"A$\u000b\u0005!K\u0015\u0001\u00027b]\u001eT\u0011AS\u0001\u0005U\u00064\u0018-\u0003\u00029\u000f\"1Q\n\u0001Q\u0001\n\u0015\u000b!BT+N?\u001aKE*R*!\u0011\u001dy\u0005A1A\u0005\u0002\u0011\u000b!\u0002V(U\u00032{6+\u0013.F\u0011\u0019\t\u0006\u0001)A\u0005\u000b\u0006YAk\u0014+B\u0019~\u001b\u0016JW#!\u0011\u001d\u0019\u0006A1A\u0005\u0002\u0011\u000b\u0001\u0002\u0012#M?RKU*\u0012\u0005\u0007+\u0002\u0001\u000b\u0011B#\u0002\u0013\u0011#Ej\u0018+J\u001b\u0016\u0003\u0003\"B,\u0001\t\u0013A\u0016!D4fiB\u000bG\u000f\u001b$jYR,'\u000f\u0006\u0002ZCB\u0011!lX\u0007\u00027*\u0011A,X\u0001\u0003MNT!A\u0018\u0006\u0002\r!\fGm\\8q\u0013\t\u00017L\u0001\u0006QCRDg)\u001b7uKJDQA\u0019,A\u0002\r\f!\u0002[1e_>\u00048i\u001c8g!\t!w-D\u0001f\u0015\t1W,\u0001\u0003d_:4\u0017B\u00015f\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\")!\u000e\u0001C!W\u0006\u0019!/\u001e8\u0015\u00051d\bcA7vq:\u0011an\u001d\b\u0003_Jl\u0011\u0001\u001d\u0006\u0003c:\ta\u0001\u0010:p_Rt\u0014\"A\u0011\n\u0005Q\u0004\u0013a\u00029bG.\fw-Z\u0005\u0003m^\u00141aU3r\u0015\t!\b\u0005\u0005\u0002zu6\ta!\u0003\u0002|\r\t\u0019!k\\<\t\u000b%I\u0007\u0019A?\u0011\u0005et\u0018BA@\u0007\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011\u001d\t\u0019\u0001\u0001C\u0005\u0003\u000b\tab]2b]B\u000b'\u000f^5uS>t7\u000f\u0006\u000b\u0002\b\u0005%\u00131JA*\u0003/\nY&a\u0018\u0002f\u0005=\u0014q\u0011\t\u0007\u0003\u0013\ty!a\u0005\u000e\u0005\u0005-!bAA\u0007A\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005E\u00111\u0002\u0002\u0007\u000f\u0016t7+Z9\u0011\u000f}\t)\"!\u0007\u0002D%\u0019\u0011q\u0003\u0011\u0003\rQ+\b\u000f\\33!\u0011\tY\"!\u0010\u000f\t\u0005u\u0011q\u0007\b\u0005\u0003?\t\u0019D\u0004\u0003\u0002\"\u0005Eb\u0002BA\u0012\u0003_qA!!\n\u0002.9!\u0011qEA\u0016\u001d\ry\u0017\u0011F\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005]1\u0011bAA\u001b-\u000591-\u0019;bY><\u0017\u0002BA\u001d\u0003w\tAbQ1uC2|w\rV=qKNT1!!\u000e\u0017\u0013\u0011\ty$!\u0011\u0003%Q\u000b'\r\\3QCJ$\u0018\u000e^5p]N\u0003Xm\u0019\u0006\u0005\u0003s\tY\u0004E\u0002[\u0003\u000bJ1!a\u0012\\\u0005\u0011\u0001\u0016\r\u001e5\t\r%\t\t\u00011\u0001~\u0011\u001da\u0016\u0011\u0001a\u0001\u0003\u001b\u00022AWA(\u0013\r\t\tf\u0017\u0002\u000b\r&dWmU=ti\u0016l\u0007bBA+\u0003\u0003\u0001\r!W\u0001\u0007M&dG/\u001a:\t\u0011\u0005e\u0013\u0011\u0001a\u0001\u0003\u0007\nA\u0001]1uQ\"A\u0011QLA\u0001\u0001\u0004\tI\"\u0001\u0003ta\u0016\u001c\u0007\u0002CA1\u0003\u0003\u0001\r!a\u0019\u0002\u001dA\f'\u000f^5uS>tg*Y7fgB\u0019Q.^\u001a\t\u0011\u0005\u001d\u0014\u0011\u0001a\u0001\u0003S\n\u0011\u0002\u001e5sKNDw\u000e\u001c3\u0011\u0007}\tY'C\u0002\u0002n\u0001\u00121!\u00138u\u0011!\t\t(!\u0001A\u0002\u0005M\u0014\u0001\u0003:fg>dg/\u001a:\u0011\t\u0005U\u0014\u0011\u0011\b\u0005\u0003o\niH\u0004\u0003\u0002 \u0005e\u0014bAA>-\u0005A\u0011M\\1msNL7/C\u0002u\u0003\u007fR1!a\u001f\u0017\u0013\u0011\t\u0019)!\"\u0003\u0011I+7o\u001c7wKJT1\u0001^A@\u0011!\tI)!\u0001A\u0002\u0005-\u0015aD3wC2$\u0016m]6TkB\u0004xN\u001d;\u0011\t\u00055\u00151S\u0007\u0003\u0003\u001fSA!!%\u0002\f\u0005A\u0001/\u0019:bY2,G.\u0003\u0003\u0002\u0016\u0006=%a\u0005$pe.Tu.\u001b8UCN\\7+\u001e9q_J$\bbBAM\u0001\u0011%\u00111T\u0001\u0015O\u0006$\b.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^:\u0015\u0019\u0005u\u0015\u0011VAV\u0003_\u000b\t,!.\u0011\u000f\u0005%\u0011qT\u001a\u0002$&!\u0011\u0011UA\u0006\u0005\u00199UM\\'baB\u00191$!*\n\u0007\u0005\u001d&AA\nQCJ$\u0018\u000e^5p]N#\u0018\r^5ti&\u001c7\u000f\u0003\u0004\n\u0003/\u0003\r! \u0005\t\u0003[\u000b9\n1\u0001\u0002\b\u0005)\u0002/\u0019:uSRLwN\\*qK\u000e\u001c\u0018I\u001c3M_\u000e\u001c\bb\u0002/\u0002\u0018\u0002\u0007\u0011Q\n\u0005\b\u0003g\u000b9\n1\u0001Z\u0003)\u0001\u0018\r\u001e5GS2$XM\u001d\u0005\t\u0003O\n9\n1\u0001\u0002j!9\u0011\u0011\u0018\u0001\u0005\n\u0005m\u0016!D1eIB\u000b'\u000f^5uS>t7\u000f\u0006\u0006\u0002>\u0006\r\u0017QYAi\u0003'\u00042aHA`\u0013\r\t\t\r\t\u0002\u0005+:LG\u000f\u0003\u0004\n\u0003o\u0003\r! \u0005\t\u0003\u000f\f9\f1\u0001\u0002J\u0006)A/\u00192mKB!\u00111ZAg\u001b\t\tY$\u0003\u0003\u0002P\u0006m\"\u0001D\"bi\u0006dwn\u001a+bE2,\u0007\u0002CAW\u0003o\u0003\r!a\u0002\t\u0011\u0005U\u0017q\u0017a\u0001\u0003;\u000ba\u0002]1si&$\u0018n\u001c8Ti\u0006$8\u000fC\u0005\u0002Z\u0002\t\t\u0011\"\u0001\u0002\\\u0006!1m\u001c9z)\u0015y\u0014Q\\Ap\u0011!A\u0013q\u001bI\u0001\u0002\u0004Q\u0003\u0002C\u0019\u0002XB\u0005\t\u0019A\u001a\t\u0013\u0005\r\b!%A\u0005\u0002\u0005\u0015\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003OT3AKAuW\t\tY\u000f\u0005\u0003\u0002n\u0006]XBAAx\u0015\u0011\t\t0a=\u0002\u0013Ut7\r[3dW\u0016$'bAA{A\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005e\u0018q\u001e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA\u007f\u0001E\u0005I\u0011AA\u0000\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"A!\u0001+\u0007M\nI\u000f\u0003\u0005\u0003\u0006\u0001\t\t\u0011\"\u0011E\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jq\"I!\u0011\u0002\u0001\u0002\u0002\u0013\u0005!1B\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003SB\u0011Ba\u0004\u0001\u0003\u0003%\tA!\u0005\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!1\u0003B\r!\ry\"QC\u0005\u0004\u0005/\u0001#aA!os\"Q!1\u0004B\u0007\u0003\u0003\u0005\r!!\u001b\u0002\u0007a$\u0013\u0007C\u0005\u0003 \u0001\t\t\u0011\"\u0011\u0003\"\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003$A1\u0011\u0011\u0002B\u0013\u0005'IAAa\n\u0002\f\tA\u0011\n^3sCR|'\u000fC\u0005\u0003,\u0001\t\t\u0011\"\u0001\u0003.\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u00030\tU\u0002cA\u0010\u00032%\u0019!1\u0007\u0011\u0003\u000f\t{w\u000e\\3b]\"Q!1\u0004B\u0015\u0003\u0003\u0005\rAa\u0005\t\u0013\te\u0002!!A\u0005B\tm\u0012AB3rk\u0006d7\u000f\u0006\u0003\u00030\tu\u0002B\u0003B\u000e\u0005o\t\t\u00111\u0001\u0003\u0014\u001dI!\u0011\t\u0002\u0002\u0002#\u0005!1I\u0001#\u00032$XM\u001d+bE2,'+Z2pm\u0016\u0014\b+\u0019:uSRLwN\\:D_6l\u0017M\u001c3\u0011\u0007m\u0011)E\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012\u0001B$'\u0015\u0011)E!\u0013%!\u001d\u0011YE!\u0015+g}j!A!\u0014\u000b\u0007\t=\u0003%A\u0004sk:$\u0018.\\3\n\t\tM#Q\n\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004bB\u001f\u0003F\u0011\u0005!q\u000b\u000b\u0003\u0005\u0007B!Ba\u0017\u0003F\u0005\u0005IQ\tB/\u0003!!xn\u0015;sS:<G#A#\t\u0015\t\u0005$QIA\u0001\n\u0003\u0013\u0019'A\u0003baBd\u0017\u0010F\u0003@\u0005K\u00129\u0007\u0003\u0004)\u0005?\u0002\rA\u000b\u0005\tc\t}\u0003\u0013!a\u0001g!Q!1\u000eB#\u0003\u0003%\tI!\u001c\u0002\u000fUt\u0017\r\u001d9msR!!q\u000eB<!\u0015y\"\u0011\u000fB;\u0013\r\u0011\u0019\b\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b}\t)BK\u001a\t\u0013\te$\u0011NA\u0001\u0002\u0004y\u0014a\u0001=%a!Q!Q\u0010B##\u0003%\t!a@\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIIB!B!!\u0003FE\u0005I\u0011AA\u0000\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e!Q!Q\u0011B#\u0003\u0003%IAa\"\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005\u0013\u00032A\u0012BF\u0013\r\u0011ii\u0012\u0002\u0007\u001f\nTWm\u0019;")
public class AlterTableRecoverPartitionsCommand
extends LeafNode
implements RunnableCommand,
Serializable {
    private final TableIdentifier tableName;
    private final String cmd;
    private final String NUM_FILES;
    private final String TOTAL_SIZE;
    private final String DDL_TIME;

    public static String $lessinit$greater$default$2() {
        return AlterTableRecoverPartitionsCommand$.MODULE$.$lessinit$greater$default$2();
    }

    public static String apply$default$2() {
        return AlterTableRecoverPartitionsCommand$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<TableIdentifier, String>, AlterTableRecoverPartitionsCommand> tupled() {
        return AlterTableRecoverPartitionsCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<String, AlterTableRecoverPartitionsCommand>> curried() {
        return AlterTableRecoverPartitionsCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.class.output((Command)this);
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public String cmd() {
        return this.cmd;
    }

    public String NUM_FILES() {
        return this.NUM_FILES;
    }

    public String TOTAL_SIZE() {
        return this.TOTAL_SIZE;
    }

    public String DDL_TIME() {
        return this.DDL_TIME;
    }

    public PathFilter org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$$getPathFilter(Configuration hadoopConf) {
        JobConf jobConf = new JobConf(hadoopConf, this.getClass());
        PathFilter pathFilter = FileInputFormat.getInputPathFilter((JobConf)jobConf);
        return new PathFilter(this, pathFilter){
            private final PathFilter pathFilter$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean accept(Path path) {
                String name;
                String string = name = path.getName();
                String string2 = "_SUCCESS";
                if (string == null) {
                    if (string2 == null) return false;
                } else if (string.equals(string2)) return false;
                String string3 = name;
                String string4 = "_temporary";
                if (string3 == null) {
                    if (string4 == null) return false;
                } else if (string3.equals(string4)) return false;
                if (name.startsWith(".")) {
                    return false;
                }
                if (this.pathFilter$1 == null) return true;
                if (!this.pathFilter$1.accept(path)) return false;
                return true;
            }
            {
                this.pathFilter$1 = pathFilter$1;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<Row> run(SparkSession spark) {
        Seq seq;
        SessionCatalog catalog2 = spark.sessionState().catalog();
        CatalogTable table = catalog2.getTableMetadata(this.tableName());
        String tableIdentWithDB = table.identifier().quotedString();
        DDLUtils$.MODULE$.verifyAlterTableType(catalog2, table, false);
        if (table.partitionColumnNames().isEmpty()) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation not allowed: ", " only works on partitioned tables: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cmd(), tableIdentWithDB})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (table.storage().locationUri().isEmpty()) {
            throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation not allowed: ", " only works on table with "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cmd()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"location provided: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableIdentWithDB}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        Path root = new Path(table.location());
        this.logInfo((Function0)new Serializable(this, root){
            public static final long serialVersionUID = 0L;
            private final Path root$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Recover all the partitions in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.root$1}));
            }
            {
                this.root$1 = root$1;
            }
        });
        FileSystem fs = root.getFileSystem(spark.sparkContext().hadoopConfiguration());
        int threshold = new StringOps(Predef$.MODULE$.augmentString(spark.conf().get("spark.rdd.parallelListingThreshold", "10"))).toInt();
        Configuration hadoopConf = spark.sparkContext().hadoopConfiguration();
        PathFilter pathFilter = this.org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$$getPathFilter(hadoopConf);
        ForkJoinPool evalPool = ThreadUtils$.MODULE$.newForkJoinPool("AlterTableRecoverPartitionsCommand", 8);
        try {
            seq = this.org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$$scanPartitions(spark, fs, pathFilter, root, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), (Seq<String>)table.partitionColumnNames(), threshold, (Function2<String, String, Object>)spark.sessionState().conf().resolver(), new ForkJoinTaskSupport(evalPool)).seq();
        }
        catch (Throwable throwable) {
            void var10_10;
            var10_10.shutdown();
            throw throwable;
        }
        evalPool.shutdown();
        Seq partitionSpecsAndLocs = seq;
        int total = partitionSpecsAndLocs.length();
        this.logInfo((Function0)new Serializable(this, root, total){
            public static final long serialVersionUID = 0L;
            private final Path root$1;
            private final int total$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " partitions in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.total$1), this.root$1}));
            }
            {
                this.root$1 = root$1;
                this.total$1 = total$1;
            }
        });
        GenMap<String, PartitionStatistics> partitionStats = spark.sqlContext().conf().gatherFastStats() ? this.gatherPartitionStats(spark, (GenSeq<Tuple2<Map<String, String>, Path>>)partitionSpecsAndLocs, fs, pathFilter, threshold) : GenMap$.MODULE$.empty();
        this.logInfo((Function0)new Serializable(this, total){
            public static final long serialVersionUID = 0L;
            private final int total$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finished to gather the fast stats for all ", " partitions."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.total$1)}));
            }
            {
                this.total$1 = total$1;
            }
        });
        this.addPartitions(spark, table, (GenSeq<Tuple2<Map<String, String>, Path>>)partitionSpecsAndLocs, partitionStats);
        boolean x$97 = true;
        TableIdentifier x$98 = table.copy$default$1();
        CatalogTableType x$99 = table.copy$default$2();
        CatalogStorageFormat x$100 = table.copy$default$3();
        StructType x$101 = table.copy$default$4();
        Option x$102 = table.copy$default$5();
        Seq x$103 = table.copy$default$6();
        Option x$104 = table.copy$default$7();
        String x$105 = table.copy$default$8();
        long x$106 = table.copy$default$9();
        long x$107 = table.copy$default$10();
        Map x$108 = table.copy$default$11();
        Option x$109 = table.copy$default$12();
        Option x$110 = table.copy$default$13();
        Option x$111 = table.copy$default$14();
        Seq x$112 = table.copy$default$15();
        boolean x$113 = table.copy$default$17();
        spark.sessionState().catalog().alterTable(table.copy(x$98, x$99, x$100, x$101, x$102, x$103, x$104, x$105, x$106, x$107, x$108, x$109, x$110, x$111, x$112, x$97, x$113));
        catalog2.refreshTable(this.tableName());
        this.logInfo((Function0)new Serializable(this, total){
            public static final long serialVersionUID = 0L;
            private final int total$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Recovered all partitions (", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.total$1)}));
            }
            {
                this.total$1 = total$1;
            }
        });
        return (Seq)Seq$.MODULE$.empty();
    }

    public GenSeq<Tuple2<Map<String, String>, Path>> org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$$scanPartitions(SparkSession spark, FileSystem fs, PathFilter filter2, Path path, Map<String, String> spec, Seq<String> partitionNames, int threshold, Function2<String, String, Object> resolver, ForkJoinTaskSupport evalTaskSupport) {
        WrappedArray wrappedArray;
        if (partitionNames.isEmpty()) {
            return (GenSeq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(spec), (Object)path)}));
        }
        FileStatus[] statuses = fs.listStatus(path, filter2);
        if (partitionNames.length() > 1 && statuses.length > threshold || partitionNames.length() > 2) {
            ParArray parArray = Predef$.MODULE$.refArrayOps((Object[])statuses).par();
            parArray.tasksupport_$eq((TaskSupport)evalTaskSupport);
            wrappedArray = parArray;
        } else {
            wrappedArray = Predef$.MODULE$.wrapRefArray((Object[])statuses);
        }
        WrappedArray statusPar = wrappedArray;
        return (GenSeq)statusPar.flatMap((Function1)new Serializable(this, spark, fs, filter2, path, spec, partitionNames, threshold, resolver, evalTaskSupport){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AlterTableRecoverPartitionsCommand $outer;
            private final SparkSession spark$1;
            private final FileSystem fs$1;
            private final PathFilter filter$1;
            public final Path path$1;
            private final Map spec$1;
            public final Seq partitionNames$1;
            private final int threshold$1;
            private final Function2 resolver$2;
            private final ForkJoinTaskSupport evalTaskSupport$1;

            public final GenSeq<Tuple2<Map<String, String>, Path>> apply(FileStatus st) {
                GenSeq<Tuple2<Map<String, String>, Path>> genSeq;
                String name = st.getPath().getName();
                if (st.isDirectory() && name.contains("=")) {
                    String[] ps = name.split("=", 2);
                    String columnName = ExternalCatalogUtils$.MODULE$.unescapePathName(ps[0]);
                    String value = ExternalCatalogUtils$.MODULE$.unescapePathName(ps[1]);
                    if (BoxesRunTime.unboxToBoolean((Object)this.resolver$2.apply((Object)columnName, this.partitionNames$1.head()))) {
                        genSeq = this.$outer.org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$$scanPartitions(this.spark$1, this.fs$1, this.filter$1, st.getPath(), (Map<String, String>)this.spec$1.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(this.partitionNames$1.head()), (Object)value)}))), (Seq<String>)((Seq)this.partitionNames$1.drop(1)), this.threshold$1, (Function2<String, String, Object>)this.resolver$2, this.evalTaskSupport$1);
                    } else {
                        this.$outer.logWarning((Function0)new Serializable(this, ps){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$$scanPartitions$1 $outer;
                            private final String[] ps$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected partition column ", ", but got ", ", ignoring it"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.partitionNames$1.head(), this.ps$1[0]}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.ps$1 = ps$1;
                            }
                        });
                        genSeq = (GenSeq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                    }
                } else {
                    this.$outer.logWarning((Function0)new Serializable(this, name){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$$scanPartitions$1 $outer;
                        private final String name$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ignore ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new Path(this.$outer.path$1, this.name$2)}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.name$2 = name$2;
                        }
                    });
                    genSeq = (GenSeq<Tuple2<Map<String, String>, Path>>)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                }
                return genSeq;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.spark$1 = spark$1;
                this.fs$1 = fs$1;
                this.filter$1 = filter$1;
                this.path$1 = path$1;
                this.spec$1 = spec$1;
                this.partitionNames$1 = partitionNames$1;
                this.threshold$1 = threshold$1;
                this.resolver$2 = resolver$2;
                this.evalTaskSupport$1 = evalTaskSupport$1;
            }
        }, (CanBuildFrom)GenSeq$.MODULE$.canBuildFrom());
    }

    private GenMap<String, PartitionStatistics> gatherPartitionStats(SparkSession spark, GenSeq<Tuple2<Map<String, String>, Path>> partitionSpecsAndLocs, FileSystem fs, PathFilter pathFilter, int threshold) {
        GenMap genMap;
        if (partitionSpecsAndLocs.length() > threshold) {
            Configuration hadoopConf = spark.sparkContext().hadoopConfiguration();
            SerializableConfiguration serializableConfiguration = new SerializableConfiguration(hadoopConf);
            String[] serializedPaths = (String[])((GenTraversableOnce)partitionSpecsAndLocs.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<Map<String, String>, Path> x$9) {
                    return ((Path)x$9._2()).toString();
                }
            }, (CanBuildFrom)GenSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
            int numParallelism = Math.min(serializedPaths.length, Math.min(spark.sparkContext().defaultParallelism(), 10000));
            this.logInfo((Function0)new Serializable(this, numParallelism){
                public static final long serialVersionUID = 0L;
                private final int numParallelism$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Gather the fast stats in parallel using ", " tasks."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numParallelism$1)}));
                }
                {
                    this.numParallelism$1 = numParallelism$1;
                }
            });
            RDD qual$1 = spark.sparkContext().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])serializedPaths), numParallelism, ClassTag$.MODULE$.apply(String.class));
            Serializable x$114 = new Serializable(this, serializableConfiguration){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AlterTableRecoverPartitionsCommand $outer;
                public final SerializableConfiguration serializableConfiguration$1;

                public final Iterator<Tuple2<String, PartitionStatistics>> apply(Iterator<String> paths) {
                    PathFilter pathFilter = this.$outer.org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$$getPathFilter(this.serializableConfiguration$1.value());
                    return paths.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Path apply(String x$10) {
                            return new Path(x$10);
                        }
                    }).map((Function1)new Serializable(this, pathFilter){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$11 $outer;
                        private final PathFilter pathFilter$3;

                        public final Tuple2<String, PartitionStatistics> apply(Path path) {
                            FileSystem fs = path.getFileSystem(this.$outer.serializableConfiguration$1.value());
                            FileStatus[] statuses = fs.listStatus(path, this.pathFilter$3);
                            return new Tuple2((Object)path.toString(), (Object)new PartitionStatistics(statuses.length, BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])statuses).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final long apply(FileStatus x$11) {
                                    return x$11.getLen();
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.pathFilter$3 = pathFilter$3;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.serializableConfiguration$1 = serializableConfiguration$1;
                }
            };
            boolean x$115 = qual$1.mapPartitions$default$2();
            genMap = RDD$.MODULE$.rddToPairRDDFunctions(qual$1.mapPartitions((Function1)x$114, x$115, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(PartitionStatistics.class), (Ordering)Ordering.String$.MODULE$).collectAsMap();
        } else {
            genMap = ((GenTraversableOnce)partitionSpecsAndLocs.map((Function1)new Serializable(this, fs, pathFilter){
                public static final long serialVersionUID = 0L;
                private final FileSystem fs$2;
                private final PathFilter pathFilter$2;

                public final Tuple2<String, PartitionStatistics> apply(Tuple2<Map<String, String>, Path> x0$3) {
                    Tuple2<Map<String, String>, Path> tuple2 = x0$3;
                    if (tuple2 != null) {
                        Path location = (Path)tuple2._2();
                        FileStatus[] statuses = this.fs$2.listStatus(location, this.pathFilter$2);
                        Tuple2 tuple22 = new Tuple2((Object)location.toString(), (Object)new PartitionStatistics(statuses.length, BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])statuses).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply(FileStatus x$12) {
                                return x$12.getLen();
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.fs$2 = fs$2;
                    this.pathFilter$2 = pathFilter$2;
                }
            }, (CanBuildFrom)GenSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        }
        return genMap;
    }

    private void addPartitions(SparkSession spark, CatalogTable table, GenSeq<Tuple2<Map<String, String>, Path>> partitionSpecsAndLocs, GenMap<String, PartitionStatistics> partitionStats) {
        int total = partitionSpecsAndLocs.length();
        LongRef done = new LongRef(0L);
        int batchSize = 100;
        partitionSpecsAndLocs.toIterator().grouped(batchSize).foreach((Function1)new Serializable(this, spark, table, partitionStats, total, done){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AlterTableRecoverPartitionsCommand $outer;
            private final SparkSession spark$2;
            public final CatalogTable table$5;
            public final GenMap partitionStats$1;
            public final int total$2;
            public final LongRef done$1;

            public final void apply(Seq<Tuple2<Map<String, String>, Path>> batch) {
                long now = System.currentTimeMillis() / 1000L;
                Seq parts = (Seq)batch.map((Function1)new Serializable(this, now){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$addPartitions$1 $outer;
                    public final long now$1;

                    public final CatalogTablePartition apply(Tuple2<Map<String, String>, Path> x0$4) {
                        Tuple2<Map<String, String>, Path> tuple2 = x0$4;
                        if (tuple2 != null) {
                            Map spec = (Map)tuple2._1();
                            Path location = (Path)tuple2._2();
                            Map params = (Map)this.$outer.partitionStats$1.get((Object)location.toString()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$addPartitions$1$$anonfun$12 $outer;

                                public final Map<String, String> apply(PartitionStatistics x0$5) {
                                    PartitionStatistics partitionStatistics = x0$5;
                                    if (partitionStatistics != null) {
                                        int numFiles = partitionStatistics.numFiles();
                                        long totalSize = partitionStatistics.totalSize();
                                        Map map2 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$$anonfun$$anonfun$$$outer().org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$$anonfun$$$outer().NUM_FILES()), (Object)((Object)BoxesRunTime.boxToInteger((int)numFiles)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$$anonfun$$anonfun$$$outer().org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$$anonfun$$$outer().TOTAL_SIZE()), (Object)((Object)BoxesRunTime.boxToLong((long)totalSize)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$$anonfun$$anonfun$$$outer().org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$$anonfun$$$outer().DDL_TIME()), (Object)((Object)BoxesRunTime.boxToLong((long)this.$outer.now$1)).toString())}));
                                        return map2;
                                    }
                                    throw new MatchError((Object)partitionStatistics);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            }).getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Map<String, Nothing$> apply() {
                                    return Predef$.MODULE$.Map().empty();
                                }
                            });
                            CatalogTablePartition catalogTablePartition = new CatalogTablePartition(spec, this.$outer.table$5.storage().copy((Option)new Some((Object)location.toUri()), this.$outer.table$5.storage().copy$default$2(), this.$outer.table$5.storage().copy$default$3(), this.$outer.table$5.storage().copy$default$4(), this.$outer.table$5.storage().copy$default$5(), this.$outer.table$5.storage().copy$default$6()), params);
                            return catalogTablePartition;
                        }
                        throw new MatchError(tuple2);
                    }

                    public /* synthetic */ $anonfun$addPartitions$1 org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.now$1 = now$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                this.spark$2.sessionState().catalog().createPartitions(this.$outer.tableName(), parts, true);
                this.done$1.elem += (long)parts.length();
                this.$outer.logDebug((Function0)new Serializable(this, parts){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$addPartitions$1 $outer;
                    private final Seq parts$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Recovered ", " partitions (", "/", " so far)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.parts$1.length()), BoxesRunTime.boxToLong((long)this.$outer.done$1.elem), BoxesRunTime.boxToInteger((int)this.$outer.total$2)}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.parts$1 = parts$1;
                    }
                });
            }

            public /* synthetic */ AlterTableRecoverPartitionsCommand org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.spark$2 = spark$2;
                this.table$5 = table$5;
                this.partitionStats$1 = partitionStats$1;
                this.total$2 = total$2;
                this.done$1 = done$1;
            }
        });
    }

    public AlterTableRecoverPartitionsCommand copy(TableIdentifier tableName, String cmd) {
        return new AlterTableRecoverPartitionsCommand(tableName, cmd);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public String copy$default$2() {
        return this.cmd();
    }

    public String productPrefix() {
        return "AlterTableRecoverPartitionsCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                string = this.cmd();
                break;
            }
            case 0: {
                string = this.tableName();
            }
        }
        return string;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableRecoverPartitionsCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableRecoverPartitionsCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableRecoverPartitionsCommand alterTableRecoverPartitionsCommand = (AlterTableRecoverPartitionsCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = alterTableRecoverPartitionsCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        String string = this.cmd();
        String string2 = alterTableRecoverPartitionsCommand.cmd();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!alterTableRecoverPartitionsCommand.canEqual(this)) return false;
        return true;
    }

    public AlterTableRecoverPartitionsCommand(TableIdentifier tableName, String cmd) {
        this.tableName = tableName;
        this.cmd = cmd;
        Command.class.$init$((Command)this);
        this.NUM_FILES = "numFiles";
        this.TOTAL_SIZE = "totalSize";
        this.DDL_TIME = "transient_lastDdlTime";
    }
}

