/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.parquet;

import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLConf$;
import org.apache.spark.sql.parquet.FilteringParquetRowInputFormat$;
import org.apache.spark.sql.parquet.RowReadSupport;
import org.apache.spark.sql.parquet.RowReadSupport$;
import org.apache.spark.sql.parquet.RowWriteSupport$;
import org.slf4j.Logger;
import parquet.filter2.compat.FilterCompat;
import parquet.filter2.compat.RowGroupFilter;
import parquet.hadoop.Footer;
import parquet.hadoop.ParquetFileWriter;
import parquet.hadoop.ParquetInputFormat;
import parquet.hadoop.ParquetInputSplit;
import parquet.hadoop.ParquetRecordReader;
import parquet.hadoop.api.InitContext;
import parquet.hadoop.api.ReadSupport;
import parquet.hadoop.metadata.GlobalMetaData;
import parquet.hadoop.metadata.ParquetMetadata;
import parquet.hadoop.util.ContextUtil;
import parquet.io.ParquetDecodingException;
import parquet.schema.MessageType;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dg!B\u0001\u0003\u0001\ta!A\b$jYR,'/\u001b8h!\u0006\u0014\u0018/^3u%><\u0018J\u001c9vi\u001a{'/\\1u\u0015\t\u0019A!A\u0004qCJ\fX/\u001a;\u000b\u0005\u00151\u0011aA:rY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001b=\u00022A\u0004\n\u0015\u001b\u0005y!B\u0001\t\u0012\u0003\u0019A\u0017\rZ8pa*\t1!\u0003\u0002\u0014\u001f\t\u0011\u0002+\u0019:rk\u0016$\u0018J\u001c9vi\u001a{'/\\1u!\t)BF\u0004\u0002\u0017S9\u0011qC\n\b\u00031\u0011r!!G\u0012\u000f\u0005i\u0011cBA\u000e\"\u001d\ta\u0002%D\u0001\u001e\u0015\tqr$\u0001\u0004=e>|GOP\u0002\u0001\u0013\u0005Y\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u0011Q\u0005B\u0001\tG\u0006$\u0018\r\\=ti&\u0011q\u0005K\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002&\t%\u0011!fK\u0001\ba\u0006\u001c7.Y4f\u0015\t9\u0003&\u0003\u0002.]\t\u0019!k\\<\u000b\u0005)Z\u0003C\u0001\u00192\u001b\u00051\u0011B\u0001\u001a\u0007\u0005\u001daunZ4j]\u001eDQ\u0001\u000e\u0001\u0005\u0002U\na\u0001P5oSRtD#\u0001\u001c\u0011\u0005]\u0002Q\"\u0001\u0002\t\u000fe\u0002\u0001\u0019!C\u0005u\u0005aa-\u001b7f'R\fG/^:fgV\t1\b\u0005\u0003=\u0007\u0016cU\"A\u001f\u000b\u0005yz\u0014!C5n[V$\u0018M\u00197f\u0015\t\u0001\u0015)\u0001\u0006d_2dWm\u0019;j_:T\u0011AQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\tv\u00121!T1q!\t1%*D\u0001H\u0015\tA\u0015*\u0001\u0002gg*\u0011\u0001\u0003C\u0005\u0003\u0017\u001e\u0013A\u0001U1uQB\u0011a)T\u0005\u0003\u001d\u001e\u0013!BR5mKN#\u0018\r^;t\u0011\u001d\u0001\u0006\u00011A\u0005\nE\u000b\u0001CZ5mKN#\u0018\r^;tKN|F%Z9\u0015\u0005I3\u0006CA*U\u001b\u0005\t\u0015BA+B\u0005\u0011)f.\u001b;\t\u000f]{\u0015\u0011!a\u0001w\u0005\u0019\u0001\u0010J\u0019\t\re\u0003\u0001\u0015)\u0003<\u000351\u0017\u000e\\3Ti\u0006$Xo]3tA!)1\f\u0001C!9\u0006\u00112M]3bi\u0016\u0014VmY8sIJ+\u0017\rZ3s)\ri6\u000e\u001d\t\u0005=\u0006\u001cG#D\u0001`\u0015\t\u0001\u0017*A\u0005nCB\u0014X\rZ;dK&\u0011!m\u0018\u0002\r%\u0016\u001cwN\u001d3SK\u0006$WM\u001d\t\u0003I&l\u0011!\u001a\u0006\u0003M\u001e\fA\u0001\\1oO*\t\u0001.\u0001\u0003kCZ\f\u0017B\u00016f\u0005\u00111v.\u001b3\t\u000b1T\u0006\u0019A7\u0002\u0015%t\u0007/\u001e;Ta2LG\u000f\u0005\u0002_]&\u0011qn\u0018\u0002\u000b\u0013:\u0004X\u000f^*qY&$\b\"B9[\u0001\u0004\u0011\u0018A\u0005;bg.\fE\u000f^3naR\u001cuN\u001c;fqR\u0004\"AX:\n\u0005Q|&A\u0005+bg.\fE\u000f^3naR\u001cuN\u001c;fqRDQA\u001e\u0001\u0005B]\f\u0011bZ3u'Bd\u0017\u000e^:\u0015\u0005at\bcA=}[6\t!P\u0003\u0002|O\u0006!Q\u000f^5m\u0013\ti(P\u0001\u0003MSN$\bBB@v\u0001\u0004\t\t!\u0001\u0006k_\n\u001cuN\u001c;fqR\u00042AXA\u0002\u0013\r\t)a\u0018\u0002\u000b\u0015>\u00147i\u001c8uKb$\bB\u0002<\u0001\t\u0003\nI\u0001\u0006\u0004\u0002\f\u0005M\u00111\u0005\t\u0005sr\fi\u0001E\u0002\u000f\u0003\u001fI1!!\u0005\u0010\u0005E\u0001\u0016M]9vKRLe\u000e];u'Bd\u0017\u000e\u001e\u0005\t\u0003+\t9\u00011\u0001\u0002\u0018\u0005i1m\u001c8gS\u001e,(/\u0019;j_:\u0004B!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0004\u0003;I\u0015\u0001B2p]\u001aLA!!\t\u0002\u001c\ti1i\u001c8gS\u001e,(/\u0019;j_:D\u0001\"!\n\u0002\b\u0001\u0007\u0011qE\u0001\bM>|G/\u001a:t!\u0011IH0!\u000b\u0011\u00079\tY#C\u0002\u0002.=\u0011aAR8pi\u0016\u0014\bbBA\u0019\u0001\u0011\u0005\u00111G\u0001\u0014O\u0016$8\t\\5f]R\u001c\u0016\u000eZ3Ta2LGo\u001d\u000b\r\u0003\u0017\t)$a\u000e\u0002:\u0005\r\u0013q\t\u0005\t\u0003+\ty\u00031\u0001\u0002\u0018!A\u0011QEA\u0018\u0001\u0004\t9\u0003\u0003\u0005\u0002<\u0005=\u0002\u0019AA\u001f\u00031i\u0017\r_*qY&$8+\u001b>f!\r!\u0017qH\u0005\u0004\u0003\u0003*'\u0001\u0002'p]\u001eD\u0001\"!\u0012\u00020\u0001\u0007\u0011QH\u0001\r[&t7\u000b\u001d7jiNK'0\u001a\u0005\t\u0003\u0013\ny\u00031\u0001\u0002L\u0005Y!/Z1e\u0007>tG/\u001a=u!\u0011\ti%a\u0019\u000f\t\u0005=\u0013Q\f\b\u0005\u0003#\nIF\u0004\u0003\u0002T\u0005]cb\u0001\u000f\u0002V%\t1!\u0003\u0002\u0011#%\u0019\u00111L\b\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002`\u0005\u0005\u0014a\u0003*fC\u0012\u001cV\u000f\u001d9peRT1!a\u0017\u0010\u0013\u0011\t)'a\u001a\u0003\u0017I+\u0017\rZ\"p]R,\u0007\u0010\u001e\u0006\u0005\u0003?\n\t\u0007C\u0004\u0002l\u0001!\t!!\u001c\u0002#\u001d,G\u000fV1tWNKG-Z*qY&$8\u000f\u0006\u0007\u0002\f\u0005=\u0014\u0011OA:\u0003k\n9\b\u0003\u0005\u0002\u0016\u0005%\u0004\u0019AA\f\u0011!\t)#!\u001bA\u0002\u0005\u001d\u0002\u0002CA\u001e\u0003S\u0002\r!!\u0010\t\u0011\u0005\u0015\u0013\u0011\u000ea\u0001\u0003{A\u0001\"!\u0013\u0002j\u0001\u0007\u00111J\u0004\t\u0003w\u0012\u0001\u0012\u0001\u0002\u0002~\u0005qb)\u001b7uKJLgn\u001a)beF,X\r\u001e*po&s\u0007/\u001e;G_Jl\u0017\r\u001e\t\u0004o\u0005}daB\u0001\u0003\u0011\u0003\u0011\u0011\u0011Q\n\u0005\u0003\u007f\n\u0019\tE\u0002T\u0003\u000bK1!a\"B\u0005\u0019\te.\u001f*fM\"9A'a \u0005\u0002\u0005-ECAA?\u0011)\ty)a C\u0002\u0013%\u0011\u0011S\u0001\fM>|G/\u001a:DC\u000eDW-\u0006\u0002\u0002\u0014B9\u0011QSAT\u0019\u0006%RBAAL\u0015\u0011\tI*a'\u0002\u000b\r\f7\r[3\u000b\t\u0005u\u0015qT\u0001\u0007G>lWn\u001c8\u000b\t\u0005\u0005\u00161U\u0001\u0007O>|w\r\\3\u000b\u0005\u0005\u0015\u0016aA2p[&!\u0011\u0011VAL\u0005\u0015\u0019\u0015m\u00195f\u0011%\ti+a !\u0002\u0013\t\u0019*\u0001\u0007g_>$XM]\"bG\",\u0007\u0005\u0003\u0006\u00022\u0006}$\u0019!C\u0005\u0003g\u000b!C\u00197pG.dunY1uS>t7)Y2iKV\u0011\u0011Q\u0017\t\b\u0003+\u000b9\u000bTA\\!\u0015\u0019\u0016\u0011XA_\u0013\r\tY,\u0011\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004\r\u0006}\u0016bAAa\u000f\ni!\t\\8dW2{7-\u0019;j_:D\u0011\"!2\u0002\u0000\u0001\u0006I!!.\u0002'\tdwnY6M_\u000e\fG/[8o\u0007\u0006\u001c\u0007.\u001a\u0011")
public class FilteringParquetRowInputFormat
extends ParquetInputFormat<Row>
implements Logging {
    private Map<Path, FileStatus> org$apache$spark$sql$parquet$FilteringParquetRowInputFormat$$fileStatuses;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public Map<Path, FileStatus> org$apache$spark$sql$parquet$FilteringParquetRowInputFormat$$fileStatuses() {
        return this.org$apache$spark$sql$parquet$FilteringParquetRowInputFormat$$fileStatuses;
    }

    private void org$apache$spark$sql$parquet$FilteringParquetRowInputFormat$$fileStatuses_$eq(Map<Path, FileStatus> x$1) {
        this.org$apache$spark$sql$parquet$FilteringParquetRowInputFormat$$fileStatuses = x$1;
    }

    public RecordReader<Void, Row> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) {
        RowReadSupport readSupport = new RowReadSupport();
        FilterCompat.Filter filter = ParquetInputFormat.getFilter((Configuration)ContextUtil.getConfiguration((JobContext)taskAttemptContext));
        return filter instanceof FilterCompat.NoOpFilter ? new ParquetRecordReader((ReadSupport)readSupport) : new ParquetRecordReader((ReadSupport)readSupport, filter);
    }

    public List<InputSplit> getSplits(JobContext jobContext) {
        List statuses = this.listStatus(jobContext);
        this.org$apache$spark$sql$parquet$FilteringParquetRowInputFormat$$fileStatuses_$eq((Map<Path, FileStatus>)((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(statuses).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Path, FileStatus> apply(FileStatus file) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)file.getPath()), (Object)file);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms()));
        return super.getSplits(jobContext);
    }

    public List<ParquetInputSplit> getSplits(Configuration configuration, List<Footer> footers) {
        List<ParquetInputSplit> list;
        boolean taskSideMetaData = configuration.getBoolean("parquet.task.side.metadata", true);
        Long maxSplitSize = Predef$.MODULE$.long2Long(configuration.getLong("mapred.max.split.size", Long.MAX_VALUE));
        Long minSplitSize = Predef$.MODULE$.long2Long(Math.max(this.getFormatMinSplitSize(), configuration.getLong("mapred.min.split.size", 0L)));
        if (Predef$.MODULE$.Long2long(maxSplitSize) < 0L || Predef$.MODULE$.Long2long(minSplitSize) < 0L) {
            throw new ParquetDecodingException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"maxSplitSize or minSplitSie should not be negative: maxSplitSize = ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{maxSplitSize}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" minSplitSize = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{minSplitSize}))).toString());
        }
        Method getGlobalMetaData = ParquetFileWriter.class.getDeclaredMethod("getGlobalMetaData", List.class);
        getGlobalMetaData.setAccessible(true);
        GlobalMetaData globalMetaData = (GlobalMetaData)getGlobalMetaData.invoke(null, footers);
        if (globalMetaData == null) {
            ArrayBuffer splits = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            return JavaConversions$.MODULE$.bufferAsJavaList((Buffer)splits);
        }
        String metadata = configuration.get(RowWriteSupport$.MODULE$.SPARK_ROW_SCHEMA());
        scala.collection.mutable.Map mergedMetadata = JavaConversions$.MODULE$.mapAsScalaMap(globalMetaData.getKeyValueMetaData()).updated((Object)RowReadSupport$.MODULE$.SPARK_METADATA_KEY(), (Object)JavaConversions$.MODULE$.setAsJavaSet((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{metadata}))));
        globalMetaData = new GlobalMetaData(globalMetaData.getSchema(), JavaConversions$.MODULE$.mutableMapAsJavaMap(mergedMetadata), globalMetaData.getCreatedBy());
        ReadSupport.ReadContext readContext = this.getReadSupport(configuration).init(new InitContext(configuration, globalMetaData.getKeyValueMetaData(), globalMetaData.getSchema()));
        if (taskSideMetaData) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Using Task Side Metadata Split Strategy";
                }
            });
            list = this.getTaskSideSplits(configuration, footers, maxSplitSize, minSplitSize, readContext);
        } else {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Using Client Side Metadata Split Strategy";
                }
            });
            list = this.getClientSideSplits(configuration, footers, maxSplitSize, minSplitSize, readContext);
        }
        return list;
    }

    public List<ParquetInputSplit> getClientSideSplits(Configuration configuration, List<Footer> footers, Long maxSplitSize, Long minSplitSize, ReadSupport.ReadContext readContext) {
        boolean cacheMetadata = configuration.getBoolean(SQLConf$.MODULE$.PARQUET_CACHE_METADATA(), true);
        ArrayBuffer splits = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        FilterCompat.Filter filter = ParquetInputFormat.getFilter((Configuration)configuration);
        LongRef rowGroupsDropped = new LongRef(0L);
        LongRef totalRowGroups = new LongRef(0L);
        Method generateSplits = (Method)Predef$.MODULE$.refArrayOps((Object[])Class.forName("parquet.hadoop.ClientSideMetadataSplitStrategy").getDeclaredMethods()).find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Method x$6) {
                String string = x$6.getName();
                String string2 = "generateSplits";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to reflectively invoke ClientSideMetadataSplitStrategy.generateSplits"})).s((Seq)Nil$.MODULE$));
            }
        });
        generateSplits.setAccessible(true);
        JavaConversions$.MODULE$.asScalaBuffer(footers).foreach((Function1)new Serializable(this, configuration, maxSplitSize, minSplitSize, readContext, cacheMetadata, splits, filter, rowGroupsDropped, totalRowGroups, generateSplits){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FilteringParquetRowInputFormat $outer;
            private final Configuration configuration$2;
            private final Long maxSplitSize$2;
            private final Long minSplitSize$2;
            private final ReadSupport.ReadContext readContext$2;
            private final boolean cacheMetadata$1;
            private final ArrayBuffer splits$1;
            private final FilterCompat.Filter filter$1;
            private final LongRef rowGroupsDropped$1;
            private final LongRef totalRowGroups$1;
            private final Method generateSplits$1;

            public final Object apply(Footer footer) {
                Object object;
                FileSystem fs = footer.getFile().getFileSystem(this.configuration$2);
                Path file = footer.getFile();
                FileStatus status = (FileStatus)this.$outer.org$apache$spark$sql$parquet$FilteringParquetRowInputFormat$$fileStatuses().getOrElse((Object)file, (Function0)new Serializable(this, fs, file){
                    public static final long serialVersionUID = 0L;
                    private final FileSystem fs$1;
                    private final Path file$1;

                    public final FileStatus apply() {
                        return this.fs$1.getFileStatus(this.file$1);
                    }
                    {
                        this.fs$1 = fs$1;
                        this.file$1 = file$1;
                    }
                });
                ParquetMetadata parquetMetaData = footer.getParquetMetadata();
                List blocks = parquetMetaData.getBlocks();
                this.totalRowGroups$1.elem += (long)blocks.size();
                List filteredBlocks = RowGroupFilter.filterRowGroups((FilterCompat.Filter)this.filter$1, (List)blocks, (MessageType)parquetMetaData.getFileMetaData().getSchema());
                this.rowGroupsDropped$1.elem += (long)(blocks.size() - filteredBlocks.size());
                if (filteredBlocks.isEmpty()) {
                    object = BoxedUnit.UNIT;
                } else {
                    BlockLocation[] blockLocations = null;
                    blockLocations = this.cacheMetadata$1 ? (BlockLocation[])FilteringParquetRowInputFormat$.MODULE$.org$apache$spark$sql$parquet$FilteringParquetRowInputFormat$$blockLocationCache().get((Object)status, (Callable)new Callable<BlockLocation[]>(this, fs, status){
                        private final FileSystem fs$1;
                        private final FileStatus status$1;

                        public BlockLocation[] call() {
                            return this.fs$1.getFileBlockLocations(this.status$1, 0L, this.status$1.getLen());
                        }
                        {
                            this.fs$1 = fs$1;
                            this.status$1 = status$1;
                        }
                    }) : fs.getFileBlockLocations(status, 0L, status.getLen());
                    object = BoxesRunTime.boxToBoolean((boolean)JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.splits$1).addAll((List)this.generateSplits$1.invoke(null, filteredBlocks, blockLocations, status, this.readContext$2.getRequestedSchema().toString(), this.readContext$2.getReadSupportMetadata(), this.minSplitSize$2, this.maxSplitSize$2)));
                }
                return object;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.configuration$2 = configuration$2;
                this.maxSplitSize$2 = maxSplitSize$2;
                this.minSplitSize$2 = minSplitSize$2;
                this.readContext$2 = readContext$2;
                this.cacheMetadata$1 = cacheMetadata$1;
                this.splits$1 = splits$1;
                this.filter$1 = filter$1;
                this.rowGroupsDropped$1 = rowGroupsDropped$1;
                this.totalRowGroups$1 = totalRowGroups$1;
                this.generateSplits$1 = generateSplits$1;
            }
        });
        if (rowGroupsDropped.elem > 0L && totalRowGroups.elem > 0L) {
            int percentDropped = (int)((double)rowGroupsDropped.elem / (double)totalRowGroups.elem * (double)100);
            this.logInfo((Function0<String>)new Serializable(this, rowGroupsDropped, percentDropped){
                public static final long serialVersionUID = 0L;
                private final LongRef rowGroupsDropped$1;
                private final int percentDropped$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dropping ", " row groups that do not pass filter predicate "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.rowGroupsDropped$1.elem)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " %) !"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.percentDropped$1)}))).toString();
                }
                {
                    this.rowGroupsDropped$1 = rowGroupsDropped$1;
                    this.percentDropped$1 = percentDropped$1;
                }
            });
        } else {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "There were no row groups that could be dropped due to filter predicates";
                }
            });
        }
        return JavaConversions$.MODULE$.bufferAsJavaList((Buffer)splits);
    }

    public List<ParquetInputSplit> getTaskSideSplits(Configuration configuration, List<Footer> footers, Long maxSplitSize, Long minSplitSize, ReadSupport.ReadContext readContext) {
        ArrayBuffer splits = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        Method generateSplits = (Method)Predef$.MODULE$.refArrayOps((Object[])Class.forName("parquet.hadoop.TaskSideMetadataSplitStrategy").getDeclaredMethods()).find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Method x$7) {
                String string = x$7.getName();
                String string2 = "generateTaskSideMDSplits";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to reflectively invoke TaskSideMetadataSplitStrategy.generateTaskSideMDSplits"})).s((Seq)Nil$.MODULE$));
            }
        });
        generateSplits.setAccessible(true);
        JavaConversions$.MODULE$.asScalaBuffer(footers).foreach((Function1)new Serializable(this, configuration, maxSplitSize, minSplitSize, readContext, splits, generateSplits){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FilteringParquetRowInputFormat $outer;
            private final Configuration configuration$1;
            private final Long maxSplitSize$1;
            private final Long minSplitSize$1;
            private final ReadSupport.ReadContext readContext$1;
            private final ArrayBuffer splits$2;
            private final Method generateSplits$2;

            public final boolean apply(Footer footer) {
                Path file = footer.getFile();
                FileSystem fs = file.getFileSystem(this.configuration$1);
                FileStatus status = (FileStatus)this.$outer.org$apache$spark$sql$parquet$FilteringParquetRowInputFormat$$fileStatuses().getOrElse((Object)file, (Function0)new Serializable(this, file, fs){
                    public static final long serialVersionUID = 0L;
                    private final Path file$2;
                    private final FileSystem fs$2;

                    public final FileStatus apply() {
                        return this.fs$2.getFileStatus(this.file$2);
                    }
                    {
                        this.file$2 = file$2;
                        this.fs$2 = fs$2;
                    }
                });
                BlockLocation[] blockLocations = fs.getFileBlockLocations(status, 0L, status.getLen());
                return JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.splits$2).addAll((List)this.generateSplits$2.invoke(null, blockLocations, status, this.readContext$1.getRequestedSchema().toString(), this.readContext$1.getReadSupportMetadata(), this.minSplitSize$1, this.maxSplitSize$1));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.configuration$1 = configuration$1;
                this.maxSplitSize$1 = maxSplitSize$1;
                this.minSplitSize$1 = minSplitSize$1;
                this.readContext$1 = readContext$1;
                this.splits$2 = splits$2;
                this.generateSplits$2 = generateSplits$2;
            }
        });
        return JavaConversions$.MODULE$.bufferAsJavaList((Buffer)splits);
    }

    public FilteringParquetRowInputFormat() {
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$sql$parquet$FilteringParquetRowInputFormat$$fileStatuses = Predef$.MODULE$.Map().empty();
    }
}

