/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.parquet;

import java.lang.reflect.Constructor;
import java.text.NumberFormat;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.spark.sql.Row;
import parquet.hadoop.ParquetOutputCommitter;
import parquet.hadoop.ParquetOutputFormat;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001}4Q!\u0001\u0002\u0001\u00051\u0011A$\u00119qK:$\u0017N\\4QCJ\fX/\u001a;PkR\u0004X\u000f\u001e$pe6\fGO\u0003\u0002\u0004\t\u00059\u0001/\u0019:rk\u0016$(BA\u0003\u0007\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0011\u0001!\u0004\t\u0004\u001dI!R\"A\b\u000b\u0005A\t\u0012A\u00025bI>|\u0007OC\u0001\u0004\u0013\t\u0019rBA\nQCJ\fX/\u001a;PkR\u0004X\u000f\u001e$pe6\fG\u000f\u0005\u0002\u0016Y9\u0011a#\u000b\b\u0003/\u0019r!\u0001\u0007\u0013\u000f\u0005e\u0019cB\u0001\u000e#\u001d\tY\u0012E\u0004\u0002\u001dA5\tQD\u0003\u0002\u001f?\u00051AH]8piz\u001a\u0001!C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003K\u0011\t\u0001bY1uC2L8\u000f^\u0005\u0003O!\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011Q\u0005B\u0005\u0003U-\nq\u0001]1dW\u0006<WM\u0003\u0002(Q%\u0011QF\f\u0002\u0004%><(B\u0001\u0016,\u0011!\u0001\u0004A!A!\u0002\u0013\t\u0014AB8gMN,G\u000f\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14GA\u0002J]RDQ\u0001\u000f\u0001\u0005\u0002e\na\u0001P5oSRtDC\u0001\u001e=!\tY\u0004!D\u0001\u0003\u0011\u0015\u0001t\u00071\u00012\u0011\u0015q\u0004\u0001\"\u0011@\u0003A\u0019\u0007.Z2l\u001fV$\b/\u001e;Ta\u0016\u001c7\u000f\u0006\u0002A\u0007B\u0011!'Q\u0005\u0003\u0005N\u0012A!\u00168ji\")A)\u0010a\u0001\u000b\u0006\u0019!n\u001c2\u0011\u0005\u0019SU\"A$\u000b\u0005!K\u0015!C7baJ,G-^2f\u0015\t\u0001\u0002\"\u0003\u0002L\u000f\nQ!j\u001c2D_:$X\r\u001f;\t\u000f5\u0003\u0001\u0019!C\u0001\u001d\u0006I1m\\7nSR$XM]\u000b\u0002\u001fB\u0011a\tU\u0005\u0003#\u001e\u0013qbT;uaV$8i\\7nSR$XM\u001d\u0005\b'\u0002\u0001\r\u0011\"\u0001U\u00035\u0019w.\\7jiR,'o\u0018\u0013fcR\u0011\u0001)\u0016\u0005\b-J\u000b\t\u00111\u0001P\u0003\rAH%\r\u0005\u00071\u0002\u0001\u000b\u0015B(\u0002\u0015\r|W.\\5ui\u0016\u0014\b\u0005C\u0003[\u0001\u0011\u00053,\u0001\nhKR$UMZ1vYR<vN]6GS2,Gc\u0001/cOB\u0011Q\fY\u0007\u0002=*\u0011q,S\u0001\u0003MNL!!\u00190\u0003\tA\u000bG\u000f\u001b\u0005\u0006Gf\u0003\r\u0001Z\u0001\bG>tG/\u001a=u!\t1U-\u0003\u0002g\u000f\n\u0011B+Y:l\u0003R$X-\u001c9u\u0007>tG/\u001a=u\u0011\u0015A\u0017\f1\u0001j\u0003%)\u0007\u0010^3og&|g\u000e\u0005\u0002k[:\u0011!g[\u0005\u0003YN\na\u0001\u0015:fI\u00164\u0017B\u00018p\u0005\u0019\u0019FO]5oO*\u0011An\r\u0005\u0006c\u0002!IA]\u0001\u0011O\u0016$H+Y:l\u0003R$X-\u001c9u\u0013\u0012#\"a\u001d<\u0011\u0005\u0019#\u0018BA;H\u00055!\u0016m]6BiR,W\u000e\u001d;J\t\")1\r\u001da\u0001I\")\u0001\u0010\u0001C!s\u0006\u0011r-\u001a;PkR\u0004X\u000f^\"p[6LG\u000f^3s)\ty%\u0010C\u0003do\u0002\u0007A\rC\u0003}\u0001\u0011%Q0A\u0007hKR|U\u000f\u001e9viB\u000bG\u000f\u001b\u000b\u00039zDQaY>A\u0002\u0011\u0004")
public class AppendingParquetOutputFormat
extends ParquetOutputFormat<Row> {
    private final int offset;
    private OutputCommitter committer;

    public void checkOutputSpecs(JobContext job) {
    }

    public OutputCommitter committer() {
        return this.committer;
    }

    public void committer_$eq(OutputCommitter x$1) {
        this.committer = x$1;
    }

    public Path getDefaultWorkFile(TaskAttemptContext context, String extension) {
        NumberFormat numfmt = NumberFormat.getInstance();
        numfmt.setMinimumIntegerDigits(5);
        numfmt.setGroupingUsed(false);
        TaskID taskId = this.getTaskAttemptID(context).getTaskID();
        int partition = taskId.getId();
        String filename = new StringBuilder().append((Object)"part-r-").append((Object)numfmt.format(partition + this.offset)).append((Object)".parquet").toString();
        FileOutputCommitter committer = (FileOutputCommitter)this.getOutputCommitter(context);
        return new Path(committer.getWorkPath(), filename);
    }

    private TaskAttemptID getTaskAttemptID(TaskAttemptContext context) {
        return (TaskAttemptID)context.getClass().getMethod("getTaskAttemptID", new Class[0]).invoke((Object)context, new Object[0]);
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) {
        if (this.committer() == null) {
            Path output2 = this.getOutputPath(context);
            Class cls = context.getConfiguration().getClass("spark.sql.parquet.output.committer.class", ParquetOutputCommitter.class, ParquetOutputCommitter.class);
            Constructor ctor = cls.getDeclaredConstructor(Path.class, TaskAttemptContext.class);
            this.committer_$eq((OutputCommitter)((ParquetOutputCommitter)ctor.newInstance(output2, context)));
        }
        return this.committer();
    }

    private Path getOutputPath(TaskAttemptContext context) {
        String string = context.getConfiguration().get("mapred.output.dir");
        Path path = string == null ? null : new Path(string);
        return path;
    }

    public AppendingParquetOutputFormat(int offset) {
        this.offset = offset;
        this.committer = null;
    }
}

