/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.parquet;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.parquet.ParquetTypesConverter$;
import org.apache.spark.sql.parquet.RowReadSupport$;
import org.apache.spark.sql.parquet.RowRecordMaterializer;
import org.apache.spark.sql.parquet.RowWriteSupport$;
import org.slf4j.Logger;
import parquet.hadoop.api.ReadSupport;
import parquet.io.api.RecordMaterializer;
import parquet.schema.MessageType;
import parquet.schema.Type;
import scala.Function0;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005=c!B\u0001\u0003\u0001\ta!A\u0004*poJ+\u0017\rZ*vaB|'\u000f\u001e\u0006\u0003\u0007\u0011\tq\u0001]1scV,GO\u0003\u0002\u0006\r\u0005\u00191/\u001d7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c2\u0001A\u00072!\rqACF\u0007\u0002\u001f)\u0011\u0001#E\u0001\u0004CBL'B\u0001\n\u0014\u0003\u0019A\u0017\rZ8pa*\t1!\u0003\u0002\u0016\u001f\tY!+Z1e'V\u0004\bo\u001c:u!\t9bF\u0004\u0002\u0019W9\u0011\u0011\u0004\u000b\b\u00035\u0019r!aG\u0013\u000f\u0005q!cBA\u000f$\u001d\tq\"%D\u0001 \u0015\t\u0001\u0013%\u0001\u0004=e>|GOP\u0002\u0001\u0013\u0005Y\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u0011q\u0005B\u0001\tG\u0006$\u0018\r\\=ti&\u0011\u0011FK\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002(\t%\u0011A&L\u0001\ba\u0006\u001c7.Y4f\u0015\tI#&\u0003\u00020a\t\u0019!k\\<\u000b\u00051j\u0003C\u0001\u001a4\u001b\u00051\u0011B\u0001\u001b\u0007\u0005\u001daunZ4j]\u001eDQA\u000e\u0001\u0005\u0002]\na\u0001P5oSRtD#\u0001\u001d\u0011\u0005e\u0002Q\"\u0001\u0002\t\u000bm\u0002A\u0011\t\u001f\u0002\u001dA\u0014X\r]1sK\u001a{'OU3bIR)Q\b\u0012'aQB\u0019aH\u0011\f\u000e\u0003}R!\u0001\u0005!\u000b\u0005\u0005\u001b\u0012AA5p\u0013\t\u0019uH\u0001\nSK\u000e|'\u000fZ'bi\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\"B#;\u0001\u00041\u0015\u0001B2p]\u001a\u0004\"a\u0012&\u000e\u0003!S!!R%\u000b\u0005IA\u0011BA&I\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\")QJ\u000fa\u0001\u001d\u0006I1\u000f\u001e:j]\u001el\u0015\r\u001d\t\u0005\u001fR3f+D\u0001Q\u0015\t\t&+\u0001\u0003vi&d'\"A*\u0002\t)\fg/Y\u0005\u0003+B\u00131!T1q!\t9VL\u0004\u0002Y76\t\u0011LC\u0001[\u0003\u0015\u00198-\u00197b\u0013\ta\u0016,\u0001\u0004Qe\u0016$WMZ\u0005\u0003=~\u0013aa\u0015;sS:<'B\u0001/Z\u0011\u0015\t'\b1\u0001c\u0003)1\u0017\u000e\\3TG\",W.\u0019\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003KN\taa]2iK6\f\u0017BA4e\u0005-iUm]:bO\u0016$\u0016\u0010]3\t\u000b%T\u0004\u0019\u00016\u0002\u0017I,\u0017\rZ\"p]R,\u0007\u0010\u001e\t\u0003WRt!\u0001\u001c:\u000f\u00055\fhB\u00018q\u001d\tqr.C\u0001\u0004\u0013\t\u00112#\u0003\u0002\u0011#%\u00111oD\u0001\f%\u0016\fGmU;qa>\u0014H/\u0003\u0002vm\nY!+Z1e\u0007>tG/\u001a=u\u0015\t\u0019x\u0002C\u0003y\u0001\u0011\u0005\u00130\u0001\u0003j]&$H\u0003\u00026{yzDQa_<A\u0002\u0019\u000bQbY8oM&<WO]1uS>t\u0007\"B?x\u0001\u0004q\u0015\u0001E6fsZ\u000bG.^3NKR\fG)\u0019;b\u0011\u0015\tw\u000f1\u0001c\u000f!\t\tA\u0001E\u0001\u0005\u0005\r\u0011A\u0004*poJ+\u0017\rZ*vaB|'\u000f\u001e\t\u0004s\u0005\u0015aaB\u0001\u0003\u0011\u0003\u0011\u0011qA\n\u0005\u0003\u000b\tI\u0001E\u0002Y\u0003\u0017I1!!\u0004Z\u0005\u0019\te.\u001f*fM\"9a'!\u0002\u0005\u0002\u0005EACAA\u0002\u0011)\t)\"!\u0002C\u0002\u0013\u0005\u0011qC\u0001\u001b'B\u000b%kS0S\u001f^{&+R)V\u000bN#V\tR0T\u0007\"+U*Q\u000b\u0003\u00033\u0001B!a\u0007\u0002\"5\u0011\u0011Q\u0004\u0006\u0004\u0003?\u0011\u0016\u0001\u00027b]\u001eL1AXA\u000f\u0011%\t)#!\u0002!\u0002\u0013\tI\"A\u000eT!\u0006\u00136j\u0018*P/~\u0013V)U+F'R+EiX*D\u0011\u0016k\u0015\t\t\u0005\u000b\u0003S\t)A1A\u0005\u0002\u0005]\u0011AE*Q\u0003J[u,T#U\u0003\u0012\u000bE+Q0L\u000bfC\u0011\"!\f\u0002\u0006\u0001\u0006I!!\u0007\u0002'M\u0003\u0016IU&`\u001b\u0016#\u0016\tR!U\u0003~[U)\u0017\u0011\t\u0011\u0005E\u0012Q\u0001C\u0005\u0003g\t!cZ3u%\u0016\fX/Z:uK\u0012\u001c6\r[3nCR!\u0011QGA'!\u0019\t9$a\u0010\u0002F9!\u0011\u0011HA\u001f\u001d\rq\u00121H\u0005\u00025&\u0011A&W\u0005\u0005\u0003\u0003\n\u0019EA\u0002TKFT!\u0001L-\u0011\t\u0005\u001d\u0013\u0011J\u0007\u0002[%\u0019\u00111J\u0017\u0003\u0013\u0005#HO]5ckR,\u0007BB>\u00020\u0001\u0007a\t")
public class RowReadSupport
extends ReadSupport<Row>
implements Logging {
    private transient Logger org$apache$spark$Logging$$log_;

    public static String SPARK_METADATA_KEY() {
        return RowReadSupport$.MODULE$.SPARK_METADATA_KEY();
    }

    public static String SPARK_ROW_REQUESTED_SCHEMA() {
        return RowReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public RecordMaterializer<Row> prepareForRead(Configuration conf, Map<String, String> stringMap, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        this.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"preparing for read with Parquet file schema ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileSchema})));
        MessageType parquetSchema = readContext.getRequestedSchema();
        Seq<Attribute> schema = null;
        if (readContext.getReadSupportMetadata() != null) {
            if (readContext.getReadSupportMetadata().get(RowReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA()) == null) {
                if (readContext.getReadSupportMetadata().get(RowReadSupport$.MODULE$.SPARK_METADATA_KEY()) != null) {
                    schema = ParquetTypesConverter$.MODULE$.convertFromString((String)readContext.getReadSupportMetadata().get(RowReadSupport$.MODULE$.SPARK_METADATA_KEY()));
                }
            } else {
                schema = ParquetTypesConverter$.MODULE$.convertFromString((String)readContext.getReadSupportMetadata().get(RowReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA()));
            }
        }
        if (schema == null) {
            this.log().debug("falling back to Parquet read schema");
            schema = ParquetTypesConverter$.MODULE$.convertToAttributes((Type)parquetSchema, false, true);
        }
        this.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list of attributes that will be read: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{schema})));
        return new RowRecordMaterializer(parquetSchema, schema);
    }

    public ReadSupport.ReadContext init(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema) {
        Object object;
        MessageType parquetSchema = fileSchema;
        HashMap<String, String> metadata = new HashMap<String, String>();
        Seq<Attribute> requestedAttributes = RowReadSupport$.MODULE$.org$apache$spark$sql$parquet$RowReadSupport$$getRequestedSchema(configuration);
        if (requestedAttributes == null) {
            object = BoxedUnit.UNIT;
        } else {
            boolean isThriftDerived = keyValueMetaData.keySet().contains("thrift.class");
            parquetSchema = ParquetTypesConverter$.MODULE$.convertFromAttributes(requestedAttributes, isThriftDerived);
            object = metadata.put(RowReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), ParquetTypesConverter$.MODULE$.convertToString(requestedAttributes));
        }
        String origAttributesStr = configuration.get(RowWriteSupport$.MODULE$.SPARK_ROW_SCHEMA());
        Object object2 = origAttributesStr == null ? BoxedUnit.UNIT : metadata.put(RowReadSupport$.MODULE$.SPARK_METADATA_KEY(), origAttributesStr);
        return new ReadSupport.ReadContext(parquetSchema, metadata);
    }

    public RowReadSupport() {
        Logging.class.$init$((Logging)this);
    }
}

