/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.graph;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.pipelines.graph.DataflowGraph;
import org.apache.spark.sql.pipelines.graph.Flow;
import org.apache.spark.sql.pipelines.graph.FlowFunction;
import org.apache.spark.sql.pipelines.graph.GraphRegistrationContext$TableType$;
import org.apache.spark.sql.pipelines.graph.GraphRegistrationContext$ViewType$;
import org.apache.spark.sql.pipelines.graph.PersistedView;
import org.apache.spark.sql.pipelines.graph.QueryContext;
import org.apache.spark.sql.pipelines.graph.QueryOrigin;
import org.apache.spark.sql.pipelines.graph.Table;
import org.apache.spark.sql.pipelines.graph.UnresolvedFlow;
import org.apache.spark.sql.pipelines.graph.View;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001de\u0001\u0002\u0012$\u0001AB\u0001b\u000e\u0001\u0003\u0006\u0004%\t\u0001\u000f\u0005\t\t\u0002\u0011\t\u0011)A\u0005s!AQ\t\u0001BC\u0002\u0013\u0005\u0001\b\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003:\u0011!9\u0005A!b\u0001\n\u0003A\u0005\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u000b5\u0003A\u0011\u0001(\t\u000fQ\u0003!\u0019!C\t+\"1\u0011\r\u0001Q\u0001\nYCqA\u0019\u0001C\u0002\u0013E1\r\u0003\u0004i\u0001\u0001\u0006I\u0001\u001a\u0005\bS\u0002\u0011\r\u0011\"\u0005k\u0011\u0019y\u0007\u0001)A\u0005W\")\u0001\u000f\u0001C\u0001c\")q\u000f\u0001C\u0001q\")1\u0010\u0001C\u0001y\"9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0001bBA\u000b\u0001\u0011\u0005\u0011q\u0003\u0005\b\u0003?\u0001A\u0011BA\u0011\u0011\u001d\t\u0019\u0004\u0001C\u0005\u0003kAq!a\u0013\u0001\t\u0013\tieB\u0004\u0002\\\rB\t!!\u0018\u0007\r\t\u001a\u0003\u0012AA0\u0011\u0019iu\u0003\"\u0001\u0002b\u0019I\u00111M\f\u0011\u0002G\u0005\u0012QM\u0004\b\u0003\u0003;\u0002\u0012BA:\r\u001d\tIg\u0006E\u0005\u0003WBa!T\u000e\u0005\u0002\u0005E\u0004bBA;7\u0011\u0005\u0013qO\u0004\b\u0003\u0007;\u0002\u0012BA@\r\u001d\tIh\u0006E\u0005\u0003wBa!T\u0010\u0005\u0002\u0005u\u0004bBA;?\u0011\u0005\u0013q\u000f\u0002\u0019\u000fJ\f\u0007\u000f\u001b*fO&\u001cHO]1uS>t7i\u001c8uKb$(B\u0001\u0013&\u0003\u00159'/\u00199i\u0015\t1s%A\u0005qSB,G.\u001b8fg*\u0011\u0001&K\u0001\u0004gFd'B\u0001\u0016,\u0003\u0015\u0019\b/\u0019:l\u0015\taS&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002]\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\r\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0007\u0003:L(+\u001a4\u0002\u001d\u0011,g-Y;mi\u000e\u000bG/\u00197pOV\t\u0011\b\u0005\u0002;\u0003:\u00111h\u0010\t\u0003yMj\u0011!\u0010\u0006\u0003}=\na\u0001\u0010:p_Rt\u0014B\u0001!4\u0003\u0019\u0001&/\u001a3fM&\u0011!i\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001\u001b\u0014a\u00043fM\u0006,H\u000e^\"bi\u0006dwn\u001a\u0011\u0002\u001f\u0011,g-Y;mi\u0012\u000bG/\u00192bg\u0016\f\u0001\u0003Z3gCVdG\u000fR1uC\n\f7/\u001a\u0011\u0002\u001d\u0011,g-Y;miN\u000bHnQ8oMV\t\u0011\n\u0005\u0003;\u0015fJ\u0014BA&D\u0005\ri\u0015\r]\u0001\u0010I\u00164\u0017-\u001e7u'Fd7i\u001c8gA\u00051A(\u001b8jiz\"BaT)S'B\u0011\u0001\u000bA\u0007\u0002G!)qg\u0002a\u0001s!)Qi\u0002a\u0001s!)qi\u0002a\u0001\u0013\u00061A/\u00192mKN,\u0012A\u0016\t\u0004/rsV\"\u0001-\u000b\u0005eS\u0016aB7vi\u0006\u0014G.\u001a\u0006\u00037N\n!bY8mY\u0016\u001cG/[8o\u0013\ti\u0006L\u0001\u0006MSN$()\u001e4gKJ\u0004\"\u0001U0\n\u0005\u0001\u001c#!\u0002+bE2,\u0017a\u0002;bE2,7\u000fI\u0001\u0006m&,wo]\u000b\u0002IB\u0019q\u000bX3\u0011\u0005A3\u0017BA4$\u0005\u00111\u0016.Z<\u0002\rYLWm^:!\u0003\u00151Gn\\<t+\u0005Y\u0007cA,]YB\u0011\u0001+\\\u0005\u0003]\u000e\u0012a\"\u00168sKN|GN^3e\r2|w/\u0001\u0004gY><8\u000fI\u0001\u000ee\u0016<\u0017n\u001d;feR\u000b'\r\\3\u0015\u0005I,\bC\u0001\u001at\u0013\t!8G\u0001\u0003V]&$\b\"\u0002<\u000f\u0001\u0004q\u0016\u0001\u0003;bE2,G)\u001a4\u0002\u0019I,w-[:uKJ4\u0016.Z<\u0015\u0005IL\b\"\u0002>\u0010\u0001\u0004)\u0017a\u0002<jK^$UMZ\u0001\tO\u0016$h+[3xgR\tQ\u0010\u0005\u0003\u007f\u0003\u000f)gbA@\u0002\u00049\u0019A(!\u0001\n\u0003QJ1!!\u00024\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0003\u0002\f\t\u00191+Z9\u000b\u0007\u0005\u00151'\u0001\u0007sK\u001eL7\u000f^3s\r2|w\u000fF\u0002s\u0003#Aa!a\u0005\u0012\u0001\u0004a\u0017a\u00024m_^$UMZ\u0001\u0010i>$\u0015\r^1gY><xI]1qQV\u0011\u0011\u0011\u0004\t\u0004!\u0006m\u0011bAA\u000fG\tiA)\u0019;bM2|wo\u0012:ba\"\f!#Y:tKJ$hj\u001c#va2L7-\u0019;fgR9!/a\t\u0002*\u00055\u0002bBA\u0013'\u0001\u0007\u0011qE\u0001\u0010cV\fG.\u001b4jK\u0012$\u0016M\u00197fgB!a0a\u0002_\u0011\u0019\tYc\u0005a\u0001{\u0006qa/\u00197jI\u0006$X\r\u001a,jK^\u001c\bbBA\u0018'\u0001\u0007\u0011\u0011G\u0001\u000fcV\fG.\u001b4jK\u00124En\\<t!\u0011q\u0018q\u00017\u0002?\u0005\u001c8/\u001a:u\t\u0006$\u0018m]3u\u0013\u0012,g\u000e^5gS\u0016\u0014\u0018j]+oSF,X\rF\u0004s\u0003o\t9%!\u0013\t\u000f\u0005eB\u00031\u0001\u0002<\u0005Q\u0011\u000eZ3oi&4\u0017.\u001a:\u0011\t\u0005u\u00121I\u0007\u0003\u0003\u007fQ1!!\u0011(\u0003!\u0019\u0017\r^1msN$\u0018\u0002BA#\u0003\u007f\u0011q\u0002V1cY\u0016LE-\u001a8uS\u001aLWM\u001d\u0005\u0007)R\u0001\r!a\n\t\u000b\t$\u0002\u0019A?\u00029\u0005\u001c8/\u001a:u\r2|w/\u00133f]RLg-[3s\u0013N,f.[9vKR9!/a\u0014\u0002T\u0005\u0015\u0005BBA)+\u0001\u0007A.\u0001\u0003gY><\bbBA++\u0001\u0007\u0011qK\u0001\fI\u0006$\u0018m]3u)f\u0004X\rE\u0002\u0002Zeq!\u0001\u0015\f\u00021\u001d\u0013\u0018\r\u001d5SK\u001eL7\u000f\u001e:bi&|gnQ8oi\u0016DH\u000f\u0005\u0002Q/M\u0011q#\r\u000b\u0003\u0003;\u00121\u0002R1uCN,G\u000fV=qKN\u0011\u0011$M\u0015\u00043my\"!\u0003+bE2,G+\u001f9f'\u0011Y\u0012'!\u001c\u0011\u0007\u0005=\u0014$D\u0001\u0018)\t\t\u0019\bE\u0002\u0002pm\t\u0001\u0002^8TiJLgn\u001a\u000b\u0002s\tAa+[3x)f\u0004Xm\u0005\u0003 c\u00055DCAA@!\r\tygH\u0001\n)\u0006\u0014G.\u001a+za\u0016\f\u0001BV5foRK\b/\u001a\u0005\u0007SV\u0001\r!!\r")
public class GraphRegistrationContext {
    private final String defaultCatalog;
    private final String defaultDatabase;
    private final Map<String, String> defaultSqlConf;
    private final ListBuffer<Table> tables;
    private final ListBuffer<View> views;
    private final ListBuffer<UnresolvedFlow> flows;

    public String defaultCatalog() {
        return this.defaultCatalog;
    }

    public String defaultDatabase() {
        return this.defaultDatabase;
    }

    public Map<String, String> defaultSqlConf() {
        return this.defaultSqlConf;
    }

    public ListBuffer<Table> tables() {
        return this.tables;
    }

    public ListBuffer<View> views() {
        return this.views;
    }

    public ListBuffer<UnresolvedFlow> flows() {
        return this.flows;
    }

    public void registerTable(Table tableDef) {
        this.tables().$plus$eq((Object)tableDef);
    }

    public void registerView(View viewDef) {
        this.views().$plus$eq((Object)viewDef);
    }

    public Seq<View> getViews() {
        return this.views().toSeq();
    }

    public void registerFlow(UnresolvedFlow flowDef) {
        Map x$1 = (Map)this.defaultSqlConf().$plus$plus(flowDef.sqlConf());
        TableIdentifier x$2 = flowDef.copy$default$1();
        TableIdentifier x$3 = flowDef.copy$default$2();
        FlowFunction x$4 = flowDef.copy$default$3();
        QueryContext x$5 = flowDef.copy$default$4();
        boolean x$6 = flowDef.copy$default$6();
        QueryOrigin x$7 = flowDef.copy$default$7();
        this.flows().$plus$eq((Object)flowDef.copy(x$2, x$3, x$4, x$5, (Map<String, String>)x$1, x$6, x$7));
    }

    public DataflowGraph toDataflowGraph() {
        if (this.tables().isEmpty() && ((ListBuffer)this.views().collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends View, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof PersistedView) {
                    PersistedView persistedView = (PersistedView)A1;
                    return (B1)persistedView;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(View x1) {
                View view = x1;
                return view instanceof PersistedView;
            }
        })).isEmpty()) {
            throw new AnalysisException("RUN_EMPTY_PIPELINE", Predef$.MODULE$.Map().empty());
        }
        this.assertNoDuplicates((Seq<Table>)this.tables().toSeq(), (Seq<View>)this.views().toSeq(), (Seq<UnresolvedFlow>)this.flows().toSeq());
        Seq x$1 = this.tables().toSeq();
        Seq x$2 = this.views().toSeq();
        Seq x$3 = this.flows().toSeq();
        return new DataflowGraph((Seq<Flow>)x$3, (Seq<Table>)x$1, (Seq<View>)x$2);
    }

    private void assertNoDuplicates(Seq<Table> qualifiedTables, Seq<View> validatedViews, Seq<UnresolvedFlow> qualifiedFlows) {
        ((IterableOnceOps)((IterableOps)qualifiedTables.map((Function1 & Serializable)x$1 -> x$1.identifier())).$plus$plus((IterableOnce)validatedViews.map((Function1 & Serializable)x$2 -> x$2.identifier()))).foreach((Function1 & Serializable)identifier -> {
            this.assertDatasetIdentifierIsUnique(identifier, (Seq<Table>)qualifiedTables, (Seq<View>)validatedViews);
            return BoxedUnit.UNIT;
        });
        qualifiedFlows.foreach((Function1 & Serializable)flow -> {
            this.assertFlowIdentifierIsUnique(flow, GraphRegistrationContext$TableType$.MODULE$, (Seq<UnresolvedFlow>)qualifiedFlows);
            return BoxedUnit.UNIT;
        });
    }

    private void assertDatasetIdentifierIsUnique(TableIdentifier identifier, Seq<Table> tables, Seq<View> views) {
        Seq allDatasets = (Seq)((IterableOps)tables.map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t.identifier()), (Object)GraphRegistrationContext$TableType$.MODULE$))).$plus$plus((IterableOnce)views.map((Function1 & Serializable)v -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)v.identifier()), (Object)GraphRegistrationContext$ViewType$.MODULE$)));
        Map grouped = allDatasets.groupBy((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TableIdentifier id = (TableIdentifier)tuple2._1();
                return id;
            }
            throw new MatchError((Object)tuple2);
        });
        List list = ((IterableOnceOps)grouped.apply((Object)identifier)).toList();
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            Tuple2 tuple2 = (Tuple2)colon2.head();
            List list2 = colon2.next$access$1();
            if (tuple2 != null) {
                .colon.colon colon3;
                Tuple2 tuple22;
                DatasetType firstType = (DatasetType)tuple2._2();
                if (list2 instanceof .colon.colon && (tuple22 = (Tuple2)(colon3 = (.colon.colon)list2).head()) != null) {
                    DatasetType secondType = (DatasetType)tuple22._2();
                    Seq sortedTypes = (Seq)new .colon.colon((Object)firstType.toString(), (List)new .colon.colon((Object)secondType.toString(), (List)Nil$.MODULE$)).sorted((Ordering)Ordering.String$.MODULE$);
                    throw new AnalysisException("PIPELINE_DUPLICATE_IDENTIFIERS.DATASET", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datasetName"), (Object)identifier.quotedString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datasetType1"), sortedTypes.head()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datasetType2"), sortedTypes.last())})));
                }
            }
        }
    }

    private void assertFlowIdentifierIsUnique(UnresolvedFlow flow, DatasetType datasetType, Seq<UnresolvedFlow> flows) {
        flows.groupBy((Function1 & Serializable)i -> i.identifier()).get((Object)flow.identifier()).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)GraphRegistrationContext.$anonfun$assertFlowIdentifierIsUnique$2(x$3))).foreach((Function1 & Serializable)duplicateFlows -> {
            UnresolvedFlow duplicateFlow = (UnresolvedFlow)((IterableOps)duplicateFlows.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)GraphRegistrationContext.$anonfun$assertFlowIdentifierIsUnique$4(flow, x$4)))).head();
            throw new AnalysisException("PIPELINE_DUPLICATE_IDENTIFIERS.FLOW", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flowName"), (Object)flow.identifier().unquotedString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datasetNames"), (Object)((IterableOnceOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{flow.destinationIdentifier().quotedString(), duplicateFlow.destinationIdentifier().quotedString()}))).mkString(","))})));
        });
    }

    public static final /* synthetic */ boolean $anonfun$assertFlowIdentifierIsUnique$2(Seq x$3) {
        return x$3.size() > 1;
    }

    public static final /* synthetic */ boolean $anonfun$assertFlowIdentifierIsUnique$4(UnresolvedFlow flow$1, UnresolvedFlow x$4) {
        UnresolvedFlow unresolvedFlow = x$4;
        UnresolvedFlow unresolvedFlow2 = flow$1;
        return unresolvedFlow == null ? unresolvedFlow2 != null : !((Object)unresolvedFlow).equals(unresolvedFlow2);
    }

    public GraphRegistrationContext(String defaultCatalog, String defaultDatabase, Map<String, String> defaultSqlConf) {
        this.defaultCatalog = defaultCatalog;
        this.defaultDatabase = defaultDatabase;
        this.defaultSqlConf = defaultSqlConf;
        this.tables = new ListBuffer();
        this.views = new ListBuffer();
        this.flows = new ListBuffer();
    }

    public static interface DatasetType {
    }
}

