/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import org.apache.spark.mllib.optimization.GradientDescent;
import org.apache.spark.mllib.optimization.SquaredGradient;
import org.apache.spark.mllib.optimization.SquaredL2Updater;
import org.apache.spark.mllib.regression.GeneralizedLinearAlgorithm;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.RidgeRegressionModel;
import org.apache.spark.mllib.regression.RidgeRegressionWithSGD$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.jblas.DoubleMatrix;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.reflect.ClassManifest;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005-g\u0001B\u0001\u0003\u00015\u0011aCU5eO\u0016\u0014Vm\u001a:fgNLwN\\,ji\"\u001cv\t\u0012\u0006\u0003\u0007\u0011\t!B]3he\u0016\u001c8/[8o\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\b\u00167A\u0019q\u0002\u0005\n\u000e\u0003\tI!!\u0005\u0002\u00035\u001d+g.\u001a:bY&TX\r\u001a'j]\u0016\f'/\u00117h_JLG\u000f[7\u0011\u0005=\u0019\u0012B\u0001\u000b\u0003\u0005Q\u0011\u0016\u000eZ4f%\u0016<'/Z:tS>tWj\u001c3fYB\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\ta1+\u001a:jC2L'0\u00192mKB\u0011a\u0003H\u0005\u0003;]\u00111bU2bY\u0006|%M[3di\"Aq\u0004\u0001BA\u0002\u0013\u0005\u0001%\u0001\u0005ti\u0016\u00048+\u001b>f+\u0005\t\u0003C\u0001\f#\u0013\t\u0019sC\u0001\u0004E_V\u0014G.\u001a\u0005\tK\u0001\u0011\t\u0019!C\u0001M\u0005a1\u000f^3q'&TXm\u0018\u0013fcR\u0011qE\u000b\t\u0003-!J!!K\f\u0003\tUs\u0017\u000e\u001e\u0005\bW\u0011\n\t\u00111\u0001\"\u0003\rAH%\r\u0005\t[\u0001\u0011\t\u0011)Q\u0005C\u0005I1\u000f^3q'&TX\r\t\u0005\t_\u0001\u0011\t\u0019!C\u0001a\u0005ia.^7Ji\u0016\u0014\u0018\r^5p]N,\u0012!\r\t\u0003-IJ!aM\f\u0003\u0007%sG\u000f\u0003\u00056\u0001\t\u0005\r\u0011\"\u00017\u0003EqW/\\%uKJ\fG/[8og~#S-\u001d\u000b\u0003O]Bqa\u000b\u001b\u0002\u0002\u0003\u0007\u0011\u0007\u0003\u0005:\u0001\t\u0005\t\u0015)\u00032\u00039qW/\\%uKJ\fG/[8og\u0002B\u0001b\u000f\u0001\u0003\u0002\u0004%\t\u0001I\u0001\te\u0016<\u0007+\u0019:b[\"AQ\b\u0001BA\u0002\u0013\u0005a(\u0001\u0007sK\u001e\u0004\u0016M]1n?\u0012*\u0017\u000f\u0006\u0002(\u007f!91\u0006PA\u0001\u0002\u0004\t\u0003\u0002C!\u0001\u0005\u0003\u0005\u000b\u0015B\u0011\u0002\u0013I,w\rU1sC6\u0004\u0003\u0002C\"\u0001\u0005\u0003\u0007I\u0011\u0001\u0011\u0002#5Lg.\u001b\"bi\u000eDgI]1di&|g\u000e\u0003\u0005F\u0001\t\u0005\r\u0011\"\u0001G\u0003Ui\u0017N\\5CCR\u001c\u0007N\u0012:bGRLwN\\0%KF$\"aJ$\t\u000f-\"\u0015\u0011!a\u0001C!A\u0011\n\u0001B\u0001B\u0003&\u0011%\u0001\nnS:L')\u0019;dQ\u001a\u0013\u0018m\u0019;j_:\u0004\u0003\"B&\u0001\t\u0013a\u0015A\u0002\u001fj]&$h\bF\u0003N\u001d>\u0003\u0016\u000b\u0005\u0002\u0010\u0001!)qD\u0013a\u0001C!)qF\u0013a\u0001c!)1H\u0013a\u0001C!)1I\u0013a\u0001C!91\u000b\u0001b\u0001\n\u0003!\u0016\u0001C4sC\u0012LWM\u001c;\u0016\u0003U\u0003\"AV-\u000e\u0003]S!\u0001\u0017\u0003\u0002\u0019=\u0004H/[7ju\u0006$\u0018n\u001c8\n\u0005i;&aD*rk\u0006\u0014X\rZ$sC\u0012LWM\u001c;\t\rq\u0003\u0001\u0015!\u0003V\u0003%9'/\u00193jK:$\b\u0005C\u0004_\u0001\t\u0007I\u0011A0\u0002\u000fU\u0004H-\u0019;feV\t\u0001\r\u0005\u0002WC&\u0011!m\u0016\u0002\u0011'F,\u0018M]3e\u0019J*\u0006\u000fZ1uKJDa\u0001\u001a\u0001!\u0002\u0013\u0001\u0017\u0001C;qI\u0006$XM\u001d\u0011\t\u000f\u0019\u0004!\u0019!C\u0001O\u0006Iq\u000e\u001d;j[&TXM]\u000b\u0002QB\u0011a+[\u0005\u0003U^\u0013qb\u0012:bI&,g\u000e\u001e#fg\u000e,g\u000e\u001e\u0005\u0007Y\u0002\u0001\u000b\u0011\u00025\u0002\u0015=\u0004H/[7ju\u0016\u0014\b\u0005\u000b\u0002l]B\u0011ac\\\u0005\u0003a^\u0011\u0011\u0002\u001e:b]NLWM\u001c;\t\u000fI\u0004\u0001\u0019!C\u0001A\u0005)\u00110T3b]\"9A\u000f\u0001a\u0001\n\u0003)\u0018!C=NK\u0006tw\fJ3r)\t9c\u000fC\u0004,g\u0006\u0005\t\u0019A\u0011\t\ra\u0004\u0001\u0015)\u0003\"\u0003\u0019IX*Z1oA!9!\u0010\u0001a\u0001\n\u0003Y\u0018\u0001\u0003=D_2lU-\u00198\u0016\u0003q\u00042!`A\u0001\u001b\u0005q(BA@\u000b\u0003\u0015Q'\r\\1t\u0013\r\t\u0019A \u0002\r\t>,(\r\\3NCR\u0014\u0018\u000e\u001f\u0005\n\u0003\u000f\u0001\u0001\u0019!C\u0001\u0003\u0013\tA\u0002_\"pY6+\u0017M\\0%KF$2aJA\u0006\u0011!Y\u0013QAA\u0001\u0002\u0004a\bbBA\b\u0001\u0001\u0006K\u0001`\u0001\nq\u000e{G.T3b]\u0002B\u0001\"a\u0005\u0001\u0001\u0004%\ta_\u0001\u0007q\u000e{Gn\u00153\t\u0013\u0005]\u0001\u00011A\u0005\u0002\u0005e\u0011A\u0003=D_2\u001cFm\u0018\u0013fcR\u0019q%a\u0007\t\u0011-\n)\"!AA\u0002qDq!a\b\u0001A\u0003&A0A\u0004y\u0007>d7\u000b\u001a\u0011\t\r-\u0003A\u0011AA\u0012)\u0005i\u0005bBA\u0014\u0001\u0011\u0005\u0011\u0011F\u0001\fGJ,\u0017\r^3N_\u0012,G\u000eF\u0003\u0013\u0003W\t)\u0004\u0003\u0005\u0002.\u0005\u0015\u0002\u0019AA\u0018\u0003\u001d9X-[4iiN\u0004BAFA\u0019C%\u0019\u00111G\f\u0003\u000b\u0005\u0013(/Y=\t\u000f\u0005]\u0012Q\u0005a\u0001C\u0005I\u0011N\u001c;fe\u000e,\u0007\u000f\u001e\u0005\b\u0003w\u0001A\u0011IA\u001f\u0003\r\u0011XO\u001c\u000b\u0006%\u0005}\u0012Q\u000b\u0005\t\u0003\u0003\nI\u00041\u0001\u0002D\u0005)\u0011N\u001c9viB1\u0011QIA&\u0003\u001fj!!a\u0012\u000b\u0007\u0005%c!A\u0002sI\u0012LA!!\u0014\u0002H\t\u0019!\u000b\u0012#\u0011\u0007=\t\t&C\u0002\u0002T\t\u0011A\u0002T1cK2,G\rU8j]RD\u0001\"a\u0016\u0002:\u0001\u0007\u0011qF\u0001\u000fS:LG/[1m/\u0016Lw\r\u001b;t\u000f\u001d\tYF\u0001E\u0003\u0003;\naCU5eO\u0016\u0014Vm\u001a:fgNLwN\\,ji\"\u001cv\t\u0012\t\u0004\u001f\u0005}cAB\u0001\u0003\u0011\u000b\t\tg\u0005\u0004\u0002`\u0005\r4$\u0006\t\u0005\u0003K\ny'\u0004\u0002\u0002h)!\u0011\u0011NA6\u0003\u0011a\u0017M\\4\u000b\u0005\u00055\u0014\u0001\u00026bm\u0006LA!!\u001d\u0002h\t1qJ\u00196fGRDqaSA0\t\u0003\t)\b\u0006\u0002\u0002^!A\u0011\u0011PA0\t\u0003\tY(A\u0003ue\u0006Lg\u000eF\u0007\u0013\u0003{\ny(!!\u0002\u0004\u0006\u0015\u0015q\u0011\u0005\t\u0003\u0003\n9\b1\u0001\u0002D!1q&a\u001eA\u0002EBaaHA<\u0001\u0004\t\u0003BB\u001e\u0002x\u0001\u0007\u0011\u0005\u0003\u0004D\u0003o\u0002\r!\t\u0005\t\u0003/\n9\b1\u0001\u00020!A\u0011\u0011PA0\t\u0003\tY\tF\u0006\u0013\u0003\u001b\u000by)!%\u0002\u0014\u0006U\u0005\u0002CA!\u0003\u0013\u0003\r!a\u0011\t\r=\nI\t1\u00012\u0011\u0019y\u0012\u0011\u0012a\u0001C!11(!#A\u0002\u0005BaaQAE\u0001\u0004\t\u0003\u0002CA=\u0003?\"\t!!'\u0015\u0013I\tY*!(\u0002 \u0006\u0005\u0006\u0002CA!\u0003/\u0003\r!a\u0011\t\r=\n9\n1\u00012\u0011\u0019y\u0012q\u0013a\u0001C!11(a&A\u0002\u0005B\u0001\"!\u001f\u0002`\u0011\u0005\u0011Q\u0015\u000b\u0006%\u0005\u001d\u0016\u0011\u0016\u0005\t\u0003\u0003\n\u0019\u000b1\u0001\u0002D!1q&a)A\u0002EB\u0001\"!,\u0002`\u0011\u0005\u0011qV\u0001\u0005[\u0006Lg\u000eF\u0002(\u0003cC\u0001\"a-\u0002,\u0002\u0007\u0011QW\u0001\u0005CJ<7\u000fE\u0003\u0017\u0003c\t9\f\u0005\u0003\u0002:\u0006}fb\u0001\f\u0002<&\u0019\u0011QX\f\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t-a1\u0003\rM#(/\u001b8h\u0015\r\til\u0006\u0005\t\u0003\u000f\fy\u0006\"\u0005\u0002J\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t\u0019\u0007")
public class RidgeRegressionWithSGD
extends GeneralizedLinearAlgorithm<RidgeRegressionModel>
implements Serializable,
ScalaObject {
    private double stepSize;
    private int numIterations;
    private double regParam;
    private double miniBatchFraction;
    private final SquaredGradient gradient;
    private final SquaredL2Updater updater;
    private final transient GradientDescent optimizer;
    private double yMean;
    private DoubleMatrix xColMean;
    private DoubleMatrix xColSd;

    public static final void main(String[] stringArray) {
        RidgeRegressionWithSGD$.MODULE$.main(stringArray);
    }

    public static final RidgeRegressionModel train(RDD<LabeledPoint> rDD, int n) {
        return RidgeRegressionWithSGD$.MODULE$.train(rDD, n);
    }

    public static final RidgeRegressionModel train(RDD<LabeledPoint> rDD, int n, double d, double d2) {
        return RidgeRegressionWithSGD$.MODULE$.train(rDD, n, d, d2);
    }

    public static final RidgeRegressionModel train(RDD<LabeledPoint> rDD, int n, double d, double d2, double d3) {
        return RidgeRegressionWithSGD$.MODULE$.train(rDD, n, d, d2, d3);
    }

    public static final RidgeRegressionModel train(RDD<LabeledPoint> rDD, int n, double d, double d2, double d3, double[] dArray) {
        return RidgeRegressionWithSGD$.MODULE$.train(rDD, n, d, d2, d3, dArray);
    }

    public double stepSize() {
        return this.stepSize;
    }

    public void stepSize_$eq(double d) {
        this.stepSize = d;
    }

    public int numIterations() {
        return this.numIterations;
    }

    public void numIterations_$eq(int n) {
        this.numIterations = n;
    }

    public double regParam() {
        return this.regParam;
    }

    public void regParam_$eq(double d) {
        this.regParam = d;
    }

    public double miniBatchFraction() {
        return this.miniBatchFraction;
    }

    public void miniBatchFraction_$eq(double d) {
        this.miniBatchFraction = d;
    }

    public SquaredGradient gradient() {
        return this.gradient;
    }

    public SquaredL2Updater updater() {
        return this.updater;
    }

    @Override
    public GradientDescent optimizer() {
        return this.optimizer;
    }

    public double yMean() {
        return this.yMean;
    }

    public void yMean_$eq(double d) {
        this.yMean = d;
    }

    public DoubleMatrix xColMean() {
        return this.xColMean;
    }

    public void xColMean_$eq(DoubleMatrix doubleMatrix) {
        this.xColMean = doubleMatrix;
    }

    public DoubleMatrix xColSd() {
        return this.xColSd;
    }

    public void xColSd_$eq(DoubleMatrix doubleMatrix) {
        this.xColSd = doubleMatrix;
    }

    @Override
    public RidgeRegressionModel createModel(double[] weights, double intercept) {
        DoubleMatrix weightsMat = new DoubleMatrix(weights.length + 1, 1, (double[])Predef$.MODULE$.doubleArrayOps(Array$.MODULE$.apply(intercept, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.doubleArrayOps(weights), Array$.MODULE$.canBuildFrom((ClassManifest)Manifest$.MODULE$.Double())));
        DoubleMatrix weightsScaled = weightsMat.div(this.xColSd());
        double interceptScaled = this.yMean() - weightsMat.transpose().mmul(this.xColMean().div(this.xColSd())).get(0);
        return new RidgeRegressionModel(weightsScaled.data, interceptScaled);
    }

    @Override
    public RidgeRegressionModel run(RDD<LabeledPoint> input, double[] initialWeights) {
        int nfeatures$1 = ((LabeledPoint)input.first()).features().length;
        long nexamples = input.count();
        Tuple3<Object, DoubleMatrix, DoubleMatrix> stats = MLUtils$.MODULE$.computeStats(input, nfeatures$1, nexamples);
        this.yMean_$eq(BoxesRunTime.unboxToDouble((Object)stats._1()));
        this.xColMean_$eq((DoubleMatrix)stats._2());
        this.xColSd_$eq((DoubleMatrix)stats._3());
        RDD normalizedData = input.map((Function1)new Serializable(this, nfeatures$1){
            public static final long serialVersionUID;
            private final RidgeRegressionWithSGD $outer;
            private final int nfeatures$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final LabeledPoint apply(LabeledPoint point) {
                double yNormalized = point.label() - this.$outer.yMean();
                DoubleMatrix featuresMat = new DoubleMatrix(this.nfeatures$1, 1, point.features());
                DoubleMatrix featuresNormalized = featuresMat.sub(this.$outer.xColMean()).divi(this.$outer.xColSd());
                return new LabeledPoint(yNormalized, featuresNormalized.toArray());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.nfeatures$1 = n;
            }
        }, ClassManifest$.MODULE$.classType(LabeledPoint.class));
        return (RidgeRegressionModel)super.run((RDD<LabeledPoint>)normalizedData, initialWeights);
    }

    public RidgeRegressionWithSGD(double stepSize, int numIterations, double regParam, double miniBatchFraction) {
        this.stepSize = stepSize;
        this.numIterations = numIterations;
        this.regParam = regParam;
        this.miniBatchFraction = miniBatchFraction;
        this.gradient = new SquaredGradient();
        this.updater = new SquaredL2Updater();
        this.optimizer = new GradientDescent(this.gradient(), this.updater()).setStepSize(this.stepSize()).setNumIterations(this.numIterations()).setRegParam(this.regParam()).setMiniBatchFraction(this.miniBatchFraction());
        this.setIntercept(false);
        this.yMean = 0.0;
    }

    public RidgeRegressionWithSGD() {
        this(1.0, 100, 1.0, 1.0);
    }
}

