/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.util;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.LogisticRegressionDataGenerator$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ClassManifest;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogisticRegressionDataGenerator$
implements ScalaObject {
    public static final LogisticRegressionDataGenerator$ MODULE$;

    static {
        new LogisticRegressionDataGenerator$();
    }

    public RDD<LabeledPoint> generateLogisticRDD(SparkContext sc, int nexamples, int nfeatures$1, double eps$1, int nparts, double probOne) {
        RDD data = sc.parallelize((Seq)Predef$.MODULE$.intWrapper(0).until(nexamples), nparts, (ClassManifest)Manifest$.MODULE$.Int()).map((Function1)new Serializable(nfeatures$1, eps$1){
            public static final long serialVersionUID;
            public final int nfeatures$1;
            public final double eps$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final LabeledPoint apply(int idx) {
                Random rnd$1 = new Random(42 + idx);
                double y$1 = idx % 2 == 0 ? 0.0 : 1.0;
                double[] x = (double[])Array$.MODULE$.fill(this.nfeatures$1, (Function0)new Serializable(this, rnd$1, y$1){
                    public static final long serialVersionUID;
                    public final anonfun.2 $outer;
                    public final Random rnd$1;
                    public final double y$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return this.rnd$1.nextGaussian() + this.y$1 * this.$outer.eps$1;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.rnd$1 = random;
                        this.y$1 = d;
                    }
                }, (ClassManifest)Manifest$.MODULE$.Double());
                return new LabeledPoint(y$1, x);
            }
            {
                this.nfeatures$1 = n;
                this.eps$1 = d;
            }
        }, ClassManifest$.MODULE$.classType(LabeledPoint.class));
        return data;
    }

    public double generateLogisticRDD$default$6() {
        return 0.5;
    }

    public int generateLogisticRDD$default$5() {
        return 2;
    }

    public void main(String[] args) {
        if (args.length != 5) {
            Predef$.MODULE$.println((Object)"Usage: LogisticRegressionGenerator <master> <output_dir> <num_examples> <num_features> <num_partitions>");
            System.exit(1);
        }
        String sparkMaster = args[0];
        String outputPath = args[1];
        int nexamples = args.length > 2 ? Predef$.MODULE$.augmentString(args[2]).toInt() : 1000;
        int nfeatures = args.length > 3 ? Predef$.MODULE$.augmentString(args[3]).toInt() : 2;
        int parts = args.length > 4 ? Predef$.MODULE$.augmentString(args[4]).toInt() : 2;
        SparkContext sc = new SparkContext(sparkMaster, "LogisticRegressionDataGenerator", SparkContext$.MODULE$.init$default$3(), SparkContext$.MODULE$.init$default$4(), SparkContext$.MODULE$.init$default$5(), SparkContext$.MODULE$.init$default$6());
        RDD<LabeledPoint> data = this.generateLogisticRDD(sc, nexamples, nfeatures, 3, parts, this.generateLogisticRDD$default$6());
        MLUtils$.MODULE$.saveLabeledData(data, outputPath);
        sc.stop();
    }

    private LogisticRegressionDataGenerator$() {
        MODULE$ = this;
    }
}

