/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.optimization;

import org.apache.spark.mllib.optimization.Gradient;
import org.jblas.DoubleMatrix;
import scala.ScalaObject;
import scala.Tuple2;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001E2A!\u0001\u0002\u0001\u001b\t\u0001Bj\\4jgRL7m\u0012:bI&,g\u000e\u001e\u0006\u0003\u0007\u0011\tAb\u001c9uS6L'0\u0019;j_:T!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dI\u0001\"a\u0004\t\u000e\u0003\tI!!\u0005\u0002\u0003\u0011\u001d\u0013\u0018\rZ5f]R\u0004\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u00111bU2bY\u0006|%M[3di\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u0003\u001f\u0001AQ!\b\u0001\u0005By\tqaY8naV$X\r\u0006\u0003 W5z\u0003\u0003B\n!E!J!!\t\u000b\u0003\rQ+\b\u000f\\33!\t\u0019c%D\u0001%\u0015\t)#\"A\u0003kE2\f7/\u0003\u0002(I\taAi\\;cY\u0016l\u0015\r\u001e:jqB\u00111#K\u0005\u0003UQ\u0011a\u0001R8vE2,\u0007\"\u0002\u0017\u001d\u0001\u0004\u0011\u0013\u0001\u00023bi\u0006DQA\f\u000fA\u0002!\nQ\u0001\\1cK2DQ\u0001\r\u000fA\u0002\t\nqa^3jO\"$8\u000f")
public class LogisticGradient
extends Gradient
implements ScalaObject {
    @Override
    public Tuple2<DoubleMatrix, Object> compute(DoubleMatrix data, double label, DoubleMatrix weights) {
        double margin = -1.0 * data.dot(weights);
        double gradientMultiplier = 1.0 / (1.0 + package$.MODULE$.exp(margin)) - label;
        DoubleMatrix gradient = data.mul(gradientMultiplier);
        double loss = margin > 0.0 ? package$.MODULE$.log(1.0 + package$.MODULE$.exp(0.0 - margin)) : package$.MODULE$.log(1.0 + package$.MODULE$.exp(margin)) - margin;
        return new Tuple2((Object)gradient, (Object)BoxesRunTime.boxToDouble((double)loss));
    }
}

