/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import org.apache.spark.SparkException;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.sql.types.DoubleType$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\t3Q\u0001C\u0005\u0001\u0017MA\u0001\"\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\u0006K\u0001!\tA\n\u0005\bU\u0001\u0011\r\u0011\"\u0001,\u0011\u0019a\u0003\u0001)A\u0005E!9Q\u0006\u0001b\u0001\n\u0013q\u0003BB\u0018\u0001A\u0003%q\u0004C\u00031\u0001\u0011\u0005\u0011G\u0001\bGK\u0006$XO]3F]\u000e|G-\u001a:\u000b\u0005)Y\u0011a\u00024fCR,(/\u001a\u0006\u0003\u00195\t!!\u001c7\u000b\u00059y\u0011!B:qCJ\\'B\u0001\t\u0012\u0003\u0019\t\u0007/Y2iK*\t!#A\u0002pe\u001e\u001c2\u0001\u0001\u000b\u001b!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u0019\te.\u001f*fMB\u0011QcG\u0005\u00039Y\u0011AbU3sS\u0006d\u0017N_1cY\u0016\f1B\\;n\r\u0016\fG/\u001e:fg\u000e\u0001\u0001cA\u000b!E%\u0011\u0011E\u0006\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003+\rJ!\u0001\n\f\u0003\u0007%sG/\u0001\u0004=S:LGO\u0010\u000b\u0003O%\u0002\"\u0001\u000b\u0001\u000e\u0003%AQ!\b\u0002A\u0002}\t!b\\;uaV$8+\u001b>f+\u0005\u0011\u0013aC8viB,HoU5{K\u0002\nQb\\;uaV$xJ\u001a4tKR\u001cX#A\u0010\u0002\u001d=,H\u000f];u\u001f\u001a47/\u001a;tA\u0005!bm\u001c:fC\u000eDgj\u001c8{KJ|w*\u001e;qkR$2AM\u001b;!\t)2'\u0003\u00025-\t!QK\\5u\u0011\u00151t\u00011\u00018\u0003\u00151\u0018\r\\;f!\t)\u0002(\u0003\u0002:-\t\u0019\u0011I\\=\t\u000bm:\u0001\u0019\u0001\u001f\u0002\u0003\u0019\u0004R!F\u001f#\u007fIJ!A\u0010\f\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004CA\u000bA\u0013\t\teC\u0001\u0004E_V\u0014G.\u001a")
public class FeatureEncoder
implements Serializable {
    private final int[] numFeatures;
    private final int outputSize;
    private final int[] outputOffsets;

    public int outputSize() {
        return this.outputSize;
    }

    private int[] outputOffsets() {
        return this.outputOffsets;
    }

    public void foreachNonzeroOutput(Object value, Function2<Object, Object, BoxedUnit> f) {
        Object object = value;
        if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            Predef$.MODULE$.assert(this.numFeatures.length == 1, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(41).append(DoubleType$.MODULE$.catalogString()).append(" columns should only contain one feature.").toString());
            int numOutputCols = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.numFeatures)).head());
            if (numOutputCols > 1) {
                Predef$.MODULE$.assert(d >= 0.0 && d == (double)((int)d) && d < (double)numOutputCols, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(45).append("Values from column must be indices, but got ").append(d).append(".").toString());
                f.apply$mcVID$sp((int)d, 1.0);
                return;
            }
            f.apply$mcVID$sp(0, d);
            return;
        }
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            Predef$.MODULE$.assert(this.numFeatures.length == vector.size(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(34).append("Vector column size was ").append(vector.size()).append(", expected ").append($this.numFeatures.length).toString());
            vector.foreachActive((Function2)(JFunction2.mcVID.sp & java.io.Serializable & Serializable)(i, v) -> {
                int numOutputCols = $this.numFeatures[i];
                if (numOutputCols > 1) {
                    Predef$.MODULE$.assert(v >= 0.0 && v == (double)((int)v) && v < (double)numOutputCols, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(45).append("Values from column must be indices, but got ").append(v).append(".").toString());
                    f.apply$mcVID$sp(this.outputOffsets()[i] + (int)v, 1.0);
                    return;
                }
                f.apply$mcVID$sp(this.outputOffsets()[i], v);
            });
            return;
        }
        if (object == null) {
            throw new SparkException("Values to interact cannot be null.");
        }
        throw new SparkException(new StringBuilder(27).append(object).append(" of type ").append(object.getClass().getName()).append(" is not supported.").toString());
    }

    /*
     * WARNING - void declaration
     */
    public FeatureEncoder(int[] numFeatures) {
        void var2_2;
        this.numFeatures = numFeatures;
        Predef$.MODULE$.assert(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(numFeatures)).forall((Function1)(JFunction1.mcZI.sp & java.io.Serializable & Serializable)x$1 -> x$1 > 0), (Function0 & java.io.Serializable & Serializable)() -> "Features counts must all be positive.");
        this.outputSize = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(numFeatures)).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int[] arr = new int[numFeatures.length];
        for (int i = 1; i < arr.length; ++i) {
            arr[i] = arr[i - 1] + numFeatures[i - 1];
        }
        this.outputOffsets = var2_2;
    }
}

