/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.feature.VectorIndexer$;
import org.apache.spark.ml.feature.VectorIndexerModel;
import org.apache.spark.ml.feature.VectorIndexerParams;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasHandleInvalid;
import org.apache.spark.ml.param.shared.HasInputCol;
import org.apache.spark.ml.param.shared.HasOutputCol;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.collection.OpenHashSet;
import org.apache.spark.util.collection.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t]b\u0001\u0002\u0014(\u0001IB\u0001\u0002\u0012\u0001\u0003\u0006\u0004%\t%\u0012\u0005\t9\u0002\u0011\t\u0011)A\u0005\r\")a\f\u0001C\u0001?\")a\f\u0001C\u0001I\")a\r\u0001C\u0001O\")\u0001\u000f\u0001C\u0001c\")A\u000f\u0001C\u0001k\")\u0001\u0010\u0001C\u0001s\")a\u0010\u0001C!\u007f\"9\u0011q\u0006\u0001\u0005B\u0005E\u0002bBA#\u0001\u0011\u0005\u0013qI\u0004\b\u0003C:\u0003\u0012AA2\r\u00191s\u0005#\u0001\u0002f!1a,\u0004C\u0001\u0003sB\u0011\"a\u001f\u000e\u0005\u0004%\taJ#\t\u000f\u0005uT\u0002)A\u0005\r\"I\u0011qP\u0007C\u0002\u0013\u0005q%\u0012\u0005\b\u0003\u0003k\u0001\u0015!\u0003G\u0011%\t\u0019)\u0004b\u0001\n\u00039S\tC\u0004\u0002\u00066\u0001\u000b\u0011\u0002$\t\u0015\u0005\u001dUB1A\u0005\u0002\u001d\nI\t\u0003\u0005\u0002\u00126\u0001\u000b\u0011BAF\u0011\u001d\t\u0019*\u0004C!\u0003+3a!!)\u000e\t\u0005\r\u0006BCAS1\t\u0015\r\u0011\"\u0003\u0002(\"I\u0011\u0011\u0016\r\u0003\u0002\u0003\u0006Ia\u001b\u0005\u000b\u0003WC\"Q1A\u0005\n\u0005\u001d\u0006\"CAW1\t\u0005\t\u0015!\u0003l\u0011\u0019q\u0006\u0004\"\u0001\u00020\"I\u0011\u0011\u0018\rC\u0002\u0013%\u00111\u0018\u0005\t\u0003'D\u0002\u0015!\u0003\u0002>\"9\u0011Q\u001b\r\u0005\u0002\u0005]\u0007bBAo1\u0011\u0005\u0011q\u001c\u0005\b\u0003oDB\u0011AA}\u0011\u001d\u0011\u0019\u0001\u0007C\u0005\u0005\u000bAqA!\u0005\u0019\t\u0013\u0011\u0019\u0002C\u0005\u0003 5\t\t\u0011\"\u0003\u0003\"\tia+Z2u_JLe\u000eZ3yKJT!\u0001K\u0015\u0002\u000f\u0019,\u0017\r^;sK*\u0011!fK\u0001\u0003[2T!\u0001L\u0017\u0002\u000bM\u0004\u0018M]6\u000b\u00059z\u0013AB1qC\u000eDWMC\u00011\u0003\ry'oZ\u0002\u0001'\u0011\u00011g\u000f \u0011\u0007Q*t'D\u0001*\u0013\t1\u0014FA\u0005FgRLW.\u0019;peB\u0011\u0001(O\u0007\u0002O%\u0011!h\n\u0002\u0013-\u0016\u001cGo\u001c:J]\u0012,\u00070\u001a:N_\u0012,G\u000e\u0005\u00029y%\u0011Qh\n\u0002\u0014-\u0016\u001cGo\u001c:J]\u0012,\u00070\u001a:QCJ\fWn\u001d\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003&\nA!\u001e;jY&\u00111\t\u0011\u0002\u0016\t\u00164\u0017-\u001e7u!\u0006\u0014\u0018-\\:Xe&$\u0018M\u00197f\u0003\r)\u0018\u000eZ\u000b\u0002\rB\u0011q\t\u0015\b\u0003\u0011:\u0003\"!\u0013'\u000e\u0003)S!aS\u0019\u0002\rq\u0012xn\u001c;?\u0015\u0005i\u0015!B:dC2\f\u0017BA(M\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011K\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005=c\u0005fA\u0001U5B\u0011Q\u000bW\u0007\u0002-*\u0011qkK\u0001\u000bC:tw\u000e^1uS>t\u0017BA-W\u0005\u0015\u0019\u0016N\\2fC\u0005Y\u0016!B\u0019/i9\u0002\u0014\u0001B;jI\u0002B3A\u0001+[\u0003\u0019a\u0014N\\5u}Q\u0011\u0001-\u0019\t\u0003q\u0001AQ\u0001R\u0002A\u0002\u0019C3!\u0019+[Q\r\u0019AK\u0017\u000b\u0002A\"\u001aA\u0001\u0016.\u0002!M,G/T1y\u0007\u0006$XmZ8sS\u0016\u001cHC\u00015j\u001b\u0005\u0001\u0001\"\u00026\u0006\u0001\u0004Y\u0017!\u0002<bYV,\u0007C\u00017n\u001b\u0005a\u0015B\u00018M\u0005\rIe\u000e\u001e\u0015\u0004\u000bQS\u0016aC:fi&s\u0007/\u001e;D_2$\"\u0001\u001b:\t\u000b)4\u0001\u0019\u0001$)\u0007\u0019!&,\u0001\u0007tKR|U\u000f\u001e9vi\u000e{G\u000e\u0006\u0002im\")!n\u0002a\u0001\r\"\u001aq\u0001\u0016.\u0002!M,G\u000fS1oI2,\u0017J\u001c<bY&$GC\u00015{\u0011\u0015Q\u0007\u00021\u0001GQ\rAA\u000b`\u0011\u0002{\u0006)!GL\u001a/a\u0005\u0019a-\u001b;\u0015\u0007]\n\t\u0001C\u0004\u0002\u0004%\u0001\r!!\u0002\u0002\u000f\u0011\fG/Y:fiB\"\u0011qAA\f!\u0019\tI!a\u0004\u0002\u00145\u0011\u00111\u0002\u0006\u0004\u0003\u001bY\u0013aA:rY&!\u0011\u0011CA\u0006\u0005\u001d!\u0015\r^1tKR\u0004B!!\u0006\u0002\u00181\u0001A\u0001DA\r\u0003\u0003\t\t\u0011!A\u0003\u0002\u0005m!aA0%cE!\u0011QDA\u0012!\ra\u0017qD\u0005\u0004\u0003Ca%a\u0002(pi\"Lgn\u001a\t\u0004Y\u0006\u0015\u0012bAA\u0014\u0019\n\u0019\u0011I\\=)\t%!\u00161F\u0011\u0003\u0003[\tQA\r\u00181]A\nq\u0002\u001e:b]N4wN]7TG\",W.\u0019\u000b\u0005\u0003g\ty\u0004\u0005\u0003\u00026\u0005mRBAA\u001c\u0015\u0011\tI$a\u0003\u0002\u000bQL\b/Z:\n\t\u0005u\u0012q\u0007\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007bBA!\u0015\u0001\u0007\u00111G\u0001\u0007g\u000eDW-\\1)\u0007)!&,\u0001\u0003d_BLHc\u00011\u0002J!9\u00111J\u0006A\u0002\u00055\u0013!B3yiJ\f\u0007\u0003BA(\u0003+j!!!\u0015\u000b\u0007\u0005M\u0013&A\u0003qCJ\fW.\u0003\u0003\u0002X\u0005E#\u0001\u0003)be\u0006lW*\u00199)\t-!\u00161L\u0011\u0003\u0003;\nQ!\r\u00185]EB3\u0001\u0001+[\u000351Vm\u0019;pe&sG-\u001a=feB\u0011\u0001(D\n\b\u001b\u0005\u001d\u0014QNA:!\ra\u0017\u0011N\u0005\u0004\u0003Wb%AB!osJ+g\r\u0005\u0003@\u0003_\u0002\u0017bAA9\u0001\n)B)\u001a4bk2$\b+\u0019:b[N\u0014V-\u00193bE2,\u0007c\u00017\u0002v%\u0019\u0011q\u000f'\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0005\u0005\r\u0014\u0001D*L\u0013B{\u0016J\u0014,B\u0019&#\u0015!D*L\u0013B{\u0016J\u0014,B\u0019&#\u0005%A\u0007F%J{%kX%O-\u0006c\u0015\nR\u0001\u000f\u000bJ\u0013vJU0J\u001dZ\u000bE*\u0013#!\u00031YU)\u0012)`\u0013:3\u0016\tT%E\u00035YU)\u0012)`\u0013:3\u0016\tT%EA\u000592/\u001e9q_J$X\r\u001a%b]\u0012dW-\u00138wC2LGm]\u000b\u0003\u0003\u0017\u0003B\u0001\\AG\r&\u0019\u0011q\u0012'\u0003\u000b\u0005\u0013(/Y=\u00021M,\b\u000f]8si\u0016$\u0007*\u00198eY\u0016LeN^1mS\u0012\u001c\b%\u0001\u0003m_\u0006$Gc\u00011\u0002\u0018\"1\u0011\u0011T\fA\u0002\u0019\u000bA\u0001]1uQ\"\"q\u0003VAOC\t\ty*A\u00032]Yr\u0003GA\u0007DCR,wm\u001c:z'R\fGo]\n\u00061\u0005\u001d\u00141O\u0001\f]Vlg)Z1ukJ,7/F\u0001l\u00031qW/\u001c$fCR,(/Z:!\u00035i\u0017\r_\"bi\u0016<wN]5fg\u0006qQ.\u0019=DCR,wm\u001c:jKN\u0004CCBAY\u0003k\u000b9\fE\u0002\u00024bi\u0011!\u0004\u0005\u0007\u0003Kk\u0002\u0019A6\t\r\u0005-V\u00041\u0001l\u0003A1W-\u0019;ve\u00164\u0016\r\\;f'\u0016$8/\u0006\u0002\u0002>B)A.!$\u0002@B1\u0011\u0011YAe\u0003\u001bl!!a1\u000b\t\u0005\u0015\u0017qY\u0001\u000bG>dG.Z2uS>t'BA!,\u0013\u0011\tY-a1\u0003\u0017=\u0003XM\u001c%bg\"\u001cV\r\u001e\t\u0004Y\u0006=\u0017bAAi\u0019\n1Ai\\;cY\u0016\f\u0011CZ3biV\u0014XMV1mk\u0016\u001cV\r^:!\u0003\u0015iWM]4f)\u0011\t\t,!7\t\u000f\u0005m\u0007\u00051\u0001\u00022\u0006)q\u000e\u001e5fe\u0006I\u0011\r\u001a3WK\u000e$xN\u001d\u000b\u0005\u0003C\f9\u000fE\u0002m\u0003GL1!!:M\u0005\u0011)f.\u001b;\t\u000f\u0005%\u0018\u00051\u0001\u0002l\u0006\ta\u000f\u0005\u0003\u0002n\u0006MXBAAx\u0015\r\t\t0K\u0001\u0007Y&t\u0017\r\\4\n\t\u0005U\u0018q\u001e\u0002\u0007-\u0016\u001cGo\u001c:\u0002\u001f\u001d,GoQ1uK\u001e|'/_'baN,\"!a?\u0011\r\u001d\u000bip\u001bB\u0001\u0013\r\tyP\u0015\u0002\u0004\u001b\u0006\u0004\bCB$\u0002~\u000657.\u0001\bbI\u0012$UM\\:f-\u0016\u001cGo\u001c:\u0015\t\u0005\u0005(q\u0001\u0005\b\u0005\u0013\u0019\u0003\u0019\u0001B\u0006\u0003\t!g\u000f\u0005\u0003\u0002n\n5\u0011\u0002\u0002B\b\u0003_\u00141\u0002R3og\u00164Vm\u0019;pe\u0006y\u0011\r\u001a3Ta\u0006\u00148/\u001a,fGR|'\u000f\u0006\u0003\u0002b\nU\u0001b\u0002B\fI\u0001\u0007!\u0011D\u0001\u0003gZ\u0004B!!<\u0003\u001c%!!QDAx\u00051\u0019\u0006/\u0019:tKZ+7\r^8s\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\r\u0002\u0003\u0002B\u0013\u0005_i!Aa\n\u000b\t\t%\"1F\u0001\u0005Y\u0006twM\u0003\u0002\u0003.\u0005!!.\u0019<b\u0013\u0011\u0011\tDa\n\u0003\r=\u0013'.Z2uQ\u0011iA+!()\t1!\u0016Q\u0014")
public class VectorIndexer
extends Estimator<VectorIndexerModel>
implements VectorIndexerParams,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> handleInvalid;
    private final IntParam maxCategories;
    private final Param<String> outputCol;
    private final Param<String> inputCol;

    public static VectorIndexer load(String string) {
        return VectorIndexer$.MODULE$.load(string);
    }

    public static MLReader<VectorIndexer> read() {
        return VectorIndexer$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public int getMaxCategories() {
        return VectorIndexerParams.getMaxCategories$(this);
    }

    @Override
    public final String getHandleInvalid() {
        return HasHandleInvalid.getHandleInvalid$(this);
    }

    @Override
    public final String getOutputCol() {
        return HasOutputCol.getOutputCol$(this);
    }

    @Override
    public final String getInputCol() {
        return HasInputCol.getInputCol$(this);
    }

    @Override
    public Param<String> handleInvalid() {
        return this.handleInvalid;
    }

    @Override
    public IntParam maxCategories() {
        return this.maxCategories;
    }

    @Override
    public void org$apache$spark$ml$feature$VectorIndexerParams$_setter_$handleInvalid_$eq(Param<String> x$1) {
        this.handleInvalid = x$1;
    }

    @Override
    public void org$apache$spark$ml$feature$VectorIndexerParams$_setter_$maxCategories_$eq(IntParam x$1) {
        this.maxCategories = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasHandleInvalid$_setter_$handleInvalid_$eq(Param<String> x$1) {
    }

    @Override
    public final Param<String> outputCol() {
        return this.outputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param<String> x$1) {
        this.outputCol = x$1;
    }

    @Override
    public final Param<String> inputCol() {
        return this.inputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param<String> x$1) {
        this.inputCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public VectorIndexer setMaxCategories(int value) {
        return (VectorIndexer)this.set(this.maxCategories(), BoxesRunTime.boxToInteger((int)value));
    }

    public VectorIndexer setInputCol(String value) {
        return (VectorIndexer)this.set(this.inputCol(), value);
    }

    public VectorIndexer setOutputCol(String value) {
        return (VectorIndexer)this.set(this.outputCol(), value);
    }

    public VectorIndexer setHandleInvalid(String value) {
        return (VectorIndexer)this.set(this.handleInvalid(), value);
    }

    @Override
    public VectorIndexerModel fit(Dataset<?> dataset) {
        this.transformSchema(dataset.schema(), true);
        int numFeatures = DatasetUtils$.MODULE$.getNumFeatures(dataset, this.$(this.inputCol()));
        RDD vectorDataset = dataset.select(this.$(this.inputCol()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object v;
            Row row = x0$1;
            Some some = Row$.MODULE$.unapplySeq(row);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (v = ((SeqLike)some.get()).apply(0)) instanceof Vector) {
                Vector vector = (Vector)v;
                return vector;
            }
            throw new MatchError((Object)row);
        }, ClassTag$.MODULE$.apply(Vector.class));
        int maxCats = BoxesRunTime.unboxToInt((Object)this.$(this.maxCategories()));
        RDD qual$1 = vectorDataset.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            CategoryStats localCatStats = new CategoryStats(numFeatures, maxCats);
            iter.foreach((Function1 & Serializable & scala.Serializable)v -> {
                localCatStats.addVector(v);
                return BoxedUnit.UNIT;
            });
            return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CategoryStats[]{localCatStats}));
        }, vectorDataset.mapPartitions$default$2(), ClassTag$.MODULE$.apply(CategoryStats.class));
        Function2 & Serializable & scala.Serializable x$1 = (Function2 & Serializable & scala.Serializable)(stats1, stats2) -> stats1.merge((CategoryStats)stats2);
        int x$2 = qual$1.treeReduce$default$2();
        CategoryStats categoryStats = (CategoryStats)qual$1.treeReduce((Function2)x$1, x$2);
        VectorIndexerModel model = new VectorIndexerModel(this.uid(), numFeatures, categoryStats.getCategoryMaps()).setParent(this);
        return this.copyValues(model, this.copyValues$default$2());
    }

    @Override
    public StructType transformSchema(StructType schema) {
        VectorUDT dataType = new VectorUDT();
        Predef$.MODULE$.require(this.isDefined(this.inputCol()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("VectorIndexer requires input column parameter: ").append(this.inputCol()).toString());
        Predef$.MODULE$.require(this.isDefined(this.outputCol()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("VectorIndexer requires output column parameter: ").append(this.outputCol()).toString());
        SchemaUtils$.MODULE$.checkColumnType(schema, this.$(this.inputCol()), (DataType)dataType, SchemaUtils$.MODULE$.checkColumnType$default$4());
        return SchemaUtils$.MODULE$.appendColumn(schema, this.$(this.outputCol()), (DataType)dataType, SchemaUtils$.MODULE$.appendColumn$default$4());
    }

    @Override
    public VectorIndexer copy(ParamMap extra) {
        return (VectorIndexer)this.defaultCopy(extra);
    }

    public VectorIndexer(String uid) {
        this.uid = uid;
        HasInputCol.$init$(this);
        HasOutputCol.$init$(this);
        HasHandleInvalid.$init$(this);
        VectorIndexerParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
    }

    public VectorIndexer() {
        this(Identifiable$.MODULE$.randomUID("vecIdx"));
    }

    private static class CategoryStats
    implements scala.Serializable {
        private final int numFeatures;
        private final int maxCategories;
        private final OpenHashSet<Object>[] featureValueSets;

        private int numFeatures() {
            return this.numFeatures;
        }

        private int maxCategories() {
            return this.maxCategories;
        }

        private OpenHashSet<Object>[] featureValueSets() {
            return this.featureValueSets;
        }

        public CategoryStats merge(CategoryStats other) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.featureValueSets())).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])other.featureValueSets()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                CategoryStats.$anonfun$merge$1(this, x0$1);
                return BoxedUnit.UNIT;
            });
            return this;
        }

        public void addVector(Vector v) {
            Predef$.MODULE$.require(v.size() == this.numFeatures(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("VectorIndexer expected ").append(this.numFeatures()).append(" features but").append(" found vector of size ").append(v.size()).append(".").toString());
            Vector vector = v;
            if (vector instanceof DenseVector) {
                DenseVector denseVector = (DenseVector)vector;
                this.addDenseVector(denseVector);
                return;
            }
            if (vector instanceof SparseVector) {
                SparseVector sparseVector = (SparseVector)vector;
                this.addSparseVector(sparseVector);
                return;
            }
            throw new MatchError((Object)vector);
        }

        public Map<Object, Map<Object, Object>> getCategoryMaps() {
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.featureValueSets())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CategoryStats.$anonfun$getCategoryMaps$1(this, x$1))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    OpenHashSet featureValues = (OpenHashSet)tuple2._1();
                    int featureIndex = tuple2._2$mcI$sp();
                    if (featureValues != null) {
                        boolean zeroExists;
                        OpenHashSet openHashSet = featureValues;
                        int n = featureIndex;
                        double[] sortedFeatureValues = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])openHashSet.iterator().filter((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$2 -> x$2 != 0.0).toArray(ClassTag$.MODULE$.Double()))).sorted((Ordering)Ordering.Double$.MODULE$);
                        boolean bl = zeroExists = sortedFeatureValues.length + 1 == openHashSet.size();
                        if (zeroExists) {
                            double d = 0.0;
                            sortedFeatureValues = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(sortedFeatureValues)).$plus$colon((Object)BoxesRunTime.boxToDouble((double)d), ClassTag$.MODULE$.Double());
                        }
                        Map categoryMap = Utils$.MODULE$.toMapWithIndex((Iterable)Predef$.MODULE$.wrapDoubleArray(sortedFeatureValues));
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)n), (Object)categoryMap);
                    }
                }
                throw new MatchError((Object)tuple2);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        }

        private void addDenseVector(DenseVector dv) {
            int size = dv.size();
            for (int i = 0; i < size; ++i) {
                if (this.featureValueSets()[i].size() > this.maxCategories()) continue;
                this.featureValueSets()[i].add$mcD$sp(dv.apply(i));
            }
        }

        private void addSparseVector(SparseVector sv) {
            int k = 0;
            int size = sv.size();
            for (int vecIndex = 0; vecIndex < size; ++vecIndex) {
                double featureValue;
                double d = featureValue = k < sv.indices().length && vecIndex == sv.indices()[k] ? sv.values()[++k - 1] : 0.0;
                if (this.featureValueSets()[vecIndex].size() > this.maxCategories()) continue;
                this.featureValueSets()[vecIndex].add$mcD$sp(featureValue);
            }
        }

        public static final /* synthetic */ void $anonfun$merge$1(CategoryStats $this, Tuple2 x0$1) {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                OpenHashSet thisValSet = (OpenHashSet)tuple2._1();
                OpenHashSet otherValSet = (OpenHashSet)tuple2._2();
                otherValSet.iterator().foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)x -> {
                    if (thisValSet.size() <= $this.maxCategories()) {
                        thisValSet.add$mcD$sp(x);
                        return;
                    }
                });
                return;
            }
            throw new MatchError((Object)tuple2);
        }

        public static final /* synthetic */ boolean $anonfun$getCategoryMaps$1(CategoryStats $this, Tuple2 x$1) {
            return ((OpenHashSet)x$1._1()).size() <= $this.maxCategories();
        }

        public CategoryStats(int numFeatures, int maxCategories) {
            this.numFeatures = numFeatures;
            this.maxCategories = maxCategories;
            this.featureValueSets = (OpenHashSet[])Array$.MODULE$.fill(numFeatures, (Function0 & Serializable & scala.Serializable)() -> new OpenHashSet.mcD.sp(ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(OpenHashSet.class));
        }
    }
}

