/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.evaluation;

import java.io.Serializable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.evaluation.RankingMetrics$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.util.collection.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001\u0002\n\u0014\u0001yA\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\t\u0005\u0002\u0011\u0019\u0011)A\u0006\u0007\")\u0001\u000b\u0001C\u0001#\"9A\u0007\u0001b\u0001\n\u0013!\u0007B\u00029\u0001A\u0003%Q\rC\u0003r\u0001\u0011\u0005!\u000f\u0003\u0005z\u0001!\u0015\r\u0011\"\u0001{\u0011\u0015a\b\u0001\"\u0001~\u0011\u001d\t)\u0001\u0001C\u0005\u0003\u000fAq!!\u000b\u0001\t\u0003\tY\u0003C\u0004\u00022\u0001!\t!a\r\t\u000f\u0005e\u0002\u0001\"\u0003\u0002<\u001d9\u0011\u0011J\n\t\u0002\u0005-cA\u0002\n\u0014\u0011\u0003\ti\u0005\u0003\u0004Q\u001d\u0011\u0005\u0011q\n\u0005\b\u0003#rA\u0011AA*\u0011%\tIJDA\u0001\n\u0013\tYJ\u0001\bSC:\\\u0017N\\4NKR\u0014\u0018nY:\u000b\u0005Q)\u0012AC3wC2,\u0018\r^5p]*\u0011acF\u0001\u0006[2d\u0017N\u0019\u0006\u00031e\tQa\u001d9be.T!AG\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0012aA8sO\u000e\u0001QCA\u0010K'\u0011\u0001\u0001E\n\u0017\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\r\u0005s\u0017PU3g!\t9#&D\u0001)\u0015\tIs#\u0001\u0005j]R,'O\\1m\u0013\tY\u0003FA\u0004M_\u001e<\u0017N\\4\u0011\u0005\u0005j\u0013B\u0001\u0018#\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003M\u0001(/\u001a3jGRLwN\\!oI2\u000b'-\u001a7ta\t\t\u0014\bE\u00023k]j\u0011a\r\u0006\u0003i]\t1A\u001d3e\u0013\t14GA\u0002S\t\u0012\u0003\"\u0001O\u001d\r\u0001\u0011I!(AA\u0001\u0002\u0003\u0015\ta\u000f\u0002\u0004?\u0012\n\u0014C\u0001\u001f@!\t\tS(\u0003\u0002?E\t9aj\u001c;iS:<\u0007CA\u0011A\u0013\t\t%EA\u0004Qe>$Wo\u0019;\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u0002E\u000f&k\u0011!\u0012\u0006\u0003\r\n\nqA]3gY\u0016\u001cG/\u0003\u0002I\u000b\nA1\t\\1tgR\u000bw\r\u0005\u00029\u0015\u0012)1\n\u0001b\u0001\u0019\n\tA+\u0005\u0002=\u001bB\u0011\u0011ET\u0005\u0003\u001f\n\u00121!\u00118z\u0003\u0019a\u0014N\\5u}Q\u0011!K\u0016\u000b\u0003'V\u00032\u0001\u0016\u0001J\u001b\u0005\u0019\u0002\"\u0002\"\u0004\u0001\b\u0019\u0005\"B\u0018\u0004\u0001\u00049\u0006G\u0001-[!\r\u0011T'\u0017\t\u0003qi#\u0011B\u000f,\u0002\u0002\u0003\u0005)\u0011A\u001e)\u0007\ra&\r\u0005\u0002^A6\taL\u0003\u0002`/\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005\u0005t&!B*j]\u000e,\u0017%A2\u0002\u000bEr#G\f\u0019\u0016\u0003\u0015\u00042AM\u001bg!\u0015\ts-[5m\u0013\tA'E\u0001\u0004UkBdWm\r\t\u0004C)L\u0015BA6#\u0005\u0015\t%O]1z!\r\t#.\u001c\t\u0003C9L!a\u001c\u0012\u0003\r\u0011{WO\u00197f\u0003\u0011\u0011H\r\u001a\u0011\u0002\u0017A\u0014XmY5tS>t\u0017\t\u001e\u000b\u0003[NDQ\u0001\u001e\u0004A\u0002U\f\u0011a\u001b\t\u0003CYL!a\u001e\u0012\u0003\u0007%sG\u000fK\u0002\u00079\n\fA#\\3b]\u00063XM]1hKB\u0013XmY5tS>tW#A7)\u0007\u001da&-\u0001\fnK\u0006t\u0017I^3sC\u001e,\u0007K]3dSNLwN\\!u)\tig\u0010C\u0003u\u0011\u0001\u0007Q\u000f\u000b\u0003\t9\u0006\u0005\u0011EAA\u0002\u0003\u0015\u0019d\u0006\r\u00181\u0003A\tg/\u001a:bO\u0016\u0004&/Z2jg&|g\u000eF\u0004n\u0003\u0013\ti!a\n\t\r\u0005-\u0011\u00021\u0001j\u0003\u0011\u0001(/\u001a3\t\u000f\u0005=\u0011\u00021\u0001\u0002\u0012\u0005\u0019A.\u00192\u0011\u000b\u0005M\u0011\u0011E%\u000f\t\u0005U\u0011Q\u0004\t\u0004\u0003/\u0011SBAA\r\u0015\r\tY\"H\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005}!%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003G\t)CA\u0002TKRT1!a\b#\u0011\u0015!\u0018\u00021\u0001v\u0003\u0019qGmY4BiR\u0019Q.!\f\t\u000bQT\u0001\u0019A;)\u0007)a&-\u0001\u0005sK\u000e\fG\u000e\\!u)\ri\u0017Q\u0007\u0005\u0006i.\u0001\r!\u001e\u0015\u0005\u0017q\u000b\t!\u0001\fd_VtGOU3mKZ\fg\u000e^%uK6\u0014\u0016\r^5p)%i\u0017QHA \u0003\u0003\n\u0019\u0005\u0003\u0004\u0002\f1\u0001\r!\u001b\u0005\u0007\u0003\u001fa\u0001\u0019A5\t\u000bQd\u0001\u0019A;\t\r\u0005\u0015C\u00021\u0001v\u0003-!WM\\8nS:\fGo\u001c:)\u0007\u0001a&-\u0001\bSC:\\\u0017N\\4NKR\u0014\u0018nY:\u0011\u0005Qs1c\u0001\b!YQ\u0011\u00111J\u0001\u0003_\u001a,\u0002\"!\u0016\u0002\\\u0005e\u00141\u0012\u000b\u0005\u0003/\ny\u0006\u0005\u0003U\u0001\u0005e\u0003c\u0001\u001d\u0002\\\u00111\u0011Q\f\tC\u00021\u0013\u0011!\u0012\u0005\u0007_A\u0001\r!!\u00191\t\u0005\r\u0014Q\u000f\t\u0007\u0003K\ny'a\u001d\u000e\u0005\u0005\u001d$\u0002BA5\u0003W\nAA[1wC*\u0019\u0011QN\f\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002r\u0005\u001d$a\u0002&bm\u0006\u0014F\t\u0012\t\u0004q\u0005UDaCA<\u0003?\n\t\u0011!A\u0003\u0002m\u00121a\u0018\u00133\t\u0019Y\u0005C1\u0001\u0002|E\u0019A(! \u0011\r\u0005}\u0014qQA-\u001b\t\t\tI\u0003\u0003\u0002\u0004\u0006\u0015\u0015\u0001\u00027b]\u001eT!!!\u001b\n\t\u0005%\u0015\u0011\u0011\u0002\t\u0013R,'/\u00192mK\u00129\u0011Q\u0012\tC\u0002\u0005=%!A!\u0012\u0007q\n\t\nE\u0003\u0002\u0000\u0005\u001dU\u000e\u000b\u0003\u00119\u0006U\u0015EAAL\u0003\u0015\td\u0006\u000e\u00181\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005u\u0005\u0003BA@\u0003?KA!!)\u0002\u0002\n1qJ\u00196fGR\u0004")
public class RankingMetrics<T>
implements Logging,
scala.Serializable {
    private double meanAveragePrecision;
    private final RDD<Tuple3<Object, Object, double[]>> rdd;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static <E, T extends java.lang.Iterable<E>, A extends java.lang.Iterable<Object>> RankingMetrics<E> of(JavaRDD<? extends Product> javaRDD) {
        return RankingMetrics$.MODULE$.of(javaRDD);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private RDD<Tuple3<Object, Object, double[]>> rdd() {
        return this.rdd;
    }

    public double precisionAt(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable & scala.Serializable)() -> "ranking position k should be positive");
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)RankingMetrics.$anonfun$precisionAt$2(this, k, x0$1)), ClassTag$.MODULE$.Double())).mean();
    }

    private double meanAveragePrecision$lzycompute() {
        RankingMetrics rankingMetrics = this;
        synchronized (rankingMetrics) {
            if (!this.bitmap$0) {
                this.meanAveragePrecision = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)RankingMetrics.$anonfun$meanAveragePrecision$1(this, x0$1)), ClassTag$.MODULE$.Double())).mean();
                this.bitmap$0 = true;
            }
        }
        return this.meanAveragePrecision;
    }

    public double meanAveragePrecision() {
        if (!this.bitmap$0) {
            return this.meanAveragePrecision$lzycompute();
        }
        return this.meanAveragePrecision;
    }

    public double meanAveragePrecisionAt(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable & scala.Serializable)() -> "ranking position k should be positive");
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)RankingMetrics.$anonfun$meanAveragePrecisionAt$2(this, k, x0$1)), ClassTag$.MODULE$.Double())).mean();
    }

    private double averagePrecision(Object pred, Set<T> lab, int k) {
        if (lab.nonEmpty()) {
            int cnt = 0;
            double precSum = 0.0;
            int n = package$.MODULE$.min(k, ScalaRunTime$.MODULE$.array_length(pred));
            for (int i = 0; i < n; ++i) {
                if (!lab.contains(ScalaRunTime$.MODULE$.array_apply(pred, i))) continue;
                precSum += (double)(++cnt) / (double)(i + 1);
            }
            return precSum / (double)package$.MODULE$.min(lab.size(), k);
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Empty ground truth set, check input data");
        return 0.0;
    }

    public double ndcgAt(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable & scala.Serializable)() -> "ranking position k should be positive");
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)RankingMetrics.$anonfun$ndcgAt$2(this, k, x0$1)), ClassTag$.MODULE$.Double())).mean();
    }

    public double recallAt(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable & scala.Serializable)() -> "ranking position k should be positive");
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)RankingMetrics.$anonfun$recallAt$2(this, k, x0$1)), ClassTag$.MODULE$.Double())).mean();
    }

    private double countRelevantItemRatio(Object pred, Object lab, int k, int denominator) {
        Set labSet = Predef$.MODULE$.genericArrayOps(lab).toSet();
        if (labSet.nonEmpty()) {
            int n = package$.MODULE$.min(ScalaRunTime$.MODULE$.array_length(pred), k);
            int cnt = 0;
            for (int i = 0; i < n; ++i) {
                if (!labSet.contains(ScalaRunTime$.MODULE$.array_apply(pred, i))) continue;
                ++cnt;
            }
            return (double)cnt / (double)denominator;
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Empty ground truth set, check input data");
        return 0.0;
    }

    public static final /* synthetic */ double $anonfun$precisionAt$2(RankingMetrics $this, int k$1, Tuple3 x0$1) {
        Tuple3 tuple3 = x0$1;
        if (tuple3 != null) {
            Object pred = tuple3._1();
            Object lab = tuple3._2();
            return $this.countRelevantItemRatio(pred, lab, k$1, k$1);
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ double $anonfun$meanAveragePrecision$1(RankingMetrics $this, Tuple3 x0$1) {
        Tuple3 tuple3 = x0$1;
        if (tuple3 != null) {
            Object pred = tuple3._1();
            Object lab = tuple3._2();
            Set labSet = Predef$.MODULE$.genericArrayOps(lab).toSet();
            int k = package$.MODULE$.max(ScalaRunTime$.MODULE$.array_length(pred), labSet.size());
            return $this.averagePrecision(pred, labSet, k);
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ double $anonfun$meanAveragePrecisionAt$2(RankingMetrics $this, int k$2, Tuple3 x0$1) {
        Tuple3 tuple3 = x0$1;
        if (tuple3 != null) {
            Object pred = tuple3._1();
            Object lab = tuple3._2();
            return $this.averagePrecision(pred, Predef$.MODULE$.genericArrayOps(lab).toSet(), k$2);
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ double $anonfun$ndcgAt$2(RankingMetrics $this, int k$3, Tuple3 x0$1) {
        Tuple3 tuple3 = x0$1;
        if (tuple3 != null) {
            Object pred = tuple3._1();
            Object lab = tuple3._2();
            double[] rel = (double[])tuple3._3();
            boolean useBinary = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(rel)).isEmpty();
            Set labSet = Predef$.MODULE$.genericArrayOps(lab).toSet();
            Map relMap = Utils$.MODULE$.toMap((Iterable)Predef$.MODULE$.genericWrapArray(lab), (Iterable)Predef$.MODULE$.wrapDoubleArray(rel));
            if (useBinary && Predef$.MODULE$.genericArrayOps(lab).size() != new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(rel)).size()) {
                $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "# of ground truth set and # of relevance value set should be equal, check input data");
            }
            if (labSet.nonEmpty()) {
                int labSetSize = labSet.size();
                int n = package$.MODULE$.min(package$.MODULE$.max(ScalaRunTime$.MODULE$.array_length(pred), labSetSize), k$3);
                double maxDcg = 0.0;
                double dcg = 0.0;
                for (int i = 0; i < n; ++i) {
                    if (useBinary) {
                        double gain = 1.0 / package$.MODULE$.log((double)(i + 2));
                        if (i < ScalaRunTime$.MODULE$.array_length(pred) && labSet.contains(ScalaRunTime$.MODULE$.array_apply(pred, i))) {
                            dcg += gain;
                        }
                        if (i >= labSetSize) continue;
                        maxDcg += gain;
                        continue;
                    }
                    if (i < ScalaRunTime$.MODULE$.array_length(pred)) {
                        dcg += (package$.MODULE$.pow(2.0, BoxesRunTime.unboxToDouble((Object)relMap.getOrElse(ScalaRunTime$.MODULE$.array_apply(pred, i), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0))) - 1.0) / package$.MODULE$.log((double)(i + 2));
                    }
                    if (i >= labSetSize) continue;
                    maxDcg += (package$.MODULE$.pow(2.0, BoxesRunTime.unboxToDouble((Object)relMap.getOrElse(ScalaRunTime$.MODULE$.array_apply(lab, i), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0))) - 1.0) / package$.MODULE$.log((double)(i + 2));
                }
                if (maxDcg == 0.0) {
                    $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Maximum of relevance of ground truth set is zero, check input data");
                    return 0.0;
                }
                return dcg / maxDcg;
            }
            $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Empty ground truth set, check input data");
            return 0.0;
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ double $anonfun$recallAt$2(RankingMetrics $this, int k$4, Tuple3 x0$1) {
        Tuple3 tuple3 = x0$1;
        if (tuple3 != null) {
            Object pred = tuple3._1();
            Object lab = tuple3._2();
            return $this.countRelevantItemRatio(pred, lab, k$4, Predef$.MODULE$.genericArrayOps(lab).toSet().size());
        }
        throw new MatchError((Object)tuple3);
    }

    public RankingMetrics(RDD<? extends Product> predictionAndLabels, ClassTag<T> evidence$1) {
        Logging.$init$((Logging)this);
        this.rdd = predictionAndLabels.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Product product = x0$1;
            if (product instanceof Tuple2) {
                Tuple2 tuple2 = (Tuple2)product;
                Object pred = tuple2._1();
                Object lab = tuple2._2();
                if (ScalaRunTime$.MODULE$.isArray(pred, 1)) {
                    Object object = pred;
                    if (ScalaRunTime$.MODULE$.isArray(lab, 1)) {
                        Object object2 = lab;
                        return new Tuple3(object, object2, Array$.MODULE$.empty(ClassTag$.MODULE$.Double()));
                    }
                }
            }
            if (product instanceof Tuple3) {
                Tuple3 tuple3 = (Tuple3)product;
                Object pred = tuple3._1();
                Object lab = tuple3._2();
                Object rel = tuple3._3();
                if (ScalaRunTime$.MODULE$.isArray(pred, 1)) {
                    Object object = pred;
                    if (ScalaRunTime$.MODULE$.isArray(lab, 1)) {
                        Object object3 = lab;
                        if (rel instanceof double[]) {
                            double[] dArray = (double[])rel;
                            return new Tuple3(object, object3, (Object)dArray);
                        }
                    }
                }
            }
            throw new IllegalArgumentException("Expected RDD of tuples or triplets");
        }, ClassTag$.MODULE$.apply(Tuple3.class));
    }
}

