/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.optim.CholeskySolver;
import org.apache.spark.ml.optim.QuasiNewtonSolver;
import org.apache.spark.ml.optim.SingularMatrixException;
import org.apache.spark.ml.optim.WeightedLeastSquares$;
import org.apache.spark.ml.optim.WeightedLeastSquares$Auto$;
import org.apache.spark.ml.optim.WeightedLeastSquares$QuasiNewton$;
import org.apache.spark.ml.optim.WeightedLeastSquaresModel;
import org.apache.spark.ml.util.OptionalInstrumentation;
import org.apache.spark.ml.util.OptionalInstrumentation$;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r\u001dc!B:u\u0001Yt\bBCA\t\u0001\t\u0015\r\u0011\"\u0001\u0002\u0016!Q\u0011Q\u0004\u0001\u0003\u0002\u0003\u0006I!a\u0006\t\u0015\u0005}\u0001A!b\u0001\n\u0003\t\t\u0003\u0003\u0006\u0002*\u0001\u0011\t\u0011)A\u0005\u0003GA!\"a\u000b\u0001\u0005\u000b\u0007I\u0011AA\u0011\u0011)\ti\u0003\u0001B\u0001B\u0003%\u00111\u0005\u0005\u000b\u0003_\u0001!Q1A\u0005\u0002\u0005U\u0001BCA\u0019\u0001\t\u0005\t\u0015!\u0003\u0002\u0018!Q\u00111\u0007\u0001\u0003\u0006\u0004%\t!!\u0006\t\u0015\u0005U\u0002A!A!\u0002\u0013\t9\u0002\u0003\u0006\u00028\u0001\u0011)\u0019!C\u0001\u0003sA!B!9\u0001\u0005\u0003\u0005\u000b\u0011BA\u001e\u0011)\u0011\u0019\u000f\u0001BC\u0002\u0013\u0005\u0011Q\n\u0005\u000b\u0005K\u0004!\u0011!Q\u0001\n\u0005=\u0003B\u0003Bt\u0001\t\u0015\r\u0011\"\u0001\u0002\"!Q!\u0011\u001e\u0001\u0003\u0002\u0003\u0006I!a\t\t\u000f\u0005\u001d\u0003\u0001\"\u0001\u0003l\"9!q \u0001\u0005\u0002\r\u0005\u0001\"CB\u0017\u0001E\u0005I\u0011AB\u0018\u0011%\u0019\u0019\u0004AI\u0001\n\u0003\u00119\u000eC\u0004\u00046\u0001!Iaa\u000e\t\u000f\r}\u0002\u0001\"\u0003\u0004B\u001dA\u0011\u0011\t;\t\u0002Y\f\u0019EB\u0004ti\"\u0005a/!\u0012\t\u000f\u0005\u001d\u0003\u0004\"\u0001\u0002J!I\u00111\n\rC\u0002\u0013\u0005\u0011Q\n\u0005\t\u0003+B\u0002\u0015!\u0003\u0002P\u0019I\u0011q\u000b\r\u0011\u0002G\u0005\u0012\u0011L\u0004\b\u00037D\u0002\u0012QA7\r\u001d\ti\u0006\u0007EA\u0003?Bq!a\u0012\u001f\t\u0003\tY\u0007C\u0005\u0002py\t\t\u0011\"\u0011\u0002r!I\u00111\u0011\u0010\u0002\u0002\u0013\u0005\u0011Q\n\u0005\n\u0003\u000bs\u0012\u0011!C\u0001\u0003\u000fC\u0011\"a%\u001f\u0003\u0003%\t%!&\t\u0013\u0005\rf$!A\u0005\u0002\u0005\u0015\u0006\"CAU=\u0005\u0005I\u0011IAV\u0011%\tiKHA\u0001\n\u0003\ny\u000bC\u0005\u00022z\t\t\u0011\"\u0003\u00024\u001e9\u0011Q\u001c\r\t\u0002\u0006\u0005gaBA^1!\u0005\u0015Q\u0018\u0005\b\u0003\u000fJC\u0011AA`\u0011%\ty'KA\u0001\n\u0003\n\t\bC\u0005\u0002\u0004&\n\t\u0011\"\u0001\u0002N!I\u0011QQ\u0015\u0002\u0002\u0013\u0005\u00111\u0019\u0005\n\u0003'K\u0013\u0011!C!\u0003+C\u0011\"a)*\u0003\u0003%\t!a2\t\u0013\u0005%\u0016&!A\u0005B\u0005-\u0006\"CAWS\u0005\u0005I\u0011IAX\u0011%\t\t,KA\u0001\n\u0013\t\u0019lB\u0004\u0002`bA\t)!5\u0007\u000f\u0005-\u0007\u0004#!\u0002N\"9\u0011q\t\u001b\u0005\u0002\u0005=\u0007\"CA8i\u0005\u0005I\u0011IA9\u0011%\t\u0019\tNA\u0001\n\u0003\ti\u0005C\u0005\u0002\u0006R\n\t\u0011\"\u0001\u0002T\"I\u00111\u0013\u001b\u0002\u0002\u0013\u0005\u0013Q\u0013\u0005\n\u0003G#\u0014\u0011!C\u0001\u0003/D\u0011\"!+5\u0003\u0003%\t%a+\t\u0013\u00055F'!A\u0005B\u0005=\u0006\"CAYi\u0005\u0005I\u0011BAZ\u0011%\t\t\u000f\u0007b\u0001\n\u0003\t\u0019\u000f\u0003\u0005\u0002rb\u0001\u000b\u0011BAs\r\u0019\t\u0019\u0010\u0007\u0003\u0002v\"9\u0011q\t!\u0005\u0002\u0005]\b\"CA~\u0001\u0002\u0007I\u0011AA\u000b\u0011%\ti\u0010\u0011a\u0001\n\u0003\ty\u0010\u0003\u0005\u0003\n\u0001\u0003\u000b\u0015BA\f\u0011-\u0011Y\u0001\u0011a\u0001\u0002\u0004%\t!!\u0014\t\u0017\t5\u0001\t1AA\u0002\u0013\u0005!q\u0002\u0005\f\u0005'\u0001\u0005\u0019!A!B\u0013\ty\u0005C\u0006\u0003\u0016\u0001\u0003\r\u00111A\u0005\u0002\t]\u0001b\u0003B\u0010\u0001\u0002\u0007\t\u0019!C\u0001\u0005CA1B!\nA\u0001\u0004\u0005\t\u0015)\u0003\u0003\u001a!Y!q\u0005!A\u0002\u0003\u0007I\u0011AA'\u0011-\u0011I\u0003\u0011a\u0001\u0002\u0004%\tAa\u000b\t\u0017\t=\u0002\t1A\u0001B\u0003&\u0011q\n\u0005\f\u0005c\u0001\u0005\u0019!a\u0001\n\u0003\t\t\u0003C\u0006\u00034\u0001\u0003\r\u00111A\u0005\u0002\tU\u0002b\u0003B\u001d\u0001\u0002\u0007\t\u0011)Q\u0005\u0003GA1Ba\u000fA\u0001\u0004\u0005\r\u0011\"\u0003\u0002\"!Y!Q\b!A\u0002\u0003\u0007I\u0011\u0002B \u0011-\u0011\u0019\u0005\u0011a\u0001\u0002\u0003\u0006K!a\t\t\u0017\t\u0015\u0003\t1AA\u0002\u0013%\u0011\u0011\u0005\u0005\f\u0005\u000f\u0002\u0005\u0019!a\u0001\n\u0013\u0011I\u0005C\u0006\u0003N\u0001\u0003\r\u0011!Q!\n\u0005\r\u0002b\u0003B(\u0001\u0002\u0007\t\u0019!C\u0005\u0003CA1B!\u0015A\u0001\u0004\u0005\r\u0011\"\u0003\u0003T!Y!q\u000b!A\u0002\u0003\u0005\u000b\u0015BA\u0012\u0011-\u0011I\u0006\u0011a\u0001\u0002\u0004%IAa\u0017\t\u0017\t%\u0004\t1AA\u0002\u0013%!1\u000e\u0005\f\u0005_\u0002\u0005\u0019!A!B\u0013\u0011i\u0006C\u0006\u0003r\u0001\u0003\r\u00111A\u0005\n\tm\u0003b\u0003B:\u0001\u0002\u0007\t\u0019!C\u0005\u0005kB1B!\u001fA\u0001\u0004\u0005\t\u0015)\u0003\u0003^!Y!1\u0010!A\u0002\u0003\u0007I\u0011\u0002B.\u0011-\u0011i\b\u0011a\u0001\u0002\u0004%IAa \t\u0017\t\r\u0005\t1A\u0001B\u0003&!Q\f\u0005\b\u0005\u000b\u0003E\u0011\u0002BD\u0011\u001d\u0011Y\t\u0011C\u0001\u0005\u001bCqA!)A\t\u0003\u0011\u0019\u000bC\u0004\u0003*\u0002#\tAa+\t\u000f\t5\u0006\t\"\u0001\u0003\\!9!q\u0016!\u0005\u0002\u0005\u0005\u0002b\u0002BY\u0001\u0012\u0005\u0011\u0011\u0005\u0005\b\u0005g\u0003E\u0011AA\u0011\u0011\u001d\u0011)\f\u0011C\u0001\u00057BqAa.A\t\u0003\u0011Y\u0006C\u0004\u0003:\u0002#\tAa\u0017\t\u000f\tm\u0006\t\"\u0001\u0003\\!I!Q\u0018\r\u0012\u0002\u0013\u0005!q\u0018\u0005\n\u0005+D\u0012\u0013!C\u0001\u0005/D\u0011Ba7\u0019#\u0003%\tA!8\t\u0013\u0005E\u0006$!A\u0005\n\u0005M&\u0001F,fS\u001eDG/\u001a3MK\u0006\u001cHoU9vCJ,7O\u0003\u0002vm\u0006)q\u000e\u001d;j[*\u0011q\u000f_\u0001\u0003[2T!!\u001f>\u0002\u000bM\u0004\u0018M]6\u000b\u0005md\u0018AB1qC\u000eDWMC\u0001~\u0003\ry'oZ\n\u0005\u0001}\fY\u0001\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\t\t)!A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\n\u0005\r!AB!osJ+g\r\u0005\u0003\u0002\u0002\u00055\u0011\u0002BA\b\u0003\u0007\u0011AbU3sS\u0006d\u0017N_1cY\u0016\fABZ5u\u0013:$XM]2faR\u001c\u0001!\u0006\u0002\u0002\u0018A!\u0011\u0011AA\r\u0013\u0011\tY\"a\u0001\u0003\u000f\t{w\u000e\\3b]\u0006ia-\u001b;J]R,'oY3qi\u0002\n\u0001B]3h!\u0006\u0014\u0018-\\\u000b\u0003\u0003G\u0001B!!\u0001\u0002&%!\u0011qEA\u0002\u0005\u0019!u.\u001e2mK\u0006I!/Z4QCJ\fW\u000eI\u0001\u0010K2\f7\u000f^5d\u001d\u0016$\b+\u0019:b[\u0006\u0001R\r\\1ti&\u001cg*\u001a;QCJ\fW\u000eI\u0001\u0014gR\fg\u000eZ1sI&TXMR3biV\u0014Xm]\u0001\u0015gR\fg\u000eZ1sI&TXMR3biV\u0014Xm\u001d\u0011\u0002!M$\u0018M\u001c3be\u0012L'0\u001a'bE\u0016d\u0017!E:uC:$\u0017M\u001d3ju\u0016d\u0015MY3mA\u0005Q1o\u001c7wKJ$\u0016\u0010]3\u0016\u0005\u0005m\u0002cAA\u001f99\u0019\u0011qH\f\u000e\u0003Q\fAcV3jO\"$X\r\u001a'fCN$8+];be\u0016\u001c\bcAA 1M!\u0001d`A\u0006\u0003\u0019a\u0014N\\5u}Q\u0011\u00111I\u0001\u0011\u001b\u0006CvLT+N?\u001a+\u0015\tV+S\u000bN+\"!a\u0014\u0011\t\u0005\u0005\u0011\u0011K\u0005\u0005\u0003'\n\u0019AA\u0002J]R\f\u0011#T!Y?:+Vj\u0018$F\u0003R+&+R*!\u0005\u0019\u0019v\u000e\u001c<feN\u0011Ad`\u0015\u00059yICG\u0001\u0003BkR|7\u0003\u0003\u0010\u0000\u0003C\n)'a\u0003\u0011\u0007\u0005\rD$D\u0001\u0019!\u0011\t\t!a\u001a\n\t\u0005%\u00141\u0001\u0002\b!J|G-^2u)\t\ti\u0007E\u0002\u0002dy\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA:!\u0011\t)(a \u000e\u0005\u0005]$\u0002BA=\u0003w\nA\u0001\\1oO*\u0011\u0011QP\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0002\u0006]$AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005%\u0015q\u0012\t\u0005\u0003\u0003\tY)\u0003\u0003\u0002\u000e\u0006\r!aA!os\"I\u0011\u0011\u0013\u0012\u0002\u0002\u0003\u0007\u0011qJ\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005]\u0005CBAM\u0003?\u000bI)\u0004\u0002\u0002\u001c*!\u0011QTA\u0002\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003C\u000bYJ\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\f\u0003OC\u0011\"!%%\u0003\u0003\u0005\r!!#\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\u0014\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u001d\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003k\u0003B!!\u001e\u00028&!\u0011\u0011XA<\u0005\u0019y%M[3di\nA1\t[8mKN\\\u0017p\u0005\u0005*\u007f\u0006\u0005\u0014QMA\u0006)\t\t\t\rE\u0002\u0002d%\"B!!#\u0002F\"I\u0011\u0011S\u0017\u0002\u0002\u0003\u0007\u0011q\n\u000b\u0005\u0003/\tI\rC\u0005\u0002\u0012>\n\t\u00111\u0001\u0002\n\nY\u0011+^1tS:+w\u000f^8o'!!t0!\u0019\u0002f\u0005-ACAAi!\r\t\u0019\u0007\u000e\u000b\u0005\u0003\u0013\u000b)\u000eC\u0005\u0002\u0012b\n\t\u00111\u0001\u0002PQ!\u0011qCAm\u0011%\t\tJOA\u0001\u0002\u0004\tI)\u0001\u0003BkR|\u0017\u0001C\"i_2,7o[=\u0002\u0017E+\u0018m]5OK^$xN\\\u0001\u0011gV\u0004\bo\u001c:uK\u0012\u001cv\u000e\u001c<feN,\"!!:\u0011\r\u0005\u0005\u0011q]Av\u0013\u0011\tI/a\u0001\u0003\u000b\u0005\u0013(/Y=\u0013\u0011\u00055\u0018QMA\u0006\u0003C2a!a<\u0019\u0001\u0005-(\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0014!E:vaB|'\u000f^3e'>dg/\u001a:tA\tQ\u0011iZ4sK\u001e\fGo\u001c:\u0014\t\u0001{\u00181\u0002\u000b\u0003\u0003s\u00042!a\u0019A\u0003-Ig.\u001b;jC2L'0\u001a3\u0002\u001f%t\u0017\u000e^5bY&TX\rZ0%KF$BA!\u0001\u0003\bA!\u0011\u0011\u0001B\u0002\u0013\u0011\u0011)!a\u0001\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003#\u001b\u0015\u0011!a\u0001\u0003/\tA\"\u001b8ji&\fG.\u001b>fI\u0002\n\u0011a[\u0001\u0006W~#S-\u001d\u000b\u0005\u0005\u0003\u0011\t\u0002C\u0005\u0002\u0012\u001a\u000b\t\u00111\u0001\u0002P\u0005\u00111\u000eI\u0001\u0006G>,h\u000e^\u000b\u0003\u00053\u0001B!!\u0001\u0003\u001c%!!QDA\u0002\u0005\u0011auN\\4\u0002\u0013\r|WO\u001c;`I\u0015\fH\u0003\u0002B\u0001\u0005GA\u0011\"!%J\u0003\u0003\u0005\rA!\u0007\u0002\r\r|WO\u001c;!\u0003\u0011!(/[&\u0002\u0011Q\u0014\u0018nS0%KF$BA!\u0001\u0003.!I\u0011\u0011\u0013'\u0002\u0002\u0003\u0007\u0011qJ\u0001\u0006iJL7\nI\u0001\u0005oN+X.\u0001\u0005x'Vlw\fJ3r)\u0011\u0011\tAa\u000e\t\u0013\u0005Eu*!AA\u0002\u0005\r\u0012!B<Tk6\u0004\u0013!B<x'Vl\u0017!C<x'Vlw\fJ3r)\u0011\u0011\tA!\u0011\t\u0013\u0005E%+!AA\u0002\u0005\r\u0012AB<x'Vl\u0007%\u0001\u0003c'Vl\u0017\u0001\u00032Tk6|F%Z9\u0015\t\t\u0005!1\n\u0005\n\u0003#+\u0016\u0011!a\u0001\u0003G\tQAY*v[\u0002\nQA\u00192Tk6\f\u0011B\u00192Tk6|F%Z9\u0015\t\t\u0005!Q\u000b\u0005\n\u0003#C\u0016\u0011!a\u0001\u0003G\taA\u00192Tk6\u0004\u0013\u0001B1Tk6,\"A!\u0018\u0011\t\t}#QM\u0007\u0003\u0005CR1Aa\u0019w\u0003\u0019a\u0017N\\1mO&!!q\rB1\u0005-!UM\\:f-\u0016\u001cGo\u001c:\u0002\u0011\u0005\u001cV/\\0%KF$BA!\u0001\u0003n!I\u0011\u0011S.\u0002\u0002\u0003\u0007!QL\u0001\u0006CN+X\u000eI\u0001\u0006C\n\u001cV/\\\u0001\nC\n\u001cV/\\0%KF$BA!\u0001\u0003x!I\u0011\u0011\u00130\u0002\u0002\u0003\u0007!QL\u0001\u0007C\n\u001cV/\u001c\u0011\u0002\u000b\u0005\f7+^7\u0002\u0013\u0005\f7+^7`I\u0015\fH\u0003\u0002B\u0001\u0005\u0003C\u0011\"!%b\u0003\u0003\u0005\rA!\u0018\u0002\r\u0005\f7+^7!\u0003\u0011Ig.\u001b;\u0015\t\t\u0005!\u0011\u0012\u0005\b\u0005\u0017\u0019\u0007\u0019AA(\u0003\r\tG\r\u001a\u000b\u0005\u0005\u001f\u0013\t*D\u0001A\u0011\u001d\u0011\u0019\n\u001aa\u0001\u0005+\u000b\u0001\"\u001b8ti\u0006t7-\u001a\t\u0005\u0005/\u0013i*\u0004\u0002\u0003\u001a*\u0019!1\u0014<\u0002\u000f\u0019,\u0017\r^;sK&!!q\u0014BM\u0005!Ien\u001d;b]\u000e,\u0017!B7fe\u001e,G\u0003\u0002BH\u0005KCqAa*f\u0001\u0004\tI0A\u0003pi\",'/\u0001\u0005wC2LG-\u0019;f)\t\u0011\t!\u0001\u0003b\u0005\u0006\u0014\u0018\u0001\u00022CCJ\fQA\u00192CCJ\fAAY*uI\u0006)\u0011M\u0019\"be\u0006)\u0011-\u0019\"be\u0006!\u0011m\u0015;e\u0003\u0011\tg+\u0019:\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011\tM\u000b\u0003\u0002<\t\r7F\u0001Bc!\u0011\u00119M!5\u000e\u0005\t%'\u0002\u0002Bf\u0005\u001b\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\t\t=\u00171A\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002Bj\u0005\u0013\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%oU\u0011!\u0011\u001c\u0016\u0005\u0003\u001f\u0012\u0019-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005O\u000b\u0003\u0005?TC!a\t\u0003D\u0006Y1o\u001c7wKJ$\u0016\u0010]3!\u0003\u001di\u0017\r_%uKJ\f\u0001\"\\1y\u0013R,'\u000fI\u0001\u0004i>d\u0017\u0001\u0002;pY\u0002\"\"C!<\u0003p\nE(1\u001fB{\u0005o\u0014IPa?\u0003~B\u0019\u0011q\b\u0001\t\u000f\u0005E\u0011\u00031\u0001\u0002\u0018!9\u0011qD\tA\u0002\u0005\r\u0002bBA\u0016#\u0001\u0007\u00111\u0005\u0005\b\u0003_\t\u0002\u0019AA\f\u0011\u001d\t\u0019$\u0005a\u0001\u0003/A\u0011\"a\u000e\u0012!\u0003\u0005\r!a\u000f\t\u0013\t\r\u0018\u0003%AA\u0002\u0005=\u0003\"\u0003Bt#A\u0005\t\u0019AA\u0012\u0003\r1\u0017\u000e\u001e\u000b\t\u0007\u0007\u0019Ia!\u0007\u0004*A!\u0011qHB\u0003\u0013\r\u00199\u0001\u001e\u0002\u001a/\u0016Lw\r\u001b;fI2+\u0017m\u001d;TcV\f'/Z:N_\u0012,G\u000eC\u0004\u0004\fI\u0001\ra!\u0004\u0002\u0013%t7\u000f^1oG\u0016\u001c\bCBB\b\u0007+\u0011)*\u0004\u0002\u0004\u0012)\u001911\u0003=\u0002\u0007I$G-\u0003\u0003\u0004\u0018\rE!a\u0001*E\t\"I11\u0004\n\u0011\u0002\u0003\u00071QD\u0001\u0006S:\u001cHO\u001d\t\u0005\u0007?\u0019)#\u0004\u0002\u0004\")\u001911\u0005<\u0002\tU$\u0018\u000e\\\u0005\u0005\u0007O\u0019\tCA\fPaRLwN\\1m\u0013:\u001cHO];nK:$\u0018\r^5p]\"I11\u0006\n\u0011\u0002\u0003\u0007\u0011qJ\u0001\u0006I\u0016\u0004H\u000f[\u0001\u000eM&$H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\rE\"\u0006BB\u000f\u0005\u0007\fQBZ5uI\u0011,g-Y;mi\u0012\u001a\u0014AB4fi\u0006#\u0018\t\u0006\u0004\u0003^\re2Q\b\u0005\b\u0005o+\u0002\u0019AB\u001e!\u0019\t\t!a:\u0002$!9!QV\u000bA\u0002\rm\u0012AB4fi\u0006#(\t\u0006\u0004\u0003^\r\r3Q\t\u0005\b\u0005k3\u0002\u0019AB\u001e\u0011\u001d\u0011yK\u0006a\u0001\u0003G\u0001")
public class WeightedLeastSquares
implements scala.Serializable {
    private final boolean fitIntercept;
    private final double regParam;
    private final double elasticNetParam;
    private final boolean standardizeFeatures;
    private final boolean standardizeLabel;
    private final Solver solverType;
    private final int maxIter;
    private final double tol;

    public static double $lessinit$greater$default$8() {
        return WeightedLeastSquares$.MODULE$.$lessinit$greater$default$8();
    }

    public static int $lessinit$greater$default$7() {
        return WeightedLeastSquares$.MODULE$.$lessinit$greater$default$7();
    }

    public static Solver $lessinit$greater$default$6() {
        return WeightedLeastSquares$.MODULE$.$lessinit$greater$default$6();
    }

    public static Product[] supportedSolvers() {
        return WeightedLeastSquares$.MODULE$.supportedSolvers();
    }

    public static int MAX_NUM_FEATURES() {
        return WeightedLeastSquares$.MODULE$.MAX_NUM_FEATURES();
    }

    public boolean fitIntercept() {
        return this.fitIntercept;
    }

    public double regParam() {
        return this.regParam;
    }

    public double elasticNetParam() {
        return this.elasticNetParam;
    }

    public boolean standardizeFeatures() {
        return this.standardizeFeatures;
    }

    public boolean standardizeLabel() {
        return this.standardizeLabel;
    }

    public Solver solverType() {
        return this.solverType;
    }

    public int maxIter() {
        return this.maxIter;
    }

    public double tol() {
        return this.tol;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public WeightedLeastSquaresModel fit(RDD<Instance> instances, OptionalInstrumentation instr, int depth) {
        block31: {
            block28: {
                block27: {
                    if (this.regParam() == 0.0) {
                        instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$1(), ()Ljava/lang/String;)());
                    }
                    summary = (Aggregator)instances.treeAggregate((Object)new Aggregator(), (Function2)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$fit$2(org.apache.spark.ml.optim.WeightedLeastSquares$Aggregator org.apache.spark.ml.feature.Instance ), (Lorg/apache/spark/ml/optim/WeightedLeastSquares$Aggregator;Lorg/apache/spark/ml/feature/Instance;)Lorg/apache/spark/ml/optim/WeightedLeastSquares$Aggregator;)(), (Function2)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$fit$3(org.apache.spark.ml.optim.WeightedLeastSquares$Aggregator org.apache.spark.ml.optim.WeightedLeastSquares$Aggregator ), (Lorg/apache/spark/ml/optim/WeightedLeastSquares$Aggregator;Lorg/apache/spark/ml/optim/WeightedLeastSquares$Aggregator;)Lorg/apache/spark/ml/optim/WeightedLeastSquares$Aggregator;)(), depth, ClassTag$.MODULE$.apply(Aggregator.class));
                    summary.validate();
                    instr.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$4(org.apache.spark.ml.optim.WeightedLeastSquares$Aggregator ), ()Ljava/lang/String;)((Aggregator)summary));
                    k = this.fitIntercept() != false ? summary.k() + 1 : summary.k();
                    numFeatures = summary.k();
                    triK = summary.triK();
                    wSum = summary.wSum();
                    rawBStd = summary.bStd();
                    rawBBar = summary.bBar();
                    v0 = bStd = rawBStd == 0.0 ? package$.MODULE$.abs(rawBBar) : rawBStd;
                    if (rawBStd == (double)false) {
                        if (this.fitIntercept() || rawBBar == 0.0) {
                            if (rawBBar == 0.0) {
                                instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$5(), ()Ljava/lang/String;)());
                            } else {
                                instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$6(), ()Ljava/lang/String;)());
                            }
                            coefficients = new DenseVector((double[])Array$.MODULE$.ofDim(numFeatures, ClassTag$.MODULE$.Double()));
                            intercept = rawBBar;
                            diagInvAtWA = new DenseVector(new double[]{0.0});
                            return new WeightedLeastSquaresModel(coefficients, intercept, diagInvAtWA, new double[]{0.0});
                        }
                        Predef$.MODULE$.require(!(this.regParam() > 0.0) || this.standardizeLabel() == false, (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$7(), ()Ljava/lang/String;)());
                        instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$8(), ()Ljava/lang/String;)());
                    }
                    bBar = summary.bBar() / bStd;
                    bbBar = summary.bbBar() / (bStd * bStd);
                    aStd = summary.aStd();
                    aStdValues = aStd.values();
                    _aBar = summary.aBar();
                    _aBarValues = _aBar.values();
                    for (i = 0; i < numFeatures; ++i) {
                        if (aStdValues[i] == 0.0) {
                            _aBarValues[i] = 0.0;
                            continue;
                        }
                        var33_22 = i;
                        _aBarValues[var33_22] = _aBarValues[var33_22] / aStdValues[i];
                    }
                    aBar = _aBar;
                    aBarValues = aBar.values();
                    _abBar = summary.abBar();
                    _abBarValues = _abBar.values();
                    for (i = 0; i < numFeatures; ++i) {
                        if (aStdValues[i] == 0.0) {
                            _abBarValues[i] = 0.0;
                            continue;
                        }
                        var39_28 = i;
                        _abBarValues[var39_28] = _abBarValues[var39_28] / (aStdValues[i] * bStd);
                    }
                    abBar = _abBar;
                    abBarValues = abBar.values();
                    _aaBar = summary.aaBar();
                    _aaBarValues = _aaBar.values();
                    p = 0;
                    for (j = 0; j < numFeatures; ++j) {
                        aStdJ = aStdValues[j];
                        for (i = 0; i <= j; ++i) {
                            aStdI = aStdValues[i];
                            if (aStdJ == 0.0 || aStdI == 0.0) {
                                _aaBarValues[p] = 0.0;
                            } else {
                                var51_38 = p;
                                _aaBarValues[var51_38] = _aaBarValues[var51_38] / (aStdI * aStdJ);
                            }
                            ++p;
                        }
                    }
                    aaBar = _aaBar;
                    aaBarValues = aaBar.values();
                    effectiveRegParam = this.regParam() / bStd;
                    effectiveL1RegParam = this.elasticNetParam() * effectiveRegParam;
                    effectiveL2RegParam = (1.0 - this.elasticNetParam()) * effectiveRegParam;
                    i = 0;
                    j = 2;
                    while (i < triK) {
                        lambda = effectiveL2RegParam;
                        if (!this.standardizeFeatures()) {
                            std = aStdValues[j - 2];
                            lambda = std != 0.0 ? (lambda /= std * std) : 0.0;
                        }
                        if (!this.standardizeLabel()) {
                            lambda *= bStd;
                        }
                        var65_46 = i;
                        aaBarValues[var65_46] = aaBarValues[var65_46] + lambda;
                        i += j;
                        ++j;
                    }
                    aa = this.getAtA(aaBarValues, aBarValues);
                    ab = this.getAtB(abBarValues, bBar);
                    v1 = this.solverType();
                    var69_51 = WeightedLeastSquares$Auto$.MODULE$;
                    if (v1 != null ? v1.equals(var69_51) == false : var69_51 != null) break block27;
                    if (this.elasticNetParam() != 0.0 && this.regParam() != 0.0) ** GOTO lbl-1000
                }
                v2 = this.solverType();
                var70_52 = WeightedLeastSquares$QuasiNewton$.MODULE$;
                if (!(v2 != null ? v2.equals(var70_52) == false : var70_52 != null)) lbl-1000:
                // 2 sources

                {
                    effectiveL1RegFun = effectiveL1RegParam != 0.0 ? new Some((Object)(JFunction1.mcDI.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (I)D, $anonfun$fit$9(org.apache.spark.ml.optim.WeightedLeastSquares int double double[] int ), (I)D)((WeightedLeastSquares)this, (int)numFeatures, (double)effectiveL1RegParam, (double[])aStdValues)) : None$.MODULE$;
                    v3 /* !! */  = new QuasiNewtonSolver(this.fitIntercept(), this.maxIter(), this.tol(), (Option<Function1<Object, Object>>)effectiveL1RegFun);
                } else {
                    v3 /* !! */  = new CholeskySolver();
                }
                var73_55 = solver = v3 /* !! */ ;
                if (!(var73_55 instanceof CholeskySolver)) break block28;
                var74_56 = var73_55;
                try {
                    v4 = var74_56.solve(bBar, bbBar, ab, aa, aBar);
                }
                catch (Throwable var75_57) {
                    block30: {
                        block29: {
                            var76_58 = var75_57;
                            if (!(var76_58 instanceof SingularMatrixException)) break block29;
                            v5 = this.solverType();
                            var77_59 = WeightedLeastSquares$Auto$.MODULE$;
                            if (!(v5 != null ? v5.equals(var77_59) == false : var77_59 != null)) break block30;
                        }
                        throw var75_57;
                    }
                    instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$10(), ()Ljava/lang/String;)());
                    _aa = this.getAtA(aaBarValues, aBarValues);
                    _ab = this.getAtB(abBarValues, bBar);
                    newSolver = new QuasiNewtonSolver(this.fitIntercept(), this.maxIter(), this.tol(), (Option<Function1<Object, Object>>)None$.MODULE$);
                    var6_63 = newSolver.solve(bBar, bbBar, _ab, _aa, aBar);
                    v4 = var6_63;
                }
                var5_64 = v4;
                break block31;
            }
            if (var73_55 instanceof QuasiNewtonSolver) {
                var81_65 = (QuasiNewtonSolver)var73_55;
                var5_64 = var81_65.solve(bBar, bbBar, ab, aa, aBar);
            } else {
                throw new MatchError((Object)var73_55);
            }
        }
        solution = var5_64;
        v6 = var83_67 = this.fitIntercept() != false ? new Tuple2(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(solution.coefficients())).slice(0, solution.coefficients().length - 1), (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(solution.coefficients())).last()) * bStd))) : new Tuple2((Object)solution.coefficients(), (Object)BoxesRunTime.boxToDouble((double)0.0));
        if (var83_67 == null) {
            throw new MatchError((Object)var83_67);
        }
        coefficientArray = (double[])var83_67._1();
        intercept = var83_67._2$mcD$sp();
        var4_70 = new Tuple2((Object)coefficientArray, (Object)BoxesRunTime.boxToDouble((double)intercept));
        var82_71 = var4_70;
        coefficientArray = (double[])var82_71._1();
        intercept = var82_71._2$mcD$sp();
        len = coefficientArray.length;
        for (q = 0; q < len; ++q) {
            var92_76 = q;
            coefficientArray[var92_76] = coefficientArray[var92_76] * (aStdValues[q] != 0.0 ? bStd / aStdValues[q] : 0.0);
        }
        diagInvAtWA = (DenseVector)solution.aaInv().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$fit$11(org.apache.spark.ml.optim.WeightedLeastSquares int double[] double double[] ), ([D)Lorg/apache/spark/ml/linalg/DenseVector;)((WeightedLeastSquares)this, (int)k, (double[])aStdValues, (double)wSum)).getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$13(), ()Lorg/apache/spark/ml/linalg/DenseVector;)());
        return new WeightedLeastSquaresModel(new DenseVector(coefficientArray), intercept, diagInvAtWA, (double[])solution.objectiveHistory().getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$14(), ()[D)()));
    }

    public OptionalInstrumentation fit$default$2() {
        return OptionalInstrumentation$.MODULE$.create(WeightedLeastSquares.class);
    }

    public int fit$default$3() {
        return 2;
    }

    private DenseVector getAtA(double[] aaBar, double[] aBar) {
        return this.fitIntercept() ? new DenseVector((double[])Array$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new double[][]{aaBar, aBar, {1.0}}), ClassTag$.MODULE$.Double())) : new DenseVector((double[])aaBar.clone());
    }

    private DenseVector getAtB(double[] abBar, double bBar) {
        return this.fitIntercept() ? new DenseVector((double[])Array$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new double[][]{abBar, {bBar}}), ClassTag$.MODULE$.Double())) : new DenseVector((double[])abBar.clone());
    }

    public static final /* synthetic */ String $anonfun$fit$1() {
        return "regParam is zero, which might cause numerical instability and overfitting.";
    }

    public static final /* synthetic */ Aggregator $anonfun$fit$2(Aggregator x$1, Instance x$2) {
        return x$1.add(x$2);
    }

    public static final /* synthetic */ Aggregator $anonfun$fit$3(Aggregator x$3, Aggregator x$4) {
        return x$3.merge(x$4);
    }

    public static final /* synthetic */ String $anonfun$fit$4(Aggregator summary$1) {
        return new StringBuilder(22).append("Number of instances: ").append(summary$1.count()).append(".").toString();
    }

    public static final /* synthetic */ String $anonfun$fit$5() {
        return new StringBuilder(143).append("Mean and standard deviation of the label are zero, so the ").append("coefficients and the intercept will all be zero; as a result, training is not ").append("needed.").toString();
    }

    public static final /* synthetic */ String $anonfun$fit$6() {
        return new StringBuilder(164).append("The standard deviation of the label is zero, so the coefficients ").append("will be zeros and the intercept will be the mean of the label; as a result, ").append("training is not needed.").toString();
    }

    public static final /* synthetic */ String $anonfun$fit$7() {
        return "The standard deviation of the label is zero. Model cannot be regularized when labels are standardized.";
    }

    public static final /* synthetic */ String $anonfun$fit$8() {
        return new StringBuilder(80).append("The standard deviation of the label is zero. Consider setting ").append("fitIntercept=true.").toString();
    }

    public static final /* synthetic */ double $anonfun$fit$9(WeightedLeastSquares $this, int numFeatures$1, double effectiveL1RegParam$1, double[] aStdValues$1, int index) {
        return $this.fitIntercept() && index == numFeatures$1 ? 0.0 : ($this.standardizeFeatures() ? effectiveL1RegParam$1 : (aStdValues$1[index] != 0.0 ? effectiveL1RegParam$1 / aStdValues$1[index] : 0.0));
    }

    public static final /* synthetic */ String $anonfun$fit$10() {
        return "Cholesky solver failed due to singular covariance matrix. Retrying with Quasi-Newton solver.";
    }

    public static final /* synthetic */ DenseVector $anonfun$fit$11(WeightedLeastSquares $this, int k$1, double[] aStdValues$1, double wSum$1, double[] inv) {
        return new DenseVector((double[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), k$1).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> {
            double multiplier = i == k$1 && $this.fitIntercept() ? 1.0 : aStdValues$1[i - 1] * aStdValues$1[i - 1];
            return inv[i + (i - 1) * i / 2 - 1] / (wSum$1 * multiplier);
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double()));
    }

    public static final /* synthetic */ DenseVector $anonfun$fit$13() {
        return new DenseVector(new double[]{0.0});
    }

    public static final /* synthetic */ double[] $anonfun$fit$14() {
        return new double[]{0.0};
    }

    public WeightedLeastSquares(boolean fitIntercept, double regParam, double elasticNetParam, boolean standardizeFeatures, boolean standardizeLabel, Solver solverType, int maxIter, double tol) {
        this.fitIntercept = fitIntercept;
        this.regParam = regParam;
        this.elasticNetParam = elasticNetParam;
        this.standardizeFeatures = standardizeFeatures;
        this.standardizeLabel = standardizeLabel;
        this.solverType = solverType;
        this.maxIter = maxIter;
        this.tol = tol;
        Predef$.MODULE$.require(regParam >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("regParam cannot be negative: ").append(this.regParam()).toString());
        Predef$.MODULE$.require(elasticNetParam >= 0.0 && elasticNetParam <= 1.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("elasticNetParam must be in [0, 1]: ").append(this.elasticNetParam()).toString());
        Predef$.MODULE$.require(maxIter > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("maxIter must be a positive integer: ").append(this.maxIter()).toString());
        Predef$.MODULE$.require(tol >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("tol must be >= 0, but was set to ").append(this.tol()).toString());
    }

    private static class Aggregator
    implements scala.Serializable {
        private boolean initialized = false;
        private int k;
        private long count;
        private int triK;
        private double wSum;
        private double wwSum;
        private double bSum;
        private double bbSum;
        private DenseVector aSum;
        private DenseVector abSum;
        private DenseVector aaSum;

        public boolean initialized() {
            return this.initialized;
        }

        public void initialized_$eq(boolean x$1) {
            this.initialized = x$1;
        }

        public int k() {
            return this.k;
        }

        public void k_$eq(int x$1) {
            this.k = x$1;
        }

        public long count() {
            return this.count;
        }

        public void count_$eq(long x$1) {
            this.count = x$1;
        }

        public int triK() {
            return this.triK;
        }

        public void triK_$eq(int x$1) {
            this.triK = x$1;
        }

        public double wSum() {
            return this.wSum;
        }

        public void wSum_$eq(double x$1) {
            this.wSum = x$1;
        }

        private double wwSum() {
            return this.wwSum;
        }

        private void wwSum_$eq(double x$1) {
            this.wwSum = x$1;
        }

        private double bSum() {
            return this.bSum;
        }

        private void bSum_$eq(double x$1) {
            this.bSum = x$1;
        }

        private double bbSum() {
            return this.bbSum;
        }

        private void bbSum_$eq(double x$1) {
            this.bbSum = x$1;
        }

        private DenseVector aSum() {
            return this.aSum;
        }

        private void aSum_$eq(DenseVector x$1) {
            this.aSum = x$1;
        }

        private DenseVector abSum() {
            return this.abSum;
        }

        private void abSum_$eq(DenseVector x$1) {
            this.abSum = x$1;
        }

        private DenseVector aaSum() {
            return this.aaSum;
        }

        private void aaSum_$eq(DenseVector x$1) {
            this.aaSum = x$1;
        }

        private void init(int k) {
            Predef$.MODULE$.require(k <= WeightedLeastSquares$.MODULE$.MAX_NUM_FEATURES(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(106).append("In order to take the normal equation approach efficiently, ").append("we set the max number of features to ").append(WeightedLeastSquares$.MODULE$.MAX_NUM_FEATURES()).append(" but got ").append(k).append(".").toString());
            this.k_$eq(k);
            this.triK_$eq(k * (k + 1) / 2);
            this.count_$eq(0L);
            this.wSum_$eq(0.0);
            this.wwSum_$eq(0.0);
            this.bSum_$eq(0.0);
            this.bbSum_$eq(0.0);
            this.aSum_$eq(new DenseVector((double[])Array$.MODULE$.ofDim(k, ClassTag$.MODULE$.Double())));
            this.abSum_$eq(new DenseVector((double[])Array$.MODULE$.ofDim(k, ClassTag$.MODULE$.Double())));
            this.aaSum_$eq(new DenseVector((double[])Array$.MODULE$.ofDim(this.triK(), ClassTag$.MODULE$.Double())));
            this.initialized_$eq(true);
        }

        public Aggregator add(Instance instance) {
            Instance instance2 = instance;
            if (instance2 == null) {
                throw new MatchError((Object)instance2);
            }
            double l = instance2.label();
            double w = instance2.weight();
            Vector f = instance2.features();
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)l), (Object)BoxesRunTime.boxToDouble((double)w), (Object)f);
            Tuple3 tuple32 = tuple3;
            double l2 = BoxesRunTime.unboxToDouble((Object)tuple32._1());
            double w2 = BoxesRunTime.unboxToDouble((Object)tuple32._2());
            Vector f2 = (Vector)tuple32._3();
            int ak = f2.size();
            if (!this.initialized()) {
                this.init(ak);
            }
            Predef$.MODULE$.assert(ak == this.k(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Dimension mismatch. Expect vectors of size ").append(this.k()).append(" but got ").append(ak).append(".").toString());
            this.count_$eq(this.count() + 1L);
            this.wSum_$eq(this.wSum() + w2);
            this.wwSum_$eq(this.wwSum() + w2 * w2);
            this.bSum_$eq(this.bSum() + w2 * l2);
            this.bbSum_$eq(this.bbSum() + w2 * l2 * l2);
            BLAS$.MODULE$.axpy(w2, f2, (Vector)this.aSum());
            BLAS$.MODULE$.axpy(w2 * l2, f2, (Vector)this.abSum());
            BLAS$.MODULE$.spr(w2, f2, this.aaSum());
            return this;
        }

        public Aggregator merge(Aggregator other) {
            Aggregator aggregator;
            if (!other.initialized()) {
                aggregator = this;
            } else {
                if (!this.initialized()) {
                    this.init(other.k());
                }
                Predef$.MODULE$.assert(this.k() == other.k(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("dimension mismatch: this.k = ").append(this.k()).append(" but other.k = ").append(other.k()).toString());
                this.count_$eq(this.count() + other.count());
                this.wSum_$eq(this.wSum() + other.wSum());
                this.wwSum_$eq(this.wwSum() + other.wwSum());
                this.bSum_$eq(this.bSum() + other.bSum());
                this.bbSum_$eq(this.bbSum() + other.bbSum());
                BLAS$.MODULE$.axpy(1.0, (Vector)other.aSum(), (Vector)this.aSum());
                BLAS$.MODULE$.axpy(1.0, (Vector)other.abSum(), (Vector)this.abSum());
                BLAS$.MODULE$.axpy(1.0, (Vector)other.aaSum(), (Vector)this.aaSum());
                aggregator = this;
            }
            return aggregator;
        }

        public void validate() {
            Predef$.MODULE$.assert(this.initialized(), (Function0 & Serializable & scala.Serializable)() -> "Training dataset is empty.");
            Predef$.MODULE$.assert(this.wSum() > 0.0, (Function0 & Serializable & scala.Serializable)() -> "Sum of weights cannot be zero.");
        }

        /*
         * WARNING - void declaration
         */
        public DenseVector aBar() {
            void var1_1;
            DenseVector output = this.aSum().copy();
            BLAS$.MODULE$.scal(1.0 / this.wSum(), (Vector)output);
            return var1_1;
        }

        public double bBar() {
            return this.bSum() / this.wSum();
        }

        public double bbBar() {
            return this.bbSum() / this.wSum();
        }

        public double bStd() {
            double variance = package$.MODULE$.max(this.bbSum() / this.wSum() - this.bBar() * this.bBar(), 0.0);
            return package$.MODULE$.sqrt(variance);
        }

        /*
         * WARNING - void declaration
         */
        public DenseVector abBar() {
            void var1_1;
            DenseVector output = this.abSum().copy();
            BLAS$.MODULE$.scal(1.0 / this.wSum(), (Vector)output);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public DenseVector aaBar() {
            void var1_1;
            DenseVector output = this.aaSum().copy();
            BLAS$.MODULE$.scal(1.0 / this.wSum(), (Vector)output);
            return var1_1;
        }

        public DenseVector aStd() {
            double[] std = (double[])Array$.MODULE$.ofDim(this.k(), ClassTag$.MODULE$.Double());
            int i = 0;
            int j = 2;
            double[] aaValues = this.aaSum().values();
            while (i < this.triK()) {
                int l = j - 2;
                double aw = this.aSum().apply(l) / this.wSum();
                std[l] = package$.MODULE$.sqrt(package$.MODULE$.max(aaValues[i] / this.wSum() - aw * aw, 0.0));
                i += j;
                ++j;
            }
            return new DenseVector(std);
        }

        public DenseVector aVar() {
            double[] variance = (double[])Array$.MODULE$.ofDim(this.k(), ClassTag$.MODULE$.Double());
            int i = 0;
            int j = 2;
            double[] aaValues = this.aaSum().values();
            while (i < this.triK()) {
                int l = j - 2;
                double aw = this.aSum().apply(l) / this.wSum();
                variance[l] = package$.MODULE$.max(aaValues[i] / this.wSum() - aw * aw, 0.0);
                i += j;
                ++j;
            }
            return new DenseVector(variance);
        }
    }

    public static interface Solver {
    }
}

