/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.classification.NaiveBayes$;
import org.apache.spark.ml.classification.NaiveBayesModel$;
import org.apache.spark.ml.classification.NaiveBayesModel$NaiveBayesModelWriter$;
import org.apache.spark.ml.classification.NaiveBayesModel$NaiveBayesModelWriter$Data$;
import org.apache.spark.ml.classification.NaiveBayesParams;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.impl.Utils$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.util.VersionUtils$;
import org.json4s.DefaultFormats$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r}a\u0001\u0002%J\u0001QC\u0001\"\u001b\u0001\u0003\u0006\u0004%\tE\u001b\u0005\n\u0003\u0007\u0001!\u0011!Q\u0001\n-D!\"a\u0002\u0001\u0005\u000b\u0007I\u0011AA\u0005\u0011%\t\t\u0002\u0001B\u0001B\u0003%\u0011\f\u0003\u0006\u0002\u0016\u0001\u0011)\u0019!C\u0001\u0003/A!\"!\t\u0001\u0005\u0003\u0005\u000b\u0011BA\r\u0011)\t)\u0003\u0001BC\u0002\u0013\u0005\u0011q\u0003\u0005\u000b\u0003[\u0001!\u0011!Q\u0001\n\u0005e\u0001\u0002CA\u0019\u0001\u0011\u00051*a\r\t\u0015\u0005\u0015\u0003\u00011A\u0005\u00025\u000b9\u0005\u0003\u0006\u0002X\u0001\u0001\r\u0011\"\u0001N\u00033B\u0001\"!\u001a\u0001A\u0003&\u0011\u0011\n\u0005\t\u0003O\u0002A\u0011A'\u0002j!Q\u0011\u0011\u000f\u0001\t\u0006\u0004%I!a\u0006\t\u0015\u0005m\u0004\u0001#b\u0001\n\u0013\ti\b\u0003\u0006\u0002\b\u0002A)\u0019!C\u0005\u0003\u000fB\u0011\"a#\u0001\u0005\u0004%\t%!$\t\u0011\u0005m\u0005\u0001)A\u0005\u0003\u001fC\u0011\"a(\u0001\u0005\u0004%\t%!$\t\u0011\u0005\r\u0006\u0001)A\u0005\u0003\u001fCq!a*\u0001\t\u0013\tI\u000bC\u0004\u00020\u0002!I!!-\t\u000f\u0005U\u0006\u0001\"\u0003\u00028\"9\u00111\u0018\u0001\u0005\n\u0005u\u0006BCAa\u0001!\u0015\r\u0011\"\u0003\u0002D\"9\u0011Q\u001a\u0001\u0005B\u0005=\u0007bBAk\u0001\u0011E\u0013q\u001b\u0005\b\u0003;\u0004A\u0011IAp\u0011\u001d\t\u0019\u0010\u0001C!\u0003kDq!!?\u0001\t\u0003\nYpB\u0004\u0003\b%C\tA!\u0003\u0007\r!K\u0005\u0012\u0001B\u0006\u0011\u001d\t\t\u0004\tC\u0001\u0005?AqA!\t!\t\u0003\u0012\u0019\u0003C\u0004\u0003.\u0001\"\tEa\f\u0007\u000f\t]\u0002\u0005\u0001\u0011\u0003:!I!1\b\u0013\u0003\u0002\u0003\u0006Ia\u0018\u0005\b\u0003c!C\u0011\u0001B\u001f\r\u0019\u0011)\u0005\n#\u0003H!Q\u0011qA\u0014\u0003\u0016\u0004%\t!!\u0003\t\u0013\u0005EqE!E!\u0002\u0013I\u0006BCA\u000bO\tU\r\u0011\"\u0001\u0002\u0018!Q\u0011\u0011E\u0014\u0003\u0012\u0003\u0006I!!\u0007\t\u0015\u0005\u0015rE!f\u0001\n\u0003\t9\u0002\u0003\u0006\u0002.\u001d\u0012\t\u0012)A\u0005\u00033Aq!!\r(\t\u0003\u0011y\u0005C\u0005\u0002^\u001e\n\t\u0011\"\u0001\u0003\\!I!1M\u0014\u0012\u0002\u0013\u0005!Q\r\u0005\n\u0005s:\u0013\u0013!C\u0001\u0005wB\u0011Ba (#\u0003%\tAa\u001f\t\u0013\t\u0005u%!A\u0005B\t\r\u0005\"\u0003BJO\u0005\u0005I\u0011AAG\u0011%\u0011)jJA\u0001\n\u0003\u00119\nC\u0005\u0003\"\u001e\n\t\u0011\"\u0011\u0003$\"I!\u0011W\u0014\u0002\u0002\u0013\u0005!1\u0017\u0005\n\u0005{;\u0013\u0011!C!\u0005\u007fC\u0011\"a=(\u0003\u0003%\tE!1\t\u0013\t\rw%!A\u0005B\t\u0015w!\u0003BeI\u0005\u0005\t\u0012\u0002Bf\r%\u0011)\u0005JA\u0001\u0012\u0013\u0011i\rC\u0004\u00022q\"\tAa7\t\u0013\u0005MH(!A\u0005F\t\u0005\u0007\"\u0003Boy\u0005\u0005I\u0011\u0011Bp\u0011%\u00119\u000fPA\u0001\n\u0003\u0013I\u000fC\u0004\u0003|\u0012\"\tF!@\u0007\r\r\u0005\u0001\u0005BB\u0002\u0011\u001d\t\tD\u0011C\u0001\u0007\u000bA\u0011b!\u0003C\u0005\u0004%IAa!\t\u0011\r-!\t)A\u0005\u0005\u000bCqA!\fC\t\u0003\u001ai\u0001C\u0005\u0004\u0012\u0001\n\t\u0011\"\u0003\u0004\u0014\tya*Y5wK\n\u000b\u00170Z:N_\u0012,GN\u0003\u0002K\u0017\u0006q1\r\\1tg&4\u0017nY1uS>t'B\u0001'N\u0003\tiGN\u0003\u0002O\u001f\u0006)1\u000f]1sW*\u0011\u0001+U\u0001\u0007CB\f7\r[3\u000b\u0003I\u000b1a\u001c:h\u0007\u0001\u0019B\u0001A+aGB!akV-`\u001b\u0005I\u0015B\u0001-J\u0005\u0001\u0002&o\u001c2bE&d\u0017n\u001d;jG\u000ec\u0017m]:jM&\u001c\u0017\r^5p]6{G-\u001a7\u0011\u0005ikV\"A.\u000b\u0005q[\u0015A\u00027j]\u0006dw-\u0003\u0002_7\n1a+Z2u_J\u0004\"A\u0016\u0001\u0011\u0005Y\u000b\u0017B\u00012J\u0005Aq\u0015-\u001b<f\u0005\u0006LXm\u001d)be\u0006l7\u000f\u0005\u0002eO6\tQM\u0003\u0002g\u0017\u0006!Q\u000f^5m\u0013\tAWM\u0001\u0006N\u0019^\u0013\u0018\u000e^1cY\u0016\f1!^5e+\u0005Y\u0007C\u00017v\u001d\ti7\u000f\u0005\u0002oc6\tqN\u0003\u0002q'\u00061AH]8pizR\u0011A]\u0001\u0006g\u000e\fG.Y\u0005\u0003iF\fa\u0001\u0015:fI\u00164\u0017B\u0001<x\u0005\u0019\u0019FO]5oO*\u0011A/\u001d\u0015\u0004\u0003e|\bC\u0001>~\u001b\u0005Y(B\u0001?N\u0003)\tgN\\8uCRLwN\\\u0005\u0003}n\u0014QaU5oG\u0016\f#!!\u0001\u0002\u000bErSG\f\u0019\u0002\tULG\r\t\u0015\u0004\u0005e|\u0018A\u00019j+\u0005I\u0006\u0006B\u0002z\u0003\u001b\t#!a\u0004\u0002\u000bIr\u0003G\f\u0019\u0002\u0007AL\u0007\u0005\u000b\u0003\u0005s\u00065\u0011!\u0002;iKR\fWCAA\r!\rQ\u00161D\u0005\u0004\u0003;Y&AB'biJL\u0007\u0010\u000b\u0003\u0006s\u00065\u0011A\u0002;iKR\f\u0007\u0005\u000b\u0003\u0007s\u00065\u0011!B:jO6\f\u0007\u0006B\u0004z\u0003S\t#!a\u000b\u0002\u000bMr\u0003G\f\u0019\u0002\rMLw-\\1!Q\u0011A\u00110!\u000b\u0002\rqJg.\u001b;?)%y\u0016QGA\u001d\u0003{\t\t\u0005C\u0003j\u0013\u0001\u00071\u000e\u000b\u0003\u00026e|\bBBA\u0004\u0013\u0001\u0007\u0011\fK\u0003\u0002:e\fi\u0001C\u0004\u0002\u0016%\u0001\r!!\u0007)\u000b\u0005u\u00120!\u0004\t\u000f\u0005\u0015\u0012\u00021\u0001\u0002\u001a!*\u0011\u0011I=\u0002*\u0005Iq\u000e\u001c3MC\n,Gn]\u000b\u0003\u0003\u0013\u0002b!a\u0013\u0002N\u0005ES\"A9\n\u0007\u0005=\u0013OA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002L\u0005M\u0013bAA+c\n1Ai\\;cY\u0016\fQb\u001c7e\u0019\u0006\u0014W\r\\:`I\u0015\fH\u0003BA.\u0003C\u0002B!a\u0013\u0002^%\u0019\u0011qL9\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003GZ\u0011\u0011!a\u0001\u0003\u0013\n1\u0001\u001f\u00132\u0003)yG\u000e\u001a'bE\u0016d7\u000fI\u0001\rg\u0016$x\n\u001c3MC\n,Gn\u001d\u000b\u0005\u0003W\ni'D\u0001\u0001\u0011\u001d\ty'\u0004a\u0001\u0003\u0013\na\u0001\\1cK2\u001c\u0018A\u0005;iKR\fW*\u001b8vg:+w\r\u00165fi\u0006D3ADA;!\u0011\tY%a\u001e\n\u0007\u0005e\u0014OA\u0005ue\u0006t7/[3oi\u0006y\u0001/['j]V\u001cH\u000b[3uCN+X.\u0006\u0002\u0002\u0000A\u0019!,!!\n\u0007\u0005\r5LA\u0006EK:\u001cXMV3di>\u0014\bfA\b\u0002v\u0005IAn\\4WCJ\u001cV/\u001c\u0015\u0004!\u0005U\u0014a\u00038v[\u001a+\u0017\r^;sKN,\"!a$\u0011\t\u0005-\u0013\u0011S\u0005\u0004\u0003'\u000b(aA%oi\"\"\u0011#_ALC\t\tI*A\u00032]Yr\u0003'\u0001\u0007ok64U-\u0019;ve\u0016\u001c\b\u0005\u000b\u0003\u0013s\u0006]\u0015A\u00038v[\u000ec\u0017m]:fg\"\u001a1#_@\u0002\u00179,Xn\u00117bgN,7\u000f\t\u0015\u0004)e|\u0018AF7vYRLgn\\7jC2\u001c\u0015\r\\2vY\u0006$\u0018n\u001c8\u0015\t\u0005}\u00141\u0016\u0005\u0007\u0003[+\u0002\u0019A-\u0002\u0011\u0019,\u0017\r^;sKN\fQcY8na2,W.\u001a8u\u0007\u0006d7-\u001e7bi&|g\u000eF\u0002Z\u0003gCa!!,\u0017\u0001\u0004I\u0016\u0001\u00062fe:|W\u000f\u001c7j\u0007\u0006d7-\u001e7bi&|g\u000e\u0006\u0003\u0002\u0000\u0005e\u0006BBAW/\u0001\u0007\u0011,A\nhCV\u001c8/[1o\u0007\u0006d7-\u001e7bi&|g\u000eF\u0002Z\u0003\u007fCa!!,\u0019\u0001\u0004I\u0016A\u00049sK\u0012L7\r\u001e*bo\u001a+hnY\u000b\u0003\u0003\u000b\u0004b!a\u0013\u0002HfK\u0016bAAec\nIa)\u001e8di&|g.\r\u0015\u00043\u0005U\u0014A\u00039sK\u0012L7\r\u001e*boR\u0019\u0011,!5\t\r\u00055&\u00041\u0001ZQ\u0011Q\u00120!\u000b\u0002-I\fwO\r9s_\n\f'-\u001b7jifLe\u000e\u00157bG\u0016$2!WAm\u0011\u0019\tYn\u0007a\u00013\u0006i!/Y<Qe\u0016$\u0017n\u0019;j_:\fAaY8qsR\u0019q,!9\t\u000f\u0005\rH\u00041\u0001\u0002f\u0006)Q\r\u001f;sCB!\u0011q]Aw\u001b\t\tIOC\u0002\u0002l.\u000bQ\u0001]1sC6LA!a<\u0002j\nA\u0001+\u0019:b[6\u000b\u0007\u000fK\u0002\u001ds~\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002W\"\u001aQ$_@\u0002\u000b]\u0014\u0018\u000e^3\u0016\u0005\u0005u\bc\u00013\u0002\u0000&\u0019!\u0011A3\u0003\u00115cuK]5uKJDCAH=\u0002\u0018\"\u001a\u0001!_@\u0002\u001f9\u000b\u0017N^3CCf,7/T8eK2\u0004\"A\u0016\u0011\u0014\u000f\u0001\u0012iAa\u0005\u0003\u001aA!\u00111\nB\b\u0013\r\u0011\t\"\u001d\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0011\u0014)bX\u0005\u0004\u0005/)'AC'M%\u0016\fG-\u00192mKB!\u00111\nB\u000e\u0013\r\u0011i\"\u001d\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0005\u0013\tAA]3bIV\u0011!Q\u0005\t\u0005I\n\u001dr,C\u0002\u0003*\u0015\u0014\u0001\"\u0014'SK\u0006$WM\u001d\u0015\u0005Ee\f9*\u0001\u0003m_\u0006$GcA0\u00032!1!1G\u0012A\u0002-\fA\u0001]1uQ\"\"1%_AL\u0005Uq\u0015-\u001b<f\u0005\u0006LXm]'pI\u0016dwK]5uKJ\u001c2\u0001JA\u007f\u0003!Ign\u001d;b]\u000e,G\u0003\u0002B \u0005\u0007\u00022A!\u0011%\u001b\u0005\u0001\u0003B\u0002B\u001eM\u0001\u0007qL\u0001\u0003ECR\f7cB\u0014\u0003\u000e\t%#\u0011\u0004\t\u0005\u0003\u0017\u0012Y%C\u0002\u0003NE\u0014q\u0001\u0015:pIV\u001cG\u000f\u0006\u0005\u0003R\tU#q\u000bB-!\r\u0011\u0019fJ\u0007\u0002I!1\u0011q\u0001\u0018A\u0002eCq!!\u0006/\u0001\u0004\tI\u0002C\u0004\u0002&9\u0002\r!!\u0007\u0015\u0011\tE#Q\fB0\u0005CB\u0001\"a\u00020!\u0003\u0005\r!\u0017\u0005\n\u0003+y\u0003\u0013!a\u0001\u00033A\u0011\"!\n0!\u0003\u0005\r!!\u0007\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!q\r\u0016\u00043\n%4F\u0001B6!\u0011\u0011iG!\u001e\u000e\u0005\t=$\u0002\u0002B9\u0005g\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005q\f\u0018\u0002\u0002B<\u0005_\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"A! +\t\u0005e!\u0011N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!Q\u0011\t\u0005\u0005\u000f\u0013\t*\u0004\u0002\u0003\n*!!1\u0012BG\u0003\u0011a\u0017M\\4\u000b\u0005\t=\u0015\u0001\u00026bm\u0006L1A\u001eBE\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!'\u0003 B!\u00111\nBN\u0013\r\u0011i*\u001d\u0002\u0004\u0003:L\b\"CA2k\u0005\u0005\t\u0019AAH\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001BS!\u0019\u00119K!,\u0003\u001a6\u0011!\u0011\u0016\u0006\u0004\u0005W\u000b\u0018AC2pY2,7\r^5p]&!!q\u0016BU\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\tU&1\u0018\t\u0005\u0003\u0017\u00129,C\u0002\u0003:F\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0002d]\n\t\u00111\u0001\u0003\u001a\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002\u0010R\u0011!QQ\u0001\u0007KF,\u0018\r\\:\u0015\t\tU&q\u0019\u0005\n\u0003GR\u0014\u0011!a\u0001\u00053\u000bA\u0001R1uCB\u0019!1\u000b\u001f\u0014\u000bq\u0012yM!\u0007\u0011\u0017\tE'q[-\u0002\u001a\u0005e!\u0011K\u0007\u0003\u0005'T1A!6r\u0003\u001d\u0011XO\u001c;j[\u0016LAA!7\u0003T\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0015\u0005\t-\u0017!B1qa2LH\u0003\u0003B)\u0005C\u0014\u0019O!:\t\r\u0005\u001dq\b1\u0001Z\u0011\u001d\t)b\u0010a\u0001\u00033Aq!!\n@\u0001\u0004\tI\"A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t-(q\u001f\t\u0007\u0003\u0017\u0012iO!=\n\u0007\t=\u0018O\u0001\u0004PaRLwN\u001c\t\n\u0003\u0017\u0012\u00190WA\r\u00033I1A!>r\u0005\u0019!V\u000f\u001d7fg!I!\u0011 !\u0002\u0002\u0003\u0007!\u0011K\u0001\u0004q\u0012\u0002\u0014\u0001C:bm\u0016LU\u000e\u001d7\u0015\t\u0005m#q \u0005\u0007\u0005g\t\u0005\u0019A6\u0003+9\u000b\u0017N^3CCf,7/T8eK2\u0014V-\u00193feN\u0019!I!\n\u0015\u0005\r\u001d\u0001c\u0001B!\u0005\u0006I1\r\\1tg:\u000bW.Z\u0001\u000bG2\f7o\u001d(b[\u0016\u0004CcA0\u0004\u0010!1!1\u0007$A\u0002-\f1B]3bIJ+7o\u001c7wKR\u00111Q\u0003\t\u0005\u0005\u000f\u001b9\"\u0003\u0003\u0004\u001a\t%%AB(cU\u0016\u001cG\u000f\u000b\u0003!s\u0006]\u0005\u0006B\u0010z\u0003/\u0003")
public class NaiveBayesModel
extends ProbabilisticClassificationModel<Vector, NaiveBayesModel>
implements NaiveBayesParams,
MLWritable {
    private transient Matrix thetaMinusNegTheta;
    private transient DenseVector piMinusThetaSum;
    private transient double[] logVarSum;
    private transient Function1<Vector, Vector> predictRawFunc;
    private final String uid;
    private final Vector pi;
    private final Matrix theta;
    private final Matrix sigma;
    private double[] oldLabels;
    private final int numFeatures;
    private final int numClasses;
    private final DoubleParam smoothing;
    private final Param<String> modelType;
    private final Param<String> weightCol;
    private volatile transient byte bitmap$trans$0;

    public static NaiveBayesModel load(String string) {
        return NaiveBayesModel$.MODULE$.load(string);
    }

    public static MLReader<NaiveBayesModel> read() {
        return NaiveBayesModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final double getSmoothing() {
        return NaiveBayesParams.getSmoothing$(this);
    }

    @Override
    public final String getModelType() {
        return NaiveBayesParams.getModelType$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final DoubleParam smoothing() {
        return this.smoothing;
    }

    @Override
    public final Param<String> modelType() {
        return this.modelType;
    }

    @Override
    public final void org$apache$spark$ml$classification$NaiveBayesParams$_setter_$smoothing_$eq(DoubleParam x$1) {
        this.smoothing = x$1;
    }

    @Override
    public final void org$apache$spark$ml$classification$NaiveBayesParams$_setter_$modelType_$eq(Param<String> x$1) {
        this.modelType = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector pi() {
        return this.pi;
    }

    public Matrix theta() {
        return this.theta;
    }

    public Matrix sigma() {
        return this.sigma;
    }

    public double[] oldLabels() {
        return this.oldLabels;
    }

    public void oldLabels_$eq(double[] x$1) {
        this.oldLabels = x$1;
    }

    public NaiveBayesModel setOldLabels(double[] labels) {
        this.oldLabels_$eq(labels);
        return this;
    }

    private Matrix thetaMinusNegTheta$lzycompute() {
        NaiveBayesModel naiveBayesModel = this;
        synchronized (naiveBayesModel) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                String string = this.$(this.modelType());
                String string2 = NaiveBayes$.MODULE$.Bernoulli();
                String string3 = string;
                if (string2 != null ? !string2.equals(string3) : string3 != null) {
                    throw new IllegalArgumentException(new StringBuilder(93).append("Invalid modelType: ").append((Object)this.$(this.modelType())).append(". ").append("Variables thetaMinusNegTheta should only be precomputed in Bernoulli NB.").toString());
                }
                Matrix matrix = this.theta().map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)value -> value - scala.math.package$.MODULE$.log1p(-scala.math.package$.MODULE$.exp(value)));
                this.thetaMinusNegTheta = matrix;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.thetaMinusNegTheta;
    }

    private Matrix thetaMinusNegTheta() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.thetaMinusNegTheta$lzycompute() : this.thetaMinusNegTheta;
    }

    private DenseVector piMinusThetaSum$lzycompute() {
        NaiveBayesModel naiveBayesModel = this;
        synchronized (naiveBayesModel) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                String string = this.$(this.modelType());
                String string2 = NaiveBayes$.MODULE$.Bernoulli();
                String string3 = string;
                if (string2 != null ? !string2.equals(string3) : string3 != null) {
                    throw new IllegalArgumentException(new StringBuilder(90).append("Invalid modelType: ").append((Object)this.$(this.modelType())).append(". ").append("Variables piMinusThetaSum should only be precomputed in Bernoulli NB.").toString());
                }
                Matrix negTheta = this.theta().map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)value -> scala.math.package$.MODULE$.log1p(-scala.math.package$.MODULE$.exp(value)));
                DenseVector ones = new DenseVector((double[])Array$.MODULE$.fill(this.theta().numCols(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0, ClassTag$.MODULE$.Double()));
                DenseVector piMinusThetaSum = this.pi().toDense().copy();
                BLAS$.MODULE$.gemv(1.0, negTheta, (Vector)ones, 1.0, piMinusThetaSum);
                DenseVector denseVector = piMinusThetaSum;
                this.piMinusThetaSum = denseVector;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.piMinusThetaSum;
    }

    private DenseVector piMinusThetaSum() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.piMinusThetaSum$lzycompute() : this.piMinusThetaSum;
    }

    private double[] logVarSum$lzycompute() {
        NaiveBayesModel naiveBayesModel = this;
        synchronized (naiveBayesModel) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                String string = this.$(this.modelType());
                String string2 = NaiveBayes$.MODULE$.Gaussian();
                String string3 = string;
                if (string2 != null ? !string2.equals(string3) : string3 != null) {
                    throw new IllegalArgumentException(new StringBuilder(83).append("Invalid modelType: ").append((Object)this.$(this.modelType())).append(". ").append("Variables logVarSum should only be precomputed in Gaussian NB.").toString());
                }
                double[] dArray = (double[])Array$.MODULE$.tabulate(this.numClasses(), (Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> BoxesRunTime.unboxToDouble((Object)package$.MODULE$.Iterator().range(0, this.numFeatures()).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)j -> scala.math.package$.MODULE$.log(this.sigma().apply(i, j))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)), ClassTag$.MODULE$.Double());
                this.logVarSum = dArray;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.logVarSum;
    }

    private double[] logVarSum() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.logVarSum$lzycompute() : this.logVarSum;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    /*
     * WARNING - void declaration
     */
    private DenseVector multinomialCalculation(Vector features) {
        void var2_2;
        NaiveBayes$.MODULE$.requireNonnegativeValues(features);
        DenseVector prob = this.pi().toDense().copy();
        BLAS$.MODULE$.gemv(1.0, this.theta(), features, 1.0, prob);
        return var2_2;
    }

    private Vector complementCalculation(Vector features) {
        int j;
        NaiveBayes$.MODULE$.requireNonnegativeValues(features);
        double[] probArray = this.theta().multiply(features).toArray();
        double max = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(probArray)).max((Ordering)Ordering.Double$.MODULE$));
        double sumExp = 0.0;
        for (j = 0; j < probArray.length; ++j) {
            sumExp += scala.math.package$.MODULE$.exp(probArray[j] - max);
        }
        double logSumExp = scala.math.package$.MODULE$.log(sumExp) + max;
        for (j = 0; j < probArray.length; ++j) {
            probArray[j] = probArray[j] - logSumExp;
        }
        return Vectors$.MODULE$.dense(probArray);
    }

    /*
     * WARNING - void declaration
     */
    private DenseVector bernoulliCalculation(Vector features) {
        void var2_2;
        NaiveBayes$.MODULE$.requireZeroOneBernoulliValues(features);
        DenseVector prob = this.piMinusThetaSum().copy();
        BLAS$.MODULE$.gemv(1.0, this.thetaMinusNegTheta(), features, 1.0, prob);
        return var2_2;
    }

    private Vector gaussianCalculation(Vector features) {
        double[] prob = (double[])Array$.MODULE$.ofDim(this.numClasses(), ClassTag$.MODULE$.Double());
        for (int i = 0; i < this.numClasses(); ++i) {
            double s = 0.0;
            for (int j = 0; j < this.numFeatures(); ++j) {
                double d = features.apply(j) - this.theta().apply(i, j);
                s += d * d / this.sigma().apply(i, j);
            }
            prob[i] = this.pi().apply(i) - (s + this.logVarSum()[i]) / (double)2;
        }
        return Vectors$.MODULE$.dense(prob);
    }

    private Function1<Vector, Vector> predictRawFunc$lzycompute() {
        NaiveBayesModel naiveBayesModel = this;
        synchronized (naiveBayesModel) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                Function1 & Serializable & scala.Serializable intersect;
                String string = this.$(this.modelType());
                String string2 = NaiveBayes$.MODULE$.Multinomial();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    intersect = (Function1 & Serializable & scala.Serializable)features -> this.multinomialCalculation((Vector)features);
                } else {
                    String string4 = NaiveBayes$.MODULE$.Complement();
                    String string5 = string;
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        intersect = (Function1 & Serializable & scala.Serializable)features -> this.complementCalculation((Vector)features);
                    } else {
                        String string6 = NaiveBayes$.MODULE$.Bernoulli();
                        String string7 = string;
                        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                            intersect = (Function1 & Serializable & scala.Serializable)features -> this.bernoulliCalculation((Vector)features);
                        } else {
                            String string8 = NaiveBayes$.MODULE$.Gaussian();
                            String string9 = string;
                            if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                                intersect = (Function1 & Serializable & scala.Serializable)features -> this.gaussianCalculation((Vector)features);
                            } else {
                                throw new MatchError((Object)string);
                            }
                        }
                    }
                }
                this.predictRawFunc = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.predictRawFunc;
    }

    private Function1<Vector, Vector> predictRawFunc() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.predictRawFunc$lzycompute() : this.predictRawFunc;
    }

    @Override
    public Vector predictRaw(Vector features) {
        return (Vector)this.predictRawFunc().apply((Object)features);
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (!(vector instanceof DenseVector)) {
            if (vector instanceof SparseVector) {
                throw new RuntimeException("Unexpected error in NaiveBayesModel: raw2probabilityInPlace encountered SparseVector");
            }
            throw new MatchError((Object)vector);
        }
        DenseVector denseVector = (DenseVector)vector;
        Utils$.MODULE$.softmax(denseVector.values());
        DenseVector denseVector2 = denseVector;
        return denseVector2;
    }

    @Override
    public NaiveBayesModel copy(ParamMap extra) {
        return (NaiveBayesModel)this.copyValues(new NaiveBayesModel(this.uid(), this.pi(), this.theta(), this.sigma()).setParent(this.parent()), extra);
    }

    @Override
    public String toString() {
        return new StringBuilder(60).append("NaiveBayesModel: uid=").append(this.uid()).append(", modelType=").append((Object)this.$(this.modelType())).append(", numClasses=").append(this.numClasses()).append(", ").append("numFeatures=").append(this.numFeatures()).toString();
    }

    @Override
    public MLWriter write() {
        return new NaiveBayesModelWriter(this);
    }

    public NaiveBayesModel(String uid, Vector pi, Matrix theta, Matrix sigma) {
        this.uid = uid;
        this.pi = pi;
        this.theta = theta;
        this.sigma = sigma;
        HasWeightCol.$init$(this);
        NaiveBayesParams.$init$(this);
        MLWritable.$init$(this);
        this.oldLabels = null;
        this.numFeatures = theta.numCols();
        this.numClasses = pi.size();
    }

    private static class NaiveBayesModelReader
    extends MLReader<NaiveBayesModel> {
        private final String className = NaiveBayesModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public NaiveBayesModel load(String path) {
            NaiveBayesModel naiveBayesModel;
            DefaultParamsReader.Metadata metadata;
            block10: {
                Matrix matrix;
                Vector vector;
                Object sigma;
                block12: {
                    Row row;
                    block11: {
                        Dataset<Row> vecConverted;
                        block7: {
                            Vector vector2;
                            Object theta;
                            block9: {
                                Row row2;
                                block8: {
                                    DefaultFormats$ format = DefaultFormats$.MODULE$;
                                    metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
                                    Tuple2 tuple2 = VersionUtils$.MODULE$.majorMinorVersion(metadata.sparkVersion());
                                    if (tuple2 == null) {
                                        throw new MatchError((Object)tuple2);
                                    }
                                    int major = tuple2._1$mcI$sp();
                                    int minor = tuple2._2$mcI$sp();
                                    Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(major, minor);
                                    Tuple2.mcII.sp sp3 = sp2;
                                    int major2 = sp3._1$mcI$sp();
                                    int minor2 = sp3._2$mcI$sp();
                                    String dataPath = new Path(path, "data").toString();
                                    Dataset data = this.sparkSession().read().parquet(dataPath);
                                    vecConverted = MLUtils$.MODULE$.convertVectorColumnsToML(data, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"pi"}));
                                    if (major2 >= 3) break block7;
                                    row2 = (Row)MLUtils$.MODULE$.convertMatrixColumnsToML(vecConverted, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"theta"})).select("pi", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"theta"})).head();
                                    Some some = Row$.MODULE$.unapplySeq(row2);
                                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block8;
                                    Object pi = ((SeqLike)some.get()).apply(0);
                                    theta = ((SeqLike)some.get()).apply(1);
                                    if (!(pi instanceof Vector)) break block8;
                                    vector2 = (Vector)pi;
                                    if (theta instanceof Matrix) break block9;
                                }
                                throw new MatchError((Object)row2);
                            }
                            Matrix matrix2 = (Matrix)theta;
                            Tuple2 tuple2 = new Tuple2((Object)vector2, (Object)matrix2);
                            Tuple2 tuple22 = tuple2;
                            Vector pi = (Vector)tuple22._1();
                            Matrix theta2 = (Matrix)tuple22._2();
                            naiveBayesModel = new NaiveBayesModel(metadata.uid(), pi, theta2, Matrices$.MODULE$.zeros(0, 0));
                            break block10;
                        }
                        row = (Row)MLUtils$.MODULE$.convertMatrixColumnsToML(vecConverted, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"theta", "sigma"})).select("pi", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"theta", "sigma"})).head();
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) break block11;
                        Object pi = ((SeqLike)some.get()).apply(0);
                        Object theta = ((SeqLike)some.get()).apply(1);
                        sigma = ((SeqLike)some.get()).apply(2);
                        if (!(pi instanceof Vector)) break block11;
                        vector = (Vector)pi;
                        if (!(theta instanceof Matrix)) break block11;
                        matrix = (Matrix)theta;
                        if (sigma instanceof Matrix) break block12;
                    }
                    throw new MatchError((Object)row);
                }
                Matrix matrix3 = (Matrix)sigma;
                Tuple3 tuple3 = new Tuple3((Object)vector, (Object)matrix, (Object)matrix3);
                Tuple3 tuple32 = tuple3;
                Vector pi = (Vector)tuple32._1();
                Matrix theta = (Matrix)tuple32._2();
                Matrix sigma2 = (Matrix)tuple32._3();
                naiveBayesModel = new NaiveBayesModel(metadata.uid(), pi, theta, sigma2);
            }
            NaiveBayesModel model = naiveBayesModel;
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class NaiveBayesModelWriter
    extends MLWriter {
        private volatile NaiveBayesModel$NaiveBayesModelWriter$Data$ Data$module;
        private final NaiveBayesModel instance;

        private NaiveBayesModel$NaiveBayesModelWriter$Data$ Data() {
            if (this.Data$module == null) {
                this.Data$lzycompute$1();
            }
            return this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            boolean bl;
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            String dataPath = new Path(path, "data").toString();
            String string = this.instance.getModelType();
            String string2 = NaiveBayes$.MODULE$.Multinomial();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                bl = true;
            } else {
                String string4 = NaiveBayes$.MODULE$.Bernoulli();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    bl = true;
                } else {
                    String string6 = NaiveBayes$.MODULE$.Complement();
                    String string7 = string;
                    bl = !(string6 != null ? !string6.equals(string7) : string7 != null);
                }
            }
            if (bl) {
                Predef$.MODULE$.require(this.instance.sigma().numRows() == 0 && this.instance.sigma().numCols() == 0);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                String string8 = NaiveBayes$.MODULE$.Gaussian();
                String string9 = string;
                if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                    Predef$.MODULE$.require(this.instance.sigma().numRows() != 0 && this.instance.sigma().numCols() != 0);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)string);
                }
            }
            Data data = new Data(this, this.instance.pi(), this.instance.theta(), this.instance.sigma());
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(NaiveBayesModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_classification_NaiveBayesModel$NaiveBayesModelWriter$$typecreator1$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.classification.NaiveBayesModel.NaiveBayesModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.classification.NaiveBayesModel.NaiveBayesModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_classification_NaiveBayesModel$NaiveBayesModelWriter$$typecreator1$2(NaiveBayesModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)new .colon.colon((Object)data, (List)Nil$.MODULE$), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_NaiveBayesModel$NaiveBayesModelWriter$$typecreator1$2(null))).repartition(1).write().parquet(dataPath);
        }

        private final void Data$lzycompute$1() {
            NaiveBayesModelWriter naiveBayesModelWriter = this;
            synchronized (naiveBayesModelWriter) {
                if (this.Data$module == null) {
                    this.Data$module = new NaiveBayesModel$NaiveBayesModelWriter$Data$(this);
                }
            }
        }

        public NaiveBayesModelWriter(NaiveBayesModel instance) {
            this.instance = instance;
        }

        private class Data
        implements Product,
        scala.Serializable {
            private final Vector pi;
            private final Matrix theta;
            private final Matrix sigma;
            public final /* synthetic */ NaiveBayesModelWriter $outer;

            public Vector pi() {
                return this.pi;
            }

            public Matrix theta() {
                return this.theta;
            }

            public Matrix sigma() {
                return this.sigma;
            }

            public Data copy(Vector pi, Matrix theta, Matrix sigma) {
                return new Data(this.org$apache$spark$ml$classification$NaiveBayesModel$NaiveBayesModelWriter$Data$$$outer(), pi, theta, sigma);
            }

            public Vector copy$default$1() {
                return this.pi();
            }

            public Matrix copy$default$2() {
                return this.theta();
            }

            public Matrix copy$default$3() {
                return this.sigma();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                Vector vector;
                int n = x$1;
                switch (n) {
                    case 0: {
                        vector = this.pi();
                        break;
                    }
                    case 1: {
                        vector = this.theta();
                        break;
                    }
                    case 2: {
                        vector = this.sigma();
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(Integer.toString(x$1));
                    }
                }
                return vector;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                if (((Data)object).org$apache$spark$ml$classification$NaiveBayesModel$NaiveBayesModelWriter$Data$$$outer() != this.org$apache$spark$ml$classification$NaiveBayesModel$NaiveBayesModelWriter$Data$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                Vector vector = this.pi();
                Vector vector2 = data.pi();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                Matrix matrix = this.theta();
                Matrix matrix2 = data.theta();
                if (matrix == null) {
                    if (matrix2 != null) {
                        return false;
                    }
                } else if (!matrix.equals(matrix2)) return false;
                Matrix matrix3 = this.sigma();
                Matrix matrix4 = data.sigma();
                if (matrix3 == null) {
                    if (matrix4 != null) {
                        return false;
                    }
                } else if (!matrix3.equals(matrix4)) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ NaiveBayesModelWriter org$apache$spark$ml$classification$NaiveBayesModel$NaiveBayesModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(NaiveBayesModelWriter $outer, Vector pi, Matrix theta, Matrix sigma) {
                this.pi = pi;
                this.theta = theta;
                this.sigma = sigma;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

