/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.optimization.GradientDescent;
import org.apache.spark.mllib.optimization.LeastSquaresGradient;
import org.apache.spark.mllib.optimization.SimpleUpdater;
import org.apache.spark.mllib.regression.GeneralizedLinearAlgorithm;
import org.apache.spark.mllib.regression.LinearRegressionModel;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001B\u000b\u0017\u0001\u0005B\u0001b\f\u0001\u0003\u0002\u0004%I\u0001\r\u0005\ti\u0001\u0011\t\u0019!C\u0005k!A1\b\u0001B\u0001B\u0003&\u0011\u0007\u0003\u0005=\u0001\t\u0005\r\u0011\"\u0003>\u0011!\t\u0005A!a\u0001\n\u0013\u0011\u0005\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0015\u0002 \t\u0011\u0015\u0003!\u00111A\u0005\nAB\u0001B\u0012\u0001\u0003\u0002\u0004%Ia\u0012\u0005\t\u0013\u0002\u0011\t\u0011)Q\u0005c!A!\n\u0001BA\u0002\u0013%\u0001\u0007\u0003\u0005L\u0001\t\u0005\r\u0011\"\u0003M\u0011!q\u0005A!A!B\u0013\t\u0004BB(\u0001\t\u0003A\u0002\u000bC\u0004W\u0001\t\u0007I\u0011B,\t\ry\u0003\u0001\u0015!\u0003Y\u0011\u001dy\u0006A1A\u0005\n\u0001Da\u0001\u001a\u0001!\u0002\u0013\t\u0007bB3\u0001\u0005\u0004%\tE\u001a\u0005\u0007g\u0002\u0001\u000b\u0011B4\t\rU\u0004A\u0011\u000b\rw\u0005]a\u0015N\\3beJ+wM]3tg&|gnV5uQN;EI\u0003\u0002\u00181\u0005Q!/Z4sKN\u001c\u0018n\u001c8\u000b\u0005eQ\u0012!B7mY&\u0014'BA\u000e\u001d\u0003\u0015\u0019\b/\u0019:l\u0015\tib$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002?\u0005\u0019qN]4\u0004\u0001M\u0019\u0001AI\u0015\u0011\u0007\r\"c%D\u0001\u0017\u0013\t)cC\u0001\u000eHK:,'/\u00197ju\u0016$G*\u001b8fCJ\fEnZ8sSRDW\u000e\u0005\u0002$O%\u0011\u0001F\u0006\u0002\u0016\u0019&tW-\u0019:SK\u001e\u0014Xm]:j_:lu\u000eZ3m!\tQS&D\u0001,\u0015\u0005a\u0013!B:dC2\f\u0017B\u0001\u0018,\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003!\u0019H/\u001a9TSj,W#A\u0019\u0011\u0005)\u0012\u0014BA\u001a,\u0005\u0019!u.\u001e2mK\u0006a1\u000f^3q'&TXm\u0018\u0013fcR\u0011a'\u000f\t\u0003U]J!\u0001O\u0016\u0003\tUs\u0017\u000e\u001e\u0005\bu\t\t\t\u00111\u00012\u0003\rAH%M\u0001\ngR,\u0007oU5{K\u0002\nQB\\;n\u0013R,'/\u0019;j_:\u001cX#\u0001 \u0011\u0005)z\u0014B\u0001!,\u0005\rIe\u000e^\u0001\u0012]Vl\u0017\n^3sCRLwN\\:`I\u0015\fHC\u0001\u001cD\u0011\u001dQT!!AA\u0002y\naB\\;n\u0013R,'/\u0019;j_:\u001c\b%\u0001\u0005sK\u001e\u0004\u0016M]1n\u00031\u0011Xm\u001a)be\u0006lw\fJ3r)\t1\u0004\nC\u0004;\u0011\u0005\u0005\t\u0019A\u0019\u0002\u0013I,w\rU1sC6\u0004\u0013!E7j]&\u0014\u0015\r^2i\rJ\f7\r^5p]\u0006)R.\u001b8j\u0005\u0006$8\r\u001b$sC\u000e$\u0018n\u001c8`I\u0015\fHC\u0001\u001cN\u0011\u001dQ4\"!AA\u0002E\n!#\\5oS\n\u000bGo\u00195Ge\u0006\u001cG/[8oA\u00051A(\u001b8jiz\"R!\u0015*T)V\u0003\"a\t\u0001\t\u000b=j\u0001\u0019A\u0019\t\u000bqj\u0001\u0019\u0001 \t\u000b\u0015k\u0001\u0019A\u0019\t\u000b)k\u0001\u0019A\u0019\u0002\u0011\u001d\u0014\u0018\rZ5f]R,\u0012\u0001\u0017\t\u00033rk\u0011A\u0017\u0006\u00037b\tAb\u001c9uS6L'0\u0019;j_:L!!\u0018.\u0003)1+\u0017m\u001d;TcV\f'/Z:He\u0006$\u0017.\u001a8u\u0003%9'/\u00193jK:$\b%A\u0004va\u0012\fG/\u001a:\u0016\u0003\u0005\u0004\"!\u00172\n\u0005\rT&!D*j[BdW-\u00169eCR,'/\u0001\u0005va\u0012\fG/\u001a:!\u0003%y\u0007\u000f^5nSj,'/F\u0001h!\tI\u0006.\u0003\u0002j5\nyqI]1eS\u0016tG\u000fR3tG\u0016tG\u000fK\u0002\u0013WF\u0004\"\u0001\\8\u000e\u00035T!A\u001c\u000e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002q[\n)1+\u001b8dK\u0006\n!/A\u00031]ar\u0003'\u0001\u0006paRLW.\u001b>fe\u0002B3aE6r\u0003-\u0019'/Z1uK6{G-\u001a7\u0015\u0007\u0019:x\u0010C\u0003y)\u0001\u0007\u00110A\u0004xK&<\u0007\u000e^:\u0011\u0005ilX\"A>\u000b\u0005qD\u0012A\u00027j]\u0006dw-\u0003\u0002\u007fw\n1a+Z2u_JDa!!\u0001\u0015\u0001\u0004\t\u0014!C5oi\u0016\u00148-\u001a9uQ\r\u00011.\u001d")
public class LinearRegressionWithSGD
extends GeneralizedLinearAlgorithm<LinearRegressionModel> {
    private double stepSize;
    private int numIterations;
    private double regParam;
    private double miniBatchFraction;
    private final LeastSquaresGradient gradient;
    private final SimpleUpdater updater;
    private final GradientDescent optimizer;

    private double stepSize() {
        return this.stepSize;
    }

    private void stepSize_$eq(double x$1) {
        this.stepSize = x$1;
    }

    private int numIterations() {
        return this.numIterations;
    }

    private void numIterations_$eq(int x$1) {
        this.numIterations = x$1;
    }

    private double regParam() {
        return this.regParam;
    }

    private void regParam_$eq(double x$1) {
        this.regParam = x$1;
    }

    private double miniBatchFraction() {
        return this.miniBatchFraction;
    }

    private void miniBatchFraction_$eq(double x$1) {
        this.miniBatchFraction = x$1;
    }

    private LeastSquaresGradient gradient() {
        return this.gradient;
    }

    private SimpleUpdater updater() {
        return this.updater;
    }

    @Override
    public GradientDescent optimizer() {
        return this.optimizer;
    }

    @Override
    public LinearRegressionModel createModel(Vector weights, double intercept) {
        return new LinearRegressionModel(weights, intercept);
    }

    public LinearRegressionWithSGD(double stepSize, int numIterations, double regParam, double miniBatchFraction) {
        this.stepSize = stepSize;
        this.numIterations = numIterations;
        this.regParam = regParam;
        this.miniBatchFraction = miniBatchFraction;
        this.gradient = new LeastSquaresGradient();
        this.updater = new SimpleUpdater();
        this.optimizer = new GradientDescent(this.gradient(), this.updater()).setStepSize(this.stepSize()).setNumIterations(this.numIterations()).setRegParam(this.regParam()).setMiniBatchFraction(this.miniBatchFraction());
    }
}

