/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.BinaryRandomForestClassificationSummaryImpl;
import org.apache.spark.ml.classification.BinaryRandomForestClassificationTrainingSummary;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel$;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams;
import org.apache.spark.ml.classification.RandomForestClassificationModel$;
import org.apache.spark.ml.classification.RandomForestClassificationSummary;
import org.apache.spark.ml.classification.RandomForestClassificationSummaryImpl;
import org.apache.spark.ml.classification.RandomForestClassificationTrainingSummary;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.EnsembleModelReadWrite$;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.RandomForestClassifierParams;
import org.apache.spark.ml.tree.RandomForestParams;
import org.apache.spark.ml.tree.TreeClassifierParams;
import org.apache.spark.ml.tree.TreeEnsembleClassifierParams;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.ml.tree.TreeEnsembleModel$;
import org.apache.spark.ml.tree.TreeEnsembleParams;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.HasTrainingSummary;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t-h\u0001B\u0017/\u0001eB\u0001b\u0019\u0001\u0003\u0006\u0004%\t\u0005\u001a\u0005\ts\u0002\u0011\t\u0011)A\u0005K\"A1\u0010\u0001BC\u0002\u0013%A\u0010C\u0005\u0002\u0002\u0001\u0011\t\u0011)A\u0005{\"Q\u00111\u0001\u0001\u0003\u0006\u0004%\t%!\u0002\t\u0015\u0005M\u0001A!A!\u0002\u0013\t9\u0001\u0003\u0006\u0002\u0018\u0001\u0011)\u0019!C!\u0003\u000bA!\"a\u0007\u0001\u0005\u0003\u0005\u000b\u0011BA\u0004\u0011!\ty\u0002\u0001C\u0001a\u0005\u0005\u0002\u0002CA\u0010\u0001\u0011\u0005\u0001'!\r\t\r\u0005U\u0002\u0001\"\u0011}\u0011)\t\t\u0005\u0001EC\u0002\u0013%\u00111\t\u0005\b\u0003\u001b\u0002A\u0011IA\"\u0011\u001d\t\t\u0006\u0001C!\u0003'Bq!a\u0017\u0001\t\u0003\ti\u0006C\u0004\u0002h\u0001!\t!!\u001b\t\u000f\u0005m\u0005\u0001\"\u0011\u0002\u001e\"9\u0011\u0011\u0017\u0001\u0005B\u0005M\u0006bBAp\u0001\u0011\u0005\u0013\u0011\u001d\u0005\b\u0003[\u0004A\u0011KAx\u0011\u001d\t)\u0010\u0001C!\u0003oDqAa\u0003\u0001\t\u0003\u0012i\u0001\u0003\u0006\u0003\u0012\u0001A)\u0019!C\u0001\u0005'A\u0001Ba\u0006\u0001\t\u0003\u0001$\u0011\u0004\u0005\b\u0005[\u0001A\u0011\tB\u0018\u000f\u001d\u0011yD\fE\u0001\u0005\u00032a!\f\u0018\t\u0002\t\r\u0003bBA\u00107\u0011\u0005!\u0011\u000b\u0005\b\u0005'ZB\u0011\tB+\u0011\u001d\u0011yf\u0007C!\u0005C2qA!\u001b\u001c\u0001m\u0011Y\u0007C\u0005\u0003n}\u0011\t\u0011)A\u0005\t\"9\u0011qD\u0010\u0005\u0002\t=\u0004b\u0002B<?\u0011E#\u0011\u0010\u0004\u0007\u0005\u0007[BA!\"\t\u000f\u0005}1\u0005\"\u0001\u0003\b\"I!1R\u0012C\u0002\u0013%!Q\u0012\u0005\t\u0005;\u001b\u0003\u0015!\u0003\u0003\u0010\"I!qT\u0012C\u0002\u0013%!Q\u0012\u0005\t\u0005C\u001b\u0003\u0015!\u0003\u0003\u0010\"9!qL\u0012\u0005B\t\r\u0006\u0002\u0003BT7\u0011\u0005\u0001G!+\t\u0015\t\u001d7$%A\u0005\u0002A\u0012I\rC\u0005\u0003^n\t\t\u0011\"\u0003\u0003`\ny\"+\u00198e_64uN]3ti\u000ec\u0017m]:jM&\u001c\u0017\r^5p]6{G-\u001a7\u000b\u0005=\u0002\u0014AD2mCN\u001c\u0018NZ5dCRLwN\u001c\u0006\u0003cI\n!!\u001c7\u000b\u0005M\"\u0014!B:qCJ\\'BA\u001b7\u0003\u0019\t\u0007/Y2iK*\tq'A\u0002pe\u001e\u001c\u0001aE\u0004\u0001u\u0015[\u0015kV/\u0011\tmbd\bR\u0007\u0002]%\u0011QH\f\u0002!!J|'-\u00192jY&\u001cH/[2DY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8N_\u0012,G\u000e\u0005\u0002@\u00056\t\u0001I\u0003\u0002Ba\u00051A.\u001b8bY\u001eL!a\u0011!\u0003\rY+7\r^8s!\tY\u0004\u0001\u0005\u0002G\u00136\tqI\u0003\u0002Ia\u0005!AO]3f\u0013\tQuI\u0001\u000fSC:$w.\u001c$pe\u0016\u001cHo\u00117bgNLg-[3s!\u0006\u0014\u0018-\\:\u0011\u0007\u0019ce*\u0003\u0002N\u000f\n\tBK]3f\u000b:\u001cX-\u001c2mK6{G-\u001a7\u0011\u0005mz\u0015B\u0001)/\u0005}!UmY5tS>tGK]3f\u00072\f7o]5gS\u000e\fG/[8o\u001b>$W\r\u001c\t\u0003%Vk\u0011a\u0015\u0006\u0003)B\nA!\u001e;jY&\u0011ak\u0015\u0002\u000b\u001b2;&/\u001b;bE2,\u0007C\u0001-\\\u001b\u0005I&\"\u0001.\u0002\u000bM\u001c\u0017\r\\1\n\u0005qK&\u0001D*fe&\fG.\u001b>bE2,\u0007c\u0001*_A&\u0011ql\u0015\u0002\u0013\u0011\u0006\u001cHK]1j]&twmU;n[\u0006\u0014\u0018\u0010\u0005\u0002<C&\u0011!M\f\u0002*%\u0006tGm\\7G_J,7\u000f^\"mCN\u001c\u0018NZ5dCRLwN\u001c+sC&t\u0017N\\4Tk6l\u0017M]=\u0002\u0007ULG-F\u0001f!\t1WN\u0004\u0002hWB\u0011\u0001.W\u0007\u0002S*\u0011!\u000eO\u0001\u0007yI|w\u000e\u001e \n\u00051L\u0016A\u0002)sK\u0012,g-\u0003\u0002o_\n11\u000b\u001e:j]\u001eT!\u0001\\-)\u0007\u0005\tx\u000f\u0005\u0002sk6\t1O\u0003\u0002ue\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Y\u001c(!B*j]\u000e,\u0017%\u0001=\u0002\u000bErSG\f\u0019\u0002\tULG\r\t\u0015\u0004\u0005E<\u0018AB0ue\u0016,7/F\u0001~!\rAfPT\u0005\u0003\u007ff\u0013Q!\u0011:sCf\fqa\u0018;sK\u0016\u001c\b%A\u0006ok64U-\u0019;ve\u0016\u001cXCAA\u0004!\rA\u0016\u0011B\u0005\u0004\u0003\u0017I&aA%oi\"\"Q!]A\bC\t\t\t\"A\u00032]Yr\u0003'\u0001\u0007ok64U-\u0019;ve\u0016\u001c\b\u0005\u000b\u0003\u0007c\u0006=\u0011A\u00038v[\u000ec\u0017m]:fg\"\u001aq!]<\u0002\u00179,Xn\u00117bgN,7\u000f\t\u0015\u0004\u0011E<\u0018A\u0002\u001fj]&$h\bF\u0005E\u0003G\t9#!\u000b\u0002.!)1-\u0003a\u0001K\"\"\u00111E9x\u0011\u0015Y\u0018\u00021\u0001~\u0011\u001d\t\u0019!\u0003a\u0001\u0003\u000fAS!!\u000br\u0003\u001fAq!a\u0006\n\u0001\u0004\t9\u0001\u000b\u0003\u0002.E<Hc\u0002#\u00024\u0005]\u0012\u0011\b\u0005\u0007\u0003kQ\u0001\u0019A?\u0002\u000bQ\u0014X-Z:\t\u000f\u0005\r!\u00021\u0001\u0002\b!9\u0011q\u0003\u0006A\u0002\u0005\u001d\u0001\u0006B\u0006r\u0003{\t#!a\u0010\u0002\u000bErCG\f\u0019\u0002\u0019}#(/Z3XK&<\u0007\u000e^:\u0016\u0005\u0005\u0015\u0003\u0003\u0002-\u007f\u0003\u000f\u00022\u0001WA%\u0013\r\tY%\u0017\u0002\u0007\t>,(\r\\3\u0002\u0017Q\u0014X-Z,fS\u001eDGo\u001d\u0015\u0005\u001bE\fi$A\u0004tk6l\u0017M]=\u0016\u0003\u0001DCAD9\u0002X\u0005\u0012\u0011\u0011L\u0001\u0006g9\nd\u0006M\u0001\u000eE&t\u0017M]=Tk6l\u0017M]=\u0016\u0005\u0005}\u0003cA\u001e\u0002b%\u0019\u00111\r\u0018\u0003_\tKg.\u0019:z%\u0006tGm\\7G_J,7\u000f^\"mCN\u001c\u0018NZ5dCRLwN\u001c+sC&t\u0017N\\4Tk6l\u0017M]=)\t=\t\u0018qK\u0001\tKZ\fG.^1uKR!\u00111NA9!\rY\u0014QN\u0005\u0004\u0003_r#!\t*b]\u0012|WNR8sKN$8\t\\1tg&4\u0017nY1uS>t7+^7nCJL\bbBA:!\u0001\u0007\u0011QO\u0001\bI\u0006$\u0018m]3ua\u0011\t9(a\"\u0011\r\u0005e\u0014qPAB\u001b\t\tYHC\u0002\u0002~I\n1a]9m\u0013\u0011\t\t)a\u001f\u0003\u000f\u0011\u000bG/Y:fiB!\u0011QQAD\u0019\u0001!A\"!#\u0002r\u0005\u0005\t\u0011!B\u0001\u0003\u0017\u00131a\u0018\u00134#\u0011\ti)a%\u0011\u0007a\u000by)C\u0002\u0002\u0012f\u0013qAT8uQ&tw\rE\u0002Y\u0003+K1!a&Z\u0005\r\te.\u001f\u0015\u0005!E\f9&A\bue\u0006t7OZ8s[N\u001b\u0007.Z7b)\u0011\ty*a+\u0011\t\u0005\u0005\u0016qU\u0007\u0003\u0003GSA!!*\u0002|\u0005)A/\u001f9fg&!\u0011\u0011VAR\u0005)\u0019FO];diRK\b/\u001a\u0005\b\u0003[\u000b\u0002\u0019AAP\u0003\u0019\u00198\r[3nC\"\"\u0011#]A\u001f\u0003%!(/\u00198tM>\u0014X\u000e\u0006\u0003\u00026\u0006M\u0007\u0003BA\\\u0003\u001btA!!/\u0002J:!\u00111XAd\u001d\u0011\ti,!2\u000f\t\u0005}\u00161\u0019\b\u0004Q\u0006\u0005\u0017\"A\u001c\n\u0005U2\u0014BA\u001a5\u0013\r\tiHM\u0005\u0005\u0003\u0017\fY(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005=\u0017\u0011\u001b\u0002\n\t\u0006$\u0018M\u0012:b[\u0016TA!a3\u0002|!9\u00111\u000f\nA\u0002\u0005U\u0007\u0007BAl\u00037\u0004b!!\u001f\u0002\u0000\u0005e\u0007\u0003BAC\u00037$A\"!8\u0002T\u0006\u0005\t\u0011!B\u0001\u0003\u0017\u00131a\u0018\u00135\u0003)\u0001(/\u001a3jGR\u0014\u0016m\u001e\u000b\u0004}\u0005\r\bBBAs'\u0001\u0007a(\u0001\u0005gK\u0006$XO]3tQ\u0011\u0019\u0012/!;\"\u0005\u0005-\u0018!B\u001a/a9\u0002\u0014A\u0006:boJ\u0002(o\u001c2bE&d\u0017\u000e^=J]Bc\u0017mY3\u0015\u0007y\n\t\u0010\u0003\u0004\u0002tR\u0001\rAP\u0001\u000ee\u0006<\bK]3eS\u000e$\u0018n\u001c8\u0002\t\r|\u0007/\u001f\u000b\u0004\t\u0006e\bbBA~+\u0001\u0007\u0011Q`\u0001\u0006Kb$(/\u0019\t\u0005\u0003\u007f\u0014)!\u0004\u0002\u0003\u0002)\u0019!1\u0001\u0019\u0002\u000bA\f'/Y7\n\t\t\u001d!\u0011\u0001\u0002\t!\u0006\u0014\u0018-\\'ba\"\"Q#]A\u001f\u0003!!xn\u0015;sS:<G#A3)\tY\t\u0018QH\u0001\u0013M\u0016\fG/\u001e:f\u00136\u0004xN\u001d;b]\u000e,7/F\u0001?Q\r9\u0012o^\u0001\u0006i>|E\u000eZ\u000b\u0003\u00057\u0001BA!\b\u0003*5\u0011!q\u0004\u0006\u0005\u0005C\u0011\u0019#A\u0003n_\u0012,GNC\u0002I\u0005KQ1Aa\n3\u0003\u0015iG\u000e\\5c\u0013\u0011\u0011YCa\b\u0003#I\u000bg\u000eZ8n\r>\u0014Xm\u001d;N_\u0012,G.A\u0003xe&$X-\u0006\u0002\u00032A\u0019!Ka\r\n\u0007\tU2K\u0001\u0005N\u0019^\u0013\u0018\u000e^3sQ\u0011I\u0012O!\u000f\"\u0005\tm\u0012!\u0002\u001a/a9\u0002\u0004\u0006\u0002\u0001r\u0003{\tqDU1oI>lgi\u001c:fgR\u001cE.Y:tS\u001aL7-\u0019;j_:lu\u000eZ3m!\tY4d\u0005\u0004\u001c\u0005\u000b\u0012Ye\u0016\t\u00041\n\u001d\u0013b\u0001B%3\n1\u0011I\\=SK\u001a\u0004BA\u0015B'\t&\u0019!qJ*\u0003\u00155c%+Z1eC\ndW\r\u0006\u0002\u0003B\u0005!!/Z1e+\t\u00119\u0006\u0005\u0003S\u00053\"\u0015b\u0001B.'\nAQ\n\u0014*fC\u0012,'\u000f\u000b\u0003\u001ec\ne\u0012\u0001\u00027pC\u0012$2\u0001\u0012B2\u0011\u0019\u0011)G\ba\u0001K\u0006!\u0001/\u0019;iQ\u0011q\u0012O!\u000f\u0003KI\u000bg\u000eZ8n\r>\u0014Xm\u001d;DY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8N_\u0012,Gn\u0016:ji\u0016\u00148cA\u0010\u00032\u0005A\u0011N\\:uC:\u001cW\r\u0006\u0003\u0003r\tU\u0004c\u0001B:?5\t1\u0004\u0003\u0004\u0003n\u0005\u0002\r\u0001R\u0001\tg\u00064X-S7qYR!!1\u0010BA!\rA&QP\u0005\u0004\u0005\u007fJ&\u0001B+oSRDaA!\u001a#\u0001\u0004)'!\n*b]\u0012|WNR8sKN$8\t\\1tg&4\u0017nY1uS>tWj\u001c3fYJ+\u0017\rZ3s'\r\u0019#q\u000b\u000b\u0003\u0005\u0013\u00032Aa\u001d$\u0003%\u0019G.Y:t\u001d\u0006lW-\u0006\u0002\u0003\u0010B!!\u0011\u0013BN\u001b\t\u0011\u0019J\u0003\u0003\u0003\u0016\n]\u0015\u0001\u00027b]\u001eT!A!'\u0002\t)\fg/Y\u0005\u0004]\nM\u0015AC2mCN\u001ch*Y7fA\u0005iAO]3f\u00072\f7o\u001d(b[\u0016\fa\u0002\u001e:fK\u000ec\u0017m]:OC6,\u0007\u0005F\u0002E\u0005KCaA!\u001a*\u0001\u0004)\u0017a\u00024s_6|E\u000e\u001a\u000b\f\t\n-&q\u0016B]\u0005\u0007\u0014)\rC\u0004\u0003.*\u0002\rAa\u0007\u0002\u0011=dG-T8eK2DqA!-+\u0001\u0004\u0011\u0019,\u0001\u0004qCJ,g\u000e\u001e\t\u0004w\tU\u0016b\u0001B\\]\t1\"+\u00198e_64uN]3ti\u000ec\u0017m]:jM&,'\u000fC\u0004\u0003<*\u0002\rA!0\u0002'\r\fG/Z4pe&\u001c\u0017\r\u001c$fCR,(/Z:\u0011\u000f\u0019\u0014y,a\u0002\u0002\b%\u0019!\u0011Y8\u0003\u00075\u000b\u0007\u000fC\u0004\u0002\u0018)\u0002\r!a\u0002\t\u0013\u0005\r!\u0006%AA\u0002\u0005\u001d\u0011!\u00054s_6|E\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!1\u001a\u0016\u0005\u0003\u000f\u0011im\u000b\u0002\u0003PB!!\u0011\u001bBm\u001b\t\u0011\u0019N\u0003\u0003\u0003V\n]\u0017!C;oG\",7m[3e\u0015\t!\u0018,\u0003\u0003\u0003\\\nM'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011\t\u000f\u0005\u0003\u0003\u0012\n\r\u0018\u0002\u0002Bs\u0005'\u0013aa\u00142kK\u000e$\b\u0006B\u000er\u0005sACAG9\u0003:\u0001")
public class RandomForestClassificationModel
extends ProbabilisticClassificationModel<Vector, RandomForestClassificationModel>
implements RandomForestClassifierParams,
TreeEnsembleModel<DecisionTreeClassificationModel>,
MLWritable,
HasTrainingSummary<RandomForestClassificationTrainingSummary> {
    private double[] _treeWeights;
    private Vector featureImportances;
    private final String uid;
    private final DecisionTreeClassificationModel[] _trees;
    private final int numFeatures;
    private final int numClasses;
    private Option<RandomForestClassificationTrainingSummary> trainingSummary;
    private int totalNumNodes;
    private final Param<String> impurity;
    private final IntParam numTrees;
    private final BooleanParam bootstrap;
    private final DoubleParam subsamplingRate;
    private final Param<String> featureSubsetStrategy;
    private final Param<String> leafCol;
    private final IntParam maxDepth;
    private final IntParam maxBins;
    private final IntParam minInstancesPerNode;
    private final DoubleParam minWeightFractionPerNode;
    private final DoubleParam minInfoGain;
    private final IntParam maxMemoryInMB;
    private final BooleanParam cacheNodeIds;
    private final Param<String> weightCol;
    private final LongParam seed;
    private final IntParam checkpointInterval;
    private volatile byte bitmap$0;

    public static RandomForestClassificationModel load(String string) {
        return RandomForestClassificationModel$.MODULE$.load(string);
    }

    public static MLReader<RandomForestClassificationModel> read() {
        return RandomForestClassificationModel$.MODULE$.read();
    }

    @Override
    public boolean hasSummary() {
        return HasTrainingSummary.hasSummary$(this);
    }

    @Override
    public HasTrainingSummary<RandomForestClassificationTrainingSummary> setSummary(Option<RandomForestClassificationTrainingSummary> summary) {
        return HasTrainingSummary.setSummary$(this, summary);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public Vector javaTreeWeights() {
        return TreeEnsembleModel.javaTreeWeights$(this);
    }

    @Override
    public String toDebugString() {
        return TreeEnsembleModel.toDebugString$(this);
    }

    @Override
    public Vector predictLeaf(Vector features) {
        return TreeEnsembleModel.predictLeaf$(this, features);
    }

    @Override
    public StructField getLeafField(String leafCol) {
        return TreeEnsembleModel.getLeafField$(this, leafCol);
    }

    @Override
    public final String getImpurity() {
        return TreeClassifierParams.getImpurity$(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return TreeClassifierParams.getOldImpurity$(this);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$tree$TreeEnsembleClassifierParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return TreeEnsembleClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final int getNumTrees() {
        return RandomForestParams.getNumTrees$(this);
    }

    @Override
    public final boolean getBootstrap() {
        return RandomForestParams.getBootstrap$(this);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams.getSubsamplingRate$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final String getFeatureSubsetStrategy() {
        return TreeEnsembleParams.getFeatureSubsetStrategy$(this);
    }

    @Override
    public final DecisionTreeParams setLeafCol(String value) {
        return DecisionTreeParams.setLeafCol$(this, value);
    }

    @Override
    public final String getLeafCol() {
        return DecisionTreeParams.getLeafCol$(this);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams.getMaxDepth$(this);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams.getMaxBins$(this);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams.getMinInstancesPerNode$(this);
    }

    @Override
    public final double getMinWeightFractionPerNode() {
        return DecisionTreeParams.getMinWeightFractionPerNode$(this);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams.getMinInfoGain$(this);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams.getMaxMemoryInMB$(this);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams.getCacheNodeIds$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval.getCheckpointInterval$(this);
    }

    @Override
    public final Option<RandomForestClassificationTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    @Override
    public final void trainingSummary_$eq(Option<RandomForestClassificationTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    private int totalNumNodes$lzycompute() {
        RandomForestClassificationModel randomForestClassificationModel = this;
        synchronized (randomForestClassificationModel) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.totalNumNodes = TreeEnsembleModel.totalNumNodes$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.totalNumNodes;
    }

    @Override
    public int totalNumNodes() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.totalNumNodes$lzycompute() : this.totalNumNodes;
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeClassifierParams$_setter_$impurity_$eq(Param<String> x$1) {
        this.impurity = x$1;
    }

    @Override
    public final IntParam numTrees() {
        return this.numTrees;
    }

    @Override
    public final BooleanParam bootstrap() {
        return this.bootstrap;
    }

    @Override
    public final void org$apache$spark$ml$tree$RandomForestParams$_setter_$numTrees_$eq(IntParam x$1) {
        this.numTrees = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$RandomForestParams$_setter_$bootstrap_$eq(BooleanParam x$1) {
        this.bootstrap = x$1;
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public final Param<String> featureSubsetStrategy() {
        return this.featureSubsetStrategy;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$featureSubsetStrategy_$eq(Param<String> x$1) {
        this.featureSubsetStrategy = x$1;
    }

    @Override
    public final Param<String> leafCol() {
        return this.leafCol;
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minWeightFractionPerNode() {
        return this.minWeightFractionPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$leafCol_$eq(Param<String> x$1) {
        this.leafCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minWeightFractionPerNode_$eq(DoubleParam x$1) {
        this.minWeightFractionPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    private DecisionTreeClassificationModel[] _trees() {
        return this._trees;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    public DecisionTreeClassificationModel[] trees() {
        return this._trees();
    }

    private double[] _treeWeights$lzycompute() {
        RandomForestClassificationModel randomForestClassificationModel = this;
        synchronized (randomForestClassificationModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this._treeWeights = (double[])Array$.MODULE$.fill(this._trees().length, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0, ClassTag$.MODULE$.Double());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this._treeWeights;
    }

    private double[] _treeWeights() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this._treeWeights$lzycompute() : this._treeWeights;
    }

    @Override
    public double[] treeWeights() {
        return this._treeWeights();
    }

    @Override
    public RandomForestClassificationTrainingSummary summary() {
        return (RandomForestClassificationTrainingSummary)HasTrainingSummary.summary$(this);
    }

    public BinaryRandomForestClassificationTrainingSummary binarySummary() {
        BinaryRandomForestClassificationTrainingSummary binaryRandomForestClassificationTrainingSummary;
        RandomForestClassificationTrainingSummary randomForestClassificationTrainingSummary = this.summary();
        if (!(randomForestClassificationTrainingSummary instanceof BinaryRandomForestClassificationTrainingSummary)) {
            throw new RuntimeException(new StringBuilder(88).append("Cannot create a binary summary for a non-binary model").append("(numClasses=").append(this.numClasses()).append("), use summary instead.").toString());
        }
        BinaryRandomForestClassificationTrainingSummary binaryRandomForestClassificationTrainingSummary2 = binaryRandomForestClassificationTrainingSummary = (BinaryRandomForestClassificationTrainingSummary)randomForestClassificationTrainingSummary;
        return binaryRandomForestClassificationTrainingSummary2;
    }

    public RandomForestClassificationSummary evaluate(Dataset<?> dataset) {
        String weightColName = !this.isDefined(this.weightCol()) ? "weightCol" : this.$(this.weightCol());
        Tuple3 tuple3 = this.findSummaryModel();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        ProbabilisticClassificationModel summaryModel = (ProbabilisticClassificationModel)tuple3._1();
        String probabilityColName = (String)tuple3._2();
        String predictionColName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)summaryModel, (Object)probabilityColName, (Object)predictionColName);
        Tuple3 tuple33 = tuple32;
        ProbabilisticClassificationModel summaryModel2 = (ProbabilisticClassificationModel)tuple33._1();
        String probabilityColName2 = (String)tuple33._2();
        String predictionColName2 = (String)tuple33._3();
        return this.numClasses() > 2 ? new RandomForestClassificationSummaryImpl(summaryModel2.transform(dataset), predictionColName2, this.$(this.labelCol()), weightColName) : new BinaryRandomForestClassificationSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), weightColName);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StructType transformSchema(StructType schema) {
        void var2_2;
        block0: {
            StructType outputSchema = super.transformSchema(schema);
            if (!new StringOps(Predef$.MODULE$.augmentString(this.$(this.leafCol()))).nonEmpty()) break block0;
            outputSchema = SchemaUtils$.MODULE$.updateField(outputSchema, this.getLeafField(this.$(this.leafCol())), SchemaUtils$.MODULE$.updateField$default$3());
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        Dataset dataset2;
        StructType outputSchema = this.transformSchema(dataset.schema(), true);
        Dataset<Row> outputData = super.transform(dataset);
        if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.leafCol()))).nonEmpty()) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(RandomForestClassificationModel.class.getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(RandomForestClassificationModel.class.getClassLoader());
            public final class Org_apache_spark_ml_classification_RandomForestClassificationModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_classification_RandomForestClassificationModel$$typecreator1$1(RandomForestClassificationModel $outer) {
                }
            }
            public final class Org_apache_spark_ml_classification_RandomForestClassificationModel$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_classification_RandomForestClassificationModel$$typecreator2$1(RandomForestClassificationModel $outer) {
                }
            }
            UserDefinedFunction leafUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> this.predictLeaf((Vector)features), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_RandomForestClassificationModel$$typecreator1$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_classification_RandomForestClassificationModel$$typecreator2$1(null)));
            dataset2 = outputData.withColumn(this.$(this.leafCol()), leafUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})), outputSchema.apply(this.$(this.leafCol())).metadata());
        } else {
            void var3_3;
            dataset2 = var3_3;
        }
        return dataset2;
    }

    @Override
    public Vector predictRaw(Vector features) {
        double[] votes = (double[])Array$.MODULE$.ofDim(this.numClasses(), ClassTag$.MODULE$.Double());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this._trees())).foreach((Function1 & Serializable & scala.Serializable)tree -> {
            RandomForestClassificationModel.$anonfun$predictRaw$1(this, features, votes, tree);
            return BoxedUnit.UNIT;
        });
        return Vectors$.MODULE$.dense(votes);
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (!(vector instanceof DenseVector)) {
            if (vector instanceof SparseVector) {
                throw new RuntimeException("Unexpected error in RandomForestClassificationModel: raw2probabilityInPlace encountered SparseVector");
            }
            throw new MatchError((Object)vector);
        }
        DenseVector denseVector = (DenseVector)vector;
        ProbabilisticClassificationModel$.MODULE$.normalizeToProbabilitiesInPlace(denseVector);
        DenseVector denseVector2 = denseVector;
        return denseVector2;
    }

    @Override
    public RandomForestClassificationModel copy(ParamMap extra) {
        return (RandomForestClassificationModel)((Model)this.copyValues(new RandomForestClassificationModel(this.uid(), this._trees(), this.numFeatures(), this.numClasses()), extra)).setParent(this.parent());
    }

    @Override
    public String toString() {
        return new StringBuilder(75).append("RandomForestClassificationModel: uid=").append(this.uid()).append(", numTrees=").append(this.getNumTrees()).append(", numClasses=").append(this.numClasses()).append(", ").append("numFeatures=").append(this.numFeatures()).toString();
    }

    private Vector featureImportances$lzycompute() {
        RandomForestClassificationModel randomForestClassificationModel = this;
        synchronized (randomForestClassificationModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.featureImportances = TreeEnsembleModel$.MODULE$.featureImportances(this.trees(), this.numFeatures(), TreeEnsembleModel$.MODULE$.featureImportances$default$3());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.featureImportances;
    }

    public Vector featureImportances() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.featureImportances$lzycompute() : this.featureImportances;
    }

    public RandomForestModel toOld() {
        return new RandomForestModel(Algo$.MODULE$.Classification(), (DecisionTreeModel[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this._trees())).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toOld(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class))));
    }

    @Override
    public MLWriter write() {
        return new RandomForestClassificationModelWriter(this);
    }

    public static final /* synthetic */ void $anonfun$predictRaw$1(RandomForestClassificationModel $this, Vector features$1, double[] votes$1, DecisionTreeClassificationModel tree) {
        double[] classCounts = tree.rootNode().predictImpl(features$1).impurityStats().stats();
        double total = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(classCounts)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        if (total != 0.0) {
            for (int i = 0; i < $this.numClasses(); ++i) {
                int n = i;
                votes$1[n] = votes$1[n] + classCounts[i] / total;
            }
        }
    }

    public RandomForestClassificationModel(String uid, DecisionTreeClassificationModel[] _trees, int numFeatures, int numClasses) {
        this.uid = uid;
        this._trees = _trees;
        this.numFeatures = numFeatures;
        this.numClasses = numClasses;
        HasCheckpointInterval.$init$(this);
        HasSeed.$init$(this);
        HasWeightCol.$init$(this);
        DecisionTreeParams.$init$(this);
        TreeEnsembleParams.$init$(this);
        RandomForestParams.$init$(this);
        TreeEnsembleClassifierParams.$init$(this);
        TreeClassifierParams.$init$(this);
        TreeEnsembleModel.$init$(this);
        MLWritable.$init$(this);
        HasTrainingSummary.$init$(this);
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])_trees)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "RandomForestClassificationModel requires at least 1 tree.");
    }

    public RandomForestClassificationModel(DecisionTreeClassificationModel[] trees, int numFeatures, int numClasses) {
        this(Identifiable$.MODULE$.randomUID("rfc"), trees, numFeatures, numClasses);
    }

    public static class RandomForestClassificationModelReader
    extends MLReader<RandomForestClassificationModel> {
        private final String className = RandomForestClassificationModel.class.getName();
        private final String treeClassName = DecisionTreeClassificationModel.class.getName();

        private String className() {
            return this.className;
        }

        private String treeClassName() {
            return this.treeClassName;
        }

        @Override
        public RandomForestClassificationModel load(String path) {
            DefaultParamsReader.Metadata metadata;
            Tuple2[] treesData;
            DefaultFormats$ format;
            block3: {
                Tuple3<DefaultParamsReader.Metadata, Tuple2<DefaultParamsReader.Metadata, Node>[], double[]> tuple3;
                block2: {
                    format = DefaultFormats$.MODULE$;
                    tuple3 = EnsembleModelReadWrite$.MODULE$.loadImpl(path, this.sparkSession(), this.className(), this.treeClassName());
                    if (tuple3 == null) break block2;
                    DefaultParamsReader.Metadata metadata2 = (DefaultParamsReader.Metadata)tuple3._1();
                    treesData = (Tuple2[])tuple3._2();
                    if (metadata2 == null) break block2;
                    metadata = metadata2;
                    if (treesData != null) break block3;
                }
                throw new MatchError(tuple3);
            }
            Tuple2[] tuple2Array = treesData;
            Tuple2 tuple2 = new Tuple2((Object)metadata, (Object)tuple2Array);
            Tuple2 tuple22 = tuple2;
            DefaultParamsReader.Metadata metadata3 = (DefaultParamsReader.Metadata)tuple22._1();
            Tuple2[] treesData2 = (Tuple2[])tuple22._2();
            int numFeatures = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numFeatures")).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            int numClasses = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numClasses")).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            int numTrees = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numTrees")).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            DecisionTreeClassificationModel[] trees = (DecisionTreeClassificationModel[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])treesData2)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                DefaultParamsReader.Metadata treeMetadata = (DefaultParamsReader.Metadata)tuple2._1();
                Node root = (Node)tuple2._2();
                DecisionTreeClassificationModel tree = new DecisionTreeClassificationModel(treeMetadata.uid(), root, numFeatures, numClasses);
                treeMetadata.getAndSetParams(tree, treeMetadata.getAndSetParams$default$2());
                DecisionTreeClassificationModel decisionTreeClassificationModel = tree;
                return decisionTreeClassificationModel;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeClassificationModel.class)));
            Predef$.MODULE$.require(numTrees == trees.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(88).append("RandomForestClassificationModel.load expected ").append(numTrees).append(" trees based on metadata but found ").append(trees.length).append(" trees.").toString());
            RandomForestClassificationModel model = new RandomForestClassificationModel(metadata3.uid(), trees, numFeatures, numClasses);
            metadata3.getAndSetParams(model, metadata3.getAndSetParams$default$2());
            return model;
        }
    }

    public static class RandomForestClassificationModelWriter
    extends MLWriter {
        private final RandomForestClassificationModel instance;

        @Override
        public void saveImpl(String path) {
            JsonAST.JObject extraMetadata = JsonDSL$.MODULE$.map2jvalue((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numFeatures"), (Object)BoxesRunTime.boxToInteger((int)this.instance.numFeatures())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numClasses"), (Object)BoxesRunTime.boxToInteger((int)this.instance.numClasses())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numTrees"), (Object)BoxesRunTime.boxToInteger((int)this.instance.getNumTrees()))})), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)));
            EnsembleModelReadWrite$.MODULE$.saveImpl(this.instance, path, this.sparkSession(), extraMetadata);
        }

        public RandomForestClassificationModelWriter(RandomForestClassificationModel instance) {
            this.instance = instance;
        }
    }
}

