/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.evaluation.BinaryClassificationEvaluator$;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.param.shared.HasLabelCol;
import org.apache.spark.ml.param.shared.HasRawPredictionCol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.evaluation.BinaryClassificationMetrics;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055g\u0001B\r\u001b\u0001\u0015B\u0001B\u0010\u0001\u0003\u0006\u0004%\te\u0010\u0005\t-\u0002\u0011\t\u0011)A\u0005\u0001\")\u0001\f\u0001C\u00013\")\u0001\f\u0001C\u0001=\"9!\r\u0001b\u0001\n\u0003\u0019\u0007BB5\u0001A\u0003%A\rC\u0003l\u0001\u0011\u0005q\bC\u0003n\u0001\u0011\u0005a\u000eC\u0004t\u0001\t\u0007I\u0011\u0001;\t\rm\u0004\u0001\u0015!\u0003v\u0011\u0015i\b\u0001\"\u0001\u007f\u0011\u001d\tI\u0001\u0001C\u0001\u0003\u0017Aq!!\u0005\u0001\t\u0003\t\u0019\u0002C\u0004\u0002\u001e\u0001!\t!a\b\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002(!9\u0011Q\u0006\u0001\u0005B\u0005=\u0002bBA3\u0001\u0011\u0005\u0013q\r\u0005\b\u0003c\u0002A\u0011IA:\u0011\u001d\t)\t\u0001C!\u0003\u000f;q!!$\u001b\u0011\u0003\tyI\u0002\u0004\u001a5!\u0005\u0011\u0011\u0013\u0005\u00071V!\t!!*\t\u000f\u0005\u001dV\u0003\"\u0011\u0002*\"I\u0011QW\u000b\u0002\u0002\u0013%\u0011q\u0017\u0002\u001e\u0005&t\u0017M]=DY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8Fm\u0006dW/\u0019;pe*\u00111\u0004H\u0001\u000bKZ\fG.^1uS>t'BA\u000f\u001f\u0003\tiGN\u0003\u0002 A\u0005)1\u000f]1sW*\u0011\u0011EI\u0001\u0007CB\f7\r[3\u000b\u0003\r\n1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\u0014+eUB\u0004CA\u0014)\u001b\u0005Q\u0012BA\u0015\u001b\u0005%)e/\u00197vCR|'\u000f\u0005\u0002,a5\tAF\u0003\u0002.]\u000511\u000f[1sK\u0012T!a\f\u000f\u0002\u000bA\f'/Y7\n\u0005Eb#a\u0005%bgJ\u000bw\u000f\u0015:fI&\u001cG/[8o\u0007>d\u0007CA\u00164\u0013\t!DFA\u0006ICNd\u0015MY3m\u0007>d\u0007CA\u00167\u0013\t9DF\u0001\u0007ICN<V-[4ii\u000e{G\u000e\u0005\u0002:y5\t!H\u0003\u0002<9\u0005!Q\u000f^5m\u0013\ti$HA\u000bEK\u001a\fW\u000f\u001c;QCJ\fWn],sSR\f'\r\\3\u0002\u0007ULG-F\u0001A!\t\t%J\u0004\u0002C\u0011B\u00111IR\u0007\u0002\t*\u0011Q\tJ\u0001\u0007yI|w\u000e\u001e \u000b\u0003\u001d\u000bQa]2bY\u0006L!!\u0013$\u0002\rA\u0013X\rZ3g\u0013\tYEJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0013\u001aC3!\u0001(U!\ty%+D\u0001Q\u0015\t\tf$\u0001\u0006b]:|G/\u0019;j_:L!a\u0015)\u0003\u000bMKgnY3\"\u0003U\u000bQ!\r\u00185]A\nA!^5eA!\u001a!A\u0014+\u0002\rqJg.\u001b;?)\tQ6\f\u0005\u0002(\u0001!)ah\u0001a\u0001\u0001\"\u001a1L\u0014+)\u0007\rqE\u000bF\u0001[Q\r!a\nY\u0011\u0002C\u0006)\u0011G\f\u001a/a\u0005QQ.\u001a;sS\u000et\u0015-\\3\u0016\u0003\u0011\u00042!\u001a4A\u001b\u0005q\u0013BA4/\u0005\u0015\u0001\u0016M]1nQ\r)a\nY\u0001\f[\u0016$(/[2OC6,\u0007\u0005K\u0002\u0007\u001d\u0002\fQbZ3u\u001b\u0016$(/[2OC6,\u0007fA\u0004OA\u0006i1/\u001a;NKR\u0014\u0018n\u0019(b[\u0016$\"a\u001c9\u000e\u0003\u0001AQ!\u001d\u0005A\u0002\u0001\u000bQA^1mk\u0016D3\u0001\u0003(a\u0003\u001dqW/\u001c\"j]N,\u0012!\u001e\t\u0003KZL!a\u001e\u0018\u0003\u0011%sG\u000fU1sC6D3!\u0003(zC\u0005Q\u0018!B\u001a/a9\u0002\u0014\u0001\u00038v[\nKgn\u001d\u0011)\u0007)q\u00150\u0001\u0006hKRtU/\u001c\"j]N,\u0012a \t\u0005\u0003\u0003\t\u0019!D\u0001G\u0013\r\t)A\u0012\u0002\u0004\u0013:$\bfA\u0006Os\u0006Q1/\u001a;Ok6\u0014\u0015N\\:\u0015\u0007=\fi\u0001C\u0003r\u0019\u0001\u0007q\u0010K\u0002\r\u001df\f1c]3u%\u0006<\bK]3eS\u000e$\u0018n\u001c8D_2$2a\\A\u000b\u0011\u0015\tX\u00021\u0001AQ\u0011ia*!\u0007\"\u0005\u0005m\u0011!B\u0019/k9\u0002\u0014aC:fi2\u000b'-\u001a7D_2$2a\\A\u0011\u0011\u0015\th\u00021\u0001AQ\rqa\nY\u0001\rg\u0016$x+Z5hQR\u001cu\u000e\u001c\u000b\u0004_\u0006%\u0002\"B9\u0010\u0001\u0004\u0001\u0005fA\bOs\u0006AQM^1mk\u0006$X\r\u0006\u0003\u00022\u0005]\u0002\u0003BA\u0001\u0003gI1!!\u000eG\u0005\u0019!u.\u001e2mK\"9\u0011\u0011\b\tA\u0002\u0005m\u0012a\u00023bi\u0006\u001cX\r\u001e\u0019\u0005\u0003{\ti\u0005\u0005\u0004\u0002@\u0005\u0015\u0013\u0011J\u0007\u0003\u0003\u0003R1!a\u0011\u001f\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003\u000f\n\tEA\u0004ECR\f7/\u001a;\u0011\t\u0005-\u0013Q\n\u0007\u0001\t1\ty%a\u000e\u0002\u0002\u0003\u0005)\u0011AA)\u0005\ryF%M\t\u0005\u0003'\nI\u0006\u0005\u0003\u0002\u0002\u0005U\u0013bAA,\r\n9aj\u001c;iS:<\u0007\u0003BA\u0001\u00037J1!!\u0018G\u0005\r\te.\u001f\u0015\u0005!9\u000b\t'\t\u0002\u0002d\u0005)!G\f\u0019/a\u0005q\u0011n\u001d'be\u001e,'OQ3ui\u0016\u0014XCAA5!\u0011\t\t!a\u001b\n\u0007\u00055dIA\u0004C_>dW-\u00198)\tEq\u0015\u0011D\u0001\u0005G>\u0004\u0018\u0010F\u0002[\u0003kBq!a\u001e\u0013\u0001\u0004\tI(A\u0003fqR\u0014\u0018\rE\u0002f\u0003wJ1!! /\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\b\u0006\u0002\nO\u0003\u0003\u000b#!a!\u0002\u000bErCGL\u0019\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012\u0001\u0011\u0015\u0004'9K\bf\u0001\u0001OA\u0006i\")\u001b8bef\u001cE.Y:tS\u001aL7-\u0019;j_:,e/\u00197vCR|'\u000f\u0005\u0002(+M9Q#a%\u0002\u001a\u0006}\u0005\u0003BA\u0001\u0003+K1!a&G\u0005\u0019\te.\u001f*fMB!\u0011(a'[\u0013\r\tiJ\u000f\u0002\u0016\t\u00164\u0017-\u001e7u!\u0006\u0014\u0018-\\:SK\u0006$\u0017M\u00197f!\u0011\t\t!!)\n\u0007\u0005\rfI\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0002\u0010\u0006!An\\1e)\rQ\u00161\u0016\u0005\u0007\u0003[;\u0002\u0019\u0001!\u0002\tA\fG\u000f\u001b\u0015\u0005/9\u000b\t,\t\u0002\u00024\u0006)\u0011G\f\u001c/a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tI\f\u0005\u0003\u0002<\u0006\u0015WBAA_\u0015\u0011\ty,!1\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0007\fAA[1wC&!\u0011qYA_\u0005\u0019y%M[3di\"\"QCTAYQ\u0011!b*!-")
public class BinaryClassificationEvaluator
extends Evaluator
implements HasRawPredictionCol,
HasLabelCol,
HasWeightCol,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> metricName;
    private final IntParam numBins;
    private final Param<String> weightCol;
    private final Param<String> labelCol;
    private final Param<String> rawPredictionCol;

    public static BinaryClassificationEvaluator load(String string) {
        return BinaryClassificationEvaluator$.MODULE$.load(string);
    }

    public static MLReader<BinaryClassificationEvaluator> read() {
        return BinaryClassificationEvaluator$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol.getLabelCol$(this);
    }

    @Override
    public final String getRawPredictionCol() {
        return HasRawPredictionCol.getRawPredictionCol$(this);
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param<String> x$1) {
        this.labelCol = x$1;
    }

    @Override
    public final Param<String> rawPredictionCol() {
        return this.rawPredictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRawPredictionCol$_setter_$rawPredictionCol_$eq(Param<String> x$1) {
        this.rawPredictionCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Param<String> metricName() {
        return this.metricName;
    }

    public String getMetricName() {
        return this.$(this.metricName());
    }

    public BinaryClassificationEvaluator setMetricName(String value) {
        return (BinaryClassificationEvaluator)this.set(this.metricName(), value);
    }

    public IntParam numBins() {
        return this.numBins;
    }

    public int getNumBins() {
        return BoxesRunTime.unboxToInt((Object)this.$(this.numBins()));
    }

    public BinaryClassificationEvaluator setNumBins(int value) {
        return (BinaryClassificationEvaluator)this.set(this.numBins(), BoxesRunTime.boxToInteger((int)value));
    }

    public BinaryClassificationEvaluator setRawPredictionCol(String value) {
        return (BinaryClassificationEvaluator)this.set(this.rawPredictionCol(), value);
    }

    public BinaryClassificationEvaluator setLabelCol(String value) {
        return (BinaryClassificationEvaluator)this.set(this.labelCol(), value);
    }

    public BinaryClassificationEvaluator setWeightCol(String value) {
        return (BinaryClassificationEvaluator)this.set(this.weightCol(), value);
    }

    @Override
    public double evaluate(Dataset<?> dataset) {
        double d;
        StructType schema = dataset.schema();
        SchemaUtils$.MODULE$.checkColumnTypes(schema, this.$(this.rawPredictionCol()), (Seq<DataType>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{DoubleType$.MODULE$, new VectorUDT()}))), SchemaUtils$.MODULE$.checkColumnTypes$default$4());
        SchemaUtils$.MODULE$.checkNumericType(schema, this.$(this.labelCol()), SchemaUtils$.MODULE$.checkNumericType$default$3());
        if (this.isDefined(this.weightCol())) {
            SchemaUtils$.MODULE$.checkNumericType(schema, this.$(this.weightCol()), SchemaUtils$.MODULE$.checkNumericType$default$3());
        }
        RDD scoreAndLabelsWithWeights = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.rawPredictionCol())), functions$.MODULE$.col(this.$(this.labelCol())).cast((DataType)DoubleType$.MODULE$), !this.isDefined(this.weightCol()) || this.$(this.weightCol()).isEmpty() ? functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0)) : functions$.MODULE$.col(this.$(this.weightCol())).cast((DataType)DoubleType$.MODULE$)})).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Some some;
            Row row = x0$1;
            Some some2 = Row$.MODULE$.unapplySeq(row);
            if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(3) == 0) {
                Object rawPrediction = ((SeqLike)some2.get()).apply(0);
                Object label = ((SeqLike)some2.get()).apply(1);
                Object weight = ((SeqLike)some2.get()).apply(2);
                if (rawPrediction instanceof Vector) {
                    Vector vector = (Vector)rawPrediction;
                    if (label instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)label);
                        if (weight instanceof Double) {
                            double d2 = BoxesRunTime.unboxToDouble((Object)weight);
                            return new Tuple3((Object)BoxesRunTime.boxToDouble((double)vector.apply(1)), (Object)BoxesRunTime.boxToDouble((double)d), (Object)BoxesRunTime.boxToDouble((double)d2));
                        }
                    }
                }
            }
            if ((some = Row$.MODULE$.unapplySeq(row)).isEmpty()) throw new MatchError((Object)row);
            if (some.get() == null) throw new MatchError((Object)row);
            if (((SeqLike)some.get()).lengthCompare(3) != 0) throw new MatchError((Object)row);
            Object rawPrediction = ((SeqLike)some.get()).apply(0);
            Object label = ((SeqLike)some.get()).apply(1);
            Object weight = ((SeqLike)some.get()).apply(2);
            if (!(rawPrediction instanceof Double)) throw new MatchError((Object)row);
            double d = BoxesRunTime.unboxToDouble((Object)rawPrediction);
            if (!(label instanceof Double)) throw new MatchError((Object)row);
            double d3 = BoxesRunTime.unboxToDouble((Object)label);
            if (!(weight instanceof Double)) throw new MatchError((Object)row);
            double d4 = BoxesRunTime.unboxToDouble((Object)weight);
            return new Tuple3((Object)BoxesRunTime.boxToDouble((double)d), (Object)BoxesRunTime.boxToDouble((double)d3), (Object)BoxesRunTime.boxToDouble((double)d4));
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        BinaryClassificationMetrics metrics = new BinaryClassificationMetrics((RDD<? extends Product>)scoreAndLabelsWithWeights, BoxesRunTime.unboxToInt((Object)this.$(this.numBins())));
        String string = this.$(this.metricName());
        if ("areaUnderROC".equals(string)) {
            d = metrics.areaUnderROC();
        } else if ("areaUnderPR".equals(string)) {
            d = metrics.areaUnderPR();
        } else {
            throw new MatchError((Object)string);
        }
        double metric = d;
        metrics.unpersist();
        return metric;
    }

    @Override
    public boolean isLargerBetter() {
        return true;
    }

    @Override
    public BinaryClassificationEvaluator copy(ParamMap extra) {
        return (BinaryClassificationEvaluator)this.defaultCopy(extra);
    }

    @Override
    public String toString() {
        return new StringBuilder(58).append("BinaryClassificationEvaluator: uid=").append(this.uid()).append(", metricName=").append((Object)this.$(this.metricName())).append(", ").append("numBins=").append(this.$(this.numBins())).toString();
    }

    public BinaryClassificationEvaluator(String uid) {
        this.uid = uid;
        HasRawPredictionCol.$init$(this);
        HasLabelCol.$init$(this);
        HasWeightCol.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        Function1 allowedParams = ParamValidators$.MODULE$.inArray(new String[]{"areaUnderROC", "areaUnderPR"});
        this.metricName = new Param(this, "metricName", "metric name in evaluation (areaUnderROC|areaUnderPR)", allowedParams);
        this.numBins = new IntParam((Identifiable)this, "numBins", "Number of bins to down-sample the curves (ROC curve, PR curve) in area computation. If 0, no down-sampling will occur. Must be >= 0.", (Function1<Object, Object>)ParamValidators$.MODULE$.gtEq(0.0));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.metricName().$minus$greater("areaUnderROC"), this.numBins().$minus$greater(BoxesRunTime.boxToInteger((int)1000))}));
    }

    public BinaryClassificationEvaluator() {
        this(Identifiable$.MODULE$.randomUID("binEval"));
    }
}

