/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tree;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.param.Param$;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.DecisionTreeModelReadWrite;
import org.apache.spark.ml.tree.DecisionTreeModelReadWrite$;
import org.apache.spark.ml.tree.EnsembleModelReadWrite;
import org.apache.spark.ml.tree.EnsembleModelReadWrite$;
import org.apache.spark.ml.tree.EnsembleModelReadWrite$EnsembleNodeData$;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.rdd.OrderedRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

public final class EnsembleModelReadWrite$ {
    public static EnsembleModelReadWrite$ MODULE$;

    static {
        new EnsembleModelReadWrite$();
    }

    public <M extends Params & TreeEnsembleModel<? extends DecisionTreeModel>> void saveImpl(M instance, String path, SparkSession sql, JsonAST.JObject extraMetadata) {
        DefaultParamsWriter$.MODULE$.saveMetadata(instance, path, sql.sparkContext(), (Option<JsonAST.JObject>)new Some((Object)extraMetadata), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
        Tuple3[] treesMetadataWeights = (Tuple3[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TreeEnsembleModel<? extends DecisionTreeModel>)instance).trees())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            DecisionTreeModel tree = (DecisionTreeModel)tuple2._1();
            int treeID = tuple2._2$mcI$sp();
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)treeID), (Object)DefaultParamsWriter$.MODULE$.getMetadataToSave((Params)((Object)tree), sql.sparkContext(), DefaultParamsWriter$.MODULE$.getMetadataToSave$default$3(), DefaultParamsWriter$.MODULE$.getMetadataToSave$default$4()), (Object)BoxesRunTime.boxToDouble((double)((TreeEnsembleModel)((Object)instance)).treeWeights()[treeID]));
            return tuple3;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
        String treesMetadataPath = new Path(path, "treesMetadata").toString();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
            }

            public Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator1$1() {
            }
        }
        sql.createDataFrame((Seq)Predef$.MODULE$.wrapRefArray((Object[])treesMetadataWeights), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator1$1())).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"treeID", "metadata", "weights"})).write().parquet(treesMetadataPath);
        String dataPath = new Path(path, "data").toString();
        RDD nodeDataRDD = sql.sparkContext().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TreeEnsembleModel<? extends DecisionTreeModel>)instance).trees())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))), sql.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            DecisionTreeModel tree = (DecisionTreeModel)tuple2._1();
            int treeID = tuple2._2$mcI$sp();
            Seq<EnsembleModelReadWrite.EnsembleNodeData> seq = EnsembleModelReadWrite$EnsembleNodeData$.MODULE$.build(tree, treeID);
            return seq;
        }, ClassTag$.MODULE$.apply(EnsembleModelReadWrite.EnsembleNodeData.class));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.tree.EnsembleModelReadWrite.EnsembleNodeData").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator2$1() {
            }
        }
        sql.createDataFrame(nodeDataRDD, ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator2$1())).write().parquet(dataPath);
    }

    public Tuple3<DefaultParamsReader.Metadata, Tuple2<DefaultParamsReader.Metadata, Node>[], double[]> loadImpl(String path, SparkSession sql, String className, String treeClassName) {
        DefaultFormats$ format = DefaultFormats$.MODULE$;
        DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, sql.sparkContext(), className);
        JsonAST.JValue impurityJson = metadata.getParamValue("impurity");
        String impurityType = (String)Param$.MODULE$.jsonDecode(JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(impurityJson, (Formats)format)));
        String treesMetadataPath = new Path(path, "treesMetadata").toString();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator4$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
            }

            public Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator4$2() {
            }
        }
        RDD treesMetadataRDD = sql.read().parquet(treesMetadataPath).select("treeID", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"metadata", "weights"})).as(sql.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator4$2()))).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            int n;
            double weights;
            String json;
            block3: {
                Tuple3 tuple3;
                block2: {
                    tuple3 = x0$1;
                    if (tuple3 == null) break block2;
                    int treeID = BoxesRunTime.unboxToInt((Object)tuple3._1());
                    json = (String)tuple3._2();
                    weights = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                    n = treeID;
                    if (json != null) break block3;
                }
                throw new MatchError((Object)tuple3);
            }
            String string = json;
            double d = weights;
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)n)), (Object)new Tuple2((Object)DefaultParamsReader$.MODULE$.parseMetadata(string, treeClassName), (Object)BoxesRunTime.boxToDouble((double)d)));
            return tuple2;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        OrderedRDDFunctions qual$1 = RDD$.MODULE$.rddToOrderedRDDFunctions(treesMetadataRDD, (Ordering)Ordering.Int$.MODULE$, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class));
        boolean x$1 = qual$1.sortByKey$default$1();
        int x$2 = qual$1.sortByKey$default$2();
        Tuple2[] treesMetadataWeights = (Tuple2[])RDD$.MODULE$.rddToPairRDDFunctions(qual$1.sortByKey(x$1, x$2), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).values().collect();
        DefaultParamsReader.Metadata[] treesMetadata = (DefaultParamsReader.Metadata[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])treesMetadataWeights)).map((Function1 & Serializable & scala.Serializable)x$19 -> (DefaultParamsReader.Metadata)x$19._1(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DefaultParamsReader.Metadata.class)));
        double[] treesWeights = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])treesMetadataWeights)).map((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToDouble((double)x$20._2$mcD$sp()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        String dataPath = new Path(path, "data").toString();
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.tree.EnsembleModelReadWrite.EnsembleNodeData").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator5$1() {
            }
        }
        Dataset nodeData = sql.read().parquet(dataPath).as(sql.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator5$1())));
        RDD rootNodesRDD = RDD$.MODULE$.rddToPairRDDFunctions(nodeData.rdd().map((Function1 & Serializable & scala.Serializable)d -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)d.treeID()), (Object)d.nodeData()), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(DecisionTreeModelReadWrite.NodeData.class), (Ordering)Ordering.Int$.MODULE$).groupByKey().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            int n;
            Iterable nodeData;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$2;
                    if (tuple2 == null) break block2;
                    int treeID = tuple2._1$mcI$sp();
                    nodeData = (Iterable)tuple2._2();
                    n = treeID;
                    if (nodeData != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            Iterable iterable = nodeData;
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)n)), (Object)DecisionTreeModelReadWrite$.MODULE$.buildTreeFromNodes((DecisionTreeModelReadWrite.NodeData[])iterable.toArray(ClassTag$.MODULE$.apply(DecisionTreeModelReadWrite.NodeData.class)), impurityType));
            return tuple2;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        OrderedRDDFunctions qual$2 = RDD$.MODULE$.rddToOrderedRDDFunctions(rootNodesRDD, (Ordering)Ordering.Int$.MODULE$, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Node.class));
        boolean x$3 = qual$2.sortByKey$default$1();
        int x$4 = qual$2.sortByKey$default$2();
        Node[] rootNodes = (Node[])RDD$.MODULE$.rddToPairRDDFunctions(qual$2.sortByKey(x$3, x$4), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Node.class), (Ordering)Ordering.Int$.MODULE$).values().collect();
        return new Tuple3((Object)metadata, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])treesMetadata)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])rootNodes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))), (Object)treesWeights);
    }

    private EnsembleModelReadWrite$() {
        MODULE$ = this;
    }
}

