/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.PredictionModel;
import org.apache.spark.ml.classification.BinaryLogisticRegressionSummaryImpl;
import org.apache.spark.ml.classification.BinaryLogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.LogisticRegressionModel$;
import org.apache.spark.ml.classification.LogisticRegressionModel$LogisticRegressionModelWriter$;
import org.apache.spark.ml.classification.LogisticRegressionModel$LogisticRegressionModelWriter$Data$;
import org.apache.spark.ml.classification.LogisticRegressionParams;
import org.apache.spark.ml.classification.LogisticRegressionSummary;
import org.apache.spark.ml.classification.LogisticRegressionSummaryImpl;
import org.apache.spark.ml.classification.LogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamMap$;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasElasticNetParam;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasStandardization;
import org.apache.spark.ml.param.shared.HasThreshold;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.HasTrainingSummary;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.VersionUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\rMg\u0001\u0002-Z\u0001\u0011D\u0011b \u0001\u0003\u0006\u0004%\t%!\u0001\t\u0015\u0005=\u0002A!A!\u0002\u0013\t\u0019\u0001\u0003\u0006\u00024\u0001\u0011)\u0019!C\u0001\u0003kA!\"a\u0011\u0001\u0005\u0003\u0005\u000b\u0011BA\u001c\u0011)\t9\u0005\u0001BC\u0002\u0013\u0005\u0011\u0011\n\u0005\n\u0003\u001b\u0002!\u0011!Q\u0001\n%D!\"!\u0015\u0001\u0005\u000b\u0007I\u0011IA*\u0011)\t\u0019\u0007\u0001B\u0001B\u0003%\u0011Q\u000b\u0005\u000b\u0003O\u0002!Q1A\u0005\n\u0005%\u0004BCA9\u0001\t\u0005\t\u0015!\u0003\u0002l!A\u00111\u000f\u0001\u0005\u0002u\u000b)\b\u0003\u0005\u0002t\u0001!\t!XAE\u0011\u001d\ty\t\u0001C\u0001\u0003\u0013B!\"!)\u0001\u0011\u000b\u0007I\u0011BA%\u0011\u001d\t\u0019\n\u0001C\u0001\u0003GC!\"a*\u0001\u0011\u000b\u0007I\u0011BAR\u0011\u001d\tI\u000b\u0001C!\u0003WCq!!/\u0001\t\u0003\n\u0019\u000bC\u0004\u0002>\u0002!\t%a0\t\u000f\u0005-\u0007\u0001\"\u0011\u0002N\"I\u0011\u0011\u001b\u0001C\u0002\u0013%\u00111\u001b\u0005\t\u00037\u0004\u0001\u0015!\u0003\u0002V\"I\u0011Q\u001c\u0001C\u0002\u0013%\u0011q\u001c\u0005\t\u0003G\u0004\u0001\u0015!\u0003\u0002b\"I\u0011Q\u001d\u0001C\u0002\u0013%\u00111\u001b\u0005\t\u0003O\u0004\u0001\u0015!\u0003\u0002V\"I\u0011\u0011\u001e\u0001C\u0002\u0013\u0005\u00131\u000b\u0005\t\u0003c\u0004\u0001\u0015!\u0003\u0002V!9\u0011Q\u001f\u0001\u0005B\u0005]\bbBA~\u0001\u0011\u0005\u0011Q \u0005\t\u0005\u0017\u0001A\u0011A-\u0003\u000e!9!Q\u0003\u0001\u0005\u0002\t]\u0001b\u0002B%\u0001\u0011\u0005#1\n\u0005\b\u0005#\u0002A\u0011\u000bB*\u0011\u001d\u0011I\u0006\u0001C!\u00057BqA!\u001a\u0001\t\u0003\u00129\u0007C\u0004\u0003|\u0001!\tF! \t\u000f\t\u0005\u0005\u0001\"\u0015\u0003\u0004\"9!\u0011\u0012\u0001\u0005B\t-\u0005b\u0002BK\u0001\u0011\u0005#qS\u0004\b\u00057K\u0006\u0012\u0001BO\r\u0019A\u0016\f#\u0001\u0003 \"9\u00111\u000f\u0016\u0005\u0002\tM\u0006b\u0002B[U\u0011\u0005#q\u0017\u0005\b\u0005\u0003TC\u0011\tBb\r\u001d\u0011YM\u000b\u0001+\u0005\u001bD\u0011Ba7/\u0005\u0003\u0005\u000b\u0011B8\t\u000f\u0005Md\u0006\"\u0001\u0003^\u001a1!Q\u001d\u0018E\u0005OD!\"!\u00152\u0005+\u0007I\u0011AA*\u0011)\t\u0019'\rB\tB\u0003%\u0011Q\u000b\u0005\u000b\u0003S\f$Q3A\u0005\u0002\u0005M\u0003BCAyc\tE\t\u0015!\u0003\u0002V!Q\u0011qI\u0019\u0003\u0016\u0004%\t!!\u0013\t\u0013\u00055\u0013G!E!\u0002\u0013I\u0007BCA\u001ac\tU\r\u0011\"\u0001\u00026!Q\u00111I\u0019\u0003\u0012\u0003\u0006I!a\u000e\t\u0015\u0005\u001d\u0014G!f\u0001\n\u0003\tI\u0007\u0003\u0006\u0002rE\u0012\t\u0012)A\u0005\u0003WBq!a\u001d2\t\u0003\u0011y\u000fC\u0005\u0003fE\n\t\u0011\"\u0001\u0003\u0000\"I11B\u0019\u0012\u0002\u0013\u00051Q\u0002\u0005\n\u0007C\t\u0014\u0013!C\u0001\u0007\u001bA\u0011ba\t2#\u0003%\ta!\n\t\u0013\r%\u0012'%A\u0005\u0002\r-\u0002\"CB\u0018cE\u0005I\u0011AB\u0019\u0011%\u0019)$MA\u0001\n\u0003\u001a9\u0004C\u0005\u0004HE\n\t\u0011\"\u0001\u0002T!I1\u0011J\u0019\u0002\u0002\u0013\u000511\n\u0005\n\u0007#\n\u0014\u0011!C!\u0007'B\u0011b!\u00192\u0003\u0003%\taa\u0019\t\u0013\r\u001d\u0014'!A\u0005B\r%\u0004\"\u0003BKc\u0005\u0005I\u0011IB6\u0011%\u0019i'MA\u0001\n\u0003\u001aygB\u0005\u0004t9\n\t\u0011#\u0003\u0004v\u0019I!Q\u001d\u0018\u0002\u0002#%1q\u000f\u0005\b\u0003gbE\u0011ABC\u0011%\u0011)\nTA\u0001\n\u000b\u001aY\u0007C\u0005\u0004\b2\u000b\t\u0011\"!\u0004\n\"I1Q\u0013'\u0002\u0002\u0013\u00055q\u0013\u0005\b\u0007SsC\u0011KBV\r\u0019\u0019)L\u000b\u0003\u00048\"9\u00111\u000f*\u0005\u0002\re\u0006\"CB_%\n\u0007I\u0011BB\u001c\u0011!\u0019yL\u0015Q\u0001\n\re\u0002b\u0002Ba%\u0012\u00053\u0011\u0019\u0005\n\u0007\u000bT\u0013\u0011!C\u0005\u0007\u000f\u0014q\u0003T8hSN$\u0018n\u0019*fOJ,7o]5p]6{G-\u001a7\u000b\u0005i[\u0016AD2mCN\u001c\u0018NZ5dCRLwN\u001c\u0006\u00039v\u000b!!\u001c7\u000b\u0005y{\u0016!B:qCJ\\'B\u00011b\u0003\u0019\t\u0007/Y2iK*\t!-A\u0002pe\u001e\u001c\u0001aE\u0003\u0001KB4\u0018\u0010\u0005\u0003gO&|W\"A-\n\u0005!L&\u0001\t)s_\n\f'-\u001b7jgRL7m\u00117bgNLg-[2bi&|g.T8eK2\u0004\"A[7\u000e\u0003-T!\u0001\\.\u0002\r1Lg.\u00197h\u0013\tq7N\u0001\u0004WK\u000e$xN\u001d\t\u0003M\u0002\u0001\"!\u001d;\u000e\u0003IT!a].\u0002\tU$\u0018\u000e\\\u0005\u0003kJ\u0014!\"\u0014'Xe&$\u0018M\u00197f!\t1w/\u0003\u0002y3\nABj\\4jgRL7MU3he\u0016\u001c8/[8o!\u0006\u0014\u0018-\\:\u0011\u0007ETH0\u0003\u0002|e\n\u0011\u0002*Y:Ue\u0006Lg.\u001b8h'VlW.\u0019:z!\t1W0\u0003\u0002\u007f3\n\tCj\\4jgRL7MU3he\u0016\u001c8/[8o)J\f\u0017N\\5oON+X.\\1ss\u0006\u0019Q/\u001b3\u0016\u0005\u0005\r\u0001\u0003BA\u0003\u0003/qA!a\u0002\u0002\u0014A!\u0011\u0011BA\b\u001b\t\tYAC\u0002\u0002\u000e\r\fa\u0001\u0010:p_Rt$BAA\t\u0003\u0015\u00198-\u00197b\u0013\u0011\t)\"a\u0004\u0002\rA\u0013X\rZ3g\u0013\u0011\tI\"a\u0007\u0003\rM#(/\u001b8h\u0015\u0011\t)\"a\u0004)\u000b\u0005\ty\"a\u000b\u0011\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQ1!!\n^\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003S\t\u0019CA\u0003TS:\u001cW-\t\u0002\u0002.\u0005)\u0011G\f\u001b/a\u0005!Q/\u001b3!Q\u0015\u0011\u0011qDA\u0016\u0003E\u0019w.\u001a4gS\u000eLWM\u001c;NCR\u0014\u0018\u000e_\u000b\u0003\u0003o\u00012A[A\u001d\u0013\r\tYd\u001b\u0002\u0007\u001b\u0006$(/\u001b=)\u000b\r\ty\"a\u0010\"\u0005\u0005\u0005\u0013!\u0002\u001a/c9\u0002\u0014AE2pK\u001a4\u0017nY5f]Rl\u0015\r\u001e:jq\u0002BS\u0001BA\u0010\u0003\u007f\tq\"\u001b8uKJ\u001cW\r\u001d;WK\u000e$xN]\u000b\u0002S\"*Q!a\b\u0002@\u0005\u0001\u0012N\u001c;fe\u000e,\u0007\u000f\u001e,fGR|'\u000f\t\u0015\u0006\r\u0005}\u0011qH\u0001\u000b]Vl7\t\\1tg\u0016\u001cXCAA+!\u0011\t9&!\u0017\u000e\u0005\u0005=\u0011\u0002BA.\u0003\u001f\u00111!\u00138uQ\u00159\u0011qDA0C\t\t\t'A\u00032]Mr\u0003'A\u0006ok6\u001cE.Y:tKN\u0004\u0003&\u0002\u0005\u0002 \u0005}\u0013!D5t\u001bVdG/\u001b8p[&\fG.\u0006\u0002\u0002lA!\u0011qKA7\u0013\u0011\ty'a\u0004\u0003\u000f\t{w\u000e\\3b]\u0006q\u0011n]'vYRLgn\\7jC2\u0004\u0013A\u0002\u001fj]&$h\bF\u0006p\u0003o\nY(a \u0002\u0004\u0006\u001d\u0005BB@\f\u0001\u0004\t\u0019\u0001\u000b\u0004\u0002x\u0005}\u00111\u0006\u0005\b\u0003gY\u0001\u0019AA\u001cQ\u0019\tY(a\b\u0002@!1\u0011qI\u0006A\u0002%Dc!a \u0002 \u0005}\u0002bBA)\u0017\u0001\u0007\u0011Q\u000b\u0015\u0007\u0003\u0007\u000by\"a\u0018\t\u000f\u0005\u001d4\u00021\u0001\u0002lQ9q.a#\u0002\u000e\u0006E\u0005BB@\r\u0001\u0004\t\u0019\u0001\u0003\u0004\u0002\u00102\u0001\r![\u0001\rG>,gMZ5dS\u0016tGo\u001d\u0005\b\u0003'c\u0001\u0019AAK\u0003%Ig\u000e^3sG\u0016\u0004H\u000f\u0005\u0003\u0002X\u0005]\u0015\u0002BAM\u0003\u001f\u0011a\u0001R8vE2,\u0007&B\u0007\u0002 \u0005u\u0015EAAP\u0003\u0015\u0011d\u0006\r\u00181\u00035y6m\\3gM&\u001c\u0017.\u001a8ugV\u0011\u0011Q\u0013\u0015\u0006\u001f\u0005}\u0011qL\u0001\u000b?&tG/\u001a:dKB$\u0018\u0001D:fiRC'/Z:i_2$G\u0003BAW\u0003_k\u0011\u0001\u0001\u0005\b\u0003c\u000b\u0002\u0019AAK\u0003\u00151\u0018\r\\;fQ\u0015\t\u0012qDA[C\t\t9,A\u00032]Ur\u0003'\u0001\u0007hKR$\u0006N]3tQ>dG\rK\u0003\u0013\u0003?\t),A\u0007tKR$\u0006N]3tQ>dGm\u001d\u000b\u0005\u0003[\u000b\t\rC\u0004\u00022N\u0001\r!a1\u0011\r\u0005]\u0013QYAK\u0013\u0011\t9-a\u0004\u0003\u000b\u0005\u0013(/Y=)\u000bM\ty\"!.\u0002\u001b\u001d,G\u000f\u00165sKNDw\u000e\u001c3t+\t\t\u0019\rK\u0003\u0015\u0003?\t),\u0001\u0004nCJ<\u0017N\\\u000b\u0003\u0003+\u0004r!a\u0016\u0002X&\f)*\u0003\u0003\u0002Z\u0006=!!\u0003$v]\u000e$\u0018n\u001c82\u0003\u001di\u0017M]4j]\u0002\nq!\\1sO&t7/\u0006\u0002\u0002bB1\u0011qKAlS&\f\u0001\"\\1sO&t7\u000fI\u0001\u0006g\u000e|'/Z\u0001\u0007g\u000e|'/\u001a\u0011\u0002\u00179,XNR3biV\u0014Xm\u001d\u0015\u00067\u0005}\u0011Q^\u0011\u0003\u0003_\fQ!\r\u00187]A\nAB\\;n\r\u0016\fG/\u001e:fg\u0002BS\u0001HA\u0010\u0003[\fqa];n[\u0006\u0014\u00180F\u0001}Q\u0015i\u0012qDA[\u00035\u0011\u0017N\\1ssN+X.\\1ssV\u0011\u0011q \t\u0004M\n\u0005\u0011b\u0001B\u00023\n9#)\u001b8befdunZ5ti&\u001c'+Z4sKN\u001c\u0018n\u001c8Ue\u0006Lg.\u001b8h'VlW.\u0019:zQ\u0015q\u0012q\u0004B\u0004C\t\u0011I!A\u00033]Mr\u0003'\u0001\tgS:$7+^7nCJLXj\u001c3fYR\u0011!q\u0002\t\n\u0003/\u0012\tb\\A\u0002\u0003\u0007IAAa\u0005\u0002\u0010\t1A+\u001e9mKN\n\u0001\"\u001a<bYV\fG/\u001a\u000b\u0005\u00053\u0011y\u0002E\u0002g\u00057I1A!\bZ\u0005eaunZ5ti&\u001c'+Z4sKN\u001c\u0018n\u001c8Tk6l\u0017M]=\t\u000f\t\u0005\u0002\u00051\u0001\u0003$\u00059A-\u0019;bg\u0016$\b\u0007\u0002B\u0013\u0005k\u0001bAa\n\u0003.\tERB\u0001B\u0015\u0015\r\u0011Y#X\u0001\u0004gFd\u0017\u0002\u0002B\u0018\u0005S\u0011q\u0001R1uCN,G\u000f\u0005\u0003\u00034\tUB\u0002\u0001\u0003\r\u0005o\u0011y\"!A\u0001\u0002\u000b\u0005!\u0011\b\u0002\u0004?\u0012\u001a\u0014\u0003\u0002B\u001e\u0005\u0003\u0002B!a\u0016\u0003>%!!qHA\b\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!a\u0016\u0003D%!!QIA\b\u0005\r\te.\u001f\u0015\u0006A\u0005}\u0011QT\u0001\baJ,G-[2u)\u0011\t)J!\u0014\t\r\t=\u0013\u00051\u0001j\u0003!1W-\u0019;ve\u0016\u001c\u0018A\u0006:boJ\u0002(o\u001c2bE&d\u0017\u000e^=J]Bc\u0017mY3\u0015\u0007%\u0014)\u0006\u0003\u0004\u0003X\t\u0002\r![\u0001\u000ee\u0006<\bK]3eS\u000e$\u0018n\u001c8\u0002\u0015A\u0014X\rZ5diJ\u000bw\u000fF\u0002j\u0005;BaAa\u0014$\u0001\u0004I\u0007&B\u0012\u0002 \t\u0005\u0014E\u0001B2\u0003\u0015\u0019d\u0006\r\u00181\u0003\u0011\u0019w\u000e]=\u0015\u0007=\u0014I\u0007C\u0004\u0003l\u0011\u0002\rA!\u001c\u0002\u000b\u0015DHO]1\u0011\t\t=$QO\u0007\u0003\u0005cR1Aa\u001d\\\u0003\u0015\u0001\u0018M]1n\u0013\u0011\u00119H!\u001d\u0003\u0011A\u000b'/Y7NCBDS\u0001JA\u0010\u0003W\taB]1xeA\u0014X\rZ5di&|g\u000e\u0006\u0003\u0002\u0016\n}\u0004B\u0002B,K\u0001\u0007\u0011.\u0001\fqe>\u0014\u0017MY5mSRL(\u0007\u001d:fI&\u001cG/[8o)\u0011\t)J!\"\t\r\t\u001de\u00051\u0001j\u0003-\u0001(o\u001c2bE&d\u0017\u000e^=\u0002\u000b]\u0014\u0018\u000e^3\u0016\u0005\t5\u0005cA9\u0003\u0010&\u0019!\u0011\u0013:\u0003\u00115cuK]5uKJDSaJA\u0010\u0003[\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u0007AS\u0001AA\u0010\u0003W\tq\u0003T8hSN$\u0018n\u0019*fOJ,7o]5p]6{G-\u001a7\u0011\u0005\u0019T3c\u0002\u0016\u0003\"\n\u001d&Q\u0016\t\u0005\u0003/\u0012\u0019+\u0003\u0003\u0003&\u0006=!AB!osJ+g\r\u0005\u0003r\u0005S{\u0017b\u0001BVe\nQQ\n\u0014*fC\u0012\f'\r\\3\u0011\t\u0005]#qV\u0005\u0005\u0005c\u000byA\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0003\u001e\u0006!!/Z1e+\t\u0011I\f\u0005\u0003r\u0005w{\u0017b\u0001B_e\nAQ\n\u0014*fC\u0012,'\u000fK\u0003-\u0003?\ti/\u0001\u0003m_\u0006$GcA8\u0003F\"9!qY\u0017A\u0002\u0005\r\u0011\u0001\u00029bi\"DS!LA\u0010\u0003[\u0014Q\u0004T8hSN$\u0018n\u0019*fOJ,7o]5p]6{G-\u001a7Xe&$XM]\n\u0006]\t5%q\u001a\t\u0005\u0005#\u00149.\u0004\u0002\u0003T*\u0019!Q[/\u0002\u0011%tG/\u001a:oC2LAA!7\u0003T\n9Aj\\4hS:<\u0017\u0001C5ogR\fgnY3\u0015\t\t}'1\u001d\t\u0004\u0005CtS\"\u0001\u0016\t\r\tm\u0007\u00071\u0001p\u0005\u0011!\u0015\r^1\u0014\u000fE\u0012\tK!;\u0003.B!\u0011q\u000bBv\u0013\u0011\u0011i/a\u0004\u0003\u000fA\u0013x\u000eZ;diRa!\u0011\u001fB{\u0005o\u0014IPa?\u0003~B\u0019!1_\u0019\u000e\u00039Bq!!\u0015=\u0001\u0004\t)\u0006C\u0004\u0002jr\u0002\r!!\u0016\t\r\u0005\u001dC\b1\u0001j\u0011\u001d\t\u0019\u0004\u0010a\u0001\u0003oAq!a\u001a=\u0001\u0004\tY\u0007\u0006\u0007\u0003r\u000e\u000511AB\u0003\u0007\u000f\u0019I\u0001C\u0005\u0002Ru\u0002\n\u00111\u0001\u0002V!I\u0011\u0011^\u001f\u0011\u0002\u0003\u0007\u0011Q\u000b\u0005\t\u0003\u000fj\u0004\u0013!a\u0001S\"I\u00111G\u001f\u0011\u0002\u0003\u0007\u0011q\u0007\u0005\n\u0003Oj\u0004\u0013!a\u0001\u0003W\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004\u0010)\"\u0011QKB\tW\t\u0019\u0019\u0002\u0005\u0003\u0004\u0016\ruQBAB\f\u0015\u0011\u0019Iba\u0007\u0002\u0013Ut7\r[3dW\u0016$'\u0002BA\u0013\u0003\u001fIAaa\b\u0004\u0018\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAB\u0014U\rI7\u0011C\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019iC\u000b\u0003\u00028\rE\u0011AD2paf$C-\u001a4bk2$H%N\u000b\u0003\u0007gQC!a\u001b\u0004\u0012\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"a!\u000f\u0011\t\rm2QI\u0007\u0003\u0007{QAaa\u0010\u0004B\u0005!A.\u00198h\u0015\t\u0019\u0019%\u0001\u0003kCZ\f\u0017\u0002BA\r\u0007{\tA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003B\r5\u0003\"CB(\u000b\u0006\u0005\t\u0019AA+\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u00111Q\u000b\t\u0007\u0007/\u001aiF!\u0011\u000e\u0005\re#\u0002BB.\u0003\u001f\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0019yf!\u0017\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003W\u001a)\u0007C\u0005\u0004P\u001d\u000b\t\u00111\u0001\u0003B\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002VQ\u00111\u0011H\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005-4\u0011\u000f\u0005\n\u0007\u001fR\u0015\u0011!a\u0001\u0005\u0003\nA\u0001R1uCB\u0019!1\u001f'\u0014\u000b1\u001bIH!,\u0011\u001f\rm4\u0011QA+\u0003+J\u0017qGA6\u0005cl!a! \u000b\t\r}\u0014qB\u0001\beVtG/[7f\u0013\u0011\u0019\u0019i! \u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tW\u0007\u0006\u0002\u0004v\u0005)\u0011\r\u001d9msRa!\u0011_BF\u0007\u001b\u001byi!%\u0004\u0014\"9\u0011\u0011K(A\u0002\u0005U\u0003bBAu\u001f\u0002\u0007\u0011Q\u000b\u0005\u0007\u0003\u000fz\u0005\u0019A5\t\u000f\u0005Mr\n1\u0001\u00028!9\u0011qM(A\u0002\u0005-\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u00073\u001b)\u000b\u0005\u0004\u0002X\rm5qT\u0005\u0005\u0007;\u000byA\u0001\u0004PaRLwN\u001c\t\u000e\u0003/\u001a\t+!\u0016\u0002V%\f9$a\u001b\n\t\r\r\u0016q\u0002\u0002\u0007)V\u0004H.Z\u001b\t\u0013\r\u001d\u0006+!AA\u0002\tE\u0018a\u0001=%a\u0005A1/\u0019<f\u00136\u0004H\u000e\u0006\u0003\u0004.\u000eM\u0006\u0003BA,\u0007_KAa!-\u0002\u0010\t!QK\\5u\u0011\u001d\u00119-\u0015a\u0001\u0003\u0007\u0011Q\u0004T8hSN$\u0018n\u0019*fOJ,7o]5p]6{G-\u001a7SK\u0006$WM]\n\u0004%\neFCAB^!\r\u0011\tOU\u0001\nG2\f7o\u001d(b[\u0016\f!b\u00197bgNt\u0015-\\3!)\ry71\u0019\u0005\b\u0005\u000f4\u0006\u0019AA\u0002\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\r%\u0007\u0003BB\u001e\u0007\u0017LAa!4\u0004>\t1qJ\u00196fGRDSAKA\u0010\u0003[DS!KA\u0010\u0003[\u0004")
public class LogisticRegressionModel
extends ProbabilisticClassificationModel<Vector, LogisticRegressionModel>
implements MLWritable,
LogisticRegressionParams,
HasTrainingSummary<LogisticRegressionTrainingSummary> {
    private Vector _coefficients;
    private double _intercept;
    private final String uid;
    private final Matrix coefficientMatrix;
    private final Vector interceptVector;
    private final int numClasses;
    private final boolean org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial;
    private final Function1<Vector, Object> margin;
    private final Function1<Vector, Vector> margins;
    private final Function1<Vector, Object> score;
    private final int numFeatures;
    private Option<LogisticRegressionTrainingSummary> trainingSummary;
    private final Param<String> family;
    private final Param<Matrix> lowerBoundsOnCoefficients;
    private final Param<Matrix> upperBoundsOnCoefficients;
    private final Param<Vector> lowerBoundsOnIntercepts;
    private final Param<Vector> upperBoundsOnIntercepts;
    private final IntParam aggregationDepth;
    private final DoubleParam threshold;
    private final Param<String> weightCol;
    private final BooleanParam standardization;
    private final DoubleParam tol;
    private final BooleanParam fitIntercept;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;
    private volatile byte bitmap$0;

    public static LogisticRegressionModel load(String string) {
        return LogisticRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<LogisticRegressionModel> read() {
        return LogisticRegressionModel$.MODULE$.read();
    }

    @Override
    public boolean hasSummary() {
        return HasTrainingSummary.hasSummary$(this);
    }

    @Override
    public HasTrainingSummary<LogisticRegressionTrainingSummary> setSummary(Option<LogisticRegressionTrainingSummary> summary) {
        return HasTrainingSummary.setSummary$(this, summary);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$classification$LogisticRegressionParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public String getFamily() {
        return LogisticRegressionParams.getFamily$(this);
    }

    @Override
    public void checkThresholdConsistency() {
        LogisticRegressionParams.checkThresholdConsistency$(this);
    }

    @Override
    public Matrix getLowerBoundsOnCoefficients() {
        return LogisticRegressionParams.getLowerBoundsOnCoefficients$(this);
    }

    @Override
    public Matrix getUpperBoundsOnCoefficients() {
        return LogisticRegressionParams.getUpperBoundsOnCoefficients$(this);
    }

    @Override
    public Vector getLowerBoundsOnIntercepts() {
        return LogisticRegressionParams.getLowerBoundsOnIntercepts$(this);
    }

    @Override
    public Vector getUpperBoundsOnIntercepts() {
        return LogisticRegressionParams.getUpperBoundsOnIntercepts$(this);
    }

    @Override
    public boolean usingBoundConstrainedOptimization() {
        return LogisticRegressionParams.usingBoundConstrainedOptimization$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return LogisticRegressionParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization.getStandardization$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam.getElasticNetParam$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final Option<LogisticRegressionTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    @Override
    public final void trainingSummary_$eq(Option<LogisticRegressionTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    @Override
    public final Param<String> family() {
        return this.family;
    }

    @Override
    public Param<Matrix> lowerBoundsOnCoefficients() {
        return this.lowerBoundsOnCoefficients;
    }

    @Override
    public Param<Matrix> upperBoundsOnCoefficients() {
        return this.upperBoundsOnCoefficients;
    }

    @Override
    public Param<Vector> lowerBoundsOnIntercepts() {
        return this.lowerBoundsOnIntercepts;
    }

    @Override
    public Param<Vector> upperBoundsOnIntercepts() {
        return this.upperBoundsOnIntercepts;
    }

    @Override
    public final void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$family_$eq(Param<String> x$1) {
        this.family = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnCoefficients_$eq(Param<Matrix> x$1) {
        this.lowerBoundsOnCoefficients = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnCoefficients_$eq(Param<Matrix> x$1) {
        this.upperBoundsOnCoefficients = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnIntercepts_$eq(Param<Vector> x$1) {
        this.lowerBoundsOnIntercepts = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnIntercepts_$eq(Param<Vector> x$1) {
        this.upperBoundsOnIntercepts = x$1;
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Matrix coefficientMatrix() {
        return this.coefficientMatrix;
    }

    public Vector interceptVector() {
        return this.interceptVector;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    public boolean org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial() {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial;
    }

    public Vector coefficients() {
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            throw new SparkException("Multinomial models contain a matrix of coefficients, use coefficientMatrix instead.");
        }
        return this._coefficients();
    }

    private Vector _coefficients$lzycompute() {
        LogisticRegressionModel logisticRegressionModel = this;
        synchronized (logisticRegressionModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Vector vector;
                Predef$.MODULE$.require(this.coefficientMatrix().isTransposed(), (Function0 & Serializable & scala.Serializable)() -> "LogisticRegressionModel coefficients should be row major for binomial model.");
                Matrix matrix = this.coefficientMatrix();
                if (matrix instanceof DenseMatrix) {
                    DenseMatrix denseMatrix = (DenseMatrix)matrix;
                    vector = Vectors$.MODULE$.dense(denseMatrix.values());
                } else if (matrix instanceof SparseMatrix) {
                    SparseMatrix sparseMatrix = (SparseMatrix)matrix;
                    vector = Vectors$.MODULE$.sparse(this.coefficientMatrix().numCols(), sparseMatrix.rowIndices(), sparseMatrix.values());
                } else {
                    throw new MatchError((Object)matrix);
                }
                this._coefficients = vector;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this._coefficients;
    }

    private Vector _coefficients() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this._coefficients$lzycompute() : this._coefficients;
    }

    public double intercept() {
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            throw new SparkException("Multinomial models contain a vector of intercepts, use interceptVector instead.");
        }
        return this._intercept();
    }

    private double _intercept$lzycompute() {
        LogisticRegressionModel logisticRegressionModel = this;
        synchronized (logisticRegressionModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this._intercept = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.interceptVector().toArray())).head());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this._intercept;
    }

    private double _intercept() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this._intercept$lzycompute() : this._intercept;
    }

    @Override
    public LogisticRegressionModel setThreshold(double value) {
        return (LogisticRegressionModel)LogisticRegressionParams.setThreshold$(this, value);
    }

    @Override
    public double getThreshold() {
        return LogisticRegressionParams.getThreshold$(this);
    }

    @Override
    public LogisticRegressionModel setThresholds(double[] value) {
        return (LogisticRegressionModel)LogisticRegressionParams.setThresholds$(this, value);
    }

    @Override
    public double[] getThresholds() {
        return LogisticRegressionParams.getThresholds$(this);
    }

    private Function1<Vector, Object> margin() {
        return this.margin;
    }

    private Function1<Vector, Vector> margins() {
        return this.margins;
    }

    private Function1<Vector, Object> score() {
        return this.score;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public LogisticRegressionTrainingSummary summary() {
        return (LogisticRegressionTrainingSummary)HasTrainingSummary.summary$(this);
    }

    public BinaryLogisticRegressionTrainingSummary binarySummary() {
        BinaryLogisticRegressionTrainingSummary binaryLogisticRegressionTrainingSummary;
        LogisticRegressionTrainingSummary logisticRegressionTrainingSummary = this.summary();
        if (!(logisticRegressionTrainingSummary instanceof BinaryLogisticRegressionTrainingSummary)) {
            throw new RuntimeException(new StringBuilder(88).append("Cannot create a binary summary for a non-binary model").append("(numClasses=").append(this.numClasses()).append("), use summary instead.").toString());
        }
        BinaryLogisticRegressionTrainingSummary binaryLogisticRegressionTrainingSummary2 = binaryLogisticRegressionTrainingSummary = (BinaryLogisticRegressionTrainingSummary)logisticRegressionTrainingSummary;
        return binaryLogisticRegressionTrainingSummary2;
    }

    public Tuple3<LogisticRegressionModel, String, String> findSummaryModel() {
        LogisticRegressionModel model = this.$(this.probabilityCol()).isEmpty() && this.$(this.predictionCol()).isEmpty() ? (LogisticRegressionModel)((PredictionModel)this.copy(ParamMap$.MODULE$.empty()).setProbabilityCol(new StringBuilder(12).append("probability_").append(UUID.randomUUID().toString()).toString())).setPredictionCol(new StringBuilder(11).append("prediction_").append(UUID.randomUUID().toString()).toString()) : (this.$(this.probabilityCol()).isEmpty() ? (LogisticRegressionModel)this.copy(ParamMap$.MODULE$.empty()).setProbabilityCol(new StringBuilder(12).append("probability_").append(UUID.randomUUID().toString()).toString()) : (this.$(this.predictionCol()).isEmpty() ? (LogisticRegressionModel)this.copy(ParamMap$.MODULE$.empty()).setPredictionCol(new StringBuilder(11).append("prediction_").append(UUID.randomUUID().toString()).toString()) : this));
        return new Tuple3((Object)model, (Object)model.getProbabilityCol(), (Object)model.getPredictionCol());
    }

    public LogisticRegressionSummary evaluate(Dataset<?> dataset) {
        Tuple3<LogisticRegressionModel, String, String> tuple3 = this.findSummaryModel();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        LogisticRegressionModel summaryModel = (LogisticRegressionModel)tuple3._1();
        String probabilityColName = (String)tuple3._2();
        String predictionColName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)summaryModel, (Object)probabilityColName, (Object)predictionColName);
        Tuple3 tuple33 = tuple32;
        LogisticRegressionModel summaryModel2 = (LogisticRegressionModel)tuple33._1();
        String probabilityColName2 = (String)tuple33._2();
        String predictionColName2 = (String)tuple33._3();
        return this.numClasses() > 2 ? new LogisticRegressionSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol())) : new BinaryLogisticRegressionSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()));
    }

    @Override
    public double predict(Vector features) {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial() ? super.predict(features) : (BoxesRunTime.unboxToDouble((Object)this.score().apply((Object)features)) > this.getThreshold() ? 1.0 : 0.0);
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        DenseVector denseVector;
        Vector vector = rawPrediction;
        if (vector instanceof DenseVector) {
            DenseVector denseVector2 = (DenseVector)vector;
            if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
                int size = denseVector2.size();
                double[] values = denseVector2.values();
                int maxMarginIndex = rawPrediction.argmax();
                double maxMargin = rawPrediction.apply(maxMarginIndex);
                if (maxMargin == Double.POSITIVE_INFINITY) {
                    for (int k = 0; k < size; ++k) {
                        values[k] = k == maxMarginIndex ? 1.0 : 0.0;
                    }
                } else {
                    double temp = 0.0;
                    for (int k = 0; k < this.numClasses(); ++k) {
                        values[k] = maxMargin > 0.0 ? scala.math.package$.MODULE$.exp(values[k] - maxMargin) : scala.math.package$.MODULE$.exp(values[k]);
                        temp += values[k];
                    }
                    double sum = temp;
                    BLAS$.MODULE$.scal(1.0 / sum, (Vector)denseVector2);
                }
                denseVector = denseVector2;
            } else {
                int size = denseVector2.size();
                for (int i = 0; i < size; ++i) {
                    denseVector2.values()[i] = 1.0 / (1.0 + scala.math.package$.MODULE$.exp(-denseVector2.values()[i]));
                }
                denseVector = denseVector2;
            }
        } else {
            if (vector instanceof SparseVector) {
                throw new RuntimeException("Unexpected error in LogisticRegressionModel: raw2probabilitiesInPlace encountered SparseVector");
            }
            throw new MatchError((Object)vector);
        }
        DenseVector denseVector3 = denseVector;
        return denseVector3;
    }

    @Override
    public Vector predictRaw(Vector features) {
        Vector vector;
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            vector = (Vector)this.margins().apply((Object)features);
        } else {
            double m = BoxesRunTime.unboxToDouble((Object)this.margin().apply((Object)features));
            vector = Vectors$.MODULE$.dense(-m, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{m}));
        }
        return vector;
    }

    @Override
    public LogisticRegressionModel copy(ParamMap extra) {
        LogisticRegressionModel newModel = this.copyValues(new LogisticRegressionModel(this.uid(), this.coefficientMatrix(), this.interceptVector(), this.numClasses(), this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()), extra);
        return (LogisticRegressionModel)((Model)((Object)newModel.setSummary(this.trainingSummary()))).setParent(this.parent());
    }

    @Override
    public double raw2prediction(Vector rawPrediction) {
        double d;
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            d = super.raw2prediction(rawPrediction);
        } else {
            double t = this.getThreshold();
            double rawThreshold = t == 0.0 ? Double.NEGATIVE_INFINITY : (t == 1.0 ? Double.POSITIVE_INFINITY : scala.math.package$.MODULE$.log(t / (1.0 - t)));
            d = rawPrediction.apply(1) > rawThreshold ? 1.0 : 0.0;
        }
        return d;
    }

    @Override
    public double probability2prediction(Vector probability) {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial() ? super.probability2prediction(probability) : (probability.apply(1) > this.getThreshold() ? 1.0 : 0.0);
    }

    @Override
    public MLWriter write() {
        return new LogisticRegressionModelWriter(this);
    }

    @Override
    public String toString() {
        return new StringBuilder(56).append("LogisticRegressionModel: uid=").append(this.uid()).append(", numClasses=").append(this.numClasses()).append(", numFeatures=").append(this.numFeatures()).toString();
    }

    public static final /* synthetic */ double $anonfun$margin$1(LogisticRegressionModel $this, Vector features) {
        return BLAS$.MODULE$.dot(features, $this._coefficients()) + $this._intercept();
    }

    public static final /* synthetic */ double $anonfun$score$1(LogisticRegressionModel $this, Vector features) {
        double m = BoxesRunTime.unboxToDouble((Object)$this.margin().apply((Object)features));
        return 1.0 / (1.0 + scala.math.package$.MODULE$.exp(-m));
    }

    public LogisticRegressionModel(String uid, Matrix coefficientMatrix, Vector interceptVector, int numClasses, boolean isMultinomial) {
        this.uid = uid;
        this.coefficientMatrix = coefficientMatrix;
        this.interceptVector = interceptVector;
        this.numClasses = numClasses;
        this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial = isMultinomial;
        MLWritable.$init$(this);
        HasRegParam.$init$(this);
        HasElasticNetParam.$init$(this);
        HasMaxIter.$init$(this);
        HasFitIntercept.$init$(this);
        HasTol.$init$(this);
        HasStandardization.$init$(this);
        HasWeightCol.$init$(this);
        HasThreshold.$init$(this);
        HasAggregationDepth.$init$(this);
        LogisticRegressionParams.$init$(this);
        HasTrainingSummary.$init$(this);
        Predef$.MODULE$.require(coefficientMatrix.numRows() == interceptVector.size(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(88).append("Dimension mismatch! Expected ").append("coefficientMatrix.numRows == interceptVector.size, but ").append(this.coefficientMatrix().numRows()).append(" != ").append(this.interceptVector().size()).toString());
        this.margin = (Function1 & Serializable & scala.Serializable)features -> BoxesRunTime.boxToDouble((double)LogisticRegressionModel.$anonfun$margin$1(this, features));
        this.margins = (Function1 & Serializable & scala.Serializable)features -> {
            void var2_2;
            DenseVector m = this.interceptVector().toDense().copy();
            BLAS$.MODULE$.gemv(1.0, this.coefficientMatrix(), features, 1.0, m);
            return var2_2;
        };
        this.score = (Function1 & Serializable & scala.Serializable)features -> BoxesRunTime.boxToDouble((double)LogisticRegressionModel.$anonfun$score$1(this, features));
        this.numFeatures = coefficientMatrix.numCols();
    }

    public LogisticRegressionModel(String uid, Vector coefficients, double intercept) {
        this(uid, (Matrix)new DenseMatrix(1, coefficients.size(), coefficients.toArray(), true), Vectors$.MODULE$.dense(intercept, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), 2, false);
    }

    public static class LogisticRegressionModelReader
    extends MLReader<LogisticRegressionModel> {
        private final String className = LogisticRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public LogisticRegressionModel load(String path) {
            LogisticRegressionModel logisticRegressionModel;
            DefaultParamsReader.Metadata metadata;
            block10: {
                Matrix matrix;
                Vector vector;
                int n;
                int n2;
                Object isMultinomial;
                block12: {
                    Row row;
                    block11: {
                        Dataset data;
                        block7: {
                            double d;
                            int n3;
                            int n4;
                            Object coefficients;
                            block9: {
                                Row row2;
                                block8: {
                                    metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
                                    Tuple2 tuple2 = VersionUtils$.MODULE$.majorMinorVersion(metadata.sparkVersion());
                                    if (tuple2 == null) {
                                        throw new MatchError((Object)tuple2);
                                    }
                                    int major = tuple2._1$mcI$sp();
                                    int minor = tuple2._2$mcI$sp();
                                    Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(major, minor);
                                    Tuple2.mcII.sp sp3 = sp2;
                                    int major2 = sp3._1$mcI$sp();
                                    int minor2 = sp3._2$mcI$sp();
                                    String dataPath = new Path(path, "data").toString();
                                    data = this.sparkSession().read().format("parquet").load(dataPath);
                                    if (major2 >= 2 && (major2 != 2 || minor2 != 0)) break block7;
                                    row2 = (Row)MLUtils$.MODULE$.convertVectorColumnsToML(data, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).select("numClasses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numFeatures", "intercept", "coefficients"})).head();
                                    Some some = Row$.MODULE$.unapplySeq(row2);
                                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(4) != 0) break block8;
                                    Object numClasses = ((SeqLike)some.get()).apply(0);
                                    Object numFeatures = ((SeqLike)some.get()).apply(1);
                                    Object intercept = ((SeqLike)some.get()).apply(2);
                                    coefficients = ((SeqLike)some.get()).apply(3);
                                    if (!(numClasses instanceof Integer)) break block8;
                                    n4 = BoxesRunTime.unboxToInt((Object)numClasses);
                                    if (!(numFeatures instanceof Integer)) break block8;
                                    n3 = BoxesRunTime.unboxToInt((Object)numFeatures);
                                    if (!(intercept instanceof Double)) break block8;
                                    d = BoxesRunTime.unboxToDouble((Object)intercept);
                                    if (coefficients instanceof Vector) break block9;
                                }
                                throw new MatchError((Object)row2);
                            }
                            Vector vector2 = (Vector)coefficients;
                            Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)n4), (Object)BoxesRunTime.boxToInteger((int)n3), (Object)BoxesRunTime.boxToDouble((double)d), (Object)vector2);
                            Tuple4 tuple42 = tuple4;
                            int numClasses = BoxesRunTime.unboxToInt((Object)tuple42._1());
                            int numFeatures = BoxesRunTime.unboxToInt((Object)tuple42._2());
                            double intercept = BoxesRunTime.unboxToDouble((Object)tuple42._3());
                            Vector coefficients2 = (Vector)tuple42._4();
                            DenseMatrix coefficientMatrix = new DenseMatrix(1, coefficients2.size(), coefficients2.toArray(), true);
                            Vector interceptVector = Vectors$.MODULE$.dense(intercept, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
                            logisticRegressionModel = new LogisticRegressionModel(metadata.uid(), (Matrix)coefficientMatrix, interceptVector, numClasses, false);
                            break block10;
                        }
                        row = (Row)data.select("numClasses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numFeatures", "interceptVector", "coefficientMatrix", "isMultinomial"})).head();
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(5) != 0) break block11;
                        Object numClasses = ((SeqLike)some.get()).apply(0);
                        Object numFeatures = ((SeqLike)some.get()).apply(1);
                        Object interceptVector = ((SeqLike)some.get()).apply(2);
                        Object coefficientMatrix = ((SeqLike)some.get()).apply(3);
                        isMultinomial = ((SeqLike)some.get()).apply(4);
                        if (!(numClasses instanceof Integer)) break block11;
                        n2 = BoxesRunTime.unboxToInt((Object)numClasses);
                        if (!(numFeatures instanceof Integer)) break block11;
                        n = BoxesRunTime.unboxToInt((Object)numFeatures);
                        if (!(interceptVector instanceof Vector)) break block11;
                        vector = (Vector)interceptVector;
                        if (!(coefficientMatrix instanceof Matrix)) break block11;
                        matrix = (Matrix)coefficientMatrix;
                        if (isMultinomial instanceof Boolean) break block12;
                    }
                    throw new MatchError((Object)row);
                }
                boolean bl = BoxesRunTime.unboxToBoolean((Object)isMultinomial);
                Tuple5 tuple5 = new Tuple5((Object)BoxesRunTime.boxToInteger((int)n2), (Object)BoxesRunTime.boxToInteger((int)n), (Object)vector, (Object)matrix, (Object)BoxesRunTime.boxToBoolean((boolean)bl));
                Tuple5 tuple52 = tuple5;
                int numClasses = BoxesRunTime.unboxToInt((Object)tuple52._1());
                int numFeatures = BoxesRunTime.unboxToInt((Object)tuple52._2());
                Vector interceptVector = (Vector)tuple52._3();
                Matrix coefficientMatrix = (Matrix)tuple52._4();
                boolean isMultinomial2 = BoxesRunTime.unboxToBoolean((Object)tuple52._5());
                logisticRegressionModel = new LogisticRegressionModel(metadata.uid(), coefficientMatrix, interceptVector, numClasses, isMultinomial2);
            }
            LogisticRegressionModel model = logisticRegressionModel;
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class LogisticRegressionModelWriter
    extends MLWriter {
        private volatile LogisticRegressionModel$LogisticRegressionModelWriter$Data$ Data$module;
        private final LogisticRegressionModel instance;

        private LogisticRegressionModel$LogisticRegressionModelWriter$Data$ Data() {
            if (this.Data$module == null) {
                this.Data$lzycompute$1();
            }
            return this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Data data = new Data(this, this.instance.numClasses(), this.instance.numFeatures(), this.instance.interceptVector(), this.instance.coefficientMatrix(), this.instance.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LogisticRegressionModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.classification.LogisticRegressionModel.LogisticRegressionModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.classification.LogisticRegressionModel.LogisticRegressionModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1(LogisticRegressionModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Data[]{data})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1(null))).repartition(1).write().parquet(dataPath);
        }

        private final void Data$lzycompute$1() {
            LogisticRegressionModelWriter logisticRegressionModelWriter = this;
            synchronized (logisticRegressionModelWriter) {
                if (this.Data$module == null) {
                    this.Data$module = new LogisticRegressionModel$LogisticRegressionModelWriter$Data$(this);
                }
            }
        }

        public LogisticRegressionModelWriter(LogisticRegressionModel instance) {
            this.instance = instance;
        }

        public class Data
        implements Product,
        scala.Serializable {
            private final int numClasses;
            private final int numFeatures;
            private final Vector interceptVector;
            private final Matrix coefficientMatrix;
            private final boolean isMultinomial;
            public final /* synthetic */ LogisticRegressionModelWriter $outer;

            public int numClasses() {
                return this.numClasses;
            }

            public int numFeatures() {
                return this.numFeatures;
            }

            public Vector interceptVector() {
                return this.interceptVector;
            }

            public Matrix coefficientMatrix() {
                return this.coefficientMatrix;
            }

            public boolean isMultinomial() {
                return this.isMultinomial;
            }

            public Data copy(int numClasses, int numFeatures, Vector interceptVector, Matrix coefficientMatrix, boolean isMultinomial) {
                return new Data(this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer(), numClasses, numFeatures, interceptVector, coefficientMatrix, isMultinomial);
            }

            public int copy$default$1() {
                return this.numClasses();
            }

            public int copy$default$2() {
                return this.numFeatures();
            }

            public Vector copy$default$3() {
                return this.interceptVector();
            }

            public Matrix copy$default$4() {
                return this.coefficientMatrix();
            }

            public boolean copy$default$5() {
                return this.isMultinomial();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 5;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    case 0: {
                        object = BoxesRunTime.boxToInteger((int)this.numClasses());
                        break;
                    }
                    case 1: {
                        object = BoxesRunTime.boxToInteger((int)this.numFeatures());
                        break;
                    }
                    case 2: {
                        object = this.interceptVector();
                        break;
                    }
                    case 3: {
                        object = this.coefficientMatrix();
                        break;
                    }
                    case 4: {
                        object = BoxesRunTime.boxToBoolean((boolean)this.isMultinomial());
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.numClasses());
                n = Statics.mix((int)n, (int)this.numFeatures());
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.interceptVector()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficientMatrix()));
                n = Statics.mix((int)n, (int)(this.isMultinomial() ? 1231 : 1237));
                return Statics.finalizeHash((int)n, (int)5);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                if (((Data)object).org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer() != this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                if (this.numClasses() != data.numClasses()) return false;
                if (this.numFeatures() != data.numFeatures()) return false;
                Vector vector = this.interceptVector();
                Vector vector2 = data.interceptVector();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                Matrix matrix = this.coefficientMatrix();
                Matrix matrix2 = data.coefficientMatrix();
                if (matrix == null) {
                    if (matrix2 != null) {
                        return false;
                    }
                } else if (!matrix.equals(matrix2)) return false;
                if (this.isMultinomial() != data.isMultinomial()) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ LogisticRegressionModelWriter org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(LogisticRegressionModelWriter $outer, int numClasses, int numFeatures, Vector interceptVector, Matrix coefficientMatrix, boolean isMultinomial) {
                this.numClasses = numClasses;
                this.numFeatures = numFeatures;
                this.interceptVector = interceptVector;
                this.coefficientMatrix = coefficientMatrix;
                this.isMultinomial = isMultinomial;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

