/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.recommendation;

import com.github.fommil.netlib.BLAS;
import java.io.IOException;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.rdd.MLPairRDDFunctions$;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel$;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel$$anonfun$9$;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel$SaveLoadV1_0$;
import org.apache.spark.mllib.util.Loader;
import org.apache.spark.mllib.util.Loader$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.BoundedPriorityQueue;
import org.json4s.JsonAST;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class MatrixFactorizationModel$
implements Loader<MatrixFactorizationModel>,
Serializable {
    public static final MatrixFactorizationModel$ MODULE$;

    static {
        new MatrixFactorizationModel$();
    }

    public Tuple2<Object, Object>[] org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommend(double[] recommendToFeatures, RDD<Tuple2<Object, double[]>> recommendableFeatures, int num) {
        RDD scored = recommendableFeatures.map((Function1)new Serializable(recommendToFeatures){
            public static final long serialVersionUID = 0L;
            private final double[] recommendToFeatures$1;

            public final Tuple2<Object, Object> apply(Tuple2<Object, double[]> x0$9) {
                Tuple2<Object, double[]> tuple2 = x0$9;
                if (tuple2 != null) {
                    int id = tuple2._1$mcI$sp();
                    double[] features = (double[])tuple2._2();
                    Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(id, BLAS.getInstance().ddot(features.length, this.recommendToFeatures$1, 1, features, 1));
                    return sp2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.recommendToFeatures$1 = recommendToFeatures$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return (Tuple2[])scored.top(num, scala.package$.MODULE$.Ordering().by((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> x$3) {
                return x$3._2$mcD$sp();
            }
        }, (Ordering)Ordering.Double$.MODULE$));
    }

    public RDD<Tuple2<Object, Tuple2<Object, Object>[]>> org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommendForAll(int rank, RDD<Tuple2<Object, double[]>> srcFeatures, RDD<Tuple2<Object, double[]>> dstFeatures, int num) {
        RDD<Seq<Tuple2<Object, double[]>>> srcBlocks = this.blockify(srcFeatures, this.blockify$default$2());
        RDD<Seq<Tuple2<Object, double[]>>> dstBlocks = this.blockify(dstFeatures, this.blockify$default$2());
        RDD ratings = srcBlocks.cartesian(dstBlocks, ClassTag$.MODULE$.apply(Seq.class)).flatMap((Function1)new Serializable(rank, num){
            public static final long serialVersionUID = 0L;
            public final int rank$1;
            private final int num$1;

            public final Seq<Tuple2<Object, Tuple2<Object, Object>>> apply(Tuple2<Seq<Tuple2<Object, double[]>>, Seq<Tuple2<Object, double[]>>> x0$10) {
                Tuple2<Seq<Tuple2<Object, double[]>>, Seq<Tuple2<Object, double[]>>> tuple2 = x0$10;
                if (tuple2 != null) {
                    Seq srcIter = (Seq)tuple2._1();
                    Seq dstIter = (Seq)tuple2._2();
                    int m = srcIter.size();
                    int n = package$.MODULE$.min(dstIter.size(), this.num$1);
                    Tuple2[] output = new Tuple2[m * n];
                    IntRef i = IntRef.create((int)0);
                    BoundedPriorityQueue pq = new BoundedPriorityQueue(n, scala.package$.MODULE$.Ordering().by((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final double apply(Tuple2<Object, Object> x$4) {
                            return x$4._2$mcD$sp();
                        }
                    }, (Ordering)Ordering.Double$.MODULE$));
                    srcIter.foreach((Function1)new Serializable(this, dstIter, output, i, pq){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.9 $outer;
                        private final Seq dstIter$1;
                        public final Tuple2[] output$1;
                        public final IntRef i$1;
                        public final BoundedPriorityQueue pq$1;

                        public final void apply(Tuple2<Object, double[]> x0$11) {
                            Tuple2<Object, double[]> tuple2 = x0$11;
                            if (tuple2 != null) {
                                int srcId = tuple2._1$mcI$sp();
                                double[] srcFactor = (double[])tuple2._2();
                                this.dstIter$1.foreach((Function1)new Serializable(this, srcFactor){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun$9$$anonfun$apply$1 $outer;
                                    private final double[] srcFactor$1;

                                    public final BoundedPriorityQueue<Tuple2<Object, Object>> apply(Tuple2<Object, double[]> x0$12) {
                                        Tuple2<Object, double[]> tuple2 = x0$12;
                                        if (tuple2 != null) {
                                            int dstId = tuple2._1$mcI$sp();
                                            double[] dstFactor = (double[])tuple2._2();
                                            double score = BLAS$.MODULE$.f2jBLAS().ddot(this.$outer.org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$anonfun$$anonfun$$$outer().rank$1, this.srcFactor$1, 1, dstFactor, 1);
                                            BoundedPriorityQueue boundedPriorityQueue = this.$outer.pq$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)dstId)), (Object)BoxesRunTime.boxToDouble((double)score)));
                                            return boundedPriorityQueue;
                                        }
                                        throw new MatchError(tuple2);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.srcFactor$1 = srcFactor$1;
                                    }
                                });
                                this.pq$1.foreach((Function1)new Serializable(this, srcId){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun$9$$anonfun$apply$1 $outer;
                                    private final int srcId$1;

                                    public final void apply(Tuple2<Object, Object> x0$13) {
                                        Tuple2<Object, Object> tuple2 = x0$13;
                                        if (tuple2 != null) {
                                            int dstId = tuple2._1$mcI$sp();
                                            double score = tuple2._2$mcD$sp();
                                            this.$outer.output$1[this.$outer.i$1.elem] = new Tuple2((Object)BoxesRunTime.boxToInteger((int)this.srcId$1), (Object)new Tuple2.mcID.sp(dstId, score));
                                            ++this.$outer.i$1.elem;
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            return;
                                        }
                                        throw new MatchError(tuple2);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.srcId$1 = srcId$1;
                                    }
                                });
                                this.pq$1.clear();
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }

                        public /* synthetic */ anonfun.9 org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.dstIter$1 = dstIter$1;
                            this.output$1 = output$1;
                            this.i$1 = i$1;
                            this.pq$1 = pq$1;
                        }
                    });
                    Seq seq = Predef$.MODULE$.refArrayOps((Object[])output).toSeq();
                    return seq;
                }
                throw new MatchError(tuple2);
            }
            {
                this.rank$1 = rank$1;
                this.num$1 = num$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return MLPairRDDFunctions$.MODULE$.fromPairRDD(ratings, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class)).topByKey(num, scala.package$.MODULE$.Ordering().by((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> x$5) {
                return x$5._2$mcD$sp();
            }
        }, (Ordering)Ordering.Double$.MODULE$));
    }

    private RDD<Seq<Tuple2<Object, double[]>>> blockify(RDD<Tuple2<Object, double[]>> features, int blockSize) {
        return features.mapPartitions((Function1)new Serializable(blockSize){
            public static final long serialVersionUID = 0L;
            private final int blockSize$1;

            public final Iterator.GroupedIterator<Tuple2<Object, double[]>> apply(Iterator<Tuple2<Object, double[]>> iter) {
                return iter.grouped(this.blockSize$1);
            }
            {
                this.blockSize$1 = blockSize$1;
            }
        }, features.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Seq.class));
    }

    private int blockify$default$2() {
        return 4096;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MatrixFactorizationModel load(SparkContext sc, String path) {
        Tuple3<String, String, JsonAST.JValue> tuple3 = Loader$.MODULE$.loadMetadata(sc, path);
        if (tuple3 != null) {
            void var10_10;
            void var9_9;
            void var8_8;
            Tuple2 tuple2;
            String loadedClassName = (String)tuple3._1();
            String formatVersion = (String)tuple3._2();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)loadedClassName, (Object)formatVersion);
            String loadedClassName2 = (String)tuple22._1();
            String formatVersion2 = (String)tuple22._2();
            String classNameV1_0 = MatrixFactorizationModel$SaveLoadV1_0$.MODULE$.thisClassName();
            Tuple2 tuple23 = new Tuple2((Object)loadedClassName2, (Object)formatVersion2);
            if (tuple23 != null) {
                String className = (String)tuple23._1();
                String string = (String)tuple23._2();
                if ("1.0".equals(string)) {
                    String string2 = className;
                    String string3 = classNameV1_0;
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        MatrixFactorizationModel matrixFactorizationModel = MatrixFactorizationModel$SaveLoadV1_0$.MODULE$.load(sc, path);
                        return matrixFactorizationModel;
                    }
                }
            }
            throw new IOException(new StringBuilder().append((Object)"MatrixFactorizationModel.load did not recognize model with").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(class: ", ", version: ", "). Supported:\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var8_8, var9_9}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  (", ", 1.0)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var10_10}))).toString());
        }
        throw new MatchError(tuple3);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MatrixFactorizationModel$() {
        MODULE$ = this;
    }
}

