/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00014a!\u0001\u0002\u0002\u0002\ta!AC*jY\"|W/\u001a;uK*\u00111\u0001B\u0001\u000bKZ\fG.^1uS>t'BA\u0003\u0007\u0003\tiGN\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h'\t\u0001Q\u0002\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006)\u0001!\tAF\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\tq\u0003\u0005\u0002\u0019\u00015\t!\u0001C\u0003\u001b\u0001\u0011\u00051$\u0001\u000eq_&tGoU5mQ>,X\r\u001e;f\u0007>,gMZ5dS\u0016tG\u000fF\u0003\u001d?!Rs\u0006\u0005\u0002\u000f;%\u0011ad\u0004\u0002\u0007\t>,(\r\\3\t\u000b\u0001J\u0002\u0019A\u0011\u0002\u0015\rdWo\u001d;fe&#7\u000fE\u0002#Kqq!AD\u0012\n\u0005\u0011z\u0011A\u0002)sK\u0012,g-\u0003\u0002'O\t\u00191+\u001a;\u000b\u0005\u0011z\u0001\"B\u0015\u001a\u0001\u0004a\u0012A\u00049pS:$8\t\\;ti\u0016\u0014\u0018\n\u001a\u0005\u0006We\u0001\r\u0001L\u0001\u0018a>Lg\u000e^\"mkN$XM\u001d(v[>3\u0007k\\5oiN\u0004\"AD\u0017\n\u00059z!\u0001\u0002'p]\u001eDQ\u0001M\rA\u0002E\n\u0001$\u0019<fe\u0006<W\rR5ti\u0006t7-\u001a+p\u00072,8\u000f^3s!\u0011q!\u0007\b\u000f\n\u0005Mz!!\u0003$v]\u000e$\u0018n\u001c82\u0011\u0015)\u0004\u0001\"\u00017\u00031yg/\u001a:bY2\u001c6m\u001c:f)\rar'\u0014\u0005\u0006qQ\u0002\r!O\u0001\u0003I\u001a\u0004\"A\u000f&\u000f\u0005m:eB\u0001\u001fF\u001d\tiDI\u0004\u0002?\u0007:\u0011qHQ\u0007\u0002\u0001*\u0011\u0011)F\u0001\u0007yI|w\u000e\u001e \n\u0003-I!!\u0003\u0006\n\u0005\u001dA\u0011B\u0001$\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0003\u0011&\u000bq\u0001]1dW\u0006<WM\u0003\u0002G\r%\u00111\n\u0014\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T!\u0001S%\t\u000b9#\u0004\u0019A(\u0002\u0017M\u001cwN]3D_2,XN\u001c\t\u0003!Fk\u0011!S\u0005\u0003%&\u0013aaQ8mk6t\u0007\"\u0002+\u0001\t#)\u0016aE4fi:+XNY3s\u001f\u001a4U-\u0019;ve\u0016\u001cHc\u0001,Z7B\u0011abV\u0005\u00031>\u00111!\u00138u\u0011\u0015Q6\u000b1\u0001:\u0003%!\u0017\r^1Ge\u0006lW\rC\u0003]'\u0002\u0007Q,\u0001\u0006d_2,XN\u001c(b[\u0016\u0004\"A\t0\n\u0005};#AB*ue&tw\r")
public abstract class Silhouette {
    public double pointSilhouetteCoefficient(Set<Object> clusterIds, double pointClusterId, long pointClusterNumOfPoints, Function1<Object, Object> averageDistanceToCluster) {
        double currentClusterDissimilarity;
        Set otherClusterIds = (Set)clusterIds.filter((Function1)new Serializable(this, pointClusterId){
            public static final long serialVersionUID = 0L;
            private final double pointClusterId$1;

            public final boolean apply(double x$1) {
                return this.apply$mcZD$sp(x$1);
            }

            public boolean apply$mcZD$sp(double x$1) {
                return x$1 != this.pointClusterId$1;
            }
            {
                this.pointClusterId$1 = pointClusterId$1;
            }
        });
        double neighboringClusterDissimilarity = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)otherClusterIds.map(averageDistanceToCluster, Set$.MODULE$.canBuildFrom())).min((Ordering)Ordering.Double$.MODULE$));
        double d = currentClusterDissimilarity = pointClusterNumOfPoints == 1L ? 0.0 : averageDistanceToCluster.apply$mcDD$sp(pointClusterId) * (double)pointClusterNumOfPoints / (double)(pointClusterNumOfPoints - 1L);
        return currentClusterDissimilarity < neighboringClusterDissimilarity ? 1.0 - currentClusterDissimilarity / neighboringClusterDissimilarity : (currentClusterDissimilarity > neighboringClusterDissimilarity ? neighboringClusterDissimilarity / currentClusterDissimilarity - 1.0 : 0.0);
    }

    public double overallScore(Dataset<Row> df, Column scoreColumn) {
        return ((Row[])df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.avg(scoreColumn)})).collect())[0].getDouble(0);
    }

    public int getNumberOfFeatures(Dataset<Row> dataFrame, String columnName) {
        AttributeGroup group = AttributeGroup$.MODULE$.fromStructField(dataFrame.schema().apply(columnName));
        return group.size() < 0 ? ((Vector)((Row)dataFrame.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(columnName)})).first()).getAs(0)).size() : group.size();
    }
}

