/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.mllib.clustering.DistanceMeasure;
import org.apache.spark.mllib.clustering.DistanceMeasure$;
import org.apache.spark.mllib.clustering.KMeans$;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.clustering.LocalKMeans$;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.DoubleAccumulator;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeqLike;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\rma\u0001B\u0001\u0003\u00015\u0011aaS'fC:\u001c(BA\u0002\u0005\u0003)\u0019G.^:uKJLgn\u001a\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001a\u0002F\f\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\tyQ#\u0003\u0002\u0017!\ta1+\u001a:jC2L'0\u00192mKB\u0011\u0001dG\u0007\u00023)\u0011!DB\u0001\tS:$XM\u001d8bY&\u0011A$\u0007\u0002\b\u0019><w-\u001b8h\u0011!q\u0002A!a\u0001\n\u0013y\u0012!A6\u0016\u0003\u0001\u0002\"aD\u0011\n\u0005\t\u0002\"aA%oi\"AA\u0005\u0001BA\u0002\u0013%Q%A\u0003l?\u0012*\u0017\u000f\u0006\u0002'SA\u0011qbJ\u0005\u0003QA\u0011A!\u00168ji\"9!fIA\u0001\u0002\u0004\u0001\u0013a\u0001=%c!AA\u0006\u0001B\u0001B\u0003&\u0001%\u0001\u0002lA!Aa\u0006\u0001BA\u0002\u0013%q$A\u0007nCbLE/\u001a:bi&|gn\u001d\u0005\ta\u0001\u0011\t\u0019!C\u0005c\u0005\tR.\u0019=Ji\u0016\u0014\u0018\r^5p]N|F%Z9\u0015\u0005\u0019\u0012\u0004b\u0002\u00160\u0003\u0003\u0005\r\u0001\t\u0005\ti\u0001\u0011\t\u0011)Q\u0005A\u0005qQ.\u0019=Ji\u0016\u0014\u0018\r^5p]N\u0004\u0003\u0002\u0003\u001c\u0001\u0005\u0003\u0007I\u0011B\u001c\u0002%%t\u0017\u000e^5bY&T\u0018\r^5p]6{G-Z\u000b\u0002qA\u0011\u0011\b\u0010\b\u0003\u001fiJ!a\u000f\t\u0002\rA\u0013X\rZ3g\u0013\tidH\u0001\u0004TiJLgn\u001a\u0006\u0003wAA\u0001\u0002\u0011\u0001\u0003\u0002\u0004%I!Q\u0001\u0017S:LG/[1mSj\fG/[8o\u001b>$Wm\u0018\u0013fcR\u0011aE\u0011\u0005\bU}\n\t\u00111\u00019\u0011!!\u0005A!A!B\u0013A\u0014aE5oSRL\u0017\r\\5{CRLwN\\'pI\u0016\u0004\u0003\u0002\u0003$\u0001\u0005\u0003\u0007I\u0011B\u0010\u0002'%t\u0017\u000e^5bY&T\u0018\r^5p]N#X\r]:\t\u0011!\u0003!\u00111A\u0005\n%\u000bq#\u001b8ji&\fG.\u001b>bi&|gn\u0015;faN|F%Z9\u0015\u0005\u0019R\u0005b\u0002\u0016H\u0003\u0003\u0005\r\u0001\t\u0005\t\u0019\u0002\u0011\t\u0011)Q\u0005A\u0005!\u0012N\\5uS\u0006d\u0017N_1uS>t7\u000b^3qg\u0002B\u0001B\u0014\u0001\u0003\u0002\u0004%IaT\u0001\bKB\u001c\u0018\u000e\\8o+\u0005\u0001\u0006CA\bR\u0013\t\u0011\u0006C\u0001\u0004E_V\u0014G.\u001a\u0005\t)\u0002\u0011\t\u0019!C\u0005+\u0006YQ\r]:jY>tw\fJ3r)\t1c\u000bC\u0004+'\u0006\u0005\t\u0019\u0001)\t\u0011a\u0003!\u0011!Q!\nA\u000b\u0001\"\u001a9tS2|g\u000e\t\u0005\t5\u0002\u0011\t\u0019!C\u00057\u0006!1/Z3e+\u0005a\u0006CA\b^\u0013\tq\u0006C\u0001\u0003M_:<\u0007\u0002\u00031\u0001\u0005\u0003\u0007I\u0011B1\u0002\u0011M,W\rZ0%KF$\"A\n2\t\u000f)z\u0016\u0011!a\u00019\"AA\r\u0001B\u0001B\u0003&A,A\u0003tK\u0016$\u0007\u0005\u0003\u0005g\u0001\t\u0005\r\u0011\"\u00038\u0003=!\u0017n\u001d;b]\u000e,W*Z1tkJ,\u0007\u0002\u00035\u0001\u0005\u0003\u0007I\u0011B5\u0002'\u0011L7\u000f^1oG\u0016lU-Y:ve\u0016|F%Z9\u0015\u0005\u0019R\u0007b\u0002\u0016h\u0003\u0003\u0005\r\u0001\u000f\u0005\tY\u0002\u0011\t\u0011)Q\u0005q\u0005\u0001B-[:uC:\u001cW-T3bgV\u0014X\r\t\u0005\u0006]\u0002!Ia\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011A\u00148\u000f^;wob\u0004\"!\u001d\u0001\u000e\u0003\tAQAH7A\u0002\u0001BQAL7A\u0002\u0001BQAN7A\u0002aBQAR7A\u0002\u0001BQAT7A\u0002ACQAW7A\u0002qCQAZ7A\u0002aBQA\u001c\u0001\u0005\ni$\u0002\u0002]>}{z|\u0018\u0011\u0001\u0005\u0006=e\u0004\r\u0001\t\u0005\u0006]e\u0004\r\u0001\t\u0005\u0006me\u0004\r\u0001\u000f\u0005\u0006\rf\u0004\r\u0001\t\u0005\u0006\u001df\u0004\r\u0001\u0015\u0005\u00065f\u0004\r\u0001\u0018\u0015\u0006s\u0006\u0015\u0011\u0011\u0003\t\u0005\u0003\u000f\ti!\u0004\u0002\u0002\n)\u0019\u00111\u0002\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0010\u0005%!!B*j]\u000e,\u0017EAA\n\u0003\u0015\u0001d\u0006\u000f\u00181\u0011\u0019q\u0007\u0001\"\u0001\u0002\u0018Q\t\u0001\u000f\u000b\u0004\u0002\u0016\u0005\u0015\u0011\u0011\u0003\u0005\u0007\u0003;\u0001A\u0011A\u0010\u0002\t\u001d,Go\u0013\u0015\u0007\u00037\t)!!\t\"\u0005\u0005\r\u0012!B\u0019/i9\u0002\u0004bBA\u0014\u0001\u0011\u0005\u0011\u0011F\u0001\u0005g\u0016$8\n\u0006\u0003\u0002,\u00055R\"\u0001\u0001\t\ry\t)\u00031\u0001!Q\u0019\t)#!\u0002\u0002\u0012!1\u00111\u0007\u0001\u0005\u0002}\t\u0001cZ3u\u001b\u0006D\u0018\n^3sCRLwN\\:)\r\u0005E\u0012QAA\u0011\u0011\u001d\tI\u0004\u0001C\u0001\u0003w\t\u0001c]3u\u001b\u0006D\u0018\n^3sCRLwN\\:\u0015\t\u0005-\u0012Q\b\u0005\u0007]\u0005]\u0002\u0019\u0001\u0011)\r\u0005]\u0012QAA\t\u0011\u0019\t\u0019\u0005\u0001C\u0001o\u0005)r-\u001a;J]&$\u0018.\u00197ju\u0006$\u0018n\u001c8N_\u0012,\u0007FBA!\u0003\u000b\t\t\u0003C\u0004\u0002J\u0001!\t!a\u0013\u0002+M,G/\u00138ji&\fG.\u001b>bi&|g.T8eKR!\u00111FA'\u0011\u00191\u0014q\ta\u0001q!2\u0011qIA\u0003\u0003#Aa!a\u0015\u0001\t\u0003y\u0012aB4fiJ+hn\u001d\u0015\t\u0003#\n9&!\u0018\u0002bA\u0019q\"!\u0017\n\u0007\u0005m\u0003C\u0001\u0006eKB\u0014XmY1uK\u0012\f#!a\u0018\u0002OQC\u0017n\u001d\u0011iCN\u0004cn\u001c\u0011fM\u001a,7\r\u001e\u0011b]\u0012\u0004\u0013\r\\<bsN\u0004#/\u001a;ve:\u001c\b%M\u0011\u0003\u0003G\nQA\r\u00182]ABc!!\u0015\u0002\u0006\u0005\u0005\u0002bBA5\u0001\u0011\u0005\u00111N\u0001\bg\u0016$(+\u001e8t)\u0011\tY#!\u001c\t\u000f\u0005=\u0014q\ra\u0001A\u0005!!/\u001e8tQ!\t9'a\u0016\u0002t\u0005\u0005\u0014EAA;\u0003I!\u0006.[:!Q\u0006\u001c\bE\\8!K\u001a4Wm\u0019;)\r\u0005\u001d\u0014QAA\t\u0011\u0019\tY\b\u0001C\u0001?\u00051r-\u001a;J]&$\u0018.\u00197ju\u0006$\u0018n\u001c8Ti\u0016\u00048\u000f\u000b\u0004\u0002z\u0005\u0015\u0011\u0011\u0005\u0005\b\u0003\u0003\u0003A\u0011AAB\u0003Y\u0019X\r^%oSRL\u0017\r\\5{CRLwN\\*uKB\u001cH\u0003BA\u0016\u0003\u000bCaARA@\u0001\u0004\u0001\u0003FBA@\u0003\u000b\t\t\u0002\u0003\u0004\u0002\f\u0002!\taT\u0001\u000bO\u0016$X\t]:jY>t\u0007FBAE\u0003\u000b\t\t\u0003C\u0004\u0002\u0012\u0002!\t!a%\u0002\u0015M,G/\u00129tS2|g\u000e\u0006\u0003\u0002,\u0005U\u0005B\u0002(\u0002\u0010\u0002\u0007\u0001\u000b\u000b\u0004\u0002\u0010\u0006\u0015\u0011\u0011\u0003\u0005\u0007\u00037\u0003A\u0011A.\u0002\u000f\u001d,GoU3fI\"2\u0011\u0011TA\u0003\u0003CAq!!)\u0001\t\u0003\t\u0019+A\u0004tKR\u001cV-\u001a3\u0015\t\u0005-\u0012Q\u0015\u0005\u00075\u0006}\u0005\u0019\u0001/)\r\u0005}\u0015QAA\u0011\u0011\u0019\tY\u000b\u0001C\u0001o\u0005\u0011r-\u001a;ESN$\u0018M\\2f\u001b\u0016\f7/\u001e:fQ\u0019\tI+!\u0002\u00020\u0006\u0012\u0011\u0011W\u0001\u0006e9\"d\u0006\r\u0005\b\u0003k\u0003A\u0011AA\\\u0003I\u0019X\r\u001e#jgR\fgnY3NK\u0006\u001cXO]3\u0015\t\u0005-\u0012\u0011\u0018\u0005\u0007M\u0006M\u0006\u0019\u0001\u001d)\r\u0005M\u0016QAAX\u0011%\ty\f\u0001a\u0001\n\u0013\t\t-\u0001\u0007j]&$\u0018.\u00197N_\u0012,G.\u0006\u0002\u0002DB)q\"!2\u0002J&\u0019\u0011q\u0019\t\u0003\r=\u0003H/[8o!\r\t\u00181Z\u0005\u0004\u0003\u001b\u0014!aC&NK\u0006t7/T8eK2D\u0011\"!5\u0001\u0001\u0004%I!a5\u0002!%t\u0017\u000e^5bY6{G-\u001a7`I\u0015\fHc\u0001\u0014\u0002V\"I!&a4\u0002\u0002\u0003\u0007\u00111\u0019\u0005\t\u00033\u0004\u0001\u0015)\u0003\u0002D\u0006i\u0011N\\5uS\u0006dWj\u001c3fY\u0002Bq!!8\u0001\t\u0003\ty.A\btKRLe.\u001b;jC2lu\u000eZ3m)\u0011\tY#!9\t\u0011\u0005\r\u00181\u001ca\u0001\u0003\u0013\fQ!\\8eK2Dc!a7\u0002\u0006\u0005\u0005\u0002bBAu\u0001\u0011\u0005\u00111^\u0001\u0004eVtG\u0003BAe\u0003[D\u0001\"a<\u0002h\u0002\u0007\u0011\u0011_\u0001\u0005I\u0006$\u0018\r\u0005\u0004\u0002t\u0006e\u0018Q`\u0007\u0003\u0003kT1!a>\u0007\u0003\r\u0011H\rZ\u0005\u0005\u0003w\f)PA\u0002S\t\u0012\u0003B!a@\u0003\u00065\u0011!\u0011\u0001\u0006\u0004\u0005\u0007!\u0011A\u00027j]\u0006dw-\u0003\u0003\u0003\b\t\u0005!A\u0002,fGR|'\u000f\u000b\u0004\u0002h\u0006\u0015\u0011\u0011\u0003\u0005\t\u0003S\u0004A\u0011\u0001\u0004\u0003\u000eQ1\u0011\u0011\u001aB\b\u0005#A\u0001\"a<\u0003\f\u0001\u0007\u0011\u0011\u001f\u0005\t\u0005'\u0011Y\u00011\u0001\u0003\u0016\u0005)\u0011N\\:ueB)q\"!2\u0003\u0018A!!\u0011\u0004B\u0012\u001b\t\u0011YB\u0003\u0003\u0003\u001e\t}\u0011\u0001B;uS2T1A!\t\u0007\u0003\tiG.\u0003\u0003\u0003&\tm!aD%ogR\u0014X/\\3oi\u0006$\u0018n\u001c8\t\u000f\t%\u0002\u0001\"\u0003\u0003,\u0005a!/\u001e8BY\u001e|'/\u001b;i[R1\u0011\u0011\u001aB\u0017\u0005oA\u0001\"a<\u0003(\u0001\u0007!q\u0006\t\u0007\u0003g\fIP!\r\u0011\u0007E\u0014\u0019$C\u0002\u00036\t\u0011aBV3di>\u0014x+\u001b;i\u001d>\u0014X\u000e\u0003\u0005\u0003\u0014\t\u001d\u0002\u0019\u0001B\u000b\u0011\u001d\u0011Y\u0004\u0001C\u0005\u0005{\t!\"\u001b8jiJ\u000bg\u000eZ8n)\u0011\u0011yD!\u0012\u0011\u000b=\u0011\tE!\r\n\u0007\t\r\u0003CA\u0003BeJ\f\u0017\u0010\u0003\u0005\u0002p\ne\u0002\u0019\u0001B\u0018\u0011!\u0011I\u0005\u0001C\u0001\u0005\t-\u0013AE5oSR\\U*Z1ogB\u000b'/\u00197mK2$bAa\u0010\u0003N\t=\u0003\u0002CAx\u0005\u000f\u0002\rAa\f\t\u0011\tE#q\ta\u0001\u0005'\nq\u0003Z5ti\u0006t7-Z'fCN,(/Z%ogR\fgnY3\u0011\u0007E\u0014)&C\u0002\u0003X\t\u0011q\u0002R5ti\u0006t7-Z'fCN,(/\u001a\u0015\u0006\u0001\u0005\u0015\u0011\u0011C\u0004\b\u0005;\u0012\u0001\u0012\u0001B0\u0003\u0019YU*Z1ogB\u0019\u0011O!\u0019\u0007\r\u0005\u0011\u0001\u0012\u0001B2'\u0011\u0011\tG\u0004\u000b\t\u000f9\u0014\t\u0007\"\u0001\u0003hQ\u0011!q\f\u0005\u000b\u0005W\u0012\tG1A\u0005\u0002\t5\u0014A\u0002*B\u001d\u0012{U*\u0006\u0002\u0003pA!!\u0011\u000fB>\u001b\t\u0011\u0019H\u0003\u0003\u0003v\t]\u0014\u0001\u00027b]\u001eT!A!\u001f\u0002\t)\fg/Y\u0005\u0004{\tM\u0004F\u0002B5\u0003\u000b\t\t\u0002C\u0005\u0003\u0002\n\u0005\u0004\u0015!\u0003\u0003p\u00059!+\u0011(E\u001f6\u0003\u0003F\u0002B@\u0003\u000b\t\t\u0002\u0003\u0006\u0003\b\n\u0005$\u0019!C\u0001\u0005[\n\u0001cS0N\u000b\u0006s5k\u0018)B%\u0006cE*\u0012')\r\t\u0015\u0015QAA\t\u0011%\u0011iI!\u0019!\u0002\u0013\u0011y'A\tL?6+\u0015IT*`!\u0006\u0013\u0016\t\u0014'F\u0019\u0002BcAa#\u0002\u0006\u0005E\u0001\u0002\u0003BJ\u0005C\"\tA!&\u0002\u000bQ\u0014\u0018-\u001b8\u0015\u0019\u0005%'q\u0013BM\u00057\u0013iJa(\t\u0011\u0005=(\u0011\u0013a\u0001\u0003cDaA\bBI\u0001\u0004\u0001\u0003B\u0002\u0018\u0003\u0012\u0002\u0007\u0001\u0005\u0003\u00047\u0005#\u0003\r\u0001\u000f\u0005\u00075\nE\u0005\u0019\u0001/)\r\tE\u0015QAA1\u0011!\u0011\u0019J!\u0019\u0005\u0002\t\u0015FCCAe\u0005O\u0013IKa+\u0003.\"A\u0011q\u001eBR\u0001\u0004\t\t\u0010\u0003\u0004\u001f\u0005G\u0003\r\u0001\t\u0005\u0007]\t\r\u0006\u0019\u0001\u0011\t\rY\u0012\u0019\u000b1\u00019Q\u0019\u0011\u0019+!\u0002\u0002b!A!1\u0013B1\t\u0003\u0011\u0019\f\u0006\b\u0002J\nU&q\u0017B]\u0005w\u0013iLa0\t\u0011\u0005=(\u0011\u0017a\u0001\u0003cDaA\bBY\u0001\u0004\u0001\u0003B\u0002\u0018\u00032\u0002\u0007\u0001\u0005C\u0004\u0002p\tE\u0006\u0019\u0001\u0011\t\rY\u0012\t\f1\u00019\u0011\u0019Q&\u0011\u0017a\u00019\"B!\u0011WA,\u0005\u0007\f\t'\t\u0002\u0003F\u0006yRk]3!iJ\f\u0017N\u001c\u0011nKRDw\u000e\u001a\u0011xSRDw.\u001e;!OI,hn]\u0014)\r\tE\u0016Q\u0001BeC\t\u0011Y-A\u00032]Mr\u0003\u0007\u0003\u0005\u0003\u0014\n\u0005D\u0011\u0001Bh)1\tIM!5\u0003T\nU'q\u001bBm\u0011!\tyO!4A\u0002\u0005E\bB\u0002\u0010\u0003N\u0002\u0007\u0001\u0005\u0003\u0004/\u0005\u001b\u0004\r\u0001\t\u0005\b\u0003_\u0012i\r1\u0001!\u0011\u00191$Q\u001aa\u0001q!B!QZA,\u0005\u0007\f\t\u0007\u000b\u0004\u0003N\u0006\u0015\u0011\u0011\u0003\u0005\t\u0005'\u0013\t\u0007\"\u0001\u0003bRA\u0011\u0011\u001aBr\u0005K\u00149\u000f\u0003\u0005\u0002p\n}\u0007\u0019AAy\u0011\u0019q\"q\u001ca\u0001A!1aFa8A\u0002\u0001BcAa8\u0002\u0006\u0005E\u0001\u0002\u0003BJ\u0005C\"\tA!<\u0015\u0015\u0005%'q\u001eBy\u0005g\u0014)\u0010\u0003\u0005\u0002p\n-\b\u0019AAy\u0011\u0019q\"1\u001ea\u0001A!1aFa;A\u0002\u0001Bq!a\u001c\u0003l\u0002\u0007\u0001\u0005\u000b\u0005\u0003l\u0006]#1YA1Q\u0019\u0011Y/!\u0002\u0002\u0012!I!Q B1\t\u00031!q`\u0001\u0011m\u0006d\u0017\u000eZ1uK&s\u0017\u000e^'pI\u0016$Ba!\u0001\u0004\bA\u0019qba\u0001\n\u0007\r\u0015\u0001CA\u0004C_>dW-\u00198\t\u000f\r%!1 a\u0001q\u0005A\u0011N\\5u\u001b>$W\r\u0003\u0006\u0004\u000e\t\u0005\u0014\u0011!C\u0005\u0007\u001f\t1B]3bIJ+7o\u001c7wKR\u00111\u0011\u0003\t\u0005\u0005c\u001a\u0019\"\u0003\u0003\u0004\u0016\tM$AB(cU\u0016\u001cG\u000f\u000b\u0004\u0003b\u0005\u0015\u0011\u0011\u0003\u0015\u0007\u00057\n)!!\u0005")
public class KMeans
implements Serializable,
Logging {
    private int org$apache$spark$mllib$clustering$KMeans$$k;
    private int org$apache$spark$mllib$clustering$KMeans$$maxIterations;
    private String org$apache$spark$mllib$clustering$KMeans$$initializationMode;
    private int initializationSteps;
    private double org$apache$spark$mllib$clustering$KMeans$$epsilon;
    private long seed;
    private String distanceMeasure;
    private Option<KMeansModel> initialModel;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, int n3) {
        return KMeans$.MODULE$.train(rDD, n, n2, n3);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2) {
        return KMeans$.MODULE$.train(rDD, n, n2);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, int n3, String string) {
        return KMeans$.MODULE$.train(rDD, n, n2, n3, string);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, int n3, String string, long l) {
        return KMeans$.MODULE$.train(rDD, n, n2, n3, string, l);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, String string) {
        return KMeans$.MODULE$.train(rDD, n, n2, string);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, String string, long l) {
        return KMeans$.MODULE$.train(rDD, n, n2, string, l);
    }

    public static String K_MEANS_PARALLEL() {
        return KMeans$.MODULE$.K_MEANS_PARALLEL();
    }

    public static String RANDOM() {
        return KMeans$.MODULE$.RANDOM();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public int org$apache$spark$mllib$clustering$KMeans$$k() {
        return this.org$apache$spark$mllib$clustering$KMeans$$k;
    }

    private void org$apache$spark$mllib$clustering$KMeans$$k_$eq(int x$1) {
        this.org$apache$spark$mllib$clustering$KMeans$$k = x$1;
    }

    public int org$apache$spark$mllib$clustering$KMeans$$maxIterations() {
        return this.org$apache$spark$mllib$clustering$KMeans$$maxIterations;
    }

    private void org$apache$spark$mllib$clustering$KMeans$$maxIterations_$eq(int x$1) {
        this.org$apache$spark$mllib$clustering$KMeans$$maxIterations = x$1;
    }

    public String org$apache$spark$mllib$clustering$KMeans$$initializationMode() {
        return this.org$apache$spark$mllib$clustering$KMeans$$initializationMode;
    }

    private void org$apache$spark$mllib$clustering$KMeans$$initializationMode_$eq(String x$1) {
        this.org$apache$spark$mllib$clustering$KMeans$$initializationMode = x$1;
    }

    private int initializationSteps() {
        return this.initializationSteps;
    }

    private void initializationSteps_$eq(int x$1) {
        this.initializationSteps = x$1;
    }

    public double org$apache$spark$mllib$clustering$KMeans$$epsilon() {
        return this.org$apache$spark$mllib$clustering$KMeans$$epsilon;
    }

    private void org$apache$spark$mllib$clustering$KMeans$$epsilon_$eq(double x$1) {
        this.org$apache$spark$mllib$clustering$KMeans$$epsilon = x$1;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    private String distanceMeasure() {
        return this.distanceMeasure;
    }

    private void distanceMeasure_$eq(String x$1) {
        this.distanceMeasure = x$1;
    }

    public int getK() {
        return this.org$apache$spark$mllib$clustering$KMeans$$k();
    }

    public KMeans setK(int k) {
        Predef$.MODULE$.require(k > 0, (Function0)new Serializable(this, k){
            public static final long serialVersionUID = 0L;
            private final int k$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of clusters must be positive but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$1)}));
            }
            {
                this.k$1 = k$1;
            }
        });
        this.org$apache$spark$mllib$clustering$KMeans$$k_$eq(k);
        return this;
    }

    public int getMaxIterations() {
        return this.org$apache$spark$mllib$clustering$KMeans$$maxIterations();
    }

    public KMeans setMaxIterations(int maxIterations) {
        Predef$.MODULE$.require(maxIterations >= 0, (Function0)new Serializable(this, maxIterations){
            public static final long serialVersionUID = 0L;
            private final int maxIterations$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Maximum of iterations must be nonnegative but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxIterations$1)}));
            }
            {
                this.maxIterations$1 = maxIterations$1;
            }
        });
        this.org$apache$spark$mllib$clustering$KMeans$$maxIterations_$eq(maxIterations);
        return this;
    }

    public String getInitializationMode() {
        return this.org$apache$spark$mllib$clustering$KMeans$$initializationMode();
    }

    public KMeans setInitializationMode(String initializationMode) {
        KMeans$.MODULE$.validateInitMode(initializationMode);
        this.org$apache$spark$mllib$clustering$KMeans$$initializationMode_$eq(initializationMode);
        return this;
    }

    public int getRuns() {
        this.logWarning((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Getting number of runs has no effect since Spark 2.0.0.";
            }
        });
        return 1;
    }

    public KMeans setRuns(int runs) {
        this.logWarning((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Setting number of runs has no effect since Spark 2.0.0.";
            }
        });
        return this;
    }

    public int getInitializationSteps() {
        return this.initializationSteps();
    }

    public KMeans setInitializationSteps(int initializationSteps) {
        Predef$.MODULE$.require(initializationSteps > 0, (Function0)new Serializable(this, initializationSteps){
            public static final long serialVersionUID = 0L;
            private final int initializationSteps$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of initialization steps must be positive but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.initializationSteps$1)}));
            }
            {
                this.initializationSteps$1 = initializationSteps$1;
            }
        });
        this.initializationSteps_$eq(initializationSteps);
        return this;
    }

    public double getEpsilon() {
        return this.org$apache$spark$mllib$clustering$KMeans$$epsilon();
    }

    public KMeans setEpsilon(double epsilon) {
        Predef$.MODULE$.require(epsilon >= 0.0, (Function0)new Serializable(this, epsilon){
            public static final long serialVersionUID = 0L;
            private final double epsilon$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Distance threshold must be nonnegative but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.epsilon$1)}));
            }
            {
                this.epsilon$1 = epsilon$1;
            }
        });
        this.org$apache$spark$mllib$clustering$KMeans$$epsilon_$eq(epsilon);
        return this;
    }

    public long getSeed() {
        return this.seed();
    }

    public KMeans setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    public String getDistanceMeasure() {
        return this.distanceMeasure();
    }

    public KMeans setDistanceMeasure(String distanceMeasure) {
        DistanceMeasure$.MODULE$.validateDistanceMeasure(distanceMeasure);
        this.distanceMeasure_$eq(distanceMeasure);
        return this;
    }

    private Option<KMeansModel> initialModel() {
        return this.initialModel;
    }

    private void initialModel_$eq(Option<KMeansModel> x$1) {
        this.initialModel = x$1;
    }

    public KMeans setInitialModel(KMeansModel model) {
        Predef$.MODULE$.require(model.k() == this.org$apache$spark$mllib$clustering$KMeans$$k(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "mismatched cluster count";
            }
        });
        this.initialModel_$eq((Option<KMeansModel>)new Some((Object)model));
        return this;
    }

    public KMeansModel run(RDD<Vector> data) {
        return this.run(data, (Option<Instrumentation>)None$.MODULE$);
    }

    public KMeansModel run(RDD<Vector> data, Option<Instrumentation> instr) {
        StorageLevel storageLevel = data.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "The input data is not directly cached, which may hurt performance if its parent RDDs are also uncached.";
                }
            });
        }
        RDD norms = data.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Vector x$1) {
                return Vectors$.MODULE$.norm(x$1, 2.0);
            }
        }, ClassTag$.MODULE$.Double());
        norms.persist();
        RDD zippedData = data.zip(norms, ClassTag$.MODULE$.Double()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final VectorWithNorm apply(Tuple2<Vector, Object> x0$1) {
                Tuple2<Vector, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Vector v = (Vector)tuple2._1();
                    double norm2 = tuple2._2$mcD$sp();
                    VectorWithNorm vectorWithNorm = new VectorWithNorm(v, norm2);
                    return vectorWithNorm;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(VectorWithNorm.class));
        KMeansModel model = this.runAlgorithm((RDD<VectorWithNorm>)zippedData, instr);
        norms.unpersist(norms.unpersist$default$1());
        StorageLevel storageLevel3 = data.getStorageLevel();
        StorageLevel storageLevel4 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel3 != null ? !storageLevel3.equals(storageLevel4) : storageLevel4 != null)) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "The input data was not directly cached, which may hurt performance if its parent RDDs are also uncached.";
                }
            });
        }
        return model;
    }

    private KMeansModel runAlgorithm(RDD<VectorWithNorm> data, Option<Instrumentation> instr) {
        Option<KMeansModel> option;
        block9: {
            VectorWithNorm[] vectorWithNormArray;
            DistanceMeasure distanceMeasureInstance;
            long initStartTime;
            SparkContext sc;
            block8: {
                block7: {
                    sc = data.sparkContext();
                    initStartTime = System.nanoTime();
                    distanceMeasureInstance = DistanceMeasure$.MODULE$.decodeFromString(this.distanceMeasure());
                    option = this.initialModel();
                    if (!(option instanceof Some)) break block7;
                    Some some = (Some)option;
                    KMeansModel kMeansCenters = (KMeansModel)some.x();
                    vectorWithNormArray = (VectorWithNorm[])Predef$.MODULE$.refArrayOps((Object[])kMeansCenters.clusterCenters()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final VectorWithNorm apply(Vector x$2) {
                            return new VectorWithNorm(x$2);
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(VectorWithNorm.class)));
                    break block8;
                }
                if (!None$.MODULE$.equals(option)) break block9;
                String string = this.org$apache$spark$mllib$clustering$KMeans$$initializationMode();
                String string2 = KMeans$.MODULE$.RANDOM();
                vectorWithNormArray = !(string != null ? !string.equals(string2) : string2 != null) ? this.initRandom(data) : this.initKMeansParallel(data, distanceMeasureInstance);
            }
            VectorWithNorm[] centers = vectorWithNormArray;
            double initTimeInSeconds = (double)(System.nanoTime() - initStartTime) / 1.0E9;
            this.logInfo((Function0<String>)new Serializable(this, initTimeInSeconds){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KMeans $outer;
                private final double initTimeInSeconds$1;

                public final String apply() {
                    String arg$macro$1 = this.$outer.org$apache$spark$mllib$clustering$KMeans$$initializationMode();
                    double arg$macro$2 = this.initTimeInSeconds$1;
                    return new StringOps("Initialization with %s took %.3f seconds.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, BoxesRunTime.boxToDouble((double)arg$macro$2)}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.initTimeInSeconds$1 = initTimeInSeconds$1;
                }
            });
            BooleanRef converged = BooleanRef.create((boolean)false);
            DoubleRef cost = DoubleRef.create((double)0.0);
            IntRef iteration = IntRef.create((int)0);
            long iterationStartTime = System.nanoTime();
            instr.foreach((Function1)new Serializable(this, centers){
                public static final long serialVersionUID = 0L;
                private final VectorWithNorm[] centers$1;

                public final void apply(Instrumentation x$3) {
                    x$3.logNumFeatures(((VectorWithNorm)Predef$.MODULE$.refArrayOps((Object[])this.centers$1).head()).vector().size());
                }
                {
                    this.centers$1 = centers$1;
                }
            });
            while (iteration.elem < this.org$apache$spark$mllib$clustering$KMeans$$maxIterations() && !converged.elem) {
                DoubleAccumulator costAccum = sc.doubleAccumulator();
                Broadcast bcCenters = sc.broadcast((Object)centers, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(VectorWithNorm.class)));
                Map collected = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(data.mapPartitions((Function1)new Serializable(this, distanceMeasureInstance, costAccum, bcCenters){
                    public static final long serialVersionUID = 0L;
                    public final DistanceMeasure distanceMeasureInstance$1;
                    public final DoubleAccumulator costAccum$1;
                    private final Broadcast bcCenters$1;

                    public final Iterator<Tuple2<Object, Tuple2<Vector, Object>>> apply(Iterator<VectorWithNorm> points) {
                        VectorWithNorm[] thisCenters = (VectorWithNorm[])this.bcCenters$1.value();
                        int dims = ((VectorWithNorm)Predef$.MODULE$.refArrayOps((Object[])thisCenters).head()).vector().size();
                        Vector[] sums = (Vector[])Array$.MODULE$.fill(thisCenters.length, (Function0)new Serializable(this, dims){
                            public static final long serialVersionUID = 0L;
                            private final int dims$1;

                            public final Vector apply() {
                                return Vectors$.MODULE$.zeros(this.dims$1);
                            }
                            {
                                this.dims$1 = dims$1;
                            }
                        }, ClassTag$.MODULE$.apply(Vector.class));
                        long[] counts = (long[])Array$.MODULE$.fill(thisCenters.length, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply() {
                                return this.apply$mcJ$sp();
                            }

                            public long apply$mcJ$sp() {
                                return 0L;
                            }
                        }, ClassTag$.MODULE$.Long());
                        points.foreach((Function1)new Serializable(this, thisCenters, sums, counts){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$6 $outer;
                            private final VectorWithNorm[] thisCenters$1;
                            private final Vector[] sums$1;
                            private final long[] counts$1;

                            public final void apply(VectorWithNorm point) {
                                Tuple2<Object, Object> tuple2 = this.$outer.distanceMeasureInstance$1.findClosest((TraversableOnce<VectorWithNorm>)Predef$.MODULE$.refArrayOps((Object[])this.thisCenters$1), point);
                                if (tuple2 != null) {
                                    Tuple2.mcID.sp sp2;
                                    int bestCenter = tuple2._1$mcI$sp();
                                    double cost = tuple2._2$mcD$sp();
                                    Tuple2.mcID.sp sp3 = sp2 = new Tuple2.mcID.sp(bestCenter, cost);
                                    int bestCenter2 = sp3._1$mcI$sp();
                                    double cost2 = sp3._2$mcD$sp();
                                    this.$outer.costAccum$1.add(cost2);
                                    this.$outer.distanceMeasureInstance$1.updateClusterSum(point, this.sums$1[bestCenter2]);
                                    this.counts$1[bestCenter2] = this.counts$1[bestCenter2] + 1L;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.thisCenters$1 = thisCenters$1;
                                this.sums$1 = sums$1;
                                this.counts$1 = counts$1;
                            }
                        });
                        return ((IndexedSeqLike)((TraversableLike)Predef$.MODULE$.longArrayOps(counts).indices().filter((Function1)new Serializable(this, counts){
                            public static final long serialVersionUID = 0L;
                            private final long[] counts$1;

                            public final boolean apply(int x$5) {
                                return this.apply$mcZI$sp(x$5);
                            }

                            public boolean apply$mcZI$sp(int x$5) {
                                return this.counts$1[x$5] > 0L;
                            }
                            {
                                this.counts$1 = counts$1;
                            }
                        })).map((Function1)new Serializable(this, sums, counts){
                            public static final long serialVersionUID = 0L;
                            private final Vector[] sums$1;
                            private final long[] counts$1;

                            public final Tuple2<Object, Tuple2<Vector, Object>> apply(int j) {
                                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)j), (Object)new Tuple2((Object)this.sums$1[j], (Object)BoxesRunTime.boxToLong((long)this.counts$1[j])));
                            }
                            {
                                this.sums$1 = sums$1;
                                this.counts$1 = counts$1;
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom())).iterator();
                    }
                    {
                        this.distanceMeasureInstance$1 = distanceMeasureInstance$1;
                        this.costAccum$1 = costAccum$1;
                        this.bcCenters$1 = bcCenters$1;
                    }
                }, data.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Vector, Object> apply(Tuple2<Vector, Object> x0$2, Tuple2<Vector, Object> x1$1) {
                        Tuple2 tuple2 = new Tuple2(x0$2, x1$1);
                        if (tuple2 != null) {
                            Tuple2 tuple22 = (Tuple2)tuple2._1();
                            Tuple2 tuple23 = (Tuple2)tuple2._2();
                            if (tuple22 != null) {
                                Vector sum1 = (Vector)tuple22._1();
                                long count1 = tuple22._2$mcJ$sp();
                                if (tuple23 != null) {
                                    Vector sum2 = (Vector)tuple23._1();
                                    long count2 = tuple23._2$mcJ$sp();
                                    BLAS$.MODULE$.axpy(1.0, sum2, sum1);
                                    Tuple2 tuple24 = new Tuple2((Object)sum1, (Object)BoxesRunTime.boxToLong((long)(count1 + count2)));
                                    return tuple24;
                                }
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }
                }), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).collectAsMap();
                if (iteration.elem == 0) {
                    instr.foreach((Function1)new Serializable(this, collected){
                        public static final long serialVersionUID = 0L;
                        private final Map collected$1;

                        public final void apply(Instrumentation x$6) {
                            x$6.logNumExamples(BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.collected$1.values().map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final long apply(Tuple2<Vector, Object> x$7) {
                                    return x$7._2$mcJ$sp();
                                }
                            }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
                        }
                        {
                            this.collected$1 = collected$1;
                        }
                    });
                }
                Map newCenters = collected.mapValues((Function1)new Serializable(this, distanceMeasureInstance){
                    public static final long serialVersionUID = 0L;
                    private final DistanceMeasure distanceMeasureInstance$1;

                    public final VectorWithNorm apply(Tuple2<Vector, Object> x0$3) {
                        Tuple2<Vector, Object> tuple2 = x0$3;
                        if (tuple2 != null) {
                            Vector sum = (Vector)tuple2._1();
                            long count = tuple2._2$mcJ$sp();
                            VectorWithNorm vectorWithNorm = this.distanceMeasureInstance$1.centroid(sum, count);
                            return vectorWithNorm;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.distanceMeasureInstance$1 = distanceMeasureInstance$1;
                    }
                });
                bcCenters.destroy(false);
                converged.elem = true;
                newCenters.foreach((Function1)new Serializable(this, distanceMeasureInstance, centers, converged){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KMeans $outer;
                    private final DistanceMeasure distanceMeasureInstance$1;
                    private final VectorWithNorm[] centers$1;
                    private final BooleanRef converged$1;

                    public final void apply(Tuple2<Object, VectorWithNorm> x0$4) {
                        Tuple2<Object, VectorWithNorm> tuple2 = x0$4;
                        if (tuple2 != null) {
                            int j = tuple2._1$mcI$sp();
                            VectorWithNorm newCenter = (VectorWithNorm)tuple2._2();
                            if (this.converged$1.elem && !this.distanceMeasureInstance$1.isCenterConverged(this.centers$1[j], newCenter, this.$outer.org$apache$spark$mllib$clustering$KMeans$$epsilon())) {
                                this.converged$1.elem = false;
                            }
                            this.centers$1[j] = newCenter;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.distanceMeasureInstance$1 = distanceMeasureInstance$1;
                        this.centers$1 = centers$1;
                        this.converged$1 = converged$1;
                    }
                });
                cost.elem = Predef$.MODULE$.Double2double(costAccum.value());
                ++iteration.elem;
            }
            double iterationTimeInSeconds = (double)(System.nanoTime() - iterationStartTime) / 1.0E9;
            this.logInfo((Function0<String>)new Serializable(this, iterationTimeInSeconds){
                public static final long serialVersionUID = 0L;
                private final double iterationTimeInSeconds$1;

                public final String apply() {
                    double arg$macro$3 = this.iterationTimeInSeconds$1;
                    return new StringOps("Iterations took %.3f seconds.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$3)}));
                }
                {
                    this.iterationTimeInSeconds$1 = iterationTimeInSeconds$1;
                }
            });
            if (iteration.elem == this.org$apache$spark$mllib$clustering$KMeans$$maxIterations()) {
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KMeans $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KMeans reached the max number of iterations: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$mllib$clustering$KMeans$$maxIterations())}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            } else {
                this.logInfo((Function0<String>)new Serializable(this, iteration){
                    public static final long serialVersionUID = 0L;
                    private final IntRef iteration$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KMeans converged in ", " iterations."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.iteration$1.elem)}));
                    }
                    {
                        this.iteration$1 = iteration$1;
                    }
                });
            }
            this.logInfo((Function0<String>)new Serializable(this, cost){
                public static final long serialVersionUID = 0L;
                private final DoubleRef cost$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The cost is ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.cost$1.elem)}));
                }
                {
                    this.cost$1 = cost$1;
                }
            });
            return new KMeansModel((Vector[])Predef$.MODULE$.refArrayOps((Object[])centers).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Vector apply(VectorWithNorm x$8) {
                    return x$8.vector();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class))), this.distanceMeasure(), cost.elem, iteration.elem);
        }
        throw new MatchError(option);
    }

    private VectorWithNorm[] initRandom(RDD<VectorWithNorm> data) {
        return (VectorWithNorm[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])data.takeSample(false, this.org$apache$spark$mllib$clustering$KMeans$$k(), (long)new XORShiftRandom(this.seed()).nextInt())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Vector apply(VectorWithNorm x$9) {
                return x$9.vector();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)))).distinct()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final VectorWithNorm apply(Vector x$10) {
                return new VectorWithNorm(x$10);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(VectorWithNorm.class)));
    }

    public VectorWithNorm[] initKMeansParallel(RDD<VectorWithNorm> data, DistanceMeasure distanceMeasureInstance) {
        VectorWithNorm[] vectorWithNormArray;
        RDD costs = data.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(VectorWithNorm x$11) {
                return Double.POSITIVE_INFINITY;
            }
        }, ClassTag$.MODULE$.Double());
        int seed = new XORShiftRandom(this.seed()).nextInt();
        VectorWithNorm[] sample = (VectorWithNorm[])data.takeSample(false, 1, (long)seed);
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])sample).nonEmpty(), (Function0)new Serializable(this, data){
            public static final long serialVersionUID = 0L;
            private final RDD data$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No samples available from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.data$1}));
            }
            {
                this.data$1 = data$1;
            }
        });
        ArrayBuffer centers = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Seq newCenters = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new VectorWithNorm[]{((VectorWithNorm)Predef$.MODULE$.refArrayOps((Object[])sample).head()).toDense()}));
        centers.$plus$plus$eq((TraversableOnce)newCenters);
        IntRef step = IntRef.create((int)0);
        ArrayBuffer bcNewCentersList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (step.elem < this.initializationSteps()) {
            Broadcast bcNewCenters = data.context().broadcast((Object)newCenters, ClassTag$.MODULE$.apply(Seq.class));
            bcNewCentersList.$plus$eq((Object)bcNewCenters);
            RDD preCosts = costs;
            costs = data.zip(preCosts, ClassTag$.MODULE$.Double()).map((Function1)new Serializable(this, distanceMeasureInstance, bcNewCenters){
                public static final long serialVersionUID = 0L;
                private final DistanceMeasure distanceMeasureInstance$2;
                private final Broadcast bcNewCenters$1;

                public final double apply(Tuple2<VectorWithNorm, Object> x0$5) {
                    Tuple2<VectorWithNorm, Object> tuple2 = x0$5;
                    if (tuple2 != null) {
                        VectorWithNorm point = (VectorWithNorm)tuple2._1();
                        double cost = tuple2._2$mcD$sp();
                        double d = package$.MODULE$.min(this.distanceMeasureInstance$2.pointCost((TraversableOnce<VectorWithNorm>)((TraversableOnce)this.bcNewCenters$1.value()), point), cost);
                        return d;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.distanceMeasureInstance$2 = distanceMeasureInstance$2;
                    this.bcNewCenters$1 = bcNewCenters$1;
                }
            }, ClassTag$.MODULE$.Double()).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
            double sumCosts = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(costs).sum();
            bcNewCenters.unpersist(false);
            preCosts.unpersist(false);
            RDD qual$1 = data.zip(costs, ClassTag$.MODULE$.Double());
            Serializable x$19 = new Serializable(this, seed, step, sumCosts){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KMeans $outer;
                private final int seed$1;
                private final IntRef step$1;
                public final double sumCosts$1;

                public final Iterator<VectorWithNorm> apply(int index2, Iterator<Tuple2<VectorWithNorm, Object>> pointCosts) {
                    XORShiftRandom rand2 = new XORShiftRandom((long)(this.seed$1 ^ this.step$1.elem << 16 ^ index2));
                    return pointCosts.filter((Function1)new Serializable(this, rand2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$11 $outer;
                        private final XORShiftRandom rand$1;

                        public final boolean apply(Tuple2<VectorWithNorm, Object> x0$6) {
                            Tuple2<VectorWithNorm, Object> tuple2 = x0$6;
                            if (tuple2 != null) {
                                double c = tuple2._2$mcD$sp();
                                boolean bl = this.rand$1.nextDouble() < 2.0 * c * (double)this.$outer.org$apache$spark$mllib$clustering$KMeans$$anonfun$$$outer().org$apache$spark$mllib$clustering$KMeans$$k() / this.$outer.sumCosts$1;
                                return bl;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.rand$1 = rand$1;
                        }
                    }).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final VectorWithNorm apply(Tuple2<VectorWithNorm, Object> x$12) {
                            return (VectorWithNorm)x$12._1();
                        }
                    });
                }

                public /* synthetic */ KMeans org$apache$spark$mllib$clustering$KMeans$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.seed$1 = seed$1;
                    this.step$1 = step$1;
                    this.sumCosts$1 = sumCosts$1;
                }
            };
            boolean x$20 = qual$1.mapPartitionsWithIndex$default$2();
            VectorWithNorm[] chosen = (VectorWithNorm[])qual$1.mapPartitionsWithIndex((Function2)x$19, x$20, ClassTag$.MODULE$.apply(VectorWithNorm.class)).collect();
            newCenters = (Seq)Predef$.MODULE$.refArrayOps((Object[])chosen).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final VectorWithNorm apply(VectorWithNorm x$13) {
                    return x$13.toDense();
                }
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
            centers.$plus$plus$eq((TraversableOnce)newCenters);
            ++step.elem;
        }
        costs.unpersist(false);
        bcNewCentersList.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Broadcast<?> x$14) {
                x$14.destroy(false);
            }
        });
        ArrayBuffer distinctCenters = (ArrayBuffer)((TraversableLike)((SeqLike)centers.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Vector apply(VectorWithNorm x$15) {
                return x$15.vector();
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).distinct()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final VectorWithNorm apply(Vector x$16) {
                return new VectorWithNorm(x$16);
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom());
        if (distinctCenters.size() <= this.org$apache$spark$mllib$clustering$KMeans$$k()) {
            vectorWithNormArray = (VectorWithNorm[])distinctCenters.toArray(ClassTag$.MODULE$.apply(VectorWithNorm.class));
        } else {
            Broadcast bcCenters = data.context().broadcast((Object)distinctCenters, ClassTag$.MODULE$.apply(ArrayBuffer.class));
            Map countMap = data.map((Function1)new Serializable(this, distanceMeasureInstance, bcCenters){
                public static final long serialVersionUID = 0L;
                private final DistanceMeasure distanceMeasureInstance$2;
                private final Broadcast bcCenters$2;

                public final int apply(VectorWithNorm x$17) {
                    return this.distanceMeasureInstance$2.findClosest((TraversableOnce<VectorWithNorm>)((TraversableOnce)this.bcCenters$2.value()), x$17)._1$mcI$sp();
                }
                {
                    this.distanceMeasureInstance$2 = distanceMeasureInstance$2;
                    this.bcCenters$2 = bcCenters$2;
                }
            }, ClassTag$.MODULE$.Int()).countByValue((Ordering)Ordering.Int$.MODULE$);
            bcCenters.destroy(false);
            double[] myWeights = (double[])((TraversableOnce)distinctCenters.indices().map((Function1)new Serializable(this, countMap){
                public static final long serialVersionUID = 0L;
                private final Map countMap$1;

                public final double apply(int x$18) {
                    return this.apply$mcDI$sp(x$18);
                }

                public double apply$mcDI$sp(int x$18) {
                    return BoxesRunTime.unboxToLong((Object)this.countMap$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)x$18), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return 0L;
                        }
                    }));
                }
                {
                    this.countMap$1 = countMap$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
            vectorWithNormArray = LocalKMeans$.MODULE$.kMeansPlusPlus(0, (VectorWithNorm[])distinctCenters.toArray(ClassTag$.MODULE$.apply(VectorWithNorm.class)), myWeights, this.org$apache$spark$mllib$clustering$KMeans$$k(), 30);
        }
        return vectorWithNormArray;
    }

    private KMeans(int k, int maxIterations, String initializationMode, int initializationSteps, double epsilon, long seed, String distanceMeasure) {
        this.org$apache$spark$mllib$clustering$KMeans$$k = k;
        this.org$apache$spark$mllib$clustering$KMeans$$maxIterations = maxIterations;
        this.org$apache$spark$mllib$clustering$KMeans$$initializationMode = initializationMode;
        this.initializationSteps = initializationSteps;
        this.org$apache$spark$mllib$clustering$KMeans$$epsilon = epsilon;
        this.seed = seed;
        this.distanceMeasure = distanceMeasure;
        Logging.class.$init$((Logging)this);
        this.initialModel = None$.MODULE$;
    }

    private KMeans(int k, int maxIterations, String initializationMode, int initializationSteps, double epsilon, long seed) {
        this(k, maxIterations, initializationMode, initializationSteps, epsilon, seed, DistanceMeasure$.MODULE$.EUCLIDEAN());
    }

    public KMeans() {
        this(2, 20, KMeans$.MODULE$.K_MEANS_PARALLEL(), 2, 1.0E-4, Utils$.MODULE$.random().nextLong(), DistanceMeasure$.MODULE$.EUCLIDEAN());
    }
}

