/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.param;

import java.util.List;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.Params;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@DeveloperApi
public final class ParamValidators$ {
    public static final ParamValidators$ MODULE$;

    static {
        new ParamValidators$();
    }

    public <T> Function1<T, Object> alwaysTrue() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(T x$2) {
                return true;
            }
        };
    }

    public <T> double org$apache$spark$ml$param$ParamValidators$$getDouble(T value) {
        block6: {
            double d;
            block3: {
                double d2;
                T t;
                block5: {
                    block4: {
                        block2: {
                            t = value;
                            if (!(t instanceof Integer)) break block2;
                            int n = BoxesRunTime.unboxToInt(t);
                            d = n;
                            break block3;
                        }
                        if (!(t instanceof Long)) break block4;
                        long l = BoxesRunTime.unboxToLong(t);
                        d = l;
                        break block3;
                    }
                    if (!(t instanceof Float)) break block5;
                    float f = BoxesRunTime.unboxToFloat(t);
                    d = f;
                    break block3;
                }
                if (!(t instanceof Double)) break block6;
                d = d2 = BoxesRunTime.unboxToDouble(t);
            }
            return d;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Numerical Param validation failed because").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" of unexpected input type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value.getClass()}))).toString());
    }

    public <T> Function1<T, Object> gt(double lowerBound) {
        return new Serializable(lowerBound){
            public static final long serialVersionUID = 0L;
            private final double lowerBound$1;

            public final boolean apply(T value) {
                return ParamValidators$.MODULE$.org$apache$spark$ml$param$ParamValidators$$getDouble(value) > this.lowerBound$1;
            }
            {
                this.lowerBound$1 = lowerBound$1;
            }
        };
    }

    public <T> Function1<T, Object> gtEq(double lowerBound) {
        return new Serializable(lowerBound){
            public static final long serialVersionUID = 0L;
            private final double lowerBound$2;

            public final boolean apply(T value) {
                return ParamValidators$.MODULE$.org$apache$spark$ml$param$ParamValidators$$getDouble(value) >= this.lowerBound$2;
            }
            {
                this.lowerBound$2 = lowerBound$2;
            }
        };
    }

    public <T> Function1<T, Object> lt(double upperBound) {
        return new Serializable(upperBound){
            public static final long serialVersionUID = 0L;
            private final double upperBound$2;

            public final boolean apply(T value) {
                return ParamValidators$.MODULE$.org$apache$spark$ml$param$ParamValidators$$getDouble(value) < this.upperBound$2;
            }
            {
                this.upperBound$2 = upperBound$2;
            }
        };
    }

    public <T> Function1<T, Object> ltEq(double upperBound) {
        return new Serializable(upperBound){
            public static final long serialVersionUID = 0L;
            private final double upperBound$3;

            public final boolean apply(T value) {
                return ParamValidators$.MODULE$.org$apache$spark$ml$param$ParamValidators$$getDouble(value) <= this.upperBound$3;
            }
            {
                this.upperBound$3 = upperBound$3;
            }
        };
    }

    public <T> Function1<T, Object> inRange(double lowerBound, double upperBound, boolean lowerInclusive, boolean upperInclusive) {
        return new Serializable(lowerBound, upperBound, lowerInclusive, upperInclusive){
            public static final long serialVersionUID = 0L;
            private final double lowerBound$3;
            private final double upperBound$1;
            private final boolean lowerInclusive$1;
            private final boolean upperInclusive$1;

            public final boolean apply(T value) {
                boolean lowerValid;
                double x = ParamValidators$.MODULE$.org$apache$spark$ml$param$ParamValidators$$getDouble(value);
                boolean bl = this.lowerInclusive$1 ? x >= this.lowerBound$3 : (lowerValid = x > this.lowerBound$3);
                boolean upperValid = this.upperInclusive$1 ? x <= this.upperBound$1 : x < this.upperBound$1;
                return lowerValid && upperValid;
            }
            {
                this.lowerBound$3 = lowerBound$3;
                this.upperBound$1 = upperBound$1;
                this.lowerInclusive$1 = lowerInclusive$1;
                this.upperInclusive$1 = upperInclusive$1;
            }
        };
    }

    public <T> Function1<T, Object> inRange(double lowerBound, double upperBound) {
        return this.inRange(lowerBound, upperBound, true, true);
    }

    public <T> Function1<T, Object> inArray(Object allowed) {
        return new Serializable(allowed){
            public static final long serialVersionUID = 0L;
            private final Object allowed$2;

            public final boolean apply(T value) {
                return Predef$.MODULE$.genericArrayOps(this.allowed$2).contains(value);
            }
            {
                this.allowed$2 = allowed$2;
            }
        };
    }

    public <T> Function1<T, Object> inArray(List<T> allowed) {
        return new Serializable(allowed){
            public static final long serialVersionUID = 0L;
            private final List allowed$1;

            public final boolean apply(T value) {
                return this.allowed$1.contains(value);
            }
            {
                this.allowed$1 = allowed$1;
            }
        };
    }

    public <T> Function1<Object, Object> arrayLengthGt(double lowerBound) {
        return new Serializable(lowerBound){
            public static final long serialVersionUID = 0L;
            private final double lowerBound$4;

            public final boolean apply(Object value) {
                return (double)ScalaRunTime$.MODULE$.array_length(value) > this.lowerBound$4;
            }
            {
                this.lowerBound$4 = lowerBound$4;
            }
        };
    }

    public void checkSingleVsMultiColumnParams(Params model, Seq<Param<?>> singleColumnParams, Seq<Param<?>> multiColumnParams) {
        String name;
        block4: {
            block3: {
                Param<Object> inputCols;
                block2: {
                    name = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{model.getClass().getSimpleName(), model}));
                    Param<Object> inputCol = model.getParam("inputCol");
                    inputCols = model.getParam("inputCols");
                    if (!model.isSet(inputCol)) break block2;
                    Predef$.MODULE$.require(!model.isSet(inputCols), (Function0)new Serializable(name){
                        public static final long serialVersionUID = 0L;
                        private final String name$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " requires "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"exactly one of inputCol, inputCols Params to be set, but both are set."})).s((Seq)Nil$.MODULE$)).toString();
                        }
                        {
                            this.name$1 = name$1;
                        }
                    });
                    this.checkExclusiveParams$1(true, singleColumnParams, multiColumnParams, model, name);
                    break block3;
                }
                if (!model.isSet(inputCols)) break block4;
                this.checkExclusiveParams$1(false, multiColumnParams, singleColumnParams, model, name);
            }
            return;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " requires "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"exactly one of inputCol, inputCols Params to be set, but neither is set."})).s((Seq)Nil$.MODULE$)).toString());
    }

    private final void checkExclusiveParams$1(boolean isSingleCol, Seq requiredParams, Seq excludedParams, Params model$1, String name$1) {
        StringBuilder badParamsMsgBuilder = new StringBuilder();
        String mustUnsetParams = ((TraversableOnce)((TraversableLike)excludedParams.filter((Function1)new Serializable(model$1){
            public static final long serialVersionUID = 0L;
            private final Params model$1;

            public final boolean apply(Param<?> p) {
                return this.model$1.isSet(p);
            }
            {
                this.model$1 = model$1;
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Param<?> x$3) {
                return x$3.name();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", ");
        Object object = new StringOps(Predef$.MODULE$.augmentString(mustUnsetParams)).nonEmpty() ? badParamsMsgBuilder.$plus$plus$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The following Params are not applicable and should not be set: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mustUnsetParams}))) : BoxedUnit.UNIT;
        String mustSetParams = ((TraversableOnce)((TraversableLike)requiredParams.filter((Function1)new Serializable(model$1){
            public static final long serialVersionUID = 0L;
            private final Params model$1;

            public final boolean apply(Param<?> p) {
                return !this.model$1.isDefined(p);
            }
            {
                this.model$1 = model$1;
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Param<?> x$4) {
                return x$4.name();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", ");
        Object object2 = new StringOps(Predef$.MODULE$.augmentString(mustSetParams)).nonEmpty() ? badParamsMsgBuilder.$plus$plus$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The following Params must be defined but are not set: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mustSetParams}))) : BoxedUnit.UNIT;
        String badParamsMsg = badParamsMsgBuilder.toString();
        if (new StringOps(Predef$.MODULE$.augmentString(badParamsMsg)).nonEmpty()) {
            String errPrefix = isSingleCol ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " has the inputCol Param set for single-column transform."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name$1})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " has the inputCols Param set for multi-column transform."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name$1}));
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errPrefix, badParamsMsg})));
        }
    }

    private ParamValidators$() {
        MODULE$ = this;
    }
}

