/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim;

import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.optim.CholeskySolver;
import org.apache.spark.ml.optim.QuasiNewtonSolver;
import org.apache.spark.ml.optim.SingularMatrixException;
import org.apache.spark.ml.optim.WeightedLeastSquares$;
import org.apache.spark.ml.optim.WeightedLeastSquares$Auto$;
import org.apache.spark.ml.optim.WeightedLeastSquares$QuasiNewton$;
import org.apache.spark.ml.optim.WeightedLeastSquaresModel;
import org.apache.spark.ml.util.OptionalInstrumentation;
import org.apache.spark.ml.util.OptionalInstrumentation$;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\r}b!B\u0001\u0003\u0001\u0011a!\u0001F,fS\u001eDG/\u001a3MK\u0006\u001cHoU9vCJ,7O\u0003\u0002\u0004\t\u0005)q\u000e\u001d;j[*\u0011QAB\u0001\u0003[2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\n\u0004\u00015\u0019\u0002C\u0001\b\u0012\u001b\u0005y!\"\u0001\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iy!AB!osJ+g\r\u0005\u0002\u000f)%\u0011Qc\u0004\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t/\u0001\u0011)\u0019!C\u00013\u0005aa-\u001b;J]R,'oY3qi\u000e\u0001Q#\u0001\u000e\u0011\u00059Y\u0012B\u0001\u000f\u0010\u0005\u001d\u0011un\u001c7fC:D\u0001B\b\u0001\u0003\u0002\u0003\u0006IAG\u0001\u000eM&$\u0018J\u001c;fe\u000e,\u0007\u000f\u001e\u0011\t\u0011\u0001\u0002!Q1A\u0005\u0002\u0005\n\u0001B]3h!\u0006\u0014\u0018-\\\u000b\u0002EA\u0011abI\u0005\u0003I=\u0011a\u0001R8vE2,\u0007\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\u0002\u0013I,w\rU1sC6\u0004\u0003\u0002\u0003\u0015\u0001\u0005\u000b\u0007I\u0011A\u0011\u0002\u001f\u0015d\u0017m\u001d;jG:+G\u000fU1sC6D\u0001B\u000b\u0001\u0003\u0002\u0003\u0006IAI\u0001\u0011K2\f7\u000f^5d\u001d\u0016$\b+\u0019:b[\u0002B\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!G\u0001\u0014gR\fg\u000eZ1sI&TXMR3biV\u0014Xm\u001d\u0005\t]\u0001\u0011\t\u0011)A\u00055\u0005!2\u000f^1oI\u0006\u0014H-\u001b>f\r\u0016\fG/\u001e:fg\u0002B\u0001\u0002\r\u0001\u0003\u0006\u0004%\t!G\u0001\u0011gR\fg\u000eZ1sI&TX\rT1cK2D\u0001B\r\u0001\u0003\u0002\u0003\u0006IAG\u0001\u0012gR\fg\u000eZ1sI&TX\rT1cK2\u0004\u0003\u0002\u0003\u001b\u0001\u0005\u000b\u0007I\u0011A\u001b\u0002\u0015M|GN^3s)f\u0004X-F\u00017!\t9\u0014J\u0004\u00029s5\t!a\u0002\u0004;\u0005!\u0005AaO\u0001\u0015/\u0016Lw\r\u001b;fI2+\u0017m\u001d;TcV\f'/Z:\u0011\u0005abdAB\u0001\u0003\u0011\u0003!QhE\u0002=\u001bMAQa\u0010\u001f\u0005\u0002\u0001\u000ba\u0001P5oSRtD#A\u001e\t\u000f\tc$\u0019!C\u0001\u0007\u0006\u0001R*\u0011-`\u001dVkuLR#B)V\u0013ViU\u000b\u0002\tB\u0011a\"R\u0005\u0003\r>\u00111!\u00138u\u0011\u0019AE\b)A\u0005\t\u0006\tR*\u0011-`\u001dVkuLR#B)V\u0013Vi\u0015\u0011\u0007\u000f)c\u0004\u0013aI\u0011\u0017\n11k\u001c7wKJ\u001c\"!S\u0007*\r%k\u0015QBA\u0019\r\u0015qE\b#!P\u0005\u0011\tU\u000f^8\u0014\u000b5k\u0001KU\n\u0011\u0005EKU\"\u0001\u001f\u0011\u00059\u0019\u0016B\u0001+\u0010\u0005\u001d\u0001&o\u001c3vGRDQaP'\u0005\u0002Y#\u0012a\u0016\t\u0003#6Cq!W'\u0002\u0002\u0013\u0005#,A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u00027B\u0011A,Y\u0007\u0002;*\u0011alX\u0001\u0005Y\u0006twMC\u0001a\u0003\u0011Q\u0017M^1\n\u0005\tl&AB*ue&tw\rC\u0004e\u001b\u0006\u0005I\u0011A\"\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u000f\u0019l\u0015\u0011!C\u0001O\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HC\u00015l!\tq\u0011.\u0003\u0002k\u001f\t\u0019\u0011I\\=\t\u000f1,\u0017\u0011!a\u0001\t\u0006\u0019\u0001\u0010J\u0019\t\u000f9l\u0015\u0011!C!_\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/F\u0001q!\r\tH\u000f[\u0007\u0002e*\u00111oD\u0001\u000bG>dG.Z2uS>t\u0017BA;s\u0005!IE/\u001a:bi>\u0014\bbB<N\u0003\u0003%\t\u0001_\u0001\tG\u0006tW)];bYR\u0011!$\u001f\u0005\bYZ\f\t\u00111\u0001i\u0011\u001dYX*!A\u0005Bq\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002\t\"9a0TA\u0001\n\u0003z\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003mC\u0011\"a\u0001N\u0003\u0003%I!!\u0002\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u000f\u00012\u0001XA\u0005\u0013\r\tY!\u0018\u0002\u0007\u001f\nTWm\u0019;\u0007\u000f\u0005=A\b#!\u0002\u0012\tA1\t[8mKN\\\u0017p\u0005\u0004\u0002\u000e5\u0001&k\u0005\u0005\b\u007f\u00055A\u0011AA\u000b)\t\t9\u0002E\u0002R\u0003\u001bA\u0001\"WA\u0007\u0003\u0003%\tE\u0017\u0005\tI\u00065\u0011\u0011!C\u0001\u0007\"Ia-!\u0004\u0002\u0002\u0013\u0005\u0011q\u0004\u000b\u0004Q\u0006\u0005\u0002\u0002\u00037\u0002\u001e\u0005\u0005\t\u0019\u0001#\t\u00119\fi!!A\u0005B=D\u0011b^A\u0007\u0003\u0003%\t!a\n\u0015\u0007i\tI\u0003\u0003\u0005m\u0003K\t\t\u00111\u0001i\u0011!Y\u0018QBA\u0001\n\u0003b\b\u0002\u0003@\u0002\u000e\u0005\u0005I\u0011I@\t\u0015\u0005\r\u0011QBA\u0001\n\u0013\t)AB\u0004\u00024qB\t)!\u000e\u0003\u0017E+\u0018m]5OK^$xN\\\n\u0007\u0003ci\u0001KU\n\t\u000f}\n\t\u0004\"\u0001\u0002:Q\u0011\u00111\b\t\u0004#\u0006E\u0002\u0002C-\u00022\u0005\u0005I\u0011\t.\t\u0011\u0011\f\t$!A\u0005\u0002\rC\u0011BZA\u0019\u0003\u0003%\t!a\u0011\u0015\u0007!\f)\u0005\u0003\u0005m\u0003\u0003\n\t\u00111\u0001E\u0011!q\u0017\u0011GA\u0001\n\u0003z\u0007\"C<\u00022\u0005\u0005I\u0011AA&)\rQ\u0012Q\n\u0005\tY\u0006%\u0013\u0011!a\u0001Q\"A10!\r\u0002\u0002\u0013\u0005C\u0010\u0003\u0005\u007f\u0003c\t\t\u0011\"\u0011\u0000\u0011)\t\u0019!!\r\u0002\u0002\u0013%\u0011QA\u0004\u0007\u0003/b\u0004\u0012Q,\u0002\t\u0005+Ho\\\u0004\b\u00037b\u0004\u0012QA\f\u0003!\u0019\u0005n\u001c7fg.LxaBA0y!\u0005\u00151H\u0001\f#V\f7/\u001b(foR|g\u000eC\u0005\u0002dq\u0012\r\u0011\"\u0001\u0002f\u0005\u00012/\u001e9q_J$X\rZ*pYZ,'o]\u000b\u0003\u0003O\u0002RADA5\u0003[J1!a\u001b\u0010\u0005\u0015\t%O]1z%\u0015\tyGU\nQ\r\u0019\t\t\b\u0010\u0001\u0002n\taAH]3gS:,W.\u001a8u}!A\u0011Q\u000f\u001f!\u0002\u0013\t9'A\ttkB\u0004xN\u001d;fIN{GN^3sg\u00022a!!\u001f=\t\u0005m$AC!hOJ,w-\u0019;peN!\u0011qO\u0007\u0014\u0011\u001dy\u0014q\u000fC\u0001\u0003\u007f\"\"!!!\u0011\u0007E\u000b9\bC\u0005\u0002\u0006\u0006]\u0004\u0019!C\u00013\u0005Y\u0011N\\5uS\u0006d\u0017N_3e\u0011)\tI)a\u001eA\u0002\u0013\u0005\u00111R\u0001\u0010S:LG/[1mSj,Gm\u0018\u0013fcR!\u0011QRAJ!\rq\u0011qR\u0005\u0004\u0003#{!\u0001B+oSRD\u0001\u0002\\AD\u0003\u0003\u0005\rA\u0007\u0005\t\u0003/\u000b9\b)Q\u00055\u0005a\u0011N\\5uS\u0006d\u0017N_3eA!Y\u00111TA<\u0001\u0004\u0005\r\u0011\"\u0001D\u0003\u0005Y\u0007\u0002DAP\u0003o\u0002\r\u00111A\u0005\u0002\u0005\u0005\u0016!B6`I\u0015\fH\u0003BAG\u0003GC\u0001\u0002\\AO\u0003\u0003\u0005\r\u0001\u0012\u0005\t\u0003O\u000b9\b)Q\u0005\t\u0006\u00111\u000e\t\u0005\r\u0003W\u000b9\b1AA\u0002\u0013\u0005\u0011QV\u0001\u0006G>,h\u000e^\u000b\u0003\u0003_\u00032ADAY\u0013\r\t\u0019l\u0004\u0002\u0005\u0019>tw\r\u0003\u0007\u00028\u0006]\u0004\u0019!a\u0001\n\u0003\tI,A\u0005d_VtGo\u0018\u0013fcR!\u0011QRA^\u0011%a\u0017QWA\u0001\u0002\u0004\ty\u000bC\u0005\u0002@\u0006]\u0004\u0015)\u0003\u00020\u000611m\\;oi\u0002B1\"a1\u0002x\u0001\u0007\t\u0019!C\u0001\u0007\u0006!AO]5L\u00111\t9-a\u001eA\u0002\u0003\u0007I\u0011AAe\u0003!!(/[&`I\u0015\fH\u0003BAG\u0003\u0017D\u0001\u0002\\Ac\u0003\u0003\u0005\r\u0001\u0012\u0005\t\u0003\u001f\f9\b)Q\u0005\t\u0006)AO]5LA!Y\u00111[A<\u0001\u0004\u0005\r\u0011\"\u0001\"\u0003\u001198+^7\t\u0019\u0005]\u0017q\u000fa\u0001\u0002\u0004%\t!!7\u0002\u0011]\u001cV/\\0%KF$B!!$\u0002\\\"AA.!6\u0002\u0002\u0003\u0007!\u0005\u0003\u0005\u0002`\u0006]\u0004\u0015)\u0003#\u0003\u001598+^7!\u0011-\t\u0019/a\u001eA\u0002\u0003\u0007I\u0011B\u0011\u0002\u000b]<8+^7\t\u0019\u0005\u001d\u0018q\u000fa\u0001\u0002\u0004%I!!;\u0002\u0013]<8+^7`I\u0015\fH\u0003BAG\u0003WD\u0001\u0002\\As\u0003\u0003\u0005\rA\t\u0005\t\u0003_\f9\b)Q\u0005E\u00051qo^*v[\u0002B1\"a=\u0002x\u0001\u0007\t\u0019!C\u0005C\u0005!!mU;n\u00111\t90a\u001eA\u0002\u0003\u0007I\u0011BA}\u0003!\u00117+^7`I\u0015\fH\u0003BAG\u0003wD\u0001\u0002\\A{\u0003\u0003\u0005\rA\t\u0005\t\u0003\u007f\f9\b)Q\u0005E\u0005)!mU;nA!Y!1AA<\u0001\u0004\u0005\r\u0011\"\u0003\"\u0003\u0015\u0011'mU;n\u00111\u00119!a\u001eA\u0002\u0003\u0007I\u0011\u0002B\u0005\u0003%\u0011'mU;n?\u0012*\u0017\u000f\u0006\u0003\u0002\u000e\n-\u0001\u0002\u00037\u0003\u0006\u0005\u0005\t\u0019\u0001\u0012\t\u0011\t=\u0011q\u000fQ!\n\t\naA\u00192Tk6\u0004\u0003\u0002\u0004B\n\u0003o\u0002\r\u00111A\u0005\n\tU\u0011\u0001B1Tk6,\"Aa\u0006\u0011\t\te!qD\u0007\u0003\u00057Q1A!\b\u0005\u0003\u0019a\u0017N\\1mO&!!\u0011\u0005B\u000e\u0005-!UM\\:f-\u0016\u001cGo\u001c:\t\u0019\t\u0015\u0012q\u000fa\u0001\u0002\u0004%IAa\n\u0002\u0011\u0005\u001cV/\\0%KF$B!!$\u0003*!IANa\t\u0002\u0002\u0003\u0007!q\u0003\u0005\n\u0005[\t9\b)Q\u0005\u0005/\tQ!Y*v[\u0002BAB!\r\u0002x\u0001\u0007\t\u0019!C\u0005\u0005+\tQ!\u00192Tk6DAB!\u000e\u0002x\u0001\u0007\t\u0019!C\u0005\u0005o\t\u0011\"\u00192Tk6|F%Z9\u0015\t\u00055%\u0011\b\u0005\nY\nM\u0012\u0011!a\u0001\u0005/A\u0011B!\u0010\u0002x\u0001\u0006KAa\u0006\u0002\r\u0005\u00147+^7!\u00111\u0011\t%a\u001eA\u0002\u0003\u0007I\u0011\u0002B\u000b\u0003\u0015\t\u0017mU;n\u00111\u0011)%a\u001eA\u0002\u0003\u0007I\u0011\u0002B$\u0003%\t\u0017mU;n?\u0012*\u0017\u000f\u0006\u0003\u0002\u000e\n%\u0003\"\u00037\u0003D\u0005\u0005\t\u0019\u0001B\f\u0011%\u0011i%a\u001e!B\u0013\u00119\"\u0001\u0004bCN+X\u000e\t\u0005\t\u0005#\n9\b\"\u0003\u0003T\u0005!\u0011N\\5u)\u0011\tiI!\u0016\t\u000f\u0005m%q\na\u0001\t\"A!\u0011LA<\t\u0003\u0011Y&A\u0002bI\u0012$BA!\u0018\u0003`5\u0011\u0011q\u000f\u0005\t\u0005C\u00129\u00061\u0001\u0003d\u0005A\u0011N\\:uC:\u001cW\r\u0005\u0003\u0003f\t-TB\u0001B4\u0015\r\u0011I\u0007B\u0001\bM\u0016\fG/\u001e:f\u0013\u0011\u0011iGa\u001a\u0003\u0011%s7\u000f^1oG\u0016D\u0001B!\u001d\u0002x\u0011\u0005!1O\u0001\u0006[\u0016\u0014x-\u001a\u000b\u0005\u0005;\u0012)\b\u0003\u0005\u0003x\t=\u0004\u0019AAA\u0003\u0015yG\u000f[3s\u0011!\u0011Y(a\u001e\u0005\u0002\tu\u0014\u0001\u0003<bY&$\u0017\r^3\u0015\u0005\u00055\u0005\u0002\u0003BA\u0003o\"\tA!\u0006\u0002\t\u0005\u0014\u0015M\u001d\u0005\b\u0005\u000b\u000b9\b\"\u0001\"\u0003\u0011\u0011')\u0019:\t\u000f\t%\u0015q\u000fC\u0001C\u0005)!M\u0019\"be\"9!QRA<\t\u0003\t\u0013\u0001\u00022Ti\u0012D\u0001B!%\u0002x\u0011\u0005!QC\u0001\u0006C\n\u0014\u0015M\u001d\u0005\t\u0005+\u000b9\b\"\u0001\u0003\u0016\u0005)\u0011-\u0019\"be\"A!\u0011TA<\t\u0003\u0011)\"\u0001\u0003b'R$\u0007\u0002\u0003BO\u0003o\"\tA!\u0006\u0002\t\u00054\u0016M\u001d\u0005\n\u0005Cc\u0014\u0013!C\u0001\u0005G\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u00122TC\u0001BSU\r1$qU\u0016\u0003\u0005S\u0003BAa+\u000366\u0011!Q\u0016\u0006\u0005\u0005_\u0013\t,A\u0005v]\u000eDWmY6fI*\u0019!1W\b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00038\n5&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I!1\u0018\u001f\u0012\u0002\u0013\u0005!QX\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\t}&f\u0001#\u0003(\"I!1\u0019\u001f\u0012\u0002\u0013\u0005!QY\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001d\u0016\u0005\t\u001d'f\u0001\u0012\u0003(\"I\u00111\u0001\u001f\u0002\u0002\u0013%\u0011Q\u0001\u0005\n\u0005\u001b\u0004!\u0011!Q\u0001\nY\n1b]8mm\u0016\u0014H+\u001f9fA!I!\u0011\u001b\u0001\u0003\u0006\u0004%\taQ\u0001\b[\u0006D\u0018\n^3s\u0011%\u0011)\u000e\u0001B\u0001B\u0003%A)\u0001\u0005nCbLE/\u001a:!\u0011%\u0011I\u000e\u0001BC\u0002\u0013\u0005\u0011%A\u0002u_2D\u0011B!8\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\u0002\tQ|G\u000e\t\u0005\u0007\u007f\u0001!\tA!9\u0015%\t\r(Q\u001dBt\u0005S\u0014YO!<\u0003p\nE(1\u001f\t\u0003q\u0001Aaa\u0006Bp\u0001\u0004Q\u0002B\u0002\u0011\u0003`\u0002\u0007!\u0005\u0003\u0004)\u0005?\u0004\rA\t\u0005\u0007Y\t}\u0007\u0019\u0001\u000e\t\rA\u0012y\u000e1\u0001\u001b\u0011!!$q\u001cI\u0001\u0002\u00041\u0004\"\u0003Bi\u0005?\u0004\n\u00111\u0001E\u0011%\u0011INa8\u0011\u0002\u0003\u0007!\u0005C\u0004\u0003x\u0002!\tA!?\u0002\u0007\u0019LG\u000f\u0006\u0004\u0003|\u000e\u00051\u0011\u0003\t\u0004q\tu\u0018b\u0001B\u0000\u0005\tIr+Z5hQR,G\rT3bgR\u001c\u0016/^1sKNlu\u000eZ3m\u0011!\u0019\u0019A!>A\u0002\r\u0015\u0011!C5ogR\fgnY3t!\u0019\u00199a!\u0004\u0003d5\u00111\u0011\u0002\u0006\u0004\u0007\u00171\u0011a\u0001:eI&!1qBB\u0005\u0005\r\u0011F\t\u0012\u0005\u000b\u0007'\u0011)\u0010%AA\u0002\rU\u0011!B5ogR\u0014\b\u0003BB\f\u0007;i!a!\u0007\u000b\u0007\rmA!\u0001\u0003vi&d\u0017\u0002BB\u0010\u00073\u0011qc\u00149uS>t\u0017\r\\%ogR\u0014X/\\3oi\u0006$\u0018n\u001c8\t\u000f\r\r\u0002\u0001\"\u0003\u0004&\u00051q-\u001a;Bi\u0006#bAa\u0006\u0004(\r-\u0002\u0002\u0003BK\u0007C\u0001\ra!\u000b\u0011\t9\tIG\t\u0005\t\u0005\u0003\u001b\t\u00031\u0001\u0004*!91q\u0006\u0001\u0005\n\rE\u0012AB4fi\u0006#(\t\u0006\u0004\u0003\u0018\rM2Q\u0007\u0005\t\u0005#\u001bi\u00031\u0001\u0004*!9!QQB\u0017\u0001\u0004\u0011\u0003\"CB\u001d\u0001E\u0005I\u0011AB\u001e\u000351\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u00111Q\b\u0016\u0005\u0007+\u00119\u000b")
public class WeightedLeastSquares
implements Serializable {
    private final boolean fitIntercept;
    private final double regParam;
    private final double elasticNetParam;
    private final boolean standardizeFeatures;
    private final boolean standardizeLabel;
    private final Solver solverType;
    private final int maxIter;
    private final double tol;

    public static double $lessinit$greater$default$8() {
        return WeightedLeastSquares$.MODULE$.$lessinit$greater$default$8();
    }

    public static int $lessinit$greater$default$7() {
        return WeightedLeastSquares$.MODULE$.$lessinit$greater$default$7();
    }

    public static Solver $lessinit$greater$default$6() {
        return WeightedLeastSquares$.MODULE$.$lessinit$greater$default$6();
    }

    public static Product[] supportedSolvers() {
        return WeightedLeastSquares$.MODULE$.supportedSolvers();
    }

    public static int MAX_NUM_FEATURES() {
        return WeightedLeastSquares$.MODULE$.MAX_NUM_FEATURES();
    }

    public boolean fitIntercept() {
        return this.fitIntercept;
    }

    public double regParam() {
        return this.regParam;
    }

    public double elasticNetParam() {
        return this.elasticNetParam;
    }

    public boolean standardizeFeatures() {
        return this.standardizeFeatures;
    }

    public boolean standardizeLabel() {
        return this.standardizeLabel;
    }

    public Solver solverType() {
        return this.solverType;
    }

    public int maxIter() {
        return this.maxIter;
    }

    public double tol() {
        return this.tol;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public WeightedLeastSquaresModel fit(RDD<Instance> instances, OptionalInstrumentation instr) {
        block25: {
            block26: {
                if (this.regParam() == 0.0) {
                    instr.logWarning((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "regParam is zero, which might cause numerical instability and overfitting.";
                        }
                    });
                }
                x$7 = new Aggregator();
                x$8 = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Aggregator apply(Aggregator x$1, Instance x$2) {
                        return x$1.add(x$2);
                    }
                };
                x$9 = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Aggregator apply(Aggregator x$3, Aggregator x$4) {
                        return x$3.merge(x$4);
                    }
                };
                x$10 = instances.treeAggregate$default$4((Object)x$7);
                summary = (Aggregator)instances.treeAggregate((Object)x$7, (Function2)x$8, (Function2)x$9, x$10, ClassTag$.MODULE$.apply(Aggregator.class));
                summary.validate();
                instr.logInfo((Function0<String>)new Serializable(this, summary){
                    public static final long serialVersionUID = 0L;
                    private final Aggregator summary$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of instances: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.summary$1.count())}));
                    }
                    {
                        this.summary$1 = summary$1;
                    }
                });
                k = this.fitIntercept() != false ? summary.k() + 1 : summary.k();
                numFeatures = summary.k();
                triK = summary.triK();
                wSum = summary.wSum();
                rawBStd = summary.bStd();
                rawBBar = summary.bBar();
                v0 = bStd = rawBStd == 0.0 ? package$.MODULE$.abs(rawBBar) : rawBStd;
                if (rawBStd == (double)false) {
                    if (this.fitIntercept() || rawBBar == 0.0) {
                        if (rawBBar == 0.0) {
                            instr.logWarning((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mean and standard deviation of the label are zero, so the "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients and the intercept will all be zero; as a result, training is not "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"needed."})).s((Seq)Nil$.MODULE$)).toString();
                                }
                            });
                        } else {
                            instr.logWarning((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The standard deviation of the label is zero, so the coefficients "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"will be zeros and the intercept will be the mean of the label; as a result, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"training is not needed."})).s((Seq)Nil$.MODULE$)).toString();
                                }
                            });
                        }
                        coefficients = new DenseVector((double[])Array$.MODULE$.ofDim(numFeatures, ClassTag$.MODULE$.Double()));
                        intercept = rawBBar;
                        diagInvAtWA = new DenseVector(new double[]{0.0});
                        return new WeightedLeastSquaresModel(coefficients, intercept, diagInvAtWA, new double[]{0.0});
                    }
                    Predef$.MODULE$.require(!(this.regParam() > 0.0) || this.standardizeLabel() == false, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "The standard deviation of the label is zero. Model cannot be regularized with standardization=true";
                        }
                    });
                    instr.logWarning((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The standard deviation of the label is zero. Consider setting "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fitIntercept=true."})).s((Seq)Nil$.MODULE$)).toString();
                        }
                    });
                }
                bBar = summary.bBar() / bStd;
                bbBar = summary.bbBar() / (bStd * bStd);
                aStd = summary.aStd();
                aStdValues = aStd.values();
                _aBar = summary.aBar();
                _aBarValues = _aBar.values();
                for (i = 0; i < numFeatures; ++i) {
                    if (aStdValues[i] == 0.0) {
                        _aBarValues[i] = 0.0;
                        continue;
                    }
                    var33_25 = i;
                    _aBarValues[var33_25] = _aBarValues[var33_25] / aStdValues[i];
                }
                aBar = _aBar;
                aBarValues = aBar.values();
                _abBar = summary.abBar();
                _abBarValues = _abBar.values();
                for (i = 0; i < numFeatures; ++i) {
                    if (aStdValues[i] == 0.0) {
                        _abBarValues[i] = 0.0;
                        continue;
                    }
                    var39_31 = i;
                    _abBarValues[var39_31] = _abBarValues[var39_31] / (aStdValues[i] * bStd);
                }
                abBar = _abBar;
                abBarValues = abBar.values();
                _aaBar = summary.aaBar();
                _aaBarValues = _aaBar.values();
                p = 0;
                for (j = 0; j < numFeatures; ++j) {
                    aStdJ = aStdValues[j];
                    for (i = 0; i <= j; ++i) {
                        aStdI = aStdValues[i];
                        if (aStdJ == 0.0 || aStdI == 0.0) {
                            _aaBarValues[p] = 0.0;
                        } else {
                            var51_41 = p;
                            _aaBarValues[var51_41] = _aaBarValues[var51_41] / (aStdI * aStdJ);
                        }
                        ++p;
                    }
                }
                aaBar = _aaBar;
                aaBarValues = aaBar.values();
                effectiveRegParam = this.regParam() / bStd;
                effectiveL1RegParam = this.elasticNetParam() * effectiveRegParam;
                effectiveL2RegParam = (1.0 - this.elasticNetParam()) * effectiveRegParam;
                i = 0;
                j = 2;
                while (i < triK) {
                    lambda = effectiveL2RegParam;
                    if (!this.standardizeFeatures()) {
                        std = aStdValues[j - 2];
                        lambda = std != 0.0 ? (lambda /= std * std) : 0.0;
                    }
                    if (!this.standardizeLabel()) {
                        lambda *= bStd;
                    }
                    var65_51 = i;
                    aaBarValues[var65_51] = aaBarValues[var65_51] + lambda;
                    i += j;
                    ++j;
                }
                aa = this.getAtA(aaBarValues, aBarValues);
                ab = this.getAtB(abBarValues, bBar);
                v1 = this.solverType();
                var69_54 = WeightedLeastSquares$Auto$.MODULE$;
                if (v1 != null ? v1.equals(var69_54) == false : var69_54 != null) break block26;
                if (this.elasticNetParam() != 0.0 && this.regParam() != 0.0) ** GOTO lbl-1000
            }
            v2 = this.solverType();
            var70_55 = WeightedLeastSquares$QuasiNewton$.MODULE$;
            if (!(v2 != null ? v2.equals(var70_55) == false : var70_55 != null)) lbl-1000:
            // 2 sources

            {
                effectiveL1RegFun = effectiveL1RegParam != 0.0 ? new Some((Object)new Serializable(this, numFeatures, aStdValues, effectiveL1RegParam){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ WeightedLeastSquares $outer;
                    private final int numFeatures$1;
                    private final double[] aStdValues$1;
                    private final double effectiveL1RegParam$1;

                    public final double apply(int index2) {
                        return this.apply$mcDI$sp(index2);
                    }

                    public double apply$mcDI$sp(int index2) {
                        return this.$outer.fitIntercept() && index2 == this.numFeatures$1 ? 0.0 : (this.$outer.standardizeFeatures() ? this.effectiveL1RegParam$1 : (this.aStdValues$1[index2] != 0.0 ? this.effectiveL1RegParam$1 / this.aStdValues$1[index2] : 0.0));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.numFeatures$1 = numFeatures$1;
                        this.aStdValues$1 = aStdValues$1;
                        this.effectiveL1RegParam$1 = effectiveL1RegParam$1;
                    }
                }) : None$.MODULE$;
                v3 /* !! */  = new QuasiNewtonSolver(this.fitIntercept(), this.maxIter(), this.tol(), (Option<Function1<Object, Object>>)effectiveL1RegFun);
            } else {
                v3 /* !! */  = new CholeskySolver();
            }
            var73_58 = solver = v3 /* !! */ ;
            if (var73_58 instanceof CholeskySolver) {
                var74_59 = var73_58;
                v4 = var74_59.solve(bBar, bbBar, ab, aa, aBar);
            }
            if (var73_58 instanceof QuasiNewtonSolver) {
                var83_60 = (QuasiNewtonSolver)var73_58;
                var75_61 = var83_60.solve(bBar, bbBar, ab, aa, aBar);
            } else {
                throw new MatchError((Object)var73_58);
                catch (Throwable var76_62) {
                    var77_63 = var76_62;
                    if (!(var77_63 instanceof SingularMatrixException)) break block25;
                    v5 = this.solverType();
                    var78_64 = WeightedLeastSquares$Auto$.MODULE$;
                    if (v5 != null ? v5.equals(var78_64) == false : var78_64 != null) break block25;
                    instr.logWarning((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Cholesky solver failed due to singular covariance matrix. Retrying with Quasi-Newton solver.";
                        }
                    });
                    _aa = this.getAtA(aaBarValues, aBarValues);
                    _ab = this.getAtB(abBarValues, bBar);
                    newSolver = new QuasiNewtonSolver(this.fitIntercept(), this.maxIter(), this.tol(), (Option<Function1<Object, Object>>)None$.MODULE$);
                    v4 = var79_68 = newSolver.solve(bBar, bbBar, _ab, _aa, aBar);
                }
                var75_61 = v4;
            }
            solution = var75_61;
            v6 = var85_70 = this.fitIntercept() != false ? new Tuple2(Predef$.MODULE$.doubleArrayOps(solution.coefficients()).slice(0, solution.coefficients().length - 1), (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(solution.coefficients()).last()) * bStd))) : new Tuple2((Object)solution.coefficients(), (Object)BoxesRunTime.boxToDouble((double)0.0));
            if (var85_70 != null) {
                coefficientArray = (double[])var85_70._1();
                intercept = var85_70._2$mcD$sp();
                var84_74 = var89_73 = new Tuple2((Object)coefficientArray, (Object)BoxesRunTime.boxToDouble((double)intercept));
                coefficientArray = (double[])var84_74._1();
                intercept = var84_74._2$mcD$sp();
                len = coefficientArray.length;
                for (q = 0; q < len; ++q) {
                    var95_79 = q;
                    coefficientArray[var95_79] = coefficientArray[var95_79] * (aStdValues[q] != 0.0 ? bStd / aStdValues[q] : 0.0);
                }
                diagInvAtWA = (DenseVector)solution.aaInv().map((Function1)new Serializable(this, k, wSum, aStdValues){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ WeightedLeastSquares $outer;
                    public final int k$1;
                    public final double wSum$1;
                    public final double[] aStdValues$1;

                    public final DenseVector apply(double[] inv) {
                        return new DenseVector((double[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.k$1).map((Function1)new Serializable(this, inv){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$9 $outer;
                            private final double[] inv$1;

                            public final double apply(int i) {
                                return this.apply$mcDI$sp(i);
                            }

                            public double apply$mcDI$sp(int i) {
                                double multiplier = i == this.$outer.k$1 && this.$outer.org$apache$spark$ml$optim$WeightedLeastSquares$$anonfun$$$outer().fitIntercept() ? 1.0 : this.$outer.aStdValues$1[i - 1] * this.$outer.aStdValues$1[i - 1];
                                return this.inv$1[i + (i - 1) * i / 2 - 1] / (this.$outer.wSum$1 * multiplier);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.inv$1 = inv$1;
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double()));
                    }

                    public /* synthetic */ WeightedLeastSquares org$apache$spark$ml$optim$WeightedLeastSquares$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.k$1 = k$1;
                        this.wSum$1 = wSum$1;
                        this.aStdValues$1 = aStdValues$1;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DenseVector apply() {
                        return new DenseVector(new double[]{0.0});
                    }
                });
                return new WeightedLeastSquaresModel(new DenseVector(coefficientArray), intercept, diagInvAtWA, (double[])solution.objectiveHistory().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double[] apply() {
                        return new double[]{0.0};
                    }
                }));
            }
            throw new MatchError((Object)var85_70);
        }
        throw var76_62;
    }

    public OptionalInstrumentation fit$default$2() {
        return OptionalInstrumentation$.MODULE$.create(WeightedLeastSquares.class);
    }

    private DenseVector getAtA(double[] aaBar, double[] aBar) {
        return this.fitIntercept() ? new DenseVector((double[])Array$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new double[][]{aaBar, aBar, {1.0}}), ClassTag$.MODULE$.Double())) : new DenseVector((double[])aaBar.clone());
    }

    private DenseVector getAtB(double[] abBar, double bBar) {
        return this.fitIntercept() ? new DenseVector((double[])Array$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new double[][]{abBar, {bBar}}), ClassTag$.MODULE$.Double())) : new DenseVector((double[])abBar.clone());
    }

    public WeightedLeastSquares(boolean fitIntercept, double regParam, double elasticNetParam, boolean standardizeFeatures, boolean standardizeLabel, Solver solverType, int maxIter, double tol) {
        this.fitIntercept = fitIntercept;
        this.regParam = regParam;
        this.elasticNetParam = elasticNetParam;
        this.standardizeFeatures = standardizeFeatures;
        this.standardizeLabel = standardizeLabel;
        this.solverType = solverType;
        this.maxIter = maxIter;
        this.tol = tol;
        Predef$.MODULE$.require(regParam >= 0.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WeightedLeastSquares $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"regParam cannot be negative: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.regParam())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(elasticNetParam >= 0.0 && elasticNetParam <= 1.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WeightedLeastSquares $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"elasticNetParam must be in [0, 1]: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.elasticNetParam())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(maxIter >= 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WeightedLeastSquares $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"maxIter must be a positive integer: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.maxIter())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(tol >= 0.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WeightedLeastSquares $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tol must be >= 0, but was set to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.tol())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static interface Solver {
    }

    public static class Aggregator
    implements Serializable {
        private boolean initialized = false;
        private int k;
        private long count;
        private int triK;
        private double wSum;
        private double wwSum;
        private double bSum;
        private double bbSum;
        private DenseVector aSum;
        private DenseVector abSum;
        private DenseVector aaSum;

        public boolean initialized() {
            return this.initialized;
        }

        public void initialized_$eq(boolean x$1) {
            this.initialized = x$1;
        }

        public int k() {
            return this.k;
        }

        public void k_$eq(int x$1) {
            this.k = x$1;
        }

        public long count() {
            return this.count;
        }

        public void count_$eq(long x$1) {
            this.count = x$1;
        }

        public int triK() {
            return this.triK;
        }

        public void triK_$eq(int x$1) {
            this.triK = x$1;
        }

        public double wSum() {
            return this.wSum;
        }

        public void wSum_$eq(double x$1) {
            this.wSum = x$1;
        }

        private double wwSum() {
            return this.wwSum;
        }

        private void wwSum_$eq(double x$1) {
            this.wwSum = x$1;
        }

        private double bSum() {
            return this.bSum;
        }

        private void bSum_$eq(double x$1) {
            this.bSum = x$1;
        }

        private double bbSum() {
            return this.bbSum;
        }

        private void bbSum_$eq(double x$1) {
            this.bbSum = x$1;
        }

        private DenseVector aSum() {
            return this.aSum;
        }

        private void aSum_$eq(DenseVector x$1) {
            this.aSum = x$1;
        }

        private DenseVector abSum() {
            return this.abSum;
        }

        private void abSum_$eq(DenseVector x$1) {
            this.abSum = x$1;
        }

        private DenseVector aaSum() {
            return this.aaSum;
        }

        private void aaSum_$eq(DenseVector x$1) {
            this.aaSum = x$1;
        }

        private void init(int k) {
            Predef$.MODULE$.require(k <= WeightedLeastSquares$.MODULE$.MAX_NUM_FEATURES(), (Function0)new Serializable(this, k){
                public static final long serialVersionUID = 0L;
                private final int k$2;

                public final String apply() {
                    return new StringBuilder().append((Object)"In order to take the normal equation approach efficiently, ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"we set the max number of features to ", " but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)WeightedLeastSquares$.MODULE$.MAX_NUM_FEATURES()), BoxesRunTime.boxToInteger((int)this.k$2)}))).toString();
                }
                {
                    this.k$2 = k$2;
                }
            });
            this.k_$eq(k);
            this.triK_$eq(k * (k + 1) / 2);
            this.count_$eq(0L);
            this.wSum_$eq(0.0);
            this.wwSum_$eq(0.0);
            this.bSum_$eq(0.0);
            this.bbSum_$eq(0.0);
            this.aSum_$eq(new DenseVector((double[])Array$.MODULE$.ofDim(k, ClassTag$.MODULE$.Double())));
            this.abSum_$eq(new DenseVector((double[])Array$.MODULE$.ofDim(k, ClassTag$.MODULE$.Double())));
            this.aaSum_$eq(new DenseVector((double[])Array$.MODULE$.ofDim(this.triK(), ClassTag$.MODULE$.Double())));
            this.initialized_$eq(true);
        }

        public Aggregator add(Instance instance) {
            Instance instance2 = instance;
            if (instance2 != null) {
                Tuple3 tuple3;
                double l = instance2.label();
                double w2 = instance2.weight();
                Vector f = instance2.features();
                Tuple3 tuple32 = tuple3 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)l), (Object)BoxesRunTime.boxToDouble((double)w2), (Object)f);
                double l2 = BoxesRunTime.unboxToDouble((Object)tuple32._1());
                double w3 = BoxesRunTime.unboxToDouble((Object)tuple32._2());
                Vector f2 = (Vector)tuple32._3();
                int ak = f2.size();
                if (!this.initialized()) {
                    this.init(ak);
                }
                Predef$.MODULE$.assert(ak == this.k(), (Function0)new Serializable(this, ak){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Aggregator $outer;
                    private final int ak$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dimension mismatch. Expect vectors of size ", " but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.k()), BoxesRunTime.boxToInteger((int)this.ak$1)}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.ak$1 = ak$1;
                    }
                });
                this.count_$eq(this.count() + 1L);
                this.wSum_$eq(this.wSum() + w3);
                this.wwSum_$eq(this.wwSum() + w3 * w3);
                this.bSum_$eq(this.bSum() + w3 * l2);
                this.bbSum_$eq(this.bbSum() + w3 * l2 * l2);
                BLAS$.MODULE$.axpy(w3, f2, (Vector)this.aSum());
                BLAS$.MODULE$.axpy(w3 * l2, f2, (Vector)this.abSum());
                BLAS$.MODULE$.spr(w3, f2, this.aaSum());
                return this;
            }
            throw new MatchError((Object)instance2);
        }

        public Aggregator merge(Aggregator other) {
            Aggregator aggregator;
            if (other.initialized()) {
                if (!this.initialized()) {
                    this.init(other.k());
                }
                Predef$.MODULE$.assert(this.k() == other.k(), (Function0)new Serializable(this, other){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Aggregator $outer;
                    private final Aggregator other$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dimension mismatch: this.k = ", " but other.k = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.k()), BoxesRunTime.boxToInteger((int)this.other$1.k())}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.other$1 = other$1;
                    }
                });
                this.count_$eq(this.count() + other.count());
                this.wSum_$eq(this.wSum() + other.wSum());
                this.wwSum_$eq(this.wwSum() + other.wwSum());
                this.bSum_$eq(this.bSum() + other.bSum());
                this.bbSum_$eq(this.bbSum() + other.bbSum());
                BLAS$.MODULE$.axpy(1.0, (Vector)other.aSum(), (Vector)this.aSum());
                BLAS$.MODULE$.axpy(1.0, (Vector)other.abSum(), (Vector)this.abSum());
                BLAS$.MODULE$.axpy(1.0, (Vector)other.aaSum(), (Vector)this.aaSum());
                aggregator = this;
            } else {
                aggregator = this;
            }
            return aggregator;
        }

        public void validate() {
            Predef$.MODULE$.assert(this.initialized(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Training dataset is empty.";
                }
            });
            Predef$.MODULE$.assert(this.wSum() > 0.0, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Sum of weights cannot be zero.";
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        public DenseVector aBar() {
            void var1_1;
            DenseVector output = this.aSum().copy();
            BLAS$.MODULE$.scal(1.0 / this.wSum(), (Vector)output);
            return var1_1;
        }

        public double bBar() {
            return this.bSum() / this.wSum();
        }

        public double bbBar() {
            return this.bbSum() / this.wSum();
        }

        public double bStd() {
            double variance2 = package$.MODULE$.max(this.bbSum() / this.wSum() - this.bBar() * this.bBar(), 0.0);
            return package$.MODULE$.sqrt(variance2);
        }

        /*
         * WARNING - void declaration
         */
        public DenseVector abBar() {
            void var1_1;
            DenseVector output = this.abSum().copy();
            BLAS$.MODULE$.scal(1.0 / this.wSum(), (Vector)output);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public DenseVector aaBar() {
            void var1_1;
            DenseVector output = this.aaSum().copy();
            BLAS$.MODULE$.scal(1.0 / this.wSum(), (Vector)output);
            return var1_1;
        }

        public DenseVector aStd() {
            double[] std = (double[])Array$.MODULE$.ofDim(this.k(), ClassTag$.MODULE$.Double());
            int i = 0;
            int j = 2;
            double[] aaValues = this.aaSum().values();
            while (i < this.triK()) {
                int l = j - 2;
                double aw = this.aSum().apply(l) / this.wSum();
                std[l] = package$.MODULE$.sqrt(package$.MODULE$.max(aaValues[i] / this.wSum() - aw * aw, 0.0));
                i += j;
                ++j;
            }
            return new DenseVector(std);
        }

        public DenseVector aVar() {
            double[] variance2 = (double[])Array$.MODULE$.ofDim(this.k(), ClassTag$.MODULE$.Double());
            int i = 0;
            int j = 2;
            double[] aaValues = this.aaSum().values();
            while (i < this.triK()) {
                int l = j - 2;
                double aw = this.aSum().apply(l) / this.wSum();
                variance2[l] = package$.MODULE$.max(aaValues[i] / this.wSum() - aw * aw, 0.0);
                i += j;
                ++j;
            }
            return new DenseVector(variance2);
        }
    }
}

