/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaDoubleRDD;
import org.apache.spark.api.java.JavaDoubleRDD$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.IsotonicRegressionModel$;
import org.apache.spark.mllib.regression.IsotonicRegressionModel$SaveLoadV1_0$;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\t-g\u0001B\u0001\u0003\u00015\u0011q#S:pi>t\u0017n\u0019*fOJ,7o]5p]6{G-\u001a7\u000b\u0005\r!\u0011A\u0003:fOJ,7o]5p]*\u0011QAB\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u000f)q\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u001b\u001b\u00051\"BA\f\u0019\u0003\tIwNC\u0001\u001a\u0003\u0011Q\u0017M^1\n\u0005m1\"\u0001D*fe&\fG.\u001b>bE2,\u0007CA\u000f!\u001b\u0005q\"BA\u0010\u0005\u0003\u0011)H/\u001b7\n\u0005\u0005r\"\u0001C*bm\u0016\f'\r\\3\t\u0011\r\u0002!Q1A\u0005\u0002\u0011\n!BY8v]\u0012\f'/[3t+\u0005)\u0003cA\b'Q%\u0011q\u0005\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u001f%J!A\u000b\t\u0003\r\u0011{WO\u00197fQ\r\u0011CF\r\t\u0003[Aj\u0011A\f\u0006\u0003_\u0019\t!\"\u00198o_R\fG/[8o\u0013\t\tdFA\u0003TS:\u001cW-I\u00014\u0003\u0015\tdf\r\u00181\u0011!)\u0004A!A!\u0002\u0013)\u0013a\u00032pk:$\u0017M]5fg\u0002B3\u0001\u000e\u00173\u0011!A\u0004A!b\u0001\n\u0003!\u0013a\u00039sK\u0012L7\r^5p]ND3a\u000e\u00173\u0011!Y\u0004A!A!\u0002\u0013)\u0013\u0001\u00049sK\u0012L7\r^5p]N\u0004\u0003f\u0001\u001e-e!Aa\b\u0001BC\u0002\u0013\u0005q(\u0001\u0005jg>$xN\\5d+\u0005\u0001\u0005CA\bB\u0013\t\u0011\u0005CA\u0004C_>dW-\u00198)\u0007ub#\u0007\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003A\u0003%I7o\u001c;p]&\u001c\u0007\u0005K\u0002EYIBQ\u0001\u0013\u0001\u0005\u0002%\u000ba\u0001P5oSRtD\u0003\u0002&M\u001dB\u0003\"a\u0013\u0001\u000e\u0003\tAQaI$A\u0002\u0015B3\u0001\u0014\u00173\u0011\u0015At\t1\u0001&Q\rqEF\r\u0005\u0006}\u001d\u0003\r\u0001\u0011\u0015\u0004!2\u0012\u0004fA$-e!9A\u000b\u0001b\u0001\n\u0013)\u0016!\u00049sK\u0012L7\r^5p]>\u0013H-F\u0001W!\r9&\fK\u0007\u00021*\u0011\u0011\fE\u0001\u0005[\u0006$\b.\u0003\u0002\\1\nAqJ\u001d3fe&tw\r\u0003\u0004^\u0001\u0001\u0006IAV\u0001\u000faJ,G-[2uS>twJ\u001d3!\u0011\u0015A\u0005\u0001\"\u0001`)\u0011Q\u0005m\u001a5\t\u000b\rr\u0006\u0019A1\u0011\u0007\t,\u0007&D\u0001d\u0015\t!\u0007$\u0001\u0003mC:<\u0017B\u00014d\u0005!IE/\u001a:bE2,\u0007\"\u0002\u001d_\u0001\u0004\t\u0007\"\u0002 _\u0001\u0004I\u0007C\u00012k\u0013\t\u00115\rK\u0002_Y1\f\u0013!\\\u0001\u0006c9\"d\u0006\r\u0005\u0006_\u0002!I\u0001]\u0001\u000eCN\u001cXM\u001d;Pe\u0012,'/\u001a3\u0015\u0007E\f)\u0001\u0006\u0002skB\u0011qb]\u0005\u0003iB\u0011A!\u00168ji\")aO\u001ca\u0002o\u0006\u0019qN\u001d3\u0011\ta\f\t\u0001\u000b\b\u0003szt!A_?\u000e\u0003mT!\u0001 \u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0012BA@\u0011\u0003\u001d\u0001\u0018mY6bO\u0016L1aWA\u0002\u0015\ty\b\u0003\u0003\u0004\u0002\b9\u0004\r!J\u0001\u0003qNDq!a\u0003\u0001\t\u0003\ti!A\u0004qe\u0016$\u0017n\u0019;\u0015\t\u0005=\u00111\u0004\t\u0006\u0003#\t9\u0002K\u0007\u0003\u0003'Q1!!\u0006\u0007\u0003\r\u0011H\rZ\u0005\u0005\u00033\t\u0019BA\u0002S\t\u0012C\u0001\"!\b\u0002\n\u0001\u0007\u0011qB\u0001\ti\u0016\u001cH\u000fR1uC\"\"\u0011\u0011\u0002\u00173\u0011\u001d\tY\u0001\u0001C\u0001\u0003G!B!!\n\u00024A!\u0011qEA\u0018\u001b\t\tICC\u0002\u001a\u0003WQ1!!\f\u0007\u0003\r\t\u0007/[\u0005\u0005\u0003c\tICA\u0007KCZ\fGi\\;cY\u0016\u0014F\t\u0012\u0005\t\u0003;\t\t\u00031\u0001\u0002&!\"\u0011\u0011\u0005\u00173\u0011\u001d\tY\u0001\u0001C\u0001\u0003s!2\u0001KA\u001e\u0011\u001d\ti\"a\u000eA\u0002!BC!a\u000e-e!A\u0011\u0011\t\u0001\u0005\u0002\u0011\t\u0019%\u0001\bc_VtG-\u0019:z-\u0016\u001cGo\u001c:\u0016\u0005\u0005\u0015\u0003\u0003BA$\u0003\u001bj!!!\u0013\u000b\u0007\u0005-C!\u0001\u0004mS:\fGnZ\u0005\u0005\u0003\u001f\nIE\u0001\u0004WK\u000e$xN\u001d\u0005\t\u0003'\u0002A\u0011\u0001\u0003\u0002D\u0005\u0001\u0002O]3eS\u000e$\u0018n\u001c8WK\u000e$xN\u001d\u0005\b\u0003/\u0002A\u0011IA-\u0003\u0011\u0019\u0018M^3\u0015\u000bI\fY&a\u001a\t\u0011\u0005u\u0013Q\u000ba\u0001\u0003?\n!a]2\u0011\t\u0005\u0005\u00141M\u0007\u0002\r%\u0019\u0011Q\r\u0004\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\t\u0011\u0005%\u0014Q\u000ba\u0001\u0003W\nA\u0001]1uQB!\u0011QNA:\u001d\ry\u0011qN\u0005\u0004\u0003c\u0002\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002v\u0005]$AB*ue&twMC\u0002\u0002rAAC!!\u0016-Y\"9\u0011Q\u0010\u0001\u0005R\u0005}\u0014!\u00044pe6\fGOV3sg&|g.\u0006\u0002\u0002l!\u001a\u0001\u0001\f\u001a\b\u000f\u0005\u0015%\u0001#\u0001\u0002\b\u00069\u0012j]8u_:L7MU3he\u0016\u001c8/[8o\u001b>$W\r\u001c\t\u0004\u0017\u0006%eAB\u0001\u0003\u0011\u0003\tYiE\u0004\u0002\n:\ti)a%\u0011\tu\tyIS\u0005\u0004\u0003#s\"A\u0002'pC\u0012,'\u000fE\u0002\u0010\u0003+K!a\u0007\t\t\u000f!\u000bI\t\"\u0001\u0002\u001aR\u0011\u0011qQ\u0004\t\u0003;\u000bI\t#\u0003\u0002 \u0006a1+\u0019<f\u0019>\fGMV\u0019`aA!\u0011\u0011UAR\u001b\t\tII\u0002\u0005\u0002&\u0006%\u0005\u0012BAT\u00051\u0019\u0016M^3M_\u0006$g+M01'\r\t\u0019K\u0004\u0005\b\u0011\u0006\rF\u0011AAV)\t\ty\n\u0003\u0005\u00020\u0006\rF\u0011AA@\u0003E!\b.[:G_Jl\u0017\r\u001e,feNLwN\u001c\u0005\t\u0003g\u000b\u0019\u000b\"\u0001\u0002\u0000\u0005iA\u000f[5t\u00072\f7o\u001d(b[\u00164q!a.\u0002$\u0002\u000bIL\u0001\u0003ECR\f7cBA[\u001d\u0005m\u00161\u0013\t\u0004\u001f\u0005u\u0016bAA`!\t9\u0001K]8ek\u000e$\bbCAb\u0003k\u0013)\u001a!C\u0001\u0003\u000b\f\u0001BY8v]\u0012\f'/_\u000b\u0002Q!Q\u0011\u0011ZA[\u0005#\u0005\u000b\u0011\u0002\u0015\u0002\u0013\t|WO\u001c3bef\u0004\u0003bCAg\u0003k\u0013)\u001a!C\u0001\u0003\u000b\f!\u0002\u001d:fI&\u001cG/[8o\u0011)\t\t.!.\u0003\u0012\u0003\u0006I\u0001K\u0001\faJ,G-[2uS>t\u0007\u0005C\u0004I\u0003k#\t!!6\u0015\r\u0005]\u00171\\Ao!\u0011\tI.!.\u000e\u0005\u0005\r\u0006bBAb\u0003'\u0004\r\u0001\u000b\u0005\b\u0003\u001b\f\u0019\u000e1\u0001)\u0011)\t\t/!.\u0002\u0002\u0013\u0005\u00111]\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0002X\u0006\u0015\u0018q\u001d\u0005\n\u0003\u0007\fy\u000e%AA\u0002!B\u0011\"!4\u0002`B\u0005\t\u0019\u0001\u0015\t\u0015\u0005-\u0018QWI\u0001\n\u0003\ti/\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005=(f\u0001\u0015\u0002r.\u0012\u00111\u001f\t\u0005\u0003k\fi0\u0004\u0002\u0002x*!\u0011\u0011`A~\u0003%)hn\u00195fG.,GM\u0003\u00020!%!\u0011q`A|\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0005\u0007\t),%A\u0005\u0002\u00055\u0018AD2paf$C-\u001a4bk2$HE\r\u0005\u000b\u0005\u000f\t),!A\u0005B\t%\u0011!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003\fA\u0019!M!\u0004\n\u0007\u0005U4\r\u0003\u0006\u0003\u0012\u0005U\u0016\u0011!C\u0001\u0005'\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"A!\u0006\u0011\u0007=\u00119\"C\u0002\u0003\u001aA\u00111!\u00138u\u0011)\u0011i\"!.\u0002\u0002\u0013\u0005!qD\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011\tCa\n\u0011\u0007=\u0011\u0019#C\u0002\u0003&A\u00111!\u00118z\u0011)\u0011ICa\u0007\u0002\u0002\u0003\u0007!QC\u0001\u0004q\u0012\n\u0004B\u0003B\u0017\u0003k\u000b\t\u0011\"\u0011\u00030\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00032A1!1\u0007B\u001d\u0005Ci!A!\u000e\u000b\u0007\t]\u0002#\u0001\u0006d_2dWm\u0019;j_:LAAa\u000f\u00036\tA\u0011\n^3sCR|'\u000f\u0003\u0006\u0003@\u0005U\u0016\u0011!C\u0001\u0005\u0003\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004\u0001\n\r\u0003B\u0003B\u0015\u0005{\t\t\u00111\u0001\u0003\"!Q!qIA[\u0003\u0003%\tE!\u0013\u0002\u0011!\f7\u000f[\"pI\u0016$\"A!\u0006\t\u0015\t5\u0013QWA\u0001\n\u0003\u0012y%\u0001\u0005u_N#(/\u001b8h)\t\u0011Y\u0001\u0003\u0006\u0003T\u0005U\u0016\u0011!C!\u0005+\na!Z9vC2\u001cHc\u0001!\u0003X!Q!\u0011\u0006B)\u0003\u0003\u0005\rA!\t\b\u0015\tm\u00131UA\u0001\u0012\u0003\u0011i&\u0001\u0003ECR\f\u0007\u0003BAm\u0005?2!\"a.\u0002$\u0006\u0005\t\u0012\u0001B1'\u0019\u0011yFa\u0019\u0002\u0014BA!Q\rB6Q!\n9.\u0004\u0002\u0003h)\u0019!\u0011\u000e\t\u0002\u000fI,h\u000e^5nK&!!Q\u000eB4\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\b\u0011\n}C\u0011\u0001B9)\t\u0011i\u0006\u0003\u0006\u0003N\t}\u0013\u0011!C#\u0005\u001fB!Ba\u001e\u0003`\u0005\u0005I\u0011\u0011B=\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\t9Na\u001f\u0003~!9\u00111\u0019B;\u0001\u0004A\u0003bBAg\u0005k\u0002\r\u0001\u000b\u0005\u000b\u0005\u0003\u0013y&!A\u0005\u0002\n\r\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u000b\u0013\t\nE\u0003\u0010\u0005\u000f\u0013Y)C\u0002\u0003\nB\u0011aa\u00149uS>t\u0007#B\b\u0003\u000e\"B\u0013b\u0001BH!\t1A+\u001e9mKJB!Ba%\u0003\u0000\u0005\u0005\t\u0019AAl\u0003\rAH\u0005\r\u0005\u000b\u0005/\u0013y&!A\u0005\n\te\u0015a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa'\u0011\u0007\t\u0014i*C\u0002\u0003 \u000e\u0014aa\u00142kK\u000e$\b\u0002CA,\u0003G#\tAa)\u0015\u0017I\u0014)Ka*\u0003*\n-&Q\u0016\u0005\t\u0003;\u0012\t\u000b1\u0001\u0002`!A\u0011\u0011\u000eBQ\u0001\u0004\tY\u0007\u0003\u0004$\u0005C\u0003\r!\n\u0005\u0007q\t\u0005\u0006\u0019A\u0013\t\ry\u0012\t\u000b1\u0001A\u0011!\u0011\t,a)\u0005\u0002\tM\u0016\u0001\u00027pC\u0012$bA!.\u00038\ne\u0006#B\b\u0003\u000e\u0016*\u0003\u0002CA/\u0005_\u0003\r!a\u0018\t\u0011\u0005%$q\u0016a\u0001\u0003WB\u0001B!-\u0002\n\u0012\u0005#Q\u0018\u000b\u0006\u0015\n}&\u0011\u0019\u0005\t\u0003;\u0012Y\f1\u0001\u0002`!A\u0011\u0011\u000eB^\u0001\u0004\tY\u0007\u000b\u0003\u0003<2b\u0007B\u0003BL\u0003\u0013\u000b\t\u0011\"\u0003\u0003\u001a\"\"\u0011\u0011\u0012\u0017mQ\u0011\t\u0019\t\f7")
public class IsotonicRegressionModel
implements Serializable,
Saveable {
    private final double[] boundaries;
    private final double[] predictions;
    private final boolean isotonic;
    private final Ordering<Object> predictionOrd;

    public static IsotonicRegressionModel load(SparkContext sparkContext, String string) {
        return IsotonicRegressionModel$.MODULE$.load(sparkContext, string);
    }

    public double[] boundaries() {
        return this.boundaries;
    }

    public double[] predictions() {
        return this.predictions;
    }

    public boolean isotonic() {
        return this.isotonic;
    }

    private Ordering<Object> predictionOrd() {
        return this.predictionOrd;
    }

    private void assertOrdered(double[] xs, Ordering<Object> ord) {
        IntRef i = IntRef.create((int)1);
        int len = xs.length;
        while (i.elem < len) {
            Predef$.MODULE$.require(ord.compare((Object)BoxesRunTime.boxToDouble((double)xs[i.elem - 1]), (Object)BoxesRunTime.boxToDouble((double)xs[i.elem])) <= 0, (Function0)new scala.Serializable(this, xs, i){
                public static final long serialVersionUID = 0L;
                private final double[] xs$1;
                private final IntRef i$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Elements (", ", ", ") are not ordered."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.xs$1[this.i$1.elem - 1]), BoxesRunTime.boxToDouble((double)this.xs$1[this.i$1.elem])}));
                }
                {
                    this.xs$1 = xs$1;
                    this.i$1 = i$1;
                }
            });
            ++i.elem;
        }
    }

    public RDD<Object> predict(RDD<Object> testData) {
        return testData.map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsotonicRegressionModel $outer;

            public final double apply(double testData) {
                return this.apply$mcDD$sp(testData);
            }

            public double apply$mcDD$sp(double testData) {
                return this.$outer.predict(testData);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.Double());
    }

    public JavaDoubleRDD predict(JavaDoubleRDD testData) {
        return JavaDoubleRDD$.MODULE$.fromRDD(this.predict((RDD<Object>)testData.rdd().retag(ClassTag$.MODULE$.apply(Double.class))));
    }

    public double predict(double testData) {
        int foundIndex = Arrays.binarySearch(this.boundaries(), testData);
        int insertIndex = -foundIndex - 1;
        return insertIndex == 0 ? BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(this.predictions()).head()) : (insertIndex == this.boundaries().length ? BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(this.predictions()).last()) : (foundIndex < 0 ? this.linearInterpolation$1(this.boundaries()[insertIndex - 1], this.predictions()[insertIndex - 1], this.boundaries()[insertIndex], this.predictions()[insertIndex], testData) : this.predictions()[foundIndex]));
    }

    public Vector boundaryVector() {
        return Vectors$.MODULE$.dense(this.boundaries());
    }

    public Vector predictionVector() {
        return Vectors$.MODULE$.dense(this.predictions());
    }

    @Override
    public void save(SparkContext sc, String path) {
        IsotonicRegressionModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.boundaries(), this.predictions(), this.isotonic());
    }

    @Override
    public String formatVersion() {
        return "1.0";
    }

    private final double linearInterpolation$1(double x1, double y1, double x2, double y2, double x) {
        return y1 + (y2 - y1) * (x - x1) / (x2 - x1);
    }

    public IsotonicRegressionModel(double[] boundaries, double[] predictions, boolean isotonic) {
        this.boundaries = boundaries;
        this.predictions = predictions;
        this.isotonic = isotonic;
        this.predictionOrd = isotonic ? package$.MODULE$.Ordering().apply((Ordering)Ordering.Double$.MODULE$) : package$.MODULE$.Ordering().apply((Ordering)Ordering.Double$.MODULE$).reverse();
        Predef$.MODULE$.require(boundaries.length == predictions.length);
        this.assertOrdered(boundaries, (Ordering<Object>)Ordering.Double$.MODULE$);
        this.assertOrdered(predictions, this.predictionOrd());
    }

    public IsotonicRegressionModel(Iterable<Object> boundaries, Iterable<Object> predictions, Boolean isotonic) {
        this((double[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(boundaries).asScala()).toArray(ClassTag$.MODULE$.Double()), (double[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(predictions).asScala()).toArray(ClassTag$.MODULE$.Double()), Predef$.MODULE$.Boolean2boolean(isotonic));
    }
}

