/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.ClassificationModel;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel$;
import org.apache.spark.ml.classification.RandomForestClassificationModel$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval$class;
import org.apache.spark.ml.param.shared.HasSeed$class;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.DecisionTreeParams$class;
import org.apache.spark.ml.tree.EnsembleModelReadWrite$;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.RandomForestClassifierParams;
import org.apache.spark.ml.tree.RandomForestParams;
import org.apache.spark.ml.tree.RandomForestParams$class;
import org.apache.spark.ml.tree.TreeClassifierParams;
import org.apache.spark.ml.tree.TreeClassifierParams$class;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.ml.tree.TreeEnsembleModel$;
import org.apache.spark.ml.tree.TreeEnsembleModel$class;
import org.apache.spark.ml.tree.TreeEnsembleParams;
import org.apache.spark.ml.tree.TreeEnsembleParams$class;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.package$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tUe\u0001B\u0001\u0003\u00015\u0011qDU1oI>lgi\u001c:fgR\u001cE.Y:tS\u001aL7-\u0019;j_:lu\u000eZ3m\u0015\t\u0019A!\u0001\bdY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0007\u00019Ir$J\u0016\u0011\t=\u0001\"\u0003G\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002!!J|'-\u00192jY&\u001cH/[2DY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8N_\u0012,G\u000e\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u00051A.\u001b8bY\u001eL!a\u0006\u000b\u0003\rY+7\r^8s!\ty\u0001\u0001\u0005\u0002\u001b;5\t1D\u0003\u0002\u001d\t\u0005!AO]3f\u0013\tq2D\u0001\u000fSC:$w.\u001c$pe\u0016\u001cHo\u00117bgNLg-[3s!\u0006\u0014\u0018-\\:\u0011\u0007i\u0001#%\u0003\u0002\"7\t\tBK]3f\u000b:\u001cX-\u001c2mK6{G-\u001a7\u0011\u0005=\u0019\u0013B\u0001\u0013\u0003\u0005}!UmY5tS>tGK]3f\u00072\f7o]5gS\u000e\fG/[8o\u001b>$W\r\u001c\t\u0003M%j\u0011a\n\u0006\u0003Q\u0011\tA!\u001e;jY&\u0011!f\n\u0002\u000b\u001b2;&/\u001b;bE2,\u0007C\u0001\u00170\u001b\u0005i#\"\u0001\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Aj#\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002\u0003\u001a\u0001\u0005\u000b\u0007I\u0011I\u001a\u0002\u0007ULG-F\u00015!\t)\u0004H\u0004\u0002-m%\u0011q'L\u0001\u0007!J,G-\u001a4\n\u0005eR$AB*ue&twM\u0003\u00028[!\u001a\u0011\u0007\u0010\"\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}2\u0011AC1o]>$\u0018\r^5p]&\u0011\u0011I\u0010\u0002\u0006'&t7-Z\u0011\u0002\u0007\u0006)\u0011GL\u001b/a!AQ\t\u0001B\u0001B\u0003%A'\u0001\u0003vS\u0012\u0004\u0003f\u0001#=\u0005\"A\u0001\n\u0001BC\u0002\u0013%\u0011*\u0001\u0004`iJ,Wm]\u000b\u0002\u0015B\u0019Af\u0013\u0012\n\u00051k#!B!se\u0006L\b\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\u0002\u000f}#(/Z3tA!A\u0001\u000b\u0001BC\u0002\u0013\u0005\u0013+A\u0006ok64U-\u0019;ve\u0016\u001cX#\u0001*\u0011\u00051\u001a\u0016B\u0001+.\u0005\rIe\u000e\u001e\u0015\u0004\u001fr2\u0016%A,\u0002\u000bErcG\f\u0019\t\u0011e\u0003!\u0011!Q\u0001\nI\u000bAB\\;n\r\u0016\fG/\u001e:fg\u0002B3\u0001\u0017\u001fW\u0011!a\u0006A!b\u0001\n\u0003\n\u0016A\u00038v[\u000ec\u0017m]:fg\"\u001a1\f\u0010\"\t\u0011}\u0003!\u0011!Q\u0001\nI\u000b1B\\;n\u00072\f7o]3tA!\u001aa\f\u0010\"\t\r\t\u0004A\u0011\u0001\u0003d\u0003\u0019a\u0014N\\5u}Q)\u0001\u0004\u001a4hS\")!'\u0019a\u0001i!\u001aA\r\u0010\"\t\u000b!\u000b\u0007\u0019\u0001&\t\u000bA\u000b\u0007\u0019\u0001*)\u0007\u001ddd\u000bC\u0003]C\u0002\u0007!\u000bK\u0002jy\tCaA\u0019\u0001\u0005\u0002\u0011aG\u0003\u0002\rn_BDQA\\6A\u0002)\u000bQ\u0001\u001e:fKNDQ\u0001U6A\u0002ICQ\u0001X6A\u0002ICQA\u001c\u0001\u0005B%C3!\u001d\u001ftC\u0005!\u0018!B\u0019/i9\u0002\u0004\u0002\u0003<\u0001\u0011\u000b\u0007I\u0011B<\u0002\u0019}#(/Z3XK&<\u0007\u000e^:\u0016\u0003a\u00042\u0001L&z!\ta#0\u0003\u0002|[\t1Ai\\;cY\u0016D\u0001\" \u0001\t\u0002\u0003\u0006K\u0001_\u0001\u000e?R\u0014X-Z,fS\u001eDGo\u001d\u0011\t\u000b}\u0004A\u0011I<\u0002\u0017Q\u0014X-Z,fS\u001eDGo\u001d\u0015\u0004}r\u001a\bbBA\u0003\u0001\u0011E\u0013qA\u0001\u000eiJ\fgn\u001d4pe6LU\u000e\u001d7\u0015\t\u0005%\u0011\u0011\u0007\t\u0005\u0003\u0017\tYC\u0004\u0003\u0002\u000e\u0005\u0015b\u0002BA\b\u0003CqA!!\u0005\u0002 9!\u00111CA\u000f\u001d\u0011\t)\"a\u0007\u000e\u0005\u0005]!bAA\r\u0019\u00051AH]8pizJ\u0011aC\u0005\u0003\u0013)I!a\u0002\u0005\n\u0007\u0005\rb!A\u0002tc2LA!a\n\u0002*\u00059\u0001/Y2lC\u001e,'bAA\u0012\r%!\u0011QFA\u0018\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0003\u0002(\u0005%\u0002\u0002CA\u001a\u0003\u0007\u0001\r!!\u000e\u0002\u000f\u0011\fG/Y:fiB\"\u0011qGA\"!\u0019\tI$a\u000f\u0002@5\u0011\u0011\u0011F\u0005\u0005\u0003{\tICA\u0004ECR\f7/\u001a;\u0011\t\u0005\u0005\u00131\t\u0007\u0001\t1\t)%!\r\u0002\u0002\u0003\u0005)\u0011AA$\u0005\ryFEM\t\u0005\u0003\u0013\ny\u0005E\u0002-\u0003\u0017J1!!\u0014.\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001LA)\u0013\r\t\u0019&\f\u0002\u0004\u0003:L\bbBA,\u0001\u0011E\u0013\u0011L\u0001\u000baJ,G-[2u%\u0006<Hc\u0001\n\u0002\\!9\u0011QLA+\u0001\u0004\u0011\u0012\u0001\u00034fCR,(/Z:\t\u000f\u0005\u0005\u0004\u0001\"\u0015\u0002d\u00051\"/Y<3aJ|'-\u00192jY&$\u00180\u00138QY\u0006\u001cW\rF\u0002\u0013\u0003KBq!a\u001a\u0002`\u0001\u0007!#A\u0007sC^\u0004&/\u001a3jGRLwN\u001c\u0005\b\u0003W\u0002A\u0011IA7\u0003\u0011\u0019w\u000e]=\u0015\u0007a\ty\u0007\u0003\u0005\u0002r\u0005%\u0004\u0019AA:\u0003\u0015)\u0007\u0010\u001e:b!\u0011\t)(a\u001f\u000e\u0005\u0005]$bAA=\t\u0005)\u0001/\u0019:b[&!\u0011QPA<\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\b\u0006BA5yMDq!a!\u0001\t\u0003\n))\u0001\u0005u_N#(/\u001b8h)\u0005!\u0004\u0006BAAyMD!\"a#\u0001\u0011\u000b\u0007I\u0011AAG\u0003I1W-\u0019;ve\u0016LU\u000e]8si\u0006t7-Z:\u0016\u0003IAC!!#=\u0005\"I\u00111\u0013\u0001\t\u0002\u0003\u0006KAE\u0001\u0014M\u0016\fG/\u001e:f\u00136\u0004xN\u001d;b]\u000e,7\u000f\t\u0015\u0005\u0003#c$\t\u0003\u0005\u0002\u001a\u0002!\t\u0001BAN\u0003\u0015!xn\u00147e+\t\ti\n\u0005\u0003\u0002 \u0006-VBAAQ\u0015\u0011\t\u0019+!*\u0002\u000b5|G-\u001a7\u000b\u0007q\t9KC\u0002\u0002*\u001a\tQ!\u001c7mS\nLA!!,\u0002\"\n\t\"+\u00198e_64uN]3ti6{G-\u001a7\t\u000f\u0005E\u0006\u0001\"\u0011\u00024\u0006)qO]5uKV\u0011\u0011Q\u0017\t\u0004M\u0005]\u0016bAA]O\tAQ\nT,sSR,'\u000fK\u0003\u00020r\ni,\t\u0002\u0002@\u0006)!G\f\u0019/a!\u001a\u0001\u0001P:\b\u000f\u0005\u0015'\u0001#\u0001\u0002H\u0006y\"+\u00198e_64uN]3ti\u000ec\u0017m]:jM&\u001c\u0017\r^5p]6{G-\u001a7\u0011\u0007=\tIM\u0002\u0004\u0002\u0005!\u0005\u00111Z\n\b\u0003\u0013\fi-a5,!\ra\u0013qZ\u0005\u0004\u0003#l#AB!osJ+g\r\u0005\u0003'\u0003+D\u0012bAAlO\tQQ\n\u0014*fC\u0012\f'\r\\3\t\u000f\t\fI\r\"\u0001\u0002\\R\u0011\u0011q\u0019\u0005\t\u0003?\fI\r\"\u0011\u0002b\u0006!!/Z1e+\t\t\u0019\u000f\u0005\u0003'\u0003KD\u0012bAAtO\tAQ\n\u0014*fC\u0012,'\u000fK\u0003\u0002^r\ni\f\u0003\u0005\u0002n\u0006%G\u0011IAx\u0003\u0011aw.\u00193\u0015\u0007a\t\t\u0010C\u0004\u0002t\u0006-\b\u0019\u0001\u001b\u0002\tA\fG\u000f\u001b\u0015\u0006\u0003Wd\u0014Q\u0018\u0004\n\u0003s\fI\rAAe\u0003w\u0014QEU1oI>lgi\u001c:fgR\u001cE.Y:tS\u001aL7-\u0019;j_:lu\u000eZ3m/JLG/\u001a:\u0014\t\u0005]\u0018Q\u0017\u0005\u000b\u0003\u007f\f9P!A!\u0002\u0013A\u0012\u0001C5ogR\fgnY3\t\u000f\t\f9\u0010\"\u0001\u0003\u0004Q!!Q\u0001B\u0005!\u0011\u00119!a>\u000e\u0005\u0005%\u0007bBA\u0000\u0005\u0003\u0001\r\u0001\u0007\u0005\t\u0005\u001b\t9\u0010\"\u0015\u0003\u0010\u0005A1/\u0019<f\u00136\u0004H\u000e\u0006\u0003\u0003\u0012\t]\u0001c\u0001\u0017\u0003\u0014%\u0019!QC\u0017\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003g\u0014Y\u00011\u00015\r\u001d\u0011Y\"!3\u0005\u0005;\u0011QEU1oI>lgi\u001c:fgR\u001cE.Y:tS\u001aL7-\u0019;j_:lu\u000eZ3m%\u0016\fG-\u001a:\u0014\t\te\u00111\u001d\u0005\bE\neA\u0011\u0001B\u0011)\t\u0011\u0019\u0003\u0005\u0003\u0003\b\te\u0001B\u0003B\u0014\u00053\u0011\r\u0011\"\u0003\u0003*\u0005I1\r\\1tg:\u000bW.Z\u000b\u0003\u0005W\u0001BA!\f\u000385\u0011!q\u0006\u0006\u0005\u0005c\u0011\u0019$\u0001\u0003mC:<'B\u0001B\u001b\u0003\u0011Q\u0017M^1\n\u0007e\u0012y\u0003C\u0005\u0003<\te\u0001\u0015!\u0003\u0003,\u0005Q1\r\\1tg:\u000bW.\u001a\u0011\t\u0015\t}\"\u0011\u0004b\u0001\n\u0013\u0011I#A\u0007ue\u0016,7\t\\1tg:\u000bW.\u001a\u0005\n\u0005\u0007\u0012I\u0002)A\u0005\u0005W\ta\u0002\u001e:fK\u000ec\u0017m]:OC6,\u0007\u0005\u0003\u0005\u0002n\neA\u0011\tB$)\rA\"\u0011\n\u0005\b\u0003g\u0014)\u00051\u00015\u0011%\u0011i%!3\u0005\u0002\u0011\u0011y%A\u0004ge>lw\n\u001c3\u0015\u0017a\u0011\tF!\u0016\u0003`\t%$1\u000e\u0005\t\u0005'\u0012Y\u00051\u0001\u0002\u001e\u0006Aq\u000e\u001c3N_\u0012,G\u000e\u0003\u0005\u0003X\t-\u0003\u0019\u0001B-\u0003\u0019\u0001\u0018M]3oiB\u0019qBa\u0017\n\u0007\tu#A\u0001\fSC:$w.\u001c$pe\u0016\u001cHo\u00117bgNLg-[3s\u0011!\u0011\tGa\u0013A\u0002\t\r\u0014aE2bi\u0016<wN]5dC24U-\u0019;ve\u0016\u001c\b#B\u001b\u0003fI\u0013\u0016b\u0001B4u\t\u0019Q*\u00199\t\rq\u0013Y\u00051\u0001S\u0011!\u0001&1\nI\u0001\u0002\u0004\u0011\u0006B\u0003B8\u0003\u0013\f\n\u0011\"\u0001\u0003r\u0005\tbM]8n\u001f2$G\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\tM$f\u0001*\u0003v-\u0012!q\u000f\t\u0005\u0005s\u0012\t)\u0004\u0002\u0003|)!!Q\u0010B@\u0003%)hn\u00195fG.,GM\u0003\u0002@[%!!1\u0011B>\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0005\u000f\u000bI-!A\u0005\n\t%\u0015a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa#\u0011\t\t5\"QR\u0005\u0005\u0005\u001f\u0013yC\u0001\u0004PE*,7\r\u001e\u0015\u0006\u0003\u0013d\u0014Q\u0018\u0015\u0006\u0003\u0007d\u0014Q\u0018")
public class RandomForestClassificationModel
extends ProbabilisticClassificationModel<Vector, RandomForestClassificationModel>
implements RandomForestClassifierParams,
TreeEnsembleModel<DecisionTreeClassificationModel>,
MLWritable {
    private final String uid;
    private final DecisionTreeClassificationModel[] _trees;
    private final int numFeatures;
    private final int numClasses;
    private double[] _treeWeights;
    private Vector featureImportances;
    private final int totalNumNodes;
    private final Param<String> impurity;
    private final IntParam numTrees;
    private final DoubleParam subsamplingRate;
    private final Param<String> featureSubsetStrategy;
    private final IntParam maxDepth;
    private final IntParam maxBins;
    private final IntParam minInstancesPerNode;
    private final DoubleParam minInfoGain;
    private final IntParam maxMemoryInMB;
    private final BooleanParam cacheNodeIds;
    private final LongParam seed;
    private final IntParam checkpointInterval;
    private volatile byte bitmap$0;

    public static int fromOld$default$5() {
        return RandomForestClassificationModel$.MODULE$.fromOld$default$5();
    }

    public static RandomForestClassificationModel load(String string) {
        return RandomForestClassificationModel$.MODULE$.load(string);
    }

    public static MLReader<RandomForestClassificationModel> read() {
        return RandomForestClassificationModel$.MODULE$.read();
    }

    private double[] _treeWeights$lzycompute() {
        RandomForestClassificationModel randomForestClassificationModel = this;
        synchronized (randomForestClassificationModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this._treeWeights = (double[])Array$.MODULE$.fill(this._trees().length, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return 1.0;
                    }
                }, ClassTag$.MODULE$.Double());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this._treeWeights;
        }
    }

    private Vector featureImportances$lzycompute() {
        RandomForestClassificationModel randomForestClassificationModel = this;
        synchronized (randomForestClassificationModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.featureImportances = TreeEnsembleModel$.MODULE$.featureImportances(this.trees(), this.numFeatures());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.featureImportances;
        }
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    private int totalNumNodes$lzycompute() {
        RandomForestClassificationModel randomForestClassificationModel = this;
        synchronized (randomForestClassificationModel) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.totalNumNodes = TreeEnsembleModel$class.totalNumNodes(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.totalNumNodes;
        }
    }

    @Override
    public int totalNumNodes() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.totalNumNodes$lzycompute() : this.totalNumNodes;
    }

    @Override
    public Vector javaTreeWeights() {
        return TreeEnsembleModel$class.javaTreeWeights(this);
    }

    @Override
    public String toDebugString() {
        return TreeEnsembleModel$class.toDebugString(this);
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeClassifierParams$_setter_$impurity_$eq(Param x$1) {
        this.impurity = x$1;
    }

    @Override
    public TreeClassifierParams setImpurity(String value) {
        return TreeClassifierParams$class.setImpurity(this, value);
    }

    @Override
    public final String getImpurity() {
        return TreeClassifierParams$class.getImpurity(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return TreeClassifierParams$class.getOldImpurity(this);
    }

    @Override
    public final IntParam numTrees() {
        return this.numTrees;
    }

    @Override
    public final void org$apache$spark$ml$tree$RandomForestParams$_setter_$numTrees_$eq(IntParam x$1) {
        this.numTrees = x$1;
    }

    @Override
    public RandomForestParams setNumTrees(int value) {
        return RandomForestParams$class.setNumTrees(this, value);
    }

    @Override
    public final int getNumTrees() {
        return RandomForestParams$class.getNumTrees(this);
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public final Param<String> featureSubsetStrategy() {
        return this.featureSubsetStrategy;
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$featureSubsetStrategy_$eq(Param x$1) {
        this.featureSubsetStrategy = x$1;
    }

    @Override
    public TreeEnsembleParams setSubsamplingRate(double value) {
        return TreeEnsembleParams$class.setSubsamplingRate(this, value);
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams$class.getSubsamplingRate(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public TreeEnsembleParams setFeatureSubsetStrategy(String value) {
        return TreeEnsembleParams$class.setFeatureSubsetStrategy(this, value);
    }

    @Override
    public final String getFeatureSubsetStrategy() {
        return TreeEnsembleParams$class.getFeatureSubsetStrategy(this);
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public DecisionTreeParams setMaxDepth(int value) {
        return DecisionTreeParams$class.setMaxDepth(this, value);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams$class.getMaxDepth(this);
    }

    @Override
    public DecisionTreeParams setMaxBins(int value) {
        return DecisionTreeParams$class.setMaxBins(this, value);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams$class.getMaxBins(this);
    }

    @Override
    public DecisionTreeParams setMinInstancesPerNode(int value) {
        return DecisionTreeParams$class.setMinInstancesPerNode(this, value);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams$class.getMinInstancesPerNode(this);
    }

    @Override
    public DecisionTreeParams setMinInfoGain(double value) {
        return DecisionTreeParams$class.setMinInfoGain(this, value);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams$class.getMinInfoGain(this);
    }

    @Override
    public DecisionTreeParams setSeed(long value) {
        return DecisionTreeParams$class.setSeed(this, value);
    }

    @Override
    public DecisionTreeParams setMaxMemoryInMB(int value) {
        return DecisionTreeParams$class.setMaxMemoryInMB(this, value);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams$class.getMaxMemoryInMB(this);
    }

    @Override
    public DecisionTreeParams setCacheNodeIds(boolean value) {
        return DecisionTreeParams$class.setCacheNodeIds(this, value);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams$class.getCacheNodeIds(this);
    }

    @Override
    public DecisionTreeParams setCheckpointInterval(int value) {
        return DecisionTreeParams$class.setCheckpointInterval(this, value);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final long getSeed() {
        return HasSeed$class.getSeed(this);
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval$class.getCheckpointInterval(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    private DecisionTreeClassificationModel[] _trees() {
        return this._trees;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    public DecisionTreeClassificationModel[] trees() {
        return this._trees();
    }

    private double[] _treeWeights() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this._treeWeights$lzycompute() : this._treeWeights;
    }

    @Override
    public double[] treeWeights() {
        return this._treeWeights();
    }

    @Override
    public Dataset<Row> transformImpl(Dataset<?> dataset) {
        Broadcast bcastModel = dataset.sparkSession().sparkContext().broadcast((Object)this, ClassTag$.MODULE$.apply(RandomForestClassificationModel.class));
        UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1)new Serializable(this, bcastModel){
            public static final long serialVersionUID = 0L;
            private final Broadcast bcastModel$1;

            public final double apply(Object features) {
                return ((ClassificationModel)this.bcastModel$1.value()).predict((Vector)features);
            }
            {
                this.bcastModel$1 = bcastModel$1;
            }
        }, ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Any());
        return dataset.withColumn(this.$(this.predictionCol()), predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})));
    }

    @Override
    public Vector predictRaw(Vector features) {
        double[] votes = (double[])Array$.MODULE$.fill(this.numClasses(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 0.0;
            }
        }, ClassTag$.MODULE$.Double());
        Predef$.MODULE$.refArrayOps((Object[])this._trees()).view().foreach((Function1)new Serializable(this, features, votes){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestClassificationModel $outer;
            private final Vector features$1;
            private final double[] votes$1;

            public final void apply(DecisionTreeClassificationModel tree) {
                double[] classCounts = tree.rootNode().predictImpl(this.features$1).impurityStats().stats();
                double total = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(classCounts).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                if (total != 0.0) {
                    for (int i = 0; i < this.$outer.numClasses(); ++i) {
                        int n = i;
                        this.votes$1[n] = this.votes$1[n] + classCounts[i] / total;
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.features$1 = features$1;
                this.votes$1 = votes$1;
            }
        });
        return Vectors$.MODULE$.dense(votes);
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            ProbabilisticClassificationModel$.MODULE$.normalizeToProbabilitiesInPlace(denseVector);
            DenseVector denseVector2 = denseVector;
            return denseVector2;
        }
        if (vector instanceof SparseVector) {
            throw new RuntimeException("Unexpected error in RandomForestClassificationModel: raw2probabilityInPlace encountered SparseVector");
        }
        throw new MatchError((Object)vector);
    }

    @Override
    public RandomForestClassificationModel copy(ParamMap extra) {
        return (RandomForestClassificationModel)((Model)this.copyValues(new RandomForestClassificationModel(this.uid(), this._trees(), this.numFeatures(), this.numClasses()), extra)).setParent(this.parent());
    }

    @Override
    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RandomForestClassificationModel (uid=", ") with ", " trees"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.uid(), BoxesRunTime.boxToInteger((int)this.getNumTrees())}));
    }

    public Vector featureImportances() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.featureImportances$lzycompute() : this.featureImportances;
    }

    public RandomForestModel toOld() {
        return new RandomForestModel(Algo$.MODULE$.Classification(), (DecisionTreeModel[])Predef$.MODULE$.refArrayOps((Object[])this._trees()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DecisionTreeModel apply(DecisionTreeClassificationModel x$2) {
                return x$2.toOld();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class))));
    }

    @Override
    public MLWriter write() {
        return new RandomForestClassificationModelWriter(this);
    }

    public RandomForestClassificationModel(String uid, DecisionTreeClassificationModel[] _trees, int numFeatures, int numClasses) {
        this.uid = uid;
        this._trees = _trees;
        this.numFeatures = numFeatures;
        this.numClasses = numClasses;
        HasCheckpointInterval$class.$init$(this);
        HasSeed$class.$init$(this);
        DecisionTreeParams$class.$init$(this);
        TreeEnsembleParams$class.$init$(this);
        RandomForestParams$class.$init$(this);
        TreeClassifierParams$class.$init$(this);
        TreeEnsembleModel$class.$init$(this);
        MLWritable$class.$init$(this);
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])_trees).nonEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "RandomForestClassificationModel requires at least 1 tree.";
            }
        });
    }

    public RandomForestClassificationModel(DecisionTreeClassificationModel[] trees, int numFeatures, int numClasses) {
        this(Identifiable$.MODULE$.randomUID("rfc"), trees, numFeatures, numClasses);
    }

    public static class RandomForestClassificationModelWriter
    extends MLWriter {
        private final RandomForestClassificationModel instance;

        @Override
        public void saveImpl(String path) {
            JsonAST.JObject extraMetadata = JsonDSL$.MODULE$.map2jvalue((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numFeatures"), (Object)BoxesRunTime.boxToInteger((int)this.instance.numFeatures())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numClasses"), (Object)BoxesRunTime.boxToInteger((int)this.instance.numClasses())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numTrees"), (Object)BoxesRunTime.boxToInteger((int)this.instance.getNumTrees()))})), (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final JsonAST.JValue apply(int x) {
                    return JsonDSL$.MODULE$.int2jvalue(x);
                }
            });
            EnsembleModelReadWrite$.MODULE$.saveImpl(this.instance, path, this.sparkSession(), extraMetadata);
        }

        public RandomForestClassificationModelWriter(RandomForestClassificationModel instance) {
            this.instance = instance;
        }
    }

    public static class RandomForestClassificationModelReader
    extends MLReader<RandomForestClassificationModel> {
        private final String className = RandomForestClassificationModel.class.getName();
        private final String treeClassName = DecisionTreeClassificationModel.class.getName();

        private String className() {
            return this.className;
        }

        private String treeClassName() {
            return this.treeClassName;
        }

        @Override
        public RandomForestClassificationModel load(String path) {
            DefaultFormats$ format2 = DefaultFormats$.MODULE$;
            Tuple3<DefaultParamsReader.Metadata, Tuple2<DefaultParamsReader.Metadata, Node>[], double[]> tuple3 = EnsembleModelReadWrite$.MODULE$.loadImpl(path, this.sparkSession(), this.className(), this.treeClassName());
            if (tuple3 != null) {
                DefaultParamsReader.Metadata metadata = (DefaultParamsReader.Metadata)tuple3._1();
                Tuple2[] treesData = (Tuple2[])tuple3._2();
                if (metadata != null) {
                    DefaultParamsReader.Metadata metadata2 = metadata;
                    if (treesData != null) {
                        DecisionTreeClassificationModel[] trees;
                        Tuple2 tuple2;
                        Tuple2[] tuple2Array = treesData;
                        Tuple2 tuple22 = tuple2 = new Tuple2((Object)metadata2, (Object)tuple2Array);
                        DefaultParamsReader.Metadata metadata3 = (DefaultParamsReader.Metadata)tuple22._1();
                        Tuple2[] treesData2 = (Tuple2[])tuple22._2();
                        int numFeatures = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numFeatures")).extract((Formats)format2, (Manifest)ManifestFactory$.MODULE$.Int()));
                        int numClasses = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numClasses")).extract((Formats)format2, (Manifest)ManifestFactory$.MODULE$.Int()));
                        int numTrees = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numTrees")).extract((Formats)format2, (Manifest)ManifestFactory$.MODULE$.Int()));
                        Predef$.MODULE$.require(numTrees == (trees = (DecisionTreeClassificationModel[])Predef$.MODULE$.refArrayOps((Object[])treesData2).map((Function1)new Serializable(this, numFeatures, numClasses){
                            public static final long serialVersionUID = 0L;
                            private final int numFeatures$1;
                            private final int numClasses$2;

                            public final DecisionTreeClassificationModel apply(Tuple2<DefaultParamsReader.Metadata, Node> x0$1) {
                                Tuple2<DefaultParamsReader.Metadata, Node> tuple2 = x0$1;
                                if (tuple2 != null) {
                                    DefaultParamsReader.Metadata treeMetadata = (DefaultParamsReader.Metadata)tuple2._1();
                                    Node root = (Node)tuple2._2();
                                    DecisionTreeClassificationModel tree = new DecisionTreeClassificationModel(treeMetadata.uid(), root, this.numFeatures$1, this.numClasses$2);
                                    treeMetadata.getAndSetParams(tree, treeMetadata.getAndSetParams$default$2());
                                    DecisionTreeClassificationModel decisionTreeClassificationModel = tree;
                                    return decisionTreeClassificationModel;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.numFeatures$1 = numFeatures$1;
                                this.numClasses$2 = numClasses$2;
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeClassificationModel.class)))).length, (Function0)new Serializable(this, numTrees, trees){
                            public static final long serialVersionUID = 0L;
                            private final int numTrees$1;
                            private final DecisionTreeClassificationModel[] trees$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RandomForestClassificationModel.load expected ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numTrees$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" trees based on metadata but found ", " trees."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.trees$1.length)}))).toString();
                            }
                            {
                                this.numTrees$1 = numTrees$1;
                                this.trees$1 = trees$1;
                            }
                        });
                        RandomForestClassificationModel model = new RandomForestClassificationModel(metadata3.uid(), trees, numFeatures, numClasses);
                        metadata3.getAndSetParams(model, metadata3.getAndSetParams$default$2());
                        return model;
                    }
                }
            }
            throw new MatchError(tuple3);
        }
    }
}

