/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim;

import org.apache.spark.internal.Logging;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.feature.OffsetInstance;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.optim.IterativelyReweightedLeastSquaresModel;
import org.apache.spark.ml.optim.WeightedLeastSquares;
import org.apache.spark.ml.optim.WeightedLeastSquares$;
import org.apache.spark.ml.optim.WeightedLeastSquaresModel;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001-4Q!\u0001\u0002\u0001\t1\u0011\u0011%\u0013;fe\u0006$\u0018N^3msJ+w/Z5hQR,G\rT3bgR\u001c\u0016/^1sKNT!a\u0001\u0003\u0002\u000b=\u0004H/[7\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0003\u0002\u0001\u000e'e\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007C\u0001\u000b\u0018\u001b\u0005)\"B\u0001\f\u0007\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\r\u0016\u0005\u001daunZ4j]\u001e\u0004\"A\u0004\u000e\n\u0005my!\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002C\u000f\u0001\u0005\u000b\u0007I\u0011A\u0010\u0002\u0019%t\u0017\u000e^5bY6{G-\u001a7\u0004\u0001U\t\u0001\u0005\u0005\u0002\"E5\t!!\u0003\u0002$\u0005\tIr+Z5hQR,G\rT3bgR\u001c\u0016/^1sKNlu\u000eZ3m\u0011!)\u0003A!A!\u0002\u0013\u0001\u0013!D5oSRL\u0017\r\\'pI\u0016d\u0007\u0005\u0003\u0005(\u0001\t\u0015\r\u0011\"\u0001)\u00031\u0011Xm^3jO\"$h)\u001e8d+\u0005I\u0003#\u0002\b+Y\u0001\u0012\u0014BA\u0016\u0010\u0005%1UO\\2uS>t'\u0007\u0005\u0002.a5\taF\u0003\u00020\t\u00059a-Z1ukJ,\u0017BA\u0019/\u00059yeMZ:fi&s7\u000f^1oG\u0016\u0004BAD\u001a6k%\u0011Ag\u0004\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u000591\u0014BA\u001c\u0010\u0005\u0019!u.\u001e2mK\"A\u0011\b\u0001B\u0001B\u0003%\u0011&A\u0007sK^,\u0017n\u001a5u\rVt7\r\t\u0005\tw\u0001\u0011)\u0019!C\u0001y\u0005aa-\u001b;J]R,'oY3qiV\tQ\b\u0005\u0002\u000f}%\u0011qh\u0004\u0002\b\u0005>|G.Z1o\u0011!\t\u0005A!A!\u0002\u0013i\u0014!\u00044ji&sG/\u001a:dKB$\b\u0005\u0003\u0005D\u0001\t\u0015\r\u0011\"\u0001E\u0003!\u0011Xm\u001a)be\u0006lW#A\u001b\t\u0011\u0019\u0003!\u0011!Q\u0001\nU\n\u0011B]3h!\u0006\u0014\u0018-\u001c\u0011\t\u0011!\u0003!Q1A\u0005\u0002%\u000bq!\\1y\u0013R,'/F\u0001K!\tq1*\u0003\u0002M\u001f\t\u0019\u0011J\u001c;\t\u00119\u0003!\u0011!Q\u0001\n)\u000b\u0001\"\\1y\u0013R,'\u000f\t\u0005\t!\u0002\u0011)\u0019!C\u0001\t\u0006\u0019Ao\u001c7\t\u0011I\u0003!\u0011!Q\u0001\nU\nA\u0001^8mA!)A\u000b\u0001C\u0001+\u00061A(\u001b8jiz\"rAV,Y3j[F\f\u0005\u0002\"\u0001!)Qd\u0015a\u0001A!)qe\u0015a\u0001S!)1h\u0015a\u0001{!)1i\u0015a\u0001k!)\u0001j\u0015a\u0001\u0015\")\u0001k\u0015a\u0001k!)a\f\u0001C\u0001?\u0006\u0019a-\u001b;\u0015\u0005\u0001\u001c\u0007CA\u0011b\u0013\t\u0011'A\u0001\u0014Ji\u0016\u0014\u0018\r^5wK2L(+Z<fS\u001eDG/\u001a3MK\u0006\u001cHoU9vCJ,7/T8eK2DQ\u0001Z/A\u0002\u0015\f\u0011\"\u001b8ti\u0006t7-Z:\u0011\u0007\u0019LG&D\u0001h\u0015\tAg!A\u0002sI\u0012L!A[4\u0003\u0007I#E\t")
public class IterativelyReweightedLeastSquares
implements Logging,
Serializable {
    private final WeightedLeastSquaresModel initialModel;
    private final Function2<OffsetInstance, WeightedLeastSquaresModel, Tuple2<Object, Object>> reweightFunc;
    private final boolean fitIntercept;
    private final double regParam;
    private final int maxIter;
    private final double tol;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public WeightedLeastSquaresModel initialModel() {
        return this.initialModel;
    }

    public Function2<OffsetInstance, WeightedLeastSquaresModel, Tuple2<Object, Object>> reweightFunc() {
        return this.reweightFunc;
    }

    public boolean fitIntercept() {
        return this.fitIntercept;
    }

    public double regParam() {
        return this.regParam;
    }

    public int maxIter() {
        return this.maxIter;
    }

    public double tol() {
        return this.tol;
    }

    public IterativelyReweightedLeastSquaresModel fit(RDD<OffsetInstance> instances) {
        boolean converged = false;
        IntRef iter = IntRef.create((int)0);
        WeightedLeastSquaresModel model = this.initialModel();
        ObjectRef oldModel = ObjectRef.create(null);
        while (iter.elem < this.maxIter() && !converged) {
            oldModel.elem = model;
            RDD newInstances = instances.map((Function1)new Serializable(this, oldModel){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ IterativelyReweightedLeastSquares $outer;
                private final ObjectRef oldModel$1;

                public final Instance apply(OffsetInstance instance) {
                    Tuple2 tuple2 = (Tuple2)this.$outer.reweightFunc().apply((Object)instance, (Object)((WeightedLeastSquaresModel)this.oldModel$1.elem));
                    if (tuple2 != null) {
                        Tuple2.mcDD.sp sp2;
                        double newLabel = tuple2._1$mcD$sp();
                        double newWeight = tuple2._2$mcD$sp();
                        Tuple2.mcDD.sp sp3 = sp2 = new Tuple2.mcDD.sp(newLabel, newWeight);
                        double newLabel2 = sp3._1$mcD$sp();
                        double newWeight2 = sp3._2$mcD$sp();
                        return new Instance(newLabel2, newWeight2, instance.features());
                    }
                    throw new MatchError((Object)tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.oldModel$1 = oldModel$1;
                }
            }, ClassTag$.MODULE$.apply(Instance.class));
            model = new WeightedLeastSquares(this.fitIntercept(), this.regParam(), 0.0, false, false, WeightedLeastSquares$.MODULE$.$lessinit$greater$default$6(), WeightedLeastSquares$.MODULE$.$lessinit$greater$default$7(), WeightedLeastSquares$.MODULE$.$lessinit$greater$default$8()).fit((RDD<Instance>)newInstances);
            DenseVector oldCoefficients = ((WeightedLeastSquaresModel)oldModel.elem).coefficients();
            DenseVector coefficients2 = model.coefficients();
            BLAS$.MODULE$.axpy(-1.0, (Vector)coefficients2, (Vector)oldCoefficients);
            double maxTolOfCoefficients = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(oldCoefficients.toArray()).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(double x, double y) {
                    return this.apply$mcDDD$sp(x, y);
                }

                public double apply$mcDDD$sp(double x, double y) {
                    return package$.MODULE$.max(package$.MODULE$.abs(x), package$.MODULE$.abs(y));
                }
            }));
            double maxTol = package$.MODULE$.max(maxTolOfCoefficients, package$.MODULE$.abs(((WeightedLeastSquaresModel)oldModel.elem).intercept() - model.intercept()));
            if (maxTol < this.tol()) {
                converged = true;
                this.logInfo((Function0<String>)new Serializable(this, iter){
                    public static final long serialVersionUID = 0L;
                    private final IntRef iter$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IRLS converged in ", " iterations."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.iter$1.elem)}));
                    }
                    {
                        this.iter$1 = iter$1;
                    }
                });
            }
            this.logInfo((Function0<String>)new Serializable(this, iter, maxTol){
                public static final long serialVersionUID = 0L;
                private final IntRef iter$1;
                private final double maxTol$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Iteration ", " : relative tolerance = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.iter$1.elem), BoxesRunTime.boxToDouble((double)this.maxTol$1)}));
                }
                {
                    this.iter$1 = iter$1;
                    this.maxTol$1 = maxTol$1;
                }
            });
            ++iter.elem;
            if (iter.elem != this.maxIter()) continue;
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ IterativelyReweightedLeastSquares $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IRLS reached the max number of iterations: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.maxIter())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        return new IterativelyReweightedLeastSquaresModel(model.coefficients(), model.intercept(), model.diagInvAtWA(), iter.elem);
    }

    public IterativelyReweightedLeastSquares(WeightedLeastSquaresModel initialModel, Function2<OffsetInstance, WeightedLeastSquaresModel, Tuple2<Object, Object>> reweightFunc, boolean fitIntercept, double regParam, int maxIter, double tol) {
        this.initialModel = initialModel;
        this.reweightFunc = reweightFunc;
        this.fitIntercept = fitIntercept;
        this.regParam = regParam;
        this.maxIter = maxIter;
        this.tol = tol;
        Logging.class.$init$((Logging)this);
    }
}

