/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.util.Locale;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.regression.GeneralizedLinearRegression$;
import org.apache.spark.ml.regression.GeneralizedLinearRegression$Family$;
import org.apache.spark.ml.regression.GeneralizedLinearRegression$Link$;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionBase;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public abstract class GeneralizedLinearRegressionBase$class {
    public static String getFamily(GeneralizedLinearRegressionBase $this) {
        return $this.$($this.family());
    }

    public static double getVariancePower(GeneralizedLinearRegressionBase $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$($this.variancePower()));
    }

    public static String getLink(GeneralizedLinearRegressionBase $this) {
        return $this.$($this.link());
    }

    public static double getLinkPower(GeneralizedLinearRegressionBase $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$($this.linkPower()));
    }

    public static String getLinkPredictionCol(GeneralizedLinearRegressionBase $this) {
        return $this.$($this.linkPredictionCol());
    }

    public static boolean hasLinkPredictionCol(GeneralizedLinearRegressionBase $this) {
        return $this.isDefined($this.linkPredictionCol()) && new StringOps(Predef$.MODULE$.augmentString($this.$($this.linkPredictionCol()))).nonEmpty();
    }

    public static StructType validateAndTransformSchema(GeneralizedLinearRegressionBase $this, StructType schema, boolean fitting, DataType featuresDataType) {
        String string = $this.$($this.family()).toLowerCase(Locale.ROOT);
        String string2 = "tweedie";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            if ($this.isSet($this.link())) {
                $this.logWarning((Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "When family is tweedie, use param linkPower to specify link function. Setting param link will take no effect.";
                    }
                });
            }
        } else {
            if ($this.isSet($this.variancePower())) {
                $this.logWarning((Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "When family is not tweedie, setting param variancePower will take no effect.";
                    }
                });
            }
            if ($this.isSet($this.linkPower())) {
                $this.logWarning((Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "When family is not tweedie, use param link to specify link function. Setting param linkPower will take no effect.";
                    }
                });
            }
            if ($this.isSet($this.link())) {
                Predef$.MODULE$.require(GeneralizedLinearRegression$.MODULE$.supportedFamilyAndLinkPairs().contains((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)GeneralizedLinearRegression$Family$.MODULE$.fromParams($this)), (Object)GeneralizedLinearRegression$Link$.MODULE$.fromParams($this))), (Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ GeneralizedLinearRegressionBase $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Generalized Linear Regression with ", " family "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.$(this.$outer.family())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"does not support ", " link function."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.$(this.$outer.link())}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
        }
        StructType newSchema = $this.org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$$super$validateAndTransformSchema(schema, fitting, featuresDataType);
        return $this.hasLinkPredictionCol() ? SchemaUtils$.MODULE$.appendColumn(newSchema, $this.$($this.linkPredictionCol()), (DataType)DoubleType$.MODULE$, SchemaUtils$.MODULE$.appendColumn$default$4()) : newSchema;
    }

    public static void $init$(GeneralizedLinearRegressionBase $this) {
        $this.org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$family_$eq(new Param($this, "family", new StringBuilder().append((Object)"The name of family which is a description of the error distribution to be used in the ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"model. Supported options: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])GeneralizedLinearRegression$.MODULE$.supportedFamilyNames()).mkString(", ")}))).toString(), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String value) {
                return Predef$.MODULE$.refArrayOps((Object[])GeneralizedLinearRegression$.MODULE$.supportedFamilyNames()).contains((Object)value.toLowerCase(Locale.ROOT));
            }
        }));
        $this.org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$variancePower_$eq(new DoubleParam((Identifiable)$this, "variancePower", "The power in the variance function of the Tweedie distribution which characterizes the relationship between the variance and mean of the distribution. Only applicable to the Tweedie family. Supported values: 0 and [1, Inf).", (Function1<Object, Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(double x) {
                return this.apply$mcZD$sp(x);
            }

            public boolean apply$mcZD$sp(double x) {
                return x >= 1.0 || x == 0.0;
            }
        }));
        $this.org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$link_$eq(new Param($this, "link", new StringBuilder().append((Object)"The name of link function which provides the relationship between the linear predictor and the mean of the ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"distribution function. Supported options: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])GeneralizedLinearRegression$.MODULE$.supportedLinkNames()).mkString(", ")}))).toString(), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String value) {
                return Predef$.MODULE$.refArrayOps((Object[])GeneralizedLinearRegression$.MODULE$.supportedLinkNames()).contains((Object)value.toLowerCase(Locale.ROOT));
            }
        }));
        $this.org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$linkPower_$eq(new DoubleParam($this, "linkPower", "The index in the power link function. Only applicable to the Tweedie family."));
        $this.org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$linkPredictionCol_$eq(new Param($this, "linkPredictionCol", "link prediction (linear predictor) column name"));
    }
}

