/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree.model;

import com.github.fommil.netlib.BLAS;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.EnsembleCombiningStrategy$;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.TreeEnsembleModel$;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.mutable.IndexedSeqView$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r]d!B\u0001\u0003!\u0011q!!\u0005+sK\u0016,en]3nE2,Wj\u001c3fY*\u00111\u0001B\u0001\u0006[>$W\r\u001c\u0006\u0003\u000b\u0019\tA\u0001\u001e:fK*\u0011q\u0001C\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sON\u0019\u0001aD\u000b\u0011\u0005A\u0019R\"A\t\u000b\u0003I\tQa]2bY\u0006L!\u0001F\t\u0003\r\u0005s\u0017PU3g!\t\u0001b#\u0003\u0002\u0018#\ta1+\u001a:jC2L'0\u00192mK\"A\u0011\u0004\u0001BC\u0002\u0013E1$\u0001\u0003bY\u001e|7\u0001A\u000b\u00029A\u0011Q$\r\b\u0003=9r!a\b\u0017\u000f\u0005\u0001ZcBA\u0011+\u001d\t\u0011\u0013F\u0004\u0002$Q9\u0011AeJ\u0007\u0002K)\u0011aEG\u0001\u0007yI|w\u000e\u001e \n\u00035I!a\u0003\u0007\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\u0003\u0002.\t\u0005i1m\u001c8gS\u001e,(/\u0019;j_:L!a\f\u0019\u0002\t\u0005cwm\u001c\u0006\u0003[\u0011I!AM\u001a\u0003\t\u0005cwm\u001c\u0006\u0003_AB\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u0006C2<w\u000e\t\u0005\to\u0001\u0011)\u0019!C\tq\u0005)AO]3fgV\t\u0011\bE\u0002\u0011uqJ!aO\t\u0003\u000b\u0005\u0013(/Y=\u0011\u0005urT\"\u0001\u0002\n\u0005}\u0012!!\u0005#fG&\u001c\u0018n\u001c8Ue\u0016,Wj\u001c3fY\"A\u0011\t\u0001B\u0001B\u0003%\u0011(\u0001\u0004ue\u0016,7\u000f\t\u0005\t\u0007\u0002\u0011)\u0019!C\t\t\u0006YAO]3f/\u0016Lw\r\u001b;t+\u0005)\u0005c\u0001\t;\rB\u0011\u0001cR\u0005\u0003\u0011F\u0011a\u0001R8vE2,\u0007\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011B#\u0002\u0019Q\u0014X-Z,fS\u001eDGo\u001d\u0011\t\u00111\u0003!Q1A\u0005\u00125\u000b\u0011cY8nE&t\u0017N\\4TiJ\fG/Z4z+\u0005q\u0005CA(S\u001d\tq\u0002+\u0003\u0002Ra\u0005IRI\\:f[\ndWmQ8nE&t\u0017N\\4TiJ\fG/Z4z\u0013\t\u0019FKA\rF]N,WN\u00197f\u0007>l'-\u001b8j]\u001e\u001cFO]1uK\u001eL(BA)1\u0011!1\u0006A!A!\u0002\u0013q\u0015AE2p[\nLg.\u001b8h'R\u0014\u0018\r^3hs\u0002BQ\u0001\u0017\u0001\u0005\u0002e\u000ba\u0001P5oSRtD#\u0002.\\9vs\u0006CA\u001f\u0001\u0011\u0015Ir\u000b1\u0001\u001d\u0011\u00159t\u000b1\u0001:\u0011\u0015\u0019u\u000b1\u0001F\u0011\u0015au\u000b1\u0001O\u0011\u001d\u0001\u0007A1A\u0005\n\u0005\f!b];n/\u0016Lw\r\u001b;t+\u00051\u0005BB2\u0001A\u0003%a)A\u0006tk6<V-[4iiN\u0004\u0003\"B3\u0001\t\u00131\u0017\u0001\u00059sK\u0012L7\r\u001e\"z'VlW.\u001b8h)\t1u\rC\u0003iI\u0002\u0007\u0011.\u0001\u0005gK\u0006$XO]3t!\tQW.D\u0001l\u0015\tag!\u0001\u0004mS:\fGnZ\u0005\u0003].\u0014aAV3di>\u0014\b\"\u00029\u0001\t\u0013\t\u0018a\u00049sK\u0012L7\r\u001e\"z->$\u0018N\\4\u0015\u0005\u0019\u0013\b\"\u00025p\u0001\u0004I\u0007\"\u0002;\u0001\t\u0003)\u0018a\u00029sK\u0012L7\r\u001e\u000b\u0003\rZDQ\u0001[:A\u0002%DQ\u0001\u001e\u0001\u0005\u0002a$\"!_@\u0011\u0007ilh)D\u0001|\u0015\ta\b\"A\u0002sI\u0012L!A`>\u0003\u0007I#E\t\u0003\u0004io\u0002\u0007\u0011\u0011\u0001\t\u0004uvL\u0007B\u0002;\u0001\t\u0003\t)\u0001\u0006\u0003\u0002\b\u0005\r\u0002CBA\u0005\u0003'\t9\"\u0004\u0002\u0002\f)!\u0011QBA\b\u0003\u0011Q\u0017M^1\u000b\u0007\u0005E\u0001\"A\u0002ba&LA!!\u0006\u0002\f\t9!*\u0019<b%\u0012#\u0005\u0003BA\r\u0003Ci!!a\u0007\u000b\t\u0005u\u0011qD\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u000e%\u0019\u0001*a\u0007\t\u000f!\f\u0019\u00011\u0001\u0002&A)\u0011\u0011BA\nS\"9\u0011\u0011\u0006\u0001\u0005B\u0005-\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u00055\u0002\u0003BA\u0018\u0003kq1\u0001EA\u0019\u0013\r\t\u0019$E\u0001\u0007!J,G-\u001a4\n\t\u0005]\u0012\u0011\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005M\u0012\u0003C\u0004\u0002>\u0001!\t!a\u0010\u0002\u001bQ|G)\u001a2vON#(/\u001b8h+\t\ti\u0003C\u0004\u0002D\u0001!\t!!\u0012\u0002\u00119,X\u000e\u0016:fKN,\"!a\u0012\u0011\u0007A\tI%C\u0002\u0002LE\u00111!\u00138u\u0011\u001d\ty\u0005\u0001C\u0001\u0003\u000b\nQ\u0002^8uC2tU/\u001c(pI\u0016\u001c\u0018&\u0002\u0001\u0002T\u0005]\u0013bAA+\u0005\tIrI]1eS\u0016tGOQ8pgR,G\r\u0016:fKNlu\u000eZ3m\u0013\r\tIF\u0001\u0002\u0012%\u0006tGm\\7G_J,7\u000f^'pI\u0016dw\u0001CA/\u0005!\u0005A!a\u0018\u0002#Q\u0013X-Z#og\u0016l'\r\\3N_\u0012,G\u000eE\u0002>\u0003C2q!\u0001\u0002\t\u0002\u0011\t\u0019g\u0005\u0004\u0002b=\t)'\u0006\t\u0005\u0003O\ni'\u0004\u0002\u0002j)\u0019\u00111\u000e\u0005\u0002\u0011%tG/\u001a:oC2LA!a\u001c\u0002j\t9Aj\\4hS:<\u0007b\u0002-\u0002b\u0011\u0005\u00111\u000f\u000b\u0003\u0003?:\u0001\"a\u001e\u0002b!\u0005\u0011\u0011P\u0001\r'\u00064X\rT8bIZ\u000bt\f\r\t\u0005\u0003w\ni(\u0004\u0002\u0002b\u0019A\u0011qPA1\u0011\u0003\t\tI\u0001\u0007TCZ,Gj\\1e-Fz\u0006gE\u0002\u0002~=Aq\u0001WA?\t\u0003\t)\t\u0006\u0002\u0002z!A\u0011\u0011RA?\t\u0003\ty$A\tuQ&\u001chi\u001c:nCR4VM]:j_:4q!!$\u0002~\u0001\u000byI\u0001\u0005NKR\fG-\u0019;b'\u0019\tYiDAI+A\u0019\u0001#a%\n\u0007\u0005U\u0015CA\u0004Qe>$Wo\u0019;\t\u0015e\tYI!f\u0001\n\u0003\ty\u0004\u0003\u00066\u0003\u0017\u0013\t\u0012)A\u0005\u0003[A1\"!(\u0002\f\nU\r\u0011\"\u0001\u0002@\u0005AAO]3f\u00032<w\u000eC\u0006\u0002\"\u0006-%\u0011#Q\u0001\n\u00055\u0012!\u0003;sK\u0016\fEnZ8!\u0011)a\u00151\u0012BK\u0002\u0013\u0005\u0011q\b\u0005\u000b-\u0006-%\u0011#Q\u0001\n\u00055\u0002\"C\"\u0002\f\nU\r\u0011\"\u0001E\u0011%Q\u00151\u0012B\tB\u0003%Q\tC\u0004Y\u0003\u0017#\t!!,\u0015\u0015\u0005=\u00161WA[\u0003o\u000bI\f\u0005\u0003\u00022\u0006-UBAA?\u0011\u001dI\u00121\u0016a\u0001\u0003[A\u0001\"!(\u0002,\u0002\u0007\u0011Q\u0006\u0005\b\u0019\u0006-\u0006\u0019AA\u0017\u0011\u0019\u0019\u00151\u0016a\u0001\u000b\"Q\u0011QXAF\u0003\u0003%\t!a0\u0002\t\r|\u0007/\u001f\u000b\u000b\u0003_\u000b\t-a1\u0002F\u0006\u001d\u0007\"C\r\u0002<B\u0005\t\u0019AA\u0017\u0011)\ti*a/\u0011\u0002\u0003\u0007\u0011Q\u0006\u0005\n\u0019\u0006m\u0006\u0013!a\u0001\u0003[A\u0001bQA^!\u0003\u0005\r!\u0012\u0005\u000b\u0003\u0017\fY)%A\u0005\u0002\u00055\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u001fTC!!\f\u0002R.\u0012\u00111\u001b\t\u0005\u0003+\fy.\u0004\u0002\u0002X*!\u0011\u0011\\An\u0003%)hn\u00195fG.,GMC\u0002\u0002^F\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\t/a6\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0003\u0006\u0002f\u0006-\u0015\u0013!C\u0001\u0003\u001b\fabY8qs\u0012\"WMZ1vYR$#\u0007\u0003\u0006\u0002j\u0006-\u0015\u0013!C\u0001\u0003\u001b\fabY8qs\u0012\"WMZ1vYR$3\u0007\u0003\u0006\u0002n\u0006-\u0015\u0013!C\u0001\u0003_\fabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0002r*\u001aQ)!5\t\u0015\u0005U\u00181RA\u0001\n\u0003\n90A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003s\u0004B!!\u0007\u0002|&!\u0011qGA\u000e\u0011)\ty0a#\u0002\u0002\u0013\u0005\u0011QI\u0001\raJ|G-^2u\u0003JLG/\u001f\u0005\u000b\u0005\u0007\tY)!A\u0005\u0002\t\u0015\u0011A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005\u000f\u0011i\u0001E\u0002\u0011\u0005\u0013I1Aa\u0003\u0012\u0005\r\te.\u001f\u0005\u000b\u0005\u001f\u0011\t!!AA\u0002\u0005\u001d\u0013a\u0001=%c!Q!1CAF\u0003\u0003%\tE!\u0006\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u0006\u0011\r\te!q\u0004B\u0004\u001b\t\u0011YBC\u0002\u0003\u001eE\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011\tCa\u0007\u0003\u0011%#XM]1u_JD!B!\n\u0002\f\u0006\u0005I\u0011\u0001B\u0014\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B\u0015\u0005_\u00012\u0001\u0005B\u0016\u0013\r\u0011i#\u0005\u0002\b\u0005>|G.Z1o\u0011)\u0011yAa\t\u0002\u0002\u0003\u0007!q\u0001\u0005\u000b\u0005g\tY)!A\u0005B\tU\u0012\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005\u001d\u0003BCA\u0015\u0003\u0017\u000b\t\u0011\"\u0011\u0003:Q\u0011\u0011\u0011 \u0005\u000b\u0005{\tY)!A\u0005B\t}\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0003*\t\u0005\u0003B\u0003B\b\u0005w\t\t\u00111\u0001\u0003\b\u001dQ!QIA?\u0003\u0003E\tAa\u0012\u0002\u00115+G/\u00193bi\u0006\u0004B!!-\u0003J\u0019Q\u0011QRA?\u0003\u0003E\tAa\u0013\u0014\u000b\t%#QJ\u000b\u0011\u001b\t=#QKA\u0017\u0003[\ti#RAX\u001b\t\u0011\tFC\u0002\u0003TE\tqA];oi&lW-\u0003\u0003\u0003X\tE#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oi!9\u0001L!\u0013\u0005\u0002\tmCC\u0001B$\u0011)\tIC!\u0013\u0002\u0002\u0013\u0015#\u0011\b\u0005\u000b\u0005C\u0012I%!A\u0005\u0002\n\r\u0014!B1qa2LHCCAX\u0005K\u00129G!\u001b\u0003l!9\u0011Da\u0018A\u0002\u00055\u0002\u0002CAO\u0005?\u0002\r!!\f\t\u000f1\u0013y\u00061\u0001\u0002.!11Ia\u0018A\u0002\u0015C!Ba\u001c\u0003J\u0005\u0005I\u0011\u0011B9\u0003\u001d)h.\u00199qYf$BAa\u001d\u0003\u0000A)\u0001C!\u001e\u0003z%\u0019!qO\t\u0003\r=\u0003H/[8o!)\u0001\"1PA\u0017\u0003[\ti#R\u0005\u0004\u0005{\n\"A\u0002+va2,G\u0007\u0003\u0006\u0003\u0002\n5\u0014\u0011!a\u0001\u0003_\u000b1\u0001\u001f\u00131\u0011)\u0011)I!\u0013\u0002\u0002\u0013%!qQ\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003\nB!\u0011\u0011\u0004BF\u0013\u0011\u0011i)a\u0007\u0003\r=\u0013'.Z2u\r\u001d\u0011\t*! A\u0005'\u0013\u0001#\u00128tK6\u0014G.\u001a(pI\u0016$\u0015\r^1\u0014\r\t=u\"!%\u0016\u0011-\u00119Ja$\u0003\u0016\u0004%\t!!\u0012\u0002\rQ\u0014X-Z%e\u0011-\u0011YJa$\u0003\u0012\u0003\u0006I!a\u0012\u0002\u000fQ\u0014X-Z%eA!Y!q\u0014BH\u0005+\u0007I\u0011\u0001BQ\u0003\u0011qw\u000eZ3\u0016\u0005\t\r\u0006\u0003\u0002BS\u0005ksAAa*\u00032:!!\u0011\u0016BW\u001d\ry\"1V\u0005\u0003\u0007\u0011I1Aa,\u0003\u0003E!UmY5tS>tGK]3f\u001b>$W\r\\\u0005\u0005\u0003o\u0012\u0019LC\u0002\u00030\nIAAa.\u0003:\nAaj\u001c3f\t\u0006$\u0018M\u0003\u0003\u0002x\tM\u0006b\u0003B_\u0005\u001f\u0013\t\u0012)A\u0005\u0005G\u000bQA\\8eK\u0002Bq\u0001\u0017BH\t\u0003\u0011\t\r\u0006\u0004\u0003D\n\u0015'q\u0019\t\u0005\u0003c\u0013y\t\u0003\u0005\u0003\u0018\n}\u0006\u0019AA$\u0011!\u0011yJa0A\u0002\t\r\u0006BCA_\u0005\u001f\u000b\t\u0011\"\u0001\u0003LR1!1\u0019Bg\u0005\u001fD!Ba&\u0003JB\u0005\t\u0019AA$\u0011)\u0011yJ!3\u0011\u0002\u0003\u0007!1\u0015\u0005\u000b\u0003\u0017\u0014y)%A\u0005\u0002\tMWC\u0001BkU\u0011\t9%!5\t\u0015\u0005\u0015(qRI\u0001\n\u0003\u0011I.\u0006\u0002\u0003\\*\"!1UAi\u0011)\t)Pa$\u0002\u0002\u0013\u0005\u0013q\u001f\u0005\u000b\u0003\u007f\u0014y)!A\u0005\u0002\u0005\u0015\u0003B\u0003B\u0002\u0005\u001f\u000b\t\u0011\"\u0001\u0003dR!!q\u0001Bs\u0011)\u0011yA!9\u0002\u0002\u0003\u0007\u0011q\t\u0005\u000b\u0005'\u0011y)!A\u0005B\tU\u0001B\u0003B\u0013\u0005\u001f\u000b\t\u0011\"\u0001\u0003lR!!\u0011\u0006Bw\u0011)\u0011yA!;\u0002\u0002\u0003\u0007!q\u0001\u0005\u000b\u0005g\u0011y)!A\u0005B\tU\u0002BCA\u0015\u0005\u001f\u000b\t\u0011\"\u0011\u0003:!Q!Q\bBH\u0003\u0003%\tE!>\u0015\t\t%\"q\u001f\u0005\u000b\u0005\u001f\u0011\u00190!AA\u0002\t\u001dqA\u0003B~\u0003{\n\t\u0011#\u0001\u0003~\u0006\u0001RI\\:f[\ndWMT8eK\u0012\u000bG/\u0019\t\u0005\u0003c\u0013yP\u0002\u0006\u0003\u0012\u0006u\u0014\u0011!E\u0001\u0007\u0003\u0019RAa@\u0004\u0004U\u0001\"Ba\u0014\u0004\u0006\u0005\u001d#1\u0015Bb\u0013\u0011\u00199A!\u0015\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007C\u0004Y\u0005\u007f$\taa\u0003\u0015\u0005\tu\bBCA\u0015\u0005\u007f\f\t\u0011\"\u0012\u0003:!Q!\u0011\rB\u0000\u0003\u0003%\ti!\u0005\u0015\r\t\r71CB\u000b\u0011!\u00119ja\u0004A\u0002\u0005\u001d\u0003\u0002\u0003BP\u0007\u001f\u0001\rAa)\t\u0015\t=$q`A\u0001\n\u0003\u001bI\u0002\u0006\u0003\u0004\u001c\r\r\u0002#\u0002\t\u0003v\ru\u0001c\u0002\t\u0004 \u0005\u001d#1U\u0005\u0004\u0007C\t\"A\u0002+va2,'\u0007\u0003\u0006\u0003\u0002\u000e]\u0011\u0011!a\u0001\u0005\u0007D!B!\"\u0003\u0000\u0006\u0005I\u0011\u0002BD\u0011!\u0019I#! \u0005\u0002\r-\u0012\u0001B:bm\u0016$\"b!\f\u00044\r}21IB#!\r\u00012qF\u0005\u0004\u0007c\t\"\u0001B+oSRD\u0001b!\u000e\u0004(\u0001\u00071qG\u0001\u0003g\u000e\u0004Ba!\u000f\u0004<5\t\u0001\"C\u0002\u0004>!\u0011Ab\u00159be.\u001cuN\u001c;fqRD\u0001b!\u0011\u0004(\u0001\u0007\u0011QF\u0001\u0005a\u0006$\b\u000e\u0003\u0004\u0004\u0007O\u0001\rA\u0017\u0005\t\u0007\u000f\u001a9\u00031\u0001\u0002.\u0005I1\r\\1tg:\u000bW.\u001a\u0005\t\u0007\u0017\ni\b\"\u0001\u0004N\u0005a!/Z1e\u001b\u0016$\u0018\rZ1uCR!\u0011qVB(\u0011!\u0019\tf!\u0013A\u0002\rM\u0013\u0001C7fi\u0006$\u0017\r^1\u0011\t\rU31\r\b\u0005\u0007/\u001aiFD\u0002$\u00073J1aa\u0017\r\u0003\u0019Q7o\u001c85g&!1qLB1\u0003\u001d\u0001\u0018mY6bO\u0016T1aa\u0017\r\u0013\u0011\u0019)ga\u001a\u0003\r)3\u0016\r\\;f\u0015\u0011\u0019yf!\u0019\t\u0011\r-\u0014Q\u0010C\u0001\u0007[\n\u0011\u0002\\8bIR\u0013X-Z:\u0015\u000fe\u001ayg!\u001d\u0004t!A1QGB5\u0001\u0004\u00199\u0004\u0003\u0005\u0004B\r%\u0004\u0019AA\u0017\u0011!\tij!\u001bA\u0002\u00055\u0002B\u0003BC\u0003C\n\t\u0011\"\u0003\u0003\b\u0002")
public class TreeEnsembleModel
implements Serializable {
    private final Enumeration.Value algo;
    private final DecisionTreeModel[] trees;
    private final double[] treeWeights;
    private final Enumeration.Value combiningStrategy;
    private final double sumWeights;

    public static void initializeLogIfNecessary(boolean bl) {
        TreeEnsembleModel$.MODULE$.initializeLogIfNecessary(bl);
    }

    public static boolean isTraceEnabled() {
        return TreeEnsembleModel$.MODULE$.isTraceEnabled();
    }

    public static void logError(Function0<String> function0, Throwable throwable) {
        TreeEnsembleModel$.MODULE$.logError(function0, throwable);
    }

    public static void logWarning(Function0<String> function0, Throwable throwable) {
        TreeEnsembleModel$.MODULE$.logWarning(function0, throwable);
    }

    public static void logTrace(Function0<String> function0, Throwable throwable) {
        TreeEnsembleModel$.MODULE$.logTrace(function0, throwable);
    }

    public static void logDebug(Function0<String> function0, Throwable throwable) {
        TreeEnsembleModel$.MODULE$.logDebug(function0, throwable);
    }

    public static void logInfo(Function0<String> function0, Throwable throwable) {
        TreeEnsembleModel$.MODULE$.logInfo(function0, throwable);
    }

    public static void logError(Function0<String> function0) {
        TreeEnsembleModel$.MODULE$.logError(function0);
    }

    public static void logWarning(Function0<String> function0) {
        TreeEnsembleModel$.MODULE$.logWarning(function0);
    }

    public static void logTrace(Function0<String> function0) {
        TreeEnsembleModel$.MODULE$.logTrace(function0);
    }

    public static void logDebug(Function0<String> function0) {
        TreeEnsembleModel$.MODULE$.logDebug(function0);
    }

    public static void logInfo(Function0<String> function0) {
        TreeEnsembleModel$.MODULE$.logInfo(function0);
    }

    public static Logger log() {
        return TreeEnsembleModel$.MODULE$.log();
    }

    public static String logName() {
        return TreeEnsembleModel$.MODULE$.logName();
    }

    public Enumeration.Value algo() {
        return this.algo;
    }

    public DecisionTreeModel[] trees() {
        return this.trees;
    }

    public double[] treeWeights() {
        return this.treeWeights;
    }

    public Enumeration.Value combiningStrategy() {
        return this.combiningStrategy;
    }

    private double sumWeights() {
        return this.sumWeights;
    }

    private double predictBySumming(Vector features) {
        double[] treePredictions = (double[])Predef$.MODULE$.refArrayOps((Object[])this.trees()).map((Function1)new Serializable(this, features){
            public static final long serialVersionUID = 0L;
            private final Vector features$1;

            public final double apply(DecisionTreeModel x$9) {
                return x$9.predict(this.features$1);
            }
            {
                this.features$1 = features$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return BLAS.getInstance().ddot(this.numTrees(), treePredictions, 1, this.treeWeights(), 1);
    }

    private double predictByVoting(Vector features) {
        Map votes = Map$.MODULE$.empty();
        ((IterableLike)Predef$.MODULE$.refArrayOps((Object[])this.trees()).view().zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(this.treeWeights()), IndexedSeqView$.MODULE$.arrCanBuildFrom())).foreach((Function1)new Serializable(this, features, votes){
            public static final long serialVersionUID = 0L;
            private final Vector features$2;
            private final Map votes$1;

            public final void apply(Tuple2<DecisionTreeModel, Object> x0$2) {
                Tuple2<DecisionTreeModel, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    DecisionTreeModel tree = (DecisionTreeModel)tuple2._1();
                    double weight = tuple2._2$mcD$sp();
                    int prediction = (int)tree.predict(this.features$2);
                    this.votes$1.update((Object)BoxesRunTime.boxToInteger((int)prediction), (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)this.votes$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)prediction), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final double apply() {
                            return this.apply$mcD$sp();
                        }

                        public double apply$mcD$sp() {
                            return 0.0;
                        }
                    })) + weight)));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.features$2 = features$2;
                this.votes$1 = votes$1;
            }
        });
        return ((Tuple2)votes.maxBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> x$10) {
                return x$10._2$mcD$sp();
            }
        }, (Ordering)Ordering.Double$.MODULE$))._1$mcI$sp();
    }

    public double predict(Vector features) {
        block6: {
            double d;
            block3: {
                Tuple2 tuple2;
                block5: {
                    block4: {
                        block2: {
                            tuple2 = new Tuple2((Object)this.algo(), (Object)this.combiningStrategy());
                            if (tuple2 == null) break block2;
                            Enumeration.Value value = (Enumeration.Value)tuple2._1();
                            Enumeration.Value value2 = (Enumeration.Value)tuple2._2();
                            Enumeration.Value value3 = Algo$.MODULE$.Regression();
                            Enumeration.Value value4 = value;
                            if (value3 != null ? !value3.equals(value4) : value4 != null) break block2;
                            Enumeration.Value value5 = EnsembleCombiningStrategy$.MODULE$.Sum();
                            Enumeration.Value value6 = value2;
                            if (value5 != null ? !value5.equals(value6) : value6 != null) break block2;
                            d = this.predictBySumming(features);
                            break block3;
                        }
                        if (tuple2 == null) break block4;
                        Enumeration.Value value = (Enumeration.Value)tuple2._1();
                        Enumeration.Value value7 = (Enumeration.Value)tuple2._2();
                        Enumeration.Value value8 = Algo$.MODULE$.Regression();
                        Enumeration.Value value9 = value;
                        if (value8 != null ? !value8.equals(value9) : value9 != null) break block4;
                        Enumeration.Value value10 = EnsembleCombiningStrategy$.MODULE$.Average();
                        Enumeration.Value value11 = value7;
                        if (value10 != null ? !value10.equals(value11) : value11 != null) break block4;
                        d = this.predictBySumming(features) / this.sumWeights();
                        break block3;
                    }
                    if (tuple2 == null) break block5;
                    Enumeration.Value value = (Enumeration.Value)tuple2._1();
                    Enumeration.Value value12 = (Enumeration.Value)tuple2._2();
                    Enumeration.Value value13 = Algo$.MODULE$.Classification();
                    Enumeration.Value value14 = value;
                    if (value13 != null ? !value13.equals(value14) : value14 != null) break block5;
                    Enumeration.Value value15 = EnsembleCombiningStrategy$.MODULE$.Sum();
                    Enumeration.Value value16 = value12;
                    if (value15 != null ? !value15.equals(value16) : value16 != null) break block5;
                    double prediction = this.predictBySumming(features);
                    d = prediction > 0.0 ? 1.0 : 0.0;
                    break block3;
                }
                if (tuple2 == null) break block6;
                Enumeration.Value value = (Enumeration.Value)tuple2._1();
                Enumeration.Value value17 = (Enumeration.Value)tuple2._2();
                Enumeration.Value value18 = Algo$.MODULE$.Classification();
                Enumeration.Value value19 = value;
                if (value18 != null ? !value18.equals(value19) : value19 != null) break block6;
                Enumeration.Value value20 = EnsembleCombiningStrategy$.MODULE$.Vote();
                Enumeration.Value value21 = value17;
                if (value20 != null ? !value20.equals(value21) : value21 != null) break block6;
                d = this.predictByVoting(features);
            }
            return d;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"TreeEnsembleModel given unsupported (algo, combiningStrategy) combination: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ", ", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.algo(), this.combiningStrategy()}))).toString());
    }

    public RDD<Object> predict(RDD<Vector> features) {
        return features.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TreeEnsembleModel $outer;

            public final double apply(Vector x) {
                return this.$outer.predict(x);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.Double());
    }

    public JavaRDD<Double> predict(JavaRDD<Vector> features) {
        return this.predict((RDD<Vector>)features.rdd()).toJavaRDD();
    }

    public String toString() {
        block4: {
            String string;
            block3: {
                Enumeration.Value value;
                block2: {
                    value = this.algo();
                    Enumeration.Value value2 = Algo$.MODULE$.Classification();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TreeEnsembleModel classifier with ", " trees\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numTrees())}));
                    break block3;
                }
                Enumeration.Value value4 = Algo$.MODULE$.Regression();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TreeEnsembleModel regressor with ", " trees\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numTrees())}));
            }
            return string;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TreeEnsembleModel given unknown algo parameter: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.algo()})));
    }

    public String toDebugString() {
        String header = new StringBuilder().append((Object)this.toString()).append((Object)"\n").toString();
        return new StringBuilder().append((Object)header).append(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.trees()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<DecisionTreeModel, Object> x0$3) {
                Tuple2<DecisionTreeModel, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    DecisionTreeModel tree = (DecisionTreeModel)tuple2._1();
                    int treeIndex = tuple2._2$mcI$sp();
                    String string = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  Tree ", ":\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)treeIndex)}))).append((Object)tree.topNode().subtreeToString(4)).toString();
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).fold((Object)"", (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$11, String x$12) {
                return new StringBuilder().append((Object)x$11).append((Object)x$12).toString();
            }
        })).toString();
    }

    public int numTrees() {
        return this.trees().length;
    }

    public int totalNumNodes() {
        return BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])this.trees()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(DecisionTreeModel x$13) {
                return x$13.numNodes();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public TreeEnsembleModel(Enumeration.Value algo, DecisionTreeModel[] trees, double[] treeWeights, Enumeration.Value combiningStrategy) {
        this.algo = algo;
        this.trees = trees;
        this.treeWeights = treeWeights;
        this.combiningStrategy = combiningStrategy;
        Predef$.MODULE$.require(this.numTrees() > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "TreeEnsembleModel cannot be created without trees.";
            }
        });
        this.sumWeights = package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(treeWeights).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)), 1.0E-15);
    }
}

