/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.IOException;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NominalAttribute$;
import org.apache.spark.ml.feature.Bucketizer;
import org.apache.spark.ml.feature.QuantileDiscretizer$;
import org.apache.spark.ml.feature.QuantileDiscretizerBase;
import org.apache.spark.ml.feature.QuantileDiscretizerBase$class;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasInputCol$class;
import org.apache.spark.ml.param.shared.HasOutputCol$class;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.DefaultParamsWritable$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble;

@ScalaSignature(bytes="\u0006\u0001\u0005\re\u0001B\u0001\u0003\u00055\u00111#U;b]RLG.\u001a#jg\u000e\u0014X\r^5{KJT!a\u0001\u0003\u0002\u000f\u0019,\u0017\r^;sK*\u0011QAB\u0001\u0003[2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001aBF\r\u0011\u0007=\u0001\"#D\u0001\u0005\u0013\t\tBAA\u0005FgRLW.\u0019;peB\u00111\u0003F\u0007\u0002\u0005%\u0011QC\u0001\u0002\u000b\u0005V\u001c7.\u001a;ju\u0016\u0014\bCA\n\u0018\u0013\tA\"AA\fRk\u0006tG/\u001b7f\t&\u001c8M]3uSj,'OQ1tKB\u0011!$H\u0007\u00027)\u0011A\u0004B\u0001\u0005kRLG.\u0003\u0002\u001f7\t)B)\u001a4bk2$\b+\u0019:b[N<&/\u001b;bE2,\u0007\u0002\u0003\u0011\u0001\u0005\u000b\u0007I\u0011I\u0011\u0002\u0007ULG-F\u0001#!\t\u0019\u0013F\u0004\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tAS%\u0001\u0004Qe\u0016$WMZ\u0005\u0003U-\u0012aa\u0015;sS:<'B\u0001\u0015&Q\ryRf\r\t\u0003]Ej\u0011a\f\u0006\u0003a\u0019\t!\"\u00198o_R\fG/[8o\u0013\t\u0011tFA\u0003TS:\u001cW-I\u00015\u0003\u0015\tdF\u000e\u00181\u0011!1\u0004A!A!\u0002\u0013\u0011\u0013\u0001B;jI\u0002B3!N\u00174\u0011\u0015I\u0004\u0001\"\u0001;\u0003\u0019a\u0014N\\5u}Q\u00111\b\u0010\t\u0003'\u0001AQ\u0001\t\u001dA\u0002\tB3\u0001P\u00174Q\rATf\r\u0005\u0006s\u0001!\t\u0001\u0011\u000b\u0002w!\u001aq(L\u001a\t\u000b\r\u0003A\u0011\u0001#\u0002!M,GOU3mCRLg/Z#se>\u0014HCA#G\u001b\u0005\u0001\u0001\"B$C\u0001\u0004A\u0015!\u0002<bYV,\u0007C\u0001\u0013J\u0013\tQUE\u0001\u0004E_V\u0014G.\u001a\u0015\u0004\u00056b\u0015%A'\u0002\u000bIr\u0003G\f\u0019\t\u000b=\u0003A\u0011\u0001)\u0002\u001bM,GOT;n\u0005V\u001c7.\u001a;t)\t)\u0015\u000bC\u0003H\u001d\u0002\u0007!\u000b\u0005\u0002%'&\u0011A+\n\u0002\u0004\u0013:$\bf\u0001(.g!)q\u000b\u0001C\u00011\u0006Y1/\u001a;J]B,HoQ8m)\t)\u0015\fC\u0003H-\u0002\u0007!\u0005K\u0002W[MBQ\u0001\u0018\u0001\u0005\u0002u\u000bAb]3u\u001fV$\b/\u001e;D_2$\"!\u00120\t\u000b\u001d[\u0006\u0019\u0001\u0012)\u0007mk3\u0007C\u0003b\u0001\u0011\u0005!-\u0001\ttKRD\u0015M\u001c3mK&sg/\u00197jIR\u0011Qi\u0019\u0005\u0006\u000f\u0002\u0004\rA\t\u0015\u0004A6*\u0017%\u00014\u0002\u000bIr\u0013G\f\u0019\t\u000b!\u0004A\u0011I5\u0002\u001fQ\u0014\u0018M\\:g_Jl7k\u00195f[\u0006$\"A\u001b:\u0011\u0005-\u0004X\"\u00017\u000b\u00055t\u0017!\u0002;za\u0016\u001c(BA8\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0003c2\u0014!b\u0015;sk\u000e$H+\u001f9f\u0011\u0015\u0019x\r1\u0001k\u0003\u0019\u00198\r[3nC\"\u001aq-L\u001a\t\u000bY\u0004A\u0011I<\u0002\u0007\u0019LG\u000f\u0006\u0002\u0013q\")\u00110\u001ea\u0001u\u00069A-\u0019;bg\u0016$\bgA>\u0002\u0004A\u0019A0`@\u000e\u00039L!A 8\u0003\u000f\u0011\u000bG/Y:fiB!\u0011\u0011AA\u0002\u0019\u0001!1\"!\u0002y\u0003\u0003\u0005\tQ!\u0001\u0002\b\t\u0019q\fJ\u0019\u0012\t\u0005%\u0011q\u0002\t\u0004I\u0005-\u0011bAA\u0007K\t9aj\u001c;iS:<\u0007c\u0001\u0013\u0002\u0012%\u0019\u00111C\u0013\u0003\u0007\u0005s\u0017\u0010K\u0002v[1Cq!!\u0007\u0001\t\u0003\nY\"\u0001\u0003d_BLHcA\u001e\u0002\u001e!A\u0011qDA\f\u0001\u0004\t\t#A\u0003fqR\u0014\u0018\r\u0005\u0003\u0002$\u0005%RBAA\u0013\u0015\r\t9\u0003B\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0005\u0003W\t)C\u0001\u0005QCJ\fW.T1qQ\u0011\t9\"L\u001a)\u0007\u0001i3gB\u0004\u00024\tA\t!!\u000e\u0002'E+\u0018M\u001c;jY\u0016$\u0015n]2sKRL'0\u001a:\u0011\u0007M\t9D\u0002\u0004\u0002\u0005!\u0005\u0011\u0011H\n\u000b\u0003o\tY$!\u0011\u0002H\u0005M\u0003c\u0001\u0013\u0002>%\u0019\u0011qH\u0013\u0003\r\u0005s\u0017PU3g!\u0011Q\u00121I\u001e\n\u0007\u0005\u00153DA\u000bEK\u001a\fW\u000f\u001c;QCJ\fWn\u001d*fC\u0012\f'\r\\3\u0011\t\u0005%\u0013qJ\u0007\u0003\u0003\u0017R1!!\u0014\u0007\u0003!Ig\u000e^3s]\u0006d\u0017\u0002BA)\u0003\u0017\u0012q\u0001T8hO&tw\rE\u0002%\u0003+J1!a\u0016&\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u001dI\u0014q\u0007C\u0001\u00037\"\"!!\u000e\t\u0011\u0005}\u0013q\u0007C!\u0003C\nA\u0001\\8bIR\u00191(a\u0019\t\u000f\u0005\u0015\u0014Q\fa\u0001E\u0005!\u0001/\u0019;iQ\u0011\ti&L\u001a\t\u0015\u0005-\u0014qGA\u0001\n\u0013\ti'A\u0006sK\u0006$'+Z:pYZ,GCAA8!\u0011\t\t(a\u001f\u000e\u0005\u0005M$\u0002BA;\u0003o\nA\u0001\\1oO*\u0011\u0011\u0011P\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002~\u0005M$AB(cU\u0016\u001cG\u000f\u000b\u0003\u000285\u001a\u0004\u0006BA\u0019[M\u0002")
public final class QuantileDiscretizer
extends Estimator<Bucketizer>
implements QuantileDiscretizerBase,
DefaultParamsWritable {
    private final String uid;
    private final IntParam numBuckets;
    private final DoubleParam relativeError;
    private final Param<String> handleInvalid;
    private final Param<String> outputCol;
    private final Param<String> inputCol;

    public static MLReader<QuantileDiscretizer> read() {
        return QuantileDiscretizer$.MODULE$.read();
    }

    public static QuantileDiscretizer load(String string) {
        return QuantileDiscretizer$.MODULE$.load(string);
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable$class.write(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public IntParam numBuckets() {
        return this.numBuckets;
    }

    @Override
    public DoubleParam relativeError() {
        return this.relativeError;
    }

    @Override
    public Param<String> handleInvalid() {
        return this.handleInvalid;
    }

    @Override
    public void org$apache$spark$ml$feature$QuantileDiscretizerBase$_setter_$numBuckets_$eq(IntParam x$1) {
        this.numBuckets = x$1;
    }

    @Override
    public void org$apache$spark$ml$feature$QuantileDiscretizerBase$_setter_$relativeError_$eq(DoubleParam x$1) {
        this.relativeError = x$1;
    }

    @Override
    public void org$apache$spark$ml$feature$QuantileDiscretizerBase$_setter_$handleInvalid_$eq(Param x$1) {
        this.handleInvalid = x$1;
    }

    @Override
    public int getNumBuckets() {
        return QuantileDiscretizerBase$class.getNumBuckets(this);
    }

    @Override
    public double getRelativeError() {
        return QuantileDiscretizerBase$class.getRelativeError(this);
    }

    @Override
    public String getHandleInvalid() {
        return QuantileDiscretizerBase$class.getHandleInvalid(this);
    }

    @Override
    public final Param<String> outputCol() {
        return this.outputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param x$1) {
        this.outputCol = x$1;
    }

    @Override
    public final String getOutputCol() {
        return HasOutputCol$class.getOutputCol(this);
    }

    @Override
    public final Param<String> inputCol() {
        return this.inputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param x$1) {
        this.inputCol = x$1;
    }

    @Override
    public final String getInputCol() {
        return HasInputCol$class.getInputCol(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public QuantileDiscretizer setRelativeError(double value) {
        return (QuantileDiscretizer)this.set(this.relativeError(), BoxesRunTime.boxToDouble((double)value));
    }

    public QuantileDiscretizer setNumBuckets(int value) {
        return (QuantileDiscretizer)this.set(this.numBuckets(), BoxesRunTime.boxToInteger((int)value));
    }

    public QuantileDiscretizer setInputCol(String value) {
        return (QuantileDiscretizer)this.set(this.inputCol(), value);
    }

    public QuantileDiscretizer setOutputCol(String value) {
        return (QuantileDiscretizer)this.set(this.outputCol(), value);
    }

    public QuantileDiscretizer setHandleInvalid(String value) {
        return (QuantileDiscretizer)this.set(this.handleInvalid(), value);
    }

    @Override
    public StructType transformSchema(StructType schema) {
        SchemaUtils$.MODULE$.checkNumericType(schema, this.$(this.inputCol()), SchemaUtils$.MODULE$.checkNumericType$default$3());
        StructField[] inputFields = schema.fields();
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])inputFields).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QuantileDiscretizer $outer;

            public final boolean apply(StructField x$1) {
                String string = x$1.name();
                String string2 = this.$outer.$(this.$outer.outputCol());
                return string != null ? !string.equals(string2) : string2 != null;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QuantileDiscretizer $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Output column ", " already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.$(this.$outer.outputCol())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        NominalAttribute attr = NominalAttribute$.MODULE$.defaultAttr().withName(this.$(this.outputCol()));
        StructField[] outputFields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])inputFields).$colon$plus((Object)attr.toStructField(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        return new StructType(outputFields);
    }

    @Override
    public Bucketizer fit(Dataset<?> dataset) {
        this.transformSchema(dataset.schema(), true);
        double[] splits = dataset.stat().approxQuantile(this.$(this.inputCol()), (double[])((TraversableOnce)new RichDouble(Predef$.MODULE$.doubleWrapper(0.0)).to((Object)BoxesRunTime.boxToDouble((double)1.0)).by((Object)BoxesRunTime.boxToDouble((double)(1.0 / (double)BoxesRunTime.unboxToInt((Object)this.$(this.numBuckets())))))).toArray(ClassTag$.MODULE$.Double()), BoxesRunTime.unboxToDouble((Object)this.$(this.relativeError())));
        splits[0] = Double.NEGATIVE_INFINITY;
        splits[splits.length - 1] = Double.POSITIVE_INFINITY;
        double[] distinctSplits = (double[])Predef$.MODULE$.doubleArrayOps(splits).distinct();
        if (splits.length != distinctSplits.length) {
            this.log().warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Some quantiles were identical. Bucketing to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(distinctSplits.length - 1))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" buckets as a result."})).s((Seq)Nil$.MODULE$)).toString());
        }
        Bucketizer bucketizer = new Bucketizer(this.uid()).setSplits((double[])Predef$.MODULE$.doubleArrayOps(distinctSplits).sorted((Ordering)Ordering.Double$.MODULE$)).setHandleInvalid(this.$(this.handleInvalid()));
        return this.copyValues(bucketizer.setParent(this), this.copyValues$default$2());
    }

    @Override
    public QuantileDiscretizer copy(ParamMap extra) {
        return (QuantileDiscretizer)this.defaultCopy(extra);
    }

    public QuantileDiscretizer(String uid) {
        this.uid = uid;
        HasInputCol$class.$init$(this);
        HasOutputCol$class.$init$(this);
        QuantileDiscretizerBase$class.$init$(this);
        MLWritable$class.$init$(this);
        DefaultParamsWritable$class.$init$(this);
    }

    public QuantileDiscretizer() {
        this(Identifiable$.MODULE$.randomUID("quantileDiscretizer"));
    }
}

